/*
  xqbiff  -- "biff" program for qmail.
  Copyright (C) 1998-2003 Yusuke Ishizawa <yu-i@wmail.plala.or.jp>

  This program is free software; you can redistribute it and/or modify it
  under the terms of the GNU General Public License as published by the
  Free Software Foundation; either version 2, or (at your option) any
  later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/
/*
 * ifile.c
 *
 * ե­ؿ
 *
 */

#include<unistd.h>
#include<dirent.h>
#include"ifile.h"


/* ե뤫ʬ'\n' ޤ EOF ޤǡˤɤ߹           */
/*  size ۤʬ˴                             */
/* ǸβʸϥХåե˳Ǽʤ                         */
/* ŪХåեϻʤΤ, s  NULL ꤷƤϤʤ     */
/* ͤ, ˴줿ʬޤ, ե뤫ɤ߹Хȿ */
int fgetline(char *s, int size, FILE *fp)
{
    char c;
    int cnt=0;

    if( s!=NULL && size>0 && fp!=NULL ){

	for(;;){
	    c = fgetc(fp);

	    if( c==EOF ){
		s[cnt] = '\0';
		cnt=-1;
		break;
	    } else if( c=='\n' ){
		s[cnt++] = '\0';
		break;
	    }
	    s[cnt++] = c;

	    if( cnt == size-1 ){
		s[cnt] = '\0';
		while( EOF != (c=fgetc(fp)) && c!='\n' ) cnt++;
		break;
	    }
	}
    }

    return cnt;
}


/* defname, name Υ 1024 Ǥ뤳 */
BOOL iFilenameCreate( char defname[], char name[] )
{
    char *sp;

    sp = strchr( defname, '/' );
    if( sp == NULL ){
	strcpy( name, defname );
    } else {
	strcpy( name,sp+1 );
    }

    return TRUE;
}


/* defname, name Υ 1024 Ǥ뤳 */
BOOL iFilefullnameCreate( char defname[], char name[] )
{
    int i;
    char home[1024], pwd[1024], temp[1024], *dnp;


    /* Хѥ̾ʤ,Τޤޥԡ */
    if( defname[0] == '/' ){
	strcpy( name, defname );

    } else {

	dnp = &(defname[0]);

	if( dnp[0] == '~' ){

	    /* ۡǥ쥯ȥ̾ */
	    strcpy( home, getenv("HOME") );

	    /* '~' */
	    if( dnp[1] == '/' ){
		dnp += 2;
		sprintf( temp, "%s/%s", home, dnp );
	    } else {
		if( 0 != (i = iStrrcIdx( home, '/' )) ){
		    home[i] = '\0';
		}
		dnp++;
		sprintf( temp, "%s/%s", home, dnp );
	    }
	    strcpy( name, temp );

	} else {

	    /* Хѥ̾ʤ,䴰 */

	    /* ȥǥ쥯ȥ̾ */
	    if(  NULL == getcwd( pwd, 1024 ) ){
		fprintf( stderr, "Cannot get current directory.\n" );
		return FALSE;
	    }

	    for(;;){
		if( dnp[0] == '.' && dnp[1] == '/' ){
		    dnp += 2;
		} else if( dnp[0] == '.' && dnp[1] == '.' 
			   && dnp[2] == '/' ){
		    dnp += 3;
		    pwd[iStrrcIdx(pwd,'/')] = '\0';
		} else {

		    strcpy( temp, pwd );
		    strcat( temp, "/" );
		    strcat( temp, dnp );
		    strcpy( name, temp );
		    break;
		}
	    }
	}
    }

    return TRUE;
}


int iAccess( char path[], int mode )
{
    DIR *dp = NULL;
    int i;

    for( i=0 ; i<6 ; i++ ){
	if( ((mode >> i) & 0x0001) == 1 ){
	    switch( i ){
	    case 0:
		/* ե¸ߤΥå */
		if( -1 == access( path, F_OK ) ){
		    return -1;
		} else if( NULL != (dp = opendir( path ) ) ){
		    closedir( dp );
		    return -1;
		}
		break;
	    case 1:
		/* ¹Ը¤Υå */
		if( -1 == access( path, X_OK ) )
		    return -1;
		break;
	    case 2:
		/* 񤭹߸¤Υå */
		if( -1 == access( path, W_OK ) )
		    return -1;
		break;
	    case 3:
		/* ɤ߹߸¤Υå */
		if( -1 == access( path, R_OK ) )
		    return -1;
		break;
	    case 4:
		/* ǥ쥯ȥ¸ߤΥå */
		if( NULL == (dp = opendir( path ) ) ){
		    return -1;
		} else{
		    closedir( dp );
		}
		break;
	    case 5:
		/* ѥʥե,ǥ쥯ȥˤΥå */
		if( -1 == access( path, F_OK ) )
		    return -1;
		break;
	    default:
		break;
	    }
	}
    }

    return 0;
}

