/* -*-mode: C; style: K&R; c-basic-offset: 4 ; -*- */

/*
 *  xreverse.h - Prototypes.
 *
 *  XReverse  - A simple reversi type game.
 *
 * Homepage:
 *   http://www.steve.org.uk/Software/
 *
 * Author:
 *  Steve Kemp <steve@steve.org.uk>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 *
 *  Steve Kemp
 *  ---
 *
 */


#ifndef _XREVERSE_H_
#define _XREVERSE_H_ 1


/*
 * An empty position on the board.
 */
#define EMPTY 0

/*
 * A square occupied by a black piece.
 */
#define BLACK 1


/*
 * A square occupied by a white piece.
 */
#define WHITE 2


/*
 * Holds the state of the board.
 */
int g_board[8][8] = {
  { 0,0,0,0,0,0,0,0 }, 
  { 0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0 }
};



/*
 * Holds the previous state of the board - used for undo.
 */
int g_backupBoard[8][8] = {
  { 0,0,0,0,0,0,0,0 }, 
  { 0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0 }
};


/*
 * The last move made by white.
 */
int white_x_last = -1;
int white_y_last = -1;

/*
 * This structure is used to store potential moves by the computer player.
 */
struct sMove
{
    /* Coords of the move. */
    int x;
    int y;

    /*
     *  The score of the resultent move - this is a fitness score, not
     * just the score which would be gained by making the move.
     */
    int score; 
};



/*
 * This is the holder for the text which is displayed at the bottom
 * of the game board.
 */
char g_statusMsg[1024];


/* Create the main window. */
void createMainWindow();

/* Iniailize the graphics context. */
GC create_gc(Display* display, Window win, int reverse_video);

/* Initialize board for a new game. */
void initBoard();

/* Count all the tiles on the board of a given colour */
int countColour( int color );

/* Count all the black tiles */
int countBlack();

/* Count all the white tiles */
int countWhite();

/* Count all the empty tiles */
int countEmpty();

/* Draw the board, and the tiles. */
void drawBoard();

/* Draw the places upon the board where the given player could move. */
int drawHints( int player, int testOnly );

/* Set the text displayed in the status area. */
void setStatus( char *text );

/* Is the game over? */
int isGameOver();

/* Game over - show the winner, etc. */
void gameOver();

/* Check the number of pieces which would be captured in a given direction */
int check_direction(int player, int x, int y, int bx, int by);

/* Flip the tiles in the given direction. */
void turn_direction(int player, int x, int y, int bx, int by);

/* Flip all the bricks after the given player makes the given move. */
void turn_bricks(int player, int x, int y);

/* Make a move for the given player. */
void make_move(int player, int x, int y);

/* Undo the last human move. */
void undo_move();

/* Will the given players move capture at least one piece? */
int will_capture(int player, int x, int y);

/* Is the given players move legal? */
int legal_move(int player, int x, int y);

/*
 *  Generate all the moves the given player could make, and determine
 * their fitness.
 */
struct sMove* generateMoves( int player );

/* 
 *  Computer players move function - analyse generated moves, and make
 * the one with the highest fitness.
 */
void performComputerMove( );


#endif /* _XREVERSE_H_ */
