// file      : xsde/cxx/serializer/elements.ixx
// author    : Boris Kolpackov <boris@codesynthesis.com>
// copyright : Copyright (c) 2005-2007 Code Synthesis Tools CC
// license   : GNU GPL v2 + exceptions; see accompanying LICENSE file

namespace xsde
{
  namespace cxx
  {
    namespace serializer
    {
      inline serializer_base::
      serializer_base ()
          : context_ (0), depth_ (0)
      {
#ifndef XSDE_EXCEPTIONS
        error_type_ = error_none;
#endif
      }

      inline context& serializer_base::
      _context ()
      {
        return *context_;
      }

#ifdef XSDE_EXCEPTIONS
      inline void serializer_base::
      _start_element (const char* name)
      {
        context_->start_element (name);
      }

      inline void serializer_base::
      _start_element (const char* ns, const char* name)
      {
        context_->start_element (ns, name);
      }

      inline void serializer_base::
      _end_element ()
      {
        context_->end_element ();
      }

      inline void serializer_base::
      _start_attribute (const char* name)
      {
        context_->start_attribute (name);
      }

      inline void serializer_base::
      _start_attribute (const char* ns, const char* name)
      {
        context_->start_attribute (ns, name);
      }

      inline void serializer_base::
      _end_attribute ()
      {
        context_->end_attribute ();
      }

      inline void serializer_base::
      _attribute (const char* name, const char* value)
      {
        context_->attribute (name, value);
      }

      inline void serializer_base::
      _attribute (const char* ns, const char* name, const char* value)
      {
        context_->attribute (ns, name, value);
      }

      inline void serializer_base::
      _characters (const char* s)
      {
        context_->characters (s);
      }

      inline void serializer_base::
      _characters (const char* s, size_t n)
      {
        context_->characters (s, n);
      }

      inline void serializer_base::
      _declare_namespace (const char* ns, const char* p)
      {
        context_->declare_namespace (ns, p);
      }

      inline void serializer_base::
      _declare_default_namespace (const char* ns)
      {
        context_->declare_default_namespace (ns);
      }

      inline void serializer_base::
      _clear_default_namespace ()
      {
        context_->clear_default_namespace ();
      }

#else // XSDE_EXCEPTIONS

      inline bool serializer_base::
      _start_element (const char* name)
      {
        return context_->start_element (name);
      }

      inline bool serializer_base::
      _start_element (const char* ns, const char* name)
      {
        return context_->start_element (ns, name);
      }

      inline bool serializer_base::
      _end_element ()
      {
        return context_->end_element ();
      }

      inline bool serializer_base::
      _start_attribute (const char* name)
      {
        return context_->start_attribute (name);
      }

      inline bool serializer_base::
      _start_attribute (const char* ns, const char* name)
      {
        return context_->start_attribute (ns, name);
      }

      inline bool serializer_base::
      _end_attribute ()
      {
        return context_->end_attribute ();
      }

      inline bool serializer_base::
      _attribute (const char* name, const char* value)
      {
        return context_->attribute (name, value);
      }

      inline bool serializer_base::
      _attribute (const char* ns, const char* name, const char* value)
      {
        return context_->attribute (ns, name, value);
      }

      inline bool serializer_base::
      _characters (const char* s)
      {
        return context_->characters (s);
      }

      inline bool serializer_base::
      _characters (const char* s, size_t n)
      {
        return context_->characters (s, n);
      }

      inline bool serializer_base::
      _declare_namespace (const char* ns, const char* p)
      {
        return context_->declare_namespace (ns, p);
      }

      inline bool serializer_base::
      _declare_default_namespace (const char* ns)
      {
        return context_->declare_default_namespace (ns);
      }

      inline bool serializer_base::
      _clear_default_namespace ()
      {
        return context_->clear_default_namespace ();
      }
#endif // !XSDE_EXCEPTIONS

      // Error handling.
      //
#ifndef XSDE_EXCEPTIONS
      inline serializer::error serializer_base::
      _error () const
      {
        switch (error_type_)
        {
        case error_sys:
          {
            return serializer::error (error_code_.sys);
          }
        case error_app:
          {
            return serializer::error (error_code_.app);
          }
        default:
          {
            return serializer::error ();
          }
        }
      }

      inline void serializer_base::
      _app_error (int e)
      {
        if (context_ != 0)
        {
          context_->app_error (e);
        }
        else
        {
          error_type_ = error_app;
          error_code_.app = e;
        }
      }

      inline int serializer_base::
      _app_error () const
      {
        return error_code_.app;
      }

      inline context::sys_error_t serializer_base::
      _sys_error () const
      {
        return error_code_.sys;
      }

      inline void serializer_base::
      _sys_error (context::sys_error_t e)
      {
        if (context_ != 0)
        {
          context_->sys_error (e);
        }
        else
        {
          error_type_ = error_sys;
          error_code_.sys = e;
        }
      }

      inline void serializer_base::
      _xml_error (context::xml_error_t e)
      {
        context_->xml_error (e);
      }

      inline serializer_base::error_type_t serializer_base::
      _error_type () const
      {
        return error_type_;
      }
#endif // XSDE_EXCEPTIONS

#ifdef XSDE_VALIDATION_SERIALIZER
      inline void serializer_base::
      _schema_error (context::schema_error_t e)
      {
        context_->schema_error (e);
      }
#endif
    }
  }
}
