// file      : tests/cxx/serializer/union/driver.cxx
// author    : Boris Kolpackov <boris@codesynthesis.com>
// copyright : Copyright (c) 2006-2007 Code Synthesis Tools CC
// license   : GNU GPL v2 + exceptions; see accompanying LICENSE file

// Test union type serialization.
//

#include <iostream>

#include "test-sskel.hxx"

using namespace std;
using namespace test;

struct int_bool_union_simpl: virtual int_bool_union_sskel
{
  int_bool_union_simpl ()
      : n_ (0)
  {
  }

  virtual void
  _serialize_content ()
  {
    if (n_++ == 0)
      _characters ("123");
    else
      _characters ("false");
  }

private:
  int n_;
};

struct root_simpl: root_sskel
{
  virtual void
  pre ()
  {
    n_ = 0;
  }

  virtual bool
  int_bool_union_next ()
  {
    return n_++ < 2;
  }

private:
  int n_;
};

int
main (int argc, char* argv[])
{
  int_bool_union_simpl int_bool_union_s;
  root_simpl root_s;

  root_s.serializers (int_bool_union_s);

  xml_schema::document_simpl doc_s (root_s, "test", "root");

  root_s.pre ();
  doc_s.serialize (cout);
  root_s.post ();
}
