/*
 * Copyright © 2007 Daniel Stone
 * Copyright © 2007 Matthew Garrett
 * Copyright © 2007 Jerome Glisse
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, version 2.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * A copy of the General Public License is included with the source
 * distribution of this driver, as COPYING.
 *
 * Authors: Daniel Stone <daniel@fooishbar.org>
 *          Matthew Garrett <mjg59@srcf.ucam.org>
 *          Jerome Glisse <glisse@freedesktop.org>
 *
 * Portions based on the Radeon and VESA drivers.
 */
#ifdef HAVE_CONFIG_H
#include "config.h"
#endif
#include "avivo.h"

#ifdef PCIACCESS
const struct pci_id_match avivo_device_match[] = {
    {
        PCI_VENDOR_ATI, 0x7100, PCI_MATCH_ANY, PCI_MATCH_ANY,
        0x00030000, 0x00ffffff, 0
    },
    {
        PCI_VENDOR_ATI, 0x7102, PCI_MATCH_ANY, PCI_MATCH_ANY,
        0x00030000, 0x00ffffff, 0
    },
    {
        PCI_VENDOR_ATI, 0x7103, PCI_MATCH_ANY, PCI_MATCH_ANY,
        0x00030000, 0x00ffffff, 0
    },
    {
        PCI_VENDOR_ATI, 0x7104, PCI_MATCH_ANY, PCI_MATCH_ANY,
        0x00030000, 0x00ffffff, 0
    },
    {
        PCI_VENDOR_ATI, 0x7105, PCI_MATCH_ANY, PCI_MATCH_ANY,
        0x00030000, 0x00ffffff, 0
    },
    {
        PCI_VENDOR_ATI, 0x7106, PCI_MATCH_ANY, PCI_MATCH_ANY,
        0x00030000, 0x00ffffff, 0
    },
    {
        PCI_VENDOR_ATI, 0x7108, PCI_MATCH_ANY, PCI_MATCH_ANY,
        0x00030000, 0x00ffffff, 0
    },
    {
        PCI_VENDOR_ATI, 0x7109, PCI_MATCH_ANY, PCI_MATCH_ANY,
        0x00030000, 0x00ffffff, 0
    },
    {
        PCI_VENDOR_ATI, 0x710A, PCI_MATCH_ANY, PCI_MATCH_ANY,
        0x00030000, 0x00ffffff, 0
    },
    {
        PCI_VENDOR_ATI, 0x710B, PCI_MATCH_ANY, PCI_MATCH_ANY,
        0x00030000, 0x00ffffff, 0
    },
    {
        PCI_VENDOR_ATI, 0x710C, PCI_MATCH_ANY, PCI_MATCH_ANY,
        0x00030000, 0x00ffffff, 0
    },
    {
        PCI_VENDOR_ATI, 0x7140, PCI_MATCH_ANY, PCI_MATCH_ANY,
        0x00030000, 0x00ffffff, 0
    },
    {
        PCI_VENDOR_ATI, 0x7142, PCI_MATCH_ANY, PCI_MATCH_ANY,
        0x00030000, 0x00ffffff, 0
    },
    {
        PCI_VENDOR_ATI, 0x7143, PCI_MATCH_ANY, PCI_MATCH_ANY,
        0x00030000, 0x00ffffff, 0
    },
    {
        PCI_VENDOR_ATI, 0x7145, PCI_MATCH_ANY, PCI_MATCH_ANY,
        0x00030000, 0x00ffffff, 0
    },
    {
        PCI_VENDOR_ATI, 0x7146, PCI_MATCH_ANY, PCI_MATCH_ANY,
        0x00030000, 0x00ffffff, 0
    },
    {
        PCI_VENDOR_ATI, 0x7147, PCI_MATCH_ANY, PCI_MATCH_ANY,
        0x00030000, 0x00ffffff, 0
    },
    {
        PCI_VENDOR_ATI, 0x7149, PCI_MATCH_ANY, PCI_MATCH_ANY,
        0x00030000, 0x00ffffff, 0
    },
    {
        PCI_VENDOR_ATI, 0x714A, PCI_MATCH_ANY, PCI_MATCH_ANY,
        0x00030000, 0x00ffffff, 0
    },
    {
        PCI_VENDOR_ATI, 0x714B, PCI_MATCH_ANY, PCI_MATCH_ANY,
        0x00030000, 0x00ffffff, 0
    },
    {
        PCI_VENDOR_ATI, 0x714C, PCI_MATCH_ANY, PCI_MATCH_ANY,
        0x00030000, 0x00ffffff, 0
    },
    {
        PCI_VENDOR_ATI, 0x714D, PCI_MATCH_ANY, PCI_MATCH_ANY,
        0x00030000, 0x00ffffff, 0
    },
    {
        PCI_VENDOR_ATI, 0x714E, PCI_MATCH_ANY, PCI_MATCH_ANY,
        0x00030000, 0x00ffffff, 0
    },
    {
        PCI_VENDOR_ATI, 0x7152, PCI_MATCH_ANY, PCI_MATCH_ANY,
        0x00030000, 0x00ffffff, 0
    },
    {
        PCI_VENDOR_ATI, 0x7153, PCI_MATCH_ANY, PCI_MATCH_ANY,
        0x00030000, 0x00ffffff, 0
    },
    {
        PCI_VENDOR_ATI, 0x715E, PCI_MATCH_ANY, PCI_MATCH_ANY,
        0x00030000, 0x00ffffff, 0
    },
    {
        PCI_VENDOR_ATI, 0x715F, PCI_MATCH_ANY, PCI_MATCH_ANY,
        0x00030000, 0x00ffffff, 0
    },
    {
        PCI_VENDOR_ATI, 0x7180, PCI_MATCH_ANY, PCI_MATCH_ANY,
        0x00030000, 0x00ffffff, 0
    },
    {
        PCI_VENDOR_ATI, 0x7181, PCI_MATCH_ANY, PCI_MATCH_ANY,
        0x00030000, 0x00ffffff, 0
    },
    {
        PCI_VENDOR_ATI, 0x7183, PCI_MATCH_ANY, PCI_MATCH_ANY,
        0x00030000, 0x00ffffff, 0
    },
    {
        PCI_VENDOR_ATI, 0x7187, PCI_MATCH_ANY, PCI_MATCH_ANY,
        0x00030000, 0x00ffffff, 0
    },
    {
        PCI_VENDOR_ATI, 0x7188, PCI_MATCH_ANY, PCI_MATCH_ANY,
        0x00030000, 0x00ffffff, 0
    },
    {
        PCI_VENDOR_ATI, 0x718A, PCI_MATCH_ANY, PCI_MATCH_ANY,
        0x00030000, 0x00ffffff, 0
    },
    {
        PCI_VENDOR_ATI, 0x718C, PCI_MATCH_ANY, PCI_MATCH_ANY,
        0x00030000, 0x00ffffff, 0
    },
    {
        PCI_VENDOR_ATI, 0x718D, PCI_MATCH_ANY, PCI_MATCH_ANY,
        0x00030000, 0x00ffffff, 0
    },
    {
        PCI_VENDOR_ATI, 0x7193, PCI_MATCH_ANY, PCI_MATCH_ANY,
        0x00030000, 0x00ffffff, 0
    },
    {
        PCI_VENDOR_ATI, 0x719F, PCI_MATCH_ANY, PCI_MATCH_ANY,
        0x00030000, 0x00ffffff, 0
    },
    {
        PCI_VENDOR_ATI, 0x71C0, PCI_MATCH_ANY, PCI_MATCH_ANY,
        0x00030000, 0x00ffffff, 0
    },
    {
        PCI_VENDOR_ATI, 0x71C2, PCI_MATCH_ANY, PCI_MATCH_ANY,
        0x00030000, 0x00ffffff, 0
    },
    {
        PCI_VENDOR_ATI, 0x71C4, PCI_MATCH_ANY, PCI_MATCH_ANY,
        0x00030000, 0x00ffffff, 0
    },
    {
        PCI_VENDOR_ATI, 0x71C5, PCI_MATCH_ANY, PCI_MATCH_ANY,
        0x00030000, 0x00ffffff, 0
    },
    {
        PCI_VENDOR_ATI, 0x71C6, PCI_MATCH_ANY, PCI_MATCH_ANY,
        0x00030000, 0x00ffffff, 0
    },
    {
        PCI_VENDOR_ATI, 0x71C7, PCI_MATCH_ANY, PCI_MATCH_ANY,
        0x00030000, 0x00ffffff, 0
    },
    {
        PCI_VENDOR_ATI, 0x71CE, PCI_MATCH_ANY, PCI_MATCH_ANY,
        0x00030000, 0x00ffffff, 0
    },
    {
        PCI_VENDOR_ATI, 0x71D4, PCI_MATCH_ANY, PCI_MATCH_ANY,
        0x00030000, 0x00ffffff, 0
    },
    {
        PCI_VENDOR_ATI, 0x71D5, PCI_MATCH_ANY, PCI_MATCH_ANY,
        0x00030000, 0x00ffffff, 0
    },
    {
        PCI_VENDOR_ATI, 0x71D6, PCI_MATCH_ANY, PCI_MATCH_ANY,
        0x00030000, 0x00ffffff, 0
    },
    {
        PCI_VENDOR_ATI, 0x71DE, PCI_MATCH_ANY, PCI_MATCH_ANY,
        0x00030000, 0x00ffffff, 0
    },
    {
        PCI_VENDOR_ATI, 0x71E7, PCI_MATCH_ANY, PCI_MATCH_ANY,
        0x00030000, 0x00ffffff, 0
    },
    {
        PCI_VENDOR_ATI, 0x7240, PCI_MATCH_ANY, PCI_MATCH_ANY,
        0x00030000, 0x00ffffff, 0
    },
    {
        PCI_VENDOR_ATI, 0x7241, PCI_MATCH_ANY, PCI_MATCH_ANY,
        0x00030000, 0x00ffffff, 0
    },
    {
        PCI_VENDOR_ATI, 0x7242, PCI_MATCH_ANY, PCI_MATCH_ANY,
        0x00030000, 0x00ffffff, 0
    },
    {
        PCI_VENDOR_ATI, 0x7243, PCI_MATCH_ANY, PCI_MATCH_ANY,
        0x00030000, 0x00ffffff, 0
    },
    {
        PCI_VENDOR_ATI, 0x7244, PCI_MATCH_ANY, PCI_MATCH_ANY,
        0x00030000, 0x00ffffff, 0
    },
    {
        PCI_VENDOR_ATI, 0x7245, PCI_MATCH_ANY, PCI_MATCH_ANY,
        0x00030000, 0x00ffffff, 0
    },
    {
        PCI_VENDOR_ATI, 0x7246, PCI_MATCH_ANY, PCI_MATCH_ANY,
        0x00030000, 0x00ffffff, 0
    },
    {
        PCI_VENDOR_ATI, 0x7247, PCI_MATCH_ANY, PCI_MATCH_ANY,
        0x00030000, 0x00ffffff, 0
    },
    {
        PCI_VENDOR_ATI, 0x7248, PCI_MATCH_ANY, PCI_MATCH_ANY,
        0x00030000, 0x00ffffff, 0
    },
    {
        PCI_VENDOR_ATI, 0x7249, PCI_MATCH_ANY, PCI_MATCH_ANY,
        0x00030000, 0x00ffffff, 0
    },
    {
        PCI_VENDOR_ATI, 0x724A, PCI_MATCH_ANY, PCI_MATCH_ANY,
        0x00030000, 0x00ffffff, 0
    },
    {
        PCI_VENDOR_ATI, 0x724B, PCI_MATCH_ANY, PCI_MATCH_ANY,
        0x00030000, 0x00ffffff, 0
    },
    {
        PCI_VENDOR_ATI, 0x724C, PCI_MATCH_ANY, PCI_MATCH_ANY,
        0x00030000, 0x00ffffff, 0
    },
    {
        PCI_VENDOR_ATI, 0x724D, PCI_MATCH_ANY, PCI_MATCH_ANY,
        0x00030000, 0x00ffffff, 0
    },
    {
        PCI_VENDOR_ATI, 0x726B, PCI_MATCH_ANY, PCI_MATCH_ANY,
        0x00030000, 0x00ffffff, 0
    },
    {
        PCI_VENDOR_ATI, 0x7280, PCI_MATCH_ANY, PCI_MATCH_ANY,
        0x00030000, 0x00ffffff, 0
    },
    {
        PCI_VENDOR_ATI, 0x7288, PCI_MATCH_ANY, PCI_MATCH_ANY,
        0x00030000, 0x00ffffff, 0
    },
    {
        PCI_VENDOR_ATI, 0x7291, PCI_MATCH_ANY, PCI_MATCH_ANY,
        0x00030000, 0x00ffffff, 0
    },
    {
        PCI_VENDOR_ATI, 0x7293, PCI_MATCH_ANY, PCI_MATCH_ANY,
        0x00030000, 0x00ffffff, 0
    },

    { 0, 0, 0 },
};
#endif

/* Supported chipsets.  I'm really, really glad that these are
 * separate, and the nomenclature is beyond reproach. */
SymTabRec avivo_chips[] = {
    { PCI_CHIP_R520_7100, "R520 (Radeon X1800)" },
    { PCI_CHIP_R520_M58_7102, "R520_M58 (Radeon Mobility X1800)" },
    { PCI_CHIP_R520_M58_7103, "R520_M58 (Mobility FireGL V7200)" },
    { PCI_CHIP_R520_7104, "R520 (FireGL V7200)" },
    { PCI_CHIP_R520_7105, "R520 (FireGL)" },
    { PCI_CHIP_R520_M58_7106, "R520_M58 (Mobility FireGL V7100)" },
    { PCI_CHIP_R520_M58_7108, "R520_M58 (Radeon Mobility X1800)" },
    { PCI_CHIP_R520_7109, "R520 (Radeon X1800)" },
    { PCI_CHIP_R520_710A, "R520 (Radeon X1800)" },
    { PCI_CHIP_R520_710B, "R520 (Radeon X1800)" },
    { PCI_CHIP_R520_710C, "R520 (Radeon X1800)" },
    { PCI_CHIP_RV515_7140, "RV515 (Radeon X1600)" },
    { PCI_CHIP_RV515_PRO_7142, "RV515_PRO (Radeon X1300/X1550)" },
    { PCI_CHIP_RV505_7143, "RV505 (Radeon X1550)" },
    { PCI_CHIP_RV515_7145, "RV515 (Radeon Mobility X1400)" },
    { PCI_CHIP_RV515_7146, "RV515 (Radeon X1300)" },
    { PCI_CHIP_RV505_7147, "RV505 (Radeon X1550 64-bit)" },
    { PCI_CHIP_RV515_M52_7149, "RV515_M52 (Mobility Radeon X1300)" },
    { PCI_CHIP_RV515_M52_714A, "RV515_M52 (Mobility Radeon X1300)" },
    { PCI_CHIP_RV515_M52_714B, "RV515_M52 (Mobility Radeon X1300)" },
    { PCI_CHIP_RV515_M52_714C, "RV515_M52 (Mobility Radeon X1300)" },
    { PCI_CHIP_RV515_714D, "RV515 (Radeon X1300)" },
    { PCI_CHIP_RV515_LE_714E, "RV515_LE (Radeon X1300)" },
    { PCI_CHIP_RV515_GL_7152, "RV515_GL (FireGL V3300)" },
    { PCI_CHIP_RV515_GL_7153, "RV515_GL (FireGL V3350)" },
    { PCI_CHIP_RV515_715E, "RV515 (Radeon X1300)" },
    { PCI_CHIP_RV505_CE_715F, "RV505_CE (Radeon X1550 64-bit)" },
    { PCI_CHIP_RV516_7180, "RV516 (Radeon X1300/X1550)" },
    { PCI_CHIP_RV516_XT_7181, "RV516_XT (Radeon X1600)" },
    { PCI_CHIP_RV516_7183, "RV516 (Radeon X1300/X1550)" },
    { PCI_CHIP_RV516_7187, "RV516 (Radeon X1300/X1550)" },
    { PCI_CHIP_RV515_M64_7188, "RV515_M64 (Mobility Radeon X2300)" },
    { PCI_CHIP_RV515_M64_718A, "RV515_M64 (Mobility Radeon X2300)" },
    { PCI_CHIP_RV515_M62_718C, "RV515_M62 (Mobility Radeon X1350)" },
    { PCI_CHIP_RV515_M64_718D, "RV515_M64 (Mobility Radeon X1450)" },
    { PCI_CHIP_RV516_7193, "RV516 (Radeon X1550)" },
    { PCI_CHIP_RV516_LE_719F, "RV516_LE (Radeon X1550 64-bit)" },
    { PCI_CHIP_RV530_71C0, "RV530 (Radeon X1600)" },
    { PCI_CHIP_RV530_71C2, "RV530 (Radeon X1600)" },
    { PCI_CHIP_RV530_M56_71C4, "RV530_M56 (Mobility FireGL V5200)" },
    { PCI_CHIP_RV530_M56_71C5, "RV530_M56 (Radeon Mobility X1600)" },
    { PCI_CHIP_RV530_LE_71C6, "RV530_LE (Radeon X1600/X1650 PRO)" },
    { PCI_CHIP_RV535_71C7, "RV535 (Radeon X1650)" },
    { PCI_CHIP_RV530_LE_71CE, "RV530_LE (Radeon X1600)" },
    { PCI_CHIP_RV530_M56_71D4, "RV530_M56 (Mobility FireGL V5250)" },
    { PCI_CHIP_RV530_M66_71D5, "RV530_M66 (Mobility Radeon X1700)" },
    { PCI_CHIP_RV530_M66_71D6, "RV530_M66 (Mobility Radeon X1700)" },
    { PCI_CHIP_RV530_LE_71DE, "RV530_LE (Radeon X1600)" },
    { PCI_CHIP_RV535_71E7, "RV535 (Radeon X1650)" },
    { PCI_CHIP_R580_7240, "R580 (Radeon X1900)" },
    { PCI_CHIP_R580_7241, "R580 (Radeon X1900)" },
    { PCI_CHIP_R580_7242, "R580 (Radeon X1900)" },
    { PCI_CHIP_R580_7243, "R580 (Radeon X1900)" },
    { PCI_CHIP_R580_7244, "R580 (Radeon X1900)" },
    { PCI_CHIP_R580_7245, "R580 (Radeon X1900)" },
    { PCI_CHIP_R580_7246, "R580 (Radeon X1900)" },
    { PCI_CHIP_R580_7247, "R580 (Radeon X1900)" },
    { PCI_CHIP_R580_7248, "R580 (Radeon X1900)" },
    { PCI_CHIP_R580_7249, "R580 (Radeon X1900 XT)" },
    { PCI_CHIP_R580_724A, "R580 (Radeon X1900)" },
    { PCI_CHIP_R580_724B, "R580 (Radeon X1900)" },
    { PCI_CHIP_R580_724C, "R580 (Radeon X1900)" },
    { PCI_CHIP_R580_724D, "R580 (Radeon X1900)" },
    { PCI_CHIP_R580_726B, "R580 (Radeon X1900)" },
    { PCI_CHIP_RV570_7280, "RV570 (Radeon X1950 Pro)" },
    { PCI_CHIP_RV570_7288, "RV570 (Radeon X1950 GT)" },
    { PCI_CHIP_RV530_7291, "RV530 (Radeon X1650 XT)" },
    { PCI_CHIP_RV530_7293, "RV530 (Radeon X1650)" },
    { -1,                  NULL }
};

PciChipsets avivo_pci_chips[] = {
    { PCI_CHIP_R520_7100, PCI_CHIP_R520_7100, RES_SHARED_VGA },
    { PCI_CHIP_R520_M58_7102, PCI_CHIP_R520_M58_7102, RES_SHARED_VGA },
    { PCI_CHIP_R520_M58_7103, PCI_CHIP_R520_M58_7103, RES_SHARED_VGA },
    { PCI_CHIP_R520_7104, PCI_CHIP_R520_7104, RES_SHARED_VGA },
    { PCI_CHIP_R520_7105, PCI_CHIP_R520_7105, RES_SHARED_VGA },
    { PCI_CHIP_R520_M58_7106, PCI_CHIP_R520_M58_7106, RES_SHARED_VGA },
    { PCI_CHIP_R520_M58_7108, PCI_CHIP_R520_M58_7108, RES_SHARED_VGA },
    { PCI_CHIP_R520_7109, PCI_CHIP_R520_7109, RES_SHARED_VGA },
    { PCI_CHIP_R520_710A, PCI_CHIP_R520_710A, RES_SHARED_VGA },
    { PCI_CHIP_R520_710B, PCI_CHIP_R520_710B, RES_SHARED_VGA },
    { PCI_CHIP_R520_710C, PCI_CHIP_R520_710C, RES_SHARED_VGA },
    { PCI_CHIP_RV515_7140, PCI_CHIP_RV515_7140, RES_SHARED_VGA },
    { PCI_CHIP_RV515_PRO_7142, PCI_CHIP_RV515_PRO_7142, RES_SHARED_VGA },
    { PCI_CHIP_RV505_7143, PCI_CHIP_RV505_7143, RES_SHARED_VGA },
    { PCI_CHIP_RV515_7145, PCI_CHIP_RV515_7145, RES_SHARED_VGA },
    { PCI_CHIP_RV515_7146, PCI_CHIP_RV515_7146, RES_SHARED_VGA },
    { PCI_CHIP_RV505_7147, PCI_CHIP_RV505_7147, RES_SHARED_VGA },
    { PCI_CHIP_RV515_M52_7149, PCI_CHIP_RV515_M52_7149, RES_SHARED_VGA },
    { PCI_CHIP_RV515_M52_714A, PCI_CHIP_RV515_M52_714A, RES_SHARED_VGA },
    { PCI_CHIP_RV515_M52_714B, PCI_CHIP_RV515_M52_714B, RES_SHARED_VGA },
    { PCI_CHIP_RV515_M52_714C, PCI_CHIP_RV515_M52_714C, RES_SHARED_VGA },
    { PCI_CHIP_RV515_714D, PCI_CHIP_RV515_714D, RES_SHARED_VGA },
    { PCI_CHIP_RV515_LE_714E, PCI_CHIP_RV515_LE_714E, RES_SHARED_VGA },
    { PCI_CHIP_RV515_GL_7152, PCI_CHIP_RV515_GL_7152, RES_SHARED_VGA },
    { PCI_CHIP_RV515_GL_7153, PCI_CHIP_RV515_GL_7153, RES_SHARED_VGA },
    { PCI_CHIP_RV515_715E, PCI_CHIP_RV515_715E, RES_SHARED_VGA },
    { PCI_CHIP_RV505_CE_715F, PCI_CHIP_RV505_CE_715F, RES_SHARED_VGA },
    { PCI_CHIP_RV516_7180, PCI_CHIP_RV516_7180, RES_SHARED_VGA },
    { PCI_CHIP_RV516_XT_7181, PCI_CHIP_RV516_XT_7181, RES_SHARED_VGA },
    { PCI_CHIP_RV516_7183, PCI_CHIP_RV516_7183, RES_SHARED_VGA },
    { PCI_CHIP_RV516_7187, PCI_CHIP_RV516_7187, RES_SHARED_VGA },
    { PCI_CHIP_RV515_M64_7188, PCI_CHIP_RV515_M64_7188, RES_SHARED_VGA },
    { PCI_CHIP_RV515_M64_718A, PCI_CHIP_RV515_M64_718A, RES_SHARED_VGA },
    { PCI_CHIP_RV515_M62_718C, PCI_CHIP_RV515_M62_718C, RES_SHARED_VGA },
    { PCI_CHIP_RV515_M64_718D, PCI_CHIP_RV515_M64_718D, RES_SHARED_VGA },
    { PCI_CHIP_RV516_7193, PCI_CHIP_RV516_7193, RES_SHARED_VGA },
    { PCI_CHIP_RV516_LE_719F, PCI_CHIP_RV516_LE_719F, RES_SHARED_VGA },
    { PCI_CHIP_RV530_71C0, PCI_CHIP_RV530_71C0, RES_SHARED_VGA },
    { PCI_CHIP_RV530_71C2, PCI_CHIP_RV530_71C2, RES_SHARED_VGA },
    { PCI_CHIP_RV530_M56_71C4, PCI_CHIP_RV530_M56_71C4, RES_SHARED_VGA },
    { PCI_CHIP_RV530_M56_71C5, PCI_CHIP_RV530_M56_71C5, RES_SHARED_VGA },
    { PCI_CHIP_RV530_LE_71C6, PCI_CHIP_RV530_LE_71C6, RES_SHARED_VGA },
    { PCI_CHIP_RV535_71C7, PCI_CHIP_RV535_71C7, RES_SHARED_VGA },
    { PCI_CHIP_RV530_LE_71CE, PCI_CHIP_RV530_LE_71CE, RES_SHARED_VGA },
    { PCI_CHIP_RV530_M56_71D4, PCI_CHIP_RV530_M56_71D4, RES_SHARED_VGA },
    { PCI_CHIP_RV530_M66_71D5, PCI_CHIP_RV530_M66_71D5, RES_SHARED_VGA },
    { PCI_CHIP_RV530_M66_71D6, PCI_CHIP_RV530_M66_71D6, RES_SHARED_VGA },
    { PCI_CHIP_RV530_LE_71DE, PCI_CHIP_RV530_LE_71DE, RES_SHARED_VGA },
    { PCI_CHIP_RV535_71E7, PCI_CHIP_RV535_71E7, RES_SHARED_VGA },
    { PCI_CHIP_R580_7240, PCI_CHIP_R580_7240, RES_SHARED_VGA },
    { PCI_CHIP_R580_7241, PCI_CHIP_R580_7241, RES_SHARED_VGA },
    { PCI_CHIP_R580_7242, PCI_CHIP_R580_7242, RES_SHARED_VGA },
    { PCI_CHIP_R580_7243, PCI_CHIP_R580_7243, RES_SHARED_VGA },
    { PCI_CHIP_R580_7244, PCI_CHIP_R580_7244, RES_SHARED_VGA },
    { PCI_CHIP_R580_7245, PCI_CHIP_R580_7245, RES_SHARED_VGA },
    { PCI_CHIP_R580_7246, PCI_CHIP_R580_7246, RES_SHARED_VGA },
    { PCI_CHIP_R580_7247, PCI_CHIP_R580_7247, RES_SHARED_VGA },
    { PCI_CHIP_R580_7248, PCI_CHIP_R580_7248, RES_SHARED_VGA },
    { PCI_CHIP_R580_7249, PCI_CHIP_R580_7249, RES_SHARED_VGA },
    { PCI_CHIP_R580_724A, PCI_CHIP_R580_724A, RES_SHARED_VGA },
    { PCI_CHIP_R580_724B, PCI_CHIP_R580_724B, RES_SHARED_VGA },
    { PCI_CHIP_R580_724C, PCI_CHIP_R580_724C, RES_SHARED_VGA },
    { PCI_CHIP_R580_724D, PCI_CHIP_R580_724D, RES_SHARED_VGA },
    { PCI_CHIP_R580_726B, PCI_CHIP_R580_726B, RES_SHARED_VGA },
    { PCI_CHIP_RV570_7280, PCI_CHIP_RV570_7280, RES_SHARED_VGA },
    { PCI_CHIP_RV570_7288, PCI_CHIP_RV570_7288, RES_SHARED_VGA },
    { PCI_CHIP_RV530_7291, PCI_CHIP_RV530_7291, RES_SHARED_VGA },
    { PCI_CHIP_RV530_7293, PCI_CHIP_RV530_7293, RES_SHARED_VGA },
    { -1,                  -1,                  RES_UNDEFINED }
};

struct avivo_chipset_family {
    unsigned int pci_id;
    enum avivo_chip_type family;
};

static struct avivo_chipset_family chipset_family[] = {
    { PCI_CHIP_R520_7100, CHIP_FAMILY_R520 },
    { PCI_CHIP_R520_M58_7102, CHIP_FAMILY_R520_M58 },
    { PCI_CHIP_R520_M58_7103, CHIP_FAMILY_R520_M58 },
    { PCI_CHIP_R520_7104, CHIP_FAMILY_R520 },
    { PCI_CHIP_R520_7105, CHIP_FAMILY_R520 },
    { PCI_CHIP_R520_M58_7106, CHIP_FAMILY_R520_M58 },
    { PCI_CHIP_R520_M58_7108, CHIP_FAMILY_R520_M58 },
    { PCI_CHIP_R520_7109, CHIP_FAMILY_R520 },
    { PCI_CHIP_R520_710A, CHIP_FAMILY_R520 },
    { PCI_CHIP_R520_710B, CHIP_FAMILY_R520 },
    { PCI_CHIP_R520_710C, CHIP_FAMILY_R520 },
    { PCI_CHIP_RV515_7140, CHIP_FAMILY_RV515 },
    { PCI_CHIP_RV515_PRO_7142, CHIP_FAMILY_RV515_PRO },
    { PCI_CHIP_RV505_7143, CHIP_FAMILY_RV505 },
    { PCI_CHIP_RV515_7145, CHIP_FAMILY_RV515 },
    { PCI_CHIP_RV515_7146, CHIP_FAMILY_RV515 },
    { PCI_CHIP_RV505_7147, CHIP_FAMILY_RV505 },
    { PCI_CHIP_RV515_M52_7149, CHIP_FAMILY_RV515_M52 },
    { PCI_CHIP_RV515_M52_714A, CHIP_FAMILY_RV515_M52 },
    { PCI_CHIP_RV515_M52_714B, CHIP_FAMILY_RV515_M52 },
    { PCI_CHIP_RV515_M52_714C, CHIP_FAMILY_RV515_M52 },
    { PCI_CHIP_RV515_714D, CHIP_FAMILY_RV515 },
    { PCI_CHIP_RV515_LE_714E, CHIP_FAMILY_RV515_LE },
    { PCI_CHIP_RV515_GL_7152, CHIP_FAMILY_RV515_GL },
    { PCI_CHIP_RV515_GL_7153, CHIP_FAMILY_RV515_GL },
    { PCI_CHIP_RV515_715E, CHIP_FAMILY_RV515 },
    { PCI_CHIP_RV505_CE_715F, CHIP_FAMILY_RV505_CE },
    { PCI_CHIP_RV516_7180, CHIP_FAMILY_RV516 },
    { PCI_CHIP_RV516_XT_7181, CHIP_FAMILY_RV516_XT },
    { PCI_CHIP_RV516_7183, CHIP_FAMILY_RV516 },
    { PCI_CHIP_RV516_7187, CHIP_FAMILY_RV516 },
    { PCI_CHIP_RV515_M64_7188, CHIP_FAMILY_RV515_M64 },
    { PCI_CHIP_RV515_M64_718A, CHIP_FAMILY_RV515_M64 },
    { PCI_CHIP_RV515_M62_718C, CHIP_FAMILY_RV515_M62 },
    { PCI_CHIP_RV515_M64_718D, CHIP_FAMILY_RV515_M64 },
    { PCI_CHIP_RV516_7193, CHIP_FAMILY_RV516 },
    { PCI_CHIP_RV516_LE_719F, CHIP_FAMILY_RV516_LE },
    { PCI_CHIP_RV530_71C0, CHIP_FAMILY_RV530 },
    { PCI_CHIP_RV530_71C2, CHIP_FAMILY_RV530 },
    { PCI_CHIP_RV530_M56_71C4, CHIP_FAMILY_RV530_M56 },
    { PCI_CHIP_RV530_M56_71C5, CHIP_FAMILY_RV530_M56 },
    { PCI_CHIP_RV530_LE_71C6, CHIP_FAMILY_RV530_LE },
    { PCI_CHIP_RV535_71C7, CHIP_FAMILY_RV535 },
    { PCI_CHIP_RV530_LE_71CE, CHIP_FAMILY_RV530_LE },
    { PCI_CHIP_RV530_M56_71D4, CHIP_FAMILY_RV530_M56 },
    { PCI_CHIP_RV530_M66_71D5, CHIP_FAMILY_RV530_M66 },
    { PCI_CHIP_RV530_M66_71D6, CHIP_FAMILY_RV530_M66 },
    { PCI_CHIP_RV530_LE_71DE, CHIP_FAMILY_RV530_LE },
    { PCI_CHIP_RV535_71E7, CHIP_FAMILY_RV535 },
    { PCI_CHIP_R580_7240, CHIP_FAMILY_R580 },
    { PCI_CHIP_R580_7241, CHIP_FAMILY_R580 },
    { PCI_CHIP_R580_7242, CHIP_FAMILY_R580 },
    { PCI_CHIP_R580_7243, CHIP_FAMILY_R580 },
    { PCI_CHIP_R580_7244, CHIP_FAMILY_R580 },
    { PCI_CHIP_R580_7245, CHIP_FAMILY_R580 },
    { PCI_CHIP_R580_7246, CHIP_FAMILY_R580 },
    { PCI_CHIP_R580_7247, CHIP_FAMILY_R580 },
    { PCI_CHIP_R580_7248, CHIP_FAMILY_R580 },
    { PCI_CHIP_R580_7249, CHIP_FAMILY_R580 },
    { PCI_CHIP_R580_724A, CHIP_FAMILY_R580 },
    { PCI_CHIP_R580_724B, CHIP_FAMILY_R580 },
    { PCI_CHIP_R580_724C, CHIP_FAMILY_R580 },
    { PCI_CHIP_R580_724D, CHIP_FAMILY_R580 },
    { PCI_CHIP_R580_726B, CHIP_FAMILY_R580 },
    { PCI_CHIP_RV570_7280, CHIP_FAMILY_RV570 },
    { PCI_CHIP_RV570_7288, CHIP_FAMILY_RV570 },
    { PCI_CHIP_RV530_7291, CHIP_FAMILY_RV530 },
    { PCI_CHIP_RV530_7293, CHIP_FAMILY_RV530 },
};

void
avivo_get_chipset(struct avivo_info *avivo)
{
    int i;

    for (i = 0; i < sizeof(chipset_family) / sizeof(chipset_family[0]); i++) {
        if (chipset_family[i].pci_id == avivo->pci_info->chipType) {
            avivo->chipset = chipset_family[i].family;
            return;
        }
    }
    FatalError("Unknown chipset for %x!\n", avivo->pci_info->device);
}
