/*
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifndef HISTORYDIALOG_H
#define HISTORYDIALOG_H

#include <qlist.h>
#include <qstring.h>

#include "HistoryDialogData.h"
#include "HistoryItem.h"
#include "HistoryFile.h"

class HistoryDialog : public HistoryDialogData
{
    Q_OBJECT

    friend class HistoryFile;
    
public:

    HistoryDialog(QWidget* parent=0, const char* name=0);
    ~HistoryDialog();

    bool load(const char* fileName);
    bool save();
    void add(const char* fileName, const char* title);

 protected slots:
    
    void historyItemHighlighted(int);
    void historySizeChanged();
    void prevButtonClicked();
    void nextButtonClicked();
    void deleteButtonClicked();
    void clearButtonClicked();

 signals:
    
    void playHistoryItem(const QString&);
    
 private:
    
    QList<HistoryItem> list;
    unsigned int maxItems;

    HistoryFile* file;
};

#endif  /* HISTORYDIALOG_H */
