/*
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#include "SidTuneWrapper.h"
#include "MD5.h"
#include "SidTuneMod.h"
#include "TypeWrapper.h"

int SidTuneWrapper::getMaxSongs()  // static
{
#ifdef SID_WITH_SIDPLAY2
    return SIDTUNE_MAX_SONGS;
#else
    return classMaxSongs;
#endif
}

unsigned long int SidTuneWrapper::getMaxSidFileLen()  // static
{
#ifdef SID_WITH_SIDPLAY2
    return SIDTUNE_MAX_FILELEN;
#else
    return maxSidtuneFileLen;
#endif
}

SidTuneWrapper::SidTuneWrapper()
{
    pSid = new SidTuneMod(0);
#ifdef SID_WITH_SIDPLAY2
    pSidInfo = new SidTuneInfo;
#else
    pSidInfo = new sidTuneInfo;
#endif
    pDigest = new QString;
}

SidTuneWrapper::~SidTuneWrapper()
{
    delete pDigest;
    delete pSidInfo;
    delete pSid;
}

bool SidTuneWrapper::open(const QString& fileName)
{
#ifdef SID_WITH_SIDPLAY2
    bool ret = pSid->load(fileName);
#else
    bool ret = pSid->open(fileName);
#endif
    updateInfo();
    return ret;
}

bool SidTuneWrapper::load(void* buf, unsigned long int bufLen)
{
#ifdef SID_WITH_SIDPLAY2
    bool ret = pSid->read((const ubyte_emuwt*)buf,(udword_emuwt)bufLen);
#else
    bool ret = pSid->load((const ubyte_emuwt*)buf,(udword_emuwt)bufLen);
#endif
    updateInfo();
    return ret;
}

const QString& SidTuneWrapper::getMD5_Digest()
{
    MD5 myMD5;
    pSid->createMD5(myMD5);
    myMD5.finish();
    // Print fingerprint.
    QString tmp;
    pDigest->truncate(0);
    for (int di = 0; di < 16; ++di)
        *pDigest += tmp.sprintf("%02x",(int)myMD5.getDigest()[di]);
    return *pDigest;
}

void SidTuneWrapper::updateInfo()
{
    pSid->getInfo(*pSidInfo);
}

bool SidTuneWrapper::getStatus() const
{
    return pSid->getStatus();
}

int SidTuneWrapper::getLoadAddr() const
{
    return pSidInfo->loadAddr;
}

int SidTuneWrapper::getInitAddr() const
{
    return pSidInfo->initAddr;
}

int SidTuneWrapper::getPlayAddr() const
{
    return pSidInfo->playAddr;
}

int SidTuneWrapper::getSongs() const
{
    return pSidInfo->songs;
}

int SidTuneWrapper::getCurrentSong() const
{
    return pSidInfo->currentSong;
}

int SidTuneWrapper::getStartSong() const
{
    return pSidInfo->startSong;
}

const char* SidTuneWrapper::getInfoString(int i) const
{
    return pSidInfo->infoString[i];
}

int SidTuneWrapper::getInfoStringsNum() const
{
    return pSidInfo->numberOfInfoStrings;
}

const char* SidTuneWrapper::getStatusString() const
{
    return pSidInfo->statusString;
}

#ifndef SID_WITH_SIDPLAY2
const char* SidTuneWrapper::getSpeedString() const
{
    return pSidInfo->speedString;
}
#endif

const char* SidTuneWrapper::getFormatString() const
{    
    return pSidInfo->formatString;
}

bool SidTuneWrapper::savePSID(const QString& fileName, bool overWrite)
{
    return pSid->savePSIDfile(fileName,overWrite);
}

SidTuneMod* SidTuneWrapper::getSidTune() const
{
    return pSid;
}

