/*
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifndef TSID2CONFIG_H
#define TSID2CONFIG_H

#ifdef XSID_HAVE_TSID2
#include <tsid2/tblist.h>
#include <tsid2/tsid2.h>
#endif

#include <qdir.h>

class TSID2Config
{
 public:

    QDir absBasePath;
    int custom;
#ifdef XSID_HAVE_TSID2
    TBLIST::engineType engine;
    unsigned int number_t;
    unsigned int number_n;
#endif

    TSID2Config()
    {
        absBasePath = "";
        custom=0;
#ifdef XSID_HAVE_TSID2
        engine=TBLIST::DINAMIC;
        number_t=(unsigned int)DEFAULT_SIZE;
        number_n=(unsigned int)DEFAULT_SIZE;
#endif
    }
};

#endif  /* TSID2CONFIG_H */
