/*
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#include "Fading.h"

FadingBase::FadingBase()
: fadeLevel(128)
{
}

FadingIn::FadingIn()
{
	proc = &FadingIn::dummy;
}

void FadingIn::set(const AudioConfig& audCfg, const int msecs)
{
	count = 0;
	millisecs = msecs;
	
	step = ((millisecs*audCfg.frequency*audCfg.channels)/fadeLevel)/1000;

	if (msecs == 0)        // no fading
		currentLevel = fadeLevel;
	else
		currentLevel = 0;  // minimum starting volume (silence)
	
	if (audCfg.precision == 16)
		proc = &FadingIn::fadeIn16;
	else
		proc = &FadingIn::fadeIn8;
}

void FadingIn::fade(ubyte_emuwt* buf, const udword_emuwt bufLen)
{
	(this->*proc)(buf,bufLen);
}

void FadingIn::dummy(ubyte_emuwt*, const udword_emuwt)
{ 
	;
}

void FadingIn::fadeIn8(ubyte_emuwt* sampleBuffer, const udword_emuwt sampleBufferSize)
{
	for ( udword_emuwt i = 0; i < sampleBufferSize; i++ )
	{
		sbyte_emuwt sam = (sbyte_emuwt)( 0x80 ^ *(sampleBuffer +i));
		sword_emuwt modsam = sam * currentLevel;
		modsam /= fadeLevel;
		sam = (sbyte_emuwt)modsam;
		*(sampleBuffer +i) = 0x80 ^ sam;

		count++;
		if ( count >= step )
		{
			if ( currentLevel < fadeLevel )
			{
				currentLevel++;
			}
			count = 0;
		}
	}
}

void FadingIn::fadeIn16(ubyte_emuwt* sampleBuffer, const udword_emuwt sampleBufferSize)
{
	sword_emuwt *buf = (sword_emuwt*)sampleBuffer;
	for ( udword_emuwt i = 0; i < sampleBufferSize/2; i++ )
	{
		sword_emuwt sam = *(buf +i);
		sdword_emuwt modsam = sam * currentLevel;
		modsam /= fadeLevel;
		sam = (sword_emuwt)modsam;
		*(buf +i) = sam;

		count++;
		if ( count >= step )
		{
			if ( currentLevel < fadeLevel )
			{
				currentLevel++;
			}
			count = 0;
		}
	}
}

FadingOut::FadingOut()
{
	proc = &FadingOut::dummy;
}

void FadingOut::set(const AudioConfig& audCfg, const int msecs)
{
	count = 0;
	millisecs = msecs;
	
	step = ((millisecs*audCfg.frequency*audCfg.channels)/fadeLevel)/1000;
	
	if (msecs == 0)                // no fading
		currentLevel = fadeLevel;
	else
		currentLevel = fadeLevel;  // maximum starting volume
	if (audCfg.precision == 16)
		proc = &FadingOut::fadeOut16;
	else
		proc = &FadingOut::fadeOut8;
}

void FadingOut::fade(ubyte_emuwt* buf, const udword_emuwt bufLen)
{
	(this->*proc)(buf,bufLen);
}

void FadingOut::dummy(ubyte_emuwt*, const udword_emuwt)
{ 
	;
}

void FadingOut::fadeOut8(ubyte_emuwt* sampleBuffer, const udword_emuwt sampleBufferSize)
{
	for ( udword_emuwt i = 0; i < sampleBufferSize; i++ )
	{
		sbyte_emuwt sam = (sbyte_emuwt)( 0x80 ^ *(sampleBuffer +i));
		sword_emuwt modsam = sam * currentLevel;
		modsam /= fadeLevel;
		sam = (sbyte_emuwt)modsam;
		*(sampleBuffer +i) = 0x80 ^ sam;
		
		count++;
		if ( count >= step )
		{
			if ( currentLevel > 0 )
			{
				currentLevel--;
			}
			count = 0;
		}
	}
}

void FadingOut::fadeOut16(ubyte_emuwt* sampleBuffer, const udword_emuwt sampleBufferSize)
{
	sword_emuwt* buf = (sword_emuwt*)sampleBuffer;
	for ( udword_emuwt i = 0; i < sampleBufferSize/2; i++ )
	{
		sword_emuwt sam = *(buf +i);
		sdword_emuwt modsam = sam * currentLevel;
		modsam /= fadeLevel;
		sam = (sword_emuwt)modsam;
		*(buf +i) = sam;
		
		count++;
		if ( count >= step )
		{
			if ( currentLevel > 0 )
			{
				currentLevel--;
			}
			count = 0;
		}
	}
}

