/**
 * A client-side 802.1x implementation 
 *
 * This code is released under both the GPL version 2 and BSD licenses.
 * Either license may be used.  The respective licenses are found below.
 *
 * Copyright (C) 2002 Bryan D. Payne & Nick L. Petroni Jr.
 * All Rights Reserved
 *
 * --- GPL Version 2 License ---
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 * --- BSD License ---
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 *  - Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 *  - Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *  - All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *       This product includes software developed by the University of
 *       Maryland at College Park and its contributors.
 *  - Neither the name of the University nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */

/*******************************************************************
 * File: snmp.c
 *
 * Authors: Chris.Hessing@utah.edu
 *
 * $Id: snmp.c,v 1.2 2004/08/11 04:01:17 chessing Exp $
 * $Date: 2004/08/11 04:01:17 $
 * $Log: snmp.c,v $
 * Revision 1.2  2004/08/11 04:01:17  chessing
 *
 * The -d option now supports letter designations for each debug level, in addition to 0..7.  (However, both letters and numbers can't be used at the same time!)  Also changed some formatting for the SNMP scoreboard.
 *
 * Revision 1.1  2004/08/11 02:44:55  chessing
 *
 * Added missing snmp.c/h files.
 *
 *
 *******************************************************************/

#include "snmp.h"
#include "profile.h"
#include "xsup_debug.h"

void snmp_dump_stats(struct interface_data *intcur)
{
  while (intcur != NULL)
    {
      debug_printf(DEBUG_SNMP, "\nStats for Interface %s with index %d :\n\n",
		   intcur->intName, intcur->intIndex);

      debug_printf(DEBUG_SNMP, "EAPOL Frames RX    : %10d   EAPOL Frames TX    : %10d\n", 
		   intcur->snmp->dot1xSuppEapolFramesRx, intcur->snmp->dot1xSuppEapolFramesTx);
      debug_printf(DEBUG_SNMP, "EAPOL Starts TX    : %10d   EAPOL Logoff TX    : %10d\n",
		   intcur->snmp->dot1xSuppEapolStartFramesTx, intcur->snmp->dot1xSuppEapolLogoffFramesTx);
      debug_printf(DEBUG_SNMP, "EAPOL Resp. ID TX  : %10d   EAPOL Resp. TX     : %10d\n",
		   intcur->snmp->dot1xSuppEapolRespIdFramesTx, intcur->snmp->dot1xSuppEapolRespFramesTx);
      debug_printf(DEBUG_SNMP, "EAPOL Req. ID RX   : %10d   EAPOL Req. RX      : %10d\n",
		   intcur->snmp->dot1xSuppEapolReqIdFramesRx, intcur->snmp->dot1xSuppEapolReqFramesRx);
      debug_printf(DEBUG_SNMP, "EAPOL Invalid Frame: %10d   EAP Length Error   : %10d\n",
		   intcur->snmp->dot1xSuppInvalidEapolFramesRx, intcur->snmp->dot1xSuppEapLengthErrorFramesRx);
      debug_printf(DEBUG_SNMP, "Last EAPOL Version : %10d   Last EAPOL Src.    :",
		   intcur->snmp->dot1xSuppLastEapolFrameVersion);
      debug_hex_printf(DEBUG_SNMP, intcur->snmp->dot1xSuppLastEapolFrameSource, 6);
      debug_printf(DEBUG_SNMP, "EAPOL Success      : %10d   EAPOL Failure      : %10d\n\n",
		   intcur->snmp->eapol_success_rx, intcur->snmp->eapol_fail_rx);
      
      intcur = intcur->next;
    }
}

