/*******************************************************************
 *
 * File: xsup_monitor.c
 *
 * Licensed under a dual GPL/BSD license.  (See LICENSE file for more info.)
 *
 * Authors: Chris.Hessing@utah.edu, Terry.Simons@utah.edu
 *
 * $Id: xsup_monitor.c,v 1.14 2005/08/09 01:39:12 chessing Exp $
 * $Date: 2005/08/09 01:39:12 $
 * $Log: xsup_monitor.c,v $
 * Revision 1.14  2005/08/09 01:39:12  chessing
 * Cleaned out old commit notes from the released version.  Added a few small features including the ability to disable the friendly warnings that are spit out.  (Such as the warning that is displayed when keys aren't rotated after 10 minutes.)  We should also be able to start when the interface is down.  Last, but not least, we can handle empty network configs.  (This may be useful for situations where there isn't a good reason to have a default network defined.)
 *
 *
 *******************************************************************/
#include <stdio.h>
#include <unistd.h>
#include <strings.h>
#include <string.h>
#include <stdlib.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <net/if.h>

#include "../../common/gui_interface.h"

int connected;
char activeint[16];
int outptr=0, skfd;

/*******************************************************************
 *
 * Make sure that XSupplicant is running.  If it isn't, then block and
 * check every so often.
 *
 *******************************************************************/
void block_while_not_xsup(char *intname)
{
  int disp=0;

  while (is_xsup_running(intname) == FALSE)
    {
      if (disp == 0)
	{
	  printf("XSupplicant isn't running.  We will block, and check again every second!\n");
	  disp = 1;
	}

      if (connected == 1)
	{
	  gui_interface_disconnect(skfd);
	  connected = 0;
	}

      sleep(1);
    }
}

void do_password(char *eaptype, char *challenge)
{
  char *passwd, buffer[1520], result[256];
  int bufptr, dlen, done = FALSE, i;  



  bzero((char *)&buffer, 1520);
  
  passwd = getpass("Please enter your password : ");
 
  if (passwd == NULL)
    {
      printf("No password set!\n");
      return;
    }

  gui_interface_set_password(if_nametoindex(activeint), (char *)&buffer, &outptr, passwd);

  switch (gui_interface_send_packet(skfd, (char *)&buffer, outptr))
    {
    case ERR_PKT_BAD:
      fprintf(stderr, "Error! Packet appears to be bad!\n");
      return;
      break;
    case ERR_SOCK:
      fprintf(stderr, "Error! There was a socket error!\n");
      return;
      break;
    }

  // Flush extra request packets.
  bzero((char *)&buffer, 1520);
  while (!done)
    {

      bufptr = 1520;
      if (gui_interface_get_packet(skfd, (char *)&buffer, &bufptr, TRUE) == ERR_SOCK)
	{
	  done = TRUE;
	  continue;
	}

      bufptr = 0;

      i = gui_interface_parse_packet((char *)&buffer, &bufptr, (char *)&result,
				     &dlen, (char *)&activeint);

      if (i != PASSWORD)
	{
	  done = TRUE;
	}
    }

  if (result[0] == ACK) 
    {
      printf("Your password has been successfully submitted to the XSupplicant daemon.\n");
    } else {
      fprintf(stderr, "Error!  Password not set!\n");
    }
}

void handle_password(char *packet)
{
  int bufptr=0;
  char eaptype[128], challenge[256];

  strcpy((char *)&eaptype[0], (char *)&packet[bufptr]);
  printf("EAP Type : %s\n",eaptype);
  bufptr += strlen(eaptype)+1;

  if (challenge[0] != 0x00)
    {
      strcpy((char *)&challenge[0], (char *)&packet[bufptr]);
      printf("Challenge : %s\n", challenge);
    }

  do_password(eaptype, challenge);
}

void handle_authstate(char *interface, char state)
{
  printf("Interface %s is now in ", interface);

  switch (state)
    {
    case LOGOFF:
      printf("LOGOFF");
      break;
    case DISCONNECTED:
      printf("DISCONNECTED");
      break;
    case CONNECTING:
      printf("CONNECTING");
      break;
    case ACQUIRED:
      printf("ACQUIRED");
      break;
    case AUTHENTICATING:
      printf("AUTHENTICATING");
      break;
    case HELD:
      printf("HELD");
      break;
    case AUTHENTICATED:
      printf("AUTHENTICATED");
      break;
    case RESTART:
      printf("RESTART");
      break;
    case S_FORCE_AUTH:
      printf("FORCED AUTHENTICATED");
      break;
    case S_FORCE_UNAUTH:
      printf("FORCED UNAUTHENTICATED");
      break;
    default:
      printf("UNKNOWN!!!!!!!!!!!!!!!!");
      break;
    }
  printf(" state.\n");
}

int main(int argc, char *argv[])
{
  char buffer[1520], result[256];
  int bufptr, dlen, i, curptr;

  if (argc < 2)
    {
      printf("You need to specify an interface to monitor!\n");
      exit(1);
    }

  while (1)
    {
      // Make sure that we have something to connect to.
      block_while_not_xsup(argv[1]);

      // If we have not connected before, or if we need to reconnect.
      if (connected != 1)
	{
	  skfd = gui_interface_connect(argv[1]);
	  if (skfd < 1)
	    {
	      fprintf(stderr, "Error! Couldn't get a handle to the daemon! "
                      "(Is the interface valid?)\n");
	      exit(1);
	    }
	  connected = 1;
	}

      bzero(&buffer, 1520);
      bufptr = 1520;

      gui_interface_get_packet(skfd, (char *)&buffer, (int *)&bufptr, TRUE);

      outptr = 0;
      curptr = 0;

      while ((bufptr > 0) && (curptr < bufptr))
	{
	  // Process the message we have been given.
	  i=gui_interface_parse_packet((char *)&buffer, &curptr, 
				       (char *)&result, &dlen, 
				       (char *)&activeint);

	  switch (i)
	    {
	    case ERR_PKT_BAD:
	      // We have a bad packet!
	      fprintf(stderr, "Got a bad packet from the Supplicant!\n");
	      fprintf(stderr, "curptr: %d - bufptr: %d\n", curptr, bufptr);
	      break;
	    case PASSWORD:
	      handle_password((char *)&result[0]);
	      break;
	    case AUTH_STATE:
	      handle_authstate(activeint, result[0]);
	      break;
	    }
	} 
    }
}
