/*******************************************************************
 * Control the backend state machine as defined in 802.1X-REV-d11.
 *
 * Licensed under a dual GPL/BSD license.  (See LICENSE file for more info.)
 *
 * File: backend_sm.h
 *
 * Authors: Chris.Hessing@utah.edu
 *
 *******************************************************************/

#ifndef _BACKEND_SM_
#define _BACKEND_SM_

#define REQUEST      0
#define RESPONSE     1
#define SUCCESS      2
#define FAIL         3
#define TIMEOUT      4
#define IDLE         5
#define INITIALIZE   6
#define RECEIVE      7


void backend_sm_init(struct interface_data *);
void backend_sm_reinit(struct interface_data *);
int backend_sm_run(struct interface_data *);
void backend_sm_deinit(struct interface_data *);

#endif
