/* Xsynth DSSI software synthesizer plugin
 *
 * Copyright (C) 2004 Sean Bolton.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of
 * the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be
 * useful, but WITHOUT ANY WARRANTY; without even the implied
 * warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
 * PURPOSE.  See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this program; if not, write to the Free
 * Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 * MA 02111-1307, USA.
 */

#include "xsynth_voice.h"

/* minBLEP tables
 *
 * sinc cutoff frequency: 0.9 nyquist
 * oversampling: 64
 * zero crossings: 32
 * Blackman window width: 4553
 *
 * run-time phase calculation simplified by shifting minBLEP discontinuity
 * center from 3.410565495 samples forward to 4 samples (using cubic
 * interpolation)
 *
 * forward-shifted step discontinuity delta truncated after local minimum
 * at the 4606th oversample (yielding a 72 sample pulse)
 *
 * forward-shifted slope discontinuity delta truncated after local minimum
 * at 4513th oversample (yielding a 71 sample pulse)
 *
 * For more information, see:
 *
 *    Stilson and Smith, "Alias Free Digital Synthesis of Classic Analog
 *        Waveforms" (1996)
 *
 *    Brandt, "Hard Sync Without Aliasing" (2001)
 */

float_value_delta
step_dd_table[MINBLEP_PHASES * STEP_DD_PULSE_LENGTH + 1] =
{
 { 0.000000e+00, 0.000000e+00},{ 0.000000e+00, 0.000000e+00},{ 0.000000e+00, 0.000000e+00},{ 0.000000e+00, 0.000000e+00},
 { 0.000000e+00, 0.000000e+00},{ 0.000000e+00, 0.000000e+00},{ 0.000000e+00, 0.000000e+00},{ 0.000000e+00, 0.000000e+00},
 { 0.000000e+00, 0.000000e+00},{ 0.000000e+00, 0.000000e+00},{ 0.000000e+00, 0.000000e+00},{ 0.000000e+00, 0.000000e+00},
 { 0.000000e+00, 0.000000e+00},{ 0.000000e+00, 0.000000e+00},{ 0.000000e+00, 0.000000e+00},{ 0.000000e+00, 0.000000e+00},
 { 0.000000e+00, 0.000000e+00},{ 0.000000e+00, 0.000000e+00},{ 0.000000e+00, 0.000000e+00},{ 0.000000e+00, 0.000000e+00},
 { 0.000000e+00, 0.000000e+00},{ 0.000000e+00, 0.000000e+00},{ 0.000000e+00, 0.000000e+00},{ 0.000000e+00, 0.000000e+00},
 { 0.000000e+00, 0.000000e+00},{ 0.000000e+00, 0.000000e+00},{ 0.000000e+00, 0.000000e+00},{ 0.000000e+00, 0.000000e+00},
 { 0.000000e+00, 0.000000e+00},{ 0.000000e+00, 0.000000e+00},{ 0.000000e+00, 0.000000e+00},{ 0.000000e+00, 0.000000e+00},
 { 0.000000e+00, 0.000000e+00},{ 0.000000e+00, 0.000000e+00},{ 0.000000e+00, 0.000000e+00},{ 0.000000e+00, 0.000000e+00},
 { 0.000000e+00, 0.000000e+00},{ 0.000000e+00, 0.000000e+00},{ 0.000000e+00, 3.120477e-10},{ 3.120477e-10, 2.206607e-10},
 { 5.327084e-10, 3.324307e-10},{ 8.651391e-10, 5.145081e-10},{ 1.379647e-09, 7.942344e-10},{ 2.173882e-09, 1.204874e-09},
 { 3.378756e-09, 1.786396e-09},{ 5.165152e-09, 2.586318e-09},{ 7.751469e-09, 3.660619e-09},{ 1.141209e-08, 5.074724e-09},
 { 1.648681e-08, 6.904558e-09},{ 2.339137e-08, 9.237679e-09},{ 3.262905e-08, 1.217449e-08},{ 4.480354e-08, 1.582953e-08},
 { 6.063307e-08, 2.033286e-08},{ 8.096593e-08, 2.583152e-08},{ 1.067974e-07, 3.249110e-08},{ 1.392886e-07, 4.049739e-08},
 { 1.797859e-07, 5.005810e-08},{ 2.298440e-07, 6.140477e-08},{ 2.912488e-07, 7.479467e-08},{ 3.660435e-07, 9.051285e-08},
 { 4.565563e-07, 1.088744e-07},{ 5.654307e-07, 1.302265e-07},{ 6.956571e-07, 1.549511e-07},{ 8.506082e-07, 1.834672e-07},
 { 1.034075e-06, 2.162336e-07},{ 1.250309e-06, 2.537515e-07},{ 1.504060e-06, 2.965675e-07},{ 1.800628e-06, 3.452764e-07},
 { 2.145904e-06, 4.005246e-07},{ 2.546429e-06, 4.630129e-07},{ 3.009442e-06, 5.335003e-07},{ 3.542942e-06, 6.128071e-07},
 { 4.155749e-06, 7.018187e-07},{ 4.857568e-06, 8.014893e-07},{ 5.659057e-06, 9.128457e-07},{ 6.571903e-06, 1.036991e-06},
 { 7.608894e-06, 1.175111e-06},{ 8.784005e-06, 1.328473e-06},{ 1.011248e-05, 1.498436e-06},{ 1.161091e-05, 1.686452e-06},
 { 1.329737e-05, 1.894073e-06},{ 1.519144e-05, 2.122953e-06},{ 1.731439e-05, 2.374852e-06},{ 1.968924e-05, 2.651647e-06},
 { 2.234089e-05, 2.955329e-06},{ 2.529622e-05, 3.288016e-06},{ 2.858424e-05, 3.651952e-06},{ 3.223619e-05, 4.049516e-06},
 { 3.628570e-05, 4.483226e-06},{ 4.076893e-05, 4.955745e-06},{ 4.572467e-05, 5.469888e-06},{ 5.119456e-05, 6.028624e-06},
 { 5.722319e-05, 6.635087e-06},{ 6.385827e-05, 7.292577e-06},{ 7.115085e-05, 8.004569e-06},{ 7.915542e-05, 8.774718e-06},
 { 8.793014e-05, 9.606865e-06},{ 9.753700e-05, 1.050504e-05},{ 1.080420e-04, 1.147349e-05},{ 1.195155e-04, 1.251663e-05},
 { 1.320322e-04, 1.363912e-05},{ 1.456713e-04, 1.484582e-05},{ 1.605171e-04, 1.614181e-05},{ 1.766589e-04, 1.753242e-05},
 { 1.941913e-04, 1.902320e-05},{ 2.132145e-04, 2.061994e-05},{ 2.338345e-04, 2.232867e-05},{ 2.561631e-04, 2.415569e-05},
 { 2.803188e-04, 2.610756e-05},{ 3.064264e-04, 2.819108e-05},{ 3.346175e-04, 3.041336e-05},{ 3.650308e-04, 3.278174e-05},
 { 3.978126e-04, 3.530388e-05},{ 4.331164e-04, 3.798771e-05},{ 4.711041e-04, 4.084145e-05},{ 5.119456e-04, 4.387361e-05},
 { 5.558192e-04, 4.709303e-05},{ 6.029122e-04, 5.050883e-05},{ 6.534211e-04, 5.413045e-05},{ 7.075515e-04, 5.796763e-05},
 { 7.655191e-04, 6.203044e-05},{ 8.275496e-04, 6.632928e-05},{ 8.938789e-04, 7.087486e-05},{ 9.647537e-04, 7.567822e-05},
 { 1.040432e-03, 8.075073e-05},{ 1.121183e-03, 8.610410e-05},{ 1.207287e-03, 9.175036e-05},{ 1.299037e-03, 9.770189e-05},
 { 1.396739e-03, 1.039714e-04},{ 1.500710e-03, 1.105719e-04},{ 1.611282e-03, 1.175168e-04},{ 1.728799e-03, 1.248199e-04},
 { 1.853619e-03, 1.324951e-04},{ 1.986114e-03, 1.405569e-04},{ 2.126671e-03, 1.490199e-04},{ 2.275691e-03, 1.578993e-04},
 { 2.433590e-03, 1.672105e-04},{ 2.600801e-03, 1.769690e-04},{ 2.777770e-03, 1.871910e-04},{ 2.964961e-03, 1.978928e-04},
 { 3.162853e-03, 2.090910e-04},{ 3.371944e-03, 2.208026e-04},{ 3.592747e-03, 2.330449e-04},{ 3.825792e-03, 2.458353e-04},
 { 4.071627e-03, 2.591918e-04},{ 4.330819e-03, 2.731324e-04},{ 4.603952e-03, 2.876755e-04},{ 4.891627e-03, 3.028397e-04},
 { 5.194467e-03, 3.186439e-04},{ 5.513111e-03, 3.351072e-04},{ 5.848218e-03, 3.522489e-04},{ 6.200467e-03, 3.700885e-04},
 { 6.570555e-03, 3.886459e-04},{ 6.959201e-03, 4.079408e-04},{ 7.367142e-03, 4.279934e-04},{ 7.795135e-03, 4.488239e-04},
 { 8.243959e-03, 4.704527e-04},{ 8.714412e-03, 4.929002e-04},{ 9.207312e-03, 5.161870e-04},{ 9.723499e-03, 5.403338e-04},
 { 1.026383e-02, 5.653614e-04},{ 1.082919e-02, 5.912904e-04},{ 1.142048e-02, 6.181416e-04},{ 1.203863e-02, 6.459358e-04},
 { 1.268456e-02, 6.746937e-04},{ 1.335926e-02, 7.044362e-04},{ 1.406369e-02, 7.351836e-04},{ 1.479888e-02, 7.669567e-04},
 { 1.556583e-02, 7.997757e-04},{ 1.636561e-02, 8.336609e-04},{ 1.719927e-02, 8.686324e-04},{ 1.806790e-02, 9.047100e-04},
 { 1.897261e-02, 9.419134e-04},{ 1.991452e-02, 9.802618e-04},{ 2.089479e-02, 1.019774e-03},{ 2.191456e-02, 1.060470e-03},
 { 2.297503e-02, 1.102367e-03},{ 2.407740e-02, 1.145483e-03},{ 2.522288e-02, 1.189835e-03},{ 2.641272e-02, 1.235442e-03},
 { 2.764816e-02, 1.282319e-03},{ 2.893048e-02, 1.330483e-03},{ 3.026096e-02, 1.379949e-03},{ 3.164091e-02, 1.430732e-03},
 { 3.307164e-02, 1.482846e-03},{ 3.455449e-02, 1.536306e-03},{ 3.609079e-02, 1.591124e-03},{ 3.768192e-02, 1.647312e-03},
 { 3.932923e-02, 1.704881e-03},{ 4.103411e-02, 1.763844e-03},{ 4.279795e-02, 1.824208e-03},{ 4.462216e-02, 1.885984e-03},
 { 4.650814e-02, 1.949178e-03},{ 4.845732e-02, 2.013799e-03},{ 5.047112e-02, 2.079853e-03},{ 5.255098e-02, 2.147344e-03},
 { 5.469832e-02, 2.216276e-03},{ 5.691460e-02, 2.286653e-03},{ 5.920125e-02, 2.358476e-03},{ 6.155972e-02, 2.431745e-03},
 { 6.399147e-02, 2.506461e-03},{ 6.649793e-02, 2.582621e-03},{ 6.908055e-02, 2.660222e-03},{ 7.174077e-02, 2.739260e-03},
 { 7.448003e-02, 2.819729e-03},{ 7.729976e-02, 2.901622e-03},{ 8.020138e-02, 2.984930e-03},{ 8.318631e-02, 3.069643e-03},
 { 8.625596e-02, 3.155750e-03},{ 8.941171e-02, 3.243239e-03},{ 9.265495e-02, 3.332094e-03},{ 9.598704e-02, 3.422299e-03},
 { 9.940934e-02, 3.513837e-03},{ 1.029232e-01, 3.606690e-03},{ 1.065299e-01, 3.700835e-03},{ 1.102307e-01, 3.796250e-03},
 { 1.140270e-01, 3.892912e-03},{ 1.179199e-01, 3.990795e-03},{ 1.219107e-01, 4.089870e-03},{ 1.260005e-01, 4.190109e-03},
 { 1.301906e-01, 4.291481e-03},{ 1.344821e-01, 4.393953e-03},{ 1.388761e-01, 4.497491e-03},{ 1.433736e-01, 4.602057e-03},
 { 1.479756e-01, 4.707615e-03},{ 1.526832e-01, 4.814124e-03},{ 1.574974e-01, 4.921542e-03},{ 1.624189e-01, 5.029827e-03},
 { 1.674487e-01, 5.138931e-03},{ 1.725877e-01, 5.248810e-03},{ 1.778365e-01, 5.359413e-03},{ 1.831959e-01, 5.470690e-03},
 { 1.886666e-01, 5.582589e-03},{ 1.942492e-01, 5.695054e-03},{ 1.999442e-01, 5.808031e-03},{ 2.057522e-01, 5.921461e-03},
 { 2.116737e-01, 6.035285e-03},{ 2.177090e-01, 6.149442e-03},{ 2.238584e-01, 6.263868e-03},{ 2.301223e-01, 6.378499e-03},
 { 2.365008e-01, 6.493268e-03},{ 2.429941e-01, 6.608108e-03},{ 2.496022e-01, 6.722949e-03},{ 2.563251e-01, 6.837721e-03},
 { 2.631628e-01, 6.952349e-03},{ 2.701152e-01, 7.066762e-03},{ 2.771820e-01, 7.180882e-03},{ 2.843628e-01, 7.294633e-03},
 { 2.916575e-01, 7.407936e-03},{ 2.990654e-01, 7.520713e-03},{ 3.065861e-01, 7.632882e-03},{ 3.142190e-01, 7.744360e-03},
 { 3.219634e-01, 7.855066e-03},{ 3.298184e-01, 7.964914e-03},{ 3.377833e-01, 8.073819e-03},{ 3.458572e-01, 8.181696e-03},
 {-6.459611e-01, 8.288455e-03},{-6.376727e-01, 8.394010e-03},{-6.292787e-01, 8.498272e-03},{-6.207804e-01, 8.601151e-03},
 {-6.121793e-01, 8.702557e-03},{-6.034767e-01, 8.802399e-03},{-5.946743e-01, 8.900586e-03},{-5.857737e-01, 8.997026e-03},
 {-5.767767e-01, 9.091628e-03},{-5.676851e-01, 9.184299e-03},{-5.585008e-01, 9.274948e-03},{-5.492258e-01, 9.363481e-03},
 {-5.398623e-01, 9.449807e-03},{-5.304125e-01, 9.533834e-03},{-5.208787e-01, 9.615469e-03},{-5.112632e-01, 9.694621e-03},
 {-5.015686e-01, 9.771199e-03},{-4.917974e-01, 9.845112e-03},{-4.819523e-01, 9.916270e-03},{-4.720360e-01, 9.984585e-03},
 {-4.620514e-01, 1.004997e-02},{-4.520015e-01, 1.011233e-02},{-4.418891e-01, 1.017158e-02},{-4.317176e-01, 1.022764e-02},
 {-4.214899e-01, 1.028043e-02},{-4.112095e-01, 1.032986e-02},{-4.008796e-01, 1.037584e-02},{-3.905038e-01, 1.041831e-02},
 {-3.800855e-01, 1.045717e-02},{-3.696283e-01, 1.049236e-02},{-3.591359e-01, 1.052380e-02},{-3.486122e-01, 1.055141e-02},
 {-3.380607e-01, 1.057514e-02},{-3.274856e-01, 1.059489e-02},{-3.168907e-01, 1.061062e-02},{-3.062801e-01, 1.062226e-02},
 {-2.956578e-01, 1.062974e-02},{-2.850281e-01, 1.063301e-02},{-2.743951e-01, 1.063201e-02},{-2.637631e-01, 1.062669e-02},
 {-2.531364e-01, 1.061699e-02},{-2.425194e-01, 1.060288e-02},{-2.319165e-01, 1.058429e-02},{-2.213322e-01, 1.056120e-02},
 {-2.107710e-01, 1.053356e-02},{-2.002374e-01, 1.050135e-02},{-1.897361e-01, 1.046452e-02},{-1.792716e-01, 1.042305e-02},
 {-1.688485e-01, 1.037691e-02},{-1.584716e-01, 1.032609e-02},{-1.481455e-01, 1.027056e-02},{-1.378750e-01, 1.021032e-02},
 {-1.276646e-01, 1.014535e-02},{-1.175193e-01, 1.007565e-02},{-1.074436e-01, 1.000122e-02},{-9.744243e-02, 9.922048e-03},
 {-8.752038e-02, 9.838155e-03},{-7.768223e-02, 9.749546e-03},{-6.793268e-02, 9.656236e-03},{-5.827645e-02, 9.558243e-03},
 {-4.871820e-02, 9.455592e-03},{-3.926261e-02, 9.348307e-03},{-2.991430e-02, 9.236422e-03},{-2.067788e-02, 9.119972e-03},
 {-1.155791e-02, 8.998997e-03},{-2.558910e-03, 8.873542e-03},{ 6.314631e-03, 8.743655e-03},{ 1.505829e-02, 8.609389e-03},
 { 2.366767e-02, 8.470802e-03},{ 3.213848e-02, 8.327956e-03},{ 4.046643e-02, 8.180918e-03},{ 4.864735e-02, 8.029757e-03},
 { 5.667711e-02, 7.874549e-03},{ 6.455166e-02, 7.715373e-03},{ 7.226703e-02, 7.552312e-03},{ 7.981934e-02, 7.385455e-03},
 { 8.720480e-02, 7.214892e-03},{ 9.441969e-02, 7.040720e-03},{ 1.014604e-01, 6.863040e-03},{ 1.083234e-01, 6.681954e-03},
 { 1.150054e-01, 6.497572e-03},{ 1.215030e-01, 6.310006e-03},{ 1.278130e-01, 6.119371e-03},{ 1.339324e-01, 5.925786e-03},
 { 1.398581e-01, 5.729376e-03},{ 1.455875e-01, 5.530267e-03},{ 1.511178e-01, 5.328590e-03},{ 1.564464e-01, 5.124478e-03},
 { 1.615708e-01, 4.918069e-03},{ 1.664889e-01, 4.709502e-03},{ 1.711984e-01, 4.498921e-03},{ 1.756973e-01, 4.286474e-03},
 { 1.799838e-01, 4.072307e-03},{ 1.840561e-01, 3.856575e-03},{ 1.879127e-01, 3.639431e-03},{ 1.915521e-01, 3.421032e-03},
 { 1.949732e-01, 3.201538e-03},{ 1.981747e-01, 2.981110e-03},{ 2.011558e-01, 2.759912e-03},{ 2.039157e-01, 2.538109e-03},
 { 2.064538e-01, 2.315867e-03},{ 2.087697e-01, 2.093357e-03},{ 2.108631e-01, 1.870748e-03},{ 2.127338e-01, 1.648212e-03},
 { 2.143820e-01, 1.425920e-03},{ 2.158079e-01, 1.204046e-03},{ 2.170120e-01, 9.827651e-04},{ 2.179947e-01, 7.622510e-04},
 { 2.187570e-01, 5.426790e-04},{ 2.192997e-01, 3.242244e-04},{ 2.196239e-01, 1.070624e-04},{ 2.197310e-01,-1.086318e-04},
 { 2.196223e-01,-3.226835e-04},{ 2.192996e-01,-5.349184e-04},{ 2.187647e-01,-7.451629e-04},{ 2.180196e-01,-9.532445e-04},
 { 2.170663e-01,-1.158992e-03},{ 2.159073e-01,-1.362234e-03},{ 2.145451e-01,-1.562803e-03},{ 2.129823e-01,-1.760531e-03},
 { 2.112218e-01,-1.955253e-03},{ 2.092665e-01,-2.146806e-03},{ 2.071197e-01,-2.335029e-03},{ 2.047847e-01,-2.519764e-03},
 { 2.022649e-01,-2.700854e-03},{ 1.995641e-01,-2.878145e-03},{ 1.966859e-01,-3.051489e-03},{ 1.936344e-01,-3.220738e-03},
 { 1.904137e-01,-3.385747e-03},{ 1.870279e-01,-3.546378e-03},{ 1.834816e-01,-3.702493e-03},{ 1.797791e-01,-3.853959e-03},
 { 1.759251e-01,-4.000648e-03},{ 1.719245e-01,-4.142436e-03},{ 1.677820e-01,-4.279201e-03},{ 1.635028e-01,-4.410829e-03},
 { 1.590920e-01,-4.537209e-03},{ 1.545548e-01,-4.658233e-03},{ 1.498965e-01,-4.773801e-03},{ 1.451227e-01,-4.883817e-03},
 { 1.402389e-01,-4.988189e-03},{ 1.352507e-01,-5.086832e-03},{ 1.301639e-01,-5.179666e-03},{ 1.249842e-01,-5.266615e-03},
 { 1.197176e-01,-5.347611e-03},{ 1.143700e-01,-5.422591e-03},{ 1.089474e-01,-5.491497e-03},{ 1.034559e-01,-5.554279e-03},
 { 9.790165e-02,-5.610890e-03},{ 9.229076e-02,-5.661293e-03},{ 8.662947e-02,-5.705453e-03},{ 8.092401e-02,-5.743345e-03},
 { 7.518067e-02,-5.774949e-03},{ 6.940572e-02,-5.800250e-03},{ 6.360547e-02,-5.819241e-03},{ 5.778623e-02,-5.831922e-03},
 { 5.195431e-02,-5.838298e-03},{ 4.611601e-02,-5.838382e-03},{ 4.027763e-02,-5.832192e-03},{ 3.444543e-02,-5.819753e-03},
 { 2.862568e-02,-5.801098e-03},{ 2.282458e-02,-5.776266e-03},{ 1.704832e-02,-5.745301e-03},{ 1.130302e-02,-5.708254e-03},
 { 5.594762e-03,-5.665184e-03},{-7.042215e-05,-5.616156e-03},{-5.686578e-03,-5.561240e-03},{-1.124782e-02,-5.500513e-03},
 {-1.674833e-02,-5.434059e-03},{-2.218239e-02,-5.361968e-03},{-2.754436e-02,-5.284336e-03},{-3.282869e-02,-5.201263e-03},
 {-3.802996e-02,-5.112859e-03},{-4.314282e-02,-5.019237e-03},{-4.816205e-02,-4.920516e-03},{-5.308257e-02,-4.816820e-03},
 {-5.789939e-02,-4.708282e-03},{-6.260767e-02,-4.595035e-03},{-6.720271e-02,-4.477222e-03},{-7.167993e-02,-4.354988e-03},
 {-7.603492e-02,-4.228484e-03},{-8.026340e-02,-4.097867e-03},{-8.436127e-02,-3.963295e-03},{-8.832456e-02,-3.824934e-03},
 {-9.214950e-02,-3.682952e-03},{-9.583245e-02,-3.537523e-03},{-9.936997e-02,-3.388824e-03},{-1.027588e-01,-3.237033e-03},
 {-1.059958e-01,-3.082336e-03},{-1.090782e-01,-2.924919e-03},{-1.120031e-01,-2.764973e-03},{-1.147681e-01,-2.602689e-03},
 {-1.173707e-01,-2.438264e-03},{-1.198090e-01,-2.271896e-03},{-1.220809e-01,-2.103783e-03},{-1.241847e-01,-1.934128e-03},
 {-1.261188e-01,-1.763134e-03},{-1.278819e-01,-1.591006e-03},{-1.294730e-01,-1.417950e-03},{-1.308909e-01,-1.244173e-03},
 {-1.321351e-01,-1.069882e-03},{-1.332050e-01,-8.952848e-04},{-1.341002e-01,-7.205901e-04},{-1.348208e-01,-5.460056e-04},
 {-1.353668e-01,-3.717392e-04},{-1.357386e-01,-1.979978e-04},{-1.359366e-01,-2.498781e-05},{-1.359616e-01, 1.470857e-04},
 {-1.358145e-01, 3.180188e-04},{-1.354965e-01, 4.876092e-04},{-1.350089e-01, 6.556567e-04},{-1.343532e-01, 8.219628e-04},
 {-1.335312e-01, 9.863316e-04},{-1.325449e-01, 1.148570e-03},{-1.313963e-01, 1.308487e-03},{-1.300878e-01, 1.465895e-03},
 {-1.286219e-01, 1.620610e-03},{-1.270013e-01, 1.772451e-03},{-1.252289e-01, 1.921242e-03},{-1.233076e-01, 2.066810e-03},
 {-1.212408e-01, 2.208985e-03},{-1.190319e-01, 2.347603e-03},{-1.166842e-01, 2.482506e-03},{-1.142017e-01, 2.613537e-03},
 {-1.115882e-01, 2.740546e-03},{-1.088477e-01, 2.863391e-03},{-1.059843e-01, 2.981930e-03},{-1.030023e-01, 3.096031e-03},
 {-9.990631e-02, 3.205565e-03},{-9.670074e-02, 3.310410e-03},{-9.339033e-02, 3.410451e-03},{-8.997988e-02, 3.505578e-03},
 {-8.647430e-02, 3.595688e-03},{-8.287862e-02, 3.680683e-03},{-7.919793e-02, 3.760474e-03},{-7.543746e-02, 3.834977e-03},
 {-7.160248e-02, 3.904115e-03},{-6.769837e-02, 3.967819e-03},{-6.373055e-02, 4.026027e-03},{-5.970452e-02, 4.078682e-03},
 {-5.562584e-02, 4.125737e-03},{-5.150010e-02, 4.167150e-03},{-4.733295e-02, 4.202889e-03},{-4.313006e-02, 4.232925e-03},
 {-3.889714e-02, 4.257242e-03},{-3.463989e-02, 4.275827e-03},{-3.036407e-02, 4.288675e-03},{-2.607539e-02, 4.295792e-03},
 {-2.177960e-02, 4.297187e-03},{-1.748241e-02, 4.292878e-03},{-1.318953e-02, 4.282892e-03},{-8.906643e-03, 4.267261e-03},
 {-4.639382e-03, 4.246026e-03},{-3.933563e-04, 4.219234e-03},{ 3.825878e-03, 4.186940e-03},{ 8.012818e-03, 4.149207e-03},
 { 1.216202e-02, 4.106102e-03},{ 1.626813e-02, 4.057703e-03},{ 2.032583e-02, 4.004091e-03},{ 2.432992e-02, 3.945357e-03},
 { 2.827528e-02, 3.881597e-03},{ 3.215688e-02, 3.812913e-03},{ 3.596979e-02, 3.739414e-03},{ 3.970920e-02, 3.661215e-03},
 { 4.337042e-02, 3.578439e-03},{ 4.694886e-02, 3.491211e-03},{ 5.044007e-02, 3.399664e-03},{ 5.383973e-02, 3.303938e-03},
 { 5.714367e-02, 3.204175e-03},{ 6.034784e-02, 3.100524e-03},{ 6.344837e-02, 2.993140e-03},{ 6.644151e-02, 2.882180e-03},
 { 6.932369e-02, 2.767808e-03},{ 7.209149e-02, 2.650190e-03},{ 7.474169e-02, 2.529499e-03},{ 7.727118e-02, 2.405909e-03},
 { 7.967709e-02, 2.279599e-03},{ 8.195669e-02, 2.150750e-03},{ 8.410744e-02, 2.019549e-03},{ 8.612699e-02, 1.886183e-03},
 { 8.801317e-02, 1.750842e-03},{ 8.976402e-02, 1.613719e-03},{ 9.137773e-02, 1.475009e-03},{ 9.285274e-02, 1.334909e-03},
 { 9.418765e-02, 1.193616e-03},{ 9.538127e-02, 1.051330e-03},{ 9.643260e-02, 9.082513e-04},{ 9.734085e-02, 7.645804e-04},
 { 9.810543e-02, 6.205188e-04},{ 9.872595e-02, 4.762678e-04},{ 9.920222e-02, 3.320286e-04},{ 9.953424e-02, 1.880019e-04},
 { 9.972225e-02, 4.438767e-05},{ 9.976663e-02,-9.861501e-05},{ 9.966802e-02,-2.408085e-04},{ 9.942721e-02,-3.819966e-04},
 { 9.904521e-02,-5.219850e-04},{ 9.852323e-02,-6.605816e-04},{ 9.786265e-02,-7.975965e-04},{ 9.706505e-02,-9.328426e-04},
 { 9.613221e-02,-1.066135e-03},{ 9.506607e-02,-1.197294e-03},{ 9.386878e-02,-1.326141e-03},{ 9.254264e-02,-1.452501e-03},
 { 9.109014e-02,-1.576205e-03},{ 8.951393e-02,-1.697087e-03},{ 8.781684e-02,-1.814986e-03},{ 8.600186e-02,-1.929742e-03},
 { 8.407212e-02,-2.041206e-03},{ 8.203091e-02,-2.149229e-03},{ 7.988168e-02,-2.253670e-03},{ 7.762801e-02,-2.354391e-03},
 { 7.527362e-02,-2.451261e-03},{ 7.282236e-02,-2.544157e-03},{ 7.027820e-02,-2.632957e-03},{ 6.764524e-02,-2.717550e-03},
 { 6.492770e-02,-2.797827e-03},{ 6.212987e-02,-2.873690e-03},{ 5.925618e-02,-2.945043e-03},{ 5.631114e-02,-3.011799e-03},
 { 5.329934e-02,-3.073879e-03},{ 5.022546e-02,-3.131209e-03},{ 4.709425e-02,-3.183721e-03},{ 4.391053e-02,-3.231358e-03},
 { 4.067917e-02,-3.274065e-03},{ 3.740510e-02,-3.311800e-03},{ 3.409330e-02,-3.344523e-03},{ 3.074878e-02,-3.372205e-03},
 { 2.737658e-02,-3.394822e-03},{ 2.398175e-02,-3.412360e-03},{ 2.056939e-02,-3.424809e-03},{ 1.714459e-02,-3.432168e-03},
 { 1.371242e-02,-3.434446e-03},{ 1.027797e-02,-3.431655e-03},{ 6.846316e-03,-3.423817e-03},{ 3.422499e-03,-3.410961e-03},
 { 1.153746e-05,-3.393123e-03},{-3.381585e-03,-3.370345e-03},{-6.751930e-03,-3.342678e-03},{-1.009461e-02,-3.310180e-03},
 {-1.340479e-02,-3.272914e-03},{-1.667770e-02,-3.230952e-03},{-1.990865e-02,-3.184372e-03},{-2.309303e-02,-3.133257e-03},
 {-2.622628e-02,-3.077699e-03},{-2.930398e-02,-3.017795e-03},{-3.232178e-02,-2.953649e-03},{-3.527543e-02,-2.885370e-03},
 {-3.816080e-02,-2.813072e-03},{-4.097387e-02,-2.736878e-03},{-4.371075e-02,-2.656913e-03},{-4.636766e-02,-2.573309e-03},
 {-4.894097e-02,-2.486203e-03},{-5.142717e-02,-2.395736e-03},{-5.382291e-02,-2.302055e-03},{-5.612496e-02,-2.205310e-03},
 {-5.833027e-02,-2.105657e-03},{-6.043593e-02,-2.003253e-03},{-6.243918e-02,-1.898262e-03},{-6.433745e-02,-1.790849e-03},
 {-6.612829e-02,-1.681184e-03},{-6.780948e-02,-1.569439e-03},{-6.937892e-02,-1.455789e-03},{-7.083471e-02,-1.340410e-03},
 {-7.217512e-02,-1.223483e-03},{-7.339860e-02,-1.105188e-03},{-7.450379e-02,-9.857095e-04},{-7.548950e-02,-8.652302e-04},
 {-7.635473e-02,-7.439359e-04},{-7.709866e-02,-6.220127e-04},{-7.772068e-02,-4.996470e-04},{-7.822032e-02,-3.770255e-04},
 {-7.859735e-02,-2.543350e-04},{-7.885168e-02,-1.317616e-04},{-7.898345e-02,-9.491119e-06},{-7.899294e-02, 1.122919e-04},
 {-7.888064e-02, 2.334039e-04},{-7.864724e-02, 3.536628e-04},{-7.829358e-02, 4.728883e-04},{-7.782069e-02, 5.909023e-04},
 {-7.722979e-02, 7.075287e-04},{-7.652226e-02, 8.225940e-04},{-7.569966e-02, 9.359278e-04},{-7.476374e-02, 1.047363e-03},
 {-7.371637e-02, 1.156734e-03},{-7.255964e-02, 1.263881e-03},{-7.129576e-02, 1.368648e-03},{-6.992711e-02, 1.470880e-03},
 {-6.845623e-02, 1.570431e-03},{-6.688580e-02, 1.667155e-03},{-6.521864e-02, 1.760914e-03},{-6.345773e-02, 1.851572e-03},
 {-6.160616e-02, 1.939001e-03},{-5.966716e-02, 2.023077e-03},{-5.764408e-02, 2.103680e-03},{-5.554040e-02, 2.180698e-03},
 {-5.335970e-02, 2.254023e-03},{-5.110568e-02, 2.323555e-03},{-4.878212e-02, 2.389198e-03},{-4.639293e-02, 2.450864e-03},
 {-4.394206e-02, 2.508469e-03},{-4.143359e-02, 2.561939e-03},{-3.887166e-02, 2.611202e-03},{-3.626045e-02, 2.656198e-03},
 {-3.360425e-02, 2.696869e-03},{-3.090739e-02, 2.733167e-03},{-2.817422e-02, 2.765049e-03},{-2.540917e-02, 2.792481e-03},
 {-2.261669e-02, 2.815433e-03},{-1.980126e-02, 2.833885e-03},{-1.696737e-02, 2.847822e-03},{-1.411955e-02, 2.857238e-03},
 {-1.126231e-02, 2.862132e-03},{-8.400179e-03, 2.862511e-03},{-5.537667e-03, 2.858390e-03},{-2.679278e-03, 2.849789e-03},
 { 1.705109e-04, 2.836736e-03},{ 3.007247e-03, 2.819266e-03},{ 5.826512e-03, 2.797421e-03},{ 8.623933e-03, 2.771249e-03},
 { 1.139518e-02, 2.740805e-03},{ 1.413599e-02, 2.706151e-03},{ 1.684214e-02, 2.667355e-03},{ 1.950949e-02, 2.624491e-03},
 { 2.213399e-02, 2.577640e-03},{ 2.471163e-02, 2.526888e-03},{ 2.723851e-02, 2.472328e-03},{ 2.971084e-02, 2.414059e-03},
 { 3.212490e-02, 2.352183e-03},{ 3.447708e-02, 2.286811e-03},{ 3.676390e-02, 2.218057e-03},{ 3.898195e-02, 2.146040e-03},
 { 4.112799e-02, 2.070885e-03},{ 4.319888e-02, 1.992721e-03},{ 4.519160e-02, 1.911682e-03},{ 4.710328e-02, 1.827904e-03},
 { 4.893118e-02, 1.741530e-03},{ 5.067272e-02, 1.652706e-03},{ 5.232542e-02, 1.561579e-03},{ 5.388700e-02, 1.468303e-03},
 { 5.535530e-02, 1.373032e-03},{ 5.672833e-02, 1.275924e-03},{ 5.800426e-02, 1.177140e-03},{ 5.918140e-02, 1.076843e-03},
 { 6.025824e-02, 9.751969e-04},{ 6.123344e-02, 8.723687e-04},{ 6.210581e-02, 7.685260e-04},{ 6.287433e-02, 6.638379e-04},
 { 6.353817e-02, 5.584746e-04},{ 6.409665e-02, 4.526065e-04},{ 6.454925e-02, 3.464046e-04},{ 6.489566e-02, 2.400401e-04},
 { 6.513570e-02, 1.336839e-04},{ 6.526938e-02, 2.750632e-05},{ 6.529689e-02,-7.832283e-05},{ 6.521856e-02,-1.836348e-04},
 { 6.503493e-02,-2.882623e-04},{ 6.474667e-02,-3.920391e-04},{ 6.435463e-02,-4.948013e-04},{ 6.385983e-02,-5.963868e-04},
 { 6.326344e-02,-6.966357e-04},{ 6.256680e-02,-7.953908e-04},{ 6.177141e-02,-8.924977e-04},{ 6.087892e-02,-9.878051e-04},
 { 5.989111e-02,-1.081165e-03},{ 5.880995e-02,-1.172432e-03},{ 5.763751e-02,-1.261467e-03},{ 5.637605e-02,-1.348131e-03},
 { 5.502792e-02,-1.432293e-03},{ 5.359562e-02,-1.513825e-03},{ 5.208180e-02,-1.592601e-03},{ 5.048920e-02,-1.668504e-03},
 { 4.882069e-02,-1.741420e-03},{ 4.707927e-02,-1.811239e-03},{ 4.526803e-02,-1.877858e-03},{ 4.339018e-02,-1.941178e-03},
 { 4.144900e-02,-2.001109e-03},{ 3.944789e-02,-2.057561e-03},{ 3.739033e-02,-2.110455e-03},{ 3.527987e-02,-2.159716e-03},
 { 3.312016e-02,-2.205274e-03},{ 3.091488e-02,-2.247068e-03},{ 2.866782e-02,-2.285039e-03},{ 2.638278e-02,-2.319140e-03},
 { 2.406364e-02,-2.349325e-03},{ 2.171431e-02,-2.375558e-03},{ 1.933875e-02,-2.397809e-03},{ 1.694094e-02,-2.416052e-03},
 { 1.452489e-02,-2.430271e-03},{ 1.209462e-02,-2.440455e-03},{ 9.654167e-03,-2.446599e-03},{ 7.207568e-03,-2.448706e-03},
 { 4.758861e-03,-2.446786e-03},{ 2.312076e-03,-2.440852e-03},{-1.287765e-04,-2.430928e-03},{-2.559705e-03,-2.417042e-03},
 {-4.976747e-03,-2.399229e-03},{-7.375976e-03,-2.377530e-03},{-9.753506e-03,-2.351993e-03},{-1.210550e-02,-2.322671e-03},
 {-1.442817e-02,-2.289623e-03},{-1.671779e-02,-2.252917e-03},{-1.897071e-02,-2.212623e-03},{-2.118333e-02,-2.168818e-03},
 {-2.335215e-02,-2.121586e-03},{-2.547374e-02,-2.071014e-03},{-2.754475e-02,-2.017197e-03},{-2.956195e-02,-1.960231e-03},
 {-3.152218e-02,-1.900222e-03},{-3.342240e-02,-1.837278e-03},{-3.525968e-02,-1.771510e-03},{-3.703119e-02,-1.703037e-03},
 {-3.873423e-02,-1.631979e-03},{-4.036621e-02,-1.558463e-03},{-4.192467e-02,-1.482616e-03},{-4.340728e-02,-1.404572e-03},
 {-4.481186e-02,-1.324466e-03},{-4.613632e-02,-1.242438e-03},{-4.737876e-02,-1.158628e-03},{-4.853739e-02,-1.073181e-03},
 {-4.961057e-02,-9.862443e-04},{-5.059681e-02,-8.979658e-04},{-5.149478e-02,-8.084963e-04},{-5.230328e-02,-7.179878e-04},
 {-5.302126e-02,-6.265940e-04},{-5.364786e-02,-5.344691e-04},{-5.418233e-02,-4.417687e-04},{-5.462410e-02,-3.486486e-04},
 {-5.497274e-02,-2.552649e-04},{-5.522801e-02,-1.617739e-04},{-5.538978e-02,-6.833164e-05},{-5.545811e-02, 2.490647e-05},
 {-5.543321e-02, 1.177856e-04},{-5.531542e-02, 2.101520e-04},{-5.510527e-02, 3.018532e-04},{-5.480342e-02, 3.927380e-04},
 {-5.441068e-02, 4.826573e-04},{-5.392802e-02, 5.714638e-04},{-5.335656e-02, 6.590124e-04},{-5.269755e-02, 7.451606e-04},
 {-5.195239e-02, 8.297685e-04},{-5.112262e-02, 9.126991e-04},{-5.020992e-02, 9.938187e-04},{-4.921610e-02, 1.072997e-03},
 {-4.814310e-02, 1.150107e-03},{-4.699300e-02, 1.225026e-03},{-4.576797e-02, 1.297634e-03},{-4.447034e-02, 1.367817e-03},
 {-4.310252e-02, 1.435464e-03},{-4.166705e-02, 1.500470e-03},{-4.016658e-02, 1.562733e-03},{-3.860385e-02, 1.622156e-03},
 {-3.698169e-02, 1.678649e-03},{-3.530305e-02, 1.732124e-03},{-3.357092e-02, 1.782501e-03},{-3.178842e-02, 1.829705e-03},
 {-2.995872e-02, 1.873665e-03},{-2.808505e-02, 1.914316e-03},{-2.617074e-02, 1.951601e-03},{-2.421913e-02, 1.985467e-03},
 {-2.223367e-02, 2.015865e-03},{-2.021780e-02, 2.042756e-03},{-1.817505e-02, 2.066105e-03},{-1.610894e-02, 2.085881e-03},
 {-1.402306e-02, 2.102064e-03},{-1.192100e-02, 2.114635e-03},{-9.806362e-03, 2.123584e-03},{-7.682778e-03, 2.128907e-03},
 {-5.553871e-03, 2.130605e-03},{-3.423266e-03, 2.128687e-03},{-1.294579e-03, 2.123165e-03},{ 8.285865e-04, 2.114061e-03},
 { 2.942647e-03, 2.101399e-03},{ 5.044047e-03, 2.085212e-03},{ 7.129259e-03, 2.065538e-03},{ 9.194797e-03, 2.042419e-03},
 { 1.123722e-02, 2.015906e-03},{ 1.325312e-02, 1.986054e-03},{ 1.523918e-02, 1.952921e-03},{ 1.719210e-02, 1.916575e-03},
 { 1.910867e-02, 1.877087e-03},{ 2.098576e-02, 1.834533e-03},{ 2.282029e-02, 1.788993e-03},{ 2.460929e-02, 1.740555e-03},
 { 2.634984e-02, 1.689308e-03},{ 2.803915e-02, 1.635349e-03},{ 2.967450e-02, 1.578777e-03},{ 3.125328e-02, 1.519696e-03},
 { 3.277297e-02, 1.458213e-03},{ 3.423118e-02, 1.394441e-03},{ 3.562563e-02, 1.328494e-03},{ 3.695412e-02, 1.260492e-03},
 { 3.821461e-02, 1.190556e-03},{ 3.940517e-02, 1.118812e-03},{ 4.052398e-02, 1.045386e-03},{ 4.156937e-02, 9.704094e-04},
 { 4.253978e-02, 8.940142e-04},{ 4.343379e-02, 8.163350e-04},{ 4.425012e-02, 7.375083e-04},{ 4.498763e-02, 6.576721e-04},
 { 4.564531e-02, 5.769658e-04},{ 4.622227e-02, 4.955299e-04},{ 4.671780e-02, 4.135058e-04},{ 4.713131e-02, 3.310356e-04},
 { 4.746234e-02, 2.482617e-04},{ 4.771060e-02, 1.653266e-04},{ 4.787593e-02, 8.237300e-05},{ 4.795830e-02,-4.570467e-07},
 { 4.795785e-02,-8.302191e-05},{ 4.787482e-02,-1.651808e-04},{ 4.770964e-02,-2.467940e-04},{ 4.746285e-02,-3.277231e-04},
 { 4.713513e-02,-4.078311e-04},{ 4.672730e-02,-4.869830e-04},{ 4.624031e-02,-5.650455e-04},{ 4.567527e-02,-6.418876e-04},
 { 4.503338e-02,-7.173810e-04},{ 4.431600e-02,-7.913997e-04},{ 4.352460e-02,-8.638206e-04},{ 4.266078e-02,-9.345238e-04},
 { 4.172625e-02,-1.003393e-03},{ 4.072286e-02,-1.070314e-03},{ 3.965255e-02,-1.135177e-03},{ 3.851737e-02,-1.197878e-03},
 { 3.731949e-02,-1.258314e-03},{ 3.606118e-02,-1.316387e-03},{ 3.474479e-02,-1.372005e-03},{ 3.337279e-02,-1.425077e-03},
 { 3.194771e-02,-1.475521e-03},{ 3.047219e-02,-1.523256e-03},{ 2.894893e-02,-1.568208e-03},{ 2.738073e-02,-1.610307e-03},
 { 2.577042e-02,-1.649489e-03},{ 2.412093e-02,-1.685693e-03},{ 2.243524e-02,-1.718868e-03},{ 2.071637e-02,-1.748962e-03},
 { 1.896741e-02,-1.775934e-03},{ 1.719147e-02,-1.799746e-03},{ 1.539173e-02,-1.820364e-03},{ 1.357136e-02,-1.837764e-03},
 { 1.173360e-02,-1.851923e-03},{ 9.881676e-03,-1.862826e-03},{ 8.018850e-03,-1.870465e-03},{ 6.148385e-03,-1.874834e-03},
 { 4.273552e-03,-1.875935e-03},{ 2.397616e-03,-1.873777e-03},{ 5.238393e-04,-1.868371e-03},{-1.344532e-03,-1.859737e-03},
 {-3.204269e-03,-1.847898e-03},{-5.052167e-03,-1.832885e-03},{-6.885053e-03,-1.814732e-03},{-8.699784e-03,-1.793479e-03},
 {-1.049326e-02,-1.769173e-03},{-1.226244e-02,-1.741864e-03},{-1.400430e-02,-1.711608e-03},{-1.571591e-02,-1.678466e-03},
 {-1.739437e-02,-1.642503e-03},{-1.903688e-02,-1.603791e-03},{-2.064067e-02,-1.562404e-03},{-2.220307e-02,-1.518422e-03},
 {-2.372149e-02,-1.471929e-03},{-2.519342e-02,-1.423013e-03},{-2.661644e-02,-1.371765e-03},{-2.798820e-02,-1.318282e-03},
 {-2.930648e-02,-1.262664e-03},{-3.056915e-02,-1.205012e-03},{-3.177416e-02,-1.145433e-03},{-3.291959e-02,-1.084037e-03},
 {-3.400363e-02,-1.020936e-03},{-3.502457e-02,-9.562438e-04},{-3.598081e-02,-8.900790e-04},{-3.687089e-02,-8.225608e-04},
 {-3.769345e-02,-7.538109e-04},{-3.844726e-02,-6.839528e-04},{-3.913121e-02,-6.131116e-04},{-3.974432e-02,-5.414139e-04},
 {-4.028574e-02,-4.689874e-04},{-4.075473e-02,-3.959608e-04},{-4.115069e-02,-3.224633e-04},{-4.147315e-02,-2.486250e-04},
 {-4.172178e-02,-1.745760e-04},{-4.189635e-02,-1.004463e-04},{-4.199680e-02,-2.636613e-05},{-4.202316e-02, 4.753510e-05},
 {-4.197563e-02, 1.211284e-04},{-4.185450e-02, 1.942857e-04},{-4.166021e-02, 2.668801e-04},{-4.139333e-02, 3.387859e-04},
 {-4.105455e-02, 4.098789e-04},{-4.064467e-02, 4.800368e-04},{-4.016463e-02, 5.491391e-04},{-3.961549e-02, 6.170675e-04},
 {-3.899843e-02, 6.837061e-04},{-3.831472e-02, 7.489415e-04},{-3.756578e-02, 8.126631e-04},{-3.675312e-02, 8.747631e-04},
 {-3.587835e-02, 9.351371e-04},{-3.494321e-02, 9.936837e-04},{-3.394953e-02, 1.050305e-03},{-3.289923e-02, 1.104907e-03},
 {-3.179432e-02, 1.157400e-03},{-3.063692e-02, 1.207696e-03},{-2.942922e-02, 1.255714e-03},{-2.817351e-02, 1.301374e-03},
 {-2.687214e-02, 1.344605e-03},{-2.552753e-02, 1.385335e-03},{-2.414220e-02, 1.423501e-03},{-2.271869e-02, 1.459042e-03},
 {-2.125965e-02, 1.491903e-03},{-1.976775e-02, 1.522033e-03},{-1.824572e-02, 1.549388e-03},{-1.669633e-02, 1.573925e-03},
 {-1.512240e-02, 1.595611e-03},{-1.352679e-02, 1.614414e-03},{-1.191238e-02, 1.630309e-03},{-1.028207e-02, 1.643277e-03},
 {-8.638793e-03, 1.653302e-03},{-6.985491e-03, 1.660375e-03},{-5.325116e-03, 1.664492e-03},{-3.660624e-03, 1.665654e-03},
 {-1.994970e-03, 1.663866e-03},{-3.311041e-04, 1.659140e-03},{ 1.328036e-03, 1.651493e-03},{ 2.979529e-03, 1.640946e-03},
 { 4.620474e-03, 1.627525e-03},{ 6.247999e-03, 1.611263e-03},{ 7.859262e-03, 1.592196e-03},{ 9.451458e-03, 1.570365e-03},
 { 1.102182e-02, 1.545817e-03},{ 1.256764e-02, 1.518602e-03},{ 1.408624e-02, 1.488777e-03},{ 1.557502e-02, 1.456401e-03},
 { 1.703142e-02, 1.421538e-03},{ 1.845296e-02, 1.384258e-03},{ 1.983722e-02, 1.344632e-03},{ 2.118185e-02, 1.302739e-03},
 { 2.248459e-02, 1.258657e-03},{ 2.374324e-02, 1.212471e-03},{ 2.495571e-02, 1.164269e-03},{ 2.611998e-02, 1.114143e-03},
 { 2.723413e-02, 1.062185e-03},{ 2.829631e-02, 1.008494e-03},{ 2.930481e-02, 9.531697e-04},{ 3.025798e-02, 8.963145e-04},
 { 3.115429e-02, 8.380337e-04},{ 3.199232e-02, 7.784347e-04},{ 3.277076e-02, 7.176271e-04},{ 3.348839e-02, 6.557221e-04},
 { 3.414411e-02, 5.928329e-04},{ 3.473694e-02, 5.290739e-04},{ 3.526601e-02, 4.645609e-04},{ 3.573058e-02, 3.994106e-04},
 { 3.612999e-02, 3.337408e-04},{ 3.646373e-02, 2.676696e-04},{ 3.673140e-02, 2.013158e-04},{ 3.693271e-02, 1.347982e-04},
 { 3.706751e-02, 6.823562e-05},{ 3.713575e-02, 1.746779e-06},{ 3.713749e-02,-6.455013e-05},{ 3.707294e-02,-1.305375e-04},
 { 3.694240e-02,-1.960987e-04},{ 3.674631e-02,-2.611180e-04},{ 3.648519e-02,-3.254811e-04},{ 3.615971e-02,-3.890749e-04},
 { 3.577063e-02,-4.517881e-04},{ 3.531884e-02,-5.135114e-04},{ 3.480533e-02,-5.741373e-04},{ 3.423120e-02,-6.335607e-04},
 { 3.359763e-02,-6.916788e-04},{ 3.290596e-02,-7.483914e-04},{ 3.215756e-02,-8.036012e-04},{ 3.135396e-02,-8.572136e-04},
 { 3.049675e-02,-9.091373e-04},{ 2.958761e-02,-9.592842e-04},{ 2.862833e-02,-1.007569e-03},{ 2.762076e-02,-1.053912e-03},
 { 2.656685e-02,-1.098234e-03},{ 2.546861e-02,-1.140462e-03},{ 2.432815e-02,-1.180526e-03},{ 2.314763e-02,-1.218360e-03},
 { 2.192927e-02,-1.253903e-03},{ 2.067536e-02,-1.287098e-03},{ 1.938826e-02,-1.317891e-03},{ 1.807037e-02,-1.346234e-03},
 { 1.672414e-02,-1.372083e-03},{ 1.535206e-02,-1.395398e-03},{ 1.395666e-02,-1.416145e-03},{ 1.254051e-02,-1.434292e-03},
 { 1.110622e-02,-1.449816e-03},{ 9.656405e-03,-1.462695e-03},{ 8.193710e-03,-1.472913e-03},{ 6.720797e-03,-1.480459e-03},
 { 5.240338e-03,-1.485328e-03},{ 3.755010e-03,-1.487516e-03},{ 2.267494e-03,-1.487029e-03},{ 7.804651e-04,-1.483873e-03},
 {-7.034084e-04,-1.478063e-03},{-2.181471e-03,-1.469615e-03},{-3.651086e-03,-1.458552e-03},{-5.109638e-03,-1.444901e-03},
 {-6.554539e-03,-1.428693e-03},{-7.983232e-03,-1.409964e-03},{-9.393196e-03,-1.388756e-03},{-1.078195e-02,-1.365112e-03},
 {-1.214706e-02,-1.339082e-03},{-1.348615e-02,-1.310719e-03},{-1.479686e-02,-1.280080e-03},{-1.607694e-02,-1.247227e-03},
 {-1.732417e-02,-1.212225e-03},{-1.853640e-02,-1.175142e-03},{-1.971154e-02,-1.136051e-03},{-2.084759e-02,-1.095027e-03},
 {-2.194262e-02,-1.052150e-03},{-2.299477e-02,-1.007502e-03},{-2.400227e-02,-9.611672e-04},{-2.496343e-02,-9.132347e-04},
 {-2.587667e-02,-8.637948e-04},{-2.674046e-02,-8.129404e-04},{-2.755340e-02,-7.607671e-04},{-2.831417e-02,-7.073724e-04},
 {-2.902154e-02,-6.528558e-04},{-2.967440e-02,-5.973186e-04},{-3.027172e-02,-5.408637e-04},{-3.081258e-02,-4.835952e-04},
 {-3.129618e-02,-4.256186e-04},{-3.172180e-02,-3.670404e-04},{-3.208884e-02,-3.079679e-04},{-3.239680e-02,-2.485089e-04},
 {-3.264531e-02,-1.887718e-04},{-3.283409e-02,-1.288651e-04},{-3.296295e-02,-6.889741e-05},{-3.303185e-02,-8.977068e-06},
 {-3.304082e-02, 5.078785e-05},{-3.299004e-02, 1.102899e-04},{-3.287975e-02, 1.694222e-04},{-3.271032e-02, 2.280791e-04},
 {-3.248225e-02, 2.861558e-04},{-3.219609e-02, 3.435491e-04},{-3.185254e-02, 4.001569e-04},{-3.145238e-02, 4.558792e-04},
 {-3.099650e-02, 5.106176e-04},{-3.048589e-02, 5.642758e-04},{-2.992161e-02, 6.167597e-04},{-2.930485e-02, 6.679776e-04},
 {-2.863687e-02, 7.178401e-04},{-2.791903e-02, 7.662609e-04},{-2.715277e-02, 8.131561e-04},{-2.633962e-02, 8.584449e-04},
 {-2.548117e-02, 9.020499e-04},{-2.457912e-02, 9.438965e-04},{-2.363523e-02, 9.839138e-04},{-2.265131e-02, 1.022034e-03},
 {-2.162928e-02, 1.058194e-03},{-2.057108e-02, 1.092332e-03},{-1.947875e-02, 1.124394e-03},{-1.835436e-02, 1.154325e-03},
 {-1.720003e-02, 1.182078e-03},{-1.601795e-02, 1.207608e-03},{-1.481035e-02, 1.230875e-03},{-1.357947e-02, 1.251843e-03},
 {-1.232763e-02, 1.270480e-03},{-1.105715e-02, 1.286758e-03},{-9.770391e-03, 1.300655e-03},{-8.469737e-03, 1.312151e-03},
 {-7.157586e-03, 1.321232e-03},{-5.836354e-03, 1.327888e-03},{-4.508465e-03, 1.332115e-03},{-3.176351e-03, 1.333909e-03},
 {-1.842442e-03, 1.333275e-03},{-5.091663e-04, 1.330221e-03},{ 8.210550e-04, 1.324759e-03},{ 2.145814e-03, 1.316904e-03},
 { 3.462718e-03, 1.306678e-03},{ 4.769396e-03, 1.294106e-03},{ 6.063502e-03, 1.279216e-03},{ 7.342718e-03, 1.262043e-03},
 { 8.604762e-03, 1.242623e-03},{ 9.847385e-03, 1.220998e-03},{ 1.106838e-02, 1.197214e-03},{ 1.226560e-02, 1.171318e-03},
 { 1.343691e-02, 1.143364e-03},{ 1.458028e-02, 1.113409e-03},{ 1.569369e-02, 1.081512e-03},{ 1.677520e-02, 1.047737e-03},
 { 1.782294e-02, 1.012149e-03},{ 1.883509e-02, 9.748197e-04},{ 1.980991e-02, 9.358204e-04},{ 2.074573e-02, 8.952270e-04},
 { 2.164095e-02, 8.531177e-04},{ 2.249407e-02, 8.095732e-04},{ 2.330364e-02, 7.646768e-04},{ 2.406832e-02, 7.185139e-04},
 { 2.478684e-02, 6.711719e-04},{ 2.545801e-02, 6.227404e-04},{ 2.608075e-02, 5.733105e-04},{ 2.665406e-02, 5.229750e-04},
 { 2.717703e-02, 4.718281e-04},{ 2.764886e-02, 4.199653e-04},{ 2.806883e-02, 3.674831e-04},{ 2.843631e-02, 3.144788e-04},
 { 2.875079e-02, 2.610505e-04},{ 2.901184e-02, 2.072969e-04},{ 2.921914e-02, 1.533169e-04},{ 2.937245e-02, 9.920960e-05},
 { 2.947166e-02, 4.507410e-05},{ 2.951674e-02,-8.990709e-06},{ 2.950775e-02,-6.288632e-05},{ 2.944486e-02,-1.165148e-04},
 { 2.932834e-02,-1.697789e-04},{ 2.915857e-02,-2.225823e-04},{ 2.893598e-02,-2.748299e-04},{ 2.866115e-02,-3.264277e-04},
 { 2.833473e-02,-3.772831e-04},{ 2.795744e-02,-4.273053e-04},{ 2.753014e-02,-4.764050e-04},{ 2.705373e-02,-5.244951e-04},
 { 2.652924e-02,-5.714902e-04},{ 2.595775e-02,-6.173075e-04},{ 2.534044e-02,-6.618663e-04},{ 2.467857e-02,-7.050885e-04},
 { 2.397348e-02,-7.468987e-04},{ 2.322659e-02,-7.872242e-04},{ 2.243936e-02,-8.259952e-04},{ 2.161337e-02,-8.631449e-04},
 { 2.075022e-02,-8.986098e-04},{ 1.985161e-02,-9.323295e-04},{ 1.891928e-02,-9.642469e-04},{ 1.795504e-02,-9.943085e-04},
 { 1.696073e-02,-1.022464e-03},{ 1.593826e-02,-1.048668e-03},{ 1.488960e-02,-1.072876e-03},{ 1.381672e-02,-1.095050e-03},
 { 1.272167e-02,-1.115156e-03},{ 1.160651e-02,-1.133160e-03},{ 1.047335e-02,-1.149037e-03},{ 9.324316e-03,-1.162763e-03},
 { 8.161553e-03,-1.174319e-03},{ 6.987234e-03,-1.183688e-03},{ 5.803545e-03,-1.190861e-03},{ 4.612685e-03,-1.195829e-03},
 { 3.416855e-03,-1.198590e-03},{ 2.218266e-03,-1.199144e-03},{ 1.019122e-03,-1.197496e-03},{-1.783748e-04,-1.193656e-03},
 {-1.372031e-03,-1.187636e-03},{-2.559667e-03,-1.179453e-03},{-3.739119e-03,-1.169128e-03},{-4.908247e-03,-1.156686e-03},
 {-6.064933e-03,-1.142154e-03},{-7.207087e-03,-1.125567e-03},{-8.332654e-03,-1.106959e-03},{-9.439613e-03,-1.086370e-03},
 {-1.052598e-02,-1.063844e-03},{-1.158983e-02,-1.039426e-03},{-1.262925e-02,-1.013167e-03},{-1.364242e-02,-9.851206e-04},
 {-1.462754e-02,-9.553424e-04},{-1.558288e-02,-9.238919e-04},{-1.650677e-02,-8.908316e-04},{-1.739761e-02,-8.562266e-04},
 {-1.825383e-02,-8.201445e-04},{-1.907398e-02,-7.826558e-04},{-1.985663e-02,-7.438331e-04},{-2.060047e-02,-7.037515e-04},
 {-2.130422e-02,-6.624880e-04},{-2.196671e-02,-6.201218e-04},{-2.258683e-02,-5.767338e-04},{-2.316356e-02,-5.324065e-04},
 {-2.369597e-02,-4.872240e-04},{-2.418319e-02,-4.412719e-04},{-2.462446e-02,-3.946367e-04},{-2.501910e-02,-3.474061e-04},
 {-2.536651e-02,-2.996688e-04},{-2.566618e-02,-2.515139e-04},{-2.591769e-02,-2.030312e-04},{-2.612072e-02,-1.543110e-04},
 {-2.627503e-02,-1.054436e-04},{-2.638048e-02,-5.651936e-05},{-2.643699e-02,-7.628626e-06},{-2.644462e-02, 4.113862e-05},
 {-2.640348e-02, 8.969287e-05},{-2.631379e-02, 1.379452e-04},{-2.617585e-02, 1.858075e-04},{-2.599004e-02, 2.331926e-04},
 {-2.575685e-02, 2.800145e-04},{-2.547683e-02, 3.261883e-04},{-2.515064e-02, 3.716306e-04},{-2.477901e-02, 4.162597e-04},
 {-2.436275e-02, 4.599953e-04},{-2.390276e-02, 5.027593e-04},{-2.340000e-02, 5.444754e-04},{-2.285552e-02, 5.850695e-04},
 {-2.227045e-02, 6.244696e-04},{-2.164598e-02, 6.626064e-04},{-2.098338e-02, 6.994128e-04},{-2.028396e-02, 7.348245e-04},
 {-1.954914e-02, 7.687799e-04},{-1.878036e-02, 8.012203e-04},{-1.797914e-02, 8.320898e-04},{-1.714705e-02, 8.613357e-04},
 {-1.628571e-02, 8.889084e-04},{-1.539681e-02, 9.147615e-04},{-1.448204e-02, 9.388519e-04},{-1.354319e-02, 9.611398e-04},
 {-1.258205e-02, 9.815890e-04},{-1.160046e-02, 1.000167e-03},{-1.060030e-02, 1.016843e-03},{-9.583454e-03, 1.031594e-03},
 {-8.551860e-03, 1.044396e-03},{-7.507465e-03, 1.055230e-03},{-6.452234e-03, 1.064084e-03},{-5.388151e-03, 1.070944e-03},
 {-4.317206e-03, 1.075805e-03},{-3.241401e-03, 1.078662e-03},{-2.162739e-03, 1.079516e-03},{-1.083223e-03, 1.078370e-03},
 {-4.852918e-06, 1.075233e-03},{ 1.070380e-03, 1.070114e-03},{ 2.140494e-03, 1.063030e-03},{ 3.203525e-03, 1.053999e-03},
 { 4.257523e-03, 1.043041e-03},{ 5.300565e-03, 1.030184e-03},{ 6.330749e-03, 1.015456e-03},{ 7.346205e-03, 9.988896e-04},
 { 8.345095e-03, 9.805199e-04},{ 9.325615e-03, 9.603861e-04},{ 1.028600e-02, 9.385303e-04},{ 1.122453e-02, 9.149977e-04},
 { 1.213953e-02, 8.898364e-04},{ 1.302937e-02, 8.630974e-04},{ 1.389246e-02, 8.348346e-04},{ 1.472730e-02, 8.051044e-04},
 { 1.553240e-02, 7.739660e-04},{ 1.630637e-02, 7.414809e-04},{ 1.704785e-02, 7.077130e-04},{ 1.775556e-02, 6.727283e-04},
 { 1.842829e-02, 6.365950e-04},{ 1.906488e-02, 5.993832e-04},{ 1.966427e-02, 5.611649e-04},{ 2.022543e-02, 5.220137e-04},
 { 2.074745e-02, 4.820046e-04},{ 2.122945e-02, 4.412144e-04},{ 2.167067e-02, 3.997206e-04},{ 2.207039e-02, 3.576024e-04},
 { 2.242799e-02, 3.149394e-04},{ 2.274293e-02, 2.718123e-04},{ 2.301474e-02, 2.283025e-04},{ 2.324304e-02, 1.844917e-04},
 { 2.342753e-02, 1.404620e-04},{ 2.356800e-02, 9.629587e-05},{ 2.366429e-02, 5.207557e-05},{ 2.371637e-02, 7.883362e-06},
 { 2.372425e-02,-3.619876e-05},{ 2.368805e-02,-8.008924e-05},{ 2.360796e-02,-1.237071e-04},{ 2.348426e-02,-1.669720e-04},
 { 2.331728e-02,-2.098047e-04},{ 2.310748e-02,-2.521266e-04},{ 2.285535e-02,-2.938606e-04},{ 2.256149e-02,-3.349307e-04},
 { 2.222656e-02,-3.752625e-04},{ 2.185130e-02,-4.147829e-04},{ 2.143652e-02,-4.534207e-04},{ 2.098310e-02,-4.911066e-04},
 { 2.049199e-02,-5.277730e-04},{ 1.996422e-02,-5.633547e-04},{ 1.940086e-02,-5.977883e-04},{ 1.880307e-02,-6.310130e-04},
 { 1.817206e-02,-6.629703e-04},{ 1.750909e-02,-6.936043e-04},{ 1.681549e-02,-7.228616e-04},{ 1.609262e-02,-7.506915e-04},
 { 1.534193e-02,-7.770461e-04},{ 1.456489e-02,-8.018805e-04},{ 1.376301e-02,-8.251526e-04},{ 1.293785e-02,-8.468234e-04},
 { 1.209103e-02,-8.668569e-04},{ 1.122417e-02,-8.852204e-04},{ 1.033895e-02,-9.018841e-04},{ 9.437068e-03,-9.168218e-04},
 { 8.520246e-03,-9.300104e-04},{ 7.590236e-03,-9.414301e-04},{ 6.648806e-03,-9.510644e-04},{ 5.697741e-03,-9.589004e-04},
 { 4.738841e-03,-9.649284e-04},{ 3.773912e-03,-9.691421e-04},{ 2.804770e-03,-9.715387e-04},{ 1.833232e-03,-9.721186e-04},
 { 8.611131e-04,-9.708857e-04},{-1.097726e-04,-9.678474e-04},{-1.077620e-03,-9.630143e-04},{-2.040634e-03,-9.564003e-04},
 {-2.997035e-03,-9.480226e-04},{-3.945057e-03,-9.379016e-04},{-4.882959e-03,-9.260611e-04},{-5.809020e-03,-9.125278e-04},
 {-6.721548e-03,-8.973317e-04},{-7.618879e-03,-8.805056e-04},{-8.499385e-03,-8.620853e-04},{-9.361470e-03,-8.421097e-04},
 {-1.020358e-02,-8.206203e-04},{-1.102420e-02,-7.976613e-04},{-1.182186e-02,-7.732796e-04},{-1.259514e-02,-7.475246e-04},
 {-1.334267e-02,-7.204481e-04},{-1.406311e-02,-6.921044e-04},{-1.475522e-02,-6.625497e-04},{-1.541777e-02,-6.318426e-04},
 {-1.604961e-02,-6.000436e-04},{-1.664965e-02,-5.672151e-04},{-1.721687e-02,-5.334211e-04},{-1.775029e-02,-4.987274e-04},
 {-1.824902e-02,-4.632013e-04},{-1.871222e-02,-4.269115e-04},{-1.913913e-02,-3.899277e-04},{-1.952906e-02,-3.523211e-04},
 {-1.988138e-02,-3.141635e-04},{-2.019554e-02,-2.755277e-04},{-2.047107e-02,-2.364873e-04},{-2.070756e-02,-1.971163e-04},
 {-2.090467e-02,-1.574891e-04},{-2.106216e-02,-1.176806e-04},{-2.117984e-02,-7.776567e-05},{-2.125761e-02,-3.781911e-05},
 {-2.129543e-02, 2.084269e-06},{-2.129334e-02, 4.187001e-05},{-2.125147e-02, 8.146407e-05},{-2.117001e-02, 1.207929e-04},
 {-2.104922e-02, 1.597838e-04},{-2.088943e-02, 1.983648e-04},{-2.069107e-02, 2.364648e-04},{-2.045460e-02, 2.740139e-04},
 {-2.018059e-02, 3.109434e-04},{-1.986965e-02, 3.471859e-04},{-1.952246e-02, 3.826757e-04},{-1.913979e-02, 4.173483e-04},
 {-1.872244e-02, 4.511411e-04},{-1.827130e-02, 4.839935e-04},{-1.778730e-02, 5.158464e-04},{-1.727146e-02, 5.466431e-04},
 {-1.672481e-02, 5.763289e-04},{-1.614848e-02, 6.048512e-04},{-1.554363e-02, 6.321600e-04},{-1.491147e-02, 6.582075e-04},
 {-1.425327e-02, 6.829484e-04},{-1.357032e-02, 7.063401e-04},{-1.286398e-02, 7.283424e-04},{-1.213563e-02, 7.489181e-04},
 {-1.138672e-02, 7.680326e-04},{-1.061868e-02, 7.856541e-04},{-9.833029e-03, 8.017539e-04},{-9.031276e-03, 8.163059e-04},
 {-8.214970e-03, 8.292873e-04},{-7.385682e-03, 8.406781e-04},{-6.545004e-03, 8.504614e-04},{-5.694543e-03, 8.586233e-04},
 {-4.835920e-03, 8.651531e-04},{-3.970766e-03, 8.700431e-04},{-3.100723e-03, 8.732886e-04},{-2.227435e-03, 8.748883e-04},
 {-1.352546e-03, 8.748437e-04},{-4.777028e-04, 8.731595e-04},{ 3.954567e-04, 8.698433e-04},{ 1.265300e-03, 8.649061e-04},
 { 2.130206e-03, 8.583616e-04},{ 2.988568e-03, 8.502265e-04},{ 3.838794e-03, 8.405206e-04},{ 4.679315e-03, 8.292664e-04},
 { 5.508581e-03, 8.164895e-04},{ 6.325071e-03, 8.022179e-04},{ 7.127289e-03, 7.864828e-04},{ 7.913771e-03, 7.693177e-04},
 { 8.683089e-03, 7.507588e-04},{ 9.433848e-03, 7.308449e-04},{ 1.016469e-02, 7.096171e-04},{ 1.087431e-02, 6.871190e-04},
 { 1.156143e-02, 6.633963e-04},{ 1.222483e-02, 6.384971e-04},{ 1.286332e-02, 6.124713e-04},{ 1.347579e-02, 5.853709e-04},
 { 1.406116e-02, 5.572500e-04},{ 1.461841e-02, 5.281640e-04},{ 1.514658e-02, 4.981705e-04},{ 1.564475e-02, 4.673282e-04},
 { 1.611208e-02, 4.356975e-04},{ 1.654777e-02, 4.033399e-04},{ 1.695111e-02, 3.703184e-04},{ 1.732143e-02, 3.366968e-04},
 { 1.765813e-02, 3.025399e-04},{ 1.796067e-02, 2.679135e-04},{ 1.822858e-02, 2.328838e-04},{ 1.846147e-02, 1.975180e-04},
 { 1.865899e-02, 1.618834e-04},{ 1.882087e-02, 1.260476e-04},{ 1.894692e-02, 9.007872e-05},{ 1.903699e-02, 5.404464e-05},
 { 1.909104e-02, 1.801328e-05},{ 1.910905e-02,-1.794761e-05},{ 1.909111e-02,-5.377063e-05},{ 1.903733e-02,-8.938882e-05},
 { 1.894795e-02,-1.247358e-04},{ 1.882321e-02,-1.597458e-04},{ 1.866346e-02,-1.943540e-04},{ 1.846911e-02,-2.284965e-04},
 { 1.824061e-02,-2.621103e-04},{ 1.797850e-02,-2.951337e-04},{ 1.768337e-02,-3.275062e-04},{ 1.735586e-02,-3.591689e-04},
 { 1.699669e-02,-3.900641e-04},{ 1.660663e-02,-4.201358e-04},{ 1.618649e-02,-4.493299e-04},{ 1.573716e-02,-4.775939e-04},
 { 1.525957e-02,-5.048772e-04},{ 1.475469e-02,-5.311312e-04},{ 1.422356e-02,-5.563095e-04},{ 1.366725e-02,-5.803678e-04},
 { 1.308689e-02,-6.032638e-04},{ 1.248362e-02,-6.249579e-04},{ 1.185866e-02,-6.454125e-04},{ 1.121325e-02,-6.645928e-04},
 { 1.054866e-02,-6.824661e-04},{ 9.866192e-03,-6.990026e-04},{ 9.167189e-03,-7.141749e-04},{ 8.453014e-03,-7.279583e-04},
 { 7.725056e-03,-7.403309e-04},{ 6.984725e-03,-7.512733e-04},{ 6.233452e-03,-7.607689e-04},{ 5.472683e-03,-7.688041e-04},
 { 4.703879e-03,-7.753678e-04},{ 3.928511e-03,-7.804519e-04},{ 3.148059e-03,-7.840510e-04},{ 2.364008e-03,-7.861626e-04},
 { 1.577846e-03,-7.867869e-04},{ 7.910587e-04,-7.859270e-04},{ 5.131754e-06,-7.835887e-04},{-7.784570e-04,-7.797808e-04},
 {-1.558238e-03,-7.745145e-04},{-2.332752e-03,-7.678040e-04},{-3.100556e-03,-7.596660e-04},{-3.860222e-03,-7.501201e-04},
 {-4.610342e-03,-7.391881e-04},{-5.349530e-03,-7.268947e-04},{-6.076425e-03,-7.132670e-04},{-6.789692e-03,-6.983344e-04},
 {-7.488027e-03,-6.821290e-04},{-8.170156e-03,-6.646849e-04},{-8.834840e-03,-6.460386e-04},{-9.480879e-03,-6.262286e-04},
 {-1.010711e-02,-6.052958e-04},{-1.071240e-02,-5.832828e-04},{-1.129569e-02,-5.602343e-04},{-1.185592e-02,-5.361967e-04},
 {-1.239212e-02,-5.112182e-04},{-1.290334e-02,-4.853488e-04},{-1.338868e-02,-4.586397e-04},{-1.384732e-02,-4.311438e-04},
 {-1.427847e-02,-4.029153e-04},{-1.468138e-02,-3.740095e-04},{-1.505539e-02,-3.444830e-04},{-1.539988e-02,-3.143934e-04},
 {-1.571427e-02,-2.837990e-04},{-1.599807e-02,-2.527591e-04},{-1.625083e-02,-2.213335e-04},{-1.647216e-02,-1.895829e-04},
 {-1.666174e-02,-1.575679e-04},{-1.681931e-02,-1.253500e-04},{-1.694466e-02,-9.299045e-05},{-1.703765e-02,-6.055088e-05},
 {-1.709820e-02,-2.809278e-05},{-1.712630e-02, 4.322468e-06},{-1.712197e-02, 3.663375e-05},{-1.708534e-02, 6.878031e-05},
 {-1.701656e-02, 1.007019e-04},{-1.691586e-02, 1.323388e-04},{-1.678352e-02, 1.636321e-04},{-1.661989e-02, 1.945236e-04},
 {-1.642536e-02, 2.249561e-04},{-1.620041e-02, 2.548734e-04},{-1.594553e-02, 2.842205e-04},{-1.566131e-02, 3.129434e-04},
 {-1.534837e-02, 3.409898e-04},{-1.500738e-02, 3.683086e-04},{-1.463907e-02, 3.948502e-04},{-1.424422e-02, 4.205667e-04},
 {-1.382365e-02, 4.454118e-04},{-1.337824e-02, 4.693411e-04},{-1.290890e-02, 4.923121e-04},{-1.241659e-02, 5.142840e-04},
 {-1.190230e-02, 5.352182e-04},{-1.136709e-02, 5.550781e-04},{-1.081201e-02, 5.738292e-04},{-1.023818e-02, 5.914394e-04},
 {-9.646740e-03, 6.078787e-04},{-9.038861e-03, 6.231193e-04},{-8.415742e-03, 6.371358e-04},{-7.778606e-03, 6.499055e-04},
 {-7.128701e-03, 6.614076e-04},{-6.467293e-03, 6.716242e-04},{-5.795669e-03, 6.805397e-04},{-5.115129e-03, 6.881410e-04},
 {-4.426988e-03, 6.944175e-04},{-3.732571e-03, 6.993613e-04},{-3.033210e-03, 7.029668e-04},{-2.330243e-03, 7.052312e-04},
 {-1.625011e-03, 7.061542e-04},{-9.188573e-04, 7.057378e-04},{-2.131196e-04, 7.039868e-04},{ 4.908672e-04, 7.009085e-04},
 { 1.191776e-03, 6.965125e-04},{ 1.888288e-03, 6.908111e-04},{ 2.579099e-03, 6.838188e-04},{ 3.262918e-03, 6.755528e-04},
 { 3.938471e-03, 6.660323e-04},{ 4.604503e-03, 6.552793e-04},{ 5.259782e-03, 6.433175e-04},{ 5.903100e-03, 6.301733e-04},
 { 6.533273e-03, 6.158750e-04},{ 7.149148e-03, 6.004531e-04},{ 7.749601e-03, 5.839402e-04},{ 8.333541e-03, 5.663707e-04},
 { 8.899912e-03, 5.477811e-04},{ 9.447693e-03, 5.282097e-04},{ 9.975903e-03, 5.076963e-04},{ 1.048360e-02, 4.862827e-04},
 { 1.096988e-02, 4.640121e-04},{ 1.143389e-02, 4.409293e-04},{ 1.187482e-02, 4.170804e-04},{ 1.229190e-02, 3.925129e-04},
 { 1.268442e-02, 3.672755e-04},{ 1.305169e-02, 3.414181e-04},{ 1.339311e-02, 3.149916e-04},{ 1.370810e-02, 2.880476e-04},
 { 1.399615e-02, 2.606389e-04},{ 1.425679e-02, 2.328189e-04},{ 1.448961e-02, 2.046414e-04},{ 1.469425e-02, 1.761611e-04},
 { 1.487041e-02, 1.474328e-04},{ 1.501784e-02, 1.185118e-04},{ 1.513635e-02, 8.945353e-05},{ 1.522581e-02, 6.031354e-05},
 { 1.528612e-02, 3.114735e-05},{ 1.531727e-02, 2.010396e-06},{ 1.531928e-02,-2.704212e-05},{ 1.529224e-02,-5.595532e-05},
 { 1.523628e-02,-8.467473e-05},{ 1.515161e-02,-1.131464e-04},{ 1.503846e-02,-1.413171e-04},{ 1.489714e-02,-1.691342e-04},
 { 1.472801e-02,-1.965459e-04},{ 1.453146e-02,-2.235014e-04},{ 1.430796e-02,-2.499509e-04},{ 1.405801e-02,-2.758457e-04},
 { 1.378217e-02,-3.011382e-04},{ 1.348103e-02,-3.257823e-04},{ 1.315524e-02,-3.497331e-04},{ 1.280551e-02,-3.729471e-04},
 { 1.243256e-02,-3.953826e-04},{ 1.203718e-02,-4.169990e-04},{ 1.162018e-02,-4.377580e-04},{ 1.118243e-02,-4.576226e-04},
 { 1.072480e-02,-4.765577e-04},{ 1.024824e-02,-4.945302e-04},{ 9.753715e-03,-5.115088e-04},{ 9.242206e-03,-5.274642e-04},
 { 8.714741e-03,-5.423692e-04},{ 8.172372e-03,-5.561986e-04},{ 7.616174e-03,-5.689294e-04},{ 7.047244e-03,-5.805405e-04},
 { 6.466704e-03,-5.910135e-04},{ 5.875690e-03,-6.003317e-04},{ 5.275359e-03,-6.084809e-04},{ 4.666878e-03,-6.154492e-04},
 { 4.051429e-03,-6.212268e-04},{ 3.430202e-03,-6.258064e-04},{ 2.804395e-03,-6.291828e-04},{ 2.175213e-03,-6.313533e-04},
 { 1.543859e-03,-6.323173e-04},{ 9.115420e-04,-6.320767e-04},{ 2.794653e-04,-6.306356e-04},{-3.511703e-04,-6.280003e-04},
 {-9.791705e-04,-6.241794e-04},{-1.603350e-03,-6.191838e-04},{-2.222534e-03,-6.130266e-04},{-2.835560e-03,-6.057228e-04},
 {-3.441283e-03,-5.972901e-04},{-4.038573e-03,-5.877476e-04},{-4.626321e-03,-5.771171e-04},{-5.203438e-03,-5.654220e-04},
 {-5.768860e-03,-5.526877e-04},{-6.321548e-03,-5.389417e-04},{-6.860489e-03,-5.242132e-04},{-7.384702e-03,-5.085331e-04},
 {-7.893236e-03,-4.919343e-04},{-8.385170e-03,-4.744510e-04},{-8.859621e-03,-4.561193e-04},{-9.315740e-03,-4.369766e-04},
 {-9.752717e-03,-4.170618e-04},{-1.016978e-02,-3.964151e-04},{-1.056619e-02,-3.750782e-04},{-1.094127e-02,-3.530937e-04},
 {-1.129437e-02,-3.305054e-04},{-1.162487e-02,-3.073582e-04},{-1.193223e-02,-2.836979e-04},{-1.221593e-02,-2.595711e-04},
 {-1.247550e-02,-2.350251e-04},{-1.271052e-02,-2.101079e-04},{-1.292063e-02,-1.848682e-04},{-1.310550e-02,-1.593550e-04},
 {-1.326485e-02,-1.336178e-04},{-1.339847e-02,-1.077062e-04},{-1.350618e-02,-8.167008e-05},{-1.358785e-02,-5.555950e-05},
 {-1.364341e-02,-2.942440e-05},{-1.367283e-02,-3.314627e-06},{-1.367615e-02, 2.272013e-05},{-1.365343e-02, 4.863051e-05},
 {-1.360480e-02, 7.436752e-05},{-1.353043e-02, 9.988265e-05},{-1.343055e-02, 1.251280e-04},{-1.330542e-02, 1.500562e-04},
 {-1.315536e-02, 1.746207e-04},{-1.298074e-02, 1.987760e-04},{-1.278197e-02, 2.224771e-04},{-1.255949e-02, 2.456803e-04},
 {-1.231381e-02, 2.683429e-04},{-1.204547e-02, 2.904234e-04},{-1.175504e-02, 3.118814e-04},{-1.144316e-02, 3.326780e-04},
 {-1.111048e-02, 3.527756e-04},{-1.075771e-02, 3.721380e-04},{-1.038557e-02, 3.907305e-04},{-9.994838e-03, 4.085200e-04},
 {-9.586318e-03, 4.254752e-04},{-9.160843e-03, 4.415662e-04},{-8.719277e-03, 4.567651e-04},{-8.262512e-03, 4.710456e-04},
 {-7.791466e-03, 4.843833e-04},{-7.307083e-03, 4.967557e-04},{-6.810327e-03, 5.081422e-04},{-6.302185e-03, 5.185240e-04},
 {-5.783661e-03, 5.278846e-04},{-5.255776e-03, 5.362092e-04},{-4.719567e-03, 5.434852e-04},{-4.176082e-03, 5.497019e-04},
 {-3.626380e-03, 5.548507e-04},{-3.071529e-03, 5.589251e-04},{-2.512604e-03, 5.619208e-04},{-1.950683e-03, 5.638353e-04},
 {-1.386848e-03, 5.646683e-04},{-8.221797e-04, 5.644217e-04},{-2.577580e-04, 5.630992e-04},{ 3.053412e-04, 5.607067e-04},
 { 8.660478e-04, 5.572521e-04},{ 1.423300e-03, 5.527454e-04},{ 1.976045e-03, 5.471983e-04},{ 2.523244e-03, 5.406248e-04},
 { 3.063868e-03, 5.330406e-04},{ 3.596909e-03, 5.244634e-04},{ 4.121372e-03, 5.149125e-04},{ 4.636285e-03, 5.044094e-04},
 { 5.140694e-03, 4.929769e-04},{ 5.633671e-03, 4.806400e-04},{ 6.114311e-03, 4.674249e-04},{ 6.581736e-03, 4.533596e-04},
 { 7.035096e-03, 4.384737e-04},{ 7.473569e-03, 4.227982e-04},{ 7.896368e-03, 4.063655e-04},{ 8.302733e-03, 3.892093e-04},
 { 8.691942e-03, 3.713648e-04},{ 9.063307e-03, 3.528681e-04},{ 9.416175e-03, 3.337567e-04},{ 9.749932e-03, 3.140689e-04},
 { 1.006400e-02, 2.938443e-04},{ 1.035785e-02, 2.731231e-04},{ 1.063097e-02, 2.519466e-04},{ 1.088291e-02, 2.303566e-04},
 { 1.111327e-02, 2.083956e-04},{ 1.132167e-02, 1.861069e-04},{ 1.150777e-02, 1.635341e-04},{ 1.167131e-02, 1.407211e-04},
 { 1.181203e-02, 1.177124e-04},{ 1.192974e-02, 9.455257e-05},{ 1.202429e-02, 7.128636e-05},{ 1.209558e-02, 4.795857e-05},
 { 1.214354e-02, 2.461400e-05},{ 1.216815e-02, 1.297348e-06},{ 1.216945e-02,-2.194690e-05},{ 1.214750e-02,-4.507453e-05},
 { 1.210243e-02,-6.804168e-05},{ 1.203439e-02,-9.080495e-05},{ 1.194358e-02,-1.133214e-04},{ 1.183026e-02,-1.355489e-04},
 { 1.169471e-02,-1.574457e-04},{ 1.153727e-02,-1.789710e-04},{ 1.135830e-02,-2.000848e-04},{ 1.115821e-02,-2.207481e-04},
 { 1.093746e-02,-2.409227e-04},{ 1.069654e-02,-2.605717e-04},{ 1.043597e-02,-2.796590e-04},{ 1.015631e-02,-2.981500e-04},
 { 9.858159e-03,-3.160112e-04},{ 9.542148e-03,-3.332104e-04},{ 9.208937e-03,-3.497168e-04},{ 8.859221e-03,-3.655011e-04},
 { 8.493719e-03,-3.805353e-04},{ 8.113184e-03,-3.947931e-04},{ 7.718391e-03,-4.082496e-04},{ 7.310142e-03,-4.208817e-04},
 { 6.889260e-03,-4.326678e-04},{ 6.456592e-03,-4.435880e-04},{ 6.013004e-03,-4.536243e-04},{ 5.559380e-03,-4.627603e-04},
 { 5.096619e-03,-4.709812e-04},{ 4.625638e-03,-4.782745e-04},{ 4.147364e-03,-4.846289e-04},{ 3.662735e-03,-4.900355e-04},
 { 3.172699e-03,-4.944868e-04},{ 2.678213e-03,-4.979775e-04},{ 2.180235e-03,-5.005039e-04},{ 1.679731e-03,-5.020643e-04},
 { 1.177667e-03,-5.026588e-04},{ 6.750079e-04,-5.022894e-04},{ 1.727185e-04,-5.009599e-04},{-3.282413e-04,-4.986758e-04},
 {-8.269172e-04,-4.954448e-04},{-1.322362e-03,-4.912760e-04},{-1.813638e-03,-4.861804e-04},{-2.299818e-03,-4.801707e-04},
 {-2.779989e-03,-4.732616e-04},{-3.253251e-03,-4.654689e-04},{-3.718720e-03,-4.568107e-04},{-4.175530e-03,-4.473062e-04},
 {-4.622836e-03,-4.369764e-04},{-5.059813e-03,-4.258438e-04},{-5.485657e-03,-4.139322e-04},{-5.899589e-03,-4.012672e-04},
 {-6.300856e-03,-3.878752e-04},{-6.688731e-03,-3.737845e-04},{-7.062516e-03,-3.590242e-04},{-7.421540e-03,-3.436248e-04},
 {-7.765165e-03,-3.276179e-04},{-8.092783e-03,-3.110362e-04},{-8.403819e-03,-2.939134e-04},{-8.697732e-03,-2.762839e-04},
 {-8.974016e-03,-2.581832e-04},{-9.232199e-03,-2.396477e-04},{-9.471847e-03,-2.207142e-04},{-9.692561e-03,-2.014203e-04},
 {-9.893982e-03,-1.818043e-04},{-1.007579e-02,-1.619047e-04},{-1.023769e-02,-1.417607e-04},{-1.037945e-02,-1.214117e-04},
 {-1.050086e-02,-1.008973e-04},{-1.060176e-02,-8.025755e-05},{-1.068202e-02,-5.953234e-05},{-1.074155e-02,-3.876172e-05},
 {-1.078031e-02,-1.798569e-05},{-1.079830e-02, 2.755890e-06},{-1.079554e-02, 2.342334e-05},{-1.077212e-02, 4.397724e-05},
 {-1.072814e-02, 6.437855e-05},{-1.066376e-02, 8.458862e-05},{-1.057917e-02, 1.045693e-04},{-1.047460e-02, 1.242830e-04},
 {-1.035032e-02, 1.436928e-04},{-1.020663e-02, 1.627624e-04},{-1.004387e-02, 1.814564e-04},{-9.862410e-03, 1.997401e-04},
 {-9.662670e-03, 2.175798e-04},{-9.445090e-03, 2.349427e-04},{-9.210147e-03, 2.517970e-04},{-8.958350e-03, 2.681121e-04},
 {-8.690238e-03, 2.838585e-04},{-8.406380e-03, 2.990077e-04},{-8.107372e-03, 3.135327e-04},{-7.793839e-03, 3.274077e-04},
 {-7.466432e-03, 3.406081e-04},{-7.125823e-03, 3.531109e-04},{-6.772713e-03, 3.648943e-04},{-6.407818e-03, 3.759382e-04},
 {-6.031880e-03, 3.862237e-04},{-5.645656e-03, 3.957336e-04},{-5.249923e-03, 4.044522e-04},{-4.845471e-03, 4.123655e-04},
 {-4.433105e-03, 4.194608e-04},{-4.013644e-03, 4.257273e-04},{-3.587917e-03, 4.311557e-04},{-3.156761e-03, 4.357383e-04},
 {-2.721023e-03, 4.394692e-04},{-2.281554e-03, 4.423440e-04},{-1.839210e-03, 4.443600e-04},{-1.394850e-03, 4.455163e-04},
 {-9.493336e-04, 4.458134e-04},{-5.035201e-04, 4.452537e-04},{-5.826644e-05, 4.438411e-04},{ 3.855747e-04, 4.415812e-04},
 { 8.271558e-04, 4.384811e-04},{ 1.265637e-03, 4.345495e-04},{ 1.700186e-03, 4.297969e-04},{ 2.129983e-03, 4.242351e-04},
 { 2.554218e-03, 4.178775e-04},{ 2.972096e-03, 4.107390e-04},{ 3.382835e-03, 4.028359e-04},{ 3.785671e-03, 3.941859e-04},
 { 4.179857e-03, 3.848082e-04},{ 4.564665e-03, 3.747233e-04},{ 4.939388e-03, 3.639529e-04},{ 5.303341e-03, 3.525200e-04},
 { 5.655861e-03, 3.404489e-04},{ 5.996310e-03, 3.277648e-04},{ 6.324075e-03, 3.144942e-04},{ 6.638569e-03, 3.006647e-04},
 { 6.939234e-03, 2.863046e-04},{ 7.225538e-03, 2.714434e-04},{ 7.496982e-03, 2.561113e-04},{ 7.753093e-03, 2.403394e-04},
 { 7.993433e-03, 2.241596e-04},{ 8.217592e-03, 2.076043e-04},{ 8.425196e-03, 1.907066e-04},{ 8.615903e-03, 1.735001e-04},
 { 8.789403e-03, 1.560191e-04},{ 8.945422e-03, 1.382981e-04},{ 9.083720e-03, 1.203719e-04},{ 9.204092e-03, 1.022758e-04},
 { 9.306368e-03, 8.404505e-05},{ 9.390413e-03, 6.571529e-05},{ 9.456128e-03, 4.732209e-05},{ 9.503450e-03, 2.890105e-05},
 { 9.532351e-03, 1.048771e-05},{ 9.542839e-03,-7.882545e-06},{ 9.534957e-03,-2.617450e-05},{ 9.508782e-03,-4.435322e-05},
 { 9.464429e-03,-6.238411e-05},{ 9.402045e-03,-8.023298e-05},{ 9.321812e-03,-9.786610e-05},{ 9.223946e-03,-1.152503e-04},
 { 9.108695e-03,-1.323529e-04},{ 8.976343e-03,-1.491419e-04},{ 8.827201e-03,-1.655862e-04},{ 8.661614e-03,-1.816553e-04},
 { 8.479959e-03,-1.973194e-04},{ 8.282640e-03,-2.125499e-04},{ 8.070090e-03,-2.273189e-04},{ 7.842771e-03,-2.415995e-04},
 { 7.601171e-03,-2.553660e-04},{ 7.345805e-03,-2.685934e-04},{ 7.077212e-03,-2.812584e-04},{ 6.795954e-03,-2.933383e-04},
 { 6.502615e-03,-3.048120e-04},{ 6.197803e-03,-3.156593e-04},{ 5.882144e-03,-3.258617e-04},{ 5.556282e-03,-3.354015e-04},
 { 5.220881e-03,-3.442628e-04},{ 4.876618e-03,-3.524309e-04},{ 4.524187e-03,-3.598922e-04},{ 4.164295e-03,-3.666350e-04},
 { 3.797660e-03,-3.726487e-04},{ 3.425011e-03,-3.779243e-04},{ 3.047087e-03,-3.824540e-04},{ 2.664633e-03,-3.862318e-04},
 { 2.278401e-03,-3.892529e-04},{ 1.889148e-03,-3.915142e-04},{ 1.497634e-03,-3.930140e-04},{ 1.104620e-03,-3.937519e-04},
 { 7.108681e-04,-3.937291e-04},{ 3.171389e-04,-3.929485e-04},{-7.580956e-05,-3.914140e-04},{-4.672235e-04,-3.891312e-04},
 {-8.563547e-04,-3.861072e-04},{-1.242462e-03,-3.823503e-04},{-1.624812e-03,-3.778703e-04},{-2.002682e-03,-3.726784e-04},
 {-2.375361e-03,-3.667869e-04},{-2.742148e-03,-3.602098e-04},{-3.102358e-03,-3.529621e-04},{-3.455320e-03,-3.450601e-04},
 {-3.800380e-03,-3.365212e-04},{-4.136901e-03,-3.273642e-04},{-4.464265e-03,-3.176089e-04},{-4.781874e-03,-3.072761e-04},
 {-5.089150e-03,-2.963878e-04},{-5.385538e-03,-2.849669e-04},{-5.670505e-03,-2.730373e-04},{-5.943542e-03,-2.606238e-04},
 {-6.204166e-03,-2.477521e-04},{-6.451918e-03,-2.344484e-04},{-6.686367e-03,-2.207400e-04},{-6.907107e-03,-2.066548e-04},
 {-7.113761e-03,-1.922213e-04},{-7.305983e-03,-1.774684e-04},{-7.483451e-03,-1.624257e-04},{-7.645877e-03,-1.471234e-04},
 {-7.793000e-03,-1.315918e-04},{-7.924592e-03,-1.158617e-04},{-8.040454e-03,-9.996410e-05},{-8.140418e-03,-8.393030e-05},
 {-8.224348e-03,-6.779170e-05},{-8.292140e-03,-5.157980e-05},{-8.343720e-03,-3.532614e-05},{-8.379046e-03,-1.906223e-05},
 {-8.398108e-03,-2.819486e-06},{-8.400928e-03, 1.337082e-05},{-8.387557e-03, 2.947764e-05},{-8.358079e-03, 4.547018e-05},
 {-8.312609e-03, 6.131797e-05},{-8.251291e-03, 7.699096e-05},{-8.174300e-03, 9.245950e-05},{-8.081840e-03, 1.076945e-04},
 {-7.974146e-03, 1.226673e-04},{-7.851479e-03, 1.373499e-04},{-7.714129e-03, 1.517152e-04},{-7.562414e-03, 1.657363e-04},
 {-7.396677e-03, 1.793876e-04},{-7.217290e-03, 1.926439e-04},{-7.024646e-03, 2.054811e-04},{-6.819165e-03, 2.178759e-04},
 {-6.601289e-03, 2.298059e-04},{-6.371483e-03, 2.412497e-04},{-6.130233e-03, 2.521870e-04},{-5.878046e-03, 2.625984e-04},
 {-5.615448e-03, 2.724657e-04},{-5.342982e-03, 2.817718e-04},{-5.061210e-03, 2.905007e-04},{-4.770710e-03, 2.986376e-04},
 {-4.472072e-03, 3.061690e-04},{-4.165903e-03, 3.130823e-04},{-3.852821e-03, 3.193666e-04},{-3.533454e-03, 3.250118e-04},
 {-3.208442e-03, 3.300094e-04},{-2.878433e-03, 3.343521e-04},{-2.544081e-03, 3.380337e-04},{-2.206047e-03, 3.410496e-04},
 {-1.864998e-03, 3.433962e-04},{-1.521601e-03, 3.450715e-04},{-1.176530e-03, 3.460747e-04},{-8.304551e-04, 3.464061e-04},
 {-4.840490e-04, 3.460677e-04},{-1.379813e-04, 3.450623e-04},{ 2.070810e-04, 3.433945e-04},{ 5.504755e-04, 3.410697e-04},
 { 8.915451e-04, 3.380948e-04},{ 1.229640e-03, 3.344780e-04},{ 1.564118e-03, 3.302284e-04},{ 1.894346e-03, 3.253567e-04},
 { 2.219703e-03, 3.198745e-04},{ 2.539578e-03, 3.137945e-04},{ 2.853372e-03, 3.071308e-04},{ 3.160503e-03, 2.998982e-04},
 { 3.460401e-03, 2.921128e-04},{ 3.752514e-03, 2.837916e-04},{ 4.036305e-03, 2.749527e-04},{ 4.311258e-03, 2.656151e-04},
 { 4.576873e-03, 2.557986e-04},{ 4.832672e-03, 2.455238e-04},{ 5.078196e-03, 2.348125e-04},{ 5.313008e-03, 2.236867e-04},
 { 5.536695e-03, 2.121696e-04},{ 5.748864e-03, 2.002849e-04},{ 5.949149e-03, 1.880568e-04},{ 6.137206e-03, 1.755102e-04},
 { 6.312716e-03, 1.626707e-04},{ 6.475387e-03, 1.495640e-04},{ 6.624951e-03, 1.362165e-04},{ 6.761168e-03, 1.226549e-04},
 { 6.883823e-03, 1.089063e-04},{ 6.992729e-03, 9.499776e-05},{ 7.087727e-03, 8.095693e-05},{ 7.168684e-03, 6.681141e-05},
 { 7.235495e-03, 5.258895e-05},{ 7.288084e-03, 3.831735e-05},{ 7.326401e-03, 2.402439e-05},{ 7.350426e-03, 9.737819e-06},
 { 7.360163e-03,-4.514759e-06},{ 7.355649e-03,-1.870588e-05},{ 7.336943e-03,-3.280832e-05},{ 7.304134e-03,-4.679511e-05},
 { 7.257339e-03,-6.063961e-05},{ 7.196700e-03,-7.431555e-05},{ 7.122384e-03,-8.779707e-05},{ 7.034587e-03,-1.010588e-04},
 { 6.933528e-03,-1.140759e-04},{ 6.819452e-03,-1.268240e-04},{ 6.692628e-03,-1.392796e-04},{ 6.553349e-03,-1.514194e-04},
 { 6.401929e-03,-1.632213e-04},{ 6.238708e-03,-1.746636e-04},{ 6.064045e-03,-1.857254e-04},{ 5.878319e-03,-1.963868e-04},
 { 5.681932e-03,-2.066286e-04},{ 5.475304e-03,-2.164326e-04},{ 5.258871e-03,-2.257813e-04},{ 5.033090e-03,-2.346583e-04},
 { 4.798431e-03,-2.430483e-04},{ 4.555383e-03,-2.509367e-04},{ 4.304447e-03,-2.583101e-04},{ 4.046136e-03,-2.651562e-04},
 { 3.780980e-03,-2.714637e-04},{ 3.509517e-03,-2.772223e-04},{ 3.232294e-03,-2.824229e-04},{ 2.949871e-03,-2.870576e-04},
 { 2.662814e-03,-2.911194e-04},{ 2.371694e-03,-2.946026e-04},{ 2.077092e-03,-2.975027e-04},{ 1.779589e-03,-2.998161e-04},
 { 1.479773e-03,-3.015406e-04},{ 1.178232e-03,-3.026751e-04},{ 8.755573e-04,-3.032194e-04},{ 5.723378e-04,-3.031749e-04},
 { 2.691630e-04,-3.025436e-04},{-3.338066e-05,-3.013292e-04},{-3.347099e-04,-2.995361e-04},{-6.342460e-04,-2.971699e-04},
 {-9.314158e-04,-2.942374e-04},{-1.225653e-03,-2.907463e-04},{-1.516400e-03,-2.867056e-04},{-1.803105e-03,-2.821251e-04},
 {-2.085230e-03,-2.770157e-04},{-2.362246e-03,-2.713893e-04},{-2.633635e-03,-2.652587e-04},{-2.898894e-03,-2.586378e-04},
 {-3.157532e-03,-2.515411e-04},{-3.409073e-03,-2.439843e-04},{-3.653057e-03,-2.359837e-04},{-3.889041e-03,-2.275565e-04},
 {-4.116597e-03,-2.187206e-04},{-4.335318e-03,-2.094948e-04},{-4.544813e-03,-1.998983e-04},{-4.744711e-03,-1.899511e-04},
 {-4.934662e-03,-1.796739e-04},{-5.114336e-03,-1.690879e-04},{-5.283424e-03,-1.582147e-04},{-5.441639e-03,-1.470765e-04},
 {-5.588715e-03,-1.356959e-04},{-5.724411e-03,-1.240959e-04},{-5.848507e-03,-1.122998e-04},{-5.960807e-03,-1.003313e-04},
 {-6.061138e-03,-8.821415e-05},{-6.149352e-03,-7.597246e-05},{-6.225325e-03,-6.363046e-05},{-6.288955e-03,-5.121246e-05},
 {-6.340168e-03,-3.874283e-05},{-6.378910e-03,-2.624596e-05},{-6.405156e-03,-1.374620e-05},{-6.418903e-03,-1.267801e-06},
 {-6.420170e-03, 1.116510e-05},{-6.409005e-03, 2.352857e-05},{-6.385477e-03, 3.579888e-05},{-6.349678e-03, 4.795257e-05},
 {-6.301725e-03, 5.996652e-05},{-6.241759e-03, 7.181793e-05},{-6.169941e-03, 8.348445e-05},{-6.086456e-03, 9.494413e-05},
 {-5.991512e-03, 1.061755e-04},{-5.885337e-03, 1.171577e-04},{-5.768179e-03, 1.278703e-04},{-5.640309e-03, 1.382936e-04},
 {-5.502015e-03, 1.484085e-04},{-5.353606e-03, 1.581965e-04},{-5.195410e-03, 1.676398e-04},{-5.027770e-03, 1.767214e-04},
 {-4.851049e-03, 1.854252e-04},{-4.665624e-03, 1.937357e-04},{-4.471888e-03, 2.016382e-04},{-4.270250e-03, 2.091190e-04},
 {-4.061131e-03, 2.161651e-04},{-3.844966e-03, 2.227646e-04},{-3.622201e-03, 2.289064e-04},{-3.393295e-03, 2.345803e-04},
 {-3.158714e-03, 2.397771e-04},{-2.918937e-03, 2.444885e-04},{-2.674449e-03, 2.487074e-04},{-2.425741e-03, 2.524273e-04},
 {-2.173314e-03, 2.556430e-04},{-1.917671e-03, 2.583501e-04},{-1.659321e-03, 2.605455e-04},{-1.398775e-03, 2.622268e-04},
 {-1.136549e-03, 2.633928e-04},{-8.731558e-04, 2.640431e-04},{-6.091126e-04, 2.641786e-04},{-3.449341e-04, 2.638008e-04},
 {-8.113323e-05, 2.629127e-04},{ 1.817795e-04, 2.615178e-04},{ 4.432973e-04, 2.596209e-04},{ 7.029182e-04, 2.572276e-04},
 { 9.601459e-04, 2.543445e-04},{ 1.214490e-03, 2.509790e-04},{ 1.465469e-03, 2.471397e-04},{ 1.712609e-03, 2.428357e-04},
 { 1.955445e-03, 2.380774e-04},{ 2.193522e-03, 2.328756e-04},{ 2.426398e-03, 2.272423e-04},{ 2.653640e-03, 2.211900e-04},
 { 2.874830e-03, 2.147323e-04},{ 3.089562e-03, 2.078831e-04},{ 3.297446e-03, 2.006573e-04},{ 3.498103e-03, 1.930706e-04},
 { 3.691173e-03, 1.851389e-04},{ 3.876312e-03, 1.768792e-04},{ 4.053191e-03, 1.683086e-04},{ 4.221500e-03, 1.594452e-04},
 { 4.380945e-03, 1.503073e-04},{ 4.531253e-03, 1.409137e-04},{ 4.672166e-03, 1.312837e-04},{ 4.803450e-03, 1.214370e-04},
 { 4.924887e-03, 1.113935e-04},{ 5.036281e-03, 1.011735e-04},{ 5.137454e-03, 9.079769e-05},{ 5.228252e-03, 8.028675e-05},
 { 5.308538e-03, 6.966168e-05},{ 5.378200e-03, 5.894360e-05},{ 5.437144e-03, 4.815371e-05},{ 5.485297e-03, 3.731328e-05},
 { 5.522611e-03, 2.644360e-05},{ 5.549054e-03, 1.556590e-05},{ 5.564620e-03, 4.701394e-06},{ 5.569322e-03,-6.128853e-06},
 { 5.563193e-03,-1.690391e-05},{ 5.546289e-03,-2.760303e-05},{ 5.518686e-03,-3.820572e-05},{ 5.480480e-03,-4.869171e-05},
 { 5.431788e-03,-5.904109e-05},{ 5.372747e-03,-6.923426e-05},{ 5.303513e-03,-7.925201e-05},{ 5.224261e-03,-8.907554e-05},
 { 5.135186e-03,-9.868652e-05},{ 5.036499e-03,-1.080671e-04},{ 4.928432e-03,-1.171999e-04},{ 4.811232e-03,-1.260682e-04},
 { 4.685164e-03,-1.346558e-04},{ 4.550508e-03,-1.429471e-04},{ 4.407561e-03,-1.509271e-04},{ 4.256634e-03,-1.585815e-04},
 { 4.098052e-03,-1.658968e-04},{ 3.932155e-03,-1.728601e-04},{ 3.759295e-03,-1.794591e-04},{ 3.579836e-03,-1.856826e-04},
 { 3.394154e-03,-1.915200e-04},{ 3.202634e-03,-1.969613e-04},{ 3.005672e-03,-2.019976e-04},{ 2.803675e-03,-2.066208e-04},
 { 2.597054e-03,-2.108235e-04},{ 2.386230e-03,-2.145991e-04},{ 2.171631e-03,-2.179421e-04},{ 1.953689e-03,-2.208477e-04},
 { 1.732841e-03,-2.233119e-04},{ 1.509530e-03,-2.253319e-04},{ 1.284198e-03,-2.269053e-04},{ 1.057292e-03,-2.280310e-04},
 { 8.292613e-04,-2.287086e-04},{ 6.005527e-04,-2.289386e-04},{ 3.716141e-04,-2.287222e-04},{ 1.428919e-04,-2.280618e-04},
 {-8.516987e-05,-2.269604e-04},{-3.121303e-04,-2.254219e-04},{-5.375522e-04,-2.234512e-04},{-7.610034e-04,-2.210538e-04},
 {-9.820572e-04,-2.182360e-04},{-1.200293e-03,-2.150052e-04},{-1.415298e-03,-2.113691e-04},{-1.626667e-03,-2.073367e-04},
 {-1.834004e-03,-2.029173e-04},{-2.036922e-03,-1.981212e-04},{-2.235043e-03,-1.929591e-04},{-2.428002e-03,-1.874427e-04},
 {-2.615445e-03,-1.815841e-04},{-2.797029e-03,-1.753962e-04},{-2.972425e-03,-1.688923e-04},{-3.141317e-03,-1.620864e-04},
 {-3.303404e-03,-1.549930e-04},{-3.458397e-03,-1.476271e-04},{-3.606024e-03,-1.400041e-04},{-3.746028e-03,-1.321400e-04},
 {-3.878168e-03,-1.240511e-04},{-4.002219e-03,-1.157540e-04},{-4.117973e-03,-1.072659e-04},{-4.225239e-03,-9.860387e-05},
 {-4.323843e-03,-8.978569e-05},{-4.413629e-03,-8.082914e-05},{-4.494458e-03,-7.175225e-05},{-4.566210e-03,-6.257320e-05},
 {-4.628783e-03,-5.331031e-05},{-4.682093e-03,-4.398198e-05},{-4.726075e-03,-3.460667e-05},{-4.760682e-03,-2.520285e-05},
 {-4.785885e-03,-1.578898e-05},{-4.801674e-03,-6.383435e-06},{-4.808057e-03, 2.995461e-06},{-4.805062e-03, 1.232953e-05},
 {-4.792732e-03, 2.160077e-05},{-4.771132e-03, 3.079134e-05},{-4.740340e-03, 3.988366e-05},{-4.700457e-03, 4.886041e-05},
 {-4.651596e-03, 5.770454e-05},{-4.593892e-03, 6.639937e-05},{-4.527492e-03, 7.492855e-05},{-4.452564e-03, 8.327612e-05},
 {-4.369288e-03, 9.142657e-05},{-4.277861e-03, 9.936480e-05},{-4.178496e-03, 1.070762e-04},{-4.071420e-03, 1.145467e-04},
 {-3.956873e-03, 1.217627e-04},{-3.835111e-03, 1.287112e-04},{-3.706399e-03, 1.353797e-04},{-3.571020e-03, 1.417564e-04},
 {-3.429263e-03, 1.478301e-04},{-3.281433e-03, 1.535901e-04},{-3.127843e-03, 1.590266e-04},{-2.968817e-03, 1.641302e-04},
 {-2.804686e-03, 1.688925e-04},{-2.635794e-03, 1.733055e-04},{-2.462488e-03, 1.773621e-04},{-2.285126e-03, 1.810558e-04},
 {-2.104070e-03, 1.843810e-04},{-1.919689e-03, 1.873327e-04},{-1.732357e-03, 1.899068e-04},{-1.542450e-03, 1.920997e-04},
 {-1.350350e-03, 1.939087e-04},{-1.156442e-03, 1.953321e-04},{-9.611094e-04, 1.963685e-04},{-7.647409e-04, 1.970177e-04},
 {-5.677233e-04, 1.972799e-04},{-3.704434e-04, 1.971562e-04},{-1.732872e-04, 1.966486e-04},{ 2.336147e-05, 1.957597e-04},
 { 2.191212e-04, 1.944927e-04},{ 4.136139e-04, 1.928518e-04},{ 6.064656e-04, 1.908417e-04},{ 7.973073e-04, 1.884679e-04},
 { 9.857752e-04, 1.857365e-04},{ 1.171512e-03, 1.826545e-04},{ 1.354166e-03, 1.792293e-04},{ 1.533396e-03, 1.754691e-04},
 { 1.708865e-03, 1.713826e-04},{ 1.880247e-03, 1.669791e-04},{ 2.047226e-03, 1.622687e-04},{ 2.209495e-03, 1.572617e-04},
 { 2.366757e-03, 1.519694e-04},{ 2.518726e-03, 1.464031e-04},{ 2.665129e-03, 1.405750e-04},{ 2.805704e-03, 1.344975e-04},
 { 2.940202e-03, 1.281836e-04},{ 3.068385e-03, 1.216466e-04},{ 3.190032e-03, 1.149002e-04},{ 3.304932e-03, 1.079585e-04},
 { 3.412891e-03, 1.008359e-04},{ 3.513726e-03, 9.354709e-05},{ 3.607274e-03, 8.610701e-05},{ 3.693381e-03, 7.853085e-05},
 { 3.771911e-03, 7.083398e-05},{ 3.842745e-03, 6.303198e-05},{ 3.905777e-03, 5.514053e-05},{ 3.960918e-03, 4.717545e-05},
 { 4.008093e-03, 3.915261e-05},{ 4.047246e-03, 3.108794e-05},{ 4.078334e-03, 2.299738e-05},{ 4.101331e-03, 1.489687e-05},
 { 4.116228e-03, 6.802277e-06},{ 4.123030e-03,-1.270599e-06},{ 4.121760e-03,-9.306070e-06},{ 4.112454e-03,-1.728859e-05},
 { 4.095165e-03,-2.520277e-05},{ 4.069962e-03,-3.303344e-05},{ 4.036929e-03,-4.076564e-05},{ 3.996163e-03,-4.838468e-05},
 { 3.947779e-03,-5.587615e-05},{ 3.891903e-03,-6.322595e-05},{ 3.828677e-03,-7.042031e-05},{ 3.758256e-03,-7.744584e-05},
 { 3.680810e-03,-8.428953e-05},{ 3.596521e-03,-9.093877e-05},{ 3.505582e-03,-9.738140e-05},{ 3.408201e-03,-1.036057e-04},
 { 3.304595e-03,-1.096005e-04},{ 3.194995e-03,-1.153550e-04},{ 3.079640e-03,-1.208590e-04},{ 2.958781e-03,-1.261028e-04},
 { 2.832678e-03,-1.310773e-04},{ 2.701601e-03,-1.357739e-04},{ 2.565827e-03,-1.401847e-04},{ 2.425642e-03,-1.443022e-04},
 { 2.281340e-03,-1.481197e-04},{ 2.133220e-03,-1.516310e-04},{ 1.981589e-03,-1.548306e-04},{ 1.826759e-03,-1.577135e-04},
 { 1.669045e-03,-1.602755e-04},{ 1.508770e-03,-1.625130e-04},{ 1.346257e-03,-1.644231e-04},{ 1.181833e-03,-1.660033e-04},
 { 1.015830e-03,-1.672521e-04},{ 8.485780e-04,-1.681685e-04},{ 6.804095e-04,-1.687520e-04},{ 5.116575e-04,-1.690031e-04},
 { 3.426543e-04,-1.689227e-04},{ 1.737316e-04,-1.685124e-04},{ 5.219164e-06,-1.677745e-04},{-1.625553e-04,-1.667117e-04},
 {-3.292670e-04,-1.653277e-04},{-4.945947e-04,-1.636265e-04},{-6.582212e-04,-1.616129e-04},{-8.198341e-04,-1.592922e-04},
 {-9.791264e-04,-1.566703e-04},{-1.135797e-03,-1.537536e-04},{-1.289550e-03,-1.505491e-04},{-1.440099e-03,-1.470644e-04},
 {-1.587164e-03,-1.433076e-04},{-1.730471e-03,-1.392871e-04},{-1.869758e-03,-1.350121e-04},{-2.004770e-03,-1.304920e-04},
 {-2.135262e-03,-1.257367e-04},{-2.260999e-03,-1.207567e-04},{-2.381756e-03,-1.155626e-04},{-2.497318e-03,-1.101656e-04},
 {-2.607484e-03,-1.045772e-04},{-2.712061e-03,-9.880908e-05},{-2.810870e-03,-9.287341e-05},{-2.903744e-03,-8.678254e-05},
 {-2.990526e-03,-8.054910e-05},{-3.071075e-03,-7.418593e-05},{-3.145261e-03,-6.770608e-05},{-3.212967e-03,-6.112275e-05},
 {-3.274090e-03,-5.444931e-05},{-3.328539e-03,-4.769923e-05},{-3.376239e-03,-4.088608e-05},{-3.417125e-03,-3.402350e-05},
 {-3.451148e-03,-2.712514e-05},{-3.478273e-03,-2.020470e-05},{-3.498478e-03,-1.327582e-05},{-3.511754e-03,-6.352139e-06},
 {-3.518106e-03, 5.528118e-07},{-3.517553e-03, 7.425577e-06},{-3.510128e-03, 1.425283e-05},{-3.495875e-03, 2.102139e-05},
 {-3.474853e-03, 2.771826e-05},{-3.447135e-03, 3.433062e-05},{-3.412805e-03, 4.084589e-05},{-3.371959e-03, 4.725173e-05},
 {-3.324707e-03, 5.353609e-05},{-3.271171e-03, 5.968717e-05},{-3.211484e-03, 6.569351e-05},{-3.145790e-03, 7.154400e-05},
 {-3.074246e-03, 7.722786e-05},{-2.997018e-03, 8.273469e-05},{-2.914284e-03, 8.805449e-05},{-2.826229e-03, 9.317767e-05},
 {-2.733052e-03, 9.809508e-05},{-2.634956e-03, 1.027980e-04},{-2.532158e-03, 1.072781e-04},{-2.424880e-03, 1.115277e-04},
 {-2.313353e-03, 1.155395e-04},{-2.197813e-03, 1.193067e-04},{-2.078506e-03, 1.228229e-04},{-1.955683e-03, 1.260825e-04},
 {-1.829601e-03, 1.290802e-04},{-1.700521e-03, 1.318113e-04},{-1.568709e-03, 1.342716e-04},{-1.434438e-03, 1.364576e-04},
 {-1.297980e-03, 1.383661e-04},{-1.159614e-03, 1.399948e-04},{-1.019619e-03, 1.413417e-04},{-8.782776e-04, 1.424055e-04},
 {-7.358722e-04, 1.431852e-04},{-5.926869e-04, 1.436808e-04},{-4.490062e-04, 1.438925e-04},{-3.051137e-04, 1.438211e-04},
 {-1.612926e-04, 1.434682e-04},{-1.782438e-05, 1.428357e-04},{ 1.250113e-04, 1.419261e-04},{ 2.669374e-04, 1.407425e-04},
 { 4.076799e-04, 1.392884e-04},{ 5.469682e-04, 1.375679e-04},{ 6.845361e-04, 1.355857e-04},{ 8.201218e-04, 1.333467e-04},
 { 9.534685e-04, 1.308567e-04},{ 1.084325e-03, 1.281216e-04},{ 1.212447e-03, 1.251479e-04},{ 1.337595e-03, 1.219425e-04},
 { 1.459537e-03, 1.185129e-04},{ 1.578050e-03, 1.148667e-04},{ 1.692917e-03, 1.110122e-04},{ 1.803929e-03, 1.069578e-04},
 { 1.910887e-03, 1.027124e-04},{ 2.013599e-03, 9.828528e-05},{ 2.111884e-03, 9.368593e-05},{ 2.205570e-03, 8.892420e-05},
 { 2.294495e-03, 8.401017e-05},{ 2.378505e-03, 7.895420e-05},{ 2.457459e-03, 7.376688e-05},{ 2.531226e-03, 6.845900e-05},
 { 2.599685e-03, 6.304154e-05},{ 2.662726e-03, 5.752566e-05},{ 2.720252e-03, 5.192265e-05},{ 2.772175e-03, 4.624391e-05},
 { 2.818419e-03, 4.050096e-05},{ 2.858920e-03, 3.470538e-05},{ 2.893625e-03, 2.886879e-05},{ 2.922494e-03, 2.300285e-05},
 { 2.945497e-03, 1.711924e-05},{ 2.962616e-03, 1.122958e-05},{ 2.973845e-03, 5.345492e-06},{ 2.979191e-03,-5.214977e-07},
 { 2.978669e-03,-6.359936e-06},{ 2.972309e-03,-1.215848e-05},{ 2.960151e-03,-1.790592e-05},{ 2.942245e-03,-2.359120e-05},
 { 2.918654e-03,-2.920343e-05},{ 2.889450e-03,-3.473192e-05},{ 2.854718e-03,-4.016620e-05},{ 2.814552e-03,-4.549602e-05},
 { 2.769056e-03,-5.071139e-05},{ 2.718345e-03,-5.580260e-05},{ 2.662542e-03,-6.076021e-05},{ 2.601782e-03,-6.557511e-05},
 { 2.536207e-03,-7.023850e-05},{ 2.465968e-03,-7.474191e-05},{ 2.391227e-03,-7.907724e-05},{ 2.312149e-03,-8.323676e-05},
 { 2.228913e-03,-8.721311e-05},{ 2.141699e-03,-9.099934e-05},{ 2.050700e-03,-9.458888e-05},{ 1.956111e-03,-9.797561e-05},
 { 1.858136e-03,-1.011538e-04},{ 1.756982e-03,-1.041182e-04},{ 1.652864e-03,-1.068640e-04},{ 1.545999e-03,-1.093869e-04},
 { 1.436613e-03,-1.116828e-04},{ 1.324930e-03,-1.137484e-04},{ 1.211181e-03,-1.155807e-04},{ 1.095601e-03,-1.171771e-04},
 { 9.784237e-04,-1.185357e-04},{ 8.598880e-04,-1.196549e-04},{ 7.402330e-04,-1.205337e-04},{ 6.196993e-04,-1.211714e-04},
 { 4.985279e-04,-1.215679e-04},{ 3.769600e-04,-1.217237e-04},{ 2.552363e-04,-1.216395e-04},{ 1.335968e-04,-1.213166e-04},
 { 1.228022e-05,-1.207568e-04},{-1.084766e-04,-1.199624e-04},{-2.284390e-04,-1.189360e-04},{-3.473750e-04,-1.176807e-04},
 {-4.650558e-04,-1.162002e-04},{-5.812560e-04,-1.144983e-04},{-6.957543e-04,-1.125795e-04},{-8.083338e-04,-1.104487e-04},
 {-9.187825e-04,-1.081109e-04},{-1.026893e-03,-1.055719e-04},{-1.132465e-03,-1.028375e-04},{-1.235303e-03,-9.991409e-05},
 {-1.335217e-03,-9.680834e-05},{-1.432025e-03,-9.352722e-05},{-1.525552e-03,-9.007803e-05},{-1.615630e-03,-8.646837e-05},
 {-1.702099e-03,-8.270612e-05},{-1.784805e-03,-7.879943e-05},{-1.863604e-03,-7.475666e-05},{-1.938361e-03,-7.058646e-05},
 {-2.008947e-03,-6.629763e-05},{-2.075245e-03,-6.189919e-05},{-2.137144e-03,-5.740035e-05},{-2.194545e-03,-5.281044e-05},
 {-2.247355e-03,-4.813894e-05},{-2.295494e-03,-4.339546e-05},{-2.338889e-03,-3.858967e-05},{-2.377479e-03,-3.373136e-05},
 {-2.411210e-03,-2.883034e-05},{-2.440041e-03,-2.389648e-05},{-2.463937e-03,-1.893966e-05},{-2.482877e-03,-1.396976e-05},
 {-2.496847e-03,-8.996632e-06},{-2.505843e-03,-4.030093e-06},{-2.509873e-03, 9.200998e-07},{-2.508953e-03, 5.844272e-06},
 {-2.503109e-03, 1.073284e-05},{-2.492376e-03, 1.557635e-05},{-2.476800e-03, 2.036548e-05},{-2.456434e-03, 2.509103e-05},
 {-2.431343e-03, 2.974402e-05},{-2.401599e-03, 3.431562e-05},{-2.367284e-03, 3.879721e-05},{-2.328487e-03, 4.318040e-05},
 {-2.285306e-03, 4.745703e-05},{-2.237849e-03, 5.161918e-05},{-2.186230e-03, 5.565922e-05},{-2.130571e-03, 5.956976e-05},
 {-2.071001e-03, 6.334374e-05},{-2.007657e-03, 6.697437e-05},{-1.940683e-03, 7.045520e-05},{-1.870228e-03, 7.378011e-05},
 {-1.796448e-03, 7.694329e-05},{-1.719504e-03, 7.993930e-05},{-1.639565e-03, 8.276305e-05},{-1.556802e-03, 8.540982e-05},
 {-1.471392e-03, 8.787525e-05},{-1.383517e-03, 9.015539e-05},{-1.293361e-03, 9.224663e-05},{-1.201115e-03, 9.414578e-05},
 {-1.106969e-03, 9.585005e-05},{-1.011119e-03, 9.735703e-05},{-9.137619e-04, 9.866471e-05},{-8.150972e-04, 9.977151e-05},
 {-7.153257e-04, 1.006762e-04},{-6.146495e-04, 1.013781e-04},{-5.132714e-04, 1.018767e-04},{-4.113947e-04, 1.021721e-04},
 {-3.092226e-04, 1.022647e-04},{-2.069580e-04, 1.021552e-04},{-1.048027e-04, 1.018451e-04},{-2.957636e-06, 1.013357e-04},
 { 9.837811e-05, 1.006293e-04},{ 1.990074e-04, 9.972797e-05},{ 2.987353e-04, 9.863464e-05},{ 3.973700e-04, 9.735238e-05},
 { 4.947223e-04, 9.588466e-05},{ 5.906070e-04, 9.423530e-05},{ 6.848423e-04, 9.240846e-05},{ 7.772508e-04, 9.040863e-05},
 { 8.676594e-04, 8.824063e-05},{ 9.559000e-04, 8.590957e-05},{ 1.041810e-03, 8.342087e-05},{ 1.125230e-03, 8.078024e-05},
 { 1.206011e-03, 7.799365e-05},{ 1.284004e-03, 7.506733e-05},{ 1.359072e-03, 7.200776e-05},{ 1.431079e-03, 6.882165e-05},
 { 1.499901e-03, 6.551593e-05},{ 1.565417e-03, 6.209773e-05},{ 1.627515e-03, 5.857437e-05},{ 1.686089e-03, 5.495333e-05},
 { 1.741042e-03, 5.124226e-05},{ 1.792285e-03, 4.744895e-05},{ 1.839734e-03, 4.358130e-05},{ 1.883315e-03, 3.964733e-05},
 { 1.922962e-03, 3.565515e-05},{ 1.958617e-03, 3.161294e-05},{ 1.990230e-03, 2.752894e-05},{ 2.017759e-03, 2.341143e-05},
 { 2.041171e-03, 1.926872e-05},{ 2.060439e-03, 1.510913e-05},{ 2.075549e-03, 1.094097e-05},{ 2.086490e-03, 6.772510e-06},
 { 2.093262e-03, 2.612001e-06},{ 2.095874e-03,-1.532374e-06},{ 2.094342e-03,-5.652503e-06},{ 2.088689e-03,-9.740363e-06},
 { 2.078949e-03,-1.378803e-05},{ 2.065161e-03,-1.778772e-05},{ 2.047373e-03,-2.173175e-05},{ 2.025641e-03,-2.561260e-05},
 { 2.000029e-03,-2.942294e-05},{ 1.970606e-03,-3.315557e-05},{ 1.937450e-03,-3.680351e-05},{ 1.900647e-03,-4.035997e-05},
 { 1.860287e-03,-4.381840e-05},{ 1.816468e-03,-4.717244e-05},{ 1.769296e-03,-5.041599e-05},{ 1.718880e-03,-5.354321e-05},
 { 1.665337e-03,-5.654849e-05},{ 1.608788e-03,-5.942651e-05},{ 1.549362e-03,-6.217224e-05},{ 1.487190e-03,-6.478090e-05},
 { 1.422409e-03,-6.724806e-05},{ 1.355161e-03,-6.956953e-05},{ 1.285591e-03,-7.174149e-05},{ 1.213850e-03,-7.376039e-05},
 { 1.140089e-03,-7.562303e-05},{ 1.064466e-03,-7.732651e-05},{ 9.871396e-04,-7.886830e-05},{ 9.082713e-04,-8.024615e-05},
 { 8.280252e-04,-8.145820e-05},{ 7.465669e-04,-8.250290e-05},{ 6.640641e-04,-8.337903e-05},{ 5.806850e-04,-8.408573e-05},
 { 4.965993e-04,-8.462248e-05},{ 4.119768e-04,-8.498908e-05},{ 3.269877e-04,-8.518570e-05},{ 2.418020e-04,-8.521282e-05},
 { 1.565892e-04,-8.507126e-05},{ 7.151794e-05,-8.476218e-05},{-1.324424e-05,-8.428705e-05},{-9.753128e-05,-8.364767e-05},
 {-1.811790e-04,-8.284617e-05},{-2.640251e-04,-8.188496e-05},{-3.459101e-04,-8.076679e-05},{-4.266769e-04,-7.949467e-05},
 {-5.061715e-04,-7.807194e-05},{-5.842435e-04,-7.650219e-05},{-6.607457e-04,-7.478930e-05},{-7.355350e-04,-7.293741e-05},
 {-8.084724e-04,-7.095090e-05},{-8.794233e-04,-6.883443e-05},{-9.482577e-04,-6.659285e-05},{-1.014851e-03,-6.423127e-05},
 {-1.079082e-03,-6.175499e-05},{-1.140837e-03,-5.916952e-05},{-1.200006e-03,-5.648056e-05},{-1.256487e-03,-5.369397e-05},
 {-1.310181e-03,-5.081579e-05},{-1.360997e-03,-4.785222e-05},{-1.408849e-03,-4.480956e-05},{-1.453658e-03,-4.169427e-05},
 {-1.495353e-03,-3.851292e-05},{-1.533866e-03,-3.527214e-05},{-1.569138e-03,-3.197869e-05},{-1.601116e-03,-2.863937e-05},
 {-1.629756e-03,-2.526105e-05},{-1.655017e-03,-2.185063e-05},{-1.676868e-03,-1.841505e-05},{-1.695283e-03,-1.496125e-05},
 {-1.710244e-03,-1.149619e-05},{-1.721740e-03,-8.026801e-06},{-1.729767e-03,-4.559986e-06},{-1.734327e-03,-1.102613e-06},
 {-1.735429e-03, 2.338506e-06},{-1.733091e-03, 5.756628e-06},{-1.727334e-03, 9.145090e-06},{-1.718189e-03, 1.249732e-05},
 {-1.705692e-03, 1.580686e-05},{-1.689885e-03, 1.906737e-05},{-1.670818e-03, 2.227263e-05},{-1.648545e-03, 2.541656e-05},
 {-1.623128e-03, 2.849326e-05},{-1.594635e-03, 3.149697e-05},{-1.563138e-03, 3.442211e-05},{-1.528716e-03, 3.726329e-05},
 {-1.491453e-03, 4.001531e-05},{-1.451438e-03, 4.267319e-05},{-1.408764e-03, 4.523213e-05},{-1.363532e-03, 4.768760e-05},
 {-1.315845e-03, 5.003525e-05},{-1.265809e-03, 5.227100e-05},{-1.213538e-03, 5.439100e-05},{-1.159147e-03, 5.639166e-05},
 {-1.102756e-03, 5.826963e-05},{-1.044486e-03, 6.002185e-05},{-9.844642e-04, 6.164550e-05},{-9.228187e-04, 6.313804e-05},
 {-8.596807e-04, 6.449720e-05},{-7.951835e-04, 6.572099e-05},{-7.294625e-04, 6.680771e-05},{-6.626548e-04, 6.775593e-05},
 {-5.948989e-04, 6.856450e-05},{-5.263344e-04, 6.923257e-05},{-4.571018e-04, 6.975956e-05},{-3.873422e-04, 7.014517e-05},
 {-3.171970e-04, 7.038941e-05},{-2.468076e-04, 7.049253e-05},{-1.763151e-04, 7.045510e-05},{-1.058600e-04, 7.027794e-05},
 {-3.558206e-05, 6.996216e-05},{ 3.438010e-05, 6.950912e-05},{ 1.038892e-04, 6.892048e-05},{ 1.728097e-04, 6.819812e-05},
 { 2.410078e-04, 6.734420e-05},{ 3.083520e-04, 6.636113e-05},{ 3.747131e-04, 6.525157e-05},{ 4.399647e-04, 6.401840e-05},
 { 5.039831e-04, 6.266473e-05},{ 5.666478e-04, 6.119393e-05},{ 6.278418e-04, 5.960954e-05},{ 6.874513e-04, 5.791532e-05},
 { 7.453666e-04, 5.611525e-05},{ 8.014819e-04, 5.421349e-05},{ 8.556954e-04, 5.221435e-05},{ 9.079097e-04, 5.012236e-05},
 { 9.580321e-04, 4.794217e-05},{ 1.005974e-03, 4.567860e-05},{ 1.051653e-03, 4.333662e-05},{ 1.094989e-03, 4.092131e-05},
 { 1.135911e-03, 3.843787e-05},{ 1.174349e-03, 3.589163e-05},{ 1.210240e-03, 3.328798e-05},{ 1.243528e-03, 3.063244e-05},
 { 1.274161e-03, 2.793056e-05},{ 1.302091e-03, 2.518798e-05},{ 1.327279e-03, 2.241038e-05},{ 1.349690e-03, 1.960349e-05},
 { 1.369293e-03, 1.677306e-05},{ 1.386066e-03, 1.392485e-05},{ 1.399991e-03, 1.106464e-05},{ 1.411056e-03, 8.198176e-06},
 { 1.419254e-03, 5.331220e-06},{ 1.424585e-03, 2.469480e-06},{ 1.427055e-03,-3.813698e-07},{ 1.426673e-03,-3.215708e-06},
 { 1.423457e-03,-6.027977e-06},{ 1.417429e-03,-8.812693e-06},{ 1.408617e-03,-1.156446e-05},{ 1.397052e-03,-1.427797e-05},
 { 1.382774e-03,-1.694802e-05},{ 1.365826e-03,-1.956953e-05},{ 1.346257e-03,-2.213755e-05},{ 1.324119e-03,-2.464724e-05},
 { 1.299472e-03,-2.709392e-05},{ 1.272378e-03,-2.947306e-05},{ 1.242905e-03,-3.178029e-05},{ 1.211125e-03,-3.401140e-05},
 { 1.177113e-03,-3.616236e-05},{ 1.140951e-03,-3.822932e-05},{ 1.102722e-03,-4.020863e-05},{ 1.062513e-03,-4.209681e-05},
 { 1.020416e-03,-4.389060e-05},{ 9.765257e-04,-4.558695e-05},{ 9.309387e-04,-4.718301e-05},{ 8.837557e-04,-4.867614e-05},
 { 8.350796e-04,-5.006394e-05},{ 7.850156e-04,-5.134422e-05},{ 7.336714e-04,-5.251501e-05},{ 6.811564e-04,-5.357460e-05},
 { 6.275818e-04,-5.452147e-05},{ 5.730603e-04,-5.535436e-05},{ 5.177060e-04,-5.607224e-05},{ 4.616337e-04,-5.667432e-05},
 { 4.049594e-04,-5.716003e-05},{ 3.477994e-04,-5.752904e-05},{ 2.902703e-04,-5.778128e-05},{ 2.324891e-04,-5.791687e-05},
 { 1.745722e-04,-5.793621e-05},{ 1.166360e-04,-5.783989e-05},{ 5.879609e-05,-5.762875e-05},{ 1.167336e-06,-5.730385e-05},
 {-5.613652e-05,-5.686647e-05},{-1.130030e-04,-5.631811e-05},{-1.693211e-04,-5.566049e-05},{-2.249816e-04,-5.489551e-05},
 {-2.798771e-04,-5.402532e-05},{-3.339024e-04,-5.305222e-05},{-3.869546e-04,-5.197875e-05},{-4.389334e-04,-5.080761e-05},
 {-4.897410e-04,-4.954167e-05},{-5.392827e-04,-4.818400e-05},{-5.874667e-04,-4.673782e-05},{-6.342045e-04,-4.520652e-05},
 {-6.794110e-04,-4.359363e-05},{-7.230046e-04,-4.190283e-05},{-7.649075e-04,-4.013793e-05},{-8.050454e-04,-3.830289e-05},
 {-8.433483e-04,-3.640175e-05},{-8.797500e-04,-3.443869e-05},{-9.141887e-04,-3.241797e-05},{-9.466067e-04,-3.034397e-05},
 {-9.769507e-04,-2.822113e-05},{-1.005172e-03,-2.605396e-05},{-1.031226e-03,-2.384705e-05},{-1.055073e-03,-2.160502e-05},
 {-1.076678e-03,-1.933257e-05},{-1.096010e-03,-1.703441e-05},{-1.113045e-03,-1.471528e-05},{-1.127760e-03,-1.237993e-05},
 {-1.140140e-03,-1.003313e-05},{-1.150173e-03,-7.679632e-06},{-1.157853e-03,-5.324185e-06},{-1.163177e-03,-2.971510e-06},
 {-1.166148e-03,-6.263003e-07},{-1.166775e-03, 1.706796e-06},{-1.165068e-03, 4.023179e-06},{-1.161045e-03, 6.318309e-06},
 {-1.154726e-03, 8.587712e-06},{-1.146139e-03, 1.082699e-05},{-1.135312e-03, 1.303184e-05},{-1.122280e-03, 1.519804e-05},
 {-1.107082e-03, 1.732147e-05},{-1.089760e-03, 1.939812e-05},{-1.070362e-03, 2.142411e-05},{-1.048938e-03, 2.339565e-05},
 {-1.025543e-03, 2.530913e-05},{-1.000233e-03, 2.716103e-05},{-9.730724e-04, 2.894799e-05},{-9.441244e-04, 3.066681e-05},
 {-9.134576e-04, 3.231443e-05},{-8.811432e-04, 3.388796e-05},{-8.472552e-04, 3.538466e-05},{-8.118706e-04, 3.680197e-05},
 {-7.750686e-04, 3.813752e-05},{-7.369311e-04, 3.938908e-05},{-6.975420e-04, 4.055463e-05},{-6.569874e-04, 4.163233e-05},
 {-6.153550e-04, 4.262051e-05},{-5.727345e-04, 4.351770e-05},{-5.292168e-04, 4.432263e-05},{-4.848942e-04, 4.503422e-05},
 {-4.398600e-04, 4.565156e-05},{-3.942084e-04, 4.617395e-05},{-3.480345e-04, 4.660090e-05},{-3.014336e-04, 4.693210e-05},
 {-2.545015e-04, 4.716742e-05},{-2.073340e-04, 4.730694e-05},{-1.600271e-04, 4.735093e-05},{-1.126762e-04, 4.729985e-05},
 {-6.537633e-05, 4.715435e-05},{-1.822198e-05, 4.691525e-05},{ 2.869327e-05, 4.658358e-05},{ 7.527685e-05, 4.616053e-05},
 { 1.214374e-04, 4.564747e-05},{ 1.670848e-04, 4.504594e-05},{ 2.121308e-04, 4.435767e-05},{ 2.564885e-04, 4.358452e-05},
 { 3.000730e-04, 4.272854e-05},{ 3.428015e-04, 4.179192e-05},{ 3.845934e-04, 4.077700e-05},{ 4.253704e-04, 3.968626e-05},
 { 4.650567e-04, 3.852234e-05},{ 5.035790e-04, 3.728799e-05},{ 5.408670e-04, 3.598608e-05},{ 5.768531e-04, 3.461962e-05},
 { 6.114727e-04, 3.319173e-05},{ 6.446645e-04, 3.170562e-05},{ 6.763701e-04, 3.016461e-05},{ 7.065347e-04, 2.857211e-05},
 { 7.351068e-04, 2.693162e-05},{ 7.620384e-04, 2.524669e-05},{ 7.872851e-04, 2.352098e-05},{ 8.108061e-04, 2.175817e-05},
 { 8.325643e-04, 1.996203e-05},{ 8.525263e-04, 1.813635e-05},{ 8.706626e-04, 1.628496e-05},{ 8.869476e-04, 1.441174e-05},
 { 9.013593e-04, 1.252057e-05},{ 9.138799e-04, 1.061535e-05},{ 9.244953e-04, 8.699987e-06},{ 9.331953e-04, 6.778388e-06},
 { 9.399736e-04, 4.854446e-06},{ 9.448281e-04, 2.932040e-06},{ 9.477601e-04, 1.015022e-06},{ 9.487751e-04,-8.927907e-07},
 { 9.478824e-04,-2.787618e-06},{ 9.450947e-04,-4.665730e-06},{ 9.404290e-04,-6.523451e-06},{ 9.339056e-04,-8.357167e-06},
 { 9.255484e-04,-1.016333e-05},{ 9.153851e-04,-1.193848e-05},{ 9.034466e-04,-1.367923e-05},{ 8.897673e-04,-1.538228e-05},
 { 8.743851e-04,-1.704442e-05},{ 8.573407e-04,-1.866255e-05},{ 8.386781e-04,-2.023369e-05},{ 8.184444e-04,-2.175494e-05},
 { 7.966895e-04,-2.322355e-05},{ 7.734659e-04,-2.463685e-05},{ 7.488291e-04,-2.599235e-05},{ 7.228367e-04,-2.728765e-05},
 { 6.955491e-04,-2.852049e-05},{ 6.670286e-04,-2.968877e-05},{ 6.373398e-04,-3.079051e-05},{ 6.065493e-04,-3.182390e-05},
 { 5.747254e-04,-3.278724e-05},{ 5.419382e-04,-3.367902e-05},{ 5.082591e-04,-3.449785e-05},{ 4.737613e-04,-3.524253e-05},
 { 4.385188e-04,-3.591199e-05},{ 4.026068e-04,-3.650532e-05},{ 3.661014e-04,-3.702178e-05},{ 3.290797e-04,-3.746077e-05},
 { 2.916189e-04,-3.782188e-05},{ 2.537970e-04,-3.810483e-05},{ 2.156922e-04,-3.830951e-05},{ 1.773827e-04,-3.843598e-05},
 { 1.389467e-04,-3.848443e-05},{ 1.004623e-04,-3.845523e-05},{ 6.200703e-05,-3.834890e-05},{ 2.365813e-05,-3.816610e-05},
 {-1.450798e-05,-3.790766e-05},{-5.241563e-05,-3.757453e-05},{-8.999017e-05,-3.716783e-05},{-1.271580e-04,-3.668882e-05},
 {-1.638468e-04,-3.613888e-05},{-1.999857e-04,-3.551954e-05},{-2.355052e-04,-3.483246e-05},{-2.703377e-04,-3.407942e-05},
 {-3.044171e-04,-3.326232e-05},{-3.376794e-04,-3.238320e-05},{-3.700626e-04,-3.144418e-05},{-4.015068e-04,-3.044752e-05},
 {-4.319543e-04,-2.939556e-05},{-4.613499e-04,-2.829075e-05},{-4.896406e-04,-2.713563e-05},{-5.167763e-04,-2.593282e-05},
 {-5.427091e-04,-2.468503e-05},{-5.673941e-04,-2.339504e-05},{-5.907892e-04,-2.206569e-05},{-6.128548e-04,-2.069991e-05},
 {-6.335548e-04,-1.930065e-05},{-6.528554e-04,-1.787094e-05},{-6.707264e-04,-1.641384e-05},{-6.871402e-04,-1.493245e-05},
 {-7.020726e-04,-1.342989e-05},{-7.155025e-04,-1.190933e-05},{-7.274119e-04,-1.037393e-05},{-7.377858e-04,-8.826873e-06},
 {-7.466127e-04,-7.271354e-06},{-7.538840e-04,-5.710554e-06},{-7.595946e-04,-4.147652e-06},{-7.637422e-04,-2.585812e-06},
 {-7.663280e-04,-1.028176e-06},{-7.673562e-04, 5.221408e-07},{-7.668341e-04, 2.062056e-06},{-7.647720e-04, 3.588528e-06},
 {-7.611835e-04, 5.098557e-06},{-7.560849e-04, 6.589197e-06},{-7.494957e-04, 8.057558e-06},{-7.414382e-04, 9.500812e-06},
 {-7.319374e-04, 1.091620e-05},{-7.210212e-04, 1.230103e-05},{-7.087201e-04, 1.365269e-05},{-6.950674e-04, 1.496866e-05},
 {-6.800988e-04, 1.624650e-05},{-6.638523e-04, 1.748385e-05},{-6.463684e-04, 1.867847e-05},{-6.276900e-04, 1.982819e-05},
 {-6.078618e-04, 2.093098e-05},{-5.869308e-04, 2.198488e-05},{-5.649459e-04, 2.298806e-05},{-5.419578e-04, 2.393880e-05},
 {-5.180190e-04, 2.483551e-05},{-4.931835e-04, 2.567669e-05},{-4.675068e-04, 2.646098e-05},{-4.410459e-04, 2.718714e-05},
 {-4.138587e-04, 2.785406e-05},{-3.860047e-04, 2.846075e-05},{-3.575439e-04, 2.900634e-05},{-3.285376e-04, 2.949011e-05},
 {-2.990475e-04, 2.991144e-05},{-2.691360e-04, 3.026986e-05},{-2.388662e-04, 3.056504e-05},{-2.083011e-04, 3.079676e-05},
 {-1.775044e-04, 3.096492e-05},{-1.465394e-04, 3.106959e-05},{-1.154698e-04, 3.111093e-05},{-8.435892e-05, 3.108923e-05},
 {-5.326969e-05, 3.100493e-05},{-2.226476e-05, 3.085858e-05},{ 8.593822e-06, 3.065084e-05},{ 3.924466e-05, 3.038251e-05},
 { 6.962718e-05, 3.005450e-05},{ 9.968168e-05, 2.966784e-05},{ 1.293495e-04, 2.922365e-05},{ 1.585732e-04, 2.872319e-05},
 { 1.872964e-04, 2.816781e-05},{ 2.154642e-04, 2.755897e-05},{ 2.430231e-04, 2.689822e-05},{ 2.699214e-04, 2.618721e-05},
 { 2.961086e-04, 2.542769e-05},{ 3.215363e-04, 2.462149e-05},{ 3.461578e-04, 2.377051e-05},{ 3.699283e-04, 2.287676e-05},
 { 3.928050e-04, 2.194230e-05},{ 4.147473e-04, 2.096927e-05},{ 4.357166e-04, 1.995987e-05},{ 4.556765e-04, 1.891636e-05},
 { 4.745928e-04, 1.784107e-05},{ 4.924339e-04, 1.673635e-05},{ 5.091702e-04, 1.560463e-05},{ 5.247749e-04, 1.444836e-05},
 { 5.392232e-04, 1.327003e-05},{ 5.524933e-04, 1.207215e-05},{ 5.645654e-04, 1.085727e-05},{ 5.754227e-04, 9.627952e-06},
 { 5.850506e-04, 8.386768e-06},{ 5.934374e-04, 7.136302e-06},{ 6.005737e-04, 5.879141e-06},{ 6.064528e-04, 4.617872e-06},
 { 6.110707e-04, 3.355070e-06},{ 6.144258e-04, 2.093300e-06},{ 6.165191e-04, 8.351101e-07},{ 6.173542e-04,-4.169759e-07},
 { 6.169372e-04,-1.660461e-06},{ 6.152768e-04,-2.892882e-06},{ 6.123839e-04,-4.111812e-06},{ 6.082721e-04,-5.314866e-06},
 { 6.029572e-04,-6.499707e-06},{ 5.964575e-04,-7.664048e-06},{ 5.887934e-04,-8.805658e-06},{ 5.799878e-04,-9.922366e-06},
 { 5.700654e-04,-1.101206e-05},{ 5.590534e-04,-1.207271e-05},{ 5.469806e-04,-1.310234e-05},{ 5.338783e-04,-1.409905e-05},
 { 5.197793e-04,-1.506104e-05},{ 5.047182e-04,-1.598657e-05},{ 4.887316e-04,-1.687398e-05},{ 4.718577e-04,-1.772172e-05},
 { 4.541359e-04,-1.852831e-05},{ 4.356076e-04,-1.929238e-05},{ 4.163152e-04,-2.001264e-05},{ 3.963026e-04,-2.068790e-05},
 { 3.756147e-04,-2.131707e-05},{ 3.542976e-04,-2.189916e-05},{ 3.323985e-04,-2.243329e-05},{ 3.099652e-04,-2.291866e-05},
 { 2.870465e-04,-2.335460e-05},{ 2.636919e-04,-2.374054e-05},{ 2.399514e-04,-2.407599e-05},{ 2.158754e-04,-2.436059e-05},
 { 1.915148e-04,-2.459408e-05},{ 1.669207e-04,-2.477631e-05},{ 1.421444e-04,-2.490722e-05},{ 1.172372e-04,-2.498686e-05},
 { 9.225035e-05,-2.501541e-05},{ 6.723494e-05,-2.499310e-05},{ 4.224184e-05,-2.492031e-05},{ 1.732153e-05,-2.479750e-05},
 {-7.475969e-06,-2.462523e-05},{-3.210119e-05,-2.440415e-05},{-5.650534e-05,-2.413501e-05},{-8.064036e-05,-2.381868e-05},
 {-1.044590e-04,-2.345607e-05},{-1.279151e-04,-2.304821e-05},{-1.509633e-04,-2.259622e-05},{-1.735595e-04,-2.210128e-05},
 {-1.956608e-04,-2.156467e-05},{-2.172255e-04,-2.098773e-05},{-2.382132e-04,-2.037190e-05},{-2.585851e-04,-1.971865e-05},
 {-2.783038e-04,-1.902956e-05},{-2.973333e-04,-1.830624e-05},{-3.156396e-04,-1.755038e-05},{-3.331899e-04,-1.676371e-05},
 {-3.499536e-04,-1.594802e-05},{-3.659017e-04,-1.510516e-05},{-3.810068e-04,-1.423700e-05},{-3.952438e-04,-1.334546e-05},
 {-4.085893e-04,-1.243250e-05},{-4.210218e-04,-1.150010e-05},{-4.325219e-04,-1.055029e-05},{-4.430722e-04,-9.585101e-06},
 {-4.526573e-04,-8.606586e-06},{-4.612639e-04,-7.616818e-06},{-4.688807e-04,-6.617878e-06},{-4.754986e-04,-5.611852e-06},
 {-4.811104e-04,-4.600828e-06},{-4.857112e-04,-3.586890e-06},{-4.892981e-04,-2.572117e-06},{-4.918702e-04,-1.558575e-06},
 {-4.934288e-04,-5.483142e-07},{-4.939771e-04, 4.566327e-07},{-4.935205e-04, 1.454258e-06},{-4.920662e-04, 2.442581e-06},
 {-4.896237e-04, 3.419652e-06},{-4.862040e-04, 4.383558e-06},{-4.818205e-04, 5.332422e-06},{-4.764880e-04, 6.264412e-06},
 {-4.702236e-04, 7.177740e-06},{-4.630459e-04, 8.070669e-06},{-4.549752e-04, 8.941511e-06},{-4.460337e-04, 9.788638e-06},
 {-4.362451e-04, 1.061048e-05},{-4.256346e-04, 1.140552e-05},{-4.142291e-04, 1.217231e-05},{-4.020567e-04, 1.290949e-05},
 {-3.891473e-04, 1.361572e-05},{-3.755315e-04, 1.428978e-05},{-3.612418e-04, 1.493050e-05},{-3.463113e-04, 1.553679e-05},
 {-3.307745e-04, 1.610763e-05},{-3.146668e-04, 1.664209e-05},{-2.980247e-04, 1.713931e-05},{-2.808854e-04, 1.759852e-05},
 {-2.632869e-04, 1.801902e-05},{-2.452679e-04, 1.840021e-05},{-2.268677e-04, 1.874156e-05},{-2.081261e-04, 1.904263e-05},
 {-1.890835e-04, 1.930306e-05},{-1.697804e-04, 1.952258e-05},{-1.502578e-04, 1.970102e-05},{-1.305568e-04, 1.983826e-05},
 {-1.107186e-04, 1.993428e-05},{-9.078428e-05, 1.998917e-05},{-7.079511e-05, 2.000306e-05},{-5.079205e-05, 1.997620e-05},
 {-3.081585e-05, 1.990889e-05},{-1.090696e-05, 1.980154e-05},{ 8.894581e-06, 1.965461e-05},{ 2.854919e-05, 1.946866e-05},
 { 4.801785e-05, 1.924432e-05},{ 6.726217e-05, 1.898229e-05},{ 8.624446e-05, 1.868334e-05},{ 1.049278e-04, 1.834832e-05},
 { 1.232761e-04, 1.797815e-05},{ 1.412543e-04, 1.757380e-05},{ 1.588281e-04, 1.713631e-05},{ 1.759644e-04, 1.666679e-05},
 { 1.926312e-04, 1.616640e-05},{ 2.087976e-04, 1.563636e-05},{ 2.244339e-04, 1.507794e-05},{ 2.395119e-04, 1.449246e-05},
 { 2.540043e-04, 1.388128e-05},{ 2.678856e-04, 1.324581e-05},{ 2.811314e-04, 1.258751e-05},{ 2.937189e-04, 1.190787e-05},
 { 3.056268e-04, 1.120840e-05},{ 3.168352e-04, 1.049066e-05},{ 3.273259e-04, 9.756231e-06},{ 3.370821e-04, 9.006714e-06},
 { 3.460888e-04, 8.243737e-06},{ 3.543325e-04, 7.468939e-06},{ 3.618015e-04, 6.683978e-06},{ 3.684855e-04, 5.890519e-06},
 { 3.743760e-04, 5.090234e-06},{ 3.794662e-04, 4.284798e-06},{ 3.837510e-04, 3.475888e-06},{ 3.872269e-04, 2.665174e-06},
 { 3.898921e-04, 1.854321e-06},{ 3.917464e-04, 1.044984e-06},{ 3.927914e-04, 2.388040e-07},{ 3.930302e-04,-5.625965e-07},
 { 3.924676e-04,-1.357614e-06},{ 3.911100e-04,-2.144667e-06},{ 3.889653e-04,-2.922204e-06},{ 3.860431e-04,-3.688698e-06},
 { 3.823544e-04,-4.442660e-06},{ 3.779117e-04,-5.182631e-06},{ 3.727291e-04,-5.907193e-06},{ 3.668219e-04,-6.614968e-06},
 { 3.602070e-04,-7.304621e-06},{ 3.529023e-04,-7.974861e-06},{ 3.449275e-04,-8.624449e-06},{ 3.363030e-04,-9.252192e-06},
 { 3.270508e-04,-9.856951e-06},{ 3.171939e-04,-1.043764e-05},{ 3.067562e-04,-1.099324e-05},{ 2.957630e-04,-1.152276e-05},
 { 2.842402e-04,-1.202531e-05},{ 2.722149e-04,-1.250003e-05},{ 2.597149e-04,-1.294613e-05},{ 2.467688e-04,-1.336290e-05},
 { 2.334059e-04,-1.374966e-05},{ 2.196562e-04,-1.410583e-05},{ 2.055504e-04,-1.443088e-05},{ 1.911195e-04,-1.472435e-05},
 { 1.763951e-04,-1.498584e-05},{ 1.614093e-04,-1.521503e-05},{ 1.461943e-04,-1.541167e-05},{ 1.307826e-04,-1.557556e-05},
 { 1.152071e-04,-1.570658e-05},{ 9.950047e-05,-1.580469e-05},{ 8.369578e-05,-1.586990e-05},{ 6.782588e-05,-1.590228e-05},
 { 5.192360e-05,-1.590199e-05},{ 3.602161e-05,-1.586925e-05},{ 2.015236e-05,-1.580433e-05},{ 4.348031e-06,-1.570757e-05},
 {-1.135954e-05,-1.557939e-05},{-2.693894e-05,-1.542026e-05},{-4.235919e-05,-1.523069e-05},{-5.758988e-05,-1.501128e-05},
 {-7.260116e-05,-1.476267e-05},{-8.736384e-05,-1.448557e-05},{-1.018494e-04,-1.418072e-05},{-1.160301e-04,-1.384894e-05},
 {-1.298791e-04,-1.349108e-05},{-1.433701e-04,-1.310804e-05},{-1.564782e-04,-1.270076e-05},{-1.691789e-04,-1.227026e-05},
 {-1.814492e-04,-1.181755e-05},{-1.932668e-04,-1.134371e-05},{-2.046105e-04,-1.084985e-05},{-2.154603e-04,-1.033711e-05},
 {-2.257974e-04,-9.806668e-06},{-2.356041e-04,-9.259720e-06},{-2.448638e-04,-8.697497e-06},{-2.535613e-04,-8.121251e-06},
 {-2.616826e-04,-7.532251e-06},{-2.692148e-04,-6.931790e-06},{-2.761466e-04,-6.321170e-06},{-2.824678e-04,-5.701709e-06},
 {-2.881695e-04,-5.074733e-06},{-2.932442e-04,-4.441575e-06},{-2.976858e-04,-3.803573e-06},{-3.014894e-04,-3.162064e-06},
 {-3.046514e-04,-2.518384e-06},{-3.071698e-04,-1.873866e-06},{-3.090437e-04,-1.229835e-06},{-3.102735e-04,-5.876058e-07},
 {-3.108611e-04, 5.151785e-08},{-3.108096e-04, 6.862483e-07},{-3.101234e-04, 1.315315e-06},{-3.088080e-04, 1.937467e-06},
 {-3.068706e-04, 2.551476e-06},{-3.043191e-04, 3.156140e-06},{-3.011630e-04, 3.750281e-06},{-2.974127e-04, 4.332753e-06},
 {-2.930799e-04, 4.902440e-06},{-2.881775e-04, 5.458260e-06},{-2.827192e-04, 5.999168e-06},{-2.767201e-04, 6.524154e-06},
 {-2.701959e-04, 7.032249e-06},{-2.631637e-04, 7.522525e-06},{-2.556411e-04, 7.994095e-06},{-2.476470e-04, 8.446119e-06},
 {-2.392009e-04, 8.877800e-06},{-2.303231e-04, 9.288390e-06},{-2.210347e-04, 9.677189e-06},{-2.113575e-04, 1.004354e-05},
 {-2.013140e-04, 1.038686e-05},{-1.909271e-04, 1.070657e-05},{-1.802206e-04, 1.100220e-05},{-1.692184e-04, 1.127329e-05},
 {-1.579451e-04, 1.151946e-05},{-1.464256e-04, 1.174036e-05},{-1.346852e-04, 1.193571e-05},{-1.227495e-04, 1.210529e-05},
 {-1.106442e-04, 1.224892e-05},{-9.839532e-05, 1.236647e-05},{-8.602885e-05, 1.245788e-05},{-7.357097e-05, 1.252315e-05},
 {-6.104782e-05, 1.256230e-05},{-4.848552e-05, 1.257544e-05},{-3.591008e-05, 1.256272e-05},{-2.334736e-05, 1.252434e-05},
 {-1.082302e-05, 1.246054e-05},{ 1.637521e-06, 1.237163e-05},{ 1.400915e-05, 1.225796e-05},{ 2.626711e-05, 1.211994e-05},
 { 3.838705e-05, 1.195800e-05},{ 5.034505e-05, 1.177264e-05},{ 6.211769e-05, 1.156441e-05},{ 7.368209e-05, 1.133388e-05},
 { 8.501597e-05, 1.108167e-05},{ 9.609764e-05, 1.080846e-05},{ 1.069061e-04, 1.051494e-05},{ 1.174210e-04, 1.020186e-05},
 { 1.276229e-04, 9.869986e-06},{ 1.374929e-04, 9.520131e-06},{ 1.470130e-04, 9.153135e-06},{ 1.561662e-04, 8.769867e-06},
 { 1.649360e-04, 8.371226e-06},{ 1.733073e-04, 7.958134e-06},{ 1.812654e-04, 7.531539e-06},{ 1.887969e-04, 7.092408e-06},
 { 1.958893e-04, 6.641728e-06},{ 2.025311e-04, 6.180504e-06},{ 2.087116e-04, 5.709756e-06},{ 2.144213e-04, 5.230515e-06},
 { 2.196518e-04, 4.743824e-06},{ 2.243957e-04, 4.250735e-06},{ 2.286464e-04, 3.752303e-06},{ 2.323987e-04, 3.249591e-06},
 { 2.356483e-04, 2.743661e-06},{ 2.383920e-04, 2.235575e-06},{ 2.406275e-04, 1.726392e-06},{ 2.423539e-04, 1.217166e-06},
 { 2.435711e-04, 7.089454e-07},{ 2.442800e-04, 2.027681e-07},{ 2.444828e-04,-3.003388e-07},{ 2.441825e-04,-7.993615e-07},
 { 2.433831e-04,-1.293302e-06},{ 2.420898e-04,-1.781178e-06},{ 2.403086e-04,-2.262027e-06},{ 2.380466e-04,-2.734910e-06},
 { 2.353117e-04,-3.198906e-06},{ 2.321128e-04,-3.653123e-06},{ 2.284597e-04,-4.096692e-06},{ 2.243630e-04,-4.528773e-06},
 { 2.198342e-04,-4.948557e-06},{ 2.148856e-04,-5.355263e-06},{ 2.095304e-04,-5.748144e-06},{ 2.037822e-04,-6.126485e-06},
 { 1.976557e-04,-6.489608e-06},{ 1.911661e-04,-6.836870e-06},{ 1.843293e-04,-7.167665e-06},{ 1.771616e-04,-7.481424e-06},
 { 1.696802e-04,-7.777618e-06},{ 1.619026e-04,-8.055758e-06},{ 1.538468e-04,-8.315396e-06},{ 1.455314e-04,-8.556124e-06},
 { 1.369753e-04,-8.777575e-06},{ 1.281977e-04,-8.979428e-06},{ 1.192183e-04,-9.161400e-06},{ 1.100569e-04,-9.323254e-06},
 { 1.007336e-04,-9.464794e-06},{ 9.126883e-05,-9.585870e-06},{ 8.168296e-05,-9.686373e-06},{ 7.199658e-05,-9.766237e-06},
 { 6.223035e-05,-9.825440e-06},{ 5.240491e-05,-9.864004e-06},{ 4.254090e-05,-9.881990e-06},{ 3.265891e-05,-9.879504e-06},
 { 2.277941e-05,-9.856692e-06},{ 1.292272e-05,-9.813743e-06},{ 3.108973e-06,-9.750883e-06},{-6.641911e-06,-9.668380e-06},
 {-1.631029e-05,-9.566540e-06},{-2.587683e-05,-9.445707e-06},{-3.532254e-05,-9.306262e-06},{-4.462880e-05,-9.148620e-06},
 {-5.377742e-05,-8.973234e-06},{-6.275066e-05,-8.780588e-06},{-7.153124e-05,-8.571199e-06},{-8.010244e-05,-8.345614e-06},
 {-8.844806e-05,-8.104413e-06},{-9.655247e-05,-7.848201e-06},{-1.044007e-04,-7.577610e-06},{-1.119783e-04,-7.293299e-06},
 {-1.192716e-04,-6.995951e-06},{-1.262675e-04,-6.686269e-06},{-1.329538e-04,-6.364978e-06},{-1.393188e-04,-6.032822e-06},
 {-1.453516e-04,-5.690563e-06},{-1.510422e-04,-5.338978e-06},{-1.563811e-04,-4.978856e-06},{-1.613600e-04,-4.611002e-06},
 {-1.659710e-04,-4.236229e-06},{-1.702072e-04,-3.855358e-06},{-1.740626e-04,-3.469219e-06},{-1.775318e-04,-3.078647e-06},
 {-1.806105e-04,-2.684478e-06},{-1.832949e-04,-2.287552e-06},{-1.855825e-04,-1.888708e-06},{-1.874712e-04,-1.488784e-06},
 {-1.889600e-04,-1.088613e-06},{-1.900486e-04,-6.890246e-07},{-1.907376e-04,-2.908395e-07},{-1.910284e-04, 1.051292e-07},
 {-1.909233e-04, 4.980785e-07},{-1.904252e-04, 8.872174e-07},{-1.895380e-04, 1.271768e-06},{-1.882663e-04, 1.650969e-06},
 {-1.866153e-04, 2.024072e-06},{-1.845912e-04, 2.390349e-06},{-1.822009e-04, 2.749092e-06},{-1.794518e-04, 3.099611e-06},
 {-1.763522e-04, 3.441238e-06},{-1.729109e-04, 3.773331e-06},{-1.691376e-04, 4.095269e-06},{-1.650423e-04, 4.406457e-06},
 {-1.606359e-04, 4.706329e-06},{-1.559295e-04, 4.994342e-06},{-1.509352e-04, 5.269984e-06},{-1.456652e-04, 5.532773e-06},
 {-1.401324e-04, 5.782256e-06},{-1.343502e-04, 6.018009e-06},{-1.283322e-04, 6.239641e-06},{-1.220925e-04, 6.446794e-06},
 {-1.156457e-04, 6.639141e-06},{-1.090066e-04, 6.816388e-06},{-1.021902e-04, 6.978275e-06},{-9.521194e-05, 7.124575e-06},
 {-8.808736e-05, 7.255095e-06},{-8.083227e-05, 7.369677e-06},{-7.346259e-05, 7.468196e-06},{-6.599440e-05, 7.550562e-06},
 {-5.844383e-05, 7.616719e-06},{-5.082711e-05, 7.666643e-06},{-4.316047e-05, 7.700347e-06},{-3.546012e-05, 7.717876e-06},
 {-2.774225e-05, 7.719307e-06},{-2.002294e-05, 7.704753e-06},{-1.231819e-05, 7.674356e-06},{-4.643831e-06, 7.628293e-06},
 { 2.984462e-06, 7.566768e-06},{ 1.055123e-05, 7.490021e-06},{ 1.804125e-05, 7.398318e-06},{ 2.543957e-05, 7.291955e-06},
 { 3.273152e-05, 7.171257e-06},{ 3.990278e-05, 7.036576e-06},{ 4.693936e-05, 6.888290e-06},{ 5.382765e-05, 6.726805e-06},
 { 6.055445e-05, 6.552549e-06},{ 6.710700e-05, 6.365974e-06},{ 7.347297e-05, 6.167554e-06},{ 7.964053e-05, 5.957786e-06},
 { 8.559831e-05, 5.737186e-06},{ 9.133550e-05, 5.506288e-06},{ 9.684179e-05, 5.265646e-06},{ 1.021074e-04, 5.015827e-06},
 { 1.071233e-04, 4.757416e-06},{ 1.118807e-04, 4.491010e-06},{ 1.163717e-04, 4.217219e-06},{ 1.205889e-04, 3.936664e-06},
 { 1.245256e-04, 3.649977e-06},{ 1.281755e-04, 3.357795e-06},{ 1.315333e-04, 3.060765e-06},{ 1.345941e-04, 2.759537e-06},
 { 1.373536e-04, 2.454769e-06},{ 1.398084e-04, 2.147117e-06},{ 1.419555e-04, 1.837241e-06},{ 1.437928e-04, 1.525801e-06},
 { 1.453186e-04, 1.213455e-06},{ 1.465320e-04, 9.008578e-07},{ 1.474329e-04, 5.886610e-07},{ 1.480215e-04, 2.775101e-07},
 { 1.482991e-04,-3.195590e-08},{ 1.482671e-04,-3.391060e-07},{ 1.479280e-04,-6.433187e-07},{ 1.472847e-04,-9.439829e-07},
 { 1.463407e-04,-1.240499e-06},{ 1.451002e-04,-1.532281e-06},{ 1.435679e-04,-1.818756e-06},{ 1.417492e-04,-2.099367e-06},
 { 1.396498e-04,-2.373572e-06},{ 1.372762e-04,-2.640848e-06},{ 1.346354e-04,-2.900689e-06},{ 1.317347e-04,-3.152607e-06},
 { 1.285821e-04,-3.396137e-06},{ 1.251859e-04,-3.630832e-06},{ 1.215551e-04,-3.856268e-06},{ 1.176988e-04,-4.072043e-06},
 { 1.136268e-04,-4.277777e-06},{ 1.093490e-04,-4.473114e-06},{ 1.048759e-04,-4.657725e-06},{ 1.002182e-04,-4.831301e-06},
 { 9.538688e-05,-4.993562e-06},{ 9.039331e-05,-5.144252e-06},{ 8.524906e-05,-5.283141e-06},{ 7.996592e-05,-5.410024e-06},
 { 7.455590e-05,-5.524725e-06},{ 6.903117e-05,-5.627094e-06},{ 6.340408e-05,-5.717006e-06},{ 5.768707e-05,-5.794365e-06},
 { 5.189271e-05,-5.859100e-06},{ 4.603360e-05,-5.911169e-06},{ 4.012244e-05,-5.950554e-06},{ 3.417188e-05,-5.977267e-06},
 { 2.819461e-05,-5.991342e-06},{ 2.220327e-05,-5.992843e-06},{ 1.621043e-05,-5.981859e-06},{ 1.022857e-05,-5.958502e-06},
 { 4.270069e-06,-5.922911e-06},{-1.652843e-06,-5.875250e-06},{-7.528093e-06,-5.815706e-06},{-1.334380e-05,-5.744490e-06},
 {-1.908829e-05,-5.661835e-06},{-2.475012e-05,-5.567996e-06},{-3.031812e-05,-5.463251e-06},{-3.578137e-05,-5.347899e-06},
 {-4.112927e-05,-5.222257e-06},{-4.635153e-05,-5.086661e-06},{-5.143819e-05,-4.941469e-06},{-5.637966e-05,-4.787052e-06},
 {-6.116671e-05,-4.623801e-06},{-6.579051e-05,-4.452120e-06},{-7.024263e-05,-4.272430e-06},{-7.451506e-05,-4.085164e-06},
 {-7.860023e-05,-3.890769e-06},{-8.249099e-05,-3.689702e-06},{-8.618070e-05,-3.482432e-06},{-8.966313e-05,-3.269438e-06},
 {-9.293257e-05,-3.051206e-06},{-9.598377e-05,-2.828230e-06},{-9.881200e-05,-2.601010e-06},{-1.014130e-04,-2.370053e-06},
 {-1.037831e-04,-2.135869e-06},{-1.059189e-04,-1.898969e-06},{-1.078179e-04,-1.659870e-06},{-1.094778e-04,-1.419086e-06},
 {-1.108969e-04,-1.177134e-06},{-1.120740e-04,-9.345280e-07},{-1.130085e-04,-6.917794e-07},{-1.137003e-04,-4.493969e-07},
 {-1.141497e-04,-2.078845e-07},{-1.143576e-04, 3.225919e-08},{-1.143253e-04, 2.705422e-07},{-1.140548e-04, 5.064798e-07},
 {-1.135483e-04, 7.395960e-07},{-1.128087e-04, 9.694240e-07},{-1.118393e-04, 1.195507e-06},{-1.106438e-04, 1.417400e-06},
 {-1.092264e-04, 1.634670e-06},{-1.075917e-04, 1.846896e-06},{-1.057448e-04, 2.053671e-06},{-1.036911e-04, 2.254603e-06},
 {-1.014365e-04, 2.449314e-06},{-9.898722e-05, 2.637443e-06},{-9.634978e-05, 2.818645e-06},{-9.353113e-05, 2.992591e-06},
 {-9.053854e-05, 3.158972e-06},{-8.737957e-05, 3.317494e-06},{-8.406207e-05, 3.467884e-06},{-8.059419e-05, 3.609887e-06},
 {-7.698430e-05, 3.743268e-06},{-7.324103e-05, 3.867812e-06},{-6.937322e-05, 3.983322e-06},{-6.538990e-05, 4.089625e-06},
 {-6.130028e-05, 4.186565e-06},{-5.711371e-05, 4.274009e-06},{-5.283970e-05, 4.351845e-06},{-4.848786e-05, 4.419980e-06},
 {-4.406788e-05, 4.478344e-06},{-3.958953e-05, 4.526887e-06},{-3.506264e-05, 4.565581e-06},{-3.049706e-05, 4.594417e-06},
 {-2.590265e-05, 4.613409e-06},{-2.128924e-05, 4.622590e-06},{-1.666665e-05, 4.622014e-06},{-1.204463e-05, 4.611755e-06},
 {-7.432879e-06, 4.591906e-06},{-2.840972e-06, 4.562582e-06},{ 1.721609e-06, 4.523913e-06},{ 6.245522e-06, 4.476052e-06},
 { 1.072157e-05, 4.419166e-06},{ 1.514074e-05, 4.353444e-06},{ 1.949418e-05, 4.279089e-06},{ 2.377327e-05, 4.196322e-06},
 { 2.796960e-05, 4.105379e-06},{ 3.207497e-05, 4.006513e-06},{ 3.608149e-05, 3.899991e-06},{ 3.998148e-05, 3.786094e-06},
 { 4.376757e-05, 3.665117e-06},{ 4.743269e-05, 3.537366e-06},{ 5.097006e-05, 3.403161e-06},{ 5.437322e-05, 3.262833e-06},
 { 5.763605e-05, 3.116722e-06},{ 6.075277e-05, 2.965179e-06},{ 6.371795e-05, 2.808564e-06},{ 6.652652e-05, 2.647244e-06},
 { 6.917376e-05, 2.481593e-06},{ 7.165535e-05, 2.311993e-06},{ 7.396735e-05, 2.138829e-06},{ 7.610617e-05, 1.962494e-06},
 { 7.806867e-05, 1.783382e-06},{ 7.985205e-05, 1.601890e-06},{ 8.145394e-05, 1.418419e-06},{ 8.287236e-05, 1.233370e-06},
 { 8.410573e-05, 1.047144e-06},{ 8.515287e-05, 8.601415e-07},{ 8.601301e-05, 6.727631e-07},{ 8.668578e-05, 4.854057e-07},
 { 8.717118e-05, 2.984638e-07},{ 8.746965e-05, 1.123281e-07},{ 8.758197e-05,-7.261558e-08},{ 8.750936e-05,-2.559865e-07},
 { 8.725337e-05,-4.374101e-07},{ 8.681596e-05,-6.165189e-07},{ 8.619944e-05,-7.929530e-07},{ 8.540649e-05,-9.663605e-07},
 { 8.444013e-05,-1.136399e-06},{ 8.330373e-05,-1.302735e-06},{ 8.200100e-05,-1.465047e-06},{ 8.053595e-05,-1.623022e-06},
 { 7.891293e-05,-1.776360e-06},{ 7.713657e-05,-1.924773e-06},{ 7.521179e-05,-2.067985e-06},{ 7.314381e-05,-2.205734e-06},
 { 7.093807e-05,-2.337769e-06},{ 6.860031e-05,-2.463857e-06},{ 6.613645e-05,-2.583776e-06},{ 6.355267e-05,-2.697319e-06},
 { 6.085535e-05,-2.804296e-06},{ 5.805106e-05,-2.904530e-06},{ 5.514653e-05,-2.997862e-06},{ 5.214867e-05,-3.084147e-06},
 { 4.906452e-05,-3.163255e-06},{ 4.590126e-05,-3.235075e-06},{ 4.266619e-05,-3.299511e-06},{ 3.936668e-05,-3.356482e-06},
 { 3.601020e-05,-3.405925e-06},{ 3.260427e-05,-3.447794e-06},{ 2.915648e-05,-3.482056e-06},{ 2.567442e-05,-3.508699e-06},
 { 2.216572e-05,-3.527724e-06},{ 1.863800e-05,-3.539148e-06},{ 1.509885e-05,-3.543006e-06},{ 1.155584e-05,-3.539348e-06},
 { 8.016496e-06,-3.528239e-06},{ 4.488257e-06,-3.509758e-06},{ 9.784991e-07,-3.484003e-06},{-2.505504e-06,-3.451083e-06},
 {-5.956587e-06,-3.411122e-06},{-9.367709e-06,-3.364260e-06},{-1.273197e-05,-3.310648e-06},{-1.604262e-05,-3.250451e-06},
 {-1.929307e-05,-3.183849e-06},{-2.247692e-05,-3.111030e-06},{-2.558795e-05,-3.032198e-06},{-2.862014e-05,-2.947564e-06},
 {-3.156771e-05,-2.857354e-06},{-3.442506e-05,-2.761801e-06},{-3.718686e-05,-2.661149e-06},{-3.984801e-05,-2.555650e-06},
 {-4.240366e-05,-2.445565e-06},{-4.484923e-05,-2.331164e-06},{-4.718039e-05,-2.212722e-06},{-4.939311e-05,-2.090522e-06},
 {-5.148363e-05,-1.964851e-06},{-5.344849e-05,-1.836003e-06},{-5.528449e-05,-1.704277e-06},{-5.698877e-05,-1.569973e-06},
 {-5.855874e-05,-1.433396e-06},{-5.999213e-05,-1.294856e-06},{-6.128699e-05,-1.154659e-06},{-6.244165e-05,-1.013118e-06},
 {-6.345477e-05,-8.705432e-07},{-6.432531e-05,-7.272451e-07},{-6.505256e-05,-5.835340e-07},{-6.563609e-05,-4.397185e-07},
 {-6.607581e-05,-2.961048e-07},{-6.637191e-05,-1.529968e-07},{-6.652491e-05,-1.069455e-08},{-6.653560e-05, 1.305055e-07},
 {-6.640510e-05, 2.703118e-07},{-6.613479e-05, 4.084378e-07},{-6.572635e-05, 5.446028e-07},{-6.518175e-05, 6.785324e-07},
 {-6.450321e-05, 8.099591e-07},{-6.369326e-05, 9.386226e-07},{-6.275463e-05, 1.064271e-06},{-6.169036e-05, 1.186659e-06},
 {-6.050370e-05, 1.305553e-06},{-5.919815e-05, 1.420727e-06},{-5.777742e-05, 1.531963e-06},{-5.624546e-05, 1.639057e-06},
 {-5.460640e-05, 1.741812e-06},{-5.286459e-05, 1.840043e-06},{-5.102455e-05, 1.933576e-06},{-4.909097e-05, 2.022249e-06},
 {-4.706872e-05, 2.105911e-06},{-4.496281e-05, 2.184421e-06},{-4.277839e-05, 2.257654e-06},{-4.052074e-05, 2.325494e-06},
 {-3.819524e-05, 2.387839e-06},{-3.580740e-05, 2.444599e-06},{-3.336280e-05, 2.495696e-06},{-3.086711e-05, 2.541066e-06},
 {-2.832604e-05, 2.580657e-06},{-2.574539e-05, 2.614430e-06},{-2.313096e-05, 2.642358e-06},{-2.048860e-05, 2.664427e-06},
 {-1.782417e-05, 2.680637e-06},{-1.514353e-05, 2.690999e-06},{-1.245253e-05, 2.695536e-06},{-9.756999e-06, 2.694284e-06},
 {-7.062715e-06, 2.687293e-06},{-4.375422e-06, 2.674621e-06},{-1.700801e-06, 2.656342e-06},{ 9.555409e-07, 2.632537e-06},
 { 3.588078e-06, 2.603301e-06},{ 6.191379e-06, 2.568740e-06},{ 8.760119e-06, 2.528970e-06},{ 1.128909e-05, 2.484116e-06},
 { 1.377320e-05, 2.434315e-06},{ 1.620752e-05, 2.379713e-06},{ 1.858723e-05, 2.320464e-06},{ 2.090770e-05, 2.256731e-06},
 { 2.316443e-05, 2.188687e-06},{ 2.535312e-05, 2.116511e-06},{ 2.746963e-05, 2.040391e-06},{ 2.951002e-05, 1.960521e-06},
 { 3.147054e-05, 1.877102e-06},{ 3.334764e-05, 1.790340e-06},{ 3.513798e-05, 1.700447e-06},{ 3.683843e-05, 1.607643e-06},
 { 3.844607e-05, 1.512148e-06},{ 3.995822e-05, 1.414188e-06},{ 4.137241e-05, 1.313994e-06},{ 4.268640e-05, 1.211797e-06},
 { 4.389820e-05, 1.107834e-06},{ 4.500603e-05, 1.002340e-06},{ 4.600837e-05, 8.955557e-07},{ 4.690393e-05, 7.877193e-07},
 { 4.769165e-05, 6.790709e-07},{ 4.837072e-05, 5.698503e-07},{ 4.894057e-05, 4.602966e-07},{ 4.940086e-05, 3.506478e-07},
 { 4.975151e-05, 2.411403e-07},{ 4.999265e-05, 1.320081e-07},{ 5.012466e-05, 2.348276e-08},{ 5.014814e-05,-8.420721e-08},
 { 5.006394e-05,-1.908370e-07},{ 4.987310e-05,-2.961858e-07},{ 4.957691e-05,-4.000373e-07},{ 4.917688e-05,-5.021801e-07},
 { 4.867470e-05,-6.024080e-07},{ 4.807229e-05,-7.005209e-07},{ 4.737177e-05,-7.963244e-07},{ 4.657544e-05,-8.896308e-07},
 { 4.568581e-05,-9.802593e-07},{ 4.470555e-05,-1.068036e-06},{ 4.363752e-05,-1.152795e-06},{ 4.248472e-05,-1.234378e-06},
 { 4.125034e-05,-1.312635e-06},{ 3.993771e-05,-1.387423e-06},{ 3.855028e-05,-1.458610e-06},{ 3.709167e-05,-1.526070e-06},
 { 3.556560e-05,-1.589689e-06},{ 3.397591e-05,-1.649360e-06},{ 3.232655e-05,-1.704987e-06},{ 3.062157e-05,-1.756481e-06},
 { 2.886509e-05,-1.803765e-06},{ 2.706132e-05,-1.846771e-06},{ 2.521455e-05,-1.885441e-06},{ 2.332911e-05,-1.919725e-06},
 { 2.140938e-05,-1.949586e-06},{ 1.945980e-05,-1.974995e-06},{ 1.748480e-05,-1.995933e-06},{ 1.548887e-05,-2.012390e-06},
 { 1.347648e-05,-2.024368e-06},{ 1.145211e-05,-2.031877e-06},{ 9.420235e-06,-2.034936e-06},{ 7.385299e-06,-2.033576e-06},
 { 5.351723e-06,-2.027834e-06},{ 3.323889e-06,-2.017760e-06},{ 1.306130e-06,-2.003409e-06},{-6.972791e-07,-1.984848e-06},
 {-2.682127e-06,-1.962151e-06},{-4.644278e-06,-1.935400e-06},{-6.579678e-06,-1.904688e-06},{-8.484366e-06,-1.870112e-06},
 {-1.035448e-05,-1.831778e-06},{-1.218626e-05,-1.789801e-06},{-1.397606e-05,-1.744301e-06},{-1.572036e-05,-1.695405e-06},
 {-1.741576e-05,-1.643247e-06},{-1.905901e-05,-1.587967e-06},{-2.064698e-05,-1.529710e-06},{-2.217668e-05,-1.468626e-06},
 {-2.364531e-05,-1.404872e-06},{-2.505018e-05,-1.338608e-06},{-2.638879e-05,-1.269997e-06},{-2.765879e-05,-1.199209e-06},
 {-2.885800e-05,-1.126414e-06},{-2.998441e-05,-1.051787e-06},{-3.103620e-05,-9.755056e-07},{-3.201170e-05,-8.977486e-07},
 {-3.290945e-05,-8.186971e-07},{-3.372815e-05,-7.385336e-07},{-3.446668e-05,-6.574416e-07},{-3.512413e-05,-5.756050e-07},
 {-3.569973e-05,-4.932079e-07},{-3.619294e-05,-4.104342e-07},{-3.660337e-05,-3.274671e-07},{-3.693084e-05,-2.444887e-07},
 {-3.717533e-05,-1.616798e-07},{-3.733701e-05,-7.921923e-08},{-3.741623e-05, 2.716247e-09},{-3.741351e-05, 8.395250e-08},
 {-3.732956e-05, 1.643183e-07},{-3.716524e-05, 2.436457e-07},{-3.692159e-05, 3.217704e-07},{-3.659982e-05, 3.985319e-07},
 {-3.620129e-05, 4.737743e-07},{-3.572752e-05, 5.473458e-07},{-3.518017e-05, 6.190999e-07},{-3.456107e-05, 6.888951e-07},
 {-3.387218e-05, 7.565951e-07},{-3.311558e-05, 8.220697e-07},{-3.229351e-05, 8.851942e-07},{-3.140832e-05, 9.458504e-07},
 {-3.046247e-05, 1.003926e-06},{-2.945854e-05, 1.059316e-06},{-2.839923e-05, 1.111922e-06},{-2.728730e-05, 1.161651e-06},
 {-2.612565e-05, 1.208418e-06},{-2.491724e-05, 1.252147e-06},{-2.366509e-05, 1.292767e-06},{-2.237232e-05, 1.330214e-06},
 {-2.104211e-05, 1.364434e-06},{-1.967767e-05, 1.395378e-06},{-1.828229e-05, 1.423006e-06},{-1.685929e-05, 1.447285e-06},
 {-1.541200e-05, 1.468190e-06},{-1.394381e-05, 1.485704e-06},{-1.245811e-05, 1.499815e-06},{-1.095829e-05, 1.510522e-06},
 {-9.447772e-06, 1.517830e-06},{-7.929942e-06, 1.521751e-06},{-6.408191e-06, 1.522305e-06},{-4.885886e-06, 1.519519e-06},
 {-3.366366e-06, 1.513427e-06},{-1.852939e-06, 1.504071e-06},{-3.488684e-07, 1.491497e-06},{ 1.142629e-06, 1.475762e-06},
 { 2.618390e-06, 1.456925e-06},{ 4.075315e-06, 1.435055e-06},{ 5.510370e-06, 1.410224e-06},{ 6.920594e-06, 1.382514e-06},
 { 8.303108e-06, 1.352007e-06},{ 9.655115e-06, 1.318797e-06},{ 1.097391e-05, 1.282977e-06},{ 1.225689e-05, 1.244650e-06},
 { 1.350154e-05, 1.203920e-06},{ 1.470546e-05, 1.160898e-06},{ 1.586636e-05, 1.115697e-06},{ 1.698205e-05, 1.068436e-06},
 { 1.805049e-05, 1.019236e-06},{ 1.906973e-05, 9.682226e-07},{ 2.003795e-05, 9.155227e-07},{ 2.095347e-05, 8.612672e-07},
 { 2.181474e-05, 8.055889e-07},{ 2.262033e-05, 7.486226e-07},{ 2.336895e-05, 6.905050e-07},{ 2.405946e-05, 6.313742e-07},
 { 2.469083e-05, 5.713693e-07},{ 2.526220e-05, 5.106302e-07},{ 2.577283e-05, 4.492974e-07},{ 2.622213e-05, 3.875113e-07},
 { 2.660964e-05, 3.254124e-07},{ 2.693505e-05, 2.631407e-07},{ 2.719819e-05, 2.008352e-07},{ 2.739903e-05, 1.386340e-07},
 { 2.753766e-05, 7.667392e-08},{ 2.761433e-05, 1.508993e-08},{ 2.762942e-05,-4.598487e-08},{ 2.758344e-05,-1.064196e-07},
 { 2.747702e-05,-1.660859e-07},{ 2.731093e-05,-2.248583e-07},{ 2.708608e-05,-2.826141e-07},{ 2.680346e-05,-3.392340e-07},
 { 2.646423e-05,-3.946023e-07},{ 2.606962e-05,-4.486069e-07},{ 2.562102e-05,-5.011398e-07},{ 2.511988e-05,-5.520971e-07},
 { 2.456778e-05,-6.013792e-07},{ 2.396640e-05,-6.488911e-07},{ 2.331751e-05,-6.945426e-07},{ 2.262297e-05,-7.382483e-07},
 { 2.188472e-05,-7.799279e-07},{ 2.110479e-05,-8.195062e-07},{ 2.028529e-05,-8.569133e-07},{ 1.942837e-05,-8.920849e-07},
 { 1.853629e-05,-9.249621e-07},{ 1.761133e-05,-9.554914e-07},{ 1.665583e-05,-9.836253e-07},{ 1.567221e-05,-1.009322e-06},
 { 1.466289e-05,-1.032545e-06},{ 1.363034e-05,-1.053265e-06},{ 1.257708e-05,-1.071456e-06},{ 1.150562e-05,-1.087100e-06},
 { 1.041852e-05,-1.100185e-06},{ 9.318336e-06,-1.110704e-06},{ 8.207632e-06,-1.118654e-06},{ 7.088978e-06,-1.124042e-06},
 { 5.964936e-06,-1.126877e-06},{ 4.838059e-06,-1.127175e-06},{ 3.710884e-06,-1.124958e-06},{ 2.585926e-06,-1.120251e-06},
 { 1.465674e-06,-1.113089e-06},{ 3.525855e-07,-1.103508e-06},{-7.509220e-07,-1.091550e-06},{-1.842472e-06,-1.077263e-06},
 {-2.919734e-06,-1.060699e-06},{-3.980434e-06,-1.041916e-06},{-5.022350e-06,-1.020975e-06},{-6.043325e-06,-9.979412e-07},
 {-7.041266e-06,-9.728849e-07},{-8.014151e-06,-9.458800e-07},{-8.960031e-06,-9.170040e-07},{-9.877035e-06,-8.863381e-07},
 {-1.076337e-05,-8.539667e-07},{-1.161734e-05,-8.199775e-07},{-1.243732e-05,-7.844609e-07},{-1.322178e-05,-7.475101e-07},
 {-1.396929e-05,-7.092207e-07},{-1.467851e-05,-6.696903e-07},{-1.534820e-05,-6.290188e-07},{-1.597722e-05,-5.873076e-07},
 {-1.656453e-05,-5.446596e-07},{-1.710919e-05,-5.011791e-07},{-1.761036e-05,-4.569710e-07},{-1.806734e-05,-4.121413e-07},
 {-1.847948e-05,-3.667965e-07},{-1.884627e-05,-3.210431e-07},{-1.916732e-05,-2.749877e-07},{-1.944230e-05,-2.287369e-07},
 {-1.967104e-05,-1.823964e-07},{-1.985344e-05,-1.360717e-07},{-1.998951e-05,-8.986699e-08},{-2.007938e-05,-4.388541e-08},
 {-2.012326e-05, 1.771259e-09},{-2.012149e-05, 4.700288e-08},{-2.007449e-05, 9.171111e-08},{-1.998278e-05, 1.357996e-07},
 {-1.984698e-05, 1.791744e-07},{-1.966780e-05, 2.217438e-07},{-1.944606e-05, 2.634187e-07},{-1.918264e-05, 3.041128e-07},
 {-1.887853e-05, 3.437430e-07},{-1.853478e-05, 3.822290e-07},{-1.815255e-05, 4.194940e-07},{-1.773306e-05, 4.554644e-07},
 {-1.727760e-05, 4.900705e-07},{-1.678753e-05, 5.232460e-07},{-1.626428e-05, 5.549285e-07},{-1.570935e-05, 5.850597e-07},
 {-1.512429e-05, 6.135851e-07},{-1.451071e-05, 6.404544e-07},{-1.387025e-05, 6.656215e-07},{-1.320463e-05, 6.890447e-07},
 {-1.251559e-05, 7.106863e-07},{-1.180490e-05, 7.305133e-07},{-1.107439e-05, 7.484969e-07},{-1.032589e-05, 7.646130e-07},
 {-9.561277e-06, 7.788417e-07},{-8.782435e-06, 7.911677e-07},{-7.991267e-06, 8.015801e-07},{-7.189687e-06, 8.100726e-07},
 {-6.379615e-06, 8.166433e-07},{-5.562971e-06, 8.212944e-07},{-4.741677e-06, 8.240330e-07},{-3.917644e-06, 8.248700e-07},
 {-3.092774e-06, 8.238208e-07},{-2.268953e-06, 8.209051e-07},{-1.448048e-06, 8.161463e-07},{-6.319017e-07, 8.095722e-07},
 { 1.776705e-07, 8.012143e-07},{ 9.788848e-07, 7.911079e-07},{ 1.769993e-06, 7.792922e-07},{ 2.549285e-06, 7.658097e-07},
 { 3.315095e-06, 7.507064e-07},{ 4.065801e-06, 7.340319e-07},{ 4.799833e-06, 7.158385e-07},{ 5.515671e-06, 6.961820e-07},
 { 6.211853e-06, 6.751207e-07},{ 6.886974e-06, 6.527157e-07},{ 7.539690e-06, 6.290309e-07},{ 8.168721e-06, 6.041322e-07},
 { 8.772853e-06, 5.780879e-07},{ 9.350941e-06, 5.509685e-07},{ 9.901909e-06, 5.228459e-07},{ 1.042476e-05, 4.937941e-07},
 { 1.091855e-05, 4.638884e-07},{ 1.138244e-05, 4.332055e-07},{ 1.181564e-05, 4.018230e-07},{ 1.221747e-05, 3.698197e-07},
 { 1.258729e-05, 3.372749e-07},{ 1.292456e-05, 3.042686e-07},{ 1.322883e-05, 2.708811e-07},{ 1.349971e-05, 2.371929e-07},
 { 1.373690e-05, 2.032844e-07},{ 1.394019e-05, 1.692360e-07},{ 1.410942e-05, 1.351273e-07},{ 1.424455e-05, 1.010378e-07},
 { 1.434559e-05, 6.704603e-08},{ 1.441264e-05, 3.322953e-08},{ 1.444586e-05,-3.351466e-10},{ 1.444553e-05,-3.357273e-08},
 { 1.441196e-05,-6.640941e-08},{ 1.434555e-05,-9.877293e-08},{ 1.424677e-05,-1.305928e-07},{ 1.411618e-05,-1.618004e-07},
 { 1.395438e-05,-1.923292e-07},{ 1.376205e-05,-2.221148e-07},{ 1.353994e-05,-2.510950e-07},{ 1.328884e-05,-2.792102e-07},
 { 1.300963e-05,-3.064033e-07},{ 1.270323e-05,-3.326198e-07},{ 1.237061e-05,-3.578080e-07},{ 1.201280e-05,-3.819190e-07},
 { 1.163088e-05,-4.049070e-07},{ 1.122598e-05,-4.267290e-07},{ 1.079925e-05,-4.473453e-07},{ 1.035190e-05,-4.667192e-07},
 { 9.885181e-06,-4.848174e-07},{ 9.400364e-06,-5.016098e-07},{ 8.898754e-06,-5.170695e-07},{ 8.381685e-06,-5.311731e-07},
 { 7.850512e-06,-5.439006e-07},{ 7.306611e-06,-5.552353e-07},{ 6.751376e-06,-5.651639e-07},{ 6.186212e-06,-5.736766e-07},
 { 5.612535e-06,-5.807669e-07},{ 5.031768e-06,-5.864318e-07},{ 4.445337e-06,-5.906717e-07},{ 3.854665e-06,-5.934900e-07},
 { 3.261175e-06,-5.948938e-07},{ 2.666281e-06,-5.948933e-07},{ 2.071388e-06,-5.935019e-07},{ 1.477886e-06,-5.907361e-07},
 { 8.871497e-07,-5.866155e-07},{ 3.005343e-07,-5.811627e-07},{-2.806285e-07,-5.744034e-07},{-8.550318e-07,-5.663658e-07},
 {-1.421398e-06,-5.570812e-07},{-1.978479e-06,-5.465833e-07},{-2.525062e-06,-5.349084e-07},{-3.059971e-06,-5.220954e-07},
 {-3.582066e-06,-5.081854e-07},{-4.090251e-06,-4.932216e-07},{-4.583473e-06,-4.772495e-07},{-5.060722e-06,-4.603164e-07},
 {-5.521039e-06,-4.424716e-07},{-5.963510e-06,-4.237659e-07},{-6.387276e-06,-4.042520e-07},{-6.791528e-06,-3.839835e-07},
 {-7.175512e-06,-3.630159e-07},{-7.538528e-06,-3.414053e-07},{-7.879933e-06,-3.192092e-07},{-8.199142e-06,-2.964858e-07},
 {-8.495628e-06,-2.732939e-07},{-8.768922e-06,-2.496932e-07},{-9.018615e-06,-2.257434e-07},{-9.244359e-06,-2.015047e-07},
 {-9.445863e-06,-1.770376e-07},{-9.622901e-06,-1.524022e-07},{-9.775303e-06,-1.276588e-07},{-9.902962e-06,-1.028672e-07},
 {-1.000583e-05,-7.808677e-08},{-1.008392e-05,-5.337636e-08},{-1.013729e-05,-2.879409e-08},{-1.016609e-05,-4.397233e-09},
 {-1.017048e-05, 1.975790e-08},{-1.015073e-05, 4.361611e-08},{-1.010711e-05, 6.712342e-08},{-1.003999e-05, 9.022719e-08},
 {-9.949759e-06, 1.128762e-07},{-9.836883e-06, 1.350210e-07},{-9.701862e-06, 1.566134e-07},{-9.545248e-06, 1.776074e-07},
 {-9.367641e-06, 1.979586e-07},{-9.169682e-06, 2.176247e-07},{-8.952058e-06, 2.365654e-07},{-8.715492e-06, 2.547424e-07},
 {-8.460750e-06, 2.721199e-07},{-8.188630e-06, 2.886640e-07},{-7.899966e-06, 3.043433e-07},{-7.595623e-06, 3.191288e-07},
 {-7.276494e-06, 3.329938e-07},{-6.943500e-06, 3.459143e-07},{-6.597586e-06, 3.578685e-07},{-6.239717e-06, 3.688373e-07},
 {-5.870880e-06, 3.788043e-07},{-5.492076e-06, 3.877554e-07},{-5.104320e-06, 3.956792e-07},{-4.708641e-06, 4.025669e-07},
 {-4.306074e-06, 4.084123e-07},{-3.897662e-06, 4.132118e-07},{-3.484450e-06, 4.169643e-07},{-3.067486e-06, 4.196712e-07},
 {-2.647815e-06, 4.213367e-07},{-2.226478e-06, 4.219671e-07},{-1.804511e-06, 4.215715e-07},{-1.382940e-06, 4.201611e-07},
 {-9.627785e-07, 4.177497e-07},{-5.450288e-07, 4.143532e-07},{-1.306757e-07, 4.099899e-07},{ 2.793142e-07, 4.046802e-07},
 { 6.839943e-07, 3.984466e-07},{ 1.082441e-06, 3.913138e-07},{ 1.473755e-06, 3.833082e-07},{ 1.857063e-06, 3.744582e-07},
 { 2.231521e-06, 3.647940e-07},{ 2.596315e-06, 3.543475e-07},{ 2.950663e-06, 3.431523e-07},{ 3.293815e-06, 3.312432e-07},
 { 3.625058e-06, 3.186567e-07},{ 3.943715e-06, 3.054305e-07},{ 4.249145e-06, 2.916036e-07},{ 4.540749e-06, 2.772159e-07},
 { 4.817965e-06, 2.623085e-07},{ 5.080273e-06, 2.469233e-07},{ 5.327197e-06, 2.311028e-07},{ 5.558299e-06, 2.148905e-07},
 { 5.773190e-06, 1.983302e-07},{ 5.971520e-06, 1.814661e-07},{ 6.152986e-06, 1.643428e-07},{ 6.317329e-06, 1.470052e-07},
 { 6.464334e-06, 1.294981e-07},{ 6.593832e-06, 1.118664e-07},{ 6.705699e-06, 9.415479e-08},{ 6.799853e-06, 7.640783e-08},
 { 6.876261e-06, 5.866963e-08},{ 6.934931e-06, 4.098390e-08},{ 6.975915e-06, 2.339377e-08},{ 6.999309e-06, 5.941721e-09},
 { 7.005250e-06,-1.133054e-08},{ 6.993920e-06,-2.838215e-08},{ 6.965538e-06,-4.517320e-08},{ 6.920364e-06,-6.166484e-08},
 { 6.858700e-06,-7.781931e-08},{ 6.780880e-06,-9.360010e-08},{ 6.687280e-06,-1.089720e-07},{ 6.578308e-06,-1.239010e-07},
 { 6.454407e-06,-1.383549e-07},{ 6.316052e-06,-1.523026e-07},{ 6.163750e-06,-1.657147e-07},{ 5.998035e-06,-1.785637e-07},
 { 5.819471e-06,-1.908233e-07},{ 5.628648e-06,-2.024694e-07},{ 5.426179e-06,-2.134793e-07},{ 5.212699e-06,-2.238323e-07},
 { 4.988867e-06,-2.335096e-07},{ 4.755358e-06,-2.424942e-07},{ 4.512863e-06,-2.507709e-07},{ 4.262092e-06,-2.583267e-07},
 { 4.003766e-06,-2.651503e-07},{ 3.738615e-06,-2.712325e-07},{ 3.467383e-06,-2.765660e-07},{ 3.190817e-06,-2.811454e-07},
 { 2.909671e-06,-2.849673e-07},{ 2.624704e-06,-2.880304e-07},{ 2.336674e-06,-2.903350e-07},{ 2.046339e-06,-2.918836e-07},
 { 1.754455e-06,-2.926805e-07},{ 1.461775e-06,-2.927319e-07},{ 1.169043e-06,-2.920456e-07},{ 8.769972e-07,-2.906314e-07},
 { 5.863657e-07,-2.885009e-07},{ 2.978648e-07,-2.856673e-07},{ 1.219747e-08,-2.821454e-07},{-2.699479e-07,-2.779516e-07},
 {-5.478996e-07,-2.731040e-07},{-8.210036e-07,-2.676220e-07},{-1.088626e-06,-2.615265e-07},{-1.350152e-06,-2.548397e-07},
 {-1.604992e-06,-2.475852e-07},{-1.852577e-06,-2.397876e-07},{-2.092365e-06,-2.314728e-07},{-2.323837e-06,-2.226678e-07},
 {-2.546505e-06,-2.134004e-07},{-2.759906e-06,-2.036994e-07},{-2.963605e-06,-1.935944e-07},{-3.157200e-06,-1.831158e-07},
 {-3.340315e-06,-1.722946e-07},{-3.512610e-06,-1.611622e-07},{-3.673772e-06,-1.497508e-07},{-3.823523e-06,-1.380926e-07},
 {-3.961616e-06,-1.262205e-07},{-4.087836e-06,-1.141673e-07},{-4.202003e-06,-1.019661e-07},{-4.303969e-06,-8.964999e-08},
 {-4.393619e-06,-7.725199e-08},{-4.470871e-06,-6.480501e-08},{-4.535676e-06,-5.234176e-08},{-4.588018e-06,-3.989462e-08},
 {-4.627913e-06,-2.749562e-08},{-4.655408e-06,-1.517632e-08},{-4.670585e-06,-2.967728e-09},{-4.673552e-06, 9.099735e-09},
 {-4.664453e-06, 2.099635e-08},{-4.643456e-06, 3.269314e-08},{-4.610763e-06, 4.416197e-08},{-4.566601e-06, 5.537559e-08},
 {-4.511226e-06, 6.630771e-08},{-4.444918e-06, 7.693302e-08},{-4.367985e-06, 8.722734e-08},{-4.280758e-06, 9.716756e-08},
 {-4.183590e-06, 1.067318e-07},{-4.076858e-06, 1.158993e-07},{-3.960959e-06, 1.246506e-07},{-3.836308e-06, 1.329677e-07},
 {-3.703341e-06, 1.408338e-07},{-3.562507e-06, 1.482333e-07},{-3.414274e-06, 1.551523e-07},{-3.259121e-06, 1.615781e-07},
 {-3.097543e-06, 1.674996e-07},{-2.930044e-06, 1.729070e-07},{-2.757136e-06, 1.777921e-07},{-2.579344e-06, 1.821481e-07},
 {-2.397196e-06, 1.859696e-07},{-2.211227e-06, 1.892528e-07},{-2.021974e-06, 1.919953e-07},{-1.829979e-06, 1.941962e-07},
 {-1.635782e-06, 1.958560e-07},{-1.439926e-06, 1.969768e-07},{-1.242950e-06, 1.975618e-07},{-1.045388e-06, 1.976158e-07},
 {-8.477720e-07, 1.971451e-07},{-6.506269e-07, 1.961570e-07},{-4.544699e-07, 1.946604e-07},{-2.598095e-07, 1.926654e-07},
 {-6.714413e-08, 1.901831e-07},{ 1.230390e-07, 1.872261e-07},{ 3.102651e-07, 1.838080e-07},{ 4.940731e-07, 1.799434e-07},
 { 6.740165e-07, 1.756481e-07},{ 8.496646e-07, 1.709388e-07},{ 1.020603e-06, 1.658331e-07},{ 1.186436e-06, 1.603496e-07},
 { 1.346786e-06, 1.545076e-07},{ 1.501294e-06, 1.483272e-07},{ 1.649621e-06, 1.418293e-07},{ 1.791450e-06, 1.350351e-07},
 { 1.926485e-06, 1.279668e-07},{ 2.054452e-06, 1.206467e-07},{ 2.175099e-06, 1.130979e-07},{ 2.288197e-06, 1.053435e-07},
 { 2.393540e-06, 9.740725e-08},{ 2.490947e-06, 8.931288e-08},{ 2.580260e-06, 8.108437e-08},{ 2.661345e-06, 7.274581e-08},
 { 2.734090e-06, 6.432130e-08},{ 2.798412e-06, 5.583489e-08},{ 2.854247e-06, 4.731056e-08},{ 2.901557e-06, 3.877209e-08},
 { 2.940329e-06, 3.024305e-08},{ 2.970572e-06, 2.174669e-08},{ 2.992319e-06, 1.330594e-08},{ 3.005625e-06, 4.943291e-09},
 { 3.010568e-06,-3.319235e-09},{ 3.007249e-06,-1.146014e-08},{ 2.995789e-06,-1.945850e-08},{ 2.976330e-06,-2.729404e-08},
 { 2.949036e-06,-3.494716e-08},{ 2.914089e-06,-4.239899e-08},{ 2.871690e-06,-4.963142e-08},{ 2.822059e-06,-5.662718e-08},
 { 2.765432e-06,-6.336985e-08},{ 2.702062e-06,-6.984389e-08},{ 2.632218e-06,-7.603471e-08},{ 2.556183e-06,-8.192865e-08},
 { 2.474254e-06,-8.751306e-08},{ 2.386741e-06,-9.277632e-08},{ 2.293965e-06,-9.770780e-08},{ 2.196257e-06,-1.022980e-07},
 { 2.093959e-06,-1.065383e-07},{ 1.987421e-06,-1.104215e-07},{ 1.876999e-06,-1.139413e-07},{ 1.763058e-06,-1.170923e-07},
 { 1.645966e-06,-1.198706e-07},{ 1.526095e-06,-1.222730e-07},{ 1.403822e-06,-1.242978e-07},{ 1.279524e-06,-1.259441e-07},
 { 1.153580e-06,-1.272122e-07},{ 1.026368e-06,-1.281033e-07},{ 8.982648e-07,-1.286200e-07},{ 7.696448e-07,-1.287656e-07},
 { 6.408792e-07,-1.285447e-07},{ 5.123345e-07,-1.279626e-07},{ 3.843719e-07,-1.270257e-07},{ 2.573462e-07,-1.257415e-07},
 { 1.316048e-07,-1.241181e-07},{ 7.486614e-09,-1.221648e-07},{-1.146782e-07,-1.198915e-07},{-2.345696e-07,-1.173089e-07},
 {-3.518785e-07,-1.144286e-07},{-4.663071e-07,-1.112628e-07},{-5.775699e-07,-1.078245e-07},{-6.853944e-07,-1.041272e-07},
 {-7.895216e-07,-1.001852e-07},{-8.897068e-07,-9.601294e-08},{-9.857197e-07,-9.162575e-08},{-1.077345e-06,-8.703921e-08},
 {-1.164385e-06,-8.226933e-08},{-1.246654e-06,-7.733244e-08},{-1.323986e-06,-7.224519e-08},{-1.396232e-06,-6.702445e-08},
 {-1.463256e-06,-6.168728e-08},{-1.524943e-06,-5.625088e-08},{-1.581194e-06,-5.073251e-08},{-1.631927e-06,-4.514949e-08},
 {-1.677076e-06,-3.951910e-08},{-1.716595e-06,-3.385858e-08},{-1.750454e-06,-2.818500e-08},{-1.778639e-06,-2.251530e-08},
 {-1.801154e-06,-1.686619e-08},{-1.818020e-06,-1.125411e-08},{-1.829275e-06,-5.695183e-09},{-1.834970e-06,-2.051878e-10},
 {-1.835175e-06, 5.200511e-09},{-1.829974e-06, 1.050699e-08},{-1.819467e-06, 1.569981e-08},{-1.803768e-06, 2.076505e-08},
 {-1.783003e-06, 2.568936e-08},{-1.757313e-06, 3.045998e-08},{-1.726853e-06, 3.506475e-08},{-1.691788e-06, 3.949219e-08},
 {-1.652296e-06, 4.373149e-08},{-1.608565e-06, 4.777252e-08},{-1.560792e-06, 5.160590e-08},{-1.509186e-06, 5.522299e-08},
 {-1.453963e-06, 5.861594e-08},{-1.395347e-06, 6.177767e-08},{-1.333570e-06, 6.470187e-08},{-1.268868e-06, 6.738307e-08},
 {-1.201485e-06, 6.981659e-08},{-1.131668e-06, 7.199860e-08},{-1.059670e-06, 7.392605e-08},{-9.857436e-07, 7.559674e-08},
 {-9.101468e-07, 7.700927e-08},{-8.331376e-07, 7.816308e-08},{-7.549745e-07, 7.905840e-08},{-6.759161e-07, 7.969624e-08},
 {-5.962199e-07, 8.007843e-08},{-5.161414e-07, 8.020755e-08},{-4.359339e-07, 8.008694e-08},{-3.558469e-07, 7.972067e-08},
 {-2.761263e-07, 7.911351e-08},{-1.970128e-07, 7.827096e-08},{-1.187418e-07, 7.719914e-08},{-4.154265e-08, 7.590486e-08},
 { 3.436220e-08, 7.439549e-08},{ 1.087577e-07, 7.267901e-08},{ 1.814367e-07, 7.076395e-08},{ 2.522006e-07, 6.865934e-08},
 { 3.208600e-07, 6.637472e-08},{ 3.872347e-07, 6.392005e-08},{ 4.511548e-07, 6.130571e-08},{ 5.124605e-07, 5.854246e-08},
 { 5.710029e-07, 5.564137e-08},{ 6.266443e-07, 5.261383e-08},{ 6.792581e-07, 4.947146e-08},{ 7.287296e-07, 4.622613e-08},
 { 7.749557e-07, 4.288983e-08},{ 8.178456e-07, 3.947473e-08},{ 8.573203e-07, 3.599304e-08},{ 8.933133e-07, 3.245707e-08},
 { 9.257704e-07, 2.887909e-08},{ 9.546495e-07, 2.527136e-08},{ 9.799208e-07, 2.164606e-08},{ 1.001567e-06, 1.801526e-08},
 { 1.019582e-06, 1.439087e-08},{ 1.033973e-06, 1.078463e-08},{ 1.044758e-06, 7.208032e-09},{ 1.051966e-06, 3.672342e-09},
 { 1.055638e-06, 1.885272e-10},{ 1.055827e-06,-3.232765e-09},{ 1.052594e-06,-6.581243e-09},{ 1.046013e-06,-9.847006e-09},
 { 1.036166e-06,-1.302057e-08},{ 1.023145e-06,-1.609289e-08},{ 1.007052e-06,-1.905538e-08},{ 9.879967e-07,-2.189995e-08},
 { 9.660968e-07,-2.461900e-08},{ 9.414778e-07,-2.720549e-08},{ 9.142723e-07,-2.965291e-08},{ 8.846194e-07,-3.195530e-08},
 { 8.526641e-07,-3.410728e-08},{ 8.185568e-07,-3.610408e-08},{ 7.824527e-07,-3.794149e-08},{ 7.445112e-07,-3.961591e-08},
 { 7.048953e-07,-4.112437e-08},{ 6.637709e-07,-4.246448e-08},{ 6.213065e-07,-4.363447e-08},{ 5.776720e-07,-4.463320e-08},
 { 5.330388e-07,-4.546010e-08},{ 4.875787e-07,-4.611522e-08},{ 4.414635e-07,-4.659921e-08},{ 3.948643e-07,-4.691329e-08},
 { 3.479510e-07,-4.705926e-08},{ 3.008917e-07,-4.703948e-08},{ 2.538522e-07,-4.685685e-08},{ 2.069954e-07,-4.651481e-08},
 { 1.604806e-07,-4.601728e-08},{ 1.144633e-07,-4.536872e-08},{ 6.909458e-08,-4.457401e-08},{ 2.452057e-08,-4.363850e-08},
 {-1.911792e-08,-4.256795e-08},{-6.168587e-08,-4.136853e-08},{-1.030544e-07,-4.004676e-08},{-1.431012e-07,-3.860951e-08},
 {-1.817107e-07,-3.706394e-08},{-2.187746e-07,-3.541753e-08},{-2.541921e-07,-3.367796e-08},{-2.878701e-07,-3.185317e-08},
 {-3.197233e-07,-2.995126e-08},{-3.496745e-07,-2.798048e-08},{-3.776550e-07,-2.594923e-08},{-4.036042e-07,-2.386597e-08},
 {-4.274702e-07,-2.173924e-08},{-4.492095e-07,-1.957761e-08},{-4.687871e-07,-1.738964e-08},{-4.861767e-07,-1.518387e-08},
 {-5.013606e-07,-1.296879e-08},{-5.143294e-07,-1.075279e-08},{-5.250822e-07,-8.544140e-09},{-5.336263e-07,-6.350940e-09},
 {-5.399772e-07,-4.181117e-09},{-5.441584e-07,-2.042392e-09},{-5.462007e-07, 5.774758e-11},{-5.461430e-07, 2.112073e-09},
 {-5.440309e-07, 4.113644e-09},{-5.399173e-07, 6.055821e-09},{-5.338615e-07, 7.932292e-09},{-5.259292e-07, 9.737094e-09},
 {-5.161921e-07, 1.146463e-08},{-5.047275e-07, 1.310968e-08},{-4.916178e-07, 1.466742e-08},{-4.769503e-07, 1.613346e-08},
 {-4.608169e-07, 1.750381e-08},{-4.433131e-07, 1.877492e-08},{-4.245382e-07, 1.994368e-08},{-4.045945e-07, 2.100744e-08},
 {-3.835870e-07, 2.196399e-08},{-3.616231e-07, 2.281160e-08},{-3.388115e-07, 2.354898e-08},{-3.152625e-07, 2.417532e-08},
 {-2.910872e-07, 2.469024e-08},{-2.663969e-07, 2.509383e-08},{-2.413031e-07, 2.538663e-08},{-2.159165e-07, 2.556962e-08},
 {-1.903468e-07, 2.564420e-08},{-1.647026e-07, 2.561221e-08},{-1.390904e-07, 2.547589e-08},{-1.136145e-07, 2.523785e-08},
 {-8.837669e-08, 2.490112e-08},{-6.347557e-08, 2.446906e-08},{-3.900651e-08, 2.394537e-08},{-1.506113e-08, 2.333410e-08},
 { 8.272965e-09, 2.263956e-08},{ 3.091253e-08, 2.186638e-08},{ 5.277891e-08, 2.101942e-08},{ 7.379833e-08, 2.010377e-08},
 { 9.390210e-08, 1.912474e-08},{ 1.130268e-07, 1.808782e-08},{ 1.311147e-07, 1.699865e-08},{ 1.481133e-07, 1.586300e-08},
 { 1.639763e-07, 1.468678e-08},{ 1.786631e-07, 1.347594e-08},{ 1.921390e-07, 1.223652e-08},{ 2.043755e-07, 1.097460e-08},
 { 2.153501e-07, 9.696250e-09},{ 2.250464e-07, 8.407549e-09},{ 2.334539e-07, 7.114496e-09},{ 2.405684e-07, 5.823009e-09},
 { 2.463914e-07, 4.538907e-09},{ 2.509304e-07, 3.267885e-09},{ 2.541982e-07, 2.015490e-09},{ 2.562137e-07, 7.870906e-10},
 { 2.570008e-07,-4.121423e-10},{ 2.565887e-07,-1.577253e-09},{ 2.550114e-07,-2.703522e-09},{ 2.523079e-07,-3.786493e-09},
 { 2.485214e-07,-4.821983e-09},{ 2.436994e-07,-5.806099e-09},{ 2.378933e-07,-6.735257e-09},{ 2.311581e-07,-7.606193e-09},
 { 2.235519e-07,-8.415978e-09},{ 2.151359e-07,-9.162022e-09},{ 2.059739e-07,-9.842093e-09},{ 1.961318e-07,-1.045431e-08},
 { 1.856775e-07,-1.099717e-08},{ 1.746803e-07,-1.146951e-08},{ 1.632108e-07,-1.187058e-08},{ 1.513402e-07,-1.219996e-08},
 { 1.391403e-07,-1.245761e-08},{ 1.266826e-07,-1.264386e-08},{ 1.140388e-07,-1.275940e-08},{ 1.012794e-07,-1.280525e-08},
 { 8.847413e-08,-1.278279e-08},{ 7.569135e-08,-1.269372e-08},{ 6.299763e-08,-1.254006e-08},{ 5.045757e-08,-1.232413e-08},
 { 3.813344e-08,-1.204855e-08},{ 2.608489e-08,-1.171619e-08},{ 1.436870e-08,-1.133017e-08},{ 3.038534e-09,-1.089385e-08},
 {-7.855319e-09,-1.041081e-08},{-1.826613e-08,-9.884798e-09},{-2.815093e-08,-9.319734e-09},{-3.747066e-08,-8.719685e-09},
 {-4.619035e-08,-8.088832e-09},{-5.427918e-08,-7.431457e-09},{-6.171064e-08,-6.751909e-09},{-6.846255e-08,-6.054592e-09},
 {-7.451714e-08,-5.343934e-09},{-7.986107e-08,-4.624372e-09},{-8.448544e-08,-3.900328e-09},{-8.838577e-08,-3.176192e-09},
 {-9.156196e-08,-2.456292e-09},{-9.401826e-08,-1.744855e-09},{-9.576311e-08,-1.045972e-09},{-9.680908e-08,-3.635716e-10},
 {-9.717265e-08, 2.985809e-10},{-9.687407e-08, 9.369009e-10},{-9.593717e-08, 1.548013e-09},{-9.438916e-08, 2.128778e-09},
 {-9.226038e-08, 2.676295e-09},{-8.958409e-08, 3.187921e-09},{-8.639616e-08, 3.661290e-09},{-8.273487e-08, 4.094324e-09},
 {-7.864055e-08, 4.485240e-09},{-7.415531e-08, 4.832558e-09},{-6.932275e-08, 5.135118e-09},{-6.418763e-08, 5.392070e-09},
 {-5.879556e-08, 5.602887e-09},{-5.319268e-08, 5.767363e-09},{-4.742531e-08, 5.885610e-09},{-4.153970e-08, 5.958055e-09},
 {-3.558165e-08, 5.985436e-09},{-2.959621e-08, 5.968793e-09},{-2.362742e-08, 5.909454e-09},{-1.771797e-08, 5.809031e-09},
 {-1.190894e-08, 5.669399e-09},{-6.239536e-09, 5.492681e-09},{-7.468554e-10, 5.281235e-09},{ 4.534380e-09, 5.037627e-09},
 { 9.572007e-09, 4.764617e-09},{ 1.433662e-08, 4.465129e-09},{ 1.880175e-08, 4.142234e-09},{ 2.294399e-08, 3.799119e-09},
 { 2.674311e-08, 3.439066e-09},{ 3.018217e-08, 3.065421e-09},{ 3.324759e-08, 2.681569e-09},{ 3.592916e-08, 2.290905e-09},
 { 3.822007e-08, 1.896810e-09},{ 4.011688e-08, 1.502618e-09},{ 4.161949e-08, 1.111597e-09},{ 4.273109e-08, 7.269150e-10},
 { 4.345801e-08, 3.516227e-10},{ 4.380963e-08,-1.137312e-11},{ 4.379826e-08,-3.593301e-10},{ 4.343893e-08,-6.896892e-10},
 { 4.274924e-08,-1.000090e-09},{ 4.174915e-08,-1.288386e-09},{ 4.046076e-08,-1.552651e-09},{ 3.890811e-08,-1.791187e-09},
 { 3.711692e-08,-2.002554e-09},{ 3.511437e-08,-2.185617e-09},{ 3.292875e-08,-2.339586e-09},{ 3.058917e-08,-2.464004e-09},
 { 2.812516e-08,-2.558707e-09},{ 2.556646e-08,-2.623839e-09},{ 2.294262e-08,-2.659871e-09},{ 2.028275e-08,-2.667575e-09},
 { 1.761517e-08,-2.648010e-09},{ 1.496716e-08,-2.602530e-09},{ 1.236463e-08,-2.532758e-09},{ 9.831872e-09,-2.440559e-09},
 { 7.391313e-09,-2.328035e-09},{ 5.063278e-09,-2.197484e-09},{ 2.865794e-09,-2.051380e-09},{ 8.144143e-10,-1.892342e-09},
 {-1.077927e-09,-1.723093e-09},{-2.801021e-09,-1.546434e-09},{-4.347455e-09,-1.365196e-09},{-5.712650e-09,-1.182202e-09},
 {-6.894853e-09,-1.000233e-09},{-7.895085e-09,-8.219714e-10},{-8.717057e-09,-6.499729e-10},{-9.367029e-09,-4.866129e-10},
 {-9.853642e-09,-3.340489e-10},{-1.018769e-08,-1.941823e-10},{-1.038187e-08,-6.861378e-11},{-1.045049e-08, 4.138179e-11},
 {-1.040911e-08, 1.348983e-10},{-1.027421e-08, 2.114116e-10},{-1.006280e-08, 2.708092e-10},{-9.791986e-09, 3.133954e-10},
 {-9.478591e-09, 3.399024e-10},{-9.138689e-09, 3.514765e-10},{-8.787212e-09, 3.496685e-10},{-8.437544e-09, 3.364000e-10},
 {-8.101144e-09, 3.139222e-10},{-7.787221e-09, 2.847563e-10},{-7.502465e-09, 2.516179e-10},{-7.250847e-09, 2.173213e-10},
 {-7.033526e-09, 1.846658e-10},{-6.848860e-09, 1.562942e-10},{-6.692566e-09, 1.345328e-10},{-6.558033e-09, 1.211999e-10},
 {-6.436833e-09, 1.173885e-10},{-6.319444e-09, 1.232145e-10},{-6.196230e-09, 1.375440e-10},{-6.058686e-09, 1.575662e-10},
 {-5.901120e-09, 1.790834e-10},{-5.722036e-09, 2.002664e-10},{-5.521770e-09, 2.209262e-10},{-5.300844e-09, 2.410449e-10},
 {-5.059799e-09, 2.605764e-10},{-4.799222e-09, 2.794782e-10},{-4.519744e-09, 2.977075e-10},{-4.222037e-09, 3.152236e-10},
 {-3.906813e-09, 3.319882e-10},{-3.574825e-09, 3.479630e-10},{-3.226862e-09, 3.631132e-10},{-2.863749e-09, 3.774054e-10},
 {-2.486343e-09, 3.908078e-10},{-2.095535e-09, 4.032923e-10},{-1.692243e-09, 4.148307e-10},{-1.277412e-09, 4.254000e-10},
 {-8.520123e-10, 4.349774e-10},{-4.170350e-10, 4.170337e-10},{ 0.000000e+00, 0.000000e+00},{ 0.000000e+00, 0.000000e+00},
 { 0.000000e+00, 0.000000e+00}
};

float
slope_dd_table [MINBLEP_PHASES * SLOPE_DD_PULSE_LENGTH + 1] =
{
  0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00,
  0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00,
  0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00,
  0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00,
  0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 4.875745e-12,
  1.319931e-11, 2.671711e-11, 4.827410e-11, 8.224100e-11, 1.350341e-10, 2.157396e-10, 3.368563e-10, 5.151702e-10,
  7.727766e-10, 1.138267e-09, 1.648096e-09, 2.348151e-09, 3.295543e-09, 4.560635e-09, 6.229346e-09, 8.405729e-09,
  1.121488e-08, 1.480620e-08, 1.935696e-08, 2.507639e-08, 3.221008e-08, 4.104494e-08, 5.191458e-08, 6.520533e-08,
  8.136276e-08, 1.008988e-07, 1.243998e-07, 1.525346e-07, 1.860643e-07, 2.258523e-07, 2.728748e-07, 3.282333e-07,
  3.931669e-07, 4.690664e-07, 5.574891e-07, 6.601751e-07, 7.790641e-07, 9.163142e-07, 1.074322e-06, 1.255742e-06,
  1.463514e-06, 1.700880e-06, 1.971417e-06, 2.279062e-06, 2.628138e-06, 3.023391e-06, 3.470020e-06, 3.973711e-06,
  4.540675e-06, 5.177689e-06, 5.892137e-06, 6.692052e-06, 7.586165e-06, 8.583950e-06, 9.695682e-06, 1.093249e-05,
  1.230639e-05, 1.383041e-05, 1.551857e-05, 1.738600e-05, 1.944900e-05, 2.172511e-05, 2.423319e-05, 2.699349e-05,
  3.002773e-05, 3.335920e-05, 3.701287e-05, 4.101542e-05, 4.539540e-05, 5.018331e-05, 5.541171e-05, 6.111531e-05,
  6.733114e-05, 7.409858e-05, 8.145958e-05, 8.945873e-05, 9.814341e-05, 1.075639e-04, 1.177736e-04, 1.288291e-04,
  1.407903e-04, 1.537208e-04, 1.676877e-04, 1.827619e-04, 1.990187e-04, 2.165372e-04, 2.354010e-04, 2.556985e-04,
  2.775225e-04, 3.009711e-04, 3.261474e-04, 3.531599e-04, 3.821227e-04, 4.131557e-04, 4.463850e-04, 4.819426e-04,
  5.199675e-04, 5.606050e-04, 6.040076e-04, 6.503351e-04, 6.997547e-04, 7.524414e-04, 8.085780e-04, 8.683560e-04,
  9.319752e-04, 9.996443e-04, 1.071581e-03, 1.148013e-03, 1.229176e-03, 1.315319e-03, 1.406697e-03, 1.503579e-03,
  1.606244e-03, 1.714982e-03, 1.830093e-03, 1.951892e-03, 2.080704e-03, 2.216867e-03, 2.360731e-03, 2.512661e-03,
  2.673033e-03, 2.842239e-03, 3.020684e-03, 3.208788e-03, 3.406984e-03, 3.615723e-03, 3.835468e-03, 4.066700e-03,
  4.309916e-03, 4.565629e-03, 4.834368e-03, 5.116679e-03, 5.413126e-03, 5.724290e-03, 6.050771e-03, 6.393186e-03,
  6.752171e-03, 7.128380e-03, 7.522488e-03, 7.935186e-03, 8.367189e-03, 8.819228e-03, 9.292055e-03, 9.786444e-03,
  1.030319e-02, 1.084310e-02, 1.140702e-02, 1.199580e-02, 1.261032e-02, 1.325148e-02, 1.392020e-02, 1.461742e-02,
  1.534411e-02, 1.610125e-02, 1.688986e-02, 1.771097e-02, 1.856563e-02, 1.945492e-02, 2.037994e-02, 2.134182e-02,
  2.234168e-02, 2.338071e-02, 2.446010e-02, 2.558105e-02, 2.674480e-02, 2.795260e-02, 2.920575e-02, 3.050554e-02,
  3.185329e-02, 3.325034e-02, 3.469808e-02, 3.619788e-02, 3.775115e-02, 3.935932e-02, 4.102385e-02, 4.274620e-02,
  4.452788e-02, 4.637037e-02, 4.827523e-02, 5.024399e-02, 5.227821e-02, 5.437950e-02, 5.654944e-02, 5.878965e-02,
  6.110177e-02, 6.348744e-02, 6.594834e-02, 6.848614e-02, 7.110252e-02, 7.379920e-02, 7.657790e-02, 7.944033e-02,
  8.238825e-02, 8.542339e-02, 8.854752e-02, 9.176240e-02, 9.506980e-02, 9.847150e-02, 1.019693e-01, 1.055650e-01,
  1.092603e-01, 1.130571e-01, 1.169571e-01, 1.209622e-01, 1.250741e-01, 1.292946e-01, 1.336256e-01, 1.380688e-01,
  1.426259e-01, 1.472988e-01, 1.520892e-01, 1.569989e-01, 1.620296e-01, 1.671830e-01, 1.724609e-01, 1.778649e-01,
  1.833967e-01, 1.734331e-01, 1.636006e-01, 1.539009e-01, 1.443356e-01, 1.349063e-01, 1.256145e-01, 1.164618e-01,
  1.074497e-01, 9.857959e-02, 8.985302e-02, 8.127137e-02, 7.283602e-02, 6.454832e-02, 5.640959e-02, 4.842110e-02,
  4.058409e-02, 3.289976e-02, 2.536926e-02, 1.799369e-02, 1.077414e-02, 3.711615e-03,-3.192902e-03,-9.938489e-03,
 -1.652427e-02,-2.294942e-02,-2.921316e-02,-3.531478e-02,-4.125362e-02,-4.702906e-02,-5.264056e-02,-5.808762e-02,
 -6.336982e-02,-6.848678e-02,-7.343820e-02,-7.822383e-02,-8.284348e-02,-8.729705e-02,-9.158447e-02,-9.570577e-02,
 -9.966102e-02,-1.034504e-01,-1.070741e-01,-1.105324e-01,-1.138257e-01,-1.169544e-01,-1.199190e-01,-1.227201e-01,
 -1.253584e-01,-1.278345e-01,-1.301493e-01,-1.323036e-01,-1.342984e-01,-1.361346e-01,-1.378134e-01,-1.393359e-01,
 -1.407034e-01,-1.419172e-01,-1.429787e-01,-1.438892e-01,-1.446505e-01,-1.452639e-01,-1.457314e-01,-1.460545e-01,
 -1.462350e-01,-1.462750e-01,-1.461764e-01,-1.459411e-01,-1.455713e-01,-1.450691e-01,-1.444368e-01,-1.436767e-01,
 -1.427911e-01,-1.417825e-01,-1.406533e-01,-1.394062e-01,-1.380436e-01,-1.365683e-01,-1.349830e-01,-1.332904e-01,
 -1.314934e-01,-1.295950e-01,-1.275979e-01,-1.255052e-01,-1.233199e-01,-1.210451e-01,-1.186839e-01,-1.162394e-01,
 -1.137149e-01,-1.111135e-01,-1.084385e-01,-1.056932e-01,-1.028810e-01,-1.000051e-01,-9.706896e-02,-9.407596e-02,
 -9.102951e-02,-8.793303e-02,-8.478997e-02,-8.160378e-02,-7.837794e-02,-7.511591e-02,-7.182118e-02,-6.849721e-02,
 -6.514749e-02,-6.177549e-02,-5.838468e-02,-5.497852e-02,-5.156044e-02,-4.813388e-02,-4.470226e-02,-4.126896e-02,
 -3.783736e-02,-3.441081e-02,-3.099261e-02,-2.758605e-02,-2.419439e-02,-2.082084e-02,-1.746857e-02,-1.414072e-02,
 -1.084038e-02,-7.570592e-03,-4.334348e-03,-1.134587e-03, 2.025803e-03, 5.143991e-03, 8.217208e-03, 1.124275e-02,
  1.421796e-02, 1.714027e-02, 2.000717e-02, 2.281622e-02, 2.556505e-02, 2.825137e-02, 3.087296e-02, 3.342769e-02,
  3.591351e-02, 3.832843e-02, 4.067056e-02, 4.293810e-02, 4.512934e-02, 4.724263e-02, 4.927644e-02, 5.122932e-02,
  5.309990e-02, 5.488694e-02, 5.658924e-02, 5.820574e-02, 5.973545e-02, 6.117750e-02, 6.253108e-02, 6.379552e-02,
  6.497022e-02, 6.605468e-02, 6.704851e-02, 6.795142e-02, 6.876321e-02, 6.948377e-02, 7.011311e-02, 7.065132e-02,
  7.109860e-02, 7.145523e-02, 7.172161e-02, 7.189822e-02, 7.198564e-02, 7.198454e-02, 7.189569e-02, 7.171994e-02,
  7.145825e-02, 7.111165e-02, 7.068127e-02, 7.016832e-02, 6.957410e-02, 6.890000e-02, 6.814746e-02, 6.731805e-02,
  6.641337e-02, 6.543513e-02, 6.438508e-02, 6.326508e-02, 6.207704e-02, 6.082293e-02, 5.950478e-02, 5.812471e-02,
  5.668487e-02, 5.518749e-02, 5.363483e-02, 5.202923e-02, 5.037304e-02, 4.866870e-02, 4.691865e-02, 4.512540e-02,
  4.329148e-02, 4.141946e-02, 3.951195e-02, 3.757156e-02, 3.560096e-02, 3.360280e-02, 3.157979e-02, 2.953462e-02,
  2.747001e-02, 2.538868e-02, 2.329336e-02, 2.118679e-02, 1.907168e-02, 1.695076e-02, 1.482676e-02, 1.270236e-02,
  1.058025e-02, 8.463123e-03, 6.353609e-03, 4.254340e-03, 2.167914e-03, 9.690017e-05,-1.956168e-03,-3.988791e-03,
 -5.998509e-03,-7.982905e-03,-9.939607e-03,-1.186629e-02,-1.376068e-02,-1.562055e-02,-1.744374e-02,-1.922814e-02,
 -2.097171e-02,-2.267245e-02,-2.432846e-02,-2.593787e-02,-2.749891e-02,-2.900985e-02,-3.046908e-02,-3.187501e-02,
 -3.322618e-02,-3.452116e-02,-3.575862e-02,-3.693733e-02,-3.805612e-02,-3.911391e-02,-4.010970e-02,-4.104258e-02,
 -4.191174e-02,-4.271642e-02,-4.345600e-02,-4.412991e-02,-4.473768e-02,-4.527893e-02,-4.575336e-02,-4.616079e-02,
 -4.650110e-02,-4.677426e-02,-4.698035e-02,-4.711951e-02,-4.719200e-02,-4.719815e-02,-4.713837e-02,-4.701317e-02,
 -4.682314e-02,-4.656895e-02,-4.625136e-02,-4.587120e-02,-4.542940e-02,-4.492695e-02,-4.436493e-02,-4.374447e-02,
 -4.306681e-02,-4.233323e-02,-4.154510e-02,-4.070386e-02,-3.981099e-02,-3.886805e-02,-3.787667e-02,-3.683852e-02,
 -3.575534e-02,-3.462891e-02,-3.346107e-02,-3.225371e-02,-3.100875e-02,-2.972818e-02,-2.841400e-02,-2.706827e-02,
 -2.569306e-02,-2.429050e-02,-2.286272e-02,-2.141190e-02,-1.994022e-02,-1.844988e-02,-1.694312e-02,-1.542217e-02,
 -1.388928e-02,-1.234668e-02,-1.079665e-02,-9.241427e-03,-7.683267e-03,-6.124412e-03,-4.567099e-03,-3.013550e-03,
 -1.465969e-03, 7.345568e-05, 1.602561e-03, 3.119201e-03, 4.621267e-03, 6.106673e-03, 7.573373e-03, 9.019352e-03,
  1.044264e-02, 1.184129e-02, 1.321343e-02, 1.455721e-02, 1.587083e-02, 1.715257e-02, 1.840072e-02, 1.961366e-02,
  2.078981e-02, 2.192765e-02, 2.302575e-02, 2.408271e-02, 2.509720e-02, 2.606798e-02, 2.699386e-02, 2.787372e-02,
  2.870652e-02, 2.949129e-02, 3.022714e-02, 3.091325e-02, 3.154886e-02, 3.213331e-02, 3.266602e-02, 3.314647e-02,
  3.357423e-02, 3.394894e-02, 3.427034e-02, 3.453823e-02, 3.475248e-02, 3.491308e-02, 3.502005e-02, 3.507353e-02,
  3.507371e-02, 3.502087e-02, 3.491537e-02, 3.475764e-02, 3.454819e-02, 3.428760e-02, 3.397653e-02, 3.361570e-02,
  3.320592e-02, 3.274804e-02, 3.224301e-02, 3.169184e-02, 3.109558e-02, 3.045536e-02, 2.977238e-02, 2.904788e-02,
  2.828318e-02, 2.747963e-02, 2.663865e-02, 2.576170e-02, 2.485029e-02, 2.390597e-02, 2.293036e-02, 2.192509e-02,
  2.089183e-02, 1.983231e-02, 1.874827e-02, 1.764147e-02, 1.651374e-02, 1.536688e-02, 1.420276e-02, 1.302324e-02,
  1.183019e-02, 1.062553e-02, 9.411141e-03, 8.188949e-03, 6.960866e-03, 5.728809e-03, 4.494692e-03, 3.260427e-03,
  2.027916e-03, 7.990528e-04,-4.242846e-04,-1.640233e-03,-2.846948e-03,-4.042609e-03,-5.225416e-03,-6.393600e-03,
 -7.545418e-03,-8.679163e-03,-9.793158e-03,-1.088577e-02,-1.195540e-02,-1.300049e-02,-1.401953e-02,-1.501106e-02,
 -1.597365e-02,-1.690595e-02,-1.780664e-02,-1.867446e-02,-1.950821e-02,-2.030673e-02,-2.106895e-02,-2.179384e-02,
 -2.248044e-02,-2.312784e-02,-2.373521e-02,-2.430177e-02,-2.482684e-02,-2.530977e-02,-2.574999e-02,-2.614701e-02,
 -2.650040e-02,-2.680979e-02,-2.707491e-02,-2.729552e-02,-2.747150e-02,-2.760275e-02,-2.768928e-02,-2.773114e-02,
 -2.772848e-02,-2.768149e-02,-2.759045e-02,-2.745570e-02,-2.727765e-02,-2.705677e-02,-2.679361e-02,-2.648878e-02,
 -2.614293e-02,-2.575681e-02,-2.533121e-02,-2.486698e-02,-2.436503e-02,-2.382633e-02,-2.325189e-02,-2.264280e-02,
 -2.200017e-02,-2.132519e-02,-2.061907e-02,-1.988308e-02,-1.911853e-02,-1.832677e-02,-1.750919e-02,-1.666720e-02,
 -1.580228e-02,-1.491590e-02,-1.400958e-02,-1.308487e-02,-1.214334e-02,-1.118656e-02,-1.021616e-02,-9.233750e-03,
 -8.240966e-03,-7.239457e-03,-6.230874e-03,-5.216879e-03,-4.199134e-03,-3.179299e-03,-2.159034e-03,-1.139993e-03,
 -1.238228e-04, 8.878428e-04, 1.893383e-03, 2.891193e-03, 3.879685e-03, 4.857291e-03, 5.822470e-03, 6.773704e-03,
  7.709503e-03, 8.628409e-03, 9.528995e-03, 1.040987e-02, 1.126968e-02, 1.210711e-02, 1.292089e-02, 1.370978e-02,
  1.447261e-02, 1.520822e-02, 1.591554e-02, 1.659351e-02, 1.724115e-02, 1.785752e-02, 1.844174e-02, 1.899299e-02,
  1.951049e-02, 1.999354e-02, 2.044147e-02, 2.085371e-02, 2.122970e-02, 2.156899e-02, 2.187115e-02, 2.213586e-02,
  2.236281e-02, 2.255179e-02, 2.270263e-02, 2.281525e-02, 2.288961e-02, 2.292574e-02, 2.292372e-02, 2.288373e-02,
  2.280597e-02, 2.269072e-02, 2.253832e-02, 2.234917e-02, 2.212373e-02, 2.186252e-02, 2.156610e-02, 2.123511e-02,
  2.087023e-02, 2.047221e-02, 2.004182e-02, 1.957991e-02, 1.908738e-02, 1.856516e-02, 1.801422e-02, 1.743561e-02,
  1.683039e-02, 1.619967e-02, 1.554459e-02, 1.486636e-02, 1.416617e-02, 1.344529e-02, 1.270500e-02, 1.194660e-02,
  1.117143e-02, 1.038086e-02, 9.576254e-03, 8.759015e-03, 7.930558e-03, 7.092310e-03, 6.245711e-03, 5.392209e-03,
  4.533261e-03, 3.670323e-03, 2.804857e-03, 1.938324e-03, 1.072181e-03, 2.078775e-04,-6.531433e-04,-1.509447e-03,
 -2.359614e-03,-3.202239e-03,-4.035936e-03,-4.859336e-03,-5.671093e-03,-6.469884e-03,-7.254414e-03,-8.023416e-03,
 -8.775652e-03,-9.509917e-03,-1.022504e-02,-1.091989e-02,-1.159337e-02,-1.224442e-02,-1.287202e-02,-1.347521e-02,
 -1.405304e-02,-1.460465e-02,-1.512920e-02,-1.562590e-02,-1.609400e-02,-1.653283e-02,-1.694175e-02,-1.732017e-02,
 -1.766757e-02,-1.798348e-02,-1.826746e-02,-1.851916e-02,-1.873827e-02,-1.892454e-02,-1.907776e-02,-1.919781e-02,
 -1.928459e-02,-1.933808e-02,-1.935830e-02,-1.934536e-02,-1.929938e-02,-1.922057e-02,-1.910917e-02,-1.896550e-02,
 -1.878992e-02,-1.858284e-02,-1.834473e-02,-1.807610e-02,-1.777753e-02,-1.744963e-02,-1.709306e-02,-1.670854e-02,
 -1.629683e-02,-1.585871e-02,-1.539505e-02,-1.490672e-02,-1.439464e-02,-1.385978e-02,-1.330313e-02,-1.272572e-02,
 -1.212862e-02,-1.151291e-02,-1.087972e-02,-1.023020e-02,-9.565518e-03,-8.886866e-03,-8.195458e-03,-7.492526e-03,
 -6.779319e-03,-6.057096e-03,-5.327132e-03,-4.590705e-03,-3.849107e-03,-3.103628e-03,-2.355567e-03,-1.606219e-03,
 -8.568775e-04,-1.088340e-04, 6.366295e-04, 1.378237e-03, 2.114723e-03, 2.844836e-03, 3.567342e-03, 4.281018e-03,
  4.984664e-03, 5.677101e-03, 6.357172e-03, 7.023748e-03, 7.675722e-03, 8.312017e-03, 8.931587e-03, 9.533421e-03,
  1.011654e-02, 1.067999e-02, 1.122288e-02, 1.174433e-02, 1.224351e-02, 1.271964e-02, 1.317197e-02, 1.359979e-02,
  1.400246e-02, 1.437934e-02, 1.472990e-02, 1.505359e-02, 1.534995e-02, 1.561857e-02, 1.585907e-02, 1.607112e-02,
  1.625446e-02, 1.640886e-02, 1.653415e-02, 1.663022e-02, 1.669699e-02, 1.673446e-02, 1.674264e-02, 1.672163e-02,
  1.667157e-02, 1.659263e-02, 1.648505e-02, 1.634911e-02, 1.618516e-02, 1.599356e-02, 1.577474e-02, 1.552918e-02,
  1.525739e-02, 1.495994e-02, 1.463743e-02, 1.429051e-02, 1.391986e-02, 1.352621e-02, 1.311033e-02, 1.267301e-02,
  1.221510e-02, 1.173746e-02, 1.124099e-02, 1.072662e-02, 1.019531e-02, 9.648053e-03, 9.085852e-03, 8.509746e-03,
  7.920786e-03, 7.320048e-03, 6.708623e-03, 6.087618e-03, 5.458154e-03, 4.821361e-03, 4.178381e-03, 3.530363e-03,
  2.878459e-03, 2.223828e-03, 1.567628e-03, 9.110154e-04, 2.551463e-04,-3.988301e-04,-1.049771e-03,-1.696542e-03,
 -2.338019e-03,-2.973092e-03,-3.600664e-03,-4.219656e-03,-4.829006e-03,-5.427674e-03,-6.014640e-03,-6.588908e-03,
 -7.149508e-03,-7.695495e-03,-8.225956e-03,-8.740007e-03,-9.236793e-03,-9.715494e-03,-1.017533e-02,-1.061554e-02,
 -1.103541e-02,-1.143428e-02,-1.181150e-02,-1.216648e-02,-1.249866e-02,-1.280753e-02,-1.309262e-02,-1.335350e-02,
 -1.358979e-02,-1.380115e-02,-1.398728e-02,-1.414794e-02,-1.428292e-02,-1.439207e-02,-1.447527e-02,-1.453247e-02,
 -1.456364e-02,-1.456881e-02,-1.454806e-02,-1.450151e-02,-1.442931e-02,-1.433169e-02,-1.420889e-02,-1.406121e-02,
 -1.388899e-02,-1.369262e-02,-1.347252e-02,-1.322916e-02,-1.296305e-02,-1.267472e-02,-1.236477e-02,-1.203380e-02,
 -1.168248e-02,-1.131149e-02,-1.092156e-02,-1.051343e-02,-1.008790e-02,-9.645771e-03,-9.187884e-03,-8.715103e-03,
 -8.228318e-03,-7.728438e-03,-7.216395e-03,-6.693139e-03,-6.159637e-03,-5.616873e-03,-5.065842e-03,-4.507551e-03,
 -3.943020e-03,-3.373275e-03,-2.799348e-03,-2.222273e-03,-1.643092e-03,-1.062846e-03,-4.825734e-04, 9.669087e-05,
  6.739160e-04, 1.248076e-03, 1.818158e-03, 2.383154e-03, 2.942070e-03, 3.493928e-03, 4.037761e-03, 4.572624e-03,
  5.097587e-03, 5.611743e-03, 6.114205e-03, 6.604111e-03, 7.080622e-03, 7.542927e-03, 7.990244e-03, 8.421819e-03,
  8.836926e-03, 9.234874e-03, 9.615001e-03, 9.976682e-03, 1.031933e-02, 1.064238e-02, 1.094532e-02, 1.122767e-02,
  1.148899e-02, 1.172886e-02, 1.194693e-02, 1.214288e-02, 1.231641e-02, 1.246729e-02, 1.259532e-02, 1.270033e-02,
  1.278221e-02, 1.284089e-02, 1.287632e-02, 1.288851e-02, 1.287752e-02, 1.284343e-02, 1.278639e-02, 1.270655e-02,
  1.260413e-02, 1.247940e-02, 1.233263e-02, 1.216416e-02, 1.197436e-02, 1.176364e-02, 1.153244e-02, 1.128123e-02,
  1.101054e-02, 1.072091e-02, 1.041292e-02, 1.008718e-02, 9.744325e-03, 9.385032e-03, 9.009996e-03, 8.619943e-03,
  8.215620e-03, 7.797800e-03, 7.367278e-03, 6.924870e-03, 6.471409e-03, 6.007745e-03, 5.534750e-03, 5.053304e-03,
  4.564301e-03, 4.068647e-03, 3.567259e-03, 3.061059e-03, 2.550975e-03, 2.037943e-03, 1.522896e-03, 1.006773e-03,
  4.905100e-04,-2.495910e-05,-5.387052e-04,-1.049804e-03,-1.557339e-03,-2.060402e-03,-2.558098e-03,-3.049541e-03,
 -3.533862e-03,-4.010203e-03,-4.477728e-03,-4.935617e-03,-5.383068e-03,-5.819303e-03,-6.243564e-03,-6.655120e-03,
 -7.053263e-03,-7.437312e-03,-7.806612e-03,-8.160539e-03,-8.498496e-03,-8.819919e-03,-9.124275e-03,-9.411062e-03,
 -9.679812e-03,-9.930093e-03,-1.016151e-02,-1.037368e-02,-1.056630e-02,-1.073907e-02,-1.089174e-02,-1.102407e-02,
 -1.113591e-02,-1.122710e-02,-1.129755e-02,-1.134718e-02,-1.137597e-02,-1.138392e-02,-1.137109e-02,-1.133756e-02,
 -1.128346e-02,-1.120894e-02,-1.111420e-02,-1.099947e-02,-1.086502e-02,-1.071115e-02,-1.053821e-02,-1.034656e-02,
 -1.013660e-02,-9.908787e-03,-9.663573e-03,-9.401460e-03,-9.122978e-03,-8.828680e-03,-8.519151e-03,-8.194997e-03,
 -7.856856e-03,-7.505385e-03,-7.141266e-03,-6.765200e-03,-6.377906e-03,-5.980124e-03,-5.572612e-03,-5.156142e-03,
 -4.731500e-03,-4.299487e-03,-3.860912e-03,-3.416594e-03,-2.967364e-03,-2.514054e-03,-2.057505e-03,-1.598560e-03,
 -1.138065e-03,-6.768666e-04,-2.158081e-04, 2.442678e-04, 7.025234e-04, 1.158125e-03, 1.610249e-03, 2.058079e-03,
  2.500809e-03, 2.937644e-03, 3.367802e-03, 3.790518e-03, 4.205037e-03, 4.610626e-03, 5.006571e-03, 5.392174e-03,
  5.766759e-03, 6.129674e-03, 6.480289e-03, 6.818000e-03, 7.142223e-03, 7.452404e-03, 7.748019e-03, 8.028567e-03,
  8.293579e-03, 8.542614e-03, 8.775265e-03, 8.991152e-03, 9.189929e-03, 9.371281e-03, 9.534927e-03, 9.680619e-03,
  9.808143e-03, 9.917317e-03, 1.000800e-02, 1.008007e-02, 1.013346e-02, 1.016812e-02, 1.018404e-02, 1.018126e-02,
  1.015982e-02, 1.011982e-02, 1.006140e-02, 9.984706e-03, 9.889941e-03, 9.777330e-03, 9.647132e-03, 9.499638e-03,
  9.335170e-03, 9.154079e-03, 8.956746e-03, 8.743584e-03, 8.515028e-03, 8.271545e-03, 8.013626e-03, 7.741790e-03,
  7.456574e-03, 7.158543e-03, 6.848282e-03, 6.526400e-03, 6.193520e-03, 5.850289e-03, 5.497369e-03, 5.135438e-03,
  4.765189e-03, 4.387327e-03, 4.002570e-03, 3.611647e-03, 3.215296e-03, 2.814262e-03, 2.409298e-03, 2.001162e-03,
  1.590614e-03, 1.178420e-03, 7.653417e-04, 3.521442e-04,-6.041013e-05,-4.715633e-04,-8.805615e-04,-1.286657e-03,
 -1.689108e-03,-2.087184e-03,-2.480163e-03,-2.867335e-03,-3.248003e-03,-3.621484e-03,-3.987110e-03,-4.344227e-03,
 -4.692203e-03,-5.030422e-03,-5.358287e-03,-5.675224e-03,-5.980678e-03,-6.274122e-03,-6.555046e-03,-6.822968e-03,
 -7.077433e-03,-7.318009e-03,-7.544290e-03,-7.755903e-03,-7.952497e-03,-8.133754e-03,-8.299384e-03,-8.449124e-03,
 -8.582746e-03,-8.700051e-03,-8.800868e-03,-8.885058e-03,-8.952514e-03,-9.003161e-03,-9.036954e-03,-9.053879e-03,
 -9.053955e-03,-9.037230e-03,-9.003785e-03,-8.953730e-03,-8.887207e-03,-8.804386e-03,-8.705469e-03,-8.590685e-03,
 -8.460293e-03,-8.314580e-03,-8.153861e-03,-7.978478e-03,-7.788800e-03,-7.585217e-03,-7.368147e-03,-7.138033e-03,
 -6.895338e-03,-6.640551e-03,-6.374178e-03,-6.096747e-03,-5.808805e-03,-5.510916e-03,-5.203662e-03,-4.887640e-03,
 -4.563460e-03,-4.231750e-03,-3.893146e-03,-3.548296e-03,-3.197858e-03,-2.842500e-03,-2.482895e-03,-2.119723e-03,
 -1.753668e-03,-1.385418e-03,-1.015663e-03,-6.450942e-04,-2.744028e-04, 9.572368e-05, 4.645977e-04, 8.315391e-04,
  1.195872e-03, 1.556926e-03, 1.914041e-03, 2.266565e-03, 2.613855e-03, 2.955282e-03, 3.290227e-03, 3.618088e-03,
  3.938275e-03, 4.250216e-03, 4.553355e-03, 4.847153e-03, 5.131091e-03, 5.404671e-03, 5.667412e-03, 5.918859e-03,
  6.158576e-03, 6.386152e-03, 6.601198e-03, 6.803353e-03, 6.992275e-03, 7.167652e-03, 7.329198e-03, 7.476652e-03,
  7.609780e-03, 7.728377e-03, 7.832265e-03, 7.921293e-03, 7.995338e-03, 8.054307e-03, 8.098131e-03, 8.126775e-03,
  8.140230e-03, 8.138516e-03, 8.121678e-03, 8.089793e-03, 8.042964e-03, 7.981323e-03, 7.905026e-03, 7.814261e-03,
  7.709237e-03, 7.590191e-03, 7.457388e-03, 7.311116e-03, 7.151686e-03, 6.979432e-03, 6.794716e-03, 6.597918e-03,
  6.389439e-03, 6.169704e-03, 5.939154e-03, 5.698251e-03, 5.447477e-03, 5.187326e-03, 4.918312e-03, 4.640963e-03,
  4.355822e-03, 4.063444e-03, 3.764396e-03, 3.459255e-03, 3.148608e-03, 2.833051e-03, 2.513190e-03, 2.189634e-03,
  1.862999e-03, 1.533903e-03, 1.202968e-03, 8.708170e-04, 5.380759e-04, 2.053678e-04,-1.266865e-04,-4.574685e-04,
 -7.863627e-04,-1.112759e-03,-1.436056e-03,-1.755659e-03,-2.070981e-03,-2.381444e-03,-2.686483e-03,-2.985542e-03,
 -3.278080e-03,-3.563569e-03,-3.841495e-03,-4.111362e-03,-4.372687e-03,-4.625008e-03,-4.867876e-03,-5.100867e-03,
 -5.323575e-03,-5.535611e-03,-5.736610e-03,-5.926229e-03,-6.104146e-03,-6.270063e-03,-6.423705e-03,-6.564818e-03,
 -6.693177e-03,-6.808578e-03,-6.910845e-03,-6.999823e-03,-7.075384e-03,-7.137427e-03,-7.185876e-03,-7.220679e-03,
 -7.241812e-03,-7.249277e-03,-7.243098e-03,-7.223328e-03,-7.190043e-03,-7.143346e-03,-7.083365e-03,-7.010251e-03,
 -6.924179e-03,-6.825349e-03,-6.713986e-03,-6.590332e-03,-6.454659e-03,-6.307254e-03,-6.148431e-03,-5.978519e-03,
 -5.797872e-03,-5.606859e-03,-5.405871e-03,-5.195311e-03,-4.975605e-03,-4.747192e-03,-4.510527e-03,-4.266078e-03,
 -4.014326e-03,-3.755768e-03,-3.490907e-03,-3.220261e-03,-2.944352e-03,-2.663717e-03,-2.378895e-03,-2.090435e-03,
 -1.798888e-03,-1.504812e-03,-1.208767e-03,-9.113150e-04,-6.130177e-04,-3.144382e-04,-1.613856e-05, 2.813210e-04,
  5.773830e-04, 8.714958e-04, 1.163113e-03, 1.451692e-03, 1.736702e-03, 2.017617e-03, 2.293919e-03, 2.565105e-03,
  2.830678e-03, 3.090155e-03, 3.343069e-03, 3.588962e-03, 3.827393e-03, 4.057934e-03, 4.280178e-03, 4.493730e-03,
  4.698212e-03, 4.893268e-03, 5.078560e-03, 5.253768e-03, 5.418590e-03, 5.572749e-03, 5.715985e-03, 5.848063e-03,
  5.968767e-03, 6.077904e-03, 6.175302e-03, 6.260813e-03, 6.334310e-03, 6.395692e-03, 6.444882e-03, 6.481820e-03,
  6.506474e-03, 6.518833e-03, 6.518913e-03, 6.506750e-03, 6.482402e-03, 6.445953e-03, 6.397506e-03, 6.337191e-03,
  6.265154e-03, 6.181567e-03, 6.086622e-03, 5.980534e-03, 5.863533e-03, 5.735874e-03, 5.597830e-03, 5.449692e-03,
  5.291769e-03, 5.124388e-03, 4.947893e-03, 4.762645e-03, 4.569018e-03, 4.367404e-03, 4.158206e-03, 3.941842e-03,
  3.718742e-03, 3.489346e-03, 3.254106e-03, 3.013482e-03, 2.767946e-03, 2.517978e-03, 2.264059e-03, 2.006681e-03,
  1.746341e-03, 1.483540e-03, 1.218779e-03, 9.525655e-04, 6.854069e-04, 4.178084e-04, 1.502777e-04,-1.166814e-04,
 -3.825650e-04,-6.468747e-04,-9.091177e-04,-1.168804e-03,-1.425449e-03,-1.678580e-03,-1.927729e-03,-2.172437e-03,
 -2.412255e-03,-2.646746e-03,-2.875481e-03,-3.098048e-03,-3.314042e-03,-3.523078e-03,-3.724780e-03,-3.918789e-03,
 -4.104761e-03,-4.282372e-03,-4.451309e-03,-4.611281e-03,-4.762012e-03,-4.903244e-03,-5.034740e-03,-5.156280e-03,
 -5.267667e-03,-5.368718e-03,-5.459274e-03,-5.539198e-03,-5.608369e-03,-5.666691e-03,-5.714086e-03,-5.750496e-03,
 -5.775886e-03,-5.790243e-03,-5.793572e-03,-5.785903e-03,-5.767282e-03,-5.737778e-03,-5.697479e-03,-5.646496e-03,
 -5.584957e-03,-5.513011e-03,-5.430827e-03,-5.338591e-03,-5.236508e-03,-5.124803e-03,-5.003715e-03,-4.873505e-03,
 -4.734443e-03,-4.586823e-03,-4.430950e-03,-4.267144e-03,-4.095740e-03,-3.917087e-03,-3.731543e-03,-3.539482e-03,
 -3.341289e-03,-3.137356e-03,-2.928090e-03,-2.713900e-03,-2.495212e-03,-2.272449e-03,-2.046049e-03,-1.816451e-03,
 -1.584101e-03,-1.349446e-03,-1.112940e-03,-8.750357e-04,-6.361900e-04,-3.968576e-04,-1.574939e-04, 8.144811e-05,
  3.195150e-04, 5.562586e-04, 7.912335e-04, 1.024001e-03, 1.254126e-03, 1.481180e-03, 1.704742e-03, 1.924398e-03,
  2.139745e-03, 2.350387e-03, 2.555937e-03, 2.756023e-03, 2.950282e-03, 3.138363e-03, 3.319929e-03, 3.494654e-03,
  3.662228e-03, 3.822357e-03, 3.974758e-03, 4.119168e-03, 4.255335e-03, 4.383028e-03, 4.502031e-03, 4.612145e-03,
  4.713188e-03, 4.804995e-03, 4.887423e-03, 4.960344e-03, 5.023647e-03, 5.077244e-03, 5.121062e-03, 5.155048e-03,
  5.179170e-03, 5.193414e-03, 5.197781e-03, 5.192294e-03, 5.176995e-03, 5.151943e-03, 5.117217e-03, 5.072911e-03,
  5.019140e-03, 4.956038e-03, 4.883752e-03, 4.802448e-03, 4.712310e-03, 4.613536e-03, 4.506341e-03, 4.390954e-03,
  4.267622e-03, 4.136604e-03, 3.998173e-03, 3.852614e-03, 3.700228e-03, 3.541324e-03, 3.376226e-03, 3.205269e-03,
  3.028795e-03, 2.847155e-03, 2.660715e-03, 2.469841e-03, 2.274911e-03, 2.076309e-03, 1.874424e-03, 1.669650e-03,
  1.462388e-03, 1.253037e-03, 1.042003e-03, 8.296931e-04, 6.165153e-04, 4.028769e-04, 1.891872e-04,-2.414728e-05,
 -2.367220e-04,-4.481347e-04,-6.579873e-04,-8.658836e-04,-1.071435e-03,-1.274260e-03,-1.473978e-03,-1.670221e-03,
 -1.862624e-03,-2.050835e-03,-2.234508e-03,-2.413308e-03,-2.586909e-03,-2.754998e-03,-2.917272e-03,-3.073442e-03,
 -3.223229e-03,-3.366367e-03,-3.502605e-03,-3.631707e-03,-3.753448e-03,-3.867621e-03,-3.974033e-03,-4.072505e-03,
 -4.162875e-03,-4.244997e-03,-4.318740e-03,-4.383991e-03,-4.440655e-03,-4.488647e-03,-4.527906e-03,-4.558385e-03,
 -4.580055e-03,-4.592901e-03,-4.596930e-03,-4.592159e-03,-4.578626e-03,-4.556387e-03,-4.525512e-03,-4.486086e-03,
 -4.438213e-03,-4.382012e-03,-4.317616e-03,-4.245175e-03,-4.164851e-03,-4.076825e-03,-3.981288e-03,-3.878450e-03,
 -3.768527e-03,-3.651753e-03,-3.528373e-03,-3.398643e-03,-3.262832e-03,-3.121219e-03,-2.974090e-03,-2.821747e-03,
 -2.664497e-03,-2.502655e-03,-2.336546e-03,-2.166500e-03,-1.992854e-03,-1.815953e-03,-1.636143e-03,-1.453778e-03,
 -1.269214e-03,-1.082811e-03,-8.949310e-04,-7.059384e-04,-5.161950e-04,-3.260668e-04,-1.359196e-04, 5.388517e-05,
  2.429854e-04, 4.310233e-04, 6.176413e-04, 8.024897e-04, 9.852200e-04, 1.165490e-03, 1.342962e-03, 1.517310e-03,
  1.688208e-03, 1.855342e-03, 2.018404e-03, 2.177096e-03, 2.331130e-03, 2.480226e-03, 2.624115e-03, 2.762540e-03,
  2.895254e-03, 3.022023e-03, 3.142623e-03, 3.256843e-03, 3.364487e-03, 3.465372e-03, 3.559325e-03, 3.646191e-03,
  3.725826e-03, 3.798102e-03, 3.862906e-03, 3.920136e-03, 3.969710e-03, 4.011556e-03, 4.045622e-03, 4.071866e-03,
  4.090268e-03, 4.100815e-03, 4.103514e-03, 4.098385e-03, 4.085464e-03, 4.064802e-03, 4.036464e-03, 4.000529e-03,
  3.957092e-03, 3.906259e-03, 3.848154e-03, 3.782911e-03, 3.710680e-03, 3.631621e-03, 3.545907e-03, 3.453726e-03,
  3.355275e-03, 3.250764e-03, 3.140412e-03, 3.024450e-03, 2.903120e-03, 2.776670e-03, 2.645360e-03, 2.509457e-03,
  2.369237e-03, 2.224984e-03, 2.076986e-03, 1.925540e-03, 1.770946e-03, 1.613511e-03, 1.453547e-03, 1.291368e-03,
  1.127292e-03, 9.616396e-04, 7.947324e-04, 6.268949e-04, 4.584516e-04, 2.897283e-04, 1.210485e-04,-4.726559e-05,
 -2.148923e-04,-3.815133e-04,-5.468131e-04,-7.104784e-04,-8.722021e-04,-1.031681e-03,-1.188615e-03,-1.342716e-03,
 -1.493696e-03,-1.641275e-03,-1.785183e-03,-1.925158e-03,-2.060943e-03,-2.192292e-03,-2.318970e-03,-2.440749e-03,
 -2.557412e-03,-2.668752e-03,-2.774576e-03,-2.874698e-03,-2.968947e-03,-3.057161e-03,-3.139191e-03,-3.214901e-03,
 -3.284168e-03,-3.346881e-03,-3.402942e-03,-3.452266e-03,-3.494782e-03,-3.530431e-03,-3.559169e-03,-3.580964e-03,
 -3.595798e-03,-3.603666e-03,-3.604576e-03,-3.598551e-03,-3.585627e-03,-3.565851e-03,-3.539287e-03,-3.506006e-03,
 -3.466095e-03,-3.419655e-03,-3.366799e-03,-3.307648e-03,-3.242337e-03,-3.171014e-03,-3.093835e-03,-3.010970e-03,
 -2.922597e-03,-2.828904e-03,-2.730090e-03,-2.626362e-03,-2.517936e-03,-2.405036e-03,-2.287896e-03,-2.166755e-03,
 -2.041858e-03,-1.913457e-03,-1.781813e-03,-1.647190e-03,-1.509854e-03,-1.370082e-03,-1.228150e-03,-1.084335e-03,
 -9.389229e-04,-7.921979e-04,-6.444455e-04,-4.959532e-04,-3.470099e-04,-1.979033e-04,-4.891873e-05, 9.965677e-05,
  2.475381e-04, 3.944457e-04, 5.400996e-04, 6.842248e-04, 8.265486e-04, 9.668045e-04, 1.104730e-03, 1.240068e-03,
  1.372567e-03, 1.501984e-03, 1.628079e-03, 1.750623e-03, 1.869392e-03, 1.984170e-03, 2.094751e-03, 2.200938e-03,
  2.302543e-03, 2.399384e-03, 2.491292e-03, 2.578108e-03, 2.659685e-03, 2.735881e-03, 2.806572e-03, 2.871639e-03,
  2.930976e-03, 2.984491e-03, 3.032102e-03, 3.073736e-03, 3.109336e-03, 3.138853e-03, 3.162253e-03, 3.179511e-03,
  3.190618e-03, 3.195573e-03, 3.194390e-03, 3.187090e-03, 3.173709e-03, 3.154296e-03, 3.128908e-03, 3.097617e-03,
  3.060501e-03, 3.017654e-03, 2.969179e-03, 2.915189e-03, 2.855807e-03, 2.791168e-03, 2.721415e-03, 2.646699e-03,
  2.567182e-03, 2.483032e-03, 2.394430e-03, 2.301562e-03, 2.204622e-03, 2.103811e-03, 1.999336e-03, 1.891412e-03,
  1.780260e-03, 1.666104e-03, 1.549175e-03, 1.429709e-03, 1.307943e-03, 1.184120e-03, 1.058488e-03, 9.312945e-04,
  8.027889e-04, 6.732242e-04, 5.428532e-04, 4.119306e-04, 2.807108e-04, 1.494467e-04, 1.839175e-05,-1.122033e-04,
 -2.420871e-04,-3.710135e-04,-4.987371e-04,-6.250159e-04,-7.496117e-04,-8.722909e-04,-9.928239e-04,-1.110987e-03,
 -1.226560e-03,-1.339330e-03,-1.449090e-03,-1.555640e-03,-1.658785e-03,-1.758339e-03,-1.854124e-03,-1.945969e-03,
 -2.033710e-03,-2.117194e-03,-2.196276e-03,-2.270818e-03,-2.340694e-03,-2.405787e-03,-2.465987e-03,-2.521197e-03,
 -2.571330e-03,-2.616305e-03,-2.656056e-03,-2.690526e-03,-2.719667e-03,-2.743442e-03,-2.761826e-03,-2.774801e-03,
 -2.782364e-03,-2.784520e-03,-2.781284e-03,-2.772683e-03,-2.758752e-03,-2.739538e-03,-2.715099e-03,-2.685500e-03,
 -2.650818e-03,-2.611136e-03,-2.566551e-03,-2.517168e-03,-2.463099e-03,-2.404465e-03,-2.341397e-03,-2.274032e-03,
 -2.202518e-03,-2.127006e-03,-2.047659e-03,-1.964644e-03,-1.878134e-03,-1.788308e-03,-1.695353e-03,-1.599460e-03,
 -1.500824e-03,-1.399647e-03,-1.296133e-03,-1.190489e-03,-1.082930e-03,-9.736690e-04,-8.629227e-04,-7.509113e-04,
 -6.378566e-04,-5.239800e-04,-4.095043e-04,-2.946542e-04,-1.796516e-04,-6.471955e-05, 4.992016e-05, 1.640468e-04,
  2.774426e-04, 3.898903e-04, 5.011770e-04, 6.110922e-04, 7.194270e-04, 8.259797e-04, 9.305521e-04, 1.032949e-03,
  1.132979e-03, 1.230459e-03, 1.325210e-03, 1.417058e-03, 1.505840e-03, 1.591393e-03, 1.673563e-03, 1.752204e-03,
  1.827180e-03, 1.898357e-03, 1.965614e-03, 2.028836e-03, 2.087914e-03, 2.142750e-03, 2.193254e-03, 2.239345e-03,
  2.280951e-03, 2.318009e-03, 2.350464e-03, 2.378271e-03, 2.401391e-03, 2.419801e-03, 2.433482e-03, 2.442425e-03,
  2.446631e-03, 2.446109e-03, 2.440878e-03, 2.430968e-03, 2.416415e-03, 2.397263e-03, 2.373570e-03, 2.345397e-03,
  2.312816e-03, 2.275905e-03, 2.234755e-03, 2.189460e-03, 2.140124e-03, 2.086858e-03, 2.029779e-03, 1.969013e-03,
  1.904691e-03, 1.836951e-03, 1.765939e-03, 1.691802e-03, 1.614698e-03, 1.534788e-03, 1.452234e-03, 1.367208e-03,
  1.279884e-03, 1.190440e-03, 1.099057e-03, 1.005920e-03, 9.112147e-04, 8.151309e-04, 7.178604e-04, 6.195953e-04,
  5.205294e-04, 4.208586e-04, 3.207772e-04, 2.204815e-04, 1.201660e-04, 2.002514e-05,-7.974774e-05,-1.789611e-04,
 -2.774249e-04,-3.749523e-04,-4.713577e-04,-5.664587e-04,-6.600762e-04,-7.520345e-04,-8.421624e-04,-9.302923e-04,
 -1.016261e-03,-1.099911e-03,-1.181089e-03,-1.259648e-03,-1.335445e-03,-1.408345e-03,-1.478218e-03,-1.544940e-03,
 -1.608396e-03,-1.668475e-03,-1.725073e-03,-1.778093e-03,-1.827448e-03,-1.873055e-03,-1.914844e-03,-1.952747e-03,
 -1.986705e-03,-2.016669e-03,-2.042595e-03,-2.064451e-03,-2.082210e-03,-2.095852e-03,-2.105369e-03,-2.110759e-03,
 -2.112027e-03,-2.109186e-03,-2.102260e-03,-2.091277e-03,-2.076276e-03,-2.057300e-03,-2.034404e-03,-2.007645e-03,
 -1.977091e-03,-1.942817e-03,-1.904905e-03,-1.863441e-03,-1.818522e-03,-1.770248e-03,-1.718726e-03,-1.664067e-03,
 -1.606393e-03,-1.545825e-03,-1.482494e-03,-1.416533e-03,-1.348081e-03,-1.277281e-03,-1.204278e-03,-1.129224e-03,
 -1.052273e-03,-9.735802e-04,-8.933066e-04,-8.116156e-04,-7.286699e-04,-6.446361e-04,-5.596813e-04,-4.739730e-04,
 -3.876832e-04,-3.009789e-04,-2.140324e-04,-1.270122e-04,-4.008827e-05, 4.657291e-05, 1.328024e-04, 2.184352e-04,
  3.033073e-04, 3.872560e-04, 4.701234e-04, 5.517525e-04, 6.319901e-04, 7.106842e-04, 7.876916e-04, 8.628676e-04,
  9.360725e-04, 1.007173e-03, 1.076041e-03, 1.142551e-03, 1.206583e-03, 1.268024e-03, 1.326762e-03, 1.382697e-03,
  1.435730e-03, 1.485771e-03, 1.532734e-03, 1.576540e-03, 1.617120e-03, 1.654405e-03, 1.688336e-03, 1.718862e-03,
  1.745938e-03, 1.769524e-03, 1.789590e-03, 1.806110e-03, 1.819066e-03, 1.828450e-03, 1.834257e-03, 1.836490e-03,
  1.835159e-03, 1.830282e-03, 1.821883e-03, 1.809992e-03, 1.794648e-03, 1.775893e-03, 1.753779e-03, 1.728363e-03,
  1.699705e-03, 1.667878e-03, 1.632956e-03, 1.595018e-03, 1.554151e-03, 1.510446e-03, 1.464001e-03, 1.414918e-03,
  1.363303e-03, 1.309265e-03, 1.252920e-03, 1.194388e-03, 1.133791e-03, 1.071256e-03, 1.006914e-03, 9.408943e-04,
  8.733342e-04, 8.043715e-04, 7.341457e-04, 6.627990e-04, 5.904748e-04, 5.173172e-04, 4.434723e-04, 3.690861e-04,
  2.943067e-04, 2.192808e-04, 1.441549e-04, 6.907601e-05,-5.810406e-06,-8.036008e-05,-1.544274e-04,-2.278724e-04,
 -3.005536e-04,-3.723331e-04,-4.430746e-04,-5.126460e-04,-5.809160e-04,-6.477582e-04,-7.130477e-04,-7.766630e-04,
 -8.384899e-04,-8.984139e-04,-9.563265e-04,-1.012124e-03,-1.065706e-03,-1.116978e-03,-1.165851e-03,-1.212239e-03,
 -1.256063e-03,-1.297248e-03,-1.335723e-03,-1.371428e-03,-1.404305e-03,-1.434300e-03,-1.461368e-03,-1.485469e-03,
 -1.506569e-03,-1.524639e-03,-1.539656e-03,-1.551604e-03,-1.560475e-03,-1.566264e-03,-1.568970e-03,-1.568606e-03,
 -1.565182e-03,-1.558719e-03,-1.549243e-03,-1.536785e-03,-1.521382e-03,-1.503076e-03,-1.481916e-03,-1.457956e-03,
 -1.431255e-03,-1.401877e-03,-1.369889e-03,-1.335366e-03,-1.298385e-03,-1.259030e-03,-1.217388e-03,-1.173547e-03,
 -1.127606e-03,-1.079663e-03,-1.029820e-03,-9.781791e-04,-9.248534e-04,-8.699528e-04,-8.135899e-04,-7.558808e-04,
 -6.969438e-04,-6.369008e-04,-5.758738e-04,-5.139835e-04,-4.513566e-04,-3.881182e-04,-3.243947e-04,-2.603112e-04,
 -1.959949e-04,-1.315736e-04,-6.717191e-05,-2.914518e-06, 6.107318e-05, 1.246657e-04, 1.877423e-04, 2.501819e-04,
  3.118645e-04, 3.726753e-04, 4.324984e-04, 4.912200e-04, 5.487328e-04, 6.049288e-04, 6.597034e-04, 7.129566e-04,
  7.645906e-04, 8.145114e-04, 8.626298e-04, 9.088617e-04, 9.531232e-04, 9.953366e-04, 1.035427e-03, 1.073328e-03,
  1.108974e-03, 1.142306e-03, 1.173268e-03, 1.201811e-03, 1.227891e-03, 1.251464e-03, 1.272498e-03, 1.290964e-03,
  1.306836e-03, 1.320096e-03, 1.330728e-03, 1.338723e-03, 1.344077e-03, 1.346793e-03, 1.346875e-03, 1.344335e-03,
  1.339190e-03, 1.331462e-03, 1.321176e-03, 1.308366e-03, 1.293066e-03, 1.275319e-03, 1.255170e-03, 1.232669e-03,
  1.207870e-03, 1.180832e-03, 1.151617e-03, 1.120291e-03, 1.086927e-03, 1.051599e-03, 1.014383e-03, 9.753634e-04,
  9.346213e-04, 8.922445e-04, 8.483251e-04, 8.029537e-04, 7.562269e-04, 7.082416e-04, 6.590967e-04, 6.088938e-04,
  5.577356e-04, 5.057275e-04, 4.529732e-04, 3.995805e-04, 3.456559e-04, 2.913075e-04, 2.366437e-04, 1.817731e-04,
  1.268027e-04, 7.184106e-05, 1.699629e-05,-3.762670e-05,-9.192186e-05,-1.457825e-04,-1.991072e-04,-2.517941e-04,
 -3.037426e-04,-3.548542e-04,-4.050344e-04,-4.541883e-04,-5.022236e-04,-5.490514e-04,-5.945871e-04,-6.387472e-04,
 -6.814519e-04,-7.226231e-04,-7.621876e-04,-8.000763e-04,-8.362222e-04,-8.705632e-04,-9.030404e-04,-9.335984e-04,
 -9.621868e-04,-9.887573e-04,-1.013268e-03,-1.035681e-03,-1.055962e-03,-1.074081e-03,-1.090012e-03,-1.103735e-03,
 -1.115233e-03,-1.124495e-03,-1.131510e-03,-1.136276e-03,-1.138796e-03,-1.139075e-03,-1.137122e-03,-1.132950e-03,
 -1.126580e-03,-1.118033e-03,-1.107338e-03,-1.094524e-03,-1.079625e-03,-1.062682e-03,-1.043737e-03,-1.022837e-03,
 -1.000032e-03,-9.753749e-04,-9.489233e-04,-9.207365e-04,-8.908795e-04,-8.594169e-04,-8.264184e-04,-7.919555e-04,
 -7.561035e-04,-7.189393e-04,-6.805416e-04,-6.409910e-04,-6.003705e-04,-5.587654e-04,-5.162607e-04,-4.729459e-04,
 -4.289087e-04,-3.842386e-04,-3.390254e-04,-2.933611e-04,-2.473380e-04,-2.010460e-04,-1.545786e-04,-1.080285e-04,
 -6.148689e-05,-1.504507e-05, 3.120662e-05, 7.717996e-05, 1.227843e-04, 1.679321e-04, 2.125370e-04, 2.565146e-04,
  2.997806e-04, 3.422551e-04, 3.838581e-04, 4.245105e-04, 4.641383e-04, 5.026682e-04, 5.400311e-04, 5.761579e-04,
  6.109851e-04, 6.444487e-04, 6.764902e-04, 7.070545e-04, 7.360878e-04, 7.635395e-04, 7.893640e-04, 8.135197e-04,
  8.359675e-04, 8.566700e-04, 8.755960e-04, 8.927149e-04, 9.080024e-04, 9.214381e-04, 9.330033e-04, 9.426857e-04,
  9.504751e-04, 9.563651e-04, 9.603528e-04, 9.624400e-04, 9.626323e-04, 9.609371e-04, 9.573680e-04, 9.519402e-04,
  9.446741e-04, 9.355922e-04, 9.247214e-04, 9.120914e-04, 8.977352e-04, 8.816905e-04, 8.639957e-04, 8.446941e-04,
  8.238309e-04, 8.014557e-04, 7.776190e-04, 7.523748e-04, 7.257788e-04, 6.978914e-04, 6.687725e-04, 6.384865e-04,
  6.070971e-04, 5.746711e-04, 5.412774e-04, 5.069879e-04, 4.718733e-04, 4.360060e-04, 3.994609e-04, 3.623126e-04,
  3.246379e-04, 2.865127e-04, 2.480134e-04, 2.092187e-04, 1.702052e-04, 1.310513e-04, 9.183494e-05, 5.263326e-05,
  1.352252e-05,-2.542086e-05,-6.412093e-05,-1.025033e-04,-1.404939e-04,-1.780196e-04,-2.150074e-04,-2.513897e-04,
 -2.870979e-04,-3.220637e-04,-3.562235e-04,-3.895132e-04,-4.218725e-04,-4.532416e-04,-4.835643e-04,-5.127863e-04,
 -5.408553e-04,-5.677223e-04,-5.933401e-04,-6.176653e-04,-6.406560e-04,-6.622736e-04,-6.824823e-04,-7.012505e-04,
 -7.185469e-04,-7.343461e-04,-7.486234e-04,-7.613583e-04,-7.725353e-04,-7.821396e-04,-7.901601e-04,-7.965874e-04,
 -8.014183e-04,-8.046516e-04,-8.062896e-04,-8.063351e-04,-8.047981e-04,-8.016884e-04,-7.970203e-04,-7.908111e-04,
 -7.830808e-04,-7.738535e-04,-7.631531e-04,-7.510094e-04,-7.374518e-04,-7.225163e-04,-7.062385e-04,-6.886568e-04,
 -6.698125e-04,-6.497497e-04,-6.285150e-04,-6.061555e-04,-5.827199e-04,-5.582596e-04,-5.328293e-04,-5.064844e-04,
 -4.792802e-04,-4.512762e-04,-4.225304e-04,-3.931029e-04,-3.630557e-04,-3.324519e-04,-3.013536e-04,-2.698259e-04,
 -2.379323e-04,-2.057383e-04,-1.733085e-04,-1.407070e-04,-1.080003e-04,-7.525231e-05,-4.252954e-05,-9.895047e-06,
  2.258785e-05, 5.485576e-05, 8.684579e-05, 1.184966e-04, 1.497470e-04, 1.805376e-04, 2.108096e-04, 2.405069e-04,
  2.695729e-04, 2.979553e-04, 3.256008e-04, 3.524594e-04, 3.784811e-04, 4.036184e-04, 4.278273e-04, 4.510650e-04,
  4.732894e-04, 4.944630e-04, 5.145513e-04, 5.335168e-04, 5.513303e-04, 5.679624e-04, 5.833861e-04, 5.975778e-04,
  6.105156e-04, 6.221805e-04, 6.325573e-04, 6.416310e-04, 6.493917e-04, 6.558281e-04, 6.609373e-04, 6.647158e-04,
  6.671627e-04, 6.682805e-04, 6.680736e-04, 6.665495e-04, 6.637187e-04, 6.595929e-04, 6.541888e-04, 6.475219e-04,
  6.396122e-04, 6.304835e-04, 6.201599e-04, 6.086667e-04, 5.960337e-04, 5.822930e-04, 5.674771e-04, 5.516196e-04,
  5.347586e-04, 5.169333e-04, 4.981830e-04, 4.785498e-04, 4.580787e-04, 4.368141e-04, 4.148006e-04, 3.920874e-04,
  3.687230e-04, 3.447554e-04, 3.202377e-04, 2.952208e-04, 2.697556e-04, 2.438961e-04, 2.176949e-04, 1.912067e-04,
  1.644845e-04, 1.375820e-04, 1.105546e-04, 8.345546e-05, 5.633888e-05, 2.925946e-05, 2.269935e-06,-2.457738e-05,
 -5.122955e-05,-7.763439e-05,-1.037407e-04,-1.294995e-04,-1.548603e-04,-1.797757e-04,-2.041991e-04,-2.280854e-04,
 -2.513896e-04,-2.740682e-04,-2.960800e-04,-3.173853e-04,-3.379460e-04,-3.577239e-04,-3.766858e-04,-3.947981e-04,
 -4.120295e-04,-4.283489e-04,-4.437310e-04,-4.581504e-04,-4.715830e-04,-4.840076e-04,-4.954046e-04,-5.057581e-04,
 -5.150533e-04,-5.232769e-04,-5.304185e-04,-5.364701e-04,-5.414254e-04,-5.452818e-04,-5.480369e-04,-5.496905e-04,
 -5.502454e-04,-5.497077e-04,-5.480841e-04,-5.453834e-04,-5.416186e-04,-5.368009e-04,-5.309449e-04,-5.240695e-04,
 -5.161943e-04,-5.073408e-04,-4.975296e-04,-4.867883e-04,-4.751417e-04,-4.626184e-04,-4.492483e-04,-4.350621e-04,
 -4.200931e-04,-4.043739e-04,-3.879420e-04,-3.708328e-04,-3.530842e-04,-3.347355e-04,-3.158261e-04,-2.963967e-04,
 -2.764876e-04,-2.561429e-04,-2.354039e-04,-2.143138e-04,-1.929181e-04,-1.712620e-04,-1.493875e-04,-1.273406e-04,
 -1.051647e-04,-8.290645e-05,-6.060974e-05,-3.831826e-05,-1.607801e-05, 6.068459e-06, 2.807835e-05, 4.990834e-05,
  7.151386e-05, 9.285366e-05, 1.138895e-04, 1.345790e-04, 1.548832e-04, 1.747639e-04, 1.941851e-04, 2.131086e-04,
  2.315009e-04, 2.493271e-04, 2.665564e-04, 2.831587e-04, 2.991028e-04, 3.143616e-04, 3.289087e-04, 3.427171e-04,
  3.557649e-04, 3.680301e-04, 3.794933e-04, 3.901370e-04, 3.999420e-04, 4.088955e-04, 4.169836e-04, 4.241970e-04,
  4.305246e-04, 4.359586e-04, 4.404953e-04, 4.441292e-04, 4.468575e-04, 4.486805e-04, 4.495990e-04, 4.496171e-04,
  4.487402e-04, 4.469755e-04, 4.443294e-04, 4.408133e-04, 4.364408e-04, 4.312237e-04, 4.251773e-04, 4.183183e-04,
  4.106664e-04, 4.022404e-04, 3.930616e-04, 3.831530e-04, 3.725371e-04, 3.612410e-04, 3.492900e-04, 3.367114e-04,
  3.235339e-04, 3.097882e-04, 2.955041e-04, 2.807130e-04, 2.654479e-04, 2.497428e-04, 2.336298e-04, 2.171439e-04,
  2.003212e-04, 1.831961e-04, 1.658044e-04, 1.481829e-04, 1.303691e-04, 1.123974e-04, 9.430516e-05, 7.613070e-05,
  5.790937e-05, 3.967778e-05, 2.147331e-05, 3.332532e-06,-1.470983e-05,-3.261773e-05,-5.035687e-05,-6.789274e-05,
 -8.519112e-05,-1.022184e-04,-1.189421e-04,-1.353320e-04,-1.513567e-04,-1.669856e-04,-1.821896e-04,-1.969419e-04,
 -2.112154e-04,-2.249837e-04,-2.382229e-04,-2.509088e-04,-2.630188e-04,-2.745329e-04,-2.854317e-04,-2.956972e-04,
 -3.053124e-04,-3.142617e-04,-3.225315e-04,-3.301072e-04,-3.369795e-04,-3.431379e-04,-3.485755e-04,-3.532855e-04,
 -3.572614e-04,-3.605010e-04,-3.630019e-04,-3.647619e-04,-3.657836e-04,-3.660685e-04,-3.656205e-04,-3.644442e-04,
 -3.625471e-04,-3.599368e-04,-3.566219e-04,-3.526150e-04,-3.479258e-04,-3.425687e-04,-3.365597e-04,-3.299129e-04,
 -3.226463e-04,-3.147764e-04,-3.063250e-04,-2.973116e-04,-2.877575e-04,-2.776831e-04,-2.671145e-04,-2.560753e-04,
 -2.445885e-04,-2.326804e-04,-2.203781e-04,-2.077098e-04,-1.946994e-04,-1.813786e-04,-1.677749e-04,-1.539161e-04,
 -1.398316e-04,-1.255536e-04,-1.111090e-04,-9.652886e-05,-8.184123e-05,-6.707707e-05,-5.226882e-05,-3.744446e-05,
 -2.263391e-05,-7.867037e-06, 6.826844e-06, 2.141945e-05, 3.588126e-05, 5.018448e-05, 6.430113e-05, 7.820368e-05,
  9.186620e-05, 1.052626e-04, 1.183671e-04, 1.311558e-04, 1.436042e-04, 1.556892e-04, 1.673899e-04, 1.786844e-04,
  1.895526e-04, 1.999756e-04, 2.099341e-04, 2.194126e-04, 2.283931e-04, 2.368614e-04, 2.448041e-04, 2.522070e-04,
  2.590592e-04, 2.653498e-04, 2.710701e-04, 2.762127e-04, 2.807702e-04, 2.847360e-04, 2.881065e-04, 2.908784e-04,
  2.930500e-04, 2.946197e-04, 2.955882e-04, 2.959578e-04, 2.957320e-04, 2.949130e-04, 2.935063e-04, 2.915196e-04,
  2.889601e-04, 2.858352e-04, 2.821558e-04, 2.779310e-04, 2.731734e-04, 2.678969e-04, 2.621151e-04, 2.558424e-04,
  2.490924e-04, 2.418830e-04, 2.342330e-04, 2.261586e-04, 2.176789e-04, 2.088133e-04, 1.995819e-04, 1.900062e-04,
  1.801075e-04, 1.699067e-04, 1.594270e-04, 1.486902e-04, 1.377203e-04, 1.265400e-04, 1.151736e-04, 1.036454e-04,
  9.197915e-05, 8.019898e-05, 6.833016e-05, 5.639568e-05, 4.442145e-05, 3.243159e-05, 2.045008e-05, 8.500077e-06,
 -3.394396e-06,-1.520792e-05,-2.691844e-05,-3.850333e-05,-4.993971e-05,-6.120604e-05,-7.228010e-05,-8.314073e-05,
 -9.376773e-05,-1.041414e-04,-1.142415e-04,-1.240496e-04,-1.335477e-04,-1.427192e-04,-1.515458e-04,-1.600143e-04,
 -1.681089e-04,-1.758149e-04,-1.831192e-04,-1.900109e-04,-1.964770e-04,-2.025081e-04,-2.080942e-04,-2.132267e-04,
 -2.178999e-04,-2.221055e-04,-2.258386e-04,-2.290942e-04,-2.318678e-04,-2.341581e-04,-2.359618e-04,-2.372797e-04,
 -2.381121e-04,-2.384591e-04,-2.383247e-04,-2.377121e-04,-2.366240e-04,-2.350661e-04,-2.330445e-04,-2.305668e-04,
 -2.276403e-04,-2.242728e-04,-2.204748e-04,-2.162581e-04,-2.116312e-04,-2.066069e-04,-2.011977e-04,-1.954189e-04,
 -1.892811e-04,-1.828010e-04,-1.759935e-04,-1.688733e-04,-1.614564e-04,-1.537610e-04,-1.458043e-04,-1.376046e-04,
 -1.291790e-04,-1.205461e-04,-1.117247e-04,-1.027337e-04,-9.359297e-05,-8.432022e-05,-7.493745e-05,-6.546239e-05,
 -5.591359e-05,-4.631397e-05,-3.668063e-05,-2.703437e-05,-1.739525e-05,-7.781717e-06, 1.787076e-06, 1.129152e-05,
  2.071362e-05, 3.003250e-05, 3.923234e-05, 4.829366e-05, 5.720105e-05, 6.593598e-05, 7.448230e-05, 8.282478e-05,
  9.094699e-05, 9.883359e-05, 1.064691e-04, 1.138417e-04, 1.209368e-04, 1.277422e-04, 1.342481e-04, 1.404416e-04,
  1.463115e-04, 1.518476e-04, 1.570417e-04, 1.618843e-04, 1.663702e-04, 1.704895e-04, 1.742386e-04, 1.776117e-04,
  1.806036e-04, 1.832113e-04, 1.854323e-04, 1.872639e-04, 1.887057e-04, 1.897562e-04, 1.904159e-04, 1.906866e-04,
  1.905696e-04, 1.900679e-04, 1.891852e-04, 1.879248e-04, 1.862927e-04, 1.842950e-04, 1.819366e-04, 1.792250e-04,
  1.761685e-04, 1.727739e-04, 1.690524e-04, 1.650127e-04, 1.606642e-04, 1.560185e-04, 1.510858e-04, 1.458795e-04,
  1.404107e-04, 1.346940e-04, 1.287414e-04, 1.225661e-04, 1.161817e-04, 1.096036e-04, 1.028451e-04, 9.592165e-05,
  8.884948e-05, 8.164257e-05, 7.431610e-05, 6.688594e-05, 5.936817e-05, 5.177946e-05, 4.413506e-05, 3.644947e-05,
  2.873943e-05, 2.102099e-05, 1.331029e-05, 5.621514e-06,-2.029358e-06,-9.626420e-06,-1.715456e-05,-2.460028e-05,
 -3.194772e-05,-3.918222e-05,-4.629039e-05,-5.325952e-05,-6.007517e-05,-6.672542e-05,-7.319819e-05,-7.948109e-05,
 -8.556165e-05,-9.142989e-05,-9.707500e-05,-1.024859e-04,-1.076548e-04,-1.125716e-04,-1.172282e-04,-1.216175e-04,
 -1.257317e-04,-1.295636e-04,-1.331078e-04,-1.363605e-04,-1.393151e-04,-1.419685e-04,-1.443165e-04,-1.463564e-04,
 -1.480859e-04,-1.495047e-04,-1.506106e-04,-1.514045e-04,-1.518864e-04,-1.520567e-04,-1.519170e-04,-1.514695e-04,
 -1.507195e-04,-1.496698e-04,-1.483218e-04,-1.466826e-04,-1.447560e-04,-1.425483e-04,-1.400666e-04,-1.373167e-04,
 -1.343062e-04,-1.310429e-04,-1.275360e-04,-1.237931e-04,-1.198235e-04,-1.156373e-04,-1.112446e-04,-1.066540e-04,
 -1.018781e-04,-9.692669e-05,-9.181281e-05,-8.654693e-05,-8.113915e-05,-7.560223e-05,-6.994825e-05,-6.419092e-05,
 -5.834054e-05,-5.241151e-05,-4.641517e-05,-4.036469e-05,-3.427315e-05,-2.815312e-05,-2.201607e-05,-1.587522e-05,
 -9.743131e-06,-3.631270e-06, 2.447137e-06, 8.479532e-06, 1.445439e-05, 2.035893e-05, 2.618262e-05, 3.191540e-05,
  3.754431e-05, 4.305886e-05, 4.844880e-05, 5.370276e-05, 5.881380e-05, 6.376969e-05, 6.856296e-05, 7.318406e-05,
  7.762462e-05, 8.187838e-05, 8.593672e-05, 8.979330e-05, 9.343993e-05, 9.687232e-05, 1.000837e-04, 1.030701e-04,
  1.058262e-04, 1.083484e-04, 1.106330e-04, 1.126768e-04, 1.144774e-04, 1.160319e-04, 1.173401e-04, 1.184005e-04,
  1.192127e-04, 1.197755e-04, 1.200908e-04, 1.201584e-04, 1.199802e-04, 1.195594e-04, 1.188980e-04, 1.179983e-04,
  1.168645e-04, 1.154995e-04, 1.139091e-04, 1.120965e-04, 1.100676e-04, 1.078278e-04, 1.053828e-04, 1.027387e-04,
  9.990359e-05, 9.688367e-05, 9.368737e-05, 9.032007e-05, 8.679148e-05, 8.311046e-05, 7.928451e-05, 7.532233e-05,
  7.123300e-05, 6.702553e-05, 6.271090e-05, 5.829804e-05, 5.379543e-05, 4.921294e-05, 4.456140e-05, 3.985045e-05,
  3.509100e-05, 3.029220e-05, 2.546331e-05, 2.061435e-05, 1.575696e-05, 1.090047e-05, 6.055274e-06, 1.230858e-06,
 -3.564611e-06,-8.320173e-06,-1.302606e-05,-1.767244e-05,-2.225246e-05,-2.675495e-05,-3.117281e-05,-3.549648e-05,
 -3.971901e-05,-4.383134e-05,-4.782586e-05,-5.169482e-05,-5.543235e-05,-5.903138e-05,-6.248567e-05,-6.578780e-05,
 -6.893368e-05,-7.191702e-05,-7.473330e-05,-7.737784e-05,-7.984619e-05,-8.213470e-05,-8.423958e-05,-8.615758e-05,
 -8.788673e-05,-8.942437e-05,-9.076868e-05,-9.191803e-05,-9.287151e-05,-9.362839e-05,-9.418901e-05,-9.455384e-05,
 -9.472251e-05,-9.469683e-05,-9.447788e-05,-9.406759e-05,-9.346778e-05,-9.268073e-05,-9.171036e-05,-9.055986e-05,
 -8.923193e-05,-8.773144e-05,-8.606087e-05,-8.422612e-05,-8.223229e-05,-8.008336e-05,-7.778558e-05,-7.534557e-05,
 -7.276766e-05,-7.005965e-05,-6.722799e-05,-6.427753e-05,-6.121707e-05,-5.805237e-05,-5.479100e-05,-5.144042e-05,
 -4.800808e-05,-4.450138e-05,-4.092825e-05,-3.729776e-05,-3.361663e-05,-2.989183e-05,-2.613295e-05,-2.234559e-05,
 -1.854116e-05,-1.472398e-05,-1.090390e-05,-7.089251e-06,-3.286321e-06, 4.962730e-07, 4.252298e-06, 7.972603e-06,
  1.164987e-05, 1.527660e-05, 1.884583e-05, 2.235161e-05, 2.578690e-05, 2.914523e-05, 3.241841e-05, 3.560215e-05,
  3.868965e-05, 4.167707e-05, 4.455816e-05, 4.732625e-05, 4.997734e-05, 5.250672e-05, 5.491137e-05, 5.718476e-05,
  5.932501e-05, 6.132826e-05, 6.319067e-05, 6.490950e-05, 6.648410e-05, 6.791089e-05, 6.918816e-05, 7.031399e-05,
  7.128700e-05, 7.210684e-05, 7.277194e-05, 7.328240e-05, 7.363874e-05, 7.384199e-05, 7.389089e-05, 7.378761e-05,
  7.353353e-05, 7.312913e-05, 7.257748e-05, 7.188086e-05, 7.104073e-05, 7.006084e-05, 6.894360e-05, 6.769173e-05,
  6.631042e-05, 6.480251e-05, 6.317145e-05, 6.142116e-05, 5.955828e-05, 5.758600e-05, 5.550934e-05, 5.333180e-05,
  5.105991e-05, 4.869950e-05, 4.625645e-05, 4.373466e-05, 4.114034e-05, 3.848064e-05, 3.576102e-05, 3.298701e-05,
  3.016469e-05, 2.730120e-05, 2.440197e-05, 2.147282e-05, 1.852034e-05, 1.555080e-05, 1.257019e-05, 9.585678e-06,
  6.602654e-06, 3.627244e-06, 6.660416e-07,-2.276316e-06,-5.191997e-06,-8.076426e-06,-1.092371e-05,-1.372741e-05,
 -1.648254e-05,-1.918482e-05,-2.182769e-05,-2.440609e-05,-2.691625e-05,-2.935317e-05,-3.171162e-05,-3.398810e-05,
 -3.617808e-05,-3.827622e-05,-4.028107e-05,-4.218845e-05,-4.399571e-05,-4.569809e-05,-4.729484e-05,-4.878359e-05,
 -5.016035e-05,-5.142256e-05,-5.257089e-05,-5.360269e-05,-5.451554e-05,-5.531029e-05,-5.598389e-05,-5.653768e-05,
 -5.697187e-05,-5.728510e-05,-5.747796e-05,-5.755036e-05,-5.750441e-05,-5.733957e-05,-5.705794e-05,-5.666087e-05,
 -5.614912e-05,-5.552631e-05,-5.479358e-05,-5.395226e-05,-5.300687e-05,-5.195847e-05,-5.081165e-05,-4.956682e-05,
 -4.822851e-05,-4.680147e-05,-4.528831e-05,-4.369340e-05,-4.201815e-05,-4.026970e-05,-3.845149e-05,-3.656720e-05,
 -3.462100e-05,-3.261869e-05,-3.056492e-05,-2.846212e-05,-2.631622e-05,-2.413237e-05,-2.191405e-05,-1.966596e-05,
 -1.739490e-05,-1.510476e-05,-1.280137e-05,-1.048929e-05,-8.171515e-06,-5.855041e-06,-3.543218e-06,-1.240789e-06,
  1.045975e-06, 3.314168e-06, 5.557381e-06, 7.772659e-06, 9.954075e-06, 1.210034e-05, 1.420433e-05, 1.626254e-05,
  1.827182e-05, 2.022901e-05, 2.212753e-05, 2.396604e-05, 2.574170e-05, 2.744952e-05, 2.908797e-05, 3.065473e-05,
  3.214592e-05, 3.355822e-05, 3.488991e-05, 3.613913e-05, 3.730402e-05, 3.838272e-05, 3.937330e-05, 4.027439e-05,
  4.108570e-05, 4.180512e-05, 4.243180e-05, 4.296644e-05, 4.340624e-05, 4.375305e-05, 4.400672e-05, 4.416727e-05,
  4.423465e-05, 4.420912e-05, 4.409135e-05, 4.388227e-05, 4.358469e-05, 4.319830e-05, 4.272519e-05, 4.216528e-05,
  4.152220e-05, 4.079765e-05, 3.999373e-05, 3.911310e-05, 3.815752e-05, 3.712904e-05, 3.603075e-05, 3.486650e-05,
  3.363931e-05, 3.235055e-05, 3.100416e-05, 2.960365e-05, 2.815196e-05, 2.665266e-05, 2.510869e-05, 2.352381e-05,
  2.190202e-05, 2.024758e-05, 1.856336e-05, 1.685317e-05, 1.512073e-05, 1.336973e-05, 1.160416e-05, 9.828330e-06,
  8.044810e-06, 6.257095e-06, 4.470570e-06, 2.688582e-06, 9.140503e-07,-8.489413e-07,-2.596418e-06,-4.325780e-06,
 -6.031765e-06,-7.712367e-06,-9.365341e-06,-1.098516e-05,-1.257036e-05,-1.411671e-05,-1.562206e-05,-1.708302e-05,
 -1.849767e-05,-1.986285e-05,-2.117547e-05,-2.243431e-05,-2.363696e-05,-2.478189e-05,-2.586588e-05,-2.688772e-05,
 -2.784488e-05,-2.873688e-05,-2.956282e-05,-3.031955e-05,-3.100766e-05,-3.162722e-05,-3.217562e-05,-3.265199e-05,
 -3.305590e-05,-3.338791e-05,-3.364744e-05,-3.383534e-05,-3.395127e-05,-3.399491e-05,-3.396786e-05,-3.387051e-05,
 -3.370385e-05,-3.346718e-05,-3.316319e-05,-3.279096e-05,-3.235429e-05,-3.185389e-05,-3.128893e-05,-3.066368e-05,
 -2.998042e-05,-2.923818e-05,-2.844120e-05,-2.759222e-05,-2.669196e-05,-2.574343e-05,-2.474724e-05,-2.370747e-05,
 -2.262689e-05,-2.150609e-05,-2.034912e-05,-1.915922e-05,-1.793860e-05,-1.669064e-05,-1.541755e-05,-1.412270e-05,
 -1.280831e-05,-1.147775e-05,-1.013319e-05,-8.778584e-06,-7.416641e-06,-6.048489e-06,-4.679207e-06,-3.310820e-06,
 -1.947289e-06,-5.913241e-07, 7.558967e-07, 2.089829e-06, 3.409430e-06, 4.710102e-06, 5.991338e-06, 7.249572e-06,
  8.483129e-06, 9.689715e-06, 1.086537e-05, 1.200727e-05, 1.311527e-05, 1.418742e-05, 1.522131e-05, 1.621406e-05,
  1.716497e-05, 1.807091e-05, 1.893225e-05, 1.974802e-05, 2.051514e-05, 2.123346e-05, 2.190092e-05, 2.251609e-05,
  2.307915e-05, 2.358969e-05, 2.404553e-05, 2.444633e-05, 2.479438e-05, 2.508629e-05, 2.532226e-05, 2.550284e-05,
  2.562910e-05, 2.569932e-05, 2.571383e-05, 2.567391e-05, 2.558078e-05, 2.543399e-05, 2.523516e-05, 2.498434e-05,
  2.468282e-05, 2.433175e-05, 2.393119e-05, 2.348431e-05, 2.299102e-05, 2.245255e-05, 2.187082e-05, 2.124769e-05,
  2.058506e-05, 1.988454e-05, 1.914722e-05, 1.837497e-05, 1.757021e-05, 1.673558e-05, 1.587120e-05, 1.498127e-05,
  1.406634e-05, 1.312832e-05, 1.217125e-05, 1.119599e-05, 1.020447e-05, 9.198765e-06, 8.181488e-06, 7.154911e-06,
  6.122491e-06, 5.085661e-06, 4.046035e-06, 3.006525e-06, 1.968334e-06, 9.358164e-07,-9.130093e-08,-1.109361e-06,
 -2.116904e-06,-3.112634e-06,-4.093597e-06,-5.057189e-06,-6.001880e-06,-6.926326e-06,-7.828054e-06,-8.706052e-06,
 -9.558312e-06,-1.038377e-05,-1.118217e-05,-1.194929e-05,-1.268472e-05,-1.338811e-05,-1.405745e-05,-1.469082e-05,
 -1.528709e-05,-1.584643e-05,-1.636667e-05,-1.684887e-05,-1.729226e-05,-1.769421e-05,-1.805467e-05,-1.837478e-05,
 -1.865284e-05,-1.888900e-05,-1.908325e-05,-1.923558e-05,-1.934601e-05,-1.941453e-05,-1.944112e-05,-1.942600e-05,
 -1.936998e-05,-1.927293e-05,-1.913533e-05,-1.895876e-05,-1.874296e-05,-1.848896e-05,-1.819936e-05,-1.787280e-05,
 -1.751093e-05,-1.711406e-05,-1.668417e-05,-1.622323e-05,-1.573209e-05,-1.520996e-05,-1.466060e-05,-1.408524e-05,
 -1.348418e-05,-1.285942e-05,-1.221288e-05,-1.154588e-05,-1.085925e-05,-1.015607e-05,-9.436465e-06,-8.702952e-06,
 -7.958533e-06,-7.202783e-06,-6.437202e-06,-5.665904e-06,-4.887831e-06,-4.106682e-06,-3.324236e-06,-2.541874e-06,
 -1.759891e-06,-9.802343e-07,-2.053510e-07, 5.623462e-07, 1.323779e-06, 2.075199e-06, 2.815410e-06, 3.543584e-06,
  4.256638e-06, 4.954360e-06, 5.635235e-06, 6.298915e-06, 6.943936e-06, 7.569521e-06, 8.172001e-06, 8.750615e-06,
  9.306632e-06, 9.837869e-06, 1.034295e-05, 1.082151e-05, 1.127201e-05, 1.169461e-05, 1.208885e-05, 1.245315e-05,
  1.278769e-05, 1.309201e-05, 1.336447e-05, 1.360575e-05, 1.381693e-05, 1.399631e-05, 1.414403e-05, 1.426008e-05,
  1.434452e-05, 1.439676e-05, 1.441625e-05, 1.440572e-05, 1.436386e-05, 1.429208e-05, 1.418972e-05, 1.405759e-05,
  1.389588e-05, 1.370529e-05, 1.348651e-05, 1.324163e-05, 1.296962e-05, 1.267098e-05, 1.234777e-05, 1.200138e-05,
  1.163190e-05, 1.124032e-05, 1.082756e-05, 1.039477e-05, 9.943690e-06, 9.475168e-06, 8.990140e-06, 8.489459e-06,
  7.974884e-06, 7.448653e-06, 6.909060e-06, 6.359924e-06, 5.802490e-06, 5.237104e-06, 4.665257e-06, 4.087512e-06,
  3.506433e-06, 2.922792e-06, 2.337735e-06, 1.753244e-06, 1.170725e-06, 5.902067e-07, 1.322228e-08,-5.582904e-07,
 -1.124300e-06,-1.682193e-06,-2.232838e-06,-2.772996e-06,-3.302770e-06,-3.820629e-06,-4.324557e-06,-4.815375e-06,
 -5.291458e-06,-5.751109e-06,-6.195081e-06,-6.620613e-06,-7.029377e-06,-7.419732e-06,-7.789371e-06,-8.138813e-06,
 -8.468092e-06,-8.775033e-06,-9.060646e-06,-9.324649e-06,-9.566018e-06,-9.784036e-06,-9.978797e-06,-1.015003e-05,
 -1.029720e-05,-1.042116e-05,-1.052188e-05,-1.059884e-05,-1.065097e-05,-1.067969e-05,-1.068456e-05,-1.066726e-05,
 -1.062713e-05,-1.056308e-05,-1.047681e-05,-1.036814e-05,-1.023755e-05,-1.008660e-05,-9.915171e-06,-9.723196e-06,
 -9.511163e-06,-9.280587e-06,-9.031816e-06,-8.766415e-06,-8.484200e-06,-8.185651e-06,-7.872285e-06,-7.544449e-06,
 -7.203709e-06,-6.849828e-06,-6.483770e-06,-6.108721e-06,-5.723824e-06,-5.328478e-06,-4.925900e-06,-4.516303e-06,
 -4.101252e-06,-3.680562e-06,-3.254664e-06,-2.825555e-06,-2.395149e-06,-1.964878e-06,-1.534607e-06,-1.104285e-06,
 -6.743421e-07,-2.467764e-07, 1.764981e-07, 5.939985e-07, 1.006445e-06, 1.414439e-06, 1.814764e-06, 2.207155e-06,
  2.590633e-06, 2.965882e-06, 3.330167e-06, 3.684895e-06, 4.027880e-06, 4.357693e-06, 4.674466e-06, 4.978253e-06,
  5.268570e-06, 5.543851e-06, 5.804283e-06, 6.049331e-06, 6.277962e-06, 6.491397e-06, 6.687932e-06, 6.867704e-06,
  7.030764e-06, 7.176577e-06, 7.304111e-06, 7.414534e-06, 7.506678e-06, 7.581711e-06, 7.638413e-06, 7.678487e-06,
  7.701822e-06, 7.708204e-06, 7.696556e-06, 7.666646e-06, 7.620055e-06, 7.557182e-06, 7.479061e-06, 7.384473e-06,
  7.275143e-06, 7.150671e-06, 7.010464e-06, 6.855880e-06, 6.688150e-06, 6.506573e-06, 6.312215e-06, 6.106058e-06,
  5.888526e-06, 5.659225e-06, 5.420055e-06, 5.171373e-06, 4.912809e-06, 4.645947e-06, 4.371160e-06, 4.089747e-06,
  3.800980e-06, 3.506218e-06, 3.206642e-06, 2.902083e-06, 2.594665e-06, 2.283860e-06, 1.971568e-06, 1.658145e-06,
  1.343171e-06, 1.028816e-06, 7.160002e-07, 4.031885e-07, 9.202223e-08,-2.151909e-07,-5.189715e-07,-8.193531e-07,
 -1.114212e-06,-1.404024e-06,-1.687475e-06,-1.964708e-06,-2.233839e-06,-2.496154e-06,-2.749953e-06,-2.995421e-06,
 -3.232050e-06,-3.458542e-06,-3.675572e-06,-3.882341e-06,-4.078410e-06,-4.262477e-06,-4.435195e-06,-4.595979e-06,
 -4.745440e-06,-4.882751e-06,-5.007714e-06,-5.119813e-06,-5.219656e-06,-5.306367e-06,-5.380281e-06,-5.441966e-06,
 -5.490252e-06,-5.525224e-06,-5.548499e-06,-5.558300e-06,-5.556697e-06,-5.541920e-06,-5.514053e-06,-5.473630e-06,
 -5.421683e-06,-5.356943e-06,-5.281696e-06,-5.196305e-06,-5.098468e-06,-4.991639e-06,-4.875015e-06,-4.747562e-06,
 -4.610397e-06,-4.462834e-06,-4.307557e-06,-4.143797e-06,-3.973753e-06,-3.795041e-06,-3.610527e-06,-3.418859e-06,
 -3.221687e-06,-3.019409e-06,-2.813006e-06,-2.601795e-06,-2.388559e-06,-2.171412e-06,-1.950971e-06,-1.728802e-06,
 -1.504718e-06,-1.279255e-06,-1.053392e-06,-8.264459e-07,-6.011492e-07,-3.761488e-07,-1.530944e-07, 6.761480e-08,
  2.849465e-07, 5.001192e-07, 7.114319e-07, 9.190706e-07, 1.122502e-06, 1.320692e-06, 1.514913e-06, 1.702877e-06,
  1.884221e-06, 2.061246e-06, 2.230552e-06, 2.392407e-06, 2.546811e-06, 2.693816e-06, 2.832889e-06, 2.962995e-06,
  3.085304e-06, 3.198646e-06, 3.304191e-06, 3.400821e-06, 3.489171e-06, 3.567040e-06, 3.636763e-06, 3.695955e-06,
  3.747534e-06, 3.789665e-06, 3.822483e-06, 3.845988e-06, 3.860180e-06, 3.865058e-06, 3.860598e-06, 3.847039e-06,
  3.825166e-06, 3.794912e-06, 3.756275e-06, 3.709257e-06, 3.653856e-06, 3.590048e-06, 3.518048e-06, 3.438932e-06,
  3.352881e-06, 3.258694e-06, 3.158630e-06, 3.053320e-06, 2.941056e-06, 2.823880e-06, 2.700241e-06, 2.571270e-06,
  2.437952e-06, 2.300734e-06, 2.158983e-06, 2.013763e-06, 1.866083e-06, 1.716101e-06, 1.562930e-06, 1.408815e-06,
  1.252718e-06, 1.095241e-06, 9.374165e-07, 7.780256e-07, 6.187180e-07, 4.598929e-07, 3.025828e-07, 1.455689e-07,
 -9.421775e-09,-1.627911e-07,-3.151324e-07,-4.650868e-07,-6.114224e-07,-7.548159e-07,-8.943910e-07,-1.030534e-06,
 -1.163226e-06,-1.290851e-06,-1.415213e-06,-1.534000e-06,-1.648224e-06,-1.757601e-06,-1.861056e-06,-1.958432e-06,
 -2.050563e-06,-2.135739e-06,-2.216030e-06,-2.289641e-06,-2.356973e-06,-2.418570e-06,-2.473580e-06,-2.522097e-06,
 -2.563853e-06,-2.598307e-06,-2.626308e-06,-2.647791e-06,-2.662780e-06,-2.670957e-06,-2.672340e-06,-2.668570e-06,
 -2.657630e-06,-2.640754e-06,-2.616725e-06,-2.587242e-06,-2.552171e-06,-2.511512e-06,-2.465265e-06,-2.413430e-06,
 -2.355956e-06,-2.293325e-06,-2.227155e-06,-2.156777e-06,-2.081108e-06,-2.001848e-06,-1.918862e-06,-1.832152e-06,
 -1.741665e-06,-1.647883e-06,-1.552425e-06,-1.454622e-06,-1.353390e-06,-1.250430e-06,-1.145607e-06,-1.038871e-06,
 -9.307541e-07,-8.222896e-07,-7.122587e-07,-6.023627e-07,-4.924666e-07,-3.825705e-07,-2.726231e-07,-1.631067e-07,
 -5.558771e-08, 5.006862e-08, 1.538623e-07, 2.557933e-07, 3.558617e-07, 4.540675e-07, 5.504106e-07, 6.449425e-07,
  7.371806e-07, 8.255587e-07, 9.102114e-07, 9.910875e-07, 1.068721e-06, 1.144247e-06, 1.215430e-06, 1.281321e-06,
  1.343622e-06, 1.402249e-06, 1.456669e-06, 1.505797e-06, 1.551385e-06, 1.592766e-06, 1.628907e-06, 1.660974e-06,
  1.687750e-06, 1.710987e-06, 1.730016e-06, 1.743805e-06, 1.753521e-06, 1.757971e-06, 1.758641e-06, 1.754294e-06,
  1.745015e-06, 1.732421e-06, 1.714709e-06, 1.694215e-06, 1.669688e-06, 1.640652e-06, 1.607932e-06, 1.571729e-06,
  1.532557e-06, 1.489835e-06, 1.444170e-06, 1.394635e-06, 1.342098e-06, 1.288135e-06, 1.230701e-06, 1.171297e-06,
  1.109248e-06, 1.045404e-06, 9.796969e-07, 9.121015e-07, 8.428333e-07, 7.729682e-07, 7.026879e-07, 6.308413e-07,
  5.591808e-07, 4.870379e-07, 4.133286e-07, 3.397027e-07, 2.665594e-07, 1.949823e-07, 1.232190e-07, 5.193830e-08,
 -1.780185e-08,-8.748690e-08,-1.559577e-07,-2.224985e-07,-2.871766e-07,-3.499664e-07,-4.111348e-07,-4.712237e-07,
 -5.294340e-07,-5.852734e-07,-6.379766e-07,-6.892525e-07,-7.370577e-07,-7.828939e-07,-8.261356e-07,-8.671253e-07,
 -9.044962e-07,-9.388735e-07,-9.699150e-07,-9.990387e-07,-1.025086e-06,-1.047314e-06,-1.066007e-06,-1.082240e-06,
 -1.096222e-06,-1.106584e-06,-1.113979e-06,-1.117822e-06,-1.118672e-06,-1.116212e-06,-1.111592e-06,-1.103010e-06,
 -1.091667e-06,-1.079732e-06,-1.063750e-06,-1.044475e-06,-1.023523e-06,-1.000225e-06,-9.734477e-07,-9.454762e-07,
 -9.167257e-07,-8.844115e-07,-8.503694e-07,-8.144647e-07,-7.766974e-07,-7.370160e-07,-6.959544e-07,-6.545966e-07,
 -6.111898e-07,-5.663516e-07,-5.216481e-07,-4.769446e-07,-4.322926e-07,-3.871580e-07,-3.404571e-07,-2.938910e-07,
 -2.473248e-07,-2.007587e-07,-1.541412e-07,-1.080061e-07,-6.343741e-08,-1.873393e-08, 2.596956e-08, 7.072446e-08,
  1.149968e-07, 1.577543e-07, 2.002155e-07, 2.406792e-07, 2.792289e-07, 3.163985e-07, 3.532717e-07, 3.881475e-07,
  4.211607e-07, 4.523112e-07, 4.815476e-07, 5.094554e-07, 5.365843e-07, 5.601495e-07, 5.819868e-07, 6.019614e-07,
  6.200734e-07, 6.363742e-07, 6.502784e-07, 6.612362e-07, 6.720323e-07, 6.808311e-07, 6.878187e-07, 6.924611e-07,
  6.936745e-07, 6.931343e-07, 6.909728e-07, 6.877318e-07, 6.825607e-07, 6.755270e-07, 6.666049e-07, 6.560615e-07,
  6.444386e-07, 6.308856e-07, 6.154700e-07, 5.981660e-07, 5.791893e-07, 5.596155e-07, 5.396781e-07, 5.176918e-07,
  4.943254e-07, 4.706112e-07, 4.453822e-07, 4.198053e-07, 3.926622e-07, 3.656796e-07, 3.384557e-07, 3.104486e-07,
  2.825089e-07, 2.545693e-07, 2.266296e-07, 1.986899e-07, 1.707502e-07, 1.428105e-07, 1.148709e-07, 8.693119e-08,
  5.896581e-08, 3.124169e-08, 4.300716e-09,-2.275906e-08,-4.933631e-08,-7.439868e-08,-9.911328e-08,-1.223130e-07,
 -1.451650e-07,-1.665020e-07,-1.875171e-07,-2.067245e-07,-2.253350e-07,-2.435304e-07,-2.602108e-07,-2.765949e-07,
 -2.909817e-07,-3.034543e-07,-3.145211e-07,-3.255329e-07,-3.353303e-07,-3.431464e-07,-3.495823e-07,-3.557219e-07,
 -3.598383e-07,-3.622820e-07,-3.641287e-07,-3.656116e-07,-3.650458e-07,-3.630998e-07,-3.608574e-07,-3.565663e-07,
 -3.508950e-07,-3.448760e-07,-3.373421e-07,-3.295118e-07,-3.196327e-07,-3.083221e-07,-2.971462e-07,-2.859703e-07,
 -2.748459e-07,-2.632389e-07,-2.500656e-07,-2.370785e-07,-2.236089e-07,-2.085730e-07,-1.936718e-07,-1.787706e-07,
 -1.639209e-07,-1.485886e-07,-1.316901e-07,-1.149263e-07,-9.816246e-08,-8.139865e-08,-6.463485e-08,-4.781962e-08,
 -3.148692e-08,-1.672052e-08,-1.819359e-09, 1.308180e-08, 2.803438e-08, 4.250442e-08, 5.540818e-08, 6.844670e-08,
  8.153663e-08, 9.414403e-08, 1.051851e-07, 1.163610e-07, 1.275369e-07, 1.387642e-07, 1.495089e-07, 1.586874e-07,
  1.680520e-07, 1.769341e-07, 1.843014e-07, 1.913209e-07, 1.968255e-07, 2.019823e-07, 2.056242e-07, 2.089184e-07,
  2.106463e-07, 2.125604e-07, 2.139919e-07, 2.139085e-07, 2.134774e-07, 2.114800e-07, 2.096431e-07, 2.075649e-07,
  2.047036e-07, 2.019610e-07, 1.987359e-07, 1.939445e-07, 1.893393e-07, 1.842516e-07, 1.775976e-07, 1.710783e-07,
  1.645591e-07, 1.580912e-07, 1.511409e-07, 1.426242e-07, 1.342423e-07, 1.258604e-07, 1.174785e-07, 1.090966e-07,
  1.007147e-07, 9.233278e-08, 8.395088e-08, 7.556898e-08, 6.718707e-08, 5.880517e-08, 5.042327e-08, 4.204136e-08,
  3.365946e-08, 2.527756e-08, 1.684424e-08, 8.893451e-09, 2.508955e-09,-4.010303e-09,-1.052956e-08,-1.704882e-08,
 -2.361949e-08,-2.970764e-08,-3.422949e-08,-3.888610e-08,-4.359413e-08,-4.781963e-08,-5.047883e-08,-5.327280e-08,
 -5.609247e-08,-5.867089e-08,-6.046616e-08,-6.232881e-08,-6.419145e-08,-6.610551e-08,-6.753704e-08,-6.740228e-08,
 -6.740228e-08,-6.745370e-08,-6.702258e-08,-6.502518e-08,-6.316253e-08,-6.129989e-08,-5.943724e-08,-5.762601e-08,
 -5.533225e-08,-5.147220e-08,-4.774691e-08,-4.402162e-08,-4.029633e-08,-3.657104e-08,-3.284575e-08,-2.912046e-08,
 -2.539517e-08,-2.166988e-08,-1.794459e-08,-1.421930e-08,-1.049401e-08,-6.768715e-09,-3.043425e-09, 6.818652e-10,
  4.407156e-09, 8.132446e-09, 1.185774e-08, 1.558303e-08, 1.930832e-08, 2.303361e-08, 2.675890e-08, 3.048419e-08,
  3.426089e-08, 3.755507e-08, 3.928295e-08, 4.114560e-08, 4.300824e-08, 4.487089e-08, 4.673353e-08, 4.859618e-08,
  5.051024e-08, 5.194177e-08, 5.180701e-08, 5.180701e-08, 5.180701e-08, 5.180701e-08, 5.180701e-08, 5.180701e-08,
  5.180701e-08, 5.180701e-08, 5.185842e-08, 5.142731e-08, 4.942990e-08, 4.756726e-08, 4.570461e-08, 4.384196e-08,
  4.197932e-08, 4.011667e-08, 3.825403e-08, 3.639138e-08, 3.452874e-08, 3.266609e-08, 3.080345e-08, 2.894080e-08,
  2.707816e-08, 2.521551e-08, 2.335287e-08, 2.149022e-08, 1.962758e-08, 1.776493e-08, 1.590229e-08, 1.403964e-08,
  1.217700e-08, 1.031435e-08, 8.451707e-09, 6.589062e-09, 4.726417e-09, 2.863771e-09, 9.497114e-10,-4.818190e-10,
 -3.470575e-10, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00,
  0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00,
  0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00,
  0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00,
  0.000000e+00
};

