.SS CHAOS
Causes confusion on the other end by doing odd things with incoming packets.
CHAOS will randomly reply (or not) with one of its configurable subtargets:
.TP
\fB\-\-delude\fP
Use the REJECT and DELUDE targets as a base to do a sudden or deferred
connection reset, fooling some network scanners to return non-deterministic
(randomly open/closed) results, and in case it is deemed open, it is actually
closed/filtered.
.TP
\fB\-\-tarpit\fP
Use the REJECT and TARPIT target as a base to hold the connection until it
times out. This consumes conntrack entries when connection tracking is loaded
(which usually is on most machines), and routers inbetween you and the Internet
may fail to do their connection tracking if they have to handle more
connections than they can.
.PP
The randomness factor of not replying vs. replying can be set during load-time
of the xt_CHAOS module or during runtime in /sys/modules/xt_CHAOS/parameters.
.PP
See http://jengelh.medozas.de/projects/chaostables/ for more information
about CHAOS, DELUDE and lscan.
.SS STEAL
Like the DROP target, but does not throw an error like DROP when used in the
\fBOUTPUT\fP chain.
.SS ECHO
The \fBECHO\fP target will send back all packets it received. It serves as an
examples for an Xtables target.
.PP
ECHO takes no options.
.SS DHCPMAC
In conjunction with ebtables, DHCPMAC can be used to completely change all MAC
addresses from and to a VMware-based virtual machine. This is needed because
VMware does not allow to set a non-VMware MAC address before an operating
system is booted (and the MAC be changed with `ip link set eth0 address
aa:bb..`).
.TP
\fB\-\-set\-mac\fP \fIaa:bb:cc:dd:ee:ff\fP[\fB/\fP\fImask\fP]
Replace the client host MAC address field in the DHCP message with the given
MAC address. This option is mandatory. The \fImask\fP parameter specifies the
prefix length of bits to change.
.PP
EXAMPLE, replacing all addresses from one of VMware's assigned vendor IDs
(00:50:56) addresses with something else:
.PP
iptables \-t mangle \-A FORWARD \-p udp \-\-dport 67 \-m physdev
\-\-physdev\-in vmnet1 \-m dhcpmac \-\-mac 00:50:56:00:00:00/24 \-j DHCPMAC
\-\-set\-mac ab:cd:ef:00:00:00/24
.PP
iptables \-t mangle \-A FORWARD \-p udp \-\-dport 68 \-m physdev
\-\-physdev\-out vmnet1 \-m dhcpmac \-\-mac ab:cd:ef:00:00:00/24 \-j DHCPMAC
\-\-set\-mac 00:50:56:00:00:00/24
.PP
(This assumes there is a bridge interface that has vmnet1 as a port. You will
also need to add appropriate ebtables rules to change the MAC address of the
Ethernet headers.)
.SS RAWDNAT
The \fBRAWDNAT\fR target will rewrite the destination address in the IP header,
much like the \fBNETMAP\fR target.
.TP
\fB\-\-to\-destination\fR \fIaddr\fR[\fB/\fR\fImask\fR]
Network address to map to. The resulting address will be constructed the
following way: All 'one' bits in the \fImask\fR are filled in from the new
\fIaddress\fR. All bits that are zero in the mask are filled in from the
original address.
.PP
See the \fBRAWSNAT\fR help entry for examples and constraints.
.SS DELUDE
The DELUDE target will reply to a SYN packet with SYN-ACK, and to all other
packets with an RST. This will terminate the connection much like REJECT, but
network scanners doing TCP half-open discovery can be spoofed to make them
belive the port is open rather than closed/filtered.
.SS TARPIT
Captures and holds incoming TCP connections using no local per-connection
resources. Connections are accepted, but immediately switched to the persist
state (0 byte window), in which the remote side stops sending data and asks to
continue every 60-240 seconds. Attempts to close the connection are ignored,
forcing the remote side to time out the connection in 12-24 minutes.

This offers similar functionality to LaBrea
<http://www.hackbusters.net/LaBrea/> but does not require dedicated hardware or
IPs. Any TCP port that you would normally DROP or REJECT can instead become a
tarpit.

To tarpit connections to TCP port 80 destined for the current machine:
.IP
\-A INPUT \-p tcp \-m tcp \-\-dport 80 \-j TARPIT
.PP
To significantly slow down Code Red/Nimda-style scans of unused address space,
forward unused ip addresses to a Linux box not acting as a router (e.g. "ip
route 10.0.0.0 255.0.0.0 ip.of.linux.box" on a Cisco), enable IP forwarding on
the Linux box, and add:
.IP
\-A FORWARD \-p tcp \-j TARPIT
.IP
\-A FORWARD \-j DROP
.PP
NOTE:
If you use the conntrack module while you are using TARPIT, you should also use
the NOTRACK target, or the kernel will unnecessarily allocate resources for
each TARPITted connection. To TARPIT incoming connections to the standard IRC
port while using conntrack, you could:
.IP
\-t raw \-A PREROUTING \-p tcp \-\-dport 6667 \-j NOTRACK
.IP
\-A INPUT \-p tcp \-\-dport 6667 \-j TARPIT
.SS RAWSNAT
The \fBRAWSNAT\fR and \fBRAWDNAT\fP targets provide stateless network address
translation.
.PP
The \fBRAWSNAT\fR target will rewrite the source address in the IP header, much
like the \fBNETMAP\fP target. \fBRAWSNAT\fP (and \fBRAWDNAT\fP) may only be
used in the \fBraw\fP or \fBrawpost\fP tables, but can be used in all chains,
which makes it possible to change the source address either when the packet
enters the machine or when it leaves it. The reason for this table constraint
is that RAWNAT must happen outside of connection tracking.
.TP
\fB\-\-to\-source\fR \fIaddr\fR[\fB/\fR\fImask\fR]
Network address to map to. The resulting address will be constructed the
following way: All 'one' bits in the \fImask\fR are filled in from the new
\fIaddress\fR. All bits that are zero in the mask are filled in from the
original address.
.PP
As an example, changing the destination for packets forwarded from an internal
LAN to the internet:
.IP
\-t raw \-A PREROUTING \-i lan0 \-d 212.201.100.135 \-j RAWDNAT \-\-to\-destination 199.181.132.250;
\-t rawpost \-A POSTROUTING \-o lan0 \-s 199.181.132.250 \-j RAWSNAT \-\-to\-source 212.201.100.135;
.PP
Note that changing addresses may influence the route selection! Specifically,
it statically NATs packets, not connections, like the normal DNAT/SNAT targets
would do. Also note that it can transform already-NATed connections \(em as
said, it is completely external to Netfilter's connection tracking/NAT.
.PP
If the machine itself generates packets that are to be rawnat'ed, you need a
rule in the OUTPUT chain instead, just like you would with the stateful NAT
targets.
.PP
It may be necessary that in doing so, you also need an extra RAWSNAT rule, to
override the automatic source address selection that the routing code does
before passing packets to iptables. If the connecting socket has not been
explicitly bound to an address, as is the common mode of operation, the address
that will be chosen is the primary address of the device through which the
packet would be routed with its initial destination address - the address as
seen before any RAWNAT takes place.
.SS TEE
The \fBTEE\fP target will clone a packet and redirect this clone to another
machine on the \fBlocal\fP network segment. In other words, the nexthop
must be the target, or you will have to configure the nexthop to forward it
further if so desired.
.TP
\fB\-\-gw\fP \fIipaddr\fP
Send the cloned packet to the host reachable at the given IP address.
Use of 0.0.0.0 (for IPv4 packets) or :: (IPv6) is invalid.
.SS SYSRQ
The SYSRQ target allows to remotely trigger sysrq on the local machine over the
network. This can be useful when vital parts of the machine hang, for example
an oops in a filesystem causing locks to be not released and processes to get
stuck as a result \(em if still possible, use /proc/sysrq-trigger. Even when
processes are stuck, interrupts are likely to be still processed, and as such,
sysrq can be triggered through incoming network packets.
.PP
The xt_SYSRQ implementation uses a salted hash and a sequence number to prevent
network sniffers from either guessing the password or replaying earlier
requests. The initial sequence number comes from the time of day so you will
have a small window of vulnerability should time go backwards at a reboot.
However, the file /sys/module/xt_SYSREQ/seqno can be used to both query and
update the current sequence number. Also, you should limit as to who can issue
commands using \fB\-s\fP and/or \fB\-m mac\fP, and also that the destination is
correct using \fB\-d\fP (to protect against potential broadcast packets),
noting that it is still short of MAC/IP spoofing:
.IP
\-A INPUT \-s 10.10.25.1 \-m mac \-\-mac\-source aa:bb:cc:dd:ee:ff \-d
10.10.25.7 \-p udp \-\-dport 9 \-j SYSRQ
.IP
(with IPsec) \-A INPUT \-s 10.10.25.1 \-d 10.10.25.7 \-m policy \-\-dir in
\-\-pol ipsec \-\-proto esp \-\-tunnel\-src 10.10.25.1 \-\-tunnel\-dst
10.10.25.7 \-p udp \-\-dport 9 \-j SYSRQ
.PP
You should also limit the rate at which connections can be received to limit
the CPU time taken by illegal requests, for example:
.IP
\-A INPUT \-s 10.10.25.1 \-m mac \-\-mac\-source aa:bb:cc:dd:ee:ff \-d
10.10.25.7 \-p udp \-\-dport 9 \-m limit \-\-limit 5/minute \-j SYSRQ
.PP
This extension does not take any options. The \fB\-p udp\fP options are
required.
.PP
The SYSRQ password can be changed through
/sys/module/xt_SYSRQ/parameters/password, for example:
.IP
echo \-n "password" >/sys/module/xt_SYSRQ/parameters/password
.PP
Alternatively, the password may be specified at modprobe time, but this is
insecure as people can possible see it through ps(1). You can use an option
line in e.g. /etc/modprobe.d/xt_sysrq if it is properly guarded, that is, only
readable by root.
.IP
options xt_SYSRQ password=cookies
.PP
The hash algorithm can also be specified as a module option, for example, to
use SHA-256 instead of the default SHA-1:
.IP
options xt_SYSRQ hash=sha256
.PP
The xt_SYSRQ module is normally silent unless a successful request is received,
but the \fIdebug\fP module parameter can be used to find exactly why a
seemingly correct request is not being processed.
.PP
To trigger SYSRQ from a remote host, just use netcat or socat:
.PP
.nf
sysrq_key="s"  # the SysRq key(s)
password="password"
seqno="$(date +%s)"
salt="$(dd bs=12 count=1 if=/dev/urandom 2>/dev/null |
    openssl enc \-base64)"
req="$sysrq_key,$seqno,$salt"
req="$req,$(echo \-n "$req,$password" | sha1sum | cut \-c1\-40)"

echo "$req" | socat stdin udp\-sendto:10.10.25.7:9
# or
echo "$req" | netcat \-uw1 10.10.25.7 9
.fi
.PP
See the Linux docs for possible sysrq keys. Important ones are: re(b)oot,
power(o)ff, (s)ync filesystems, (u)mount and remount readonly. More than one
sysrq key can be used at once, but bear in mind that, for example, a sync may
not complete before a subsequent reboot or poweroff.
.PP
The hashing scheme should be enough to prevent mis-use of SYSRQ in many
environments, but it is not perfect: take reasonable precautions to
protect your machines.  Most importantly ensure that each machine has a
different password; there is scant protection for a SYSRQ packet being
applied to a machine that happens to have the same password.
.SS IPMARK
Allows you to mark a received packet basing on its IP address. This
can replace many mangle/mark entries with only one, if you use
firewall based classifier.

This target is to be used inside the \fBmangle\fP table.
.TP
\fB\-\-addr\fP {\fBsrc\fP|\fBdst\fP}
Select source or destination IP address as a basis for the mark.
.TP
\fB\-\-and\-mask\fP \fImask\fP
Perform bitwise AND on the IP address and this bitmask.
.TP
\fB\-\-or\-mask\fP \fImask\fP
Perform bitwise OR on the IP address and this bitmask.
.TP
\fB\-\-shift\fP \fIvalue\fP
Shift addresses to the right by the given number of bits before taking it
as a mark. (This is done before ANDing or ORing it.) This option is needed
to select part of an IPv6 address, because marks are only 32 bits in size.
.PP
The order of IP address bytes is reversed to meet "human order of bytes":
192.168.0.1 is 0xc0a80001. At first the "AND" operation is performed, then
"OR".
.PP
Examples:
.PP
We create a queue for each user, the queue number is adequate
to the IP address of the user, e.g.: all packets going to/from 192.168.5.2
are directed to 1:0502 queue, 192.168.5.12 -> 1:050c etc.
.PP
We have one classifier rule:
.IP
tc filter add dev eth3 parent 1:0 protocol ip fw
.PP
Earlier we had many rules just like below:
.IP
iptables \-t mangle \-A POSTROUTING \-o eth3 \-d 192.168.5.2 \-j MARK
\-\-set\-mark 0x10502
.IP
iptables \-t mangle \-A POSTROUTING \-o eth3 \-d 192.168.5.3 \-j MARK
\-\-set\-mark 0x10503
.PP
Using IPMARK target we can replace all the mangle/mark rules with only one:
.IP
iptables \-t mangle \-A POSTROUTING \-o eth3 \-j IPMARK \-\-addr dst
\-\-and\-mask 0xffff \-\-or\-mask 0x10000
.PP
On the routers with hundreds of users there should be significant load
decrease (e.g. twice).
.PP
(IPv6 example) If the source address is of the form
2001:db8:45:1d:20d:93ff:fe9b:e443 and the resulting mark should be 0x93ff,
then a right-shift of 16 is needed first:
.IP
\-t mangle \-A PREROUTING \-s 2001:db8::/32 \-j IPMARK \-\-addr src \-\-shift
16 \-\-and\-mask 0xFFFF
.SS ACCOUNT
The ACCOUNT target is a high performance accounting system for large
local networks. It allows per-IP accounting in whole prefixes of IPv4
addresses with size of up to /8 without the need to add individual
accouting rule for each IP address.
.PP
The ACCOUNT is designed to be queried for data every second or at
least every ten seconds. It is written as kernel module to handle high
bandwidths without packet loss.
.PP
The largest possible subnet size is 24 bit, meaning for example 10.0.0.0/8
network. ACCOUNT uses fixed internal data structures
which speeds up the processing of each packet. Furthermore,
accounting data for one complete 192.168.1.X/24 network takes 4 KB of
memory. Memory for 16 or 24 bit networks is only allocated when
needed.
.PP
To optimize the kernel<->userspace data transfer a bit more, the
kernel module only transfers information about IPs, where the src/dst
packet counter is not 0. This saves precious kernel time.
.PP
There is no /proc interface as it would be too slow for continuous access.
The read-and-flush query operation is the fastest, as no internal data
snapshot needs to be created&copied for all data. Use the "read"
operation without flush only for debugging purposes!
.PP
Usage:
.PP
ACCOUNT takes two mandatory parameters:
.TP
\fB\-\-addr\fR \fInetwork\fP\fB/\fP\fInetmask\fR
where \fInetwork\fP\fB/\fP\fInetmask\fP is the subnet to account for, in CIDR syntax
.TP
\fB\-\-tname\fP \fINAME\fP
where \fINAME\fP is the name of the table where the accounting information
should be stored
.PP
The subnet 0.0.0.0/0 is a special case: all data are then stored in the src_bytes
and src_packets structure of slot "0". This is useful if you want
to account the overall traffic to/from your internet provider.
.PP
The data can be queried using the userspace libxt_ACCOUNT_cl library,
and by the reference implementation to show usage of this library,
the \fBiptaccount\fP(8) tool, which features following options:
.PP
[\fB\-u\fP] show kernel handle usage
.PP
[\fB\-h\fP] free all kernel handles (experts only!)
.PP
[\fB\-a\fP] list all table names
.PP
[\fB\-l\fP \fIname\fP] show data in table \fIname\fP
.PP
[\fB\-f\fP] flush data after showing
.PP
[\fB\-c\fP] loop every second (abort with CTRL+C)
.PP
Here is an example of use:
.PP
iptables \-A FORWARD \-j ACCOUNT \-\-addr 0.0.0.0/0 \-\-tname all_outgoing;
iptables \-A FORWARD \-j ACCOUNT \-\-addr 192.168.1.0/24 \-\-tname sales;
.PP
This creates two tables called "all_outgoing" and "sales" which can be
queried using the userspace library/iptaccount tool.
.PP
Note that this target is non-terminating \(em the packet destined to it
will continue traversing the chain in which it has been used.
.PP
Also note that once a table has been defined for specific CIDR address/netmask
block, it can be referenced multiple times using \-j ACCOUNT, provided
that both the original table name and address/netmask block are specified.
.PP
For more information go to http://www.intra2net.com/en/developer/ipt_ACCOUNT/
.SS LOGMARK
The LOGMARK target will log packet and connection marks to syslog.
.TP
\fB\-\-log\-level\fR \fIlevel\fR
A logging level between 0 and 8 (inclusive).
.TP
\fB\-\-log\-prefix\fR \fIstring\fR
Prefix log messages with the specified prefix; up to 29 bytes long, and useful
for distinguishing messages in the logs.
.TP
\fB\-\-log\-nfmark\fR
Include the packet mark in the log.
.TP
\fB\-\-log\-ctmark\fR
Include the connection mark in the log.
.TP
\fB\-\-log\-secmark\fR
Include the packet secmark in the log.
