/* -*- Mode: C++; tab-width: 20; indent-tabs-mode: nil; c-basic-offset: 4 -*-
 * ***** BEGIN LICENSE BLOCK *****
 * Version: MPL 1.1/GPL 2.0/LGPL 2.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is Mozilla Corporation code.
 *
 * The Initial Developer of the Original Code is Mozilla Corporation.
 * Portions created by the Initial Developer are Copyright (C) 2009-2010
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s):
 *   Jonathan Kew <jfkthame@gmail.com>
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ***** END LICENSE BLOCK ***** */

#ifndef GFX_UNICODEPROPERTIES_H
#define GFX_UNICODEPROPERTIES_H

#include "prtypes.h"
#include "gfxTypes.h"

class THEBES_API gfxUnicodeProperties
{
public:
    static PRUint32 GetMirroredChar(PRUint32 aCh);

    static PRUint8 GetCombiningClass(PRUint32 aCh);

    static PRUint8 GetGeneralCategory(PRUint32 aCh);

    static PRUint8 GetEastAsianWidth(PRUint32 aCh);

    static PRInt32 GetScriptCode(PRUint32 aCh);

    enum HSType {
        HST_NONE = 0x00,
        HST_L    = 0x01,
        HST_V    = 0x02,
        HST_T    = 0x04,
        HST_LV   = 0x03,
        HST_LVT  = 0x07
    };

    static HSType GetHangulSyllableType(PRUint32 aCh);

    static PRInt32 ScriptShapingLevel(PRInt32 aScriptCode);
};

#endif /* GFX_UNICODEPROPERTIES_H */
