#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <gtk/gtk.h>
#include <glib.h>
#include <string.h>

#include "callbacks.h"
#include "interface.h"
#include "support.h"
#include "global.h"
#include "net.h"

extern pref_opts xwota_settings;


void
on_quit1_activate                      (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
if (connection_status == 1) {
	disconnect_network(sockfd,readchan);
}
	
	gtk_main_quit();
	
}


void
on_station_info_activate               (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
	
	
//	char call_entry[100],country_entry[100],state_entry[100],grid_entry[100],county_entry[100],lat_entry[100],longitude_entry[100];
	
	station_info_window=create_station_info_window();
	gtk_widget_show(station_info_window);
	gtk_widget_set_sensitive(station_info,FALSE);
	load_preferences();
	//printf("Loading value...\n");
	
	GtkWidget* call = lookup_widget(GTK_WIDGET(station_info_window),"call");
	GtkWidget* country = lookup_widget(GTK_WIDGET(station_info_window),"country");
	GtkWidget* state = lookup_widget(GTK_WIDGET(station_info_window),"state");
	GtkWidget* grid = lookup_widget(GTK_WIDGET(station_info_window),"grid");
	GtkWidget* county = lookup_widget(GTK_WIDGET(station_info_window),"county");
	GtkWidget* lat = lookup_widget(GTK_WIDGET(station_info_window),"lat");
	GtkWidget* longitude = lookup_widget(GTK_WIDGET(station_info_window),"longitude");
	

	
		
	gtk_entry_set_text (GTK_ENTRY (call), xwota_settings.call);
    gtk_entry_set_text (GTK_ENTRY (country),xwota_settings.country);
	gtk_entry_set_text (GTK_ENTRY (state), xwota_settings.state);
	gtk_entry_set_text (GTK_ENTRY (grid), xwota_settings.grid);
	gtk_entry_set_text (GTK_ENTRY (county), xwota_settings.county);
	gtk_entry_set_text (GTK_ENTRY (lat), xwota_settings.latitude);
	gtk_entry_set_text (GTK_ENTRY (longitude),xwota_settings.longitude);
		
}


void
on_manual_activate                     (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
manual = create_manual();
	gtk_widget_show(manual);
}


void
on_about_activate                      (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
	aboutdialog=create_aboutdialog();
	gtk_widget_show(aboutdialog);

}


void
on_clear_comment_clicked               (GtkButton       *button,
                                        gpointer         user_data)
{

//	printf("Clear comment request.\n");
	GtkWidget * comment = lookup_widget(GTK_WIDGET(button),"comment");
	gtk_entry_set_text (GTK_ENTRY (comment), "");
	
}

/* UPDATE INFO */

void
on_update_button_clicked               (GtkButton       *button,
                                        gpointer         user_data)
{
	
	char program_name[40];
	char string_to_send[1000];
	char frequency_entry[100],comment_entry[100];
	gchar *get_frequency,*get_comment;
	int wota_status;
	
	strcpy(program_name,"Xwota 0.2");
	load_preferences();
	
	if (connection_status != 1) {
		write_statusbar("Failed to send. Xwota not connected.");
	return;	
	}
	else if (strcmp(xwota_settings.call,"NOCALL") == 0) {
		write_statusbar("Failed to send. Station info not configured.");
		return;
	}
	
	
	get_frequency= gtk_entry_get_text(GTK_ENTRY(frequency));
	get_comment = gtk_entry_get_text(GTK_ENTRY(comment));
	
	strcpy(frequency_entry,get_frequency);
	strcpy(comment_entry,get_comment);
	
	if(strcmp(get_frequency,old_freq) == 0) {
		wota_status = 2;
	}
	else {
		wota_status = 1;
		old_freq = g_strdup(get_frequency);
	}
	
//	printf("Freq %s - Comment %s\n",frequency_entry,comment_entry);

// Compongo la stringa da inviare al server WOTA
//Call|Frequency|Country|PAS|Grid|SAS|Latitude|Longitude|Status|Comment|Program Name|Future 1|Future 2|<EOR>
sprintf(string_to_send,"%s|%s|%s|%s|%s|%s|%s|%s|%d|%s|%s|f1|f2|<EOR>",xwota_settings.call,frequency_entry,xwota_settings.country,xwota_settings.state,xwota_settings.grid,xwota_settings.county,xwota_settings.latitude,xwota_settings.longitude,wota_status,comment_entry,program_name);
//printf("%s\n",string_to_send);
tx(readchan,string_to_send);
		
}

void
on_wota_server_activate                (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
	wota_server_window=create_wota_server_window();
	gtk_widget_show(wota_server_window);
	
	load_preferences();

	GtkWidget* server = lookup_widget(GTK_WIDGET(wota_server_window),"server");
	GtkWidget* port = lookup_widget(GTK_WIDGET(wota_server_window),"port");
	gtk_entry_set_text (GTK_ENTRY (server), xwota_settings.server_wotadb);
    gtk_entry_set_text (GTK_ENTRY (port),xwota_settings.port);
	gtk_widget_set_sensitive(wota_server,FALSE);
}


void
on_cancel_wota_server_clicked          (GtkButton       *button,
                                        gpointer         user_data)
{
	gtk_widget_destroy(wota_server_window);
gtk_widget_set_sensitive(wota_server,TRUE);
}


void
on_save_wota_server_clicked            (GtkButton       *button,
                                        gpointer         user_data)
{
	gchar *server, *port;
	
	GtkWidget * server_name = lookup_widget(GTK_WIDGET(button),"server");
	GtkWidget * port_num = lookup_widget(GTK_WIDGET(button),"port");
//	printf("Saving server settings...\n");
	
	server = gtk_entry_get_text(GTK_ENTRY(server_name));
	port =gtk_entry_get_text(GTK_ENTRY(port_num));
	
	//printf("Server name : %s - %s\n",server_name,port_num);
	xwota_settings.server_wotadb = g_strdup(server);
	xwota_settings.port = g_strdup(port);
	save_preferences();
	gtk_widget_destroy(wota_server_window);
	gtk_widget_set_sensitive(wota_server,TRUE);
}


void
on_clear_station_info_clicked          (GtkButton       *button,
                                        gpointer         user_data)
{

	gtk_widget_destroy(station_info_window);
	gtk_widget_set_sensitive(station_info,TRUE);
}

// SAVE SETTINGS
void
on_save_station_info_clicked           (GtkButton       *button,
                                        gpointer         user_data)
{
	gchar *call_,*country_,*state_,*grid_,*county_,*lat_,*longitude_;
	
	GtkWidget* call = lookup_widget(GTK_WIDGET(button),"call");
	GtkWidget* country = lookup_widget(GTK_WIDGET(button),"country");
	GtkWidget* state = lookup_widget(GTK_WIDGET(button),"state");
	GtkWidget* grid = lookup_widget(GTK_WIDGET(button),"grid");
	GtkWidget* county = lookup_widget(GTK_WIDGET(button),"county");
	GtkWidget* lat = lookup_widget(GTK_WIDGET(button),"lat");
	GtkWidget* longitude = lookup_widget(GTK_WIDGET(button),"longitude");
	
//	printf("Saving station info...\n");
	call_ = gtk_entry_get_text(GTK_ENTRY(call));
	country_ = gtk_entry_get_text(GTK_ENTRY(country));
	state_ = gtk_entry_get_text(GTK_ENTRY(state));
	grid_ = gtk_entry_get_text(GTK_ENTRY(grid));
	county_ = gtk_entry_get_text(GTK_ENTRY(county));
	lat_ = gtk_entry_get_text(GTK_ENTRY(lat));
	longitude_ = gtk_entry_get_text(GTK_ENTRY(longitude));
	
	call_ = uppercase(call_);
	state_ = uppercase(state_);
	grid_ = uppercase(grid_);	
	
		
	//printf("Call: %s\n%s\n%s\n%s\n%s\n%s\n%s\n",call,country,state,grid,county,lat, longitude);
	
	xwota_settings.call = g_strdup(call_);
	xwota_settings.country = g_strdup(country_);
	xwota_settings.state = g_strdup(state_);
	xwota_settings.grid = g_strdup(grid_);
	xwota_settings.county = g_strdup(county_);
	xwota_settings.latitude = g_strdup(lat_);
	xwota_settings.longitude = g_strdup(longitude_);
		
	save_preferences();
	
	gtk_widget_destroy(station_info_window);
	gtk_widget_set_sensitive(station_info,TRUE);
}

void
on_preferences_activate                (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
	
	preferences_window=create_preferences_window();
	gtk_widget_show(preferences_window);

	load_preferences();
	
	GtkWidget * default_freq = lookup_widget(GTK_WIDGET(preferences_window),"default_freq");
	GtkWidget * default_comment = lookup_widget(GTK_WIDGET(preferences_window),"default_comment");
	
		
	gtk_entry_set_text (GTK_ENTRY (default_freq), xwota_settings.freq);
    gtk_entry_set_text (GTK_ENTRY (default_comment),xwota_settings.comments);

	gtk_widget_set_sensitive(preferences,FALSE);
}




void
on_clear_preferences_button_clicked    (GtkButton       *button,
                                        gpointer         user_data)
{
gtk_widget_destroy(preferences_window);
	gtk_widget_set_sensitive(preferences,TRUE);
	
}


void
on_save_preferences_button_clicked     (GtkButton       *button,
                                        gpointer         user_data)
{
gchar *default_freq_,*default_comment_;
	
	GtkWidget * default_freq = lookup_widget(GTK_WIDGET(button),"default_freq");
	GtkWidget * default_comment = lookup_widget(GTK_WIDGET(button),"default_comment");

	
	
	default_freq_ = gtk_entry_get_text(GTK_ENTRY(default_freq));
	default_comment_ =gtk_entry_get_text(GTK_ENTRY(default_comment));
	
	//printf("Server name : %s - %s\n",server_name,port_num);
	xwota_settings.freq = g_strdup(default_freq_);
	xwota_settings.comments = g_strdup(default_comment_);
	gtk_entry_set_text(GTK_ENTRY(frequency),xwota_settings.freq);
	
	 gtk_entry_set_text(GTK_ENTRY(comment),xwota_settings.comments);

	save_preferences();
	
	gtk_widget_destroy(preferences_window);
	gtk_widget_set_sensitive(preferences,TRUE);
	
}

void
on_connect_activate                    (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
	int connection_result;
	GtkWidget *xwota =  lookup_widget(GTK_WIDGET(menuitem),"xwota");
	gtk_widget_set_sensitive(xwota,FALSE);
	connection_result =	init_network();
	
	if (connection_result == 1) {
	gtk_widget_set_sensitive(xwota,TRUE);
	GtkWidget *connect =  lookup_widget(GTK_WIDGET(menuitem),"connect");
	gtk_widget_set_sensitive(connect,FALSE);
	GtkWidget *disconnect =  lookup_widget(GTK_WIDGET(menuitem),"disconnect");
	gtk_widget_set_sensitive(disconnect,TRUE);
		write_statusbar("Connected");
		write_message_statusbar("Connected");
		connection_status = 1;
		upload_event_id= g_timeout_add(3000000,automatic_upload,NULL);
		check_freq_event_id = g_timeout_add(5000,check_freq,NULL);
		
	//printf("Upload event id: %d Check freq id %d\n",upload_event_id,check_freq_event_id);
		}
	 else  {
	gtk_widget_set_sensitive(xwota,TRUE);
	GtkWidget *connect =  lookup_widget(GTK_WIDGET(menuitem),"connect");
	gtk_widget_set_sensitive(connect,TRUE);
	GtkWidget *disconnect =  lookup_widget(GTK_WIDGET(menuitem),"disconnect");
	gtk_widget_set_sensitive(disconnect,FALSE); 
		write_statusbar("Connection failed to the server");
connection_status = 0;	
		 
		 }
	
	}


void
on_disconnect_activate                 (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
	
	
	disconnect_network(sockfd,readchan);
	GtkWidget *connect =  lookup_widget(GTK_WIDGET(menuitem),"connect");
	gtk_widget_set_sensitive(connect,TRUE);
	GtkWidget *disconnect =  lookup_widget(GTK_WIDGET(menuitem),"disconnect");
	gtk_widget_set_sensitive(disconnect,FALSE);
	write_statusbar("Disconnected");
	connection_status = 0;
}


void
on_spot_activate                       (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
	
	// Qui disabilitare il menù spot.
	gtk_widget_set_sensitive(spot,FALSE);
	//
	gtk_widget_show(spot_window);
	
	
}




void
on_hide_spot_window_activate           (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
	
	
	gtk_widget_set_sensitive(spot,TRUE);
	gtk_widget_hide(spot_window);

	}

gboolean
on_spot_window_delete_event            (GtkWidget       *widget,
                                        GdkEvent        *event,
                                        gpointer         user_data)
{

  gtk_widget_set_sensitive(spot,TRUE);
	gtk_widget_hide(spot_window);
  return TRUE;
}

void
on_close_manual_clicked                (GtkButton       *button,
                                        gpointer         user_data)
{
gtk_widget_destroy(manual);
}

gboolean
on_wota_server_window_delete_event     (GtkWidget       *widget,
                                        GdkEvent        *event,
                                        gpointer         user_data)
{
gtk_widget_set_sensitive(wota_server,TRUE);
	gtk_widget_hide(wota_server_window);
  return TRUE;
  
}


gboolean
on_station_info_window_delete_event    (GtkWidget       *widget,
                                        GdkEvent        *event,
                                        gpointer         user_data)
{
gtk_widget_set_sensitive(station_info,TRUE);
	gtk_widget_hide(station_info_window);
  return TRUE;
  
}


gboolean
on_preferences_window_delete_event     (GtkWidget       *widget,
                                        GdkEvent        *event,
                                        gpointer         user_data)
{
gtk_widget_set_sensitive(preferences,TRUE);
	gtk_widget_hide(preferences_window);
  return TRUE;

}

gboolean
on_xwota_delete_event                  (GtkWidget       *widget,
                                        GdkEvent        *event,
                                        gpointer         user_data)
{
if (connection_status == 1) {
	disconnect_network(sockfd,readchan);
}
	
	gtk_main_quit();
}


void
on_messages_activate                   (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{

	gtk_widget_show(messages_window);
	gtk_widget_set_sensitive(messages,FALSE);
//write_message_statusbar("Ready.");
}

gboolean
on_messages_window_delete_event        (GtkWidget       *widget,
                                        GdkEvent        *event,
                                        gpointer         user_data)
{
	
gtk_widget_set_sensitive(messages,TRUE);
	gtk_widget_hide(messages_window);
  return TRUE;
  
}


void
on_quit_messages_activate              (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
	
gtk_widget_set_sensitive(messages,TRUE);
	gtk_widget_hide(messages_window);	

	
}


void
on_send_msg_button_clicked             (GtkButton       *button,
                                        gpointer         user_data)
{
gchar *get_send_to,*get_message_text;
gchar string_to_send[1000];
	
// Sono connesso ?
	if(connection_status != 1 ) {
		write_message_statusbar("Cannot send message. You are not connected.");
	return;
	}
	
	load_preferences();
	//printf("Send message cliked.\n");
	 GtkWidget* send_to = lookup_widget(GTK_WIDGET(button),"send_to");
	 GtkWidget* message_text = lookup_widget(GTK_WIDGET(button),"message_text");
	
	
	get_send_to= gtk_entry_get_text(GTK_ENTRY(send_to));
	get_message_text = gtk_entry_get_text(GTK_ENTRY(message_text));
	
	if((strcmp(get_send_to,"") == 0) || (strcmp(get_message_text,"") == 0))  {
	//printf("Missing message info.\n");
		write_message_statusbar("Cannot send message. Fill all fields please.");
		return;	
		}
	get_send_to = uppercase(get_send_to);
	
	//printf("From: %s - To: %s - Text: %s\n",xwota_settings.call,get_send_to,get_message_text);
	
	// :MSENDTO|This is the message|FROM|<EOR>
	
	sprintf(string_to_send,":M%s|%s|%s|<EOR>",get_send_to,get_message_text,xwota_settings.call);

	//printf("%s\n",string_to_send);	
	tx(readchan,string_to_send);
	gtk_entry_set_text(GTK_ENTRY(message_text),"");
	write_message_statusbar("Sent.");
	decode_text_message(string_to_send);
	
}



void
on_action_messages_activate            (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{

}


void
on_clear_messages_activate             (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
printf("Clear message not implemented yet.\n");
}

// Se clikko enter nella entry del messaggio di testo
void
on_message_text_activate               (GtkEntry        *entry,
                                        gpointer         user_data)
{

	GtkWidget *send_msg_button = lookup_widget(GTK_WIDGET(messages_window),"send_to");
	on_send_msg_button_clicked (send_msg_button,NULL);
	
}

void message_selected (GtkTreeSelection *msg_selection, gpointer user_data) {
GtkTreeIter iter;
GtkTreeStore *store_message;
gchar *get_sent_from, *get_sent_to;
	
	//printf("Message selected\n");
	
	
	 if (gtk_tree_selection_get_selected (msg_selection, &store_message, &iter))
        {
                gtk_tree_model_get (store_message, &iter, MSG_FROM_COLUMN, &get_sent_from, -1);
				gtk_tree_model_get (store_message, &iter, MSG_TO_COLUMN, &get_sent_to, -1);
			
		
			GtkWidget *messages_list = lookup_widget(GTK_WIDGET(messages_window),"messages_list");
			gtk_tree_selection_unselect_all (gtk_tree_view_get_selection(GTK_TREE_VIEW (messages_list)));
	
			GtkWidget *send_to = lookup_widget(GTK_WIDGET(messages_window),"send_to");
			
			//get_sent_from = uppercase
			//printf("From: %s - To: %s\n",get_sent_from, get_sent_to);
			
			if(strcmp(xwota_settings.call,get_sent_from) == 0) {
				gtk_entry_set_text(GTK_ENTRY(send_to),get_sent_to);
			}
			
			else {
			gtk_entry_set_text(GTK_ENTRY(send_to),get_sent_from);
			}
		}
		
	
}
