'\" t
.\" Manual page created with latex2man on Tue  9 May 09:45:30 CEST 2017
.\" NOTE: This file is generated, DO NOT EDIT.
.de Vb
.ft CW
.nf
..
.de Ve
.ft R

.fi
..
.TH "YADIFAD\-CONF" "5" "P018\-02\-12" "YADIFA " "YADIFA "
.SH NAME

.PP
yadifad.conf
\- configuration file for \fIyadifad\fP(8)\&.
.PP
.SH SYNOPSIS

.PP
${PREFIX}/etc/yadifad.conf 
.PP
.SH DESCRIPTION

.PP
The configuration of yadifad
has several containers: 
.TP
\fB<main>\fP
 General container 
.TP
<key> 
TSIG keys 
.TP
<acl> 
Access lists 
.TP
<nsid> 
NameServer IDentifier 
.TP
<rrl> 
Response Rate Limiting directives 
.TP
<zone> 
Description of the domain name in specific attributes. 
.TP
<channels> 
Description of the logger outputs. 
.TP
<dnssec\-policy> 
Description of dnssec policies. 
.TP
<key\-suite> 
Description of the key\-suites needed if \&'dnssec policies\&' are used. 
.TP
<key\-roll> 
Description of the key\-rolls needed if \&'dnssec policies\&' are used. 
.TP
<key\-template> 
Description of the key\-templates needed if \&'dnssec policies\&' are used. 
.TP
<denial> 
Description of \&'denial\&', this can be used in certain \&'dnssec policies\&'\&. 
.PP
The configuration supports included files.
.br
example: include /etc/yadifa/conf.d/local.conf 
.PP
The configuration files can be nested. 
.PP
The configuration consists of: 
.TP
.B *
Container, which starts with <container name> and ends with </container name> 
.TP
.B *
Variable name 
.TP
.B *
1 or 2 arguments 
.TP
.B *
Arguments can contain 1 or more comma separated values. 
.PP
eg. 
.PP
.Vb
<container>
    # variable  argument
    variable    value1  
    # variable  argument1       argument2
    variable    value1          value2
    # variable  argument1
    variable    value1,value2
</container>
.Ve
.PP
.SH EXAMPLES

.PP
Examples of containers defined for a configuration file. 
.PP
.TP
.B *
Main 
.RS
.TP
1.
Config with includes 
.RS
.PP
.Vb
# start yadifad.conf <main> container
include /etc/yadifa/conf.d/local.conf
# end yadifad.conf <main> container
.Ve
.PP
.RE
.TP
2.
Main without includes 
.RS
.PP
.Vb
<main>
    # Detach from the console (alias: daemonize)
    daemon                  off

    # Jail the application
    chroot                  off

    # The path of the log files (alias: chroot\-path)
    chrootpath              "/chroot/yadifad"

    # The path of the log files (alias: log\-path)
    logpath                 "/var/log/yadifa"

    # The location of the pid file (alias: pid\-file)
    pidfile                 "/var/run/yadifa/yadifad.pid"

    # The path of the zone files (alias: data\-path)
    datapath                "/var/lib/yadifa"

    # The path of the DNSSEC keys (alias: keys\-path)
    keyspath                "/var/lib/yadifa/keys"

    # The path of the transfer and journaling files (AXFR & IXFR) (alias: xfr\-path)
    xfrpath                 "/var/lib/yadifa/xfr"

    # A string returned by a query of hostname. CH TXT 
    # note: if you leave this out, the real hostname will be given back (alias: hostname\-chaos)
    hostname                "server\-yadifad"

    # An ID returned by a query to id.server. CH TXT (alias: serverid\-chaos)
    serverid                "yadifad\-01"

    # The version returned by a query to version.yadifa. CH TXT (alias: version\-chaos)
    version                 "2.3.9"

    # Set the maximum UDP packet size.  
    # note: the packetsize cannot be less than 512 or more than 65535.
    #       Typical choice is 4096.
    edns0\-max\-size          4096

    # The maximum number of parallel TCP queries (max\-tcp\-connections)
    max\-tcp\-queries         100

    # The minimum data rate for a TCP query (in bytes per second)
    tcp\-query\-min\-rate      512

    # The user id to use (alias: user)
    uid                     yadifa

    # The group id to use (alias: group)
    gid                     yadifa

    # The DNS port \- any DNS query will use that port unless a specific value is used (alias: server\-port)
    port                    53

    # The interfaces to listen to.
    # listen        0.0.0.0
    listen                  127.0.0.1, 192.0.2.2, 192.0.2.130 port 8053, 2001:db8::2

    # Type of querylog to use
    #   0: none
    #   1: yadifa
    #   2: bind
    #   3: both yadifa and bind
    queries\-log\-type        1

    # Enable the collection and logging of statistics
    statistics              on

    # Maximum number of seconds between two statistics lines
    statistics\-max\-period   60

    # Drop queries with erroneous content
    #
    # answer\-formerr\-packets on
    answer\-formerr\-packets  off

    # Maximum number of records in an AXFR packet. Set to 1 for compatibility
    # with very old name servers (alias: axfr\-max\-record\-by\-packet)
    axfr\-maxrecordbypacket  0

    # Global Access Control rules
    #
    # Rules can be defined on network ranges, TSIG signatures, and ACL rules

    # simple queries:
    #
    # allow\-query any
    allow\-query             !192.0.2.251,any

    # dynamic update of a zone
    #
    # allow\-update none
    allow\-update            admins

    # dynamic update of a slave (forwarded to the master)
    #
    # allow\-update\-forwarding   none
    allow\-update\-forwarding admins,key abroad\-admin\-key

    # transfer of a zone (AXFR or IXFR)
    #
    # allow\-transfer any
    allow\-transfer          transferer

    # notify of a change in the master
    #
    # allow\-notify any
    allow\-notify            master,admins

    # If YADIFA has the controller enabled, allow control only for these
    # clients (none by default)
    allow\-control           localhost

    # overwrite the amount of CPUs detected by yadifad
    cpu\-count\-override 3

    # set the number of threads to serve queries
    thread\-count\-by\-address 2

</main>
.Ve
.RE
.RE
.PP
.RE
.TP
.B *
Key
.br 
TSIG\-key configuration
.br
.PP
.RS
.TP
1.
Admin\-key key definition (the name is arbitrary) 
.RS
.PP
.Vb
<key>
    name        abroad\-admin\-key
    algorithm   hmac\-md5
    secret      WorthlessKeyForExample==
</key>
.Ve
.PP
.RE
.TP
2.
Master\-slave key definition 
.RS
.PP
.Vb
<key>
    name        master\-slave
    algorithm   hmac\-md5
    secret      MasterAndSlavesTSIGKey==
</key>
.Ve
.RE
.RE
.PP
.RE
.TP
.B *
ACL
.br 
Access Control List definitions
.br
.PP
.RS
.TP
1.
Master\-slave key use 
.RS
.PP
.Vb
<acl>
    transferer  key master\-slave
    admins      192.0.2.0/24, 2001:db8::74
    master      192.0.2.53
    localhost   127.0.0.0/8, ::1
</acl>
.Ve
.PP
.RE
.RE
.PP
.RE
.TP
.B *
NSID
.br 
DNS NameServer IDentifier
.br
.PP
.RS
.TP
1.
Example with ascii 
.RS
.PP
.Vb
<nsid>
    ascii belgium\-brussels\-01
</nsid>
.Ve
.PP
.RE
.TP
2.
Example with hex 
.RS
.PP
.Vb
<nsid>
    hex 00320201
</nsid>
.Ve
.RE
.RE
.PP
.RE
.TP
.B *
RRL
.br 
Response Rate Limiting 
.PP
.Vb
<rrl>
    # Number of identical responses per second before responses are being limited
    responses\-per\-second    5

    # Number of errors per second before responses are being limited
    errors\-per\-second       5

    # Random slip parameter
    slip                    10

    # If enabled, the rate limits are only logged and not enforced
    log\-only                off

    # Mask applied to group the IPv4 clients
    ipv4\-prefix\-length      24

    # Mask applied to group the IPv6 clients
    ipv6\-prefix\-length      56

    # Rate limits are not subject to the following clients (aka whitelist)
    exempt\-clients          none

    # Enable or disable the rate limit capabilities
    enabled                 yes
</rrl>
.Ve
.PP
.TP
.B *
Zone 
.PP
.RS
.TP
1.
Master domain zone config 
.RS
.PP
.Vb
<zone>
    # This server is master for the zone (mandatory)
    type            master

    # The domain name (mandatory)
    domain          mydomain.eu

    # The zone file, relative to 'datapath'  (mandatory for a master) (alias: file\-name)
    file            master/mydomain.eu

    # List of servers also notified of a change (beside the ones in the zone file) (alias: notifies, notify)
    also\-notify     192.0.2.84, 192.0.2.149

    # Set the size of the journal file in KB (alias: journal\-size\-kb)
    journal\-size    8192 

    # Allow dynupdate for these ACL entries
    allow\-update    admins

    # Allow AXFR/IXFR for these ACL entries
    allow\-transfer  transferer

    # Use DNSSEC policies otherwise remove or put in remark line below
    dnssec\-policy   1
</zone>
.Ve
.PP
.RE
.TP
2.
Slave domain zone config 
.RS
.PP
.Vb
<zone>
    # This server is slave for that zone (mandatory)
    type            slave

    # The domain name (mandatory)
    domain          myotherdomain.eu

    # The address of the master (mandatory for a slave, forbidden for a master) (alias: master)
    masters         191.0.2.53 port 4053 key master\-slave

    # The zone file, relative to 'datapath'.
    file            slaves/myotherdomain.eu

    # Accept notifes from these ACL entries
    allow\-notify    master
</zone>
.Ve
.PP
.RE
.RE
.PP
.RE
.TP
.B *
DNSSEC\-Policy 
.PP
DNSSEC\-Policy needs some extra sections: key\-suite, key\-roll, key\-template (and denial if NSEC3 is configured) 
.PP
.RS
.TP
1.
dnssec\-policy example with all the needed sections 
.RS
.PP
example with NSEC3 
.Vb
<dnssec\-policy>
    id              "1"

    description     "Example of ZSK and KSK"
    denial          "nsec3\-with\-salt\-on"
    key\-suite       "zsk\-1024"
    key\-suite       "ksk\-2048"
</dnssec\-policy>
.Ve
example with NSEC 
.Vb
<dnssec\-policy>
    id              "2"

    description     "Example of ZSK and KSK"
    denial          nsec
    key\-suite       "zsk\-1024"
    key\-suite       "ksk\-2048"
</dnssec\-policy>
.Ve
.PP
.RE
.TP
2.
key\-suite 
.Vb
<key\-suite>                     
    id              "ksk\-2048"

    key\-template    "ksk\-2048"
    key\-roll        "key\-roll\-ksk\-2048\-short\-times"
</key\-suite>                            

<key\-suite>                     
    id              "zsk\-1024"

    key\-template    "zsk\-1024"
    key\-roll        "key\-roll\-zsk\-1024\-short\-times"
</key\-suite>                            
.Ve
.TP
3.
key\-roll 
.Vb
<key\-roll>      
    id              "key\-roll\-ksk\-2048\-short\-times"

#   command         minutes    hours      day        month      day\-week   week
    generate        5,35       *          *          *          *          *
    publish         6,36       *          *          *          *          *
    activate        7,37       *          *          *          *          *
    inactive        8,38       *          *          *          *          * 
    remove          12,42      *          *          *          *          *
</key\-roll>     

<key\-roll>      
    id              "key\-roll\-zsk\-1024\-short\-times"

#   command         minutes    hours      day        month      day\-week   week
    generate        5,35       *          *          *          *          *
    publish         6,36       *          *          *          *          *
    activate        7,37       *          *          *          *          *
    inactive        8,38       *          *          *          *          * 
    remove          12,42      *          *          *          *          *
</key\-roll>     
.Ve
.TP
4.
key\-template 
.Vb
<key\-template>
    id              "ksk\-2048"

    ksk             true
    algorithm       8
    size            2048
</key\-template>

<key\-template>
    id              "zsk\-1024"

    ksk             false
    algorithm       8
    size            1024
</key\-template>
.Ve
.TP
5.
denial 
.Vb
<denial>                
    id              "nsec3\-with\-salt\-on"

    salt            "ABCD"
    algorithm       1
    iterations      5
    optout          off             
</denial>                               
.Ve
.RS
.PP
.Vb
<denial>                
    id              "nsec3\-with\-salt\-length\-on"

    salt\-length     4
    algorithm       1
    iterations      5
    optout          off             
</denial>                               
.Ve
.PP
.RE
.RE
.PP
.RE
.TP
.B *
Channels 
.PP
Logging output\-channel configurations: 
.PP
The "name" is arbitrary and is used in the <loggers>.
.br
The "stream\-name" defines the output type (ie: a file name or syslog).
.br
The "arguments" are specific to the output type (ie: unix file access rights or syslog options and facilities).
.br
.PP
.RS
.RS
.PP
.RE
.TP
1.
Example: YADIFA running as daemon channel definition.
.br 
.RS
.PP
.Vb
<channels>
#   name        stream\-name     arguments
    database    database.log    0644
    dnssec      dnssec.log      0644
    server      server.log      0644
    statistics  statistics.log  0644
    system      system.log      0644
    queries     queries.log     0644
    zone        zone.log        0644
    all         all.log         0644

    syslog      syslog          user
</channels>
.Ve
.PP
.RE
.TP
2.
Example: YADIFA running in debug mode.
.br 
This example shows the "stderr" and "stdout" which can also be used in the first example, but will output to the console. 
.RS
.PP
.Vb
<channels>
#   name        stream\-name     arguments
    syslog      syslog          user

    stderr      STDERR
    stdout      STDOUT
</channels>
.Ve
.PP
.RE
.RE
.PP
.RE
.TP
.B *
Loggers 
.PP
Logging input configurations: 
.PP
The "bundle" is the name of the section of YADIDA being logged, sources are : database, dnssec, queries, server, stats, system, zone.
.br
The "debuglevel" uses the same names as syslog or "*" or "all" to filter the input.
.br
.PP
The "channels" are a comma\-separated list of channels. 
.PP
.RS
.TP
1.
Example without syslog 
.RS
.PP
.Vb
<loggers>
#   bundle          debuglevel                          channels
    database        ALL                                 database,all
    dnssec          warning                             dnssec,all
    server          INFO,WARNING,ERR,CRIT,ALERT,EMERG   server,all
    stats           prod                                statistics
    system          *                                   system,all
    queries         *                                   queries
    zone            *                                   zone,all
</loggers>
.Ve
.PP
.RE
.TP
2.
Example with syslog 
.RS
.PP
.Vb
<loggers>
#   bundle          debuglevel                          channels
    database        ALL                                 database,syslog
    dnssec          warning                             dnssec,syslog
    server          INFO,WARNING,ERR,CRIT,ALERT,EMERG   server,syslog
    stats           prod                                statistics, syslog
    system          *                                   system,syslog
    queries         *                                   queries,syslog
    zone            *                                   zone,syslog
</loggers>
.Ve
.RE
.RE
.PP
The defined loggers are: 
.PP
.RS
.RE
.TP
system 
contains low level messages about the system such as memory allocation, threading, IOs, timers and cryptography, \&.\&.\&. 
.TP
database 
It contains messages about most lower\-level operations in the DNS database. ie: journal, updates, zone loading and sanitization, DNS message query resolution, \&.\&.\&.) 
.TP
dnssec 
contains messages about lower\-level dnssec operations in the DNS database. ie: status, maintenance, verification, \&.\&.\&. 
.TP
server 
contains messages about operations in the DNS server. ie: start up, shutdown, configuration, transfers, various services status (database management, network management, DNS notification management, dynamic update management, resource rate limiting, \&.\&.\&.) 
.TP
zone 
contains messages about the loading of a zone from a source (file parsing, transferred binary zone reading, \&.\&.\&.) 
.TP
stats 
contains the statistics of the server. 
.TP
queries 
contains the queries on the server. 
Queries can be logged with the BIND and/or with the YADIFA format.
.br
.br
\fBBIND format:\fP
.br
.br
client sender\-ip#port: query: fqdn class type +SETDC (listen\-ip)
.br
.br
\fBYADIFA format:\fP
.br
.br
query [ id ] {+SETDC} fqdn class type (sender\-ip#port)
.br 
.br
where: 
.RS
.TP
id 
is the query message id 
.TP
+ 
means the message has the Recursion Desired flag set 
.TP
S 
means the message is signed with a TSIG 
.TP
E 
means the message is EDNS 
.TP
T 
means the message was sent using TCP instead of UDP 
.TP
D 
means the message has the DNSSEC OK flag set 
.TP
C 
means the message has the Checking Disabled flag set 
.TP
fqdn 
is the queried FQDN 
.TP
class 
is the queried class 
.TP
type 
is the queried type 
.TP
sender\-ip 
is the IP of the client that sent the query 
.TP
port 
is the port of the client that sent the query 
.TP
listen\-ip 
is the listen network interface that received the message 
.RE
.RS
.PP
Note that on YADIFA any unset flag is replaced by a \&'\-\&', on BIND only the \&'+\&' follows that rule. 
.RE
.RE
.PP
System operators will mostly be interested in the info and above messages of queries and stats, as well as the error and above messages of the other loggers. 
.PP
.RE
.PP
.SH SEE ALSO

.PP
\fIyadifad\fP(8)
.PP
.SH NOTES

.PP
Since unquoted leading whitespace is generally ignored in the yadifad.conf
you can indent everything to taste. 
.PP
.SH CHANGES

.PP
Please check the file ChangeLog
from the sources. 
.PP
.SH VERSION

.PP
Version: 2.3.9 of 2019\-02\-11 \&.
.PP
.SH MAILING LISTS

.PP
There exists a mailinglist for questions relating to any program in the yadifa package:
.br
.RE
.TP
.B *
\fByadifa\-users@mailinglists.yadifa.eu\fP
.br
for submitting questions/answers. 
.PP
.TP
.B *
\fBhttp://www.yadifa.eu/mailing\-list\-users\fP
.br
for subscription requests. 
.PP
If you would like to stay informed about new versions and official patches send a subscription request to 
via: 
.TP
.B *
\fBhttp://www.yadifa.eu/mailing\-list\-announcements\fP
.PP
(this is a readonly list). 
.PP
.SH LICENSE AND COPYRIGHT

.PP
.TP
Copyright 
(C)2011\-2018, EURid
.br
B\-1831 Diegem, Belgium
.br
\fBinfo@yadifa.eu\fP
.PP
.SH AUTHORS

.PP
Gery Van Emelen 
.br
Email: \fBGery.VanEmelen@EURid.eu\fP
.br
Eric Diaz Fernandez 
.br
Email: \fBEric.DiazFernandez@EURid.eu\fP
.PP
WWW: \fBhttp://www.EURid.eu\fP
.PP
.\" NOTE: This file is generated, DO NOT EDIT.
