//---------------------------------------------------------------------------
// Targa image loader
//---------------------------------------------------------------------------
#ifndef __TARGAIO_H
#define __TARGAIO_H

#include <stdio.h>
#include <string>
#include "color.h"
#include "buffer.h"
#include "output.h"

#ifdef HAVE_CONFIG_H
#include<config.h>
#endif

__BEGIN_YAFRAY

class targaImg_t
{
public:
  // ctor
  targaImg_t()
  {
    alpha_bits=0;  byte_per_pix=0;
    has_alpha=false;  isgray=false;
    IS_CMAP = false;
    imgdata = NULL;
    COLMAP = NULL;
    fp = NULL;
  }
  // dtor
  ~targaImg_t()
  {
    if (imgdata) {
      delete imgdata;
      imgdata = NULL;
    }
    if (COLMAP) {
      delete[] COLMAP;
      COLMAP = NULL;
    }
    if (fp) fclose(fp);
  }
  // mtds
  bool Load(const char *fname);
  gBuf_t<unsigned char, 4> * imageData() { return imgdata; }
  unsigned short getWidth() const { return width; }
  unsigned short getHeight() const { return height; }
  color_t operator() (int x, int y) const;
  std::string getErrorString() { return err_str; }
private:
  FILE *fp;
  std::string err_str;
  unsigned char alpha_bits, byte_per_pix;
  bool has_alpha, isgray, IS_CMAP;
  unsigned short width, height;
  gBuf_t<unsigned char, 4> *imgdata;
  unsigned char *COLMAP; //possible colormap
  unsigned char R, G, B, A;
  enum {TGA_NO_DATA=0, TGA_UNC_CMAP, TGA_UNC_TRUE, TGA_UNC_GRAY,
        TGA_RLE_CMAP=9, TGA_RLE_TRUE, TGA_RLE_GRAY} TGA_TYPE;
  void getColor(unsigned char* scan=NULL );
  bool readError();
};

//---------------------------------------------------------------------------
// buffer save


class outTga_t : public colorOutput_t
{
	public:
		outTga_t(int resx, int resy, const char *fname, bool sv_alpha=false)
		{
			unsigned int tsz = resx*resy;
			data = new unsigned char[tsz*3];
			if (data==NULL) {
				std::cout <<"Fatal error allocating memory in outTga_t\n";
				exit(1);
			}
			sizex = resx;
			sizey = resy;
			outfile = fname;

			alpha_buf = NULL;
			save_alpha = sv_alpha;
			if (save_alpha) {
				alpha_buf = new unsigned char[tsz];
				if (!alpha_buf) {
					std::cout << "Could not allocate memory for alpha buffer in outTga_t\n";
					exit(1);
				}
			}
		}
		virtual void putPixel(int x, int y, const color_t &c, CFLOAT alpha=0)
		{
			unsigned int yx = sizex*y + x;
			(data+yx*3) << c;
			if (save_alpha)
				alpha_buf[yx] = (unsigned char)(255.0*((alpha<0)?0:((alpha>1)?1:alpha)));
		}
		void flush() { savetga(outfile.c_str()); }
		virtual ~outTga_t()
		{
			if (data) {
			  delete[] data;
			  data = NULL;
			}
			if (alpha_buf) {
			  delete[] alpha_buf;
			  alpha_buf = NULL;
			}
		}
		int RX() { return sizex; };
		int RY() { return sizey; };
		void *DD() { return dd; };
		void *DR() { return dr; };
	protected:
		bool savetga(const char* filename);
		bool save_alpha;
		unsigned char *data;
		unsigned char *alpha_buf;
		int sizex,sizey;
		void *dd,*dr;
		std::string outfile;
};

__END_YAFRAY

//---------------------------------------------------------------------------
#endif //__TARGAIO_H
