#ifndef __CCTHREADS_H
#define __CCTHREADS_H

#ifdef HAVE_CONFIG_H
#include<config.h>
#endif

#if HAVE_PTHREAD
#include<pthread.h>
#include<semaphore.h>
#endif

class YAFRAYCORE_EXPORT mutex_t
{
	public:
		mutex_t();
		void wait();
		void signal();
		~mutex_t();
	protected:
#if HAVE_PTHREAD
		pthread_mutex_t m;
#endif
};

template<class T>
class YAFRAYCORE_EXPORT locked_t : public T
{
  public:
    void wait() 
		{
#if HAVE_PTHREAD
			mutex.wait();
#endif
		};
    void signal() 
		{
#if HAVE_PTHREAD
			mutex.signal();
#endif
		};
  protected:
#if HAVE_PTHREAD
    mutex_t mutex;
#endif
};
                                                                                                                
#if HAVE_PTHREAD
                                                                                                                
class YAFRAYCORE_EXPORT mysemaphore_t
{
  public:
    mysemaphore_t(int c=0) {sem_init (&s,0,c);};
    ~mysemaphore_t() {sem_destroy (&s);};
    void wait() {sem_wait(&s);};
    void signal() {sem_post(&s);};
  protected:
    sem_t s;
};
#endif

#endif
