#!perl -w
#
# OpenFirmwareTab -- encapsulate modules.ofmap
#   this file is based on PciTab which is
#   Copyright (C) 2005  Erik van Konijnenburg
#   changed for OpenFirmware by Bernhard R. Link in 2006
#
#   This program is free software; you can redistribute it and/or modify
#   it under the terms of the GNU General Public License as published by
#   the Free Software Foundation; either version 2 of the License, or
#   (at your option) any later version.
#
#   This program is distributed in the hope that it will be useful,
#   but WITHOUT ANY WARRANTY; without even the implied warranty of
#   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#   GNU General Public License for more details.
#
#   You should have received a copy of the GNU General Public License
#   along with this program; if not, write to the Free Software
#   Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301 USA
#

use strict;
use warnings;
use Base;
use Conf;
use OpenFirmwareMapEntry;
package OpenFirmwareTab;

my $ofList = undef;

# Parse this:
# # of module          name                 type                 compatible
# esp                  SUNW,esp             *                    *
# esp                  SUNW,fas             *                    *
# esp                  esp                  *                    *
# parport_sunbpp       SUNW,bpp             *                    *

sub init () {
	if (defined ($ofList)) {
		return;
	}
	$ofList = [];
	my $name = Conf::get('ofMap');
	if (! open (IN, "<", "$name")) {
		Base::warning ("can't open of module list $name");
		return;		
	}
	while (defined (my $line = <IN>)) {
		chomp $line;
		$line =~ s/#.*//;
		$line =~ s/^\s+//;
		$line =~ s/\s+$//;
		next if ($line eq "");
		my @fields = split (/\s+/, $line, 999);
		if ($#fields != 3) {
			Base::fatal "malformed line in of module list $name";
		}
		push @{$ofList}, OpenFirmwareMapEntry->new (
			module => $fields[0],
			name => $fields[1],
			type => $fields[2],
			compatible => $fields[3],
			);
	}
	if (! close (IN)) {
		Base::fatal "could not read of module list $name";
	}
}

sub all	() {
	init;
	return $ofList;
}

# given pathname in devices tree, find module name in OF map as a list.
sub find ($) {
	my ($dev) = @_;
	my @result = ();
	for my $ome (@{OpenFirmwareTab::all()}) {
		if ($ome->matches ($dev)) {
			push @result, $ome->module;
		}
	}
	return [@result];
}


1;
