/*
 * gdd.h
 */
/*
 * yank  -  yet another NoteKeeper
 * Copyright (C) 1999, 2000, 2001 Michael Humann <m.hussmann@home.ins.de>
 *
 * This program is free software; you  can redistribute it and/or modify it
 * under the terms of  the GNU General  Public License as published  by the
 * Free Software Foundation;  either version 2 of  the License, or (at your
 * option) any later version.
 *
 * This program  is  distributed in the  hope  that it will  be useful, but
 * WITHOUT  ANY   WARRANTY;  without   even   the  implied    warranty   of
 * MERCHANTABILITY or    FITNESS FOR A PARTICULAR   PURPOSE.   See  the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the  GNU General Public License along
 * with this program; if not, write to the  Free Software Foundation, Inc.,
 * 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef __GDD_H__
#define __GDD_H__

#include <glade/glade-xml.h> 
#include <gnome-xml/tree.h>

#ifdef __cplusplus
extern "C" {
#endif  /*__cplusplus */

/* ------------------------------------------------------ */
    
#define TYPE_GDD            (gdd_get_type ())
#define GDD(obj)            (GTK_CHECK_CAST ((obj), TYPE_GDD, Gdd))
#define GDD_CLASS(klass)    (GTK_CHECK_CLASS_CAST ((klass), TYPE_GDD, GddClass))
#define IS_GDD(obj)         (GTK_CHECK_TYPE ((obj), TYPE_GDD))
#define IS_GDD_CLASS(klass) (GTK_CHECK_CLASS_TYPE ((klass), TYPE_GDD))

typedef struct _Gdd        Gdd;
typedef struct _GddPrivate GddPrivate;
typedef struct _GddClass   GddClass;
    
struct _Gdd
{
    GladeXML   parent;
    GddPrivate *priv;
};

struct _GddClass
{
    GladeXMLClass   parent_class;
    void (*changed) (Gdd *gdd);
};

/* ------------------------------------------------------ */

GtkType    gdd_get_type(void);
Gdd*       gdd_new(const gchar *fname, const gchar *root,
                   const gchar *domain);
gboolean   gdd_construct(const Gdd*, const gchar *fname,
                         const gchar *root, const gchar *domain);

gint       gdd_set_values(const Gdd *gdd, const xmlNodePtr node);
xmlNodePtr gdd_get_values(const Gdd *gdd, const xmlDocPtr doc,
                          const gchar *name);
gint       gdd_clear_values(const Gdd *gdd);

gint       gdd_cmonitor_on(Gdd *gdd, const gboolean auto_disconnect);
gint       gdd_cmonitor_off(Gdd *gdd);
gboolean   gdd_cmonitor_is_running(const Gdd *gdd);
gint       gdd_cmonitor_set_auto_disconnect(const Gdd *gdd,
                                            const gboolean auto_disconnect);
gboolean   gdd_cmonitor_get_auto_disconnect(const Gdd *gdd);

/* debug helpers */
void       gdd_print_glade_widgets(const Gdd *gdd, const gchar *root);
void       gdd_print_scanned_widgets(const Gdd *gdd);

/* ------------------------------------------------------ */

#ifdef __cplusplus
}
#endif  /*__cplusplus */

#endif  /* __GDD_H__ */
