// $Id: import1.cc 2427 2009-07-07 22:20:11Z rafi $
// Tests whether or not import works under lab conditions.
// Relies on test1.csv

#ifdef HAVE_CONFIG_H
# include <config.h>
#endif

#ifdef HAVE_IOSTREAM
# include <iostream>
#endif

#include <csvimport.h>

#include "testpaths.h"

int main (int, char**) {
    try {
	std::cout << "Importing from test1.csv" << std::endl;;
	CSVImport imp(SRCDIR "/test1.csv", "test1.pet", ',');
	imp.import("test1");
	if (imp.hadErrors())
	    return 1;
	if (imp.numErrors() != 0)
	    return 1;
    } catch(std::exception& ex) {
	std::cout << ex.what() << std::endl;
	return 1;
    }

    return 0;
}
