/**
 * qtclientform.hpp
 * This file is part of the YATE Project http://YATE.null.ro
 *
 * A Qt based universal telephony client
 * Author: Dorin Lazar <lazar@deuromedia.ro>
 *
 * Yet Another Telephony Engine - a fully featured software PBX and IVR
 * Copyright (C) 2004 Null Team
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifndef __QTCLIENTFORM_HPP
#define __QTCLIENTFORM_HPP

#include <qwidget.h>

class YateDialButton;
class YateNumberDisplay;
class QPushButton;
class QLabel;
class YateAddressBook;
class YateAddressBookView;
class YateCallHistory;

#define YATE_NDIALBUTTONS 12

typedef enum {
	YCS_IDLE = 0,
	YCS_RINGIN,
	YCS_RINGOUT,
	YCS_INCALL,
	YCS_MAXSTATUS
} YateClientStatus;

class QtClientForm : public QWidget
{
	Q_OBJECT
 public:
	QtClientForm ();
	~QtClientForm();
 protected:
	YateDialButton *dialButtons[YATE_NDIALBUTTONS];
	YateNumberDisplay *numberDisplay;
	QPushButton *correctDigit, *rejectCall, *dialButton;
	QPushButton *quitButton;
	QLabel *statusLabel, *errorMessage;
	YateClientStatus telEngineStatus;
	YateAddressBook *addressbook;
	QPushButton *addToAddressBookButton;
	YateAddressBookView *yabv;
	YateCallHistory *ych;
	QString dialer;
 public:
	bool setStatus (YateClientStatus); /* returns false if unable to change the status */
	YateClientStatus getStatus (void) {return telEngineStatus;}
	void emitDTMF (char value);
	void setErrorMessage (QString);
	void setDialer (const char *address) {dialer = address;}
 protected slots:
	void dialPressed (void);
	void rejectPressed (void);
	void quitPressed (void);
	void addToAddressBookPressed (void);
	void dialRequest (const char *number);
};

#endif /* !__QTCLIENTFORM_HPP */

