/**
 * yatecallhistory.cpp
 * This file is part of the YATE Project http://YATE.null.ro
 *
 * A Qt based universal telephony client
 * Author: Dorin Lazar <lazar@deuromedia.ro>
 *
 * Yet Another Telephony Engine - a fully featured software PBX and IVR
 * Copyright (C) 2004 Null Team
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include "yatecallhistory.hpp"

#define YATE_CALL_HISTORY_SIZE 10

YateCallHistory::YateCallHistory(const char *filename)
{
	if (!filename) {
		ych_filename = new char [2048];
		snprintf (ych_filename, 2047, "%s/.yatecallhistory", getenv("HOME"));
	} 
	else {
		int length = strlen (filename);
		ych_filename = new char[length + 1];
		strcpy (ych_filename, filename);
	}
	restore();
}

YateCallHistory::~YateCallHistory()
{
	//store();
}

void YateCallHistory::addNumber (QString number)
{
	numbers.push_back (number);
	if (numbers.size()>YATE_CALL_HISTORY_SIZE)
		numbers.erase (numbers.begin());
	store();
}

void YateCallHistory::debug (void)
{
	unsigned int nItems = numbers.size();
	qDebug ("Call HISTORY:");
	for (unsigned int i=0; i<nItems; i++) {
		qDebug ("======%s", numbers[i].latin1());
	}
}

void YateCallHistory::restore (void)
{
	FILE *fd = fopen (ych_filename, "r");
	if (!fd) {
		perror (ych_filename);
		return;
	}
	char *buffer = (char *)alloca (2048);
	memset (buffer, 0, 2048);
	do {
		if (!fgets (buffer, 2048, fd))
			break;
		int length = strlen (buffer);
		if (length > 0 && buffer[length-1]=='\n')
			buffer[length-1] = '\0';
		if (strlen (buffer)==0)
			continue;
		addNumber (buffer);
	} while (!feof(fd));
	fclose(fd);
}

void YateCallHistory::store (void)
{
	FILE *fd = fopen (ych_filename, "w");
	if (!fd) {
		perror (ych_filename);
		return;
	}

	unsigned int nItems = numbers.size();
	qDebug ("Call HISTORY:%d",nItems);
	for (unsigned int i=0; i<nItems; i++) {
		qDebug ("======%s", numbers[i].latin1());
		fputs (numbers[i].latin1(), fd);
		fputc ('\n', fd);
	}
	fclose(fd);
}
