/**
 * yatedialbutton.cpp
 * This file is part of the YATE Project http://YATE.null.ro
 *
 * A Qt based universal telephony client
 * Author: Dorin Lazar <lazar@deuromedia.ro>
 *
 * Yet Another Telephony Engine - a fully featured software PBX and IVR
 * Copyright (C) 2004 Null Team
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include "yatedialbutton.hpp"
#include "yatedialbutton.moc"
#include "yatenumberdisplay.hpp"
#include "qtclientform.hpp"

YateDialButton::YateDialButton (QtClientForm *parent, YateNumberDisplay *d, char value) :
	QPushButton (parent, NULL),
	dialValue (value),
	disp (d),
	form (parent)
{
	setFixedSize (30,20);
	setText (QString(QChar(value)));
	connect (this, SIGNAL(clicked()), this, SLOT(clickedAction()));

	QKeySequence *seq = NULL;
	if (value >= '0' && value <='9')
		seq = new QKeySequence (UNICODE_ACCEL + value);
	if (value == '*')
		seq = new QKeySequence (UNICODE_ACCEL + '*');
	if (value == '#')
		seq = new QKeySequence (UNICODE_ACCEL + '.'); /* change it with '#', but it's nicer if you use the numeric keypad */
	if (seq)
		setAccel (*seq);
	setFocusPolicy (NoFocus);
}

YateDialButton::~YateDialButton()
{
}

void YateDialButton::clickedAction (void)
{
	if (form->getStatus()==YCS_INCALL) {
		form->emitDTMF (dialValue);
		if (disp->getNumber().find('p')<0)
			disp->addDigit ('p');
	}
	disp->addDigit (dialValue);
}
