/*
 * Copyright (c) 1996-2004, Index Data.
 *
 * Permission to use, copy, modify, distribute, and sell this software and
 * its documentation, in whole or in part, for any purpose, is hereby granted,
 * provided that:
 *
 * 1. This copyright and permission notice appear in all copies of the
 * software and its documentation. Notices of copyright or attribution
 * which appear at the beginning of any file must remain unchanged.
 *
 * 2. The names of Index Data or the individual authors may not be used to
 * endorse or promote products derived from this software without specific
 * prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED "AS IS" AND WITHOUT WARRANTY OF ANY KIND,
 * EXPRESS, IMPLIED, OR OTHERWISE, INCLUDING WITHOUT LIMITATION, ANY
 * WARRANTY OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE.
 * IN NO EVENT SHALL INDEX DATA BE LIABLE FOR ANY SPECIAL, INCIDENTAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OF ANY KIND, OR ANY DAMAGES
 * WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER OR
 * NOT ADVISED OF THE POSSIBILITY OF DAMAGE, AND ON ANY THEORY OF
 * LIABILITY, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE
 * OF THIS SOFTWARE.
 *
 * $Id: readconf.h,v 1.3 2004/10/15 00:18:59 adam Exp $
 */
/**
 * \file readconf.h
 * \brief Header for config file reading utilities
 */

#ifndef READCONF_H
#define READCONF_H

#include <stdio.h>
#include <yaz/yconfig.h>

YAZ_BEGIN_CDECL
    
YAZ_EXPORT int readconf(char *name, void *rprivate,
                        int (*fun)(char *name, void *rprivate,
				   int argc, char *argv[]));

YAZ_EXPORT int readconf_line(FILE *f, int *lineno,
			     char *line, int len, char *argv[], int num);
    
YAZ_END_CDECL

#endif
