/*
 * Copyright (C) 1995-2005, Index Data ApS
 * See the file LICENSE for details.
 *
 * $Id: ber_null.c,v 1.3 2005/01/15 19:47:11 adam Exp $
 */

/** 
 * \file ber_null.c
 * \brief Implements ber_null
 *
 * This source file implements BER encoding and decoding of
 * the NULL type.
 */
#if HAVE_CONFIG_H
#include <config.h>
#endif

#include "odr-priv.h"

/** 
 * ber_null: BER-en/decoder for NULL type.
 */
int ber_null(ODR o)
{
    switch (o->direction)
    {
    case ODR_ENCODE:
        if (odr_putc(o, 0X00) < 0)
            return 0;
#ifdef ODR_DEBUG
        fprintf(stderr, "[NULL]\n");
#endif
        return 1;
    case ODR_DECODE:
        if (odr_max(o) < 1)
        {
            odr_seterror(o, OPROTO, 39);
            return 0;
        }
        if (*(o->bp++) != 0X00)
        {
            odr_seterror(o, OPROTO, 12);
            return 0;
        }
#ifdef ODR_DEBUG
        fprintf(stderr, "[NULL]\n");
#endif
        return 1;
    case ODR_PRINT:
	return 1;
    default:
	odr_seterror(o, OOTHER, 13);
	return 0;
    }
}
