/*  
  Copyright 2002, Andreas Rottmann

  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Lesser General Public
  License as published by the Free Software Foundation; either
  version 2.1 of the License, or (at your option) any later version.

  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Lesser General Public License for more details.

  You should have received a copy of the GNU Lesser General Public
  License along with this library; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
*/
#include "yehia/script/namespace-builder.h"

namespace Yehia
{

namespace Script
{

using namespace std;

NamespaceBuilder::NamespaceBuilder(ObjectFactory& factory, 
                                   Namespace& parent_ns,
                                   const string& name) 
    : factory_(factory), parent_ns_(parent_ns), 
      nsobj_(factory_.create_namespace())
{
  name_ = name;
  this_ns_ = nsobj_.namespace_interface();
  parent_ns_.insert(name_, nsobj_);
}

NamespaceBuilder::~NamespaceBuilder()
{
}

void NamespaceBuilder::add(const std::string& name,
                           const Slot& slot, 
                           const Signature& sig)
{
  Object *obj = this_ns_->member(name);
  GenFunc *genfunc;
  
  if (!obj)
  {
    obj = &factory_.create_genfunc();
    this_ns_->insert(name, *obj);
  }
  genfunc = obj->genfunc_interface();
  
  if (!genfunc)
    throw Exception("Can only overload generic functions");
  
  genfunc->add_method(slot, sig);
}

void NamespaceBuilder::add(const std::string& name, const Any& value)
{
  this_ns_->insert(name, factory_.create_value(value));
}

}

}
