/* This is for emacs: -*-Mode: C++;-*- */
/*  
  Copyright 2002, Andreas Rottmann

  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Lesser General Public
  License as published by the Free Software Foundation; either
  version 2.1 of the License, or (at your option) any later version.

  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Lesser General Public License for more details.

  You should have received a copy of the GNU Lesser General Public
  License along with this library; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
*/
#if !defined(__INC_YEHIA_SCRIPT_NSBUILDER_H)
#define __INC_YEHIA_SCRIPT_NSBUILDER_H

#include <yehia/script/base.h>
#include <yehia/script/slot-convert.h>
#include <yehia/script/slot-signature.h>

namespace Yehia
{

namespace Script
{

class NamespaceBuilder
{
  public:
    NamespaceBuilder(ObjectFactory& factory, Namespace& parent_ns,
                     const std::string& name);
    ~NamespaceBuilder();

    operator Namespace&() { return *this_ns_; }
    
    void add(const std::string& name, const Slot& slot, const Signature& sig);
    void add(const std::string& name, const Any& value);
    
    template <class ASlot> 
    void method(const std::string& name, const ASlot& slot) {
      add(name, convert(slot), slotsig(slot));
    }
  private:
    ObjectFactory& factory_;
    Namespace& parent_ns_;
    Namespace *this_ns_;
    Object& nsobj_;
    std::string name_;
};

}

}

#endif
