/*
 * YH - Console Chinese Environment -
 * Copyright (C) 1999 Red Flag Linux (office@sonata.iscas.ac.cn)
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY TAKASHI MANABE ``AS IS'' AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE TERRENCE R. LAMBERT BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 */


/*****************---license.c----*********************/


#include <stdio.h>
#include <sys/types.h>
#include <sys/stat.h>

#define YES 1
#define NO  0

#define BASE26		26

#define TAGSIZ		5
#define	DISTSIZ		3
#define	NUMBSIZ		6
#define	PSWDSIZ		3
#define STSWSIZ		3
#define	CHKSIZ		2
#define	TAGOFF		0
#define	DISTOFF		TAGOFF+TAGSIZ
#define NUMBOFF		DISTOFF+DISTSIZ
#define	PSWDOFF		NUMBOFF+NUMBSIZ
#define	STSWOFF		PSWDOFF+PSWDSIZ
#define	CHKOFF		STSWOFF+STSWSIZ

#define SERSIZ		DISTSIZ+NUMBSIZ
#define	KEYSIZ		PSWDSIZ+STSWSIZ+CHKSIZ
#define SEROFF		DISTOFF

/* for adding NULL on the End Of Strings */
#define EOS			'\0'

u_char ASCII_SW[] =
{
		0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
	    0x20, 0x28, 0x28, 0x28, 0x28, 0x28, 0x20, 0x20,
	    0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
	    0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
	    0x48, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10,
	    0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10,
	    0x84, 0x84, 0x84, 0x84, 0x84, 0x84, 0x84, 0x84,
	    0x84, 0x84, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10,
	    0x10, 0x81, 0x81, 0x81, 0x81, 0x81, 0x81, 0x1,
	    0x1,  0x1,  0x1,  0x1,  0x1,  0x1,  0x1,  0x1,
	    0x1,  0x1,  0x1,  0x1,  0x1,  0x1,  0x1,  0x1,
	    0x1,  0x1,  0x1,  0x10, 0x10, 0x10, 0x10, 0x10,
	    0x10, 0x82, 0x82, 0x82, 0x82, 0x82, 0x82, 0x2,
	    0x2,  0x2,  0x2,  0x2,  0x2,  0x2,  0x2,  0x2,
	    0x2,  0x2,  0x2,  0x2,  0x2,  0x2,  0x2,  0x2,
	    0x2,  0x2,  0x2,  0x10, 0x10, 0x10, 0x10, 0x20,
	    0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,
};

#ifdef STONE_OEM
char *ACTKEY = "stoneo";
#else
char *ACTKEY = "yhdemo";
#endif

char *snsumgen(char *snserkey);
char *trans(char *strkey);


/*************************functions*******************/

char *chkserkey()
{
	static char ser[80],serno[80], key[80];
	char *ser1,*serkey,*chksum;
	char *actkey;
	FILE *fp;
	int i;

	actkey=ACTKEY;

	if((fp=fopen("/usr/local/yh/lib/.license","r"))==NULL)
	{
		puts("The License Number and License Code wasn't specified.");
		puts("yh: cannot execute");
		exit(0);
	}

	fscanf(fp,"%s%s",ser,key);

	for(i=0;ser[i];i++)
		serno[i]=ser[i];
	serno[i]='\0';

	serkey = ser;
	strcat(serkey,actkey);
	serkey[SERSIZ + KEYSIZ - CHKSIZ] = EOS;
	chksum = snsumgen(serkey);
	strcat(actkey,chksum);
	ser1 = trans(actkey);
	strcat(ser1, "d");
	fclose(fp);

	if(strcmp(key,ser1) != 0) {
		printf("The License Number or License Code was invalid.\n");
		puts("yh: cannot execute");
		return(0);
	}
	return(serno);
}


int isserial(serial)
char *serial;
{
	char *ser = serial;
	int i;

	if(strlen(ser) != SERSIZ) {
		return(YES);
	} else {
		for(i = 0; i < DISTSIZ; i++) {
			if((ser[i] < 'A')||(ser[i] > 'Z')) {
				return(YES);
			}
		}

		for(i = DISTSIZ; i < SERSIZ; i++) {
			if((ser[i] < '0')||(ser[i] > '9')) {
				return(YES);
			}
		}
	}
	return(NO);
}


int iskey(key)
char *key;
{
	char *actkey = key;
	int i;

	if(strlen(actkey) != KEYSIZ) {
		return(YES);
	} else {
		for(i = 0; i < KEYSIZ; i++) {
			if((actkey[i] < 'a')||(actkey[i] > 'z')) {
				return(YES);
			}
		}
	}
	return(NO);
}

extern char *Key;

char *trans(strkey)
char *strkey;
{
	register mod,i;
	char *key = strkey;

	mod = i = 0;
	while(*key)
		key++;
	while( key >= strkey ) {
		if( ASCII_SW[*key] & 0x2 ) {
			if(( *key - i ) < 'a')
				*key = ((*key - i) - 'G') + 'a';
			else 
				if(( *key - i - 'a' ) >= 26)
					*key = ((*key - i) - 0x7b) + 'a';
				else
					*key = ((*key - i) - 'a') + 'a';
		}
		mod = 26 - (*key - mod) % 26;
		i = mod;
		key--;
	}

	return(key+1);

}

char *snsumgen(snserkey)
char *snserkey;
{

	int shift;
	register unsigned int check = 0;
	static char cksum[CHKSIZ + 1];
	int i;

	shift = (int)snserkey[SERSIZ-1] % 16;

	while (*snserkey != EOS) {
		check += *snserkey;
		check = (check << 1)  |  ((check & 0x8000)?1:0);
		++snserkey;
	}

	while (shift--)
		check = (check << 1)  |  ((check & 0x8000)?1:0);

	for(i=CHKSIZ-1; i>=0; i--) {
		cksum[i] = (check%BASE26) + 'a';
		check /= BASE26;
	}
	cksum[CHKSIZ] = EOS;

	return (cksum);
}

