/*                                                                      -*-C-*-
 * config.h --
 *
 *	Configuration settings for compiling Yeti and others Yorick extensions.
 *
 *-----------------------------------------------------------------------------
 *
 *	Copyright (C) 2006 Eric Thibaut.
 *
 *	This file is part of Yeti.
 *
 *	Yeti is  free software;  you can redistribute  it and/or  modify it
 *	under  the terms of  the GNU  General Public  License version  2 as
 *	published by the Free Software Foundation.
 *
 *	Yeti is distributed in the hope that it will be useful, but WITHOUT
 *	ANY WARRANTY; without even  the implied warranty of MERCHANTABILITY
 *	or FITNESS  FOR A PARTICULAR  PURPOSE.  See the GNU  General Public
 *	License for more details.
 *
 *	You should have  received a copy of the  GNU General Public License
 *	along with  Yeti (file "COPYING"  in the top source  directory); if
 *	not, write to  the Free Software Foundation, Inc.,  51 Franklin St,
 *	Fifth Floor, Boston, MA 02110-1301 USA
 *
 *-----------------------------------------------------------------------------
 *
 * History:
 *	$Id$
 *	$Log$
 */

#ifndef _YETI_CONFIG_H
#define _YETI_CONFIG_H 1

/*---------------------------------------------------------------------------*/
/* Yorick version numbers: */
#define YORICK_VERSION_MAJOR 2
#define YORICK_VERSION_MINOR 1
#define YORICK_VERSION_MICRO 4
#define YORICK_VERSION_SUFFIX "x"

/* Yeti version numbers: */
#define YETI_VERSION_MAJOR 6
#define YETI_VERSION_MINOR 2
#define YETI_VERSION_MICRO 2
#define YETI_VERSION_SUFFIX "x"

/* Define the following macro to true if Yeti must provide 'is_list'
   function: */
#define YETI_MUST_PROVIDE_IS_LIST 0

/* Define the following macro to true if Yorick does not export
   the definitions of autoload_t structure: */
#define YETI_MUST_DEFINE_AUTOLOAD_TYPE 0

/*---------------------------------------------------------------------------*/
/* Unfortunately the code interface to Yorick change with the version and
   none of the Yorick headers provide this information.  The following
   defintions attempt to provide a more uniform interface. */

#undef p_strfree
#if (YORICK_VERSION_MAJOR == 1 && YORICK_VERSION_MINOR == 4)
# include "defstr.h"
# define p_malloc   Ymalloc  /* usage: p_malloc(SIZE)        */
# define p_realloc  Yrealloc /* usage: p_realloc(ADDR, SIZE) */
# define p_free     Yfree    /* usage: p_free(ADDR)          */
# define p_strcpy   StrCpy   /* usage: p_strcpy(STR) -- also see yeti_strcpy */
# define p_strfree  StrFree  /* usage: p_strfree(STR) */
# define p_stralloc StrAlloc /* usage: p_stralloc(LEN) */
#endif /* Yorick 1.4 */

#if ((YORICK_VERSION_MAJOR == 1 && YORICK_VERSION_MINOR >= 5) || YORICK_VERSION_MAJOR >= 2)
# include "pstdlib.h"
# define p_strfree       p_free            /* usage: p_strfree(STR) */
# define p_stralloc(LEN) p_malloc((LEN)+1) /* usage: p_stralloc(LEN) */
#endif /* Yorick 1.5 and newer */

#ifndef p_stralloc
# error "unsupported Yorick version"
#endif

/*---------------------------------------------------------------------------*/
#endif /* _YETI_CONFIG_H */
