#!/bin/sh

# script to execute shell commands it reads from a named pipe (fifo)
# to create a fifo, use the system utility
#   mkfifo <filename>
# or
#   mknod <filename> -p
# the mknod utility may not be in a standard PATH (try /usr/etc)

# - the purpose of this script is to be able to start commands from
#   a very large program without the need to fork
# - on most modern OSes, fork memory usage may be negligible
# - on some old OSes, using vfork instead of fork solves the problem
# - this script will work on any OS that supports named pipes

input=${1:-$HOME/Yorick/FIFO.0}
output=${2:-$HOME/Yorick/FIFO.1}
case $input in
  -) : ;;
  *) exec <$input ;;
esac
case $output in
  -) : ;;
  *) exec >$output 2>$output ;;
esac

while test 1; do
  echo =-=-listener-=-ready-=-=
  if read line
    then eval $line
    else break
  fi
done
