/* main.c */

/*			   NOTICE
 *
 * Copyright (c) 1990,1992,1993 Britt Yenne.  All rights reserved.
 * 
 * This software is provided AS-IS.  The author gives no warranty,
 * real or assumed, and takes no responsibility whatsoever for any 
 * use or misuse of this software, or any damage created by its use
 * or misuse.
 * 
 * This software may be freely copied and distributed provided that
 * no part of this NOTICE is deleted or edited in any manner.
 * 
 */

/* Mail comments or questions to metawire.org */

#include "header.h"
#include <signal.h>
#include "menu.h"


#ifndef HAVE_GETOPT_LONG
#include "getopt.h"
#else
#include <getopt.h>
#endif

char errstr[132];	/* temporary string for errors */
char *vhost = NULL;	/* specified virtual host */

/* Clean up and exit.
 */
void
bail(n)
  int n;
{
    kill_auto();
    if(n == YTE_SUCCESS_PROMPT && (def_flags & FL_PROMPTQUIT))
       if(show_mesg("Press any key to quit.", NULL) == 0)
       {
           update_menu();
           bail_loop();
       }
    end_term();
    (void)exit(n == YTE_SUCCESS_PROMPT ? YTE_SUCCESS : n);
}

#ifndef HAVE_STRERROR
#define strerror(n)	(sys_errlist[(n)])
#endif

/* Display an error.
 */
void
show_error(str)
  register char *str;
{
    register char *syserr;
    static int in_error = 0;

    if(errno == 0)
	syserr = "";
    else
	syserr = strerror(errno);

    putc(7, stderr);
    if(in_error == 0 && what_term() != 0)
    {
	in_error = 1;
	if(show_error_menu(str, syserr) < 0)
	{
	    show_error("show_error: show_error_menu() failed");
	    show_error(str);
	}
	else
	    update_menu();
	in_error = 0;
    }
    else
    {
	fprintf(stderr, "%s: %s\n", str, syserr);
	sleep(2);
    }
}

/* Allocate memory.
 */
yaddr
get_mem(n)
  int n;
{
    register yaddr out;
    if((out = (yaddr)malloc(n)) == NULL)
    {
	show_error("malloc() failed");
	bail(YTE_NO_MEM);
    }
    return out;
}

/* Copy a string.
 */
char *
str_copy(str)
  register char *str;
{
    register char *out;
    register int len;

    if(str == NULL)
	return NULL;
    len = strlen(str) + 1;
    out = get_mem(len);
    (void)memcpy(out, str, len);
    return out;
}

/* Reallocate memory.
 */
yaddr
realloc_mem(p, n)
  char *p;
  int n;
{
    register yaddr out;
    if(p == NULL)
	return get_mem(n);
    if((out = (yaddr)realloc(p, n)) == NULL)
    {
	show_error("realloc() failed");
	bail(YTE_NO_MEM);
    }
    return out;
}

/* Process signals.
 */
static RETSIGTYPE
got_sig(n)
  int n;
{
    if(n == SIGINT)
	bail(YTE_SUCCESS);
    bail(YTE_SIGNAL);
}

/*  MAIN  */
int
main(argc, argv)
  int argc;
  char **argv;
{
    int xflg = 0, sflg = 0, yflg = 0, iflg = 0, qflg = 0;
    int optchar;
    struct option longopts[] = {
	#ifdef USE_X11
	{"x-interface",		0, 0, 'x'},
	#endif
	{"no-auto-invite-port",	0, 0, 'i'},
	{"require-caps",	0, 0, 'Y'},
	{"start-shell",		0, 0, 's'},
	{"quit-prompt",		0, 0, 'q'},
	{"virtual-host",	1, 0, 'h'},
	{"dump",		1, 0, 'd'},
	{0, 0, 0, 0}
    }, *optsptr;
    struct optiondesc {
	const char *arg;
	const char *desc;
    } longopts_desc[] = {
	#ifdef USE_X11
	{NULL, "use the X interface"},
	#endif
	{NULL, "no auto-invite port"},
	{NULL, "require caps on all y/n answers"},
	{NULL, "start a shell"},
	{NULL, "prompt before quitting"},
	{"host_or_ip", "select interface or virtual host"},
	{"filename", "enable, and select file to, dump"},
	{NULL, NULL}
    }, *descsptr;

    /* check for a 64-bit mis-compile */

    if(sizeof(ylong) != 4)
    {
    	fprintf(stderr, "The definition for ylong in header.h is wrong;\n\
please change it to an unsigned 32-bit type that works on your computer,\n\
then type 'make clean' and 'make'.\n");
	(void)exit(YTE_INIT);
    }

    /* search for options */
    while((optchar = getopt_long(argc, argv,
    #ifdef USE_X11
    "x"
    #endif
                                 "iYsh:d:", longopts, NULL)) != -1)
    	switch(optchar)
    {
	#ifdef USE_X11
	case 'x': xflg++; break;
	#endif
	case 'i': iflg++; break;
	case 'Y': yflg++; break;		
	case 's': sflg++; break;
	case 'q': qflg++; break;
	case 'h': vhost = optarg; break;
	case 'd': set_file_dump(optarg); break;
	case '?': argc = 0; break;		/* force usage error */
    }

    /* check for users */
    if(argc <= optind)
    {
	fprintf(stderr, "Usage:    %s [options] user[@host][#tty]...\n",
	        argv[0]);
	optsptr = longopts;
	descsptr = longopts_desc;
	while(optsptr->name)
	{
	    fprintf(stderr,"    -%c or --%-15s %-*s --   %s\n",
	            optsptr->val, optsptr->name,
		    strlen(optsptr->name) > 15 ?
		      11 - (strlen(optsptr->name) - 15) : 11,
		    descsptr->arg ? descsptr->arg : "",
	            descsptr->desc);
	    ++ optsptr;
	    ++ descsptr;
	}
	(void)exit(YTE_INIT);
    }

    /* set up signals */

    signal(SIGINT, got_sig);
    signal(SIGHUP, got_sig);
    signal(SIGQUIT, got_sig);
    signal(SIGABRT, got_sig);
    signal(SIGPIPE, SIG_IGN);

    /* set default options */

    def_flags = FL_PROMPTRING | FL_RING | FL_SCROLL;

    /* go for it! */

    errno = 0;
    init_fd();
    read_ytalkrc();
    init_user(vhost);
    if(xflg)
	def_flags |= FL_XWIN;
    if(yflg)
	def_flags |= FL_CAPS;
    if(iflg)
	def_flags |= FL_NOAUTO;
    if (qflg)
        def_flags |= FL_PROMPTQUIT;

    init_term();
    init_socket();
    for(; optind < argc; optind ++)
	invite(argv[optind], 1);
    if(sflg)
	execute(NULL);
    else
	msg_term(me, "Waiting for connection...");
    main_loop();
    bail(YTE_SUCCESS);

    return 0;	/* make lint happy */
}

