/*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*\

File:  oct6100_chip_open_inst.h

    Copyright (c) 2001-2006 Octasic Inc.
    
Description: 

	File containing all defines, macros, and structures pertaining to the file
	oct6100_chip_open.c.  All elements defined in this file are for public
	usage of the API.  All private elements are defined in the
	oct6100_chip_open_priv.h file.

This file is part of the Octasic OCT6100 GPL API . The OCT6100 GPL API  is 
free software; you can redistribute it and/or modify it under the terms of 
the GNU General Public License as published by the Free Software Foundation; 
either version 2 of the License, or (at your option) any later version.

The OCT6100 GPL API is distributed in the hope that it will be useful, but 
WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY 
or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License 
for more details. 

You should have received a copy of the GNU General Public License 
along with the OCT6100 GPL API; if not, write to the Free Software 
Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.

$Octasic_Release: OCT612xAPI-01.00-PR47 $

$Octasic_Revision: 120 $

\*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*/

#ifndef __OCT6100_CHIP_OPEN_INST_H__
#define __OCT6100_CHIP_OPEN_INST_H__

/*****************************  INCLUDE FILES  *******************************/

/*****************************  DEFINES  *************************************/

/*****************************  TYPES  ***************************************/

typedef struct _OCT6100_API_CHIP_CONFIG_
{
	UINT32	ulUserChipId;
	PVOID	pProcessContext;

	unsigned char const *pbyImageFile;		/* Byte pointer to the image file to be uploaded into the chip. */
	UINT32	ulImageSize;		/* Size of the image file (in bytes). */
	
	UINT32	ulMemClkFreq;		
	UINT32	ulUpclkFreq;		/* 33.33 or 66.66 MHz. */
	UINT8	fEnableMemClkOut;	/* TRUE/FALSE */

	UINT8	fMultiProcessSystem;

	UINT8	byMemoryType;		/* SDRAM or DDR */
	UINT8	byNumMemoryChips;	/* Number of memory chips present. */
	UINT32	ulMemoryChipSize;	/* The size of the memory chips. */

	UINT16	usMaxRwAccesses;	
	UINT16	usTailDisplacement;	

	/* Resource allocation parameters. */
	UINT16	usMaxChannels;
	UINT16	usMaxBiDirChannels;

	UINT32	aulTdmStreamFreqs[ cOCT6100_TDM_STREAM_MAX_GROUPS ];

	UINT8	byMaxTdmStreams;
	UINT8	byTdmSampling;

	UINT8	fEnableFastH100Mode;
	UINT8	fEnableAcousticEcho; /* Acoustic echo enabled. */

	UINT16	ausTimestampTimeslots[ 4 ];
	UINT16	ausTimestampStreams[ 4 ];

	UINT8	fUseSynchTimestamp;

	/* Debug feature used to record stream information from a channel.*/
	UINT8	fEnableChannelRecording;

	UINT16	usMaxRemoteDebugSessions;

	UINT8	byInterruptPolarity;

	UINT16	usMaxTsiCncts;

	UINT8	fEnableExtToneDetection;


	UINT16	usMaxConfBridges;
	UINT16	usMaxFlexibleConfParticipants;
	UINT16	usMaxPlayoutBuffers;

	/* Playout event software buffer size. */
	UINT32	ulSoftBufPlayoutEventsBufSize;

	/* Soft buffer size. */
	UINT32	ulSoftToneEventsBufSize;

	UINT16	usMaxPhasingTssts;
	UINT16  usMaxAdpcmChannels;
	

	


	UINT8	fEnableProductionBist;
	UINT32	ulProductionBistMode;
	UINT32	ulNumProductionBistLoops;
	
} tOCT6100_API_CHIP_CONFIG, *tPOCT6100_API_CHIP_CONFIG;


typedef struct _OCT6100_API_MISCELLANEOUS_
{
	/* Total size of external memories. */
	UINT32	ulTotalMemSize;

	UINT32	ulH100SlaveMode;

	/* Mclk frequency generated by the chip. */
	UINT32	ulMclkFreq;

	/* Array of UINT32s used to perform a burst of writes (avoids having to
	   allocate on the stack. The size of this array MUST NOT CHANGE (it's
	   used everywhere). */
	UINT16	ausSuperArray[ cOCT6100_INTERNAL_SUPER_ARRAY_SIZE ];
	UINT16	ausSuperArray1[ cOCT6100_INTERNAL_SUPER_ARRAY_SIZE ];
	UINT16	ausSuperArray2[ cOCT6100_INTERNAL_SUPER_ARRAY_SIZE ];

	/* Chip ID and revision.*/
	UINT16	usChipId;
	UINT16	usChipRevision;

	/* Lsu CPU access variables.*/
	UINT16	usCpuLsuWritePtr;
	UINT16	usCodepoint;
	
	/* Max number of channel supported.*/
	UINT16	usMaxNumberOfChannels;
	UINT16	usMaxH100Speed;
	UINT16	usTdmClkBoundary;

	UINT16	usNumBridgesOpened;
	UINT16	usFirstBridge;





} tOCT6100_API_MISCELLANEOUS, *tPOCT6100_API_MISCELLANEOUS;

typedef struct _OCT6100_API_MEMORY_MAP_
{
	/*-----------------------------------------------------------------------------*/
	/* Structure contained in external memory. */

	/* Memory mapping filled using TLV information from the chip. */

	/* Main channel memory. */
	UINT32	ulChanMainMemBase;
	UINT32	ulChanMainMemSize;

	UINT32	ulChanMainIoMemOfst;

	UINT32	ulChanMainRinCBMemOfst;
	UINT32	ulChanMainRinCBMemSize;
	UINT32	ulChanMainSinCBMemOfst;
	UINT32	ulChanMainSinCBMemSize;
	UINT32	ulChanMainSoutCBMemOfst;
	UINT32	ulChanMainSoutCBMemSize;

	/* Free memory base address. */
	UINT32	ulFreeMemBaseAddress;

	/* Root channel config offset. */
	UINT32	ulChanRootConfOfst;

	/* Playout buffer info. */
	UINT32	ulChanMainRinPlayoutMemOfst;
	UINT32	ulChanMainRinPlayoutMemSize;
	UINT32	ulChanMainSoutPlayoutMemOfst;
	UINT32	ulChanMainSoutPlayoutMemSize;

	/* Channel Stats location */
	UINT32	ulChanMainIoStatsOfst;
	UINT32	ulChanMainIoStatsSize;

	/* Buffer playout fields. */
	tOCT6100_TLV_OFFSET	PlayoutRinWritePtrOfst;
	tOCT6100_TLV_OFFSET	PlayoutRinIgnoreSkipCleanOfst;
	tOCT6100_TLV_OFFSET	PlayoutRinSkipPtrOfst;
	tOCT6100_TLV_OFFSET	PlayoutSoutWritePtrOfst;
	tOCT6100_TLV_OFFSET	PlayoutSoutIgnoreSkipCleanOfst;
	tOCT6100_TLV_OFFSET	PlayoutSoutSkipPtrOfst;
	tOCT6100_TLV_OFFSET	PlayoutRinReadPtrOfst;
	tOCT6100_TLV_OFFSET	PlayoutSoutReadPtrOfst;
	tOCT6100_TLV_OFFSET	PlayoutRinHardSkipOfst;
	tOCT6100_TLV_OFFSET	PlayoutSoutHardSkipOfst;

	/* Adaptive noise reduction. */
	tOCT6100_TLV_OFFSET	AdaptiveNoiseReductionOfst;

	/* DC offset removal. */
	tOCT6100_TLV_OFFSET	RinDcOffsetRemovalOfst;
	tOCT6100_TLV_OFFSET	SinDcOffsetRemovalOfst;

	/* Level control. */
	tOCT6100_TLV_OFFSET	RinLevelControlOfst;
	tOCT6100_TLV_OFFSET	SoutLevelControlOfst;
	
	/* Auto level control. */
	tOCT6100_TLV_OFFSET	RinAutoLevelControlTargetOfst;
	tOCT6100_TLV_OFFSET	SoutAutoLevelControlTargetOfst;

	/* High level compensation. */
	tOCT6100_TLV_OFFSET	RinHighLevelCompensationThresholdOfst;
	tOCT6100_TLV_OFFSET	SoutHighLevelCompensationThresholdOfst;

	/* Auto level control and high level compensation status. */
	tOCT6100_TLV_OFFSET	AlcHlcStatusOfst;

	/* Confort Noise Mode. */
	tOCT6100_TLV_OFFSET	ComfortNoiseModeOfst;

	/* NLP control field. */
	tOCT6100_TLV_OFFSET	NlpControlFieldOfst;

	/* VAD control field offset.*/
	tOCT6100_TLV_OFFSET	VadControlFieldOfst;

	/* NLP Trivial field offset. */
	tOCT6100_TLV_OFFSET	NlpTrivialFieldOfst;
	
	/* Acoustic echo field offset. */
	tOCT6100_TLV_OFFSET	AecFieldOfst;

	/* Acoustic echo default ERL field offset. */
	tOCT6100_TLV_OFFSET	AecDefaultErlFieldOfst;

	/* Non-linearity behavior A and B field offset. */
	tOCT6100_TLV_OFFSET	PcmLeakFieldOfst;
	tOCT6100_TLV_OFFSET	NlpConvCapFieldOfst;

	/* Default ERL field offset. */
	tOCT6100_TLV_OFFSET	DefaultErlFieldOfst;
	
	/* Tone Removal field offset.*/
	tOCT6100_TLV_OFFSET	ToneRemovalFieldOfst;



	/* Channel config fields offset. */
	tOCT6100_TLV_OFFSET	ChanMainIoMaxEchoPointOfst;
	tOCT6100_TLV_OFFSET TailDisplEnableOfst;
	
	/* Pouch fields offset. */
	tOCT6100_TLV_OFFSET	PouchBootInstructionOfst;
	tOCT6100_TLV_OFFSET	PouchBootResultOfst;
	tOCT6100_TLV_OFFSET	PouchTailDisplOfst;

	/* 2100 Hz Auto disabling fields offset. */
	tOCT6100_TLV_OFFSET	ToneDisablerControlOfst;
	
	/* Conferencing dominant speaker field offset. */
	tOCT6100_TLV_OFFSET	DominantSpeakerFieldOfst;

	/* Conferencing noise reduction field offset. */
	tOCT6100_TLV_OFFSET	ConferencingNoiseReductionOfst;
	
	/* Per channel tail displacement field offset. */
	tOCT6100_TLV_OFFSET	PerChanTailDisplacementFieldOfst;

	/* Per channel tail length field offset. */
	tOCT6100_TLV_OFFSET	PerChanTailLengthFieldOfst;

	/* AF control/echo cancellation bypass. */
	tOCT6100_TLV_OFFSET	AftControlOfst;

	/* Voice detected stat field offset. */
	tOCT6100_TLV_OFFSET	SinVoiceDetectedStatOfst;

	/* Rin currently applied gain field offset. */
	tOCT6100_TLV_OFFSET	RinAppliedGainStatOfst;

	/* Sout currently applied gain field offset. */
	tOCT6100_TLV_OFFSET	SoutAppliedGainStatOfst;
	
	/* Adaptive listener enhancement field offset. */
	tOCT6100_TLV_OFFSET	AdaptiveAleOfst;
	
	/* Rin NR field offset.  */
	tOCT6100_TLV_OFFSET	RinAnrOfst;

	/* Rin NR value field offset.  */
	tOCT6100_TLV_OFFSET	RinAnrValOfst;
	
	/* Sin Mute field offset. */
	tOCT6100_TLV_OFFSET	SinMuteOfst;

	/* Rin Mute field offset. */
	tOCT6100_TLV_OFFSET	RinMuteOfst;

	/* Sout ANR SNR enhancement offset. */
	tOCT6100_TLV_OFFSET	AnrSnrEnhancementOfst;

	/* Sout ANR voice-noise segregation offset. */
	tOCT6100_TLV_OFFSET	AnrVoiceNoiseSegregationOfst;

	/* Tone disabler VQE activation delay offset. */
	tOCT6100_TLV_OFFSET	ToneDisablerVqeActivationDelayOfst;

	/* AF tail displacement value configuration offset. */
	tOCT6100_TLV_OFFSET	AfTailDisplacementFieldOfst;

	/* Pouch counter field offset. */
	tOCT6100_TLV_OFFSET	PouchCounterFieldOfst;

	/* Acoustic echo tail length. */
	tOCT6100_TLV_OFFSET	AecTailLengthFieldOfst;

	/* Is ISR called field offset. */
	tOCT6100_TLV_OFFSET	IsIsrCalledFieldOfst;

	/* Music protection enable field offset. */
	tOCT6100_TLV_OFFSET	MusicProtectionFieldOfst;

	/* Rin port energy level statistics field offset. */
	tOCT6100_TLV_OFFSET	RinEnergyStatFieldOfst;

	/* Sout port energy level statistics field offset. */
	tOCT6100_TLV_OFFSET	SoutEnergyStatFieldOfst;

	/* Double talk behavior field offset. */
	tOCT6100_TLV_OFFSET	DoubleTalkBehaviorFieldOfst;

	/* Idle code detection field offset. */
	tOCT6100_TLV_OFFSET	IdleCodeDetectionFieldOfst;

	/* Reset Rin ALC on tones field offset. */
	tOCT6100_TLV_OFFSET	ResetRinAlcOnTonesFieldOfst;

	/* Reset Sout ALC on tones field offset. */
	tOCT6100_TLV_OFFSET	ResetSoutAlcOnTonesFieldOfst;

	/* ALC noise bleed out time field offset. */
	tOCT6100_TLV_OFFSET	AlcNoiseBleedOutTimeFieldOfst;

	/* TSI memory mapping information.*/
	UINT32				ulNumTsiEntries;

	/*-----------------------------------------------------------------------------*/

} tOCT6100_API_MEMORY_MAP, *tPOCT6100_API_MEMORY_MAP;

typedef struct _OCT6100_API_SOFT_BUFS_
{
	/* To avoid compilation errors. */
	UINT32	ulDummyVariable;

	/* Tone events buffer pointers. */
	UINT32	ulToneEventBufferWritePtr;
	UINT32	ulToneEventBufferReadPtr;
	UINT32	ulToneEventBufferSize;
	UINT32	ulToneEventBufferMemOfst;
	UINT32	ulToneEventBufferOverflowCnt;

	/* Playout events buffer pointers. */
	UINT32	ulBufPlayoutEventBufferWritePtr;
	UINT32	ulBufPlayoutEventBufferReadPtr;
	UINT32	ulBufPlayoutEventBufferSize;
	UINT32	ulBufPlayoutEventBufferMemOfst;
	UINT32	ulBufPlayoutEventBufferOverflowCnt;

} tOCT6100_API_SOFT_BUFS, *tPOCT6100_API_SOFT_BUFS;

typedef struct _OCT6100_API_IMAGE_REGION_
{
	UINT32	ulPart1Size;
	UINT32	ulPart2Size;
	UINT32	ulClockInfo;
	
	UINT32	ulReserved;

	UINT32	ulPart1BaseAddress;
	UINT32	ulPart2BaseAddress;

} tOCT6100_API_IMAGE_REGION, *tPOCT6100_API_IMAGE_REGION;

typedef struct _OCT6100_API_IMAGE_INFO_
{
	UINT8	fBufferPlayout;
	UINT8	fAdaptiveNoiseReduction;
	UINT8	fRinDcOffsetRemoval;
	UINT8	fSinDcOffsetRemoval;

	UINT8	fRinAutoLevelControl;
	UINT8	fSoutAutoLevelControl;
	UINT8	fRinHighLevelCompensation;
	UINT8	fSoutHighLevelCompensation;

	UINT8	fAlcHlcStatus;
	UINT8	fComfortNoise;
	UINT8	fNlpControl;
	UINT8	fSilenceSuppression;

	UINT8	fToneDisabler;
	UINT8	fTailDisplacement;
	UINT8	fPerChannelTailDisplacement;
	UINT8	fAcousticEcho;

	UINT8	fAecEnabled;
	UINT8	fToneRemoval;
	UINT8	fDefaultErl;
	UINT8	fMaxEchoPoint;

	UINT8	fNonLinearityBehaviorA;
	UINT8	fNonLinearityBehaviorB;
	UINT8	fAecDefaultErl;
	UINT8	fAdpcm;

	UINT8	fConferencing;
	UINT8	fConferencingNoiseReduction;
	UINT8	fMusicProtection;
	UINT8	fDominantSpeakerEnabled;

	UINT8	fAftControl;
	UINT8	fSinVoiceDetectedStat;
	UINT8	fRinAppliedGainStat;
	UINT8	fSoutAppliedGainStat;

	UINT8	fListenerEnhancement;
	UINT8	fRoutNoiseReduction;
	UINT8	fRoutNoiseReductionLevel;
	UINT8	fRinMute;
	UINT8	fSinMute;

	UINT8	fAnrSnrEnhancement;
	UINT8	fAnrVoiceNoiseSegregation;
	UINT8	fRinBufferPlayoutHardSkip;
	UINT8	fSoutBufferPlayoutHardSkip;

	UINT16	usMaxNumberOfChannels;
	UINT8	fPerChannelTailLength;
	UINT8	fToneDisablerVqeActivationDelay;

	UINT32	ulToneProfileNumber;

	UINT16	usMaxTailDisplacement;
	UINT16	usMaxTailLength;

	UINT8	byNumToneDetectors;
	UINT8	byMaxNumberPlayoutEvents;

	UINT8	fAfTailDisplacement;
	UINT8	fAecTailLength;

	UINT8	fMusicProtectionConfiguration;
	UINT8	byImageType;

	UINT8	fBufferPlayoutSkipInEvents;
	UINT8	fSoutNoiseBleaching;

	UINT8	fRinEnergyStat;
	UINT8	fSoutEnergyStat;

	UINT8	fDoubleTalkBehavior;
	UINT8	fDoubleTalkBehaviorFieldOfst;
	
	UINT8	fIdleCodeDetection;
	UINT8	fIdleCodeDetectionConfiguration;
	
	UINT8	fResetRinAlcOnTones;
	UINT8	fResetSoutAlcOnTones;

	UINT8	fSinLevel;
	UINT8	fAlcNoiseBleedOutTime;



	UINT8	szVersionNumber[ cOCT6100_VERSION_NUMBER_MAX_SIZE ];
	UINT32	ulBuildId;

	tOCT6100_TLV_TONE_INFO	aToneInfo[ cOCT6100_MAX_TONE_EVENT ];

} tOCT6100_API_IMAGE_INFO, *tPOCT6100_API_IMAGE_INFO;

typedef struct _OCT6100_API_MIXER_
{
	/* Pointer to the various event region. */
	UINT16	usFirstSoutCopyEventPtr;
	UINT16	usLastSoutCopyEventPtr;

	UINT16	usFirstBridgeEventPtr;
	UINT16	usLastBridgeEventPtr;

	UINT16	usFirstSinCopyEventPtr;
	UINT16	usLastSinCopyEventPtr;

	/* Recording event info. */
	UINT16	usRecordCopyEventIndex;
	UINT16	usRecordSinEventIndex;

} tOCT6100_API_MIXER, tPOCT6100_API_MIXER;


typedef struct _OCT6100_API_BUFFER_PLAYOUT_MALLOC_INFO_
{
	/* Next node to be checked for free memory. */
	UINT32	ulRovingNode;

	/* First unused node in the unused list. */
	UINT32	ulFirstUnusedNode;

	/* Last unused node in the unused list. */
	UINT32	ulLastUnusedNode;

	/* Count of unused nodes. */
	UINT32	ulUnusedNodeCnt;

} tOCT6100_API_BUFFER_PLAYOUT_MALLOC_INFO, *tPOCT6100_API_BUFFER_PLAYOUT_MALLOC_INFO;




#endif /* __OCT6100_CHIP_OPEN_INST_H__ */
