/*
 * Zaz
 * Copyright (C) Remigiusz Dybka 2009 <remigiusz.dybka@gmail.com>
 *
 Zaz is free software: you can redistribute it and/or modify it
 under the terms of the GNU General Public License as published by the
 Free Software Foundation, either version 3 of the License, or
 (at your option) any later version.

 Zaz is distributed in the hope that it will be useful, but
 WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 See the GNU General Public License for more details.

 You should have received a copy of the GNU General Public License along
 with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include "settings.h"

#include <stdlib.h>
#include <iostream>
#include <fstream>
#include <cstring>

#ifndef WIN32
#include <dirent.h>
#endif

using namespace std;

void Strip(string &str)
{
    if (str.empty())
        return;

    int start = 0;
    int end = str.length() -1;

    while ((!isalnum(str[start])) && (start < end))
        start++;

    while ((!isalnum(str[end])) && (start < end))
        end--;

    str = str.substr(start, (end - start) + 1);
}

namespace Scenes
{
    string Settings::getDefaultDirectory(void)
    {
        string dir = getenv(ENVVAR);

        return dir + SEPARATOR + DEFAULT_DIRECTORY;
    }

    string Settings::getDefaultFileName(void)
    {
        string retstr = DEFAULT_FILENAME;
        string envvar = ENVVAR;
        string separator = SEPARATOR;

        string dir = getenv(ENVVAR);

        return getDefaultDirectory () + SEPARATOR + retstr;
    }

    string Settings::getHighscoreFileName(void)
    {
        return getDefaultDirectory() + SEPARATOR + HIGHSCORE_FILENAME;
    }

    Settings::Settings(string fileName)
            : fileNameInUse(fileName)
    {
        if (!fileName.empty())
            fileNameInUse = fileName;

        Load();

        installed = true;
#ifndef WIN32
        DIR *d = opendir((string(PACKAGE_DATA_DIR) + SEPARATOR + PACKAGE_NAME).c_str());
        if (d == NULL)
        {
            installed = false;
        }
        else
        {
            closedir(d);
        }
#endif
    }

    void Settings::Save(string fileName)
    {
        ofstream phile;

        phile.open(fileName.c_str());
        if (!phile)
        {
            cerr << "Could not save config in " << fileName << endl;
            return;
        }

        map<string, string>::iterator iter;

        for (iter = cfg.begin(); iter != cfg.end(); ++iter)
        {
            string cfgline = iter->first;
            cfgline.append(":");
            cfgline.append(iter->second);
            cfgline.append("\n");

            phile << cfgline;
        }

        phile.close();
    }

    void Settings::Load()
    {
        ifstream phile;
        phile.open(fileNameInUse.c_str());

        if (!phile)
        {
            return;
        }

        string cfgline;

        while (getline(phile, cfgline))
        {
            int col = cfgline.find_last_of(":");

            if (col == -1)
                continue; // format error

            string name = cfgline.substr(0, col);
            string value = cfgline.substr(col + 1);

            Strip(name);
            Strip(value);

            cfg[name] = value;
        }

        phile.close();
    }

    const string Settings::get(const string name, const string defval)
    {
        if (!cfg.count(name))
            cfg[name] = defval;

        return cfg[name];
    }

    void Settings::set(const string name, const string value)
    {
        cfg[name] = value;
    }

    bool Settings::getb(const string name, bool defval)
    {
        if (!cfg.count(name))
        {
            string val = defval?"TRUE":"FALSE";
            cfg[name] = val;
        }

        bool ret = false;

        char buff[1024];
        //char buff[strlen(cfg[name].c_str()) + 1];
        strcpy(buff, cfg[name].c_str());
        int s = strlen(buff);

        for (int f = 0; f < s; f++)
        {
            buff[f] = toupper(buff[f]);
        }

        if (!strcmp(buff, "TRUE"))
        {
            return true;
        }

        return ret;
    }

    void Settings::setb(const string name, bool value)
    {
        string val = value?"TRUE":"FALSE";
        cfg[name] = val;
    }

    const string Settings::getDataDir()
    {
#ifndef WIN32
        if (installed)
        {
            return string(PACKAGE_DATA_DIR) + SEPARATOR + PACKAGE_NAME;
        }
        else
        {
            return "data";
        }
#else
        return "data";
#endif
    }

    string Settings::getFilename(const string phname)
    {
        return getDataDir() + SEPARATOR + phname;
    }

    const char *Settings::getCFilename(const string phname)
    {
        static char buff[1024];
        strcpy(buff, getFilename(phname).c_str());
        return buff;
    }
}

