print.summary.multiple <- function(object, subset = NULL, ...){
  if (is.null(subset))
    m <- length(object$M)
  else if (any(subset > max(m)))
    stop("the subset selected lies outside the range of available \n        sets of regression output.")
  else
    m <- subset
  cat("\n  Model:", object$zelig)
  cat("\n  Number of subsets evaluated:", m, "\n")
  for (i in 1:m) {
    cat(paste("\nResults for", object$call$by[1], "=", object$lev[i], "\n"))
    print(object[[i]])
    cat("\n")
  }
}

