CS_PACKAGES=\
  libzeroc-ice$(RV)-cil

export MONO_SHARED_DIR=$(CURDIR)
CS_PREFIX=$(CURDIR)/$(DEB_DH_INSTALL_SOURCEDIR)/usr
CS_BINDIR=$(CS_PREFIX)/lib/cli/libzeroc-ice$(RV)

debian/stamp-build-cs:: DEB_MAKE_INVOKE := $(DEB_MAKE_ENVVARS) make \
	PKG_CONFIG_PATH=../../lib/pkgconfig:../lib/pkgconfig:lib/pkgconfig \
	UNAME=$(UNAME) prefix=/usr MCS=/usr/bin/cli-csc -j 4
debian/stamp-build-cs:: debian/stamp-build-cpp
	-mkdir -p cs/bin
	-for i in src demo test ; do \
		find cs/$$i -type d \
			| sed -e 's.generated$$..g' -e 's.$$./generated.g' \
			| xargs mkdir -p ; \
	done
	@if test ! -f $@ ; then \
		$(DEB_MAKE_INVOKE) -C cs all ; \
	fi
	:> $@

debian/stamp-install-cs:: DEB_MAKE_INVOKE := $(DEB_MAKE_ENVVARS) make \
	NOGAC=true UNAME=$(UNAME) \
	prefix=$(CS_PREFIX) \
	install_clibindir=$(CS_BINDIR) \
	install_slicedir=$(CS_PREFIX)/share/Ice-$(V)/slice -j 4
debian/stamp-install-cs::
	-mkdir -p $(CS_BINDIR) $(CS_PREFIX)/share/cli-common/packages.d
	-mkdir -p $(CS_PREFIX)/lib/pkgconfig $(CS_PREFIX)/bin
	@if test ! -f $@ ; then \
		$(DEB_MAKE_INVOKE) -C cs install ; \
	fi
	cp debian/iceboxnet.wrapper $(CS_PREFIX)/bin/iceboxnet-$(RV)
	cp -r debian/pkgconfig $(CS_PREFIX)/lib/
	chmod 755 $(CS_PREFIX)/bin/iceboxnet-$(RV)
	:> $@

.PHONY: build/cs install/cs

build/cs:: debian/stamp-build-cpp debian/stamp-build-cs
install/cs:: debian/stamp-install-cs

$(patsubst %,build/%,$(CS_PACKAGES)) :: build/% : build/cs
$(patsubst %,install/%,$(CS_PACKAGES)) :: install/% : install/cs

binary-predeb/libzeroc-ice$(RV)-cil::
	dh_clifixperms
	dh_makeclilibs -V
	dh_installcligac
	dh_clideps -r
	dh_installdeb

clean::
	-$(MAKE) UNAME=$(UNAME) -C cs clean
	$(RM) debian/stamp-build-cs debian/stamp-install-cs
	# -for i in src demo test ; do \
	#     find cs/$$i -name generated | xargs rm -rf ; \
	# done
	#-$(RM) -r cs/bin $(MONO_SHARED_DIR)/.wapi
