package Zim::Win32;

use strict;
use Win32::Process;

our $VERSION = '0.01';

=head1 NAME

Zim::Win32 - win32 specific routines for zim

=head1 DESCRIPTION

This module contains some routines that are specific
for the windows platform.

=cut

$Zim::DEFAULTS{browser} = 'firefox.exe';
$Zim::DEFAULTS{filebrowser} = 'explorer.exe';

*Zim::_exec = sub {
	my ($self, @args) = @_;
	my ($prog, $cmdline);
	if (@args > 1) {
		$cmdline = join ' ', map {/\s/ ? qq/"$_"/ : $_} @args;
		$prog = $args[0];
	}
	else {
		$cmdline = $args[0];
		$args[0] =~ /^(['"])(.+?)\1|^(\S+)/;
		$prog = $2 || $3;
	}
	$prog = _lookup_exec($self, $prog) unless $prog =~ /\\/;
	return unless $prog;
	
	warn "Executing $prog, $cmdline\n";
	my $ProcessObj;
	Win32::Process::Create(
		$ProcessObj, $prog, $cmdline, 0, NORMAL_PRIORITY_CLASS, "." );
};

sub _lookup_exec {
	my ($self, $prog) = @_;
	for (split /;/, $ENV{PATH}) {
		my $try = File::Spec->catfile($_, $prog);
		return $try if -f $try;
	}
	return $self->error_dialog("Could not find program: $prog");
}

1;

__END__

=head1 AUTHOR

Jaap Karssenberg (Pardus) E<lt>pardus@cpan.orgE<gt>

Copyright (c) 2006 Jaap G Karssenberg. All rights reserved.
This program is free software; you can redistribute it and/or
modify it under the same terms as Perl itself.

=head1 SEE ALSO

=cut

