package Zim::GUI::ExportDialog;

use strict;
use Gtk2;
use File::BaseDir qw/xdg_data_files xdg_data_dirs xdg_data_home/;
use Zim::Selection;
use Zim::GUI::Component;
#use Zim::Formats;

our $VERSION = '0.18';
our @ISA = qw/Zim::GUI::Component/;

=head1 NAME

Zim::GUI::ExportDialog - dialog for zim

=head1 DESCRIPTION

This modules contains the export dialog for zim.
It is autoloaded when needed.

=head1 METHODS

=over 4

=item C<show()>

Present the dialog.

=cut

sub show {
	my $self = shift;
	return $self->{dialog}->present if defined $self->{dialog};
	$self->{app}->save_page || return;

	my $dialog = Gtk2::Dialog->new(
		"Export page - Zim", $self->{app}{window},
	       	[qw/destroy-with-parent no-separator/],
		'gtk-help'   => 'help',
		'gtk-cancel' => 'cancel',
		'gtk-ok'     => 'ok',
	);
	$dialog->set_resizable(0);
	$dialog->vbox->set_border_width(12);
	
	# Page range
	my $frame = Gtk2::Frame->new;
	my $label = Gtk2::Label->new('<b>Pages</b>');
	$label->set_use_markup(1);
	$frame->set_label_widget($label);
	$dialog->vbox->add($frame);
	
	my $vbox = Gtk2::VBox->new(0, 5);
	$vbox->set_border_width(12);
	$frame->add($vbox);
	
	my $radio1 = Gtk2::RadioButton->new_with_mnemonic(undef, '_All');
	my $rgroup = $radio1->get_group;
	$vbox->add($radio1);

	my $hbox = Gtk2::HBox->new(0, 5);
	$vbox->add($hbox);
	
	my $radio2 = Gtk2::RadioButton->new_with_mnemonic($rgroup, '_Page:');
	$hbox->pack_start($radio2, 0,1,0);
	
	my $page_entry = Gtk2::Entry->new();
	$page_entry->set_text( $self->{app}{page}->name );
	$page_entry->set_sensitive(0);
	$hbox->pack_start($page_entry, 0,1,0);

	my $recurs_box = Gtk2::CheckButton->new_with_label('Recursive');
	$recurs_box->set_active(1);
	$recurs_box->set_sensitive(0);	
	$vbox->add($recurs_box);
	
	$radio2->signal_connect( toggled => sub {
		my $active = $radio2->get_active;
		$page_entry->set_sensitive( $active );
		$recurs_box->set_sensitive( $active );
	} );
	
	# Output
	$frame = Gtk2::Frame->new;
	$label = Gtk2::Label->new('<b>Output</b>');
	$label->set_use_markup(1);
	$frame->set_label_widget($label);
	$dialog->vbox->add($frame);
	
	my $table = Gtk2::Table->new(5, 3);
	$table->set_border_width(12);
	$table->set_row_spacings(5);
	$table->set_col_spacings(12);
	$frame->add($table);
	
	my $i;
	for (qw/Format Template/, '', 'Output dir') {
		if (length $_) {
			my $label = Gtk2::Label->new($_.':');
			my $align = Gtk2::Alignment->new(0,0.5, 0,0);
			$align->add($label);
			$table->attach_defaults($align, 0,1, $i,$i+1);
		}
		$i++;
	}

	my $conf = $self->{app}{repository}->config;
	
	my $combo1 = Gtk2::ComboBox->new_text();
	my @formats = qw/Html Txt2Tags/;
	# FIXME use Zim::Formats->list(..) to discover available formats
	$combo1->append_text($_) for @formats;
	my ($if) = grep {lc($formats[$_]) eq $$conf{export_format}} 0..$#formats;
	$combo1->set_active($if || 0);
	$table->attach_defaults($combo1, 1,2, 0,1);
	
	my $combo2 = Gtk2::ComboBox->new_text();
	my $combo2_items = -1;
	my $templates = {};
	$table->attach_defaults($combo2, 1,2, 1,2);

	my $entry2 = Gtk2::Entry->new;
	$table->attach_defaults($entry2, 1,2, 2,3);
	my $button2 = Gtk2::Button->new('_Browse...');
	$button2->signal_connect(clicked => sub {
		my $t = $self->filechooser_dialog();
		$entry2->set_text($t);
	} );
	$table->attach_defaults($button2, 2,3, 2,3);

	my $entry3 = Gtk2::Entry->new;
	$table->attach_defaults($entry3, 1,2, 3,4);
	$entry3->set_text($$conf{export_dir});
	$entry3->signal_connect(activate => sub { $dialog->response('ok') });
	my $button3 = Gtk2::Button->new('_Browse...');
	$button3->signal_connect(clicked => sub {
		my $dir = $entry3->get_text;
		$dir = $self->filechooser_dialog($dir, 'DIR');
		$entry3->set_text($dir);
	} );
	$table->attach_defaults($button3, 2,3, 3,4);
	
	my $fill_combo2 = sub {
		my $format = _get_active_text($combo1);
		for (reverse 0 .. $combo2_items) { $combo2->remove_text($_) }
		$templates = Zim::Formats->list_templates($format);
		for (sort keys %$templates) {
			if (/^default$/i) { $combo2->prepend_text($_) }
			else              { $combo2->append_text($_)  }
		}
		$combo2_items = scalar keys %$templates;
		$combo2->append_text('other...');
		$combo2->set_active(0);
		my $other = ($combo2_items == 0);
		$entry2->set_sensitive($other);
		$button2->set_sensitive($other);
	};
	$fill_combo2->(); # initialize

	$combo1->signal_connect(changed => $fill_combo2);
	$combo2->signal_connect(changed => sub {
		my $other = ($combo2->get_active == $combo2_items) ; # "other" item
		$entry2->set_sensitive($other);
		$button2->set_sensitive($other);
	} );

	if ($$conf{export_template} =~ /[\/\\]/) {
		$entry2->set_text($$conf{export_template});
		$combo2->set_active($combo2_items); # other;
	}
	else {
		my @t = sort keys %$templates;
		my ($j) = grep {lc($t[$_]) eq lc($$conf{export_template})} 0..$#t;
		$combo2->set_active($j || 0);
	}

	$frame = Gtk2::Frame->new;
	$label = Gtk2::Label->new('<b>Media</b>');
	$label->set_use_markup(1);
	$frame->set_label_widget($label);
	$dialog->vbox->add($frame);
	
	$vbox = Gtk2::VBox->new(0, 5);
	$vbox->set_border_width(12);
	$frame->add($vbox);
	
	my $media_radio1 = Gtk2::RadioButton->new_with_mnemonic(undef, '_Relative linked');
	$rgroup = $media_radio1->get_group;
	$vbox->add($media_radio1);

	my $media_radio2 = Gtk2::RadioButton->new_with_mnemonic($rgroup, '_Absolute linked');
	$vbox->add($media_radio2);

	my $media_radio3 = Gtk2::RadioButton->new_with_mnemonic($rgroup, '_Copy files');
	$vbox->add($media_radio3);
	my $media_r = ($$conf{export_media} eq 'absolute') ? $media_radio2 :
	              ($$conf{export_media} eq 'copy')     ? $media_radio3 :
		      $media_radio1;
	$media_r->set_active(1);

	# Run dialog
	$self->{dialog} = $dialog;
	$dialog->show_all;
	while ($_ = $dialog->run) {
		if ($_ eq 'help') {
			$self->ShowHelp(':zim:usage:exporting');
			next;
		}
		
		last unless $_ eq 'ok';
		
		# TODO, resolve page here !
		# and resolve page in zim.pl sub export
		my @pages = $radio1->get_active ? (':') : (
			grep length($_),
			split /,\s*|\s+/, $page_entry->get_text ) ;
		last unless @pages;
		
		my ($tn, $template);
		if ($entry2->is_sensitive) { # free input
			$template = $entry2->get_text;
			$template = './'.$template unless $template =~ /[\/\\]/;
			$tn = $template;
		}
		else {
			$tn = _get_active_text($combo2);
			$template = $$templates{$tn};
		}

		my $media =
			$media_radio2->get_active ? 'absolute' :
			$media_radio3->get_active ? 'copy'     : 'relative' ;

		my %opts = (
			format   => lc _get_active_text($combo1),
			dir      => $entry3->get_text,
			template => $template,
			media    => $media,
		);
		@$conf{qw/export_dir export_format export_media/}
			= @opts{qw/dir format media/};
		$$conf{'export_template'} = $tn;
		$dialog->destroy;
		$self->{dialog} = undef;
		my ($bar, $label);
		($dialog, $bar, $label) = $self->new_progress_bar(
			"Export page - Zim", "Exporting page 1" );
		my $continue = 1;
		$dialog->signal_connect(response => sub {$continue = 0});
		my $i = 1;
		$opts{callback} = sub {
			$bar->pulse;
			$label->set_text('Exporting page ' . $i++);
			while (Gtk2->events_pending) { Gtk2->main_iteration_do(0) }
			return $continue;
		};
		
		eval {
			my $o = { resolve => 1, recurse => $recurs_box->get_active() };
			my $s = Zim::Selection->new(
				$self->{app}{repository}, $o, @pages);
			$s->export(\%opts);
		};
		$self->error_dialog($@) if $@;

		$self->{app}{repository}->save(); # save settings
		
		last;
	}
	$dialog->destroy;
	$self->{dialog} = undef;
}

sub _get_active_text {
	my $combo = shift;
	if (Gtk2->CHECK_VERSION(2, 6, 0)) {
		return $combo->get_active_text;
	}
	else {
		my $iter = $combo->get_active_iter;
		return ( ($combo->get_model->get($iter))[0] );
	}
}

=item C<hide()>

Delete the dialog.

=cut

sub hide {
	return unless $_[0]->{dialog};
	$_[0]->{dialog}->destroy;
	$_[0]->{dialog} = undef;
}

1;

__END__

=back

=head1 AUTHOR

Jaap Karssenberg (Pardus) E<lt>pardus@cpan.orgE<gt>

Copyright (c) 2006 Jaap G Karssenberg. All rights reserved.
This program is free software; you can redistribute it and/or
modify it under the same terms as Perl itself.

=head1 SEE ALSO

=cut

