
use strict;

my $app = Zim::GUI->current;

my $null = File::Spec->devnull;
system("scrot -v > $null") == 0
	or die 'Can not find application "scrot"';

return 1 if $app->{read_only};

$app->{actions}->add_actions( [
	[	'InsertScreenshot',
		'',
		'_Screenshot...',
		'',
		'Insert screenshot',
		\&InsertScreenshot,
	],
] );

$app->{ui}->add_ui_from_string( q{
<ui>
	<menubar name='MenuBar'>
		<menu action='InsertMenu'>
			<placeholder name='PluginItems'>
				<menuitem action='InsertScreenshot'/>
			</placeholder>
		</menu>
	</menubar>
</ui> } );

sub InsertScreenshot {
	my $dir = $app->{page}->properties->{base};
	$dir .= '/' . $app->{page}->basename;
		# FIXME FIXME need proper interface to determine this dir
	
	## Generate file name	
	my $file = "screenshot_01.png";
	my $i = 1;
	while (-e "$dir/$file") {
		$file = sprintf('screenshot_%02d.png', ++$i);
	}

	## Show dialog
	my $dialog = Gtk2::Dialog->new(
		"Insert Screenshot - Zim", $app->{window},
	       	[qw/modal destroy-with-parent/],
		'gtk-cancel' => 'cancel',
		'gtk-ok'     => 'ok',
	);
	$dialog->vbox->set_border_width(12);
	#my $hbox = Gtk2::HBox->new;
	#$dialog->vbox->add($hbox);
	#$hbox->add( Gtk2::Label->new('Name: ') );
	#my $name_entry = Gtk2::Entry->new;
	#$name_entry->set_text($file);
	#$hbox->add($name_entry);
	my $all = Gtk2::RadioButton->new(undef, 'Capture whole screen');
	my $win = Gtk2::RadioButton->new($all, 'Select window or region');
	$dialog->vbox->add($_) for $all, $win;
	my $hbox = Gtk2::HBox->new;
	$dialog->vbox->add($hbox);
	$hbox->add( Gtk2::Label->new('Delay: ') );
	my $spin = Gtk2::SpinButton->new_with_range(0, 99, 1);
	$hbox->add($spin);
	$hbox->add( Gtk2::Label->new(' seconds') );

	$dialog->show_all;
	my $re = $dialog->run;
	$dialog->destroy;
	return unless $re eq 'ok';

	my $delay = $spin->get_value_as_int;
	my $select = $win->get_active;
	#my $f = $name_entry->get_text;
	#$file = $f if $f =~ /\S/;
	#$file .= '.png' unless $file =~ /\.\w+/;

	## Run scrot
	Zim::File->make_dir($dir);
	my @app = ('scrot');
	push @app, '-d', $delay if $delay;
	push @app, ($select ? ('-s', '-b') : ('-m'));
	warn "Running: @app $dir/$file\n";
	system(@app, "$dir/$file") == 0
		or return $app->error_dialog("Failed to execute scrot: $!");
	$app->PageView->InsertImage("$dir/$file", 'NO_ASK');
}

