/*____________________________________________________________________________

   Zinf - Zinf Is Not FreeA*p (The Free MP3 Player)

   Copyright (C) 1999-2000 EMusic

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

   $Id: GTKFont.cpp,v 1.8 2003/09/16 17:36:23 kgk Exp $
____________________________________________________________________________*/ 

#include <sys/stat.h>
#include <unistd.h>
#include <sys/types.h>
#include <dirent.h>
#include <string>

using namespace std;
#include "path_max.h"
#include "GTKFont.h"
#include "GTKUtility.h"
#include "win32impl.h"
#include "utility.h"

#ifdef __QNX__
#include <strings.h>
#endif

GTKFont::GTKFont(FAContext *context, string &oName, string &oFace, 
                 string &oFile, string &oDefault) :
                Font(oName, oFace, oFile, oDefault)
{
    m_context = context;
    gdk_threads_enter();
    pango_context = gdk_pango_context_get();
    gdk_threads_leave();
    m_oFace = oFace;
    m_oName = oName;
    m_oFile = oFile;
    m_oDefault = oDefault;
    pfont = NULL;
    layout = NULL;
    bold = false;
    size=0;
    italic = false;
    underline = false;
    first = true;
}

GTKFont::GTKFont(GTKFont &f) : Font(f)
{
    m_context = f.m_context;
    gdk_threads_enter();
    pango_context = gdk_pango_context_get();
    gdk_threads_leave();
    m_oFace = f.m_oFace;
    m_oName = f.m_oName;
    m_oFile = f.m_oFile;
    m_oDefault = f.m_oDefault;
    pfont = NULL;
    layout = NULL;
    bold = false;
    size=0;
    italic = false;
    underline = false;
    first = true;
}


Error GTKFont::AddFont(string &oFontFile)
{
  //  cerr << "AddFont(" << oFontFile << ")" <<endl;
//     string oFontDest;
//     char fcopy[_MAX_PATH], *filename, *ext;
//     struct stat st;
//     string tempfile;

//     char *fadir = ZinfDir(NULL);
//     oFontDest = string(fadir) + string ("/fonts");
//     delete [] fadir;

//     if (-1 == stat(oFontDest.c_str(), &st))
//         mkdir(oFontDest.c_str(), 0755);

//     strcpy(fcopy, oFontFile.c_str());
//     filename = strrchr(fcopy, '/');
//     if (filename) 
//         filename = filename + 1;
//     ext = strrchr(filename, '.');
//     if (ext) {
//         *ext = '\0';
//         ext++;
//     }

//     tempfile = oFontFile;
//     if (-1 == stat(tempfile.c_str(), &st)) 
//         tempfile = FindFile(tempfile);
         
//     oFontDest += string("/") + string(filename);
//     if (ext)
//         oFontDest += string(".") + string(ext);

//     CopyFile(tempfile.c_str(), oFontDest.c_str(), true);

//     m_oFace = oFontDest;

    return kError_NoErr;
}
    
Error GTKFont::Load(int iFontHeight, bool bBold, bool bItalic)
{
  gdk_threads_enter();
  if (pfont==NULL)
        layout = pango_layout_new(pango_context);
  if (bold != bBold || italic != bItalic || size != iFontHeight) {
      bold = bBold;
      italic = bItalic;
      size = iFontHeight;
      if (pfont)
	pango_font_description_free(pfont);
      string fontname = BuildFontString(bold, italic, size-1);
      pfont = pango_font_description_from_string(fontname.c_str());
      if (!pfont) {
	pfont = pango_font_description_from_string("sans");  
	if (!pfont) {
	  gdk_threads_leave();
	  //cout << "oops, couldn't load _any_ fonts...\n";
	  return kError_YouScrewedUp;
	}
      }
      pango_context_load_font(pango_context, pfont);
      pango_layout_set_font_description (layout, pfont);
      pango_layout_context_changed(layout);
  }
  
  gdk_threads_leave();
  return kError_NoErr;
}

int GTKFont::GetLength(string &oText)
{
    int retvalue = 0;
    gdk_threads_enter();
    pango_layout_set_text(layout, oText.c_str(), -1);
    pango_layout_get_pixel_size (layout, &retvalue, NULL);
    gdk_threads_leave();
    return retvalue;

}

int GTKFont::GetHeight(string &oText)
{
    int retvalue = 0;
    gdk_threads_enter();
    pango_layout_set_text(layout, oText.c_str(), -1);
    pango_layout_get_pixel_size (layout, NULL, &retvalue);
    gdk_threads_leave();
    return retvalue;
}

void GTKFont::Render(Rect &oClipRect, string &oText, int iOffset, 
                     const Color &oColor, GTKBitmap *bitmap, bool bUnderline)
{
    if (!bitmap->GetBitmap())
        return;

    gdk_threads_enter();
    GdkGC *gc = gdk_gc_new((GdkWindow *)bitmap->GetBitmap());
    gdk_rgb_gc_set_foreground(gc, (oColor.red << 16) | (oColor.green << 8) |
                              oColor.blue);

    GdkRectangle clipRect;
    clipRect.x = oClipRect.x1;
    clipRect.y = oClipRect.y1;
    clipRect.width = oClipRect.Width();
    clipRect.height = oClipRect.Height() + 1;

    gdk_gc_set_clip_rectangle(gc, &clipRect);

    pango_layout_set_text(layout,oText.c_str(),-1);
    gdk_draw_layout(bitmap->GetBitmap(), gc, 
		    oClipRect.x1 + iOffset, 
		    oClipRect.y1 - 3,
		    layout);

    gdk_flush();
    gdk_gc_unref(gc);
    gdk_threads_leave();

    return;
}

string GTKFont::BuildFontString(bool bBold, bool bItalic, int iFontHeight)
{
   string retstring = m_oFace;
   if (bBold)
       retstring += string(" bold");

   if (bItalic)
       retstring += string(" italic");

   char tempstr[16];
   sprintf(tempstr, " %d", iFontHeight);
   retstring += string(tempstr);
   return retstring;
}

GTKFont::~GTKFont(void)
{
  gdk_threads_enter();
  if (pfont)
    {
      pango_font_description_free(pfont);
      pfont=NULL;
    }
  //what else do we need to free here? layout, context?
  //shot in the dark. is this right?
  if (G_IS_OBJECT(layout))
    g_object_unref(layout);
  //  if (G_IS_OBJECT(pango_context))
  g_free(pango_context);
  gdk_threads_leave();
}

/* arch-tag: 91f84ce1-ed64-4a31-804b-fcea03654e08
   (do not change this comment) */
