/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.discovery.util;

import java.io.InputStream;
import java.net.URL;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DiscoveryBuildInfo {
    private static final Logger logger = LoggerFactory.getLogger(DiscoveryBuildInfo.class);
    private static final DiscoveryBuildInfo INSTANCE = new DiscoveryBuildInfo(DiscoveryBuildInfo.class);
    private final Manifest manifest;

    DiscoveryBuildInfo(Class<?> clazz) {
        Manifest resolvedManifest = null;
        try {
            String jarUrl = DiscoveryBuildInfo.resolveJarUrl(clazz);
            if (jarUrl != null) {
                resolvedManifest = DiscoveryBuildInfo.loadManifest(jarUrl);
            }
        }
        catch (Throwable e) {
            logger.warn("Cannot load eureka-client manifest file; no build meta data are available", e);
        }
        this.manifest = resolvedManifest;
    }

    String getBuildVersion() {
        return this.getManifestAttribute("Implementation-Version", "<version_unknown>");
    }

    String getManifestAttribute(String name, String defaultValue) {
        if (this.manifest == null) {
            return defaultValue;
        }
        Attributes.Name attrName = new Attributes.Name(name);
        Object value = this.manifest.getMainAttributes().get(attrName);
        return value == null ? defaultValue : value.toString();
    }

    public static String buildVersion() {
        return INSTANCE.getBuildVersion();
    }

    private static Manifest loadManifest(String jarUrl) throws Exception {
        try (InputStream is = new URL(jarUrl + "!/META-INF/MANIFEST.MF").openStream();){
            Manifest manifest = new Manifest(is);
            return manifest;
        }
    }

    private static String resolveJarUrl(Class<?> clazz) {
        Matcher matcher;
        URL location = clazz.getResource('/' + clazz.getName().replace('.', '/') + ".class");
        if (location != null && (matcher = Pattern.compile("(jar:file.*-[\\d.]+(-rc[\\d]+|-SNAPSHOT)?.jar)!.*$").matcher(location.toString())).matches()) {
            return matcher.group(1);
        }
        return null;
    }
}

