#import "ExpectationListTest.h"

@implementation ExpectationListTest

- (void)testSingleUnsuccessfulExpectation {
    ExpectationList *expectationList = [[[ExpectationList alloc] initWithName:@"My Expectations"] autorelease];
    NSException *exception = nil;

    [expectationList addExpectedObject:@"Hello, world!"];

    NS_DURING
        [expectationList verify];
    NS_HANDLER
        exception = localException;
    NS_ENDHANDLER

    [self assertNotNil:exception message:@"Should raise exception"];
    [self assertString:[exception name] equals:@"AssertionFailedException"];
    [self assertString:[exception reason] equals:@"My Expectations expected (\"Hello, world!\"), was ()"];
}

- (void)testSingleSucccessfulExpectation {
    ExpectationList *expectationList = [[[ExpectationList alloc] initWithName:@"My Expectations"] autorelease];

    [expectationList addExpectedObject:@"Hello, world!"];
    [expectationList addActualObject:@"Hello, world!"];

    NS_DURING
        [expectationList verify];
    NS_HANDLER
        [self fail:@"Should not raise exception"];
    NS_ENDHANDLER
}

- (void)testSingleExpectationDoesntMatchActual {
    ExpectationList *expectationList = [[[ExpectationList alloc] initWithName:@"My Expectations"] autorelease];
    NSException *exception = nil;

    [expectationList addExpectedObject:@"I expected this!"];

    NS_DURING
        [expectationList addActualObject:@"But got this!"];
    NS_HANDLER
        exception = localException;
    NS_ENDHANDLER

    [self assertNotNil:exception message:@"Should raise exception"];
    [self assertString:[exception name] equals:@"AssertionFailedException"];
    [self assertString:[exception reason] equals:@"My Expectations expected I expected this!, was But got this!"];
}

- (void)testMultipleExpectationDoesntMatchActual {
    ExpectationList *expectationList = [[[ExpectationList alloc] initWithName:@"My Expectations"] autorelease];
    NSException *exception = nil;

    [expectationList addExpectedObject:@"One"];
    [expectationList addExpectedObject:@"Two"];
    [expectationList addExpectedObject:@"Three"];

    [expectationList addActualObject:@"One"];

    NS_DURING
        [expectationList addActualObject:@"Three"];
    NS_HANDLER
        exception = localException;
    NS_ENDHANDLER

    [self assertNotNil:exception message:@"Should raise exception"];
    [self assertString:[exception name] equals:@"AssertionFailedException"];
    [self assertString:[exception reason] equals:@"My Expectations expected Two, was Three"];
}

- (void)testFailOnVerify {
    ExpectationList *expectationList = [[[ExpectationList alloc] initWithName:@"My Expectations"] autorelease];
    NSException *exception = nil;

    [expectationList addExpectedObject:@"I expected this!"];

    [expectationList setFailsOnVerify:YES];

    NS_DURING
        [expectationList addActualObject:@"But got this!"];
    NS_HANDLER
        [self fail:@"Should not raise exception"];
    NS_ENDHANDLER

    NS_DURING
        [expectationList verify];
    NS_HANDLER
        exception = localException;
    NS_ENDHANDLER

    [self assertNotNil:exception message:@"Should raise exception"];
    [self assertString:[exception name] equals:@"AssertionFailedException"];
    [self assertString:[exception reason] equals:@"My Expectations expected (\"I expected this!\"), was (\"But got this!\")"];
}

- (void)testExpectSelector {
    ExpectationList *expectationList = [[[ExpectationList alloc] initWithName:@"My Expectations"] autorelease];
    NSException *exception = nil;

    [expectationList addExpectedSelector:@selector(invoked:)];
    [expectationList addExpectedSelector:@selector(notInvoked:)];

    [expectationList addActualSelector:@selector(invoked:)];

    NS_DURING
        [expectationList verify];
    NS_HANDLER
        exception = localException;
    NS_ENDHANDLER

    [self assertNotNil:exception message:@"Should raise exception"];
    [self assertString:[exception name] equals:@"AssertionFailedException"];
    [self assertString:[exception reason] equals:@"My Expectations expected (\"selector -invoked:\", \"selector -notInvoked:\"), was (\"selector -invoked:\")"];
}

- (void)testVerifyPassesOnNoExpectations {
    ExpectationList *expectationList = [[[ExpectationList alloc] initWithName:@"My Expectations"] autorelease];

    NS_DURING
        [expectationList verify];
    NS_HANDLER
        [self fail:@"Shouldn't raise exception"];
    NS_ENDHANDLER
}

- (void)testAddActualPassesOnNoExpectations {
    ExpectationList *expectationList = [[[ExpectationList alloc] initWithName:@"My Expectations"] autorelease];

    NS_DURING
        [expectationList addActualObject:@"Unexpected"];
    NS_HANDLER
        [self fail:@"Shouldn't raise exception"];
    NS_ENDHANDLER
}

- (void)testVerifyPassesAfterAddActualOnNoExpectations {
    ExpectationList *expectationList = [[[ExpectationList alloc] initWithName:@"My Expectations"] autorelease];

    [expectationList addActualObject:@"Unexpected"];

    NS_DURING
        [expectationList verify];
    NS_HANDLER
        [self fail:@"Shouldn't raise exception"];
    NS_ENDHANDLER
}

@end
