#import "TestCaseTest.h"

#import "MockTestCase.h"

@interface TestCaseTest (Privates)
- (void)verifyError:(TestCase *)test;
- (void)verifySuccess:(TestCase *)test;
- (void)verifyFailure:(TestCase *)test;
@end

@implementation TestCaseTest

- (void)testName {
    [self assertString:[self name] equals:@"testName"];
}

- (void)testCountTestCases {
    [self assertInt:[self countTestCases] equals:1];
}

- (void)testDescription {
    [self assertString:[self description] equals:@"testDescription(TestCaseTest)"];
}

- (void)testError {
    MockTestCase *error = [MockTestCase testWithName:@"error"];
    error->runTestRaisesException = YES;
    [self verifyError:error];
}

- (void)testRunAndTearDownRaisesException {
    MockTestCase *error = [MockTestCase testWithName:@"error"];
    error->runTestRaisesException = YES;
    error->tearDownRaisesException = YES;
    [self verifyError:error];
    [self assertTrue:error->isTornDown];
}

- (void)testSetUpRaisesException {
    MockTestCase *error = [MockTestCase testWithName:@"error"];
    error->setUpRaisesException = YES;
    [self verifyError:error];
}

- (void)testSuccess {
    MockTestCase *success = [MockTestCase testWithName:@"success"];
    [self verifySuccess:success];
}

- (void)testFailure {
    MockTestCase *failure = [MockTestCase testWithName:@"failure"];
    failure->runTestFails = YES;
    [self verifyFailure:failure];
}

- (void)testTearDownAfterError {
    MockTestCase *error = [MockTestCase testWithName:@"error"];
    error->runTestRaisesException = YES;
    [self verifyError:error];
    [self assertTrue:error->isTornDown];
}

- (void)testTearDownRaisesException {
    MockTestCase *error = [MockTestCase testWithName:@"error"];
    error->tearDownRaisesException = YES;
    [self verifyError:error];
}

- (void)testNoTearDownSetUpRaisesException {
    MockTestCase *error = [MockTestCase testWithName:@"error"];
    error->setUpRaisesException = YES;
    [self verifyError:error];
    [self assertTrue:!error->isTornDown];
}

- (void)testWasRun {
    MockTestCase *test = [MockTestCase testWithName:@""];
    [test run];
    [self assertTrue:test->wasRun];
}

@end

@implementation TestCaseTest (Privates)

- (void)verifyError:(TestCase *)test {
    TestResult *result = [test run];
    [self assertInt:[result numberOfTestsRun] equals:1];
    [self assertInt:[result numberOfFailures] equals:0];
    [self assertInt:[result numberOfErrors] equals:1];
}

- (void)verifySuccess:(TestCase *)test {
    TestResult *result = [test run];
    [self assertInt:[result numberOfTestsRun] equals:1];
    [self assertInt:[result numberOfFailures] equals:0];
    [self assertInt:[result numberOfErrors] equals:0];
}

- (void)verifyFailure:(TestCase *)test {
    TestResult *result = [test run];
    [self assertInt:[result numberOfTestsRun] equals:1];
    [self assertInt:[result numberOfFailures] equals:1];
    [self assertInt:[result numberOfErrors] equals:0];
}

@end
