/*
 * Copyright (C) 2004-2007  See the AUTHORS file for details.
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 as published
 * by the Free Software Foundation.
 */

#ifndef _NICK_H
#define _NICK_H

#include "String.h"
#include <vector>
#include <set>
using std::vector;
using std::set;

// Forward Decl
class CUser;
class CChan;
// !Forward Decl

class CNick
{
public:
	CNick();
	CNick(const CString& sNick);
	virtual ~CNick();

	void Reset();
	void Parse(const CString& sNickMask);
	CString GetHostMask() const;
	unsigned int GetCommonChans(vector<CChan*>& vChans, CUser* pUser) const;
	static CString Concat(const CString& sNick, const CString& sSuffix, unsigned int uMaxNickLen = 9);

	// Setters
	void SetUser(CUser* pUser);
	void UpdatePermChar();
	void SetPermChar(char c);
	void SetNick(const CString& s);
	void SetIdent(const CString& s);
	void SetHost(const CString& s);
	bool AddPerm(unsigned char uPerm);
	bool RemPerm(unsigned char uPerm);
	// !Setters

	// Getters
	const set<unsigned char>& GetChanPerms() const;
	CString GetPermStr() const;
	unsigned char GetPermChar() const;
	bool HasPerm(unsigned char uPerm) const;
	const CString& GetNick() const;
	const CString& GetIdent() const;
	const CString& GetHost() const;
	CString GetNickMask() const;
	// !Getters
private:
protected:
	set<unsigned char>	m_suChanPerms;
	unsigned char		m_cPerm;
	CUser*				m_pUser;
	CString				m_sNick;
	CString				m_sIdent;
	CString				m_sHost;
};

#endif // !_NICK_H
