/*
 * Copyright (C) 2004-2016 ZNC, see the NOTICE file for details.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * Parts of SWIG are used here.
 */

/***************************************************************************
 * This file is generated automatically using codegen.pl from functions.in *
 * Don't change it manually.                                               *
 ***************************************************************************/

namespace {
/*	template<class T>
	struct pyobj_to_ptr {
		CString m_sType;
		SvToPtr(const CString& sType) {
			m_sType = sType;
		}
		bool operator()(PyObject* py, T** result) {
			T* x = nullptr;
			int res = SWIG_ConvertPtr(sv, (void**)&x, SWIG_TypeQuery(m_sType.c_str()), 0);
			if (SWIG_IsOK(res)) {
				*result = x;
				return true;
			}
			DEBUG("modpython: ");
			return false;
		}
	};

	CModule::EModRet SvToEModRet(PyObject* py, CModule::EModRet* result) {
		long int x = PyLong_AsLong();
		return static_cast<CModule::EModRet>(SvUV(sv));
	}*/

	inline swig_type_info* SWIG_pchar_descriptor(void) {
		static int init = 0;
		static swig_type_info* info = 0;
		if (!init) {
			info = SWIG_TypeQuery("_p_char");
			init = 1;
		}
		return info;
	}

	inline int SWIG_AsCharPtrAndSize(PyObject *obj, char** cptr, size_t* psize, int *alloc) {
#if PY_VERSION_HEX>=0x03000000
		if (PyUnicode_Check(obj))
#else
			if (PyString_Check(obj))
#endif
			{
				char *cstr; Py_ssize_t len;
#if PY_VERSION_HEX>=0x03000000
				if (!alloc && cptr) {
					/* We can't allow converting without allocation, since the internal
					   representation of string in Python 3 is UCS-2/UCS-4 but we require
					   a UTF-8 representation.
					   TODO(bhy) More detailed explanation */
					return SWIG_RuntimeError;
				}
				obj = PyUnicode_AsUTF8String(obj);
				PyBytes_AsStringAndSize(obj, &cstr, &len);
				if(alloc) *alloc = SWIG_NEWOBJ;
#else
				PyString_AsStringAndSize(obj, &cstr, &len);
#endif
				if (cptr) {
					if (alloc) {
						/*
						   In python the user should not be able to modify the inner
						   string representation. To warranty that, if you define
						   SWIG_PYTHON_SAFE_CSTRINGS, a new/copy of the python string
						   buffer is always returned.

						   The default behavior is just to return the pointer value,
						   so, be careful.
						 */
#if defined(SWIG_PYTHON_SAFE_CSTRINGS)
						if (*alloc != SWIG_OLDOBJ)
#else
							if (*alloc == SWIG_NEWOBJ)
#endif
							{
								*cptr = (char *)memcpy((char *)malloc((len + 1)*sizeof(char)), cstr, sizeof(char)*(len + 1));
								*alloc = SWIG_NEWOBJ;
							}
							else {
								*cptr = cstr;
								*alloc = SWIG_OLDOBJ;
							}
					} else {
#if PY_VERSION_HEX>=0x03000000
						assert(0); /* Should never reach here in Python 3 */
#endif
						*cptr = SWIG_Python_str_AsChar(obj);
					}
				}
				if (psize) *psize = len + 1;
#if PY_VERSION_HEX>=0x03000000
				Py_XDECREF(obj);
#endif
				return SWIG_OK;
			} else {
				swig_type_info* pchar_descriptor = SWIG_pchar_descriptor();
				if (pchar_descriptor) {
					void* vptr = 0;
					if (SWIG_ConvertPtr(obj, &vptr, pchar_descriptor, 0) == SWIG_OK) {
						if (cptr) *cptr = (char *) vptr;
						if (psize) *psize = vptr ? (strlen((char *)vptr) + 1) : 0;
						if (alloc) *alloc = SWIG_OLDOBJ;
						return SWIG_OK;
					}
				}
			}
		return SWIG_TypeError;
	}

	inline int SWIG_AsPtr_CString (PyObject * obj, CString **val) {
		char* buf = 0 ; size_t size = 0; int alloc = SWIG_OLDOBJ;
		if (SWIG_IsOK((SWIG_AsCharPtrAndSize(obj, &buf, &size, &alloc)))) {
			if (buf) {
				if (val) *val = new CString(buf, size - 1);
				if (alloc == SWIG_NEWOBJ) delete[] buf;
				return SWIG_NEWOBJ;
			} else {
				if (val) *val = 0;
				return SWIG_OLDOBJ;
			}
		} else {
			static int init = 0;
			static swig_type_info* descriptor = 0;
			if (!init) {
				descriptor = SWIG_TypeQuery("CString" " *");
				init = 1;
			}
			if (descriptor) {
				CString *vptr;
				int res = SWIG_ConvertPtr(obj, (void**)&vptr, descriptor, 0);
				if (SWIG_IsOK(res) && val) *val = vptr;
				return res;
			}
		}
		return SWIG_ERROR;
	}
}

bool CPyModule::OnBoot() {
	PyObject* pyName = Py_BuildValue("s", "OnBoot");
	if (!pyName) {
		CString sPyErr = m_pModPython->GetPyExceptionStr();
		DEBUG("modpython: " << (GetUser() ? GetUser()->GetUserName() : CString("<no user>")) << "/" << GetModName() << "/OnBoot: can't convert string 'OnBoot' to PyObject: " << sPyErr);
		return CModule::OnBoot();
	}
	PyObject* pyRes = PyObject_CallMethodObjArgs(m_pyObj, pyName, nullptr);
	if (!pyRes) {
		CString sPyErr = m_pModPython->GetPyExceptionStr();
		DEBUG("modpython: " << (GetUser() ? GetUser()->GetUserName() : CString("<no user>")) << "/" << GetModName() << "/OnBoot failed: " << sPyErr);
		Py_CLEAR(pyName);
		return CModule::OnBoot();
	}
	Py_CLEAR(pyName);
	bool result;
	if (pyRes == Py_None) {
		result = CModule::OnBoot();
	} else {
		int x = PyObject_IsTrue(pyRes);
		if (-1 == x) {
			CString sPyErr = m_pModPython->GetPyExceptionStr();
			DEBUG("modpython: " << (GetUser() ? GetUser()->GetUserName() : CString("<no user>")) << "/" << GetModName() << "/OnBoot was expected to return EModRet but: " << sPyErr);
			result = CModule::OnBoot();
		} else result = x ? true : false;
	}
	Py_CLEAR(pyRes);
	return result;
}

bool CPyModule::WebRequiresLogin() {
	PyObject* pyName = Py_BuildValue("s", "WebRequiresLogin");
	if (!pyName) {
		CString sPyErr = m_pModPython->GetPyExceptionStr();
		DEBUG("modpython: " << (GetUser() ? GetUser()->GetUserName() : CString("<no user>")) << "/" << GetModName() << "/WebRequiresLogin: can't convert string 'WebRequiresLogin' to PyObject: " << sPyErr);
		return CModule::WebRequiresLogin();
	}
	PyObject* pyRes = PyObject_CallMethodObjArgs(m_pyObj, pyName, nullptr);
	if (!pyRes) {
		CString sPyErr = m_pModPython->GetPyExceptionStr();
		DEBUG("modpython: " << (GetUser() ? GetUser()->GetUserName() : CString("<no user>")) << "/" << GetModName() << "/WebRequiresLogin failed: " << sPyErr);
		Py_CLEAR(pyName);
		return CModule::WebRequiresLogin();
	}
	Py_CLEAR(pyName);
	bool result;
	if (pyRes == Py_None) {
		result = CModule::WebRequiresLogin();
	} else {
		int x = PyObject_IsTrue(pyRes);
		if (-1 == x) {
			CString sPyErr = m_pModPython->GetPyExceptionStr();
			DEBUG("modpython: " << (GetUser() ? GetUser()->GetUserName() : CString("<no user>")) << "/" << GetModName() << "/WebRequiresLogin was expected to return EModRet but: " << sPyErr);
			result = CModule::WebRequiresLogin();
		} else result = x ? true : false;
	}
	Py_CLEAR(pyRes);
	return result;
}

bool CPyModule::WebRequiresAdmin() {
	PyObject* pyName = Py_BuildValue("s", "WebRequiresAdmin");
	if (!pyName) {
		CString sPyErr = m_pModPython->GetPyExceptionStr();
		DEBUG("modpython: " << (GetUser() ? GetUser()->GetUserName() : CString("<no user>")) << "/" << GetModName() << "/WebRequiresAdmin: can't convert string 'WebRequiresAdmin' to PyObject: " << sPyErr);
		return CModule::WebRequiresAdmin();
	}
	PyObject* pyRes = PyObject_CallMethodObjArgs(m_pyObj, pyName, nullptr);
	if (!pyRes) {
		CString sPyErr = m_pModPython->GetPyExceptionStr();
		DEBUG("modpython: " << (GetUser() ? GetUser()->GetUserName() : CString("<no user>")) << "/" << GetModName() << "/WebRequiresAdmin failed: " << sPyErr);
		Py_CLEAR(pyName);
		return CModule::WebRequiresAdmin();
	}
	Py_CLEAR(pyName);
	bool result;
	if (pyRes == Py_None) {
		result = CModule::WebRequiresAdmin();
	} else {
		int x = PyObject_IsTrue(pyRes);
		if (-1 == x) {
			CString sPyErr = m_pModPython->GetPyExceptionStr();
			DEBUG("modpython: " << (GetUser() ? GetUser()->GetUserName() : CString("<no user>")) << "/" << GetModName() << "/WebRequiresAdmin was expected to return EModRet but: " << sPyErr);
			result = CModule::WebRequiresAdmin();
		} else result = x ? true : false;
	}
	Py_CLEAR(pyRes);
	return result;
}

CString CPyModule::GetWebMenuTitle() {
	PyObject* pyName = Py_BuildValue("s", "GetWebMenuTitle");
	if (!pyName) {
		CString sPyErr = m_pModPython->GetPyExceptionStr();
		DEBUG("modpython: " << (GetUser() ? GetUser()->GetUserName() : CString("<no user>")) << "/" << GetModName() << "/GetWebMenuTitle: can't convert string 'GetWebMenuTitle' to PyObject: " << sPyErr);
		return CModule::GetWebMenuTitle();
	}
	PyObject* pyRes = PyObject_CallMethodObjArgs(m_pyObj, pyName, nullptr);
	if (!pyRes) {
		CString sPyErr = m_pModPython->GetPyExceptionStr();
		DEBUG("modpython: " << (GetUser() ? GetUser()->GetUserName() : CString("<no user>")) << "/" << GetModName() << "/GetWebMenuTitle failed: " << sPyErr);
		Py_CLEAR(pyName);
		return CModule::GetWebMenuTitle();
	}
	Py_CLEAR(pyName);
	CString result;
	if (pyRes == Py_None) {
		result = CModule::GetWebMenuTitle();
	} else {
		CString* p = nullptr;
		int res = SWIG_AsPtr_CString(pyRes, &p);
		if (!SWIG_IsOK(res)) {
			DEBUG("modpython: " << (GetUser() ? GetUser()->GetUserName() : CString("<no user>")) << "/" << GetModName() << "/GetWebMenuTitle was expected to return 'CString' but error=" << res);
			result = CModule::GetWebMenuTitle();
		} else if (!p) {
			DEBUG("modpython: " << (GetUser() ? GetUser()->GetUserName() : CString("<no user>")) << "/" << GetModName() << "/GetWebMenuTitle was expected to return 'CString' but returned nullptr");
			result = CModule::GetWebMenuTitle();
		} else result = *p;
		if (SWIG_IsNewObj(res)) delete p;
	}
	Py_CLEAR(pyRes);
	return result;
}

bool CPyModule::OnWebPreRequest(CWebSock& WebSock, const CString& sPageName) {
	PyObject* pyName = Py_BuildValue("s", "OnWebPreRequest");
	if (!pyName) {
		CString sPyErr = m_pModPython->GetPyExceptionStr();
		DEBUG("modpython: " << (GetUser() ? GetUser()->GetUserName() : CString("<no user>")) << "/" << GetModName() << "/OnWebPreRequest: can't convert string 'OnWebPreRequest' to PyObject: " << sPyErr);
		return CModule::OnWebPreRequest(WebSock, sPageName);
	}
	PyObject* pyArg_WebSock = SWIG_NewInstanceObj(const_cast<CWebSock*>(&WebSock), SWIG_TypeQuery("CWebSock*"), 0);
	if (!pyArg_WebSock) {
		CString sPyErr = m_pModPython->GetPyExceptionStr();
		DEBUG("modpython: " << (GetUser() ? GetUser()->GetUserName() : CString("<no user>")) << "/" << GetModName() << "/OnWebPreRequest: can't convert parameter 'WebSock' to PyObject: " << sPyErr);
		Py_CLEAR(pyName);
		return CModule::OnWebPreRequest(WebSock, sPageName);
	}
	PyObject* pyArg_sPageName = Py_BuildValue("s", sPageName.c_str());
	if (!pyArg_sPageName) {
		CString sPyErr = m_pModPython->GetPyExceptionStr();
		DEBUG("modpython: " << (GetUser() ? GetUser()->GetUserName() : CString("<no user>")) << "/" << GetModName() << "/OnWebPreRequest: can't convert parameter 'sPageName' to PyObject: " << sPyErr);
		Py_CLEAR(pyName);
		Py_CLEAR(pyArg_WebSock);
		return CModule::OnWebPreRequest(WebSock, sPageName);
	}
	PyObject* pyRes = PyObject_CallMethodObjArgs(m_pyObj, pyName, pyArg_WebSock, pyArg_sPageName, nullptr);
	if (!pyRes) {
		CString sPyErr = m_pModPython->GetPyExceptionStr();
		DEBUG("modpython: " << (GetUser() ? GetUser()->GetUserName() : CString("<no user>")) << "/" << GetModName() << "/OnWebPreRequest failed: " << sPyErr);
		Py_CLEAR(pyName);
		Py_CLEAR(pyArg_WebSock);
		Py_CLEAR(pyArg_sPageName);
		return CModule::OnWebPreRequest(WebSock, sPageName);
	}
	Py_CLEAR(pyName);
	Py_CLEAR(pyArg_WebSock);
	Py_CLEAR(pyArg_sPageName);
	bool result;
	if (pyRes == Py_None) {
		result = CModule::OnWebPreRequest(WebSock, sPageName);
	} else {
		int x = PyObject_IsTrue(pyRes);
		if (-1 == x) {
			CString sPyErr = m_pModPython->GetPyExceptionStr();
			DEBUG("modpython: " << (GetUser() ? GetUser()->GetUserName() : CString("<no user>")) << "/" << GetModName() << "/OnWebPreRequest was expected to return EModRet but: " << sPyErr);
			result = CModule::OnWebPreRequest(WebSock, sPageName);
		} else result = x ? true : false;
	}
	Py_CLEAR(pyRes);
	return result;
}

bool CPyModule::OnWebRequest(CWebSock& WebSock, const CString& sPageName, CTemplate& Tmpl) {
	PyObject* pyName = Py_BuildValue("s", "OnWebRequest");
	if (!pyName) {
		CString sPyErr = m_pModPython->GetPyExceptionStr();
		DEBUG("modpython: " << (GetUser() ? GetUser()->GetUserName() : CString("<no user>")) << "/" << GetModName() << "/OnWebRequest: can't convert string 'OnWebRequest' to PyObject: " << sPyErr);
		return CModule::OnWebRequest(WebSock, sPageName, Tmpl);
	}
	PyObject* pyArg_WebSock = SWIG_NewInstanceObj(const_cast<CWebSock*>(&WebSock), SWIG_TypeQuery("CWebSock*"), 0);
	if (!pyArg_WebSock) {
		CString sPyErr = m_pModPython->GetPyExceptionStr();
		DEBUG("modpython: " << (GetUser() ? GetUser()->GetUserName() : CString("<no user>")) << "/" << GetModName() << "/OnWebRequest: can't convert parameter 'WebSock' to PyObject: " << sPyErr);
		Py_CLEAR(pyName);
		return CModule::OnWebRequest(WebSock, sPageName, Tmpl);
	}
	PyObject* pyArg_sPageName = Py_BuildValue("s", sPageName.c_str());
	if (!pyArg_sPageName) {
		CString sPyErr = m_pModPython->GetPyExceptionStr();
		DEBUG("modpython: " << (GetUser() ? GetUser()->GetUserName() : CString("<no user>")) << "/" << GetModName() << "/OnWebRequest: can't convert parameter 'sPageName' to PyObject: " << sPyErr);
		Py_CLEAR(pyName);
		Py_CLEAR(pyArg_WebSock);
		return CModule::OnWebRequest(WebSock, sPageName, Tmpl);
	}
	PyObject* pyArg_Tmpl = SWIG_NewInstanceObj(const_cast<CTemplate*>(&Tmpl), SWIG_TypeQuery("CTemplate*"), 0);
	if (!pyArg_Tmpl) {
		CString sPyErr = m_pModPython->GetPyExceptionStr();
		DEBUG("modpython: " << (GetUser() ? GetUser()->GetUserName() : CString("<no user>")) << "/" << GetModName() << "/OnWebRequest: can't convert parameter 'Tmpl' to PyObject: " << sPyErr);
		Py_CLEAR(pyName);
		Py_CLEAR(pyArg_WebSock);
		Py_CLEAR(pyArg_sPageName);
		return CModule::OnWebRequest(WebSock, sPageName, Tmpl);
	}
	PyObject* pyRes = PyObject_CallMethodObjArgs(m_pyObj, pyName, pyArg_WebSock, pyArg_sPageName, pyArg_Tmpl, nullptr);
	if (!pyRes) {
		CString sPyErr = m_pModPython->GetPyExceptionStr();
		DEBUG("modpython: " << (GetUser() ? GetUser()->GetUserName() : CString("<no user>")) << "/" << GetModName() << "/OnWebRequest failed: " << sPyErr);
		Py_CLEAR(pyName);
		Py_CLEAR(pyArg_WebSock);
		Py_CLEAR(pyArg_sPageName);
		Py_CLEAR(pyArg_Tmpl);
		return CModule::OnWebRequest(WebSock, sPageName, Tmpl);
	}
	Py_CLEAR(pyName);
	Py_CLEAR(pyArg_WebSock);
	Py_CLEAR(pyArg_sPageName);
	Py_CLEAR(pyArg_Tmpl);
	bool result;
	if (pyRes == Py_None) {
		result = CModule::OnWebRequest(WebSock, sPageName, Tmpl);
	} else {
		int x = PyObject_IsTrue(pyRes);
		if (-1 == x) {
			CString sPyErr = m_pModPython->GetPyExceptionStr();
			DEBUG("modpython: " << (GetUser() ? GetUser()->GetUserName() : CString("<no user>")) << "/" << GetModName() << "/OnWebRequest was expected to return EModRet but: " << sPyErr);
			result = CModule::OnWebRequest(WebSock, sPageName, Tmpl);
		} else result = x ? true : false;
	}
	Py_CLEAR(pyRes);
	return result;
}

bool CPyModule::ValidateWebRequestCSRFCheck(CWebSock& WebSock, const CString& sPageName) {
	PyObject* pyName = Py_BuildValue("s", "ValidateWebRequestCSRFCheck");
	if (!pyName) {
		CString sPyErr = m_pModPython->GetPyExceptionStr();
		DEBUG("modpython: " << (GetUser() ? GetUser()->GetUserName() : CString("<no user>")) << "/" << GetModName() << "/ValidateWebRequestCSRFCheck: can't convert string 'ValidateWebRequestCSRFCheck' to PyObject: " << sPyErr);
		return CModule::ValidateWebRequestCSRFCheck(WebSock, sPageName);
	}
	PyObject* pyArg_WebSock = SWIG_NewInstanceObj(const_cast<CWebSock*>(&WebSock), SWIG_TypeQuery("CWebSock*"), 0);
	if (!pyArg_WebSock) {
		CString sPyErr = m_pModPython->GetPyExceptionStr();
		DEBUG("modpython: " << (GetUser() ? GetUser()->GetUserName() : CString("<no user>")) << "/" << GetModName() << "/ValidateWebRequestCSRFCheck: can't convert parameter 'WebSock' to PyObject: " << sPyErr);
		Py_CLEAR(pyName);
		return CModule::ValidateWebRequestCSRFCheck(WebSock, sPageName);
	}
	PyObject* pyArg_sPageName = Py_BuildValue("s", sPageName.c_str());
	if (!pyArg_sPageName) {
		CString sPyErr = m_pModPython->GetPyExceptionStr();
		DEBUG("modpython: " << (GetUser() ? GetUser()->GetUserName() : CString("<no user>")) << "/" << GetModName() << "/ValidateWebRequestCSRFCheck: can't convert parameter 'sPageName' to PyObject: " << sPyErr);
		Py_CLEAR(pyName);
		Py_CLEAR(pyArg_WebSock);
		return CModule::ValidateWebRequestCSRFCheck(WebSock, sPageName);
	}
	PyObject* pyRes = PyObject_CallMethodObjArgs(m_pyObj, pyName, pyArg_WebSock, pyArg_sPageName, nullptr);
	if (!pyRes) {
		CString sPyErr = m_pModPython->GetPyExceptionStr();
		DEBUG("modpython: " << (GetUser() ? GetUser()->GetUserName() : CString("<no user>")) << "/" << GetModName() << "/ValidateWebRequestCSRFCheck failed: " << sPyErr);
		Py_CLEAR(pyName);
		Py_CLEAR(pyArg_WebSock);
		Py_CLEAR(pyArg_sPageName);
		return CModule::ValidateWebRequestCSRFCheck(WebSock, sPageName);
	}
	Py_CLEAR(pyName);
	Py_CLEAR(pyArg_WebSock);
	Py_CLEAR(pyArg_sPageName);
	bool result;
	if (pyRes == Py_None) {
		result = CModule::ValidateWebRequestCSRFCheck(WebSock, sPageName);
	} else {
		int x = PyObject_IsTrue(pyRes);
		if (-1 == x) {
			CString sPyErr = m_pModPython->GetPyExceptionStr();
			DEBUG("modpython: " << (GetUser() ? GetUser()->GetUserName() : CString("<no user>")) << "/" << GetModName() << "/ValidateWebRequestCSRFCheck was expected to return EModRet but: " << sPyErr);
			result = CModule::ValidateWebRequestCSRFCheck(WebSock, sPageName);
		} else result = x ? true : false;
	}
	Py_CLEAR(pyRes);
	return result;
}

VWebSubPages* CPyModule::_GetSubPages() {
	PyObject* pyName = Py_BuildValue("s", "_GetSubPages");
	if (!pyName) {
		CString sPyErr = m_pModPython->GetPyExceptionStr();
		DEBUG("modpython: " << (GetUser() ? GetUser()->GetUserName() : CString("<no user>")) << "/" << GetModName() << "/_GetSubPages: can't convert string '_GetSubPages' to PyObject: " << sPyErr);
		return nullptr;
	}
	PyObject* pyRes = PyObject_CallMethodObjArgs(m_pyObj, pyName, nullptr);
	if (!pyRes) {
		CString sPyErr = m_pModPython->GetPyExceptionStr();
		DEBUG("modpython: " << (GetUser() ? GetUser()->GetUserName() : CString("<no user>")) << "/" << GetModName() << "/_GetSubPages failed: " << sPyErr);
		Py_CLEAR(pyName);
		return nullptr;
	}
	Py_CLEAR(pyName);
	VWebSubPages* result;
	if (pyRes == Py_None) {
		result = nullptr;
	} else {
		int res = SWIG_ConvertPtr(pyRes, (void**)&result, SWIG_TypeQuery("VWebSubPages*"), 0);
		if (!SWIG_IsOK(res)) {
			DEBUG("modpython: " << (GetUser() ? GetUser()->GetUserName() : CString("<no user>")) << "/" << GetModName() << "/_GetSubPages was expected to return 'VWebSubPages*' but error=" << res);
			result = nullptr;
		}
	}
	Py_CLEAR(pyRes);
	return result;
}

void CPyModule::OnPreRehash() {
	PyObject* pyName = Py_BuildValue("s", "OnPreRehash");
	if (!pyName) {
		CString sPyErr = m_pModPython->GetPyExceptionStr();
		DEBUG("modpython: " << (GetUser() ? GetUser()->GetUserName() : CString("<no user>")) << "/" << GetModName() << "/OnPreRehash: can't convert string 'OnPreRehash' to PyObject: " << sPyErr);
		return CModule::OnPreRehash();
	}
	PyObject* pyRes = PyObject_CallMethodObjArgs(m_pyObj, pyName, nullptr);
	if (!pyRes) {
		CString sPyErr = m_pModPython->GetPyExceptionStr();
		DEBUG("modpython: " << (GetUser() ? GetUser()->GetUserName() : CString("<no user>")) << "/" << GetModName() << "/OnPreRehash failed: " << sPyErr);
		Py_CLEAR(pyName);
		return CModule::OnPreRehash();
	}
	Py_CLEAR(pyName);
	Py_CLEAR(pyRes);
}

void CPyModule::OnPostRehash() {
	PyObject* pyName = Py_BuildValue("s", "OnPostRehash");
	if (!pyName) {
		CString sPyErr = m_pModPython->GetPyExceptionStr();
		DEBUG("modpython: " << (GetUser() ? GetUser()->GetUserName() : CString("<no user>")) << "/" << GetModName() << "/OnPostRehash: can't convert string 'OnPostRehash' to PyObject: " << sPyErr);
		return CModule::OnPostRehash();
	}
	PyObject* pyRes = PyObject_CallMethodObjArgs(m_pyObj, pyName, nullptr);
	if (!pyRes) {
		CString sPyErr = m_pModPython->GetPyExceptionStr();
		DEBUG("modpython: " << (GetUser() ? GetUser()->GetUserName() : CString("<no user>")) << "/" << GetModName() << "/OnPostRehash failed: " << sPyErr);
		Py_CLEAR(pyName);
		return CModule::OnPostRehash();
	}
	Py_CLEAR(pyName);
	Py_CLEAR(pyRes);
}

void CPyModule::OnIRCDisconnected() {
	PyObject* pyName = Py_BuildValue("s", "OnIRCDisconnected");
	if (!pyName) {
		CString sPyErr = m_pModPython->GetPyExceptionStr();
		DEBUG("modpython: " << (GetUser() ? GetUser()->GetUserName() : CString("<no user>")) << "/" << GetModName() << "/OnIRCDisconnected: can't convert string 'OnIRCDisconnected' to PyObject: " << sPyErr);
		return CModule::OnIRCDisconnected();
	}
	PyObject* pyRes = PyObject_CallMethodObjArgs(m_pyObj, pyName, nullptr);
	if (!pyRes) {
		CString sPyErr = m_pModPython->GetPyExceptionStr();
		DEBUG("modpython: " << (GetUser() ? GetUser()->GetUserName() : CString("<no user>")) << "/" << GetModName() << "/OnIRCDisconnected failed: " << sPyErr);
		Py_CLEAR(pyName);
		return CModule::OnIRCDisconnected();
	}
	Py_CLEAR(pyName);
	Py_CLEAR(pyRes);
}

void CPyModule::OnIRCConnected() {
	PyObject* pyName = Py_BuildValue("s", "OnIRCConnected");
	if (!pyName) {
		CString sPyErr = m_pModPython->GetPyExceptionStr();
		DEBUG("modpython: " << (GetUser() ? GetUser()->GetUserName() : CString("<no user>")) << "/" << GetModName() << "/OnIRCConnected: can't convert string 'OnIRCConnected' to PyObject: " << sPyErr);
		return CModule::OnIRCConnected();
	}
	PyObject* pyRes = PyObject_CallMethodObjArgs(m_pyObj, pyName, nullptr);
	if (!pyRes) {
		CString sPyErr = m_pModPython->GetPyExceptionStr();
		DEBUG("modpython: " << (GetUser() ? GetUser()->GetUserName() : CString("<no user>")) << "/" << GetModName() << "/OnIRCConnected failed: " << sPyErr);
		Py_CLEAR(pyName);
		return CModule::OnIRCConnected();
	}
	Py_CLEAR(pyName);
	Py_CLEAR(pyRes);
}

CModule::EModRet CPyModule::OnIRCConnecting(CIRCSock *pIRCSock) {
	PyObject* pyName = Py_BuildValue("s", "OnIRCConnecting");
	if (!pyName) {
		CString sPyErr = m_pModPython->GetPyExceptionStr();
		DEBUG("modpython: " << (GetUser() ? GetUser()->GetUserName() : CString("<no user>")) << "/" << GetModName() << "/OnIRCConnecting: can't convert string 'OnIRCConnecting' to PyObject: " << sPyErr);
		return CModule::OnIRCConnecting(pIRCSock);
	}
	PyObject* pyArg_pIRCSock = SWIG_NewInstanceObj(const_cast<CIRCSock *>(pIRCSock), SWIG_TypeQuery("CIRCSock *"), 0);
	if (!pyArg_pIRCSock) {
		CString sPyErr = m_pModPython->GetPyExceptionStr();
		DEBUG("modpython: " << (GetUser() ? GetUser()->GetUserName() : CString("<no user>")) << "/" << GetModName() << "/OnIRCConnecting: can't convert parameter 'pIRCSock' to PyObject: " << sPyErr);
		Py_CLEAR(pyName);
		return CModule::OnIRCConnecting(pIRCSock);
	}
	PyObject* pyRes = PyObject_CallMethodObjArgs(m_pyObj, pyName, pyArg_pIRCSock, nullptr);
	if (!pyRes) {
		CString sPyErr = m_pModPython->GetPyExceptionStr();
		DEBUG("modpython: " << (GetUser() ? GetUser()->GetUserName() : CString("<no user>")) << "/" << GetModName() << "/OnIRCConnecting failed: " << sPyErr);
		Py_CLEAR(pyName);
		Py_CLEAR(pyArg_pIRCSock);
		return CModule::OnIRCConnecting(pIRCSock);
	}
	Py_CLEAR(pyName);
	Py_CLEAR(pyArg_pIRCSock);
	CModule::EModRet result;
	if (pyRes == Py_None) {
		result = CModule::OnIRCConnecting(pIRCSock);
	} else {
		long int x = PyLong_AsLong(pyRes);
		if (PyErr_Occurred()) {
			CString sPyErr = m_pModPython->GetPyExceptionStr();
			DEBUG("modpython: " << (GetUser() ? GetUser()->GetUserName() : CString("<no user>")) << "/" << GetModName() << "/OnIRCConnecting was expected to return EModRet but: " << sPyErr);
			result = CModule::OnIRCConnecting(pIRCSock);
		} else { result = (CModule::EModRet)x; }
	}
	Py_CLEAR(pyRes);
	return result;
}

void CPyModule::OnIRCConnectionError(CIRCSock *pIRCSock) {
	PyObject* pyName = Py_BuildValue("s", "OnIRCConnectionError");
	if (!pyName) {
		CString sPyErr = m_pModPython->GetPyExceptionStr();
		DEBUG("modpython: " << (GetUser() ? GetUser()->GetUserName() : CString("<no user>")) << "/" << GetModName() << "/OnIRCConnectionError: can't convert string 'OnIRCConnectionError' to PyObject: " << sPyErr);
		return CModule::OnIRCConnectionError(pIRCSock);
	}
	PyObject* pyArg_pIRCSock = SWIG_NewInstanceObj(const_cast<CIRCSock *>(pIRCSock), SWIG_TypeQuery("CIRCSock *"), 0);
	if (!pyArg_pIRCSock) {
		CString sPyErr = m_pModPython->GetPyExceptionStr();
		DEBUG("modpython: " << (GetUser() ? GetUser()->GetUserName() : CString("<no user>")) << "/" << GetModName() << "/OnIRCConnectionError: can't convert parameter 'pIRCSock' to PyObject: " << sPyErr);
		Py_CLEAR(pyName);
		return CModule::OnIRCConnectionError(pIRCSock);
	}
	PyObject* pyRes = PyObject_CallMethodObjArgs(m_pyObj, pyName, pyArg_pIRCSock, nullptr);
	if (!pyRes) {
		CString sPyErr = m_pModPython->GetPyExceptionStr();
		DEBUG("modpython: " << (GetUser() ? GetUser()->GetUserName() : CString("<no user>")) << "/" << GetModName() << "/OnIRCConnectionError failed: " << sPyErr);
		Py_CLEAR(pyName);
		Py_CLEAR(pyArg_pIRCSock);
		return CModule::OnIRCConnectionError(pIRCSock);
	}
	Py_CLEAR(pyName);
	Py_CLEAR(pyArg_pIRCSock);
	Py_CLEAR(pyRes);
}

CModule::EModRet CPyModule::OnIRCRegistration(CString& sPass, CString& sNick, CString& sIdent, CString& sRealName) {
	PyObject* pyName = Py_BuildValue("s", "OnIRCRegistration");
	if (!pyName) {
		CString sPyErr = m_pModPython->GetPyExceptionStr();
		DEBUG("modpython: " << (GetUser() ? GetUser()->GetUserName() : CString("<no user>")) << "/" << GetModName() << "/OnIRCRegistration: can't convert string 'OnIRCRegistration' to PyObject: " << sPyErr);
		return CModule::OnIRCRegistration(sPass, sNick, sIdent, sRealName);
	}
	PyObject* pyArg_sPass = CPyRetString::wrap(sPass);
	if (!pyArg_sPass) {
		CString sPyErr = m_pModPython->GetPyExceptionStr();
		DEBUG("modpython: " << (GetUser() ? GetUser()->GetUserName() : CString("<no user>")) << "/" << GetModName() << "/OnIRCRegistration: can't convert parameter 'sPass' to PyObject: " << sPyErr);
		Py_CLEAR(pyName);
		return CModule::OnIRCRegistration(sPass, sNick, sIdent, sRealName);
	}
	PyObject* pyArg_sNick = CPyRetString::wrap(sNick);
	if (!pyArg_sNick) {
		CString sPyErr = m_pModPython->GetPyExceptionStr();
		DEBUG("modpython: " << (GetUser() ? GetUser()->GetUserName() : CString("<no user>")) << "/" << GetModName() << "/OnIRCRegistration: can't convert parameter 'sNick' to PyObject: " << sPyErr);
		Py_CLEAR(pyName);
		Py_CLEAR(pyArg_sPass);
		return CModule::OnIRCRegistration(sPass, sNick, sIdent, sRealName);
	}
	PyObject* pyArg_sIdent = CPyRetString::wrap(sIdent);
	if (!pyArg_sIdent) {
		CString sPyErr = m_pModPython->GetPyExceptionStr();
		DEBUG("modpython: " << (GetUser() ? GetUser()->GetUserName() : CString("<no user>")) << "/" << GetModName() << "/OnIRCRegistration: can't convert parameter 'sIdent' to PyObject: " << sPyErr);
		Py_CLEAR(pyName);
		Py_CLEAR(pyArg_sPass);
		Py_CLEAR(pyArg_sNick);
		return CModule::OnIRCRegistration(sPass, sNick, sIdent, sRealName);
	}
	PyObject* pyArg_sRealName = CPyRetString::wrap(sRealName);
	if (!pyArg_sRealName) {
		CString sPyErr = m_pModPython->GetPyExceptionStr();
		DEBUG("modpython: " << (GetUser() ? GetUser()->GetUserName() : CString("<no user>")) << "/" << GetModName() << "/OnIRCRegistration: can't convert parameter 'sRealName' to PyObject: " << sPyErr);
		Py_CLEAR(pyName);
		Py_CLEAR(pyArg_sPass);
		Py_CLEAR(pyArg_sNick);
		Py_CLEAR(pyArg_sIdent);
		return CModule::OnIRCRegistration(sPass, sNick, sIdent, sRealName);
	}
	PyObject* pyRes = PyObject_CallMethodObjArgs(m_pyObj, pyName, pyArg_sPass, pyArg_sNick, pyArg_sIdent, pyArg_sRealName, nullptr);
	if (!pyRes) {
		CString sPyErr = m_pModPython->GetPyExceptionStr();
		DEBUG("modpython: " << (GetUser() ? GetUser()->GetUserName() : CString("<no user>")) << "/" << GetModName() << "/OnIRCRegistration failed: " << sPyErr);
		Py_CLEAR(pyName);
		Py_CLEAR(pyArg_sPass);
		Py_CLEAR(pyArg_sNick);
		Py_CLEAR(pyArg_sIdent);
		Py_CLEAR(pyArg_sRealName);
		return CModule::OnIRCRegistration(sPass, sNick, sIdent, sRealName);
	}
	Py_CLEAR(pyName);
	Py_CLEAR(pyArg_sPass);
	Py_CLEAR(pyArg_sNick);
	Py_CLEAR(pyArg_sIdent);
	Py_CLEAR(pyArg_sRealName);
	CModule::EModRet result;
	if (pyRes == Py_None) {
		result = CModule::OnIRCRegistration(sPass, sNick, sIdent, sRealName);
	} else {
		long int x = PyLong_AsLong(pyRes);
		if (PyErr_Occurred()) {
			CString sPyErr = m_pModPython->GetPyExceptionStr();
			DEBUG("modpython: " << (GetUser() ? GetUser()->GetUserName() : CString("<no user>")) << "/" << GetModName() << "/OnIRCRegistration was expected to return EModRet but: " << sPyErr);
			result = CModule::OnIRCRegistration(sPass, sNick, sIdent, sRealName);
		} else { result = (CModule::EModRet)x; }
	}
	Py_CLEAR(pyRes);
	return result;
}

CModule::EModRet CPyModule::OnBroadcast(CString& sMessage) {
	PyObject* pyName = Py_BuildValue("s", "OnBroadcast");
	if (!pyName) {
		CString sPyErr = m_pModPython->GetPyExceptionStr();
		DEBUG("modpython: " << (GetUser() ? GetUser()->GetUserName() : CString("<no user>")) << "/" << GetModName() << "/OnBroadcast: can't convert string 'OnBroadcast' to PyObject: " << sPyErr);
		return CModule::OnBroadcast(sMessage);
	}
	PyObject* pyArg_sMessage = CPyRetString::wrap(sMessage);
	if (!pyArg_sMessage) {
		CString sPyErr = m_pModPython->GetPyExceptionStr();
		DEBUG("modpython: " << (GetUser() ? GetUser()->GetUserName() : CString("<no user>")) << "/" << GetModName() << "/OnBroadcast: can't convert parameter 'sMessage' to PyObject: " << sPyErr);
		Py_CLEAR(pyName);
		return CModule::OnBroadcast(sMessage);
	}
	PyObject* pyRes = PyObject_CallMethodObjArgs(m_pyObj, pyName, pyArg_sMessage, nullptr);
	if (!pyRes) {
		CString sPyErr = m_pModPython->GetPyExceptionStr();
		DEBUG("modpython: " << (GetUser() ? GetUser()->GetUserName() : CString("<no user>")) << "/" << GetModName() << "/OnBroadcast failed: " << sPyErr);
		Py_CLEAR(pyName);
		Py_CLEAR(pyArg_sMessage);
		return CModule::OnBroadcast(sMessage);
	}
	Py_CLEAR(pyName);
	Py_CLEAR(pyArg_sMessage);
	CModule::EModRet result;
	if (pyRes == Py_None) {
		result = CModule::OnBroadcast(sMessage);
	} else {
		long int x = PyLong_AsLong(pyRes);
		if (PyErr_Occurred()) {
			CString sPyErr = m_pModPython->GetPyExceptionStr();
			DEBUG("modpython: " << (GetUser() ? GetUser()->GetUserName() : CString("<no user>")) << "/" << GetModName() << "/OnBroadcast was expected to return EModRet but: " << sPyErr);
			result = CModule::OnBroadcast(sMessage);
		} else { result = (CModule::EModRet)x; }
	}
	Py_CLEAR(pyRes);
	return result;
}

void CPyModule::OnChanPermission2(const CNick* pOpNick, const CNick& Nick, CChan& Channel, unsigned char uMode, bool bAdded, bool bNoChange) {
	PyObject* pyName = Py_BuildValue("s", "OnChanPermission2");
	if (!pyName) {
		CString sPyErr = m_pModPython->GetPyExceptionStr();
		DEBUG("modpython: " << (GetUser() ? GetUser()->GetUserName() : CString("<no user>")) << "/" << GetModName() << "/OnChanPermission2: can't convert string 'OnChanPermission2' to PyObject: " << sPyErr);
		return CModule::OnChanPermission2(pOpNick, Nick, Channel, uMode, bAdded, bNoChange);
	}
	PyObject* pyArg_pOpNick = SWIG_NewInstanceObj(const_cast< CNick*>(pOpNick), SWIG_TypeQuery(" CNick*"), 0);
	if (!pyArg_pOpNick) {
		CString sPyErr = m_pModPython->GetPyExceptionStr();
		DEBUG("modpython: " << (GetUser() ? GetUser()->GetUserName() : CString("<no user>")) << "/" << GetModName() << "/OnChanPermission2: can't convert parameter 'pOpNick' to PyObject: " << sPyErr);
		Py_CLEAR(pyName);
		return CModule::OnChanPermission2(pOpNick, Nick, Channel, uMode, bAdded, bNoChange);
	}
	PyObject* pyArg_Nick = SWIG_NewInstanceObj(const_cast< CNick*>(&Nick), SWIG_TypeQuery(" CNick*"), 0);
	if (!pyArg_Nick) {
		CString sPyErr = m_pModPython->GetPyExceptionStr();
		DEBUG("modpython: " << (GetUser() ? GetUser()->GetUserName() : CString("<no user>")) << "/" << GetModName() << "/OnChanPermission2: can't convert parameter 'Nick' to PyObject: " << sPyErr);
		Py_CLEAR(pyName);
		Py_CLEAR(pyArg_pOpNick);
		return CModule::OnChanPermission2(pOpNick, Nick, Channel, uMode, bAdded, bNoChange);
	}
	PyObject* pyArg_Channel = SWIG_NewInstanceObj(const_cast<CChan*>(&Channel), SWIG_TypeQuery("CChan*"), 0);
	if (!pyArg_Channel) {
		CString sPyErr = m_pModPython->GetPyExceptionStr();
		DEBUG("modpython: " << (GetUser() ? GetUser()->GetUserName() : CString("<no user>")) << "/" << GetModName() << "/OnChanPermission2: can't convert parameter 'Channel' to PyObject: " << sPyErr);
		Py_CLEAR(pyName);
		Py_CLEAR(pyArg_pOpNick);
		Py_CLEAR(pyArg_Nick);
		return CModule::OnChanPermission2(pOpNick, Nick, Channel, uMode, bAdded, bNoChange);
	}
	PyObject* pyArg_uMode = Py_BuildValue("B", uMode);
	if (!pyArg_uMode) {
		CString sPyErr = m_pModPython->GetPyExceptionStr();
		DEBUG("modpython: " << (GetUser() ? GetUser()->GetUserName() : CString("<no user>")) << "/" << GetModName() << "/OnChanPermission2: can't convert parameter 'uMode' to PyObject: " << sPyErr);
		Py_CLEAR(pyName);
		Py_CLEAR(pyArg_pOpNick);
		Py_CLEAR(pyArg_Nick);
		Py_CLEAR(pyArg_Channel);
		return CModule::OnChanPermission2(pOpNick, Nick, Channel, uMode, bAdded, bNoChange);
	}
	PyObject* pyArg_bAdded = Py_BuildValue("l", (long int)bAdded);
	if (!pyArg_bAdded) {
		CString sPyErr = m_pModPython->GetPyExceptionStr();
		DEBUG("modpython: " << (GetUser() ? GetUser()->GetUserName() : CString("<no user>")) << "/" << GetModName() << "/OnChanPermission2: can't convert parameter 'bAdded' to PyObject: " << sPyErr);
		Py_CLEAR(pyName);
		Py_CLEAR(pyArg_pOpNick);
		Py_CLEAR(pyArg_Nick);
		Py_CLEAR(pyArg_Channel);
		Py_CLEAR(pyArg_uMode);
		return CModule::OnChanPermission2(pOpNick, Nick, Channel, uMode, bAdded, bNoChange);
	}
	PyObject* pyArg_bNoChange = Py_BuildValue("l", (long int)bNoChange);
	if (!pyArg_bNoChange) {
		CString sPyErr = m_pModPython->GetPyExceptionStr();
		DEBUG("modpython: " << (GetUser() ? GetUser()->GetUserName() : CString("<no user>")) << "/" << GetModName() << "/OnChanPermission2: can't convert parameter 'bNoChange' to PyObject: " << sPyErr);
		Py_CLEAR(pyName);
		Py_CLEAR(pyArg_pOpNick);
		Py_CLEAR(pyArg_Nick);
		Py_CLEAR(pyArg_Channel);
		Py_CLEAR(pyArg_uMode);
		Py_CLEAR(pyArg_bAdded);
		return CModule::OnChanPermission2(pOpNick, Nick, Channel, uMode, bAdded, bNoChange);
	}
	PyObject* pyRes = PyObject_CallMethodObjArgs(m_pyObj, pyName, pyArg_pOpNick, pyArg_Nick, pyArg_Channel, pyArg_uMode, pyArg_bAdded, pyArg_bNoChange, nullptr);
	if (!pyRes) {
		CString sPyErr = m_pModPython->GetPyExceptionStr();
		DEBUG("modpython: " << (GetUser() ? GetUser()->GetUserName() : CString("<no user>")) << "/" << GetModName() << "/OnChanPermission2 failed: " << sPyErr);
		Py_CLEAR(pyName);
		Py_CLEAR(pyArg_pOpNick);
		Py_CLEAR(pyArg_Nick);
		Py_CLEAR(pyArg_Channel);
		Py_CLEAR(pyArg_uMode);
		Py_CLEAR(pyArg_bAdded);
		Py_CLEAR(pyArg_bNoChange);
		return CModule::OnChanPermission2(pOpNick, Nick, Channel, uMode, bAdded, bNoChange);
	}
	Py_CLEAR(pyName);
	Py_CLEAR(pyArg_pOpNick);
	Py_CLEAR(pyArg_Nick);
	Py_CLEAR(pyArg_Channel);
	Py_CLEAR(pyArg_uMode);
	Py_CLEAR(pyArg_bAdded);
	Py_CLEAR(pyArg_bNoChange);
	Py_CLEAR(pyRes);
}

void CPyModule::OnOp2(const CNick* pOpNick, const CNick& Nick, CChan& Channel, bool bNoChange) {
	PyObject* pyName = Py_BuildValue("s", "OnOp2");
	if (!pyName) {
		CString sPyErr = m_pModPython->GetPyExceptionStr();
		DEBUG("modpython: " << (GetUser() ? GetUser()->GetUserName() : CString("<no user>")) << "/" << GetModName() << "/OnOp2: can't convert string 'OnOp2' to PyObject: " << sPyErr);
		return CModule::OnOp2(pOpNick, Nick, Channel, bNoChange);
	}
	PyObject* pyArg_pOpNick = SWIG_NewInstanceObj(const_cast< CNick*>(pOpNick), SWIG_TypeQuery(" CNick*"), 0);
	if (!pyArg_pOpNick) {
		CString sPyErr = m_pModPython->GetPyExceptionStr();
		DEBUG("modpython: " << (GetUser() ? GetUser()->GetUserName() : CString("<no user>")) << "/" << GetModName() << "/OnOp2: can't convert parameter 'pOpNick' to PyObject: " << sPyErr);
		Py_CLEAR(pyName);
		return CModule::OnOp2(pOpNick, Nick, Channel, bNoChange);
	}
	PyObject* pyArg_Nick = SWIG_NewInstanceObj(const_cast< CNick*>(&Nick), SWIG_TypeQuery(" CNick*"), 0);
	if (!pyArg_Nick) {
		CString sPyErr = m_pModPython->GetPyExceptionStr();
		DEBUG("modpython: " << (GetUser() ? GetUser()->GetUserName() : CString("<no user>")) << "/" << GetModName() << "/OnOp2: can't convert parameter 'Nick' to PyObject: " << sPyErr);
		Py_CLEAR(pyName);
		Py_CLEAR(pyArg_pOpNick);
		return CModule::OnOp2(pOpNick, Nick, Channel, bNoChange);
	}
	PyObject* pyArg_Channel = SWIG_NewInstanceObj(const_cast<CChan*>(&Channel), SWIG_TypeQuery("CChan*"), 0);
	if (!pyArg_Channel) {
		CString sPyErr = m_pModPython->GetPyExceptionStr();
		DEBUG("modpython: " << (GetUser() ? GetUser()->GetUserName() : CString("<no user>")) << "/" << GetModName() << "/OnOp2: can't convert parameter 'Channel' to PyObject: " << sPyErr);
		Py_CLEAR(pyName);
		Py_CLEAR(pyArg_pOpNick);
		Py_CLEAR(pyArg_Nick);
		return CModule::OnOp2(pOpNick, Nick, Channel, bNoChange);
	}
	PyObject* pyArg_bNoChange = Py_BuildValue("l", (long int)bNoChange);
	if (!pyArg_bNoChange) {
		CString sPyErr = m_pModPython->GetPyExceptionStr();
		DEBUG("modpython: " << (GetUser() ? GetUser()->GetUserName() : CString("<no user>")) << "/" << GetModName() << "/OnOp2: can't convert parameter 'bNoChange' to PyObject: " << sPyErr);
		Py_CLEAR(pyName);
		Py_CLEAR(pyArg_pOpNick);
		Py_CLEAR(pyArg_Nick);
		Py_CLEAR(pyArg_Channel);
		return CModule::OnOp2(pOpNick, Nick, Channel, bNoChange);
	}
	PyObject* pyRes = PyObject_CallMethodObjArgs(m_pyObj, pyName, pyArg_pOpNick, pyArg_Nick, pyArg_Channel, pyArg_bNoChange, nullptr);
	if (!pyRes) {
		CString sPyErr = m_pModPython->GetPyExceptionStr();
		DEBUG("modpython: " << (GetUser() ? GetUser()->GetUserName() : CString("<no user>")) << "/" << GetModName() << "/OnOp2 failed: " << sPyErr);
		Py_CLEAR(pyName);
		Py_CLEAR(pyArg_pOpNick);
		Py_CLEAR(pyArg_Nick);
		Py_CLEAR(pyArg_Channel);
		Py_CLEAR(pyArg_bNoChange);
		return CModule::OnOp2(pOpNick, Nick, Channel, bNoChange);
	}
	Py_CLEAR(pyName);
	Py_CLEAR(pyArg_pOpNick);
	Py_CLEAR(pyArg_Nick);
	Py_CLEAR(pyArg_Channel);
	Py_CLEAR(pyArg_bNoChange);
	Py_CLEAR(pyRes);
}

void CPyModule::OnDeop2(const CNick* pOpNick, const CNick& Nick, CChan& Channel, bool bNoChange) {
	PyObject* pyName = Py_BuildValue("s", "OnDeop2");
	if (!pyName) {
		CString sPyErr = m_pModPython->GetPyExceptionStr();
		DEBUG("modpython: " << (GetUser() ? GetUser()->GetUserName() : CString("<no user>")) << "/" << GetModName() << "/OnDeop2: can't convert string 'OnDeop2' to PyObject: " << sPyErr);
		return CModule::OnDeop2(pOpNick, Nick, Channel, bNoChange);
	}
	PyObject* pyArg_pOpNick = SWIG_NewInstanceObj(const_cast< CNick*>(pOpNick), SWIG_TypeQuery(" CNick*"), 0);
	if (!pyArg_pOpNick) {
		CString sPyErr = m_pModPython->GetPyExceptionStr();
		DEBUG("modpython: " << (GetUser() ? GetUser()->GetUserName() : CString("<no user>")) << "/" << GetModName() << "/OnDeop2: can't convert parameter 'pOpNick' to PyObject: " << sPyErr);
		Py_CLEAR(pyName);
		return CModule::OnDeop2(pOpNick, Nick, Channel, bNoChange);
	}
	PyObject* pyArg_Nick = SWIG_NewInstanceObj(const_cast< CNick*>(&Nick), SWIG_TypeQuery(" CNick*"), 0);
	if (!pyArg_Nick) {
		CString sPyErr = m_pModPython->GetPyExceptionStr();
		DEBUG("modpython: " << (GetUser() ? GetUser()->GetUserName() : CString("<no user>")) << "/" << GetModName() << "/OnDeop2: can't convert parameter 'Nick' to PyObject: " << sPyErr);
		Py_CLEAR(pyName);
		Py_CLEAR(pyArg_pOpNick);
		return CModule::OnDeop2(pOpNick, Nick, Channel, bNoChange);
	}
	PyObject* pyArg_Channel = SWIG_NewInstanceObj(const_cast<CChan*>(&Channel), SWIG_TypeQuery("CChan*"), 0);
	if (!pyArg_Channel) {
		CString sPyErr = m_pModPython->GetPyExceptionStr();
		DEBUG("modpython: " << (GetUser() ? GetUser()->GetUserName() : CString("<no user>")) << "/" << GetModName() << "/OnDeop2: can't convert parameter 'Channel' to PyObject: " << sPyErr);
		Py_CLEAR(pyName);
		Py_CLEAR(pyArg_pOpNick);
		Py_CLEAR(pyArg_Nick);
		return CModule::OnDeop2(pOpNick, Nick, Channel, bNoChange);
	}
	PyObject* pyArg_bNoChange = Py_BuildValue("l", (long int)bNoChange);
	if (!pyArg_bNoChange) {
		CString sPyErr = m_pModPython->GetPyExceptionStr();
		DEBUG("modpython: " << (GetUser() ? GetUser()->GetUserName() : CString("<no user>")) << "/" << GetModName() << "/OnDeop2: can't convert parameter 'bNoChange' to PyObject: " << sPyErr);
		Py_CLEAR(pyName);
		Py_CLEAR(pyArg_pOpNick);
		Py_CLEAR(pyArg_Nick);
		Py_CLEAR(pyArg_Channel);
		return CModule::OnDeop2(pOpNick, Nick, Channel, bNoChange);
	}
	PyObject* pyRes = PyObject_CallMethodObjArgs(m_pyObj, pyName, pyArg_pOpNick, pyArg_Nick, pyArg_Channel, pyArg_bNoChange, nullptr);
	if (!pyRes) {
		CString sPyErr = m_pModPython->GetPyExceptionStr();
		DEBUG("modpython: " << (GetUser() ? GetUser()->GetUserName() : CString("<no user>")) << "/" << GetModName() << "/OnDeop2 failed: " << sPyErr);
		Py_CLEAR(pyName);
		Py_CLEAR(pyArg_pOpNick);
		Py_CLEAR(pyArg_Nick);
		Py_CLEAR(pyArg_Channel);
		Py_CLEAR(pyArg_bNoChange);
		return CModule::OnDeop2(pOpNick, Nick, Channel, bNoChange);
	}
	Py_CLEAR(pyName);
	Py_CLEAR(pyArg_pOpNick);
	Py_CLEAR(pyArg_Nick);
	Py_CLEAR(pyArg_Channel);
	Py_CLEAR(pyArg_bNoChange);
	Py_CLEAR(pyRes);
}

void CPyModule::OnVoice2(const CNick* pOpNick, const CNick& Nick, CChan& Channel, bool bNoChange) {
	PyObject* pyName = Py_BuildValue("s", "OnVoice2");
	if (!pyName) {
		CString sPyErr = m_pModPython->GetPyExceptionStr();
		DEBUG("modpython: " << (GetUser() ? GetUser()->GetUserName() : CString("<no user>")) << "/" << GetModName() << "/OnVoice2: can't convert string 'OnVoice2' to PyObject: " << sPyErr);
		return CModule::OnVoice2(pOpNick, Nick, Channel, bNoChange);
	}
	PyObject* pyArg_pOpNick = SWIG_NewInstanceObj(const_cast< CNick*>(pOpNick), SWIG_TypeQuery(" CNick*"), 0);
	if (!pyArg_pOpNick) {
		CString sPyErr = m_pModPython->GetPyExceptionStr();
		DEBUG("modpython: " << (GetUser() ? GetUser()->GetUserName() : CString("<no user>")) << "/" << GetModName() << "/OnVoice2: can't convert parameter 'pOpNick' to PyObject: " << sPyErr);
		Py_CLEAR(pyName);
		return CModule::OnVoice2(pOpNick, Nick, Channel, bNoChange);
	}
	PyObject* pyArg_Nick = SWIG_NewInstanceObj(const_cast< CNick*>(&Nick), SWIG_TypeQuery(" CNick*"), 0);
	if (!pyArg_Nick) {
		CString sPyErr = m_pModPython->GetPyExceptionStr();
		DEBUG("modpython: " << (GetUser() ? GetUser()->GetUserName() : CString("<no user>")) << "/" << GetModName() << "/OnVoice2: can't convert parameter 'Nick' to PyObject: " << sPyErr);
		Py_CLEAR(pyName);
		Py_CLEAR(pyArg_pOpNick);
		return CModule::OnVoice2(pOpNick, Nick, Channel, bNoChange);
	}
	PyObject* pyArg_Channel = SWIG_NewInstanceObj(const_cast<CChan*>(&Channel), SWIG_TypeQuery("CChan*"), 0);
	if (!pyArg_Channel) {
		CString sPyErr = m_pModPython->GetPyExceptionStr();
		DEBUG("modpython: " << (GetUser() ? GetUser()->GetUserName() : CString("<no user>")) << "/" << GetModName() << "/OnVoice2: can't convert parameter 'Channel' to PyObject: " << sPyErr);
		Py_CLEAR(pyName);
		Py_CLEAR(pyArg_pOpNick);
		Py_CLEAR(pyArg_Nick);
		return CModule::OnVoice2(pOpNick, Nick, Channel, bNoChange);
	}
	PyObject* pyArg_bNoChange = Py_BuildValue("l", (long int)bNoChange);
	if (!pyArg_bNoChange) {
		CString sPyErr = m_pModPython->GetPyExceptionStr();
		DEBUG("modpython: " << (GetUser() ? GetUser()->GetUserName() : CString("<no user>")) << "/" << GetModName() << "/OnVoice2: can't convert parameter 'bNoChange' to PyObject: " << sPyErr);
		Py_CLEAR(pyName);
		Py_CLEAR(pyArg_pOpNick);
		Py_CLEAR(pyArg_Nick);
		Py_CLEAR(pyArg_Channel);
		return CModule::OnVoice2(pOpNick, Nick, Channel, bNoChange);
	}
	PyObject* pyRes = PyObject_CallMethodObjArgs(m_pyObj, pyName, pyArg_pOpNick, pyArg_Nick, pyArg_Channel, pyArg_bNoChange, nullptr);
	if (!pyRes) {
		CString sPyErr = m_pModPython->GetPyExceptionStr();
		DEBUG("modpython: " << (GetUser() ? GetUser()->GetUserName() : CString("<no user>")) << "/" << GetModName() << "/OnVoice2 failed: " << sPyErr);
		Py_CLEAR(pyName);
		Py_CLEAR(pyArg_pOpNick);
		Py_CLEAR(pyArg_Nick);
		Py_CLEAR(pyArg_Channel);
		Py_CLEAR(pyArg_bNoChange);
		return CModule::OnVoice2(pOpNick, Nick, Channel, bNoChange);
	}
	Py_CLEAR(pyName);
	Py_CLEAR(pyArg_pOpNick);
	Py_CLEAR(pyArg_Nick);
	Py_CLEAR(pyArg_Channel);
	Py_CLEAR(pyArg_bNoChange);
	Py_CLEAR(pyRes);
}

void CPyModule::OnDevoice2(const CNick* pOpNick, const CNick& Nick, CChan& Channel, bool bNoChange) {
	PyObject* pyName = Py_BuildValue("s", "OnDevoice2");
	if (!pyName) {
		CString sPyErr = m_pModPython->GetPyExceptionStr();
		DEBUG("modpython: " << (GetUser() ? GetUser()->GetUserName() : CString("<no user>")) << "/" << GetModName() << "/OnDevoice2: can't convert string 'OnDevoice2' to PyObject: " << sPyErr);
		return CModule::OnDevoice2(pOpNick, Nick, Channel, bNoChange);
	}
	PyObject* pyArg_pOpNick = SWIG_NewInstanceObj(const_cast< CNick*>(pOpNick), SWIG_TypeQuery(" CNick*"), 0);
	if (!pyArg_pOpNick) {
		CString sPyErr = m_pModPython->GetPyExceptionStr();
		DEBUG("modpython: " << (GetUser() ? GetUser()->GetUserName() : CString("<no user>")) << "/" << GetModName() << "/OnDevoice2: can't convert parameter 'pOpNick' to PyObject: " << sPyErr);
		Py_CLEAR(pyName);
		return CModule::OnDevoice2(pOpNick, Nick, Channel, bNoChange);
	}
	PyObject* pyArg_Nick = SWIG_NewInstanceObj(const_cast< CNick*>(&Nick), SWIG_TypeQuery(" CNick*"), 0);
	if (!pyArg_Nick) {
		CString sPyErr = m_pModPython->GetPyExceptionStr();
		DEBUG("modpython: " << (GetUser() ? GetUser()->GetUserName() : CString("<no user>")) << "/" << GetModName() << "/OnDevoice2: can't convert parameter 'Nick' to PyObject: " << sPyErr);
		Py_CLEAR(pyName);
		Py_CLEAR(pyArg_pOpNick);
		return CModule::OnDevoice2(pOpNick, Nick, Channel, bNoChange);
	}
	PyObject* pyArg_Channel = SWIG_NewInstanceObj(const_cast<CChan*>(&Channel), SWIG_TypeQuery("CChan*"), 0);
	if (!pyArg_Channel) {
		CString sPyErr = m_pModPython->GetPyExceptionStr();
		DEBUG("modpython: " << (GetUser() ? GetUser()->GetUserName() : CString("<no user>")) << "/" << GetModName() << "/OnDevoice2: can't convert parameter 'Channel' to PyObject: " << sPyErr);
		Py_CLEAR(pyName);
		Py_CLEAR(pyArg_pOpNick);
		Py_CLEAR(pyArg_Nick);
		return CModule::OnDevoice2(pOpNick, Nick, Channel, bNoChange);
	}
	PyObject* pyArg_bNoChange = Py_BuildValue("l", (long int)bNoChange);
	if (!pyArg_bNoChange) {
		CString sPyErr = m_pModPython->GetPyExceptionStr();
		DEBUG("modpython: " << (GetUser() ? GetUser()->GetUserName() : CString("<no user>")) << "/" << GetModName() << "/OnDevoice2: can't convert parameter 'bNoChange' to PyObject: " << sPyErr);
		Py_CLEAR(pyName);
		Py_CLEAR(pyArg_pOpNick);
		Py_CLEAR(pyArg_Nick);
		Py_CLEAR(pyArg_Channel);
		return CModule::OnDevoice2(pOpNick, Nick, Channel, bNoChange);
	}
	PyObject* pyRes = PyObject_CallMethodObjArgs(m_pyObj, pyName, pyArg_pOpNick, pyArg_Nick, pyArg_Channel, pyArg_bNoChange, nullptr);
	if (!pyRes) {
		CString sPyErr = m_pModPython->GetPyExceptionStr();
		DEBUG("modpython: " << (GetUser() ? GetUser()->GetUserName() : CString("<no user>")) << "/" << GetModName() << "/OnDevoice2 failed: " << sPyErr);
		Py_CLEAR(pyName);
		Py_CLEAR(pyArg_pOpNick);
		Py_CLEAR(pyArg_Nick);
		Py_CLEAR(pyArg_Channel);
		Py_CLEAR(pyArg_bNoChange);
		return CModule::OnDevoice2(pOpNick, Nick, Channel, bNoChange);
	}
	Py_CLEAR(pyName);
	Py_CLEAR(pyArg_pOpNick);
	Py_CLEAR(pyArg_Nick);
	Py_CLEAR(pyArg_Channel);
	Py_CLEAR(pyArg_bNoChange);
	Py_CLEAR(pyRes);
}

void CPyModule::OnMode2(const CNick* pOpNick, CChan& Channel, char uMode, const CString& sArg, bool bAdded, bool bNoChange) {
	PyObject* pyName = Py_BuildValue("s", "OnMode2");
	if (!pyName) {
		CString sPyErr = m_pModPython->GetPyExceptionStr();
		DEBUG("modpython: " << (GetUser() ? GetUser()->GetUserName() : CString("<no user>")) << "/" << GetModName() << "/OnMode2: can't convert string 'OnMode2' to PyObject: " << sPyErr);
		return CModule::OnMode2(pOpNick, Channel, uMode, sArg, bAdded, bNoChange);
	}
	PyObject* pyArg_pOpNick = SWIG_NewInstanceObj(const_cast< CNick*>(pOpNick), SWIG_TypeQuery(" CNick*"), 0);
	if (!pyArg_pOpNick) {
		CString sPyErr = m_pModPython->GetPyExceptionStr();
		DEBUG("modpython: " << (GetUser() ? GetUser()->GetUserName() : CString("<no user>")) << "/" << GetModName() << "/OnMode2: can't convert parameter 'pOpNick' to PyObject: " << sPyErr);
		Py_CLEAR(pyName);
		return CModule::OnMode2(pOpNick, Channel, uMode, sArg, bAdded, bNoChange);
	}
	PyObject* pyArg_Channel = SWIG_NewInstanceObj(const_cast<CChan*>(&Channel), SWIG_TypeQuery("CChan*"), 0);
	if (!pyArg_Channel) {
		CString sPyErr = m_pModPython->GetPyExceptionStr();
		DEBUG("modpython: " << (GetUser() ? GetUser()->GetUserName() : CString("<no user>")) << "/" << GetModName() << "/OnMode2: can't convert parameter 'Channel' to PyObject: " << sPyErr);
		Py_CLEAR(pyName);
		Py_CLEAR(pyArg_pOpNick);
		return CModule::OnMode2(pOpNick, Channel, uMode, sArg, bAdded, bNoChange);
	}
	PyObject* pyArg_uMode = Py_BuildValue("b", uMode);
	if (!pyArg_uMode) {
		CString sPyErr = m_pModPython->GetPyExceptionStr();
		DEBUG("modpython: " << (GetUser() ? GetUser()->GetUserName() : CString("<no user>")) << "/" << GetModName() << "/OnMode2: can't convert parameter 'uMode' to PyObject: " << sPyErr);
		Py_CLEAR(pyName);
		Py_CLEAR(pyArg_pOpNick);
		Py_CLEAR(pyArg_Channel);
		return CModule::OnMode2(pOpNick, Channel, uMode, sArg, bAdded, bNoChange);
	}
	PyObject* pyArg_sArg = Py_BuildValue("s", sArg.c_str());
	if (!pyArg_sArg) {
		CString sPyErr = m_pModPython->GetPyExceptionStr();
		DEBUG("modpython: " << (GetUser() ? GetUser()->GetUserName() : CString("<no user>")) << "/" << GetModName() << "/OnMode2: can't convert parameter 'sArg' to PyObject: " << sPyErr);
		Py_CLEAR(pyName);
		Py_CLEAR(pyArg_pOpNick);
		Py_CLEAR(pyArg_Channel);
		Py_CLEAR(pyArg_uMode);
		return CModule::OnMode2(pOpNick, Channel, uMode, sArg, bAdded, bNoChange);
	}
	PyObject* pyArg_bAdded = Py_BuildValue("l", (long int)bAdded);
	if (!pyArg_bAdded) {
		CString sPyErr = m_pModPython->GetPyExceptionStr();
		DEBUG("modpython: " << (GetUser() ? GetUser()->GetUserName() : CString("<no user>")) << "/" << GetModName() << "/OnMode2: can't convert parameter 'bAdded' to PyObject: " << sPyErr);
		Py_CLEAR(pyName);
		Py_CLEAR(pyArg_pOpNick);
		Py_CLEAR(pyArg_Channel);
		Py_CLEAR(pyArg_uMode);
		Py_CLEAR(pyArg_sArg);
		return CModule::OnMode2(pOpNick, Channel, uMode, sArg, bAdded, bNoChange);
	}
	PyObject* pyArg_bNoChange = Py_BuildValue("l", (long int)bNoChange);
	if (!pyArg_bNoChange) {
		CString sPyErr = m_pModPython->GetPyExceptionStr();
		DEBUG("modpython: " << (GetUser() ? GetUser()->GetUserName() : CString("<no user>")) << "/" << GetModName() << "/OnMode2: can't convert parameter 'bNoChange' to PyObject: " << sPyErr);
		Py_CLEAR(pyName);
		Py_CLEAR(pyArg_pOpNick);
		Py_CLEAR(pyArg_Channel);
		Py_CLEAR(pyArg_uMode);
		Py_CLEAR(pyArg_sArg);
		Py_CLEAR(pyArg_bAdded);
		return CModule::OnMode2(pOpNick, Channel, uMode, sArg, bAdded, bNoChange);
	}
	PyObject* pyRes = PyObject_CallMethodObjArgs(m_pyObj, pyName, pyArg_pOpNick, pyArg_Channel, pyArg_uMode, pyArg_sArg, pyArg_bAdded, pyArg_bNoChange, nullptr);
	if (!pyRes) {
		CString sPyErr = m_pModPython->GetPyExceptionStr();
		DEBUG("modpython: " << (GetUser() ? GetUser()->GetUserName() : CString("<no user>")) << "/" << GetModName() << "/OnMode2 failed: " << sPyErr);
		Py_CLEAR(pyName);
		Py_CLEAR(pyArg_pOpNick);
		Py_CLEAR(pyArg_Channel);
		Py_CLEAR(pyArg_uMode);
		Py_CLEAR(pyArg_sArg);
		Py_CLEAR(pyArg_bAdded);
		Py_CLEAR(pyArg_bNoChange);
		return CModule::OnMode2(pOpNick, Channel, uMode, sArg, bAdded, bNoChange);
	}
	Py_CLEAR(pyName);
	Py_CLEAR(pyArg_pOpNick);
	Py_CLEAR(pyArg_Channel);
	Py_CLEAR(pyArg_uMode);
	Py_CLEAR(pyArg_sArg);
	Py_CLEAR(pyArg_bAdded);
	Py_CLEAR(pyArg_bNoChange);
	Py_CLEAR(pyRes);
}

void CPyModule::OnRawMode2(const CNick* pOpNick, CChan& Channel, const CString& sModes, const CString& sArgs) {
	PyObject* pyName = Py_BuildValue("s", "OnRawMode2");
	if (!pyName) {
		CString sPyErr = m_pModPython->GetPyExceptionStr();
		DEBUG("modpython: " << (GetUser() ? GetUser()->GetUserName() : CString("<no user>")) << "/" << GetModName() << "/OnRawMode2: can't convert string 'OnRawMode2' to PyObject: " << sPyErr);
		return CModule::OnRawMode2(pOpNick, Channel, sModes, sArgs);
	}
	PyObject* pyArg_pOpNick = SWIG_NewInstanceObj(const_cast< CNick*>(pOpNick), SWIG_TypeQuery(" CNick*"), 0);
	if (!pyArg_pOpNick) {
		CString sPyErr = m_pModPython->GetPyExceptionStr();
		DEBUG("modpython: " << (GetUser() ? GetUser()->GetUserName() : CString("<no user>")) << "/" << GetModName() << "/OnRawMode2: can't convert parameter 'pOpNick' to PyObject: " << sPyErr);
		Py_CLEAR(pyName);
		return CModule::OnRawMode2(pOpNick, Channel, sModes, sArgs);
	}
	PyObject* pyArg_Channel = SWIG_NewInstanceObj(const_cast<CChan*>(&Channel), SWIG_TypeQuery("CChan*"), 0);
	if (!pyArg_Channel) {
		CString sPyErr = m_pModPython->GetPyExceptionStr();
		DEBUG("modpython: " << (GetUser() ? GetUser()->GetUserName() : CString("<no user>")) << "/" << GetModName() << "/OnRawMode2: can't convert parameter 'Channel' to PyObject: " << sPyErr);
		Py_CLEAR(pyName);
		Py_CLEAR(pyArg_pOpNick);
		return CModule::OnRawMode2(pOpNick, Channel, sModes, sArgs);
	}
	PyObject* pyArg_sModes = Py_BuildValue("s", sModes.c_str());
	if (!pyArg_sModes) {
		CString sPyErr = m_pModPython->GetPyExceptionStr();
		DEBUG("modpython: " << (GetUser() ? GetUser()->GetUserName() : CString("<no user>")) << "/" << GetModName() << "/OnRawMode2: can't convert parameter 'sModes' to PyObject: " << sPyErr);
		Py_CLEAR(pyName);
		Py_CLEAR(pyArg_pOpNick);
		Py_CLEAR(pyArg_Channel);
		return CModule::OnRawMode2(pOpNick, Channel, sModes, sArgs);
	}
	PyObject* pyArg_sArgs = Py_BuildValue("s", sArgs.c_str());
	if (!pyArg_sArgs) {
		CString sPyErr = m_pModPython->GetPyExceptionStr();
		DEBUG("modpython: " << (GetUser() ? GetUser()->GetUserName() : CString("<no user>")) << "/" << GetModName() << "/OnRawMode2: can't convert parameter 'sArgs' to PyObject: " << sPyErr);
		Py_CLEAR(pyName);
		Py_CLEAR(pyArg_pOpNick);
		Py_CLEAR(pyArg_Channel);
		Py_CLEAR(pyArg_sModes);
		return CModule::OnRawMode2(pOpNick, Channel, sModes, sArgs);
	}
	PyObject* pyRes = PyObject_CallMethodObjArgs(m_pyObj, pyName, pyArg_pOpNick, pyArg_Channel, pyArg_sModes, pyArg_sArgs, nullptr);
	if (!pyRes) {
		CString sPyErr = m_pModPython->GetPyExceptionStr();
		DEBUG("modpython: " << (GetUser() ? GetUser()->GetUserName() : CString("<no user>")) << "/" << GetModName() << "/OnRawMode2 failed: " << sPyErr);
		Py_CLEAR(pyName);
		Py_CLEAR(pyArg_pOpNick);
		Py_CLEAR(pyArg_Channel);
		Py_CLEAR(pyArg_sModes);
		Py_CLEAR(pyArg_sArgs);
		return CModule::OnRawMode2(pOpNick, Channel, sModes, sArgs);
	}
	Py_CLEAR(pyName);
	Py_CLEAR(pyArg_pOpNick);
	Py_CLEAR(pyArg_Channel);
	Py_CLEAR(pyArg_sModes);
	Py_CLEAR(pyArg_sArgs);
	Py_CLEAR(pyRes);
}

CModule::EModRet CPyModule::OnRaw(CString& sLine) {
	PyObject* pyName = Py_BuildValue("s", "OnRaw");
	if (!pyName) {
		CString sPyErr = m_pModPython->GetPyExceptionStr();
		DEBUG("modpython: " << (GetUser() ? GetUser()->GetUserName() : CString("<no user>")) << "/" << GetModName() << "/OnRaw: can't convert string 'OnRaw' to PyObject: " << sPyErr);
		return CModule::OnRaw(sLine);
	}
	PyObject* pyArg_sLine = CPyRetString::wrap(sLine);
	if (!pyArg_sLine) {
		CString sPyErr = m_pModPython->GetPyExceptionStr();
		DEBUG("modpython: " << (GetUser() ? GetUser()->GetUserName() : CString("<no user>")) << "/" << GetModName() << "/OnRaw: can't convert parameter 'sLine' to PyObject: " << sPyErr);
		Py_CLEAR(pyName);
		return CModule::OnRaw(sLine);
	}
	PyObject* pyRes = PyObject_CallMethodObjArgs(m_pyObj, pyName, pyArg_sLine, nullptr);
	if (!pyRes) {
		CString sPyErr = m_pModPython->GetPyExceptionStr();
		DEBUG("modpython: " << (GetUser() ? GetUser()->GetUserName() : CString("<no user>")) << "/" << GetModName() << "/OnRaw failed: " << sPyErr);
		Py_CLEAR(pyName);
		Py_CLEAR(pyArg_sLine);
		return CModule::OnRaw(sLine);
	}
	Py_CLEAR(pyName);
	Py_CLEAR(pyArg_sLine);
	CModule::EModRet result;
	if (pyRes == Py_None) {
		result = CModule::OnRaw(sLine);
	} else {
		long int x = PyLong_AsLong(pyRes);
		if (PyErr_Occurred()) {
			CString sPyErr = m_pModPython->GetPyExceptionStr();
			DEBUG("modpython: " << (GetUser() ? GetUser()->GetUserName() : CString("<no user>")) << "/" << GetModName() << "/OnRaw was expected to return EModRet but: " << sPyErr);
			result = CModule::OnRaw(sLine);
		} else { result = (CModule::EModRet)x; }
	}
	Py_CLEAR(pyRes);
	return result;
}

CModule::EModRet CPyModule::OnStatusCommand(CString& sCommand) {
	PyObject* pyName = Py_BuildValue("s", "OnStatusCommand");
	if (!pyName) {
		CString sPyErr = m_pModPython->GetPyExceptionStr();
		DEBUG("modpython: " << (GetUser() ? GetUser()->GetUserName() : CString("<no user>")) << "/" << GetModName() << "/OnStatusCommand: can't convert string 'OnStatusCommand' to PyObject: " << sPyErr);
		return CModule::OnStatusCommand(sCommand);
	}
	PyObject* pyArg_sCommand = CPyRetString::wrap(sCommand);
	if (!pyArg_sCommand) {
		CString sPyErr = m_pModPython->GetPyExceptionStr();
		DEBUG("modpython: " << (GetUser() ? GetUser()->GetUserName() : CString("<no user>")) << "/" << GetModName() << "/OnStatusCommand: can't convert parameter 'sCommand' to PyObject: " << sPyErr);
		Py_CLEAR(pyName);
		return CModule::OnStatusCommand(sCommand);
	}
	PyObject* pyRes = PyObject_CallMethodObjArgs(m_pyObj, pyName, pyArg_sCommand, nullptr);
	if (!pyRes) {
		CString sPyErr = m_pModPython->GetPyExceptionStr();
		DEBUG("modpython: " << (GetUser() ? GetUser()->GetUserName() : CString("<no user>")) << "/" << GetModName() << "/OnStatusCommand failed: " << sPyErr);
		Py_CLEAR(pyName);
		Py_CLEAR(pyArg_sCommand);
		return CModule::OnStatusCommand(sCommand);
	}
	Py_CLEAR(pyName);
	Py_CLEAR(pyArg_sCommand);
	CModule::EModRet result;
	if (pyRes == Py_None) {
		result = CModule::OnStatusCommand(sCommand);
	} else {
		long int x = PyLong_AsLong(pyRes);
		if (PyErr_Occurred()) {
			CString sPyErr = m_pModPython->GetPyExceptionStr();
			DEBUG("modpython: " << (GetUser() ? GetUser()->GetUserName() : CString("<no user>")) << "/" << GetModName() << "/OnStatusCommand was expected to return EModRet but: " << sPyErr);
			result = CModule::OnStatusCommand(sCommand);
		} else { result = (CModule::EModRet)x; }
	}
	Py_CLEAR(pyRes);
	return result;
}

void CPyModule::OnModCommand(const CString& sCommand) {
	PyObject* pyName = Py_BuildValue("s", "OnModCommand");
	if (!pyName) {
		CString sPyErr = m_pModPython->GetPyExceptionStr();
		DEBUG("modpython: " << (GetUser() ? GetUser()->GetUserName() : CString("<no user>")) << "/" << GetModName() << "/OnModCommand: can't convert string 'OnModCommand' to PyObject: " << sPyErr);
		return CModule::OnModCommand(sCommand);
	}
	PyObject* pyArg_sCommand = Py_BuildValue("s", sCommand.c_str());
	if (!pyArg_sCommand) {
		CString sPyErr = m_pModPython->GetPyExceptionStr();
		DEBUG("modpython: " << (GetUser() ? GetUser()->GetUserName() : CString("<no user>")) << "/" << GetModName() << "/OnModCommand: can't convert parameter 'sCommand' to PyObject: " << sPyErr);
		Py_CLEAR(pyName);
		return CModule::OnModCommand(sCommand);
	}
	PyObject* pyRes = PyObject_CallMethodObjArgs(m_pyObj, pyName, pyArg_sCommand, nullptr);
	if (!pyRes) {
		CString sPyErr = m_pModPython->GetPyExceptionStr();
		DEBUG("modpython: " << (GetUser() ? GetUser()->GetUserName() : CString("<no user>")) << "/" << GetModName() << "/OnModCommand failed: " << sPyErr);
		Py_CLEAR(pyName);
		Py_CLEAR(pyArg_sCommand);
		return CModule::OnModCommand(sCommand);
	}
	Py_CLEAR(pyName);
	Py_CLEAR(pyArg_sCommand);
	Py_CLEAR(pyRes);
}

void CPyModule::OnModNotice(const CString& sMessage) {
	PyObject* pyName = Py_BuildValue("s", "OnModNotice");
	if (!pyName) {
		CString sPyErr = m_pModPython->GetPyExceptionStr();
		DEBUG("modpython: " << (GetUser() ? GetUser()->GetUserName() : CString("<no user>")) << "/" << GetModName() << "/OnModNotice: can't convert string 'OnModNotice' to PyObject: " << sPyErr);
		return CModule::OnModNotice(sMessage);
	}
	PyObject* pyArg_sMessage = Py_BuildValue("s", sMessage.c_str());
	if (!pyArg_sMessage) {
		CString sPyErr = m_pModPython->GetPyExceptionStr();
		DEBUG("modpython: " << (GetUser() ? GetUser()->GetUserName() : CString("<no user>")) << "/" << GetModName() << "/OnModNotice: can't convert parameter 'sMessage' to PyObject: " << sPyErr);
		Py_CLEAR(pyName);
		return CModule::OnModNotice(sMessage);
	}
	PyObject* pyRes = PyObject_CallMethodObjArgs(m_pyObj, pyName, pyArg_sMessage, nullptr);
	if (!pyRes) {
		CString sPyErr = m_pModPython->GetPyExceptionStr();
		DEBUG("modpython: " << (GetUser() ? GetUser()->GetUserName() : CString("<no user>")) << "/" << GetModName() << "/OnModNotice failed: " << sPyErr);
		Py_CLEAR(pyName);
		Py_CLEAR(pyArg_sMessage);
		return CModule::OnModNotice(sMessage);
	}
	Py_CLEAR(pyName);
	Py_CLEAR(pyArg_sMessage);
	Py_CLEAR(pyRes);
}

void CPyModule::OnModCTCP(const CString& sMessage) {
	PyObject* pyName = Py_BuildValue("s", "OnModCTCP");
	if (!pyName) {
		CString sPyErr = m_pModPython->GetPyExceptionStr();
		DEBUG("modpython: " << (GetUser() ? GetUser()->GetUserName() : CString("<no user>")) << "/" << GetModName() << "/OnModCTCP: can't convert string 'OnModCTCP' to PyObject: " << sPyErr);
		return CModule::OnModCTCP(sMessage);
	}
	PyObject* pyArg_sMessage = Py_BuildValue("s", sMessage.c_str());
	if (!pyArg_sMessage) {
		CString sPyErr = m_pModPython->GetPyExceptionStr();
		DEBUG("modpython: " << (GetUser() ? GetUser()->GetUserName() : CString("<no user>")) << "/" << GetModName() << "/OnModCTCP: can't convert parameter 'sMessage' to PyObject: " << sPyErr);
		Py_CLEAR(pyName);
		return CModule::OnModCTCP(sMessage);
	}
	PyObject* pyRes = PyObject_CallMethodObjArgs(m_pyObj, pyName, pyArg_sMessage, nullptr);
	if (!pyRes) {
		CString sPyErr = m_pModPython->GetPyExceptionStr();
		DEBUG("modpython: " << (GetUser() ? GetUser()->GetUserName() : CString("<no user>")) << "/" << GetModName() << "/OnModCTCP failed: " << sPyErr);
		Py_CLEAR(pyName);
		Py_CLEAR(pyArg_sMessage);
		return CModule::OnModCTCP(sMessage);
	}
	Py_CLEAR(pyName);
	Py_CLEAR(pyArg_sMessage);
	Py_CLEAR(pyRes);
}

void CPyModule::OnQuit(const CNick& Nick, const CString& sMessage, const vector<CChan*>& vChans) {
	PyObject* pyName = Py_BuildValue("s", "OnQuit");
	if (!pyName) {
		CString sPyErr = m_pModPython->GetPyExceptionStr();
		DEBUG("modpython: " << (GetUser() ? GetUser()->GetUserName() : CString("<no user>")) << "/" << GetModName() << "/OnQuit: can't convert string 'OnQuit' to PyObject: " << sPyErr);
		return CModule::OnQuit(Nick, sMessage, vChans);
	}
	PyObject* pyArg_Nick = SWIG_NewInstanceObj(const_cast< CNick*>(&Nick), SWIG_TypeQuery(" CNick*"), 0);
	if (!pyArg_Nick) {
		CString sPyErr = m_pModPython->GetPyExceptionStr();
		DEBUG("modpython: " << (GetUser() ? GetUser()->GetUserName() : CString("<no user>")) << "/" << GetModName() << "/OnQuit: can't convert parameter 'Nick' to PyObject: " << sPyErr);
		Py_CLEAR(pyName);
		return CModule::OnQuit(Nick, sMessage, vChans);
	}
	PyObject* pyArg_sMessage = Py_BuildValue("s", sMessage.c_str());
	if (!pyArg_sMessage) {
		CString sPyErr = m_pModPython->GetPyExceptionStr();
		DEBUG("modpython: " << (GetUser() ? GetUser()->GetUserName() : CString("<no user>")) << "/" << GetModName() << "/OnQuit: can't convert parameter 'sMessage' to PyObject: " << sPyErr);
		Py_CLEAR(pyName);
		Py_CLEAR(pyArg_Nick);
		return CModule::OnQuit(Nick, sMessage, vChans);
	}
	PyObject* pyArg_vChans = PyList_New(0);
	if (!pyArg_vChans) {
		CString sPyErr = m_pModPython->GetPyExceptionStr();
		DEBUG("modpython: " << (GetUser() ? GetUser()->GetUserName() : CString("<no user>")) << "/" << GetModName() << "/OnQuit: can't convert parameter 'vChans' to PyObject: " << sPyErr);
		Py_CLEAR(pyName);
		Py_CLEAR(pyArg_Nick);
		Py_CLEAR(pyArg_sMessage);
		return CModule::OnQuit(Nick, sMessage, vChans);
	}
	for (vector<CChan*>::const_iterator i = vChans.begin(); i != vChans.end(); ++i) {
		PyObject* pyVecEl = SWIG_NewInstanceObj(*i, SWIG_TypeQuery("CChan*"), 0);
		if (!pyVecEl) {
			CString sPyErr = m_pModPython->GetPyExceptionStr();
			DEBUG("modpython: " << (GetUser() ? GetUser()->GetUserName() : CString("<no user>")) << "/" << GetModName() << "/OnQuit: can't convert element of vector 'vChans' to PyObject: " << sPyErr);
			Py_CLEAR(pyName);
			Py_CLEAR(pyArg_Nick);
			Py_CLEAR(pyArg_sMessage);
			Py_CLEAR(pyArg_vChans);
			return CModule::OnQuit(Nick, sMessage, vChans);
		}
		if (PyList_Append(pyArg_vChans, pyVecEl)) {
			CString sPyErr = m_pModPython->GetPyExceptionStr();
			DEBUG("modpython: " << (GetUser() ? GetUser()->GetUserName() : CString("<no user>")) << "/" << GetModName() << "/OnQuit: can't add element of vector 'vChans' to PyObject: " << sPyErr);
			Py_CLEAR(pyVecEl);
			Py_CLEAR(pyName);
			Py_CLEAR(pyArg_Nick);
			Py_CLEAR(pyArg_sMessage);
			Py_CLEAR(pyArg_vChans);
			return CModule::OnQuit(Nick, sMessage, vChans);
		}
		Py_CLEAR(pyVecEl);
	}
	PyObject* pyRes = PyObject_CallMethodObjArgs(m_pyObj, pyName, pyArg_Nick, pyArg_sMessage, pyArg_vChans, nullptr);
	if (!pyRes) {
		CString sPyErr = m_pModPython->GetPyExceptionStr();
		DEBUG("modpython: " << (GetUser() ? GetUser()->GetUserName() : CString("<no user>")) << "/" << GetModName() << "/OnQuit failed: " << sPyErr);
		Py_CLEAR(pyName);
		Py_CLEAR(pyArg_Nick);
		Py_CLEAR(pyArg_sMessage);
		Py_CLEAR(pyArg_vChans);
		return CModule::OnQuit(Nick, sMessage, vChans);
	}
	Py_CLEAR(pyName);
	Py_CLEAR(pyArg_Nick);
	Py_CLEAR(pyArg_sMessage);
	Py_CLEAR(pyArg_vChans);
	Py_CLEAR(pyRes);
}

void CPyModule::OnNick(const CNick& Nick, const CString& sNewNick, const vector<CChan*>& vChans) {
	PyObject* pyName = Py_BuildValue("s", "OnNick");
	if (!pyName) {
		CString sPyErr = m_pModPython->GetPyExceptionStr();
		DEBUG("modpython: " << (GetUser() ? GetUser()->GetUserName() : CString("<no user>")) << "/" << GetModName() << "/OnNick: can't convert string 'OnNick' to PyObject: " << sPyErr);
		return CModule::OnNick(Nick, sNewNick, vChans);
	}
	PyObject* pyArg_Nick = SWIG_NewInstanceObj(const_cast< CNick*>(&Nick), SWIG_TypeQuery(" CNick*"), 0);
	if (!pyArg_Nick) {
		CString sPyErr = m_pModPython->GetPyExceptionStr();
		DEBUG("modpython: " << (GetUser() ? GetUser()->GetUserName() : CString("<no user>")) << "/" << GetModName() << "/OnNick: can't convert parameter 'Nick' to PyObject: " << sPyErr);
		Py_CLEAR(pyName);
		return CModule::OnNick(Nick, sNewNick, vChans);
	}
	PyObject* pyArg_sNewNick = Py_BuildValue("s", sNewNick.c_str());
	if (!pyArg_sNewNick) {
		CString sPyErr = m_pModPython->GetPyExceptionStr();
		DEBUG("modpython: " << (GetUser() ? GetUser()->GetUserName() : CString("<no user>")) << "/" << GetModName() << "/OnNick: can't convert parameter 'sNewNick' to PyObject: " << sPyErr);
		Py_CLEAR(pyName);
		Py_CLEAR(pyArg_Nick);
		return CModule::OnNick(Nick, sNewNick, vChans);
	}
	PyObject* pyArg_vChans = PyList_New(0);
	if (!pyArg_vChans) {
		CString sPyErr = m_pModPython->GetPyExceptionStr();
		DEBUG("modpython: " << (GetUser() ? GetUser()->GetUserName() : CString("<no user>")) << "/" << GetModName() << "/OnNick: can't convert parameter 'vChans' to PyObject: " << sPyErr);
		Py_CLEAR(pyName);
		Py_CLEAR(pyArg_Nick);
		Py_CLEAR(pyArg_sNewNick);
		return CModule::OnNick(Nick, sNewNick, vChans);
	}
	for (vector<CChan*>::const_iterator i = vChans.begin(); i != vChans.end(); ++i) {
		PyObject* pyVecEl = SWIG_NewInstanceObj(*i, SWIG_TypeQuery("CChan*"), 0);
		if (!pyVecEl) {
			CString sPyErr = m_pModPython->GetPyExceptionStr();
			DEBUG("modpython: " << (GetUser() ? GetUser()->GetUserName() : CString("<no user>")) << "/" << GetModName() << "/OnNick: can't convert element of vector 'vChans' to PyObject: " << sPyErr);
			Py_CLEAR(pyName);
			Py_CLEAR(pyArg_Nick);
			Py_CLEAR(pyArg_sNewNick);
			Py_CLEAR(pyArg_vChans);
			return CModule::OnNick(Nick, sNewNick, vChans);
		}
		if (PyList_Append(pyArg_vChans, pyVecEl)) {
			CString sPyErr = m_pModPython->GetPyExceptionStr();
			DEBUG("modpython: " << (GetUser() ? GetUser()->GetUserName() : CString("<no user>")) << "/" << GetModName() << "/OnNick: can't add element of vector 'vChans' to PyObject: " << sPyErr);
			Py_CLEAR(pyVecEl);
			Py_CLEAR(pyName);
			Py_CLEAR(pyArg_Nick);
			Py_CLEAR(pyArg_sNewNick);
			Py_CLEAR(pyArg_vChans);
			return CModule::OnNick(Nick, sNewNick, vChans);
		}
		Py_CLEAR(pyVecEl);
	}
	PyObject* pyRes = PyObject_CallMethodObjArgs(m_pyObj, pyName, pyArg_Nick, pyArg_sNewNick, pyArg_vChans, nullptr);
	if (!pyRes) {
		CString sPyErr = m_pModPython->GetPyExceptionStr();
		DEBUG("modpython: " << (GetUser() ? GetUser()->GetUserName() : CString("<no user>")) << "/" << GetModName() << "/OnNick failed: " << sPyErr);
		Py_CLEAR(pyName);
		Py_CLEAR(pyArg_Nick);
		Py_CLEAR(pyArg_sNewNick);
		Py_CLEAR(pyArg_vChans);
		return CModule::OnNick(Nick, sNewNick, vChans);
	}
	Py_CLEAR(pyName);
	Py_CLEAR(pyArg_Nick);
	Py_CLEAR(pyArg_sNewNick);
	Py_CLEAR(pyArg_vChans);
	Py_CLEAR(pyRes);
}

void CPyModule::OnKick(const CNick& OpNick, const CString& sKickedNick, CChan& Channel, const CString& sMessage) {
	PyObject* pyName = Py_BuildValue("s", "OnKick");
	if (!pyName) {
		CString sPyErr = m_pModPython->GetPyExceptionStr();
		DEBUG("modpython: " << (GetUser() ? GetUser()->GetUserName() : CString("<no user>")) << "/" << GetModName() << "/OnKick: can't convert string 'OnKick' to PyObject: " << sPyErr);
		return CModule::OnKick(OpNick, sKickedNick, Channel, sMessage);
	}
	PyObject* pyArg_OpNick = SWIG_NewInstanceObj(const_cast< CNick*>(&OpNick), SWIG_TypeQuery(" CNick*"), 0);
	if (!pyArg_OpNick) {
		CString sPyErr = m_pModPython->GetPyExceptionStr();
		DEBUG("modpython: " << (GetUser() ? GetUser()->GetUserName() : CString("<no user>")) << "/" << GetModName() << "/OnKick: can't convert parameter 'OpNick' to PyObject: " << sPyErr);
		Py_CLEAR(pyName);
		return CModule::OnKick(OpNick, sKickedNick, Channel, sMessage);
	}
	PyObject* pyArg_sKickedNick = Py_BuildValue("s", sKickedNick.c_str());
	if (!pyArg_sKickedNick) {
		CString sPyErr = m_pModPython->GetPyExceptionStr();
		DEBUG("modpython: " << (GetUser() ? GetUser()->GetUserName() : CString("<no user>")) << "/" << GetModName() << "/OnKick: can't convert parameter 'sKickedNick' to PyObject: " << sPyErr);
		Py_CLEAR(pyName);
		Py_CLEAR(pyArg_OpNick);
		return CModule::OnKick(OpNick, sKickedNick, Channel, sMessage);
	}
	PyObject* pyArg_Channel = SWIG_NewInstanceObj(const_cast<CChan*>(&Channel), SWIG_TypeQuery("CChan*"), 0);
	if (!pyArg_Channel) {
		CString sPyErr = m_pModPython->GetPyExceptionStr();
		DEBUG("modpython: " << (GetUser() ? GetUser()->GetUserName() : CString("<no user>")) << "/" << GetModName() << "/OnKick: can't convert parameter 'Channel' to PyObject: " << sPyErr);
		Py_CLEAR(pyName);
		Py_CLEAR(pyArg_OpNick);
		Py_CLEAR(pyArg_sKickedNick);
		return CModule::OnKick(OpNick, sKickedNick, Channel, sMessage);
	}
	PyObject* pyArg_sMessage = Py_BuildValue("s", sMessage.c_str());
	if (!pyArg_sMessage) {
		CString sPyErr = m_pModPython->GetPyExceptionStr();
		DEBUG("modpython: " << (GetUser() ? GetUser()->GetUserName() : CString("<no user>")) << "/" << GetModName() << "/OnKick: can't convert parameter 'sMessage' to PyObject: " << sPyErr);
		Py_CLEAR(pyName);
		Py_CLEAR(pyArg_OpNick);
		Py_CLEAR(pyArg_sKickedNick);
		Py_CLEAR(pyArg_Channel);
		return CModule::OnKick(OpNick, sKickedNick, Channel, sMessage);
	}
	PyObject* pyRes = PyObject_CallMethodObjArgs(m_pyObj, pyName, pyArg_OpNick, pyArg_sKickedNick, pyArg_Channel, pyArg_sMessage, nullptr);
	if (!pyRes) {
		CString sPyErr = m_pModPython->GetPyExceptionStr();
		DEBUG("modpython: " << (GetUser() ? GetUser()->GetUserName() : CString("<no user>")) << "/" << GetModName() << "/OnKick failed: " << sPyErr);
		Py_CLEAR(pyName);
		Py_CLEAR(pyArg_OpNick);
		Py_CLEAR(pyArg_sKickedNick);
		Py_CLEAR(pyArg_Channel);
		Py_CLEAR(pyArg_sMessage);
		return CModule::OnKick(OpNick, sKickedNick, Channel, sMessage);
	}
	Py_CLEAR(pyName);
	Py_CLEAR(pyArg_OpNick);
	Py_CLEAR(pyArg_sKickedNick);
	Py_CLEAR(pyArg_Channel);
	Py_CLEAR(pyArg_sMessage);
	Py_CLEAR(pyRes);
}

CModule::EModRet CPyModule::OnJoining(CChan& Channel) {
	PyObject* pyName = Py_BuildValue("s", "OnJoining");
	if (!pyName) {
		CString sPyErr = m_pModPython->GetPyExceptionStr();
		DEBUG("modpython: " << (GetUser() ? GetUser()->GetUserName() : CString("<no user>")) << "/" << GetModName() << "/OnJoining: can't convert string 'OnJoining' to PyObject: " << sPyErr);
		return CModule::OnJoining(Channel);
	}
	PyObject* pyArg_Channel = SWIG_NewInstanceObj(const_cast<CChan*>(&Channel), SWIG_TypeQuery("CChan*"), 0);
	if (!pyArg_Channel) {
		CString sPyErr = m_pModPython->GetPyExceptionStr();
		DEBUG("modpython: " << (GetUser() ? GetUser()->GetUserName() : CString("<no user>")) << "/" << GetModName() << "/OnJoining: can't convert parameter 'Channel' to PyObject: " << sPyErr);
		Py_CLEAR(pyName);
		return CModule::OnJoining(Channel);
	}
	PyObject* pyRes = PyObject_CallMethodObjArgs(m_pyObj, pyName, pyArg_Channel, nullptr);
	if (!pyRes) {
		CString sPyErr = m_pModPython->GetPyExceptionStr();
		DEBUG("modpython: " << (GetUser() ? GetUser()->GetUserName() : CString("<no user>")) << "/" << GetModName() << "/OnJoining failed: " << sPyErr);
		Py_CLEAR(pyName);
		Py_CLEAR(pyArg_Channel);
		return CModule::OnJoining(Channel);
	}
	Py_CLEAR(pyName);
	Py_CLEAR(pyArg_Channel);
	CModule::EModRet result;
	if (pyRes == Py_None) {
		result = CModule::OnJoining(Channel);
	} else {
		long int x = PyLong_AsLong(pyRes);
		if (PyErr_Occurred()) {
			CString sPyErr = m_pModPython->GetPyExceptionStr();
			DEBUG("modpython: " << (GetUser() ? GetUser()->GetUserName() : CString("<no user>")) << "/" << GetModName() << "/OnJoining was expected to return EModRet but: " << sPyErr);
			result = CModule::OnJoining(Channel);
		} else { result = (CModule::EModRet)x; }
	}
	Py_CLEAR(pyRes);
	return result;
}

void CPyModule::OnJoin(const CNick& Nick, CChan& Channel) {
	PyObject* pyName = Py_BuildValue("s", "OnJoin");
	if (!pyName) {
		CString sPyErr = m_pModPython->GetPyExceptionStr();
		DEBUG("modpython: " << (GetUser() ? GetUser()->GetUserName() : CString("<no user>")) << "/" << GetModName() << "/OnJoin: can't convert string 'OnJoin' to PyObject: " << sPyErr);
		return CModule::OnJoin(Nick, Channel);
	}
	PyObject* pyArg_Nick = SWIG_NewInstanceObj(const_cast< CNick*>(&Nick), SWIG_TypeQuery(" CNick*"), 0);
	if (!pyArg_Nick) {
		CString sPyErr = m_pModPython->GetPyExceptionStr();
		DEBUG("modpython: " << (GetUser() ? GetUser()->GetUserName() : CString("<no user>")) << "/" << GetModName() << "/OnJoin: can't convert parameter 'Nick' to PyObject: " << sPyErr);
		Py_CLEAR(pyName);
		return CModule::OnJoin(Nick, Channel);
	}
	PyObject* pyArg_Channel = SWIG_NewInstanceObj(const_cast<CChan*>(&Channel), SWIG_TypeQuery("CChan*"), 0);
	if (!pyArg_Channel) {
		CString sPyErr = m_pModPython->GetPyExceptionStr();
		DEBUG("modpython: " << (GetUser() ? GetUser()->GetUserName() : CString("<no user>")) << "/" << GetModName() << "/OnJoin: can't convert parameter 'Channel' to PyObject: " << sPyErr);
		Py_CLEAR(pyName);
		Py_CLEAR(pyArg_Nick);
		return CModule::OnJoin(Nick, Channel);
	}
	PyObject* pyRes = PyObject_CallMethodObjArgs(m_pyObj, pyName, pyArg_Nick, pyArg_Channel, nullptr);
	if (!pyRes) {
		CString sPyErr = m_pModPython->GetPyExceptionStr();
		DEBUG("modpython: " << (GetUser() ? GetUser()->GetUserName() : CString("<no user>")) << "/" << GetModName() << "/OnJoin failed: " << sPyErr);
		Py_CLEAR(pyName);
		Py_CLEAR(pyArg_Nick);
		Py_CLEAR(pyArg_Channel);
		return CModule::OnJoin(Nick, Channel);
	}
	Py_CLEAR(pyName);
	Py_CLEAR(pyArg_Nick);
	Py_CLEAR(pyArg_Channel);
	Py_CLEAR(pyRes);
}

void CPyModule::OnPart(const CNick& Nick, CChan& Channel, const CString& sMessage) {
	PyObject* pyName = Py_BuildValue("s", "OnPart");
	if (!pyName) {
		CString sPyErr = m_pModPython->GetPyExceptionStr();
		DEBUG("modpython: " << (GetUser() ? GetUser()->GetUserName() : CString("<no user>")) << "/" << GetModName() << "/OnPart: can't convert string 'OnPart' to PyObject: " << sPyErr);
		return CModule::OnPart(Nick, Channel, sMessage);
	}
	PyObject* pyArg_Nick = SWIG_NewInstanceObj(const_cast< CNick*>(&Nick), SWIG_TypeQuery(" CNick*"), 0);
	if (!pyArg_Nick) {
		CString sPyErr = m_pModPython->GetPyExceptionStr();
		DEBUG("modpython: " << (GetUser() ? GetUser()->GetUserName() : CString("<no user>")) << "/" << GetModName() << "/OnPart: can't convert parameter 'Nick' to PyObject: " << sPyErr);
		Py_CLEAR(pyName);
		return CModule::OnPart(Nick, Channel, sMessage);
	}
	PyObject* pyArg_Channel = SWIG_NewInstanceObj(const_cast<CChan*>(&Channel), SWIG_TypeQuery("CChan*"), 0);
	if (!pyArg_Channel) {
		CString sPyErr = m_pModPython->GetPyExceptionStr();
		DEBUG("modpython: " << (GetUser() ? GetUser()->GetUserName() : CString("<no user>")) << "/" << GetModName() << "/OnPart: can't convert parameter 'Channel' to PyObject: " << sPyErr);
		Py_CLEAR(pyName);
		Py_CLEAR(pyArg_Nick);
		return CModule::OnPart(Nick, Channel, sMessage);
	}
	PyObject* pyArg_sMessage = Py_BuildValue("s", sMessage.c_str());
	if (!pyArg_sMessage) {
		CString sPyErr = m_pModPython->GetPyExceptionStr();
		DEBUG("modpython: " << (GetUser() ? GetUser()->GetUserName() : CString("<no user>")) << "/" << GetModName() << "/OnPart: can't convert parameter 'sMessage' to PyObject: " << sPyErr);
		Py_CLEAR(pyName);
		Py_CLEAR(pyArg_Nick);
		Py_CLEAR(pyArg_Channel);
		return CModule::OnPart(Nick, Channel, sMessage);
	}
	PyObject* pyRes = PyObject_CallMethodObjArgs(m_pyObj, pyName, pyArg_Nick, pyArg_Channel, pyArg_sMessage, nullptr);
	if (!pyRes) {
		CString sPyErr = m_pModPython->GetPyExceptionStr();
		DEBUG("modpython: " << (GetUser() ? GetUser()->GetUserName() : CString("<no user>")) << "/" << GetModName() << "/OnPart failed: " << sPyErr);
		Py_CLEAR(pyName);
		Py_CLEAR(pyArg_Nick);
		Py_CLEAR(pyArg_Channel);
		Py_CLEAR(pyArg_sMessage);
		return CModule::OnPart(Nick, Channel, sMessage);
	}
	Py_CLEAR(pyName);
	Py_CLEAR(pyArg_Nick);
	Py_CLEAR(pyArg_Channel);
	Py_CLEAR(pyArg_sMessage);
	Py_CLEAR(pyRes);
}

CModule::EModRet CPyModule::OnInvite(const CNick& Nick, const CString& sChan) {
	PyObject* pyName = Py_BuildValue("s", "OnInvite");
	if (!pyName) {
		CString sPyErr = m_pModPython->GetPyExceptionStr();
		DEBUG("modpython: " << (GetUser() ? GetUser()->GetUserName() : CString("<no user>")) << "/" << GetModName() << "/OnInvite: can't convert string 'OnInvite' to PyObject: " << sPyErr);
		return CModule::OnInvite(Nick, sChan);
	}
	PyObject* pyArg_Nick = SWIG_NewInstanceObj(const_cast< CNick*>(&Nick), SWIG_TypeQuery(" CNick*"), 0);
	if (!pyArg_Nick) {
		CString sPyErr = m_pModPython->GetPyExceptionStr();
		DEBUG("modpython: " << (GetUser() ? GetUser()->GetUserName() : CString("<no user>")) << "/" << GetModName() << "/OnInvite: can't convert parameter 'Nick' to PyObject: " << sPyErr);
		Py_CLEAR(pyName);
		return CModule::OnInvite(Nick, sChan);
	}
	PyObject* pyArg_sChan = Py_BuildValue("s", sChan.c_str());
	if (!pyArg_sChan) {
		CString sPyErr = m_pModPython->GetPyExceptionStr();
		DEBUG("modpython: " << (GetUser() ? GetUser()->GetUserName() : CString("<no user>")) << "/" << GetModName() << "/OnInvite: can't convert parameter 'sChan' to PyObject: " << sPyErr);
		Py_CLEAR(pyName);
		Py_CLEAR(pyArg_Nick);
		return CModule::OnInvite(Nick, sChan);
	}
	PyObject* pyRes = PyObject_CallMethodObjArgs(m_pyObj, pyName, pyArg_Nick, pyArg_sChan, nullptr);
	if (!pyRes) {
		CString sPyErr = m_pModPython->GetPyExceptionStr();
		DEBUG("modpython: " << (GetUser() ? GetUser()->GetUserName() : CString("<no user>")) << "/" << GetModName() << "/OnInvite failed: " << sPyErr);
		Py_CLEAR(pyName);
		Py_CLEAR(pyArg_Nick);
		Py_CLEAR(pyArg_sChan);
		return CModule::OnInvite(Nick, sChan);
	}
	Py_CLEAR(pyName);
	Py_CLEAR(pyArg_Nick);
	Py_CLEAR(pyArg_sChan);
	CModule::EModRet result;
	if (pyRes == Py_None) {
		result = CModule::OnInvite(Nick, sChan);
	} else {
		long int x = PyLong_AsLong(pyRes);
		if (PyErr_Occurred()) {
			CString sPyErr = m_pModPython->GetPyExceptionStr();
			DEBUG("modpython: " << (GetUser() ? GetUser()->GetUserName() : CString("<no user>")) << "/" << GetModName() << "/OnInvite was expected to return EModRet but: " << sPyErr);
			result = CModule::OnInvite(Nick, sChan);
		} else { result = (CModule::EModRet)x; }
	}
	Py_CLEAR(pyRes);
	return result;
}

CModule::EModRet CPyModule::OnChanBufferStarting(CChan& Chan, CClient& Client) {
	PyObject* pyName = Py_BuildValue("s", "OnChanBufferStarting");
	if (!pyName) {
		CString sPyErr = m_pModPython->GetPyExceptionStr();
		DEBUG("modpython: " << (GetUser() ? GetUser()->GetUserName() : CString("<no user>")) << "/" << GetModName() << "/OnChanBufferStarting: can't convert string 'OnChanBufferStarting' to PyObject: " << sPyErr);
		return CModule::OnChanBufferStarting(Chan, Client);
	}
	PyObject* pyArg_Chan = SWIG_NewInstanceObj(const_cast<CChan*>(&Chan), SWIG_TypeQuery("CChan*"), 0);
	if (!pyArg_Chan) {
		CString sPyErr = m_pModPython->GetPyExceptionStr();
		DEBUG("modpython: " << (GetUser() ? GetUser()->GetUserName() : CString("<no user>")) << "/" << GetModName() << "/OnChanBufferStarting: can't convert parameter 'Chan' to PyObject: " << sPyErr);
		Py_CLEAR(pyName);
		return CModule::OnChanBufferStarting(Chan, Client);
	}
	PyObject* pyArg_Client = SWIG_NewInstanceObj(const_cast<CClient*>(&Client), SWIG_TypeQuery("CClient*"), 0);
	if (!pyArg_Client) {
		CString sPyErr = m_pModPython->GetPyExceptionStr();
		DEBUG("modpython: " << (GetUser() ? GetUser()->GetUserName() : CString("<no user>")) << "/" << GetModName() << "/OnChanBufferStarting: can't convert parameter 'Client' to PyObject: " << sPyErr);
		Py_CLEAR(pyName);
		Py_CLEAR(pyArg_Chan);
		return CModule::OnChanBufferStarting(Chan, Client);
	}
	PyObject* pyRes = PyObject_CallMethodObjArgs(m_pyObj, pyName, pyArg_Chan, pyArg_Client, nullptr);
	if (!pyRes) {
		CString sPyErr = m_pModPython->GetPyExceptionStr();
		DEBUG("modpython: " << (GetUser() ? GetUser()->GetUserName() : CString("<no user>")) << "/" << GetModName() << "/OnChanBufferStarting failed: " << sPyErr);
		Py_CLEAR(pyName);
		Py_CLEAR(pyArg_Chan);
		Py_CLEAR(pyArg_Client);
		return CModule::OnChanBufferStarting(Chan, Client);
	}
	Py_CLEAR(pyName);
	Py_CLEAR(pyArg_Chan);
	Py_CLEAR(pyArg_Client);
	CModule::EModRet result;
	if (pyRes == Py_None) {
		result = CModule::OnChanBufferStarting(Chan, Client);
	} else {
		long int x = PyLong_AsLong(pyRes);
		if (PyErr_Occurred()) {
			CString sPyErr = m_pModPython->GetPyExceptionStr();
			DEBUG("modpython: " << (GetUser() ? GetUser()->GetUserName() : CString("<no user>")) << "/" << GetModName() << "/OnChanBufferStarting was expected to return EModRet but: " << sPyErr);
			result = CModule::OnChanBufferStarting(Chan, Client);
		} else { result = (CModule::EModRet)x; }
	}
	Py_CLEAR(pyRes);
	return result;
}

CModule::EModRet CPyModule::OnChanBufferEnding(CChan& Chan, CClient& Client) {
	PyObject* pyName = Py_BuildValue("s", "OnChanBufferEnding");
	if (!pyName) {
		CString sPyErr = m_pModPython->GetPyExceptionStr();
		DEBUG("modpython: " << (GetUser() ? GetUser()->GetUserName() : CString("<no user>")) << "/" << GetModName() << "/OnChanBufferEnding: can't convert string 'OnChanBufferEnding' to PyObject: " << sPyErr);
		return CModule::OnChanBufferEnding(Chan, Client);
	}
	PyObject* pyArg_Chan = SWIG_NewInstanceObj(const_cast<CChan*>(&Chan), SWIG_TypeQuery("CChan*"), 0);
	if (!pyArg_Chan) {
		CString sPyErr = m_pModPython->GetPyExceptionStr();
		DEBUG("modpython: " << (GetUser() ? GetUser()->GetUserName() : CString("<no user>")) << "/" << GetModName() << "/OnChanBufferEnding: can't convert parameter 'Chan' to PyObject: " << sPyErr);
		Py_CLEAR(pyName);
		return CModule::OnChanBufferEnding(Chan, Client);
	}
	PyObject* pyArg_Client = SWIG_NewInstanceObj(const_cast<CClient*>(&Client), SWIG_TypeQuery("CClient*"), 0);
	if (!pyArg_Client) {
		CString sPyErr = m_pModPython->GetPyExceptionStr();
		DEBUG("modpython: " << (GetUser() ? GetUser()->GetUserName() : CString("<no user>")) << "/" << GetModName() << "/OnChanBufferEnding: can't convert parameter 'Client' to PyObject: " << sPyErr);
		Py_CLEAR(pyName);
		Py_CLEAR(pyArg_Chan);
		return CModule::OnChanBufferEnding(Chan, Client);
	}
	PyObject* pyRes = PyObject_CallMethodObjArgs(m_pyObj, pyName, pyArg_Chan, pyArg_Client, nullptr);
	if (!pyRes) {
		CString sPyErr = m_pModPython->GetPyExceptionStr();
		DEBUG("modpython: " << (GetUser() ? GetUser()->GetUserName() : CString("<no user>")) << "/" << GetModName() << "/OnChanBufferEnding failed: " << sPyErr);
		Py_CLEAR(pyName);
		Py_CLEAR(pyArg_Chan);
		Py_CLEAR(pyArg_Client);
		return CModule::OnChanBufferEnding(Chan, Client);
	}
	Py_CLEAR(pyName);
	Py_CLEAR(pyArg_Chan);
	Py_CLEAR(pyArg_Client);
	CModule::EModRet result;
	if (pyRes == Py_None) {
		result = CModule::OnChanBufferEnding(Chan, Client);
	} else {
		long int x = PyLong_AsLong(pyRes);
		if (PyErr_Occurred()) {
			CString sPyErr = m_pModPython->GetPyExceptionStr();
			DEBUG("modpython: " << (GetUser() ? GetUser()->GetUserName() : CString("<no user>")) << "/" << GetModName() << "/OnChanBufferEnding was expected to return EModRet but: " << sPyErr);
			result = CModule::OnChanBufferEnding(Chan, Client);
		} else { result = (CModule::EModRet)x; }
	}
	Py_CLEAR(pyRes);
	return result;
}

CModule::EModRet CPyModule::OnChanBufferPlayLine(CChan& Chan, CClient& Client, CString& sLine) {
	PyObject* pyName = Py_BuildValue("s", "OnChanBufferPlayLine");
	if (!pyName) {
		CString sPyErr = m_pModPython->GetPyExceptionStr();
		DEBUG("modpython: " << (GetUser() ? GetUser()->GetUserName() : CString("<no user>")) << "/" << GetModName() << "/OnChanBufferPlayLine: can't convert string 'OnChanBufferPlayLine' to PyObject: " << sPyErr);
		return CModule::OnChanBufferPlayLine(Chan, Client, sLine);
	}
	PyObject* pyArg_Chan = SWIG_NewInstanceObj(const_cast<CChan*>(&Chan), SWIG_TypeQuery("CChan*"), 0);
	if (!pyArg_Chan) {
		CString sPyErr = m_pModPython->GetPyExceptionStr();
		DEBUG("modpython: " << (GetUser() ? GetUser()->GetUserName() : CString("<no user>")) << "/" << GetModName() << "/OnChanBufferPlayLine: can't convert parameter 'Chan' to PyObject: " << sPyErr);
		Py_CLEAR(pyName);
		return CModule::OnChanBufferPlayLine(Chan, Client, sLine);
	}
	PyObject* pyArg_Client = SWIG_NewInstanceObj(const_cast<CClient*>(&Client), SWIG_TypeQuery("CClient*"), 0);
	if (!pyArg_Client) {
		CString sPyErr = m_pModPython->GetPyExceptionStr();
		DEBUG("modpython: " << (GetUser() ? GetUser()->GetUserName() : CString("<no user>")) << "/" << GetModName() << "/OnChanBufferPlayLine: can't convert parameter 'Client' to PyObject: " << sPyErr);
		Py_CLEAR(pyName);
		Py_CLEAR(pyArg_Chan);
		return CModule::OnChanBufferPlayLine(Chan, Client, sLine);
	}
	PyObject* pyArg_sLine = CPyRetString::wrap(sLine);
	if (!pyArg_sLine) {
		CString sPyErr = m_pModPython->GetPyExceptionStr();
		DEBUG("modpython: " << (GetUser() ? GetUser()->GetUserName() : CString("<no user>")) << "/" << GetModName() << "/OnChanBufferPlayLine: can't convert parameter 'sLine' to PyObject: " << sPyErr);
		Py_CLEAR(pyName);
		Py_CLEAR(pyArg_Chan);
		Py_CLEAR(pyArg_Client);
		return CModule::OnChanBufferPlayLine(Chan, Client, sLine);
	}
	PyObject* pyRes = PyObject_CallMethodObjArgs(m_pyObj, pyName, pyArg_Chan, pyArg_Client, pyArg_sLine, nullptr);
	if (!pyRes) {
		CString sPyErr = m_pModPython->GetPyExceptionStr();
		DEBUG("modpython: " << (GetUser() ? GetUser()->GetUserName() : CString("<no user>")) << "/" << GetModName() << "/OnChanBufferPlayLine failed: " << sPyErr);
		Py_CLEAR(pyName);
		Py_CLEAR(pyArg_Chan);
		Py_CLEAR(pyArg_Client);
		Py_CLEAR(pyArg_sLine);
		return CModule::OnChanBufferPlayLine(Chan, Client, sLine);
	}
	Py_CLEAR(pyName);
	Py_CLEAR(pyArg_Chan);
	Py_CLEAR(pyArg_Client);
	Py_CLEAR(pyArg_sLine);
	CModule::EModRet result;
	if (pyRes == Py_None) {
		result = CModule::OnChanBufferPlayLine(Chan, Client, sLine);
	} else {
		long int x = PyLong_AsLong(pyRes);
		if (PyErr_Occurred()) {
			CString sPyErr = m_pModPython->GetPyExceptionStr();
			DEBUG("modpython: " << (GetUser() ? GetUser()->GetUserName() : CString("<no user>")) << "/" << GetModName() << "/OnChanBufferPlayLine was expected to return EModRet but: " << sPyErr);
			result = CModule::OnChanBufferPlayLine(Chan, Client, sLine);
		} else { result = (CModule::EModRet)x; }
	}
	Py_CLEAR(pyRes);
	return result;
}

CModule::EModRet CPyModule::OnPrivBufferPlayLine(CClient& Client, CString& sLine) {
	PyObject* pyName = Py_BuildValue("s", "OnPrivBufferPlayLine");
	if (!pyName) {
		CString sPyErr = m_pModPython->GetPyExceptionStr();
		DEBUG("modpython: " << (GetUser() ? GetUser()->GetUserName() : CString("<no user>")) << "/" << GetModName() << "/OnPrivBufferPlayLine: can't convert string 'OnPrivBufferPlayLine' to PyObject: " << sPyErr);
		return CModule::OnPrivBufferPlayLine(Client, sLine);
	}
	PyObject* pyArg_Client = SWIG_NewInstanceObj(const_cast<CClient*>(&Client), SWIG_TypeQuery("CClient*"), 0);
	if (!pyArg_Client) {
		CString sPyErr = m_pModPython->GetPyExceptionStr();
		DEBUG("modpython: " << (GetUser() ? GetUser()->GetUserName() : CString("<no user>")) << "/" << GetModName() << "/OnPrivBufferPlayLine: can't convert parameter 'Client' to PyObject: " << sPyErr);
		Py_CLEAR(pyName);
		return CModule::OnPrivBufferPlayLine(Client, sLine);
	}
	PyObject* pyArg_sLine = CPyRetString::wrap(sLine);
	if (!pyArg_sLine) {
		CString sPyErr = m_pModPython->GetPyExceptionStr();
		DEBUG("modpython: " << (GetUser() ? GetUser()->GetUserName() : CString("<no user>")) << "/" << GetModName() << "/OnPrivBufferPlayLine: can't convert parameter 'sLine' to PyObject: " << sPyErr);
		Py_CLEAR(pyName);
		Py_CLEAR(pyArg_Client);
		return CModule::OnPrivBufferPlayLine(Client, sLine);
	}
	PyObject* pyRes = PyObject_CallMethodObjArgs(m_pyObj, pyName, pyArg_Client, pyArg_sLine, nullptr);
	if (!pyRes) {
		CString sPyErr = m_pModPython->GetPyExceptionStr();
		DEBUG("modpython: " << (GetUser() ? GetUser()->GetUserName() : CString("<no user>")) << "/" << GetModName() << "/OnPrivBufferPlayLine failed: " << sPyErr);
		Py_CLEAR(pyName);
		Py_CLEAR(pyArg_Client);
		Py_CLEAR(pyArg_sLine);
		return CModule::OnPrivBufferPlayLine(Client, sLine);
	}
	Py_CLEAR(pyName);
	Py_CLEAR(pyArg_Client);
	Py_CLEAR(pyArg_sLine);
	CModule::EModRet result;
	if (pyRes == Py_None) {
		result = CModule::OnPrivBufferPlayLine(Client, sLine);
	} else {
		long int x = PyLong_AsLong(pyRes);
		if (PyErr_Occurred()) {
			CString sPyErr = m_pModPython->GetPyExceptionStr();
			DEBUG("modpython: " << (GetUser() ? GetUser()->GetUserName() : CString("<no user>")) << "/" << GetModName() << "/OnPrivBufferPlayLine was expected to return EModRet but: " << sPyErr);
			result = CModule::OnPrivBufferPlayLine(Client, sLine);
		} else { result = (CModule::EModRet)x; }
	}
	Py_CLEAR(pyRes);
	return result;
}

void CPyModule::OnClientLogin() {
	PyObject* pyName = Py_BuildValue("s", "OnClientLogin");
	if (!pyName) {
		CString sPyErr = m_pModPython->GetPyExceptionStr();
		DEBUG("modpython: " << (GetUser() ? GetUser()->GetUserName() : CString("<no user>")) << "/" << GetModName() << "/OnClientLogin: can't convert string 'OnClientLogin' to PyObject: " << sPyErr);
		return CModule::OnClientLogin();
	}
	PyObject* pyRes = PyObject_CallMethodObjArgs(m_pyObj, pyName, nullptr);
	if (!pyRes) {
		CString sPyErr = m_pModPython->GetPyExceptionStr();
		DEBUG("modpython: " << (GetUser() ? GetUser()->GetUserName() : CString("<no user>")) << "/" << GetModName() << "/OnClientLogin failed: " << sPyErr);
		Py_CLEAR(pyName);
		return CModule::OnClientLogin();
	}
	Py_CLEAR(pyName);
	Py_CLEAR(pyRes);
}

void CPyModule::OnClientDisconnect() {
	PyObject* pyName = Py_BuildValue("s", "OnClientDisconnect");
	if (!pyName) {
		CString sPyErr = m_pModPython->GetPyExceptionStr();
		DEBUG("modpython: " << (GetUser() ? GetUser()->GetUserName() : CString("<no user>")) << "/" << GetModName() << "/OnClientDisconnect: can't convert string 'OnClientDisconnect' to PyObject: " << sPyErr);
		return CModule::OnClientDisconnect();
	}
	PyObject* pyRes = PyObject_CallMethodObjArgs(m_pyObj, pyName, nullptr);
	if (!pyRes) {
		CString sPyErr = m_pModPython->GetPyExceptionStr();
		DEBUG("modpython: " << (GetUser() ? GetUser()->GetUserName() : CString("<no user>")) << "/" << GetModName() << "/OnClientDisconnect failed: " << sPyErr);
		Py_CLEAR(pyName);
		return CModule::OnClientDisconnect();
	}
	Py_CLEAR(pyName);
	Py_CLEAR(pyRes);
}

CModule::EModRet CPyModule::OnUserRaw(CString& sLine) {
	PyObject* pyName = Py_BuildValue("s", "OnUserRaw");
	if (!pyName) {
		CString sPyErr = m_pModPython->GetPyExceptionStr();
		DEBUG("modpython: " << (GetUser() ? GetUser()->GetUserName() : CString("<no user>")) << "/" << GetModName() << "/OnUserRaw: can't convert string 'OnUserRaw' to PyObject: " << sPyErr);
		return CModule::OnUserRaw(sLine);
	}
	PyObject* pyArg_sLine = CPyRetString::wrap(sLine);
	if (!pyArg_sLine) {
		CString sPyErr = m_pModPython->GetPyExceptionStr();
		DEBUG("modpython: " << (GetUser() ? GetUser()->GetUserName() : CString("<no user>")) << "/" << GetModName() << "/OnUserRaw: can't convert parameter 'sLine' to PyObject: " << sPyErr);
		Py_CLEAR(pyName);
		return CModule::OnUserRaw(sLine);
	}
	PyObject* pyRes = PyObject_CallMethodObjArgs(m_pyObj, pyName, pyArg_sLine, nullptr);
	if (!pyRes) {
		CString sPyErr = m_pModPython->GetPyExceptionStr();
		DEBUG("modpython: " << (GetUser() ? GetUser()->GetUserName() : CString("<no user>")) << "/" << GetModName() << "/OnUserRaw failed: " << sPyErr);
		Py_CLEAR(pyName);
		Py_CLEAR(pyArg_sLine);
		return CModule::OnUserRaw(sLine);
	}
	Py_CLEAR(pyName);
	Py_CLEAR(pyArg_sLine);
	CModule::EModRet result;
	if (pyRes == Py_None) {
		result = CModule::OnUserRaw(sLine);
	} else {
		long int x = PyLong_AsLong(pyRes);
		if (PyErr_Occurred()) {
			CString sPyErr = m_pModPython->GetPyExceptionStr();
			DEBUG("modpython: " << (GetUser() ? GetUser()->GetUserName() : CString("<no user>")) << "/" << GetModName() << "/OnUserRaw was expected to return EModRet but: " << sPyErr);
			result = CModule::OnUserRaw(sLine);
		} else { result = (CModule::EModRet)x; }
	}
	Py_CLEAR(pyRes);
	return result;
}

CModule::EModRet CPyModule::OnUserCTCPReply(CString& sTarget, CString& sMessage) {
	PyObject* pyName = Py_BuildValue("s", "OnUserCTCPReply");
	if (!pyName) {
		CString sPyErr = m_pModPython->GetPyExceptionStr();
		DEBUG("modpython: " << (GetUser() ? GetUser()->GetUserName() : CString("<no user>")) << "/" << GetModName() << "/OnUserCTCPReply: can't convert string 'OnUserCTCPReply' to PyObject: " << sPyErr);
		return CModule::OnUserCTCPReply(sTarget, sMessage);
	}
	PyObject* pyArg_sTarget = CPyRetString::wrap(sTarget);
	if (!pyArg_sTarget) {
		CString sPyErr = m_pModPython->GetPyExceptionStr();
		DEBUG("modpython: " << (GetUser() ? GetUser()->GetUserName() : CString("<no user>")) << "/" << GetModName() << "/OnUserCTCPReply: can't convert parameter 'sTarget' to PyObject: " << sPyErr);
		Py_CLEAR(pyName);
		return CModule::OnUserCTCPReply(sTarget, sMessage);
	}
	PyObject* pyArg_sMessage = CPyRetString::wrap(sMessage);
	if (!pyArg_sMessage) {
		CString sPyErr = m_pModPython->GetPyExceptionStr();
		DEBUG("modpython: " << (GetUser() ? GetUser()->GetUserName() : CString("<no user>")) << "/" << GetModName() << "/OnUserCTCPReply: can't convert parameter 'sMessage' to PyObject: " << sPyErr);
		Py_CLEAR(pyName);
		Py_CLEAR(pyArg_sTarget);
		return CModule::OnUserCTCPReply(sTarget, sMessage);
	}
	PyObject* pyRes = PyObject_CallMethodObjArgs(m_pyObj, pyName, pyArg_sTarget, pyArg_sMessage, nullptr);
	if (!pyRes) {
		CString sPyErr = m_pModPython->GetPyExceptionStr();
		DEBUG("modpython: " << (GetUser() ? GetUser()->GetUserName() : CString("<no user>")) << "/" << GetModName() << "/OnUserCTCPReply failed: " << sPyErr);
		Py_CLEAR(pyName);
		Py_CLEAR(pyArg_sTarget);
		Py_CLEAR(pyArg_sMessage);
		return CModule::OnUserCTCPReply(sTarget, sMessage);
	}
	Py_CLEAR(pyName);
	Py_CLEAR(pyArg_sTarget);
	Py_CLEAR(pyArg_sMessage);
	CModule::EModRet result;
	if (pyRes == Py_None) {
		result = CModule::OnUserCTCPReply(sTarget, sMessage);
	} else {
		long int x = PyLong_AsLong(pyRes);
		if (PyErr_Occurred()) {
			CString sPyErr = m_pModPython->GetPyExceptionStr();
			DEBUG("modpython: " << (GetUser() ? GetUser()->GetUserName() : CString("<no user>")) << "/" << GetModName() << "/OnUserCTCPReply was expected to return EModRet but: " << sPyErr);
			result = CModule::OnUserCTCPReply(sTarget, sMessage);
		} else { result = (CModule::EModRet)x; }
	}
	Py_CLEAR(pyRes);
	return result;
}

CModule::EModRet CPyModule::OnUserCTCP(CString& sTarget, CString& sMessage) {
	PyObject* pyName = Py_BuildValue("s", "OnUserCTCP");
	if (!pyName) {
		CString sPyErr = m_pModPython->GetPyExceptionStr();
		DEBUG("modpython: " << (GetUser() ? GetUser()->GetUserName() : CString("<no user>")) << "/" << GetModName() << "/OnUserCTCP: can't convert string 'OnUserCTCP' to PyObject: " << sPyErr);
		return CModule::OnUserCTCP(sTarget, sMessage);
	}
	PyObject* pyArg_sTarget = CPyRetString::wrap(sTarget);
	if (!pyArg_sTarget) {
		CString sPyErr = m_pModPython->GetPyExceptionStr();
		DEBUG("modpython: " << (GetUser() ? GetUser()->GetUserName() : CString("<no user>")) << "/" << GetModName() << "/OnUserCTCP: can't convert parameter 'sTarget' to PyObject: " << sPyErr);
		Py_CLEAR(pyName);
		return CModule::OnUserCTCP(sTarget, sMessage);
	}
	PyObject* pyArg_sMessage = CPyRetString::wrap(sMessage);
	if (!pyArg_sMessage) {
		CString sPyErr = m_pModPython->GetPyExceptionStr();
		DEBUG("modpython: " << (GetUser() ? GetUser()->GetUserName() : CString("<no user>")) << "/" << GetModName() << "/OnUserCTCP: can't convert parameter 'sMessage' to PyObject: " << sPyErr);
		Py_CLEAR(pyName);
		Py_CLEAR(pyArg_sTarget);
		return CModule::OnUserCTCP(sTarget, sMessage);
	}
	PyObject* pyRes = PyObject_CallMethodObjArgs(m_pyObj, pyName, pyArg_sTarget, pyArg_sMessage, nullptr);
	if (!pyRes) {
		CString sPyErr = m_pModPython->GetPyExceptionStr();
		DEBUG("modpython: " << (GetUser() ? GetUser()->GetUserName() : CString("<no user>")) << "/" << GetModName() << "/OnUserCTCP failed: " << sPyErr);
		Py_CLEAR(pyName);
		Py_CLEAR(pyArg_sTarget);
		Py_CLEAR(pyArg_sMessage);
		return CModule::OnUserCTCP(sTarget, sMessage);
	}
	Py_CLEAR(pyName);
	Py_CLEAR(pyArg_sTarget);
	Py_CLEAR(pyArg_sMessage);
	CModule::EModRet result;
	if (pyRes == Py_None) {
		result = CModule::OnUserCTCP(sTarget, sMessage);
	} else {
		long int x = PyLong_AsLong(pyRes);
		if (PyErr_Occurred()) {
			CString sPyErr = m_pModPython->GetPyExceptionStr();
			DEBUG("modpython: " << (GetUser() ? GetUser()->GetUserName() : CString("<no user>")) << "/" << GetModName() << "/OnUserCTCP was expected to return EModRet but: " << sPyErr);
			result = CModule::OnUserCTCP(sTarget, sMessage);
		} else { result = (CModule::EModRet)x; }
	}
	Py_CLEAR(pyRes);
	return result;
}

CModule::EModRet CPyModule::OnUserAction(CString& sTarget, CString& sMessage) {
	PyObject* pyName = Py_BuildValue("s", "OnUserAction");
	if (!pyName) {
		CString sPyErr = m_pModPython->GetPyExceptionStr();
		DEBUG("modpython: " << (GetUser() ? GetUser()->GetUserName() : CString("<no user>")) << "/" << GetModName() << "/OnUserAction: can't convert string 'OnUserAction' to PyObject: " << sPyErr);
		return CModule::OnUserAction(sTarget, sMessage);
	}
	PyObject* pyArg_sTarget = CPyRetString::wrap(sTarget);
	if (!pyArg_sTarget) {
		CString sPyErr = m_pModPython->GetPyExceptionStr();
		DEBUG("modpython: " << (GetUser() ? GetUser()->GetUserName() : CString("<no user>")) << "/" << GetModName() << "/OnUserAction: can't convert parameter 'sTarget' to PyObject: " << sPyErr);
		Py_CLEAR(pyName);
		return CModule::OnUserAction(sTarget, sMessage);
	}
	PyObject* pyArg_sMessage = CPyRetString::wrap(sMessage);
	if (!pyArg_sMessage) {
		CString sPyErr = m_pModPython->GetPyExceptionStr();
		DEBUG("modpython: " << (GetUser() ? GetUser()->GetUserName() : CString("<no user>")) << "/" << GetModName() << "/OnUserAction: can't convert parameter 'sMessage' to PyObject: " << sPyErr);
		Py_CLEAR(pyName);
		Py_CLEAR(pyArg_sTarget);
		return CModule::OnUserAction(sTarget, sMessage);
	}
	PyObject* pyRes = PyObject_CallMethodObjArgs(m_pyObj, pyName, pyArg_sTarget, pyArg_sMessage, nullptr);
	if (!pyRes) {
		CString sPyErr = m_pModPython->GetPyExceptionStr();
		DEBUG("modpython: " << (GetUser() ? GetUser()->GetUserName() : CString("<no user>")) << "/" << GetModName() << "/OnUserAction failed: " << sPyErr);
		Py_CLEAR(pyName);
		Py_CLEAR(pyArg_sTarget);
		Py_CLEAR(pyArg_sMessage);
		return CModule::OnUserAction(sTarget, sMessage);
	}
	Py_CLEAR(pyName);
	Py_CLEAR(pyArg_sTarget);
	Py_CLEAR(pyArg_sMessage);
	CModule::EModRet result;
	if (pyRes == Py_None) {
		result = CModule::OnUserAction(sTarget, sMessage);
	} else {
		long int x = PyLong_AsLong(pyRes);
		if (PyErr_Occurred()) {
			CString sPyErr = m_pModPython->GetPyExceptionStr();
			DEBUG("modpython: " << (GetUser() ? GetUser()->GetUserName() : CString("<no user>")) << "/" << GetModName() << "/OnUserAction was expected to return EModRet but: " << sPyErr);
			result = CModule::OnUserAction(sTarget, sMessage);
		} else { result = (CModule::EModRet)x; }
	}
	Py_CLEAR(pyRes);
	return result;
}

CModule::EModRet CPyModule::OnUserMsg(CString& sTarget, CString& sMessage) {
	PyObject* pyName = Py_BuildValue("s", "OnUserMsg");
	if (!pyName) {
		CString sPyErr = m_pModPython->GetPyExceptionStr();
		DEBUG("modpython: " << (GetUser() ? GetUser()->GetUserName() : CString("<no user>")) << "/" << GetModName() << "/OnUserMsg: can't convert string 'OnUserMsg' to PyObject: " << sPyErr);
		return CModule::OnUserMsg(sTarget, sMessage);
	}
	PyObject* pyArg_sTarget = CPyRetString::wrap(sTarget);
	if (!pyArg_sTarget) {
		CString sPyErr = m_pModPython->GetPyExceptionStr();
		DEBUG("modpython: " << (GetUser() ? GetUser()->GetUserName() : CString("<no user>")) << "/" << GetModName() << "/OnUserMsg: can't convert parameter 'sTarget' to PyObject: " << sPyErr);
		Py_CLEAR(pyName);
		return CModule::OnUserMsg(sTarget, sMessage);
	}
	PyObject* pyArg_sMessage = CPyRetString::wrap(sMessage);
	if (!pyArg_sMessage) {
		CString sPyErr = m_pModPython->GetPyExceptionStr();
		DEBUG("modpython: " << (GetUser() ? GetUser()->GetUserName() : CString("<no user>")) << "/" << GetModName() << "/OnUserMsg: can't convert parameter 'sMessage' to PyObject: " << sPyErr);
		Py_CLEAR(pyName);
		Py_CLEAR(pyArg_sTarget);
		return CModule::OnUserMsg(sTarget, sMessage);
	}
	PyObject* pyRes = PyObject_CallMethodObjArgs(m_pyObj, pyName, pyArg_sTarget, pyArg_sMessage, nullptr);
	if (!pyRes) {
		CString sPyErr = m_pModPython->GetPyExceptionStr();
		DEBUG("modpython: " << (GetUser() ? GetUser()->GetUserName() : CString("<no user>")) << "/" << GetModName() << "/OnUserMsg failed: " << sPyErr);
		Py_CLEAR(pyName);
		Py_CLEAR(pyArg_sTarget);
		Py_CLEAR(pyArg_sMessage);
		return CModule::OnUserMsg(sTarget, sMessage);
	}
	Py_CLEAR(pyName);
	Py_CLEAR(pyArg_sTarget);
	Py_CLEAR(pyArg_sMessage);
	CModule::EModRet result;
	if (pyRes == Py_None) {
		result = CModule::OnUserMsg(sTarget, sMessage);
	} else {
		long int x = PyLong_AsLong(pyRes);
		if (PyErr_Occurred()) {
			CString sPyErr = m_pModPython->GetPyExceptionStr();
			DEBUG("modpython: " << (GetUser() ? GetUser()->GetUserName() : CString("<no user>")) << "/" << GetModName() << "/OnUserMsg was expected to return EModRet but: " << sPyErr);
			result = CModule::OnUserMsg(sTarget, sMessage);
		} else { result = (CModule::EModRet)x; }
	}
	Py_CLEAR(pyRes);
	return result;
}

CModule::EModRet CPyModule::OnUserNotice(CString& sTarget, CString& sMessage) {
	PyObject* pyName = Py_BuildValue("s", "OnUserNotice");
	if (!pyName) {
		CString sPyErr = m_pModPython->GetPyExceptionStr();
		DEBUG("modpython: " << (GetUser() ? GetUser()->GetUserName() : CString("<no user>")) << "/" << GetModName() << "/OnUserNotice: can't convert string 'OnUserNotice' to PyObject: " << sPyErr);
		return CModule::OnUserNotice(sTarget, sMessage);
	}
	PyObject* pyArg_sTarget = CPyRetString::wrap(sTarget);
	if (!pyArg_sTarget) {
		CString sPyErr = m_pModPython->GetPyExceptionStr();
		DEBUG("modpython: " << (GetUser() ? GetUser()->GetUserName() : CString("<no user>")) << "/" << GetModName() << "/OnUserNotice: can't convert parameter 'sTarget' to PyObject: " << sPyErr);
		Py_CLEAR(pyName);
		return CModule::OnUserNotice(sTarget, sMessage);
	}
	PyObject* pyArg_sMessage = CPyRetString::wrap(sMessage);
	if (!pyArg_sMessage) {
		CString sPyErr = m_pModPython->GetPyExceptionStr();
		DEBUG("modpython: " << (GetUser() ? GetUser()->GetUserName() : CString("<no user>")) << "/" << GetModName() << "/OnUserNotice: can't convert parameter 'sMessage' to PyObject: " << sPyErr);
		Py_CLEAR(pyName);
		Py_CLEAR(pyArg_sTarget);
		return CModule::OnUserNotice(sTarget, sMessage);
	}
	PyObject* pyRes = PyObject_CallMethodObjArgs(m_pyObj, pyName, pyArg_sTarget, pyArg_sMessage, nullptr);
	if (!pyRes) {
		CString sPyErr = m_pModPython->GetPyExceptionStr();
		DEBUG("modpython: " << (GetUser() ? GetUser()->GetUserName() : CString("<no user>")) << "/" << GetModName() << "/OnUserNotice failed: " << sPyErr);
		Py_CLEAR(pyName);
		Py_CLEAR(pyArg_sTarget);
		Py_CLEAR(pyArg_sMessage);
		return CModule::OnUserNotice(sTarget, sMessage);
	}
	Py_CLEAR(pyName);
	Py_CLEAR(pyArg_sTarget);
	Py_CLEAR(pyArg_sMessage);
	CModule::EModRet result;
	if (pyRes == Py_None) {
		result = CModule::OnUserNotice(sTarget, sMessage);
	} else {
		long int x = PyLong_AsLong(pyRes);
		if (PyErr_Occurred()) {
			CString sPyErr = m_pModPython->GetPyExceptionStr();
			DEBUG("modpython: " << (GetUser() ? GetUser()->GetUserName() : CString("<no user>")) << "/" << GetModName() << "/OnUserNotice was expected to return EModRet but: " << sPyErr);
			result = CModule::OnUserNotice(sTarget, sMessage);
		} else { result = (CModule::EModRet)x; }
	}
	Py_CLEAR(pyRes);
	return result;
}

CModule::EModRet CPyModule::OnUserJoin(CString& sChannel, CString& sKey) {
	PyObject* pyName = Py_BuildValue("s", "OnUserJoin");
	if (!pyName) {
		CString sPyErr = m_pModPython->GetPyExceptionStr();
		DEBUG("modpython: " << (GetUser() ? GetUser()->GetUserName() : CString("<no user>")) << "/" << GetModName() << "/OnUserJoin: can't convert string 'OnUserJoin' to PyObject: " << sPyErr);
		return CModule::OnUserJoin(sChannel, sKey);
	}
	PyObject* pyArg_sChannel = CPyRetString::wrap(sChannel);
	if (!pyArg_sChannel) {
		CString sPyErr = m_pModPython->GetPyExceptionStr();
		DEBUG("modpython: " << (GetUser() ? GetUser()->GetUserName() : CString("<no user>")) << "/" << GetModName() << "/OnUserJoin: can't convert parameter 'sChannel' to PyObject: " << sPyErr);
		Py_CLEAR(pyName);
		return CModule::OnUserJoin(sChannel, sKey);
	}
	PyObject* pyArg_sKey = CPyRetString::wrap(sKey);
	if (!pyArg_sKey) {
		CString sPyErr = m_pModPython->GetPyExceptionStr();
		DEBUG("modpython: " << (GetUser() ? GetUser()->GetUserName() : CString("<no user>")) << "/" << GetModName() << "/OnUserJoin: can't convert parameter 'sKey' to PyObject: " << sPyErr);
		Py_CLEAR(pyName);
		Py_CLEAR(pyArg_sChannel);
		return CModule::OnUserJoin(sChannel, sKey);
	}
	PyObject* pyRes = PyObject_CallMethodObjArgs(m_pyObj, pyName, pyArg_sChannel, pyArg_sKey, nullptr);
	if (!pyRes) {
		CString sPyErr = m_pModPython->GetPyExceptionStr();
		DEBUG("modpython: " << (GetUser() ? GetUser()->GetUserName() : CString("<no user>")) << "/" << GetModName() << "/OnUserJoin failed: " << sPyErr);
		Py_CLEAR(pyName);
		Py_CLEAR(pyArg_sChannel);
		Py_CLEAR(pyArg_sKey);
		return CModule::OnUserJoin(sChannel, sKey);
	}
	Py_CLEAR(pyName);
	Py_CLEAR(pyArg_sChannel);
	Py_CLEAR(pyArg_sKey);
	CModule::EModRet result;
	if (pyRes == Py_None) {
		result = CModule::OnUserJoin(sChannel, sKey);
	} else {
		long int x = PyLong_AsLong(pyRes);
		if (PyErr_Occurred()) {
			CString sPyErr = m_pModPython->GetPyExceptionStr();
			DEBUG("modpython: " << (GetUser() ? GetUser()->GetUserName() : CString("<no user>")) << "/" << GetModName() << "/OnUserJoin was expected to return EModRet but: " << sPyErr);
			result = CModule::OnUserJoin(sChannel, sKey);
		} else { result = (CModule::EModRet)x; }
	}
	Py_CLEAR(pyRes);
	return result;
}

CModule::EModRet CPyModule::OnUserPart(CString& sChannel, CString& sMessage) {
	PyObject* pyName = Py_BuildValue("s", "OnUserPart");
	if (!pyName) {
		CString sPyErr = m_pModPython->GetPyExceptionStr();
		DEBUG("modpython: " << (GetUser() ? GetUser()->GetUserName() : CString("<no user>")) << "/" << GetModName() << "/OnUserPart: can't convert string 'OnUserPart' to PyObject: " << sPyErr);
		return CModule::OnUserPart(sChannel, sMessage);
	}
	PyObject* pyArg_sChannel = CPyRetString::wrap(sChannel);
	if (!pyArg_sChannel) {
		CString sPyErr = m_pModPython->GetPyExceptionStr();
		DEBUG("modpython: " << (GetUser() ? GetUser()->GetUserName() : CString("<no user>")) << "/" << GetModName() << "/OnUserPart: can't convert parameter 'sChannel' to PyObject: " << sPyErr);
		Py_CLEAR(pyName);
		return CModule::OnUserPart(sChannel, sMessage);
	}
	PyObject* pyArg_sMessage = CPyRetString::wrap(sMessage);
	if (!pyArg_sMessage) {
		CString sPyErr = m_pModPython->GetPyExceptionStr();
		DEBUG("modpython: " << (GetUser() ? GetUser()->GetUserName() : CString("<no user>")) << "/" << GetModName() << "/OnUserPart: can't convert parameter 'sMessage' to PyObject: " << sPyErr);
		Py_CLEAR(pyName);
		Py_CLEAR(pyArg_sChannel);
		return CModule::OnUserPart(sChannel, sMessage);
	}
	PyObject* pyRes = PyObject_CallMethodObjArgs(m_pyObj, pyName, pyArg_sChannel, pyArg_sMessage, nullptr);
	if (!pyRes) {
		CString sPyErr = m_pModPython->GetPyExceptionStr();
		DEBUG("modpython: " << (GetUser() ? GetUser()->GetUserName() : CString("<no user>")) << "/" << GetModName() << "/OnUserPart failed: " << sPyErr);
		Py_CLEAR(pyName);
		Py_CLEAR(pyArg_sChannel);
		Py_CLEAR(pyArg_sMessage);
		return CModule::OnUserPart(sChannel, sMessage);
	}
	Py_CLEAR(pyName);
	Py_CLEAR(pyArg_sChannel);
	Py_CLEAR(pyArg_sMessage);
	CModule::EModRet result;
	if (pyRes == Py_None) {
		result = CModule::OnUserPart(sChannel, sMessage);
	} else {
		long int x = PyLong_AsLong(pyRes);
		if (PyErr_Occurred()) {
			CString sPyErr = m_pModPython->GetPyExceptionStr();
			DEBUG("modpython: " << (GetUser() ? GetUser()->GetUserName() : CString("<no user>")) << "/" << GetModName() << "/OnUserPart was expected to return EModRet but: " << sPyErr);
			result = CModule::OnUserPart(sChannel, sMessage);
		} else { result = (CModule::EModRet)x; }
	}
	Py_CLEAR(pyRes);
	return result;
}

CModule::EModRet CPyModule::OnUserTopic(CString& sChannel, CString& sTopic) {
	PyObject* pyName = Py_BuildValue("s", "OnUserTopic");
	if (!pyName) {
		CString sPyErr = m_pModPython->GetPyExceptionStr();
		DEBUG("modpython: " << (GetUser() ? GetUser()->GetUserName() : CString("<no user>")) << "/" << GetModName() << "/OnUserTopic: can't convert string 'OnUserTopic' to PyObject: " << sPyErr);
		return CModule::OnUserTopic(sChannel, sTopic);
	}
	PyObject* pyArg_sChannel = CPyRetString::wrap(sChannel);
	if (!pyArg_sChannel) {
		CString sPyErr = m_pModPython->GetPyExceptionStr();
		DEBUG("modpython: " << (GetUser() ? GetUser()->GetUserName() : CString("<no user>")) << "/" << GetModName() << "/OnUserTopic: can't convert parameter 'sChannel' to PyObject: " << sPyErr);
		Py_CLEAR(pyName);
		return CModule::OnUserTopic(sChannel, sTopic);
	}
	PyObject* pyArg_sTopic = CPyRetString::wrap(sTopic);
	if (!pyArg_sTopic) {
		CString sPyErr = m_pModPython->GetPyExceptionStr();
		DEBUG("modpython: " << (GetUser() ? GetUser()->GetUserName() : CString("<no user>")) << "/" << GetModName() << "/OnUserTopic: can't convert parameter 'sTopic' to PyObject: " << sPyErr);
		Py_CLEAR(pyName);
		Py_CLEAR(pyArg_sChannel);
		return CModule::OnUserTopic(sChannel, sTopic);
	}
	PyObject* pyRes = PyObject_CallMethodObjArgs(m_pyObj, pyName, pyArg_sChannel, pyArg_sTopic, nullptr);
	if (!pyRes) {
		CString sPyErr = m_pModPython->GetPyExceptionStr();
		DEBUG("modpython: " << (GetUser() ? GetUser()->GetUserName() : CString("<no user>")) << "/" << GetModName() << "/OnUserTopic failed: " << sPyErr);
		Py_CLEAR(pyName);
		Py_CLEAR(pyArg_sChannel);
		Py_CLEAR(pyArg_sTopic);
		return CModule::OnUserTopic(sChannel, sTopic);
	}
	Py_CLEAR(pyName);
	Py_CLEAR(pyArg_sChannel);
	Py_CLEAR(pyArg_sTopic);
	CModule::EModRet result;
	if (pyRes == Py_None) {
		result = CModule::OnUserTopic(sChannel, sTopic);
	} else {
		long int x = PyLong_AsLong(pyRes);
		if (PyErr_Occurred()) {
			CString sPyErr = m_pModPython->GetPyExceptionStr();
			DEBUG("modpython: " << (GetUser() ? GetUser()->GetUserName() : CString("<no user>")) << "/" << GetModName() << "/OnUserTopic was expected to return EModRet but: " << sPyErr);
			result = CModule::OnUserTopic(sChannel, sTopic);
		} else { result = (CModule::EModRet)x; }
	}
	Py_CLEAR(pyRes);
	return result;
}

CModule::EModRet CPyModule::OnUserTopicRequest(CString& sChannel) {
	PyObject* pyName = Py_BuildValue("s", "OnUserTopicRequest");
	if (!pyName) {
		CString sPyErr = m_pModPython->GetPyExceptionStr();
		DEBUG("modpython: " << (GetUser() ? GetUser()->GetUserName() : CString("<no user>")) << "/" << GetModName() << "/OnUserTopicRequest: can't convert string 'OnUserTopicRequest' to PyObject: " << sPyErr);
		return CModule::OnUserTopicRequest(sChannel);
	}
	PyObject* pyArg_sChannel = CPyRetString::wrap(sChannel);
	if (!pyArg_sChannel) {
		CString sPyErr = m_pModPython->GetPyExceptionStr();
		DEBUG("modpython: " << (GetUser() ? GetUser()->GetUserName() : CString("<no user>")) << "/" << GetModName() << "/OnUserTopicRequest: can't convert parameter 'sChannel' to PyObject: " << sPyErr);
		Py_CLEAR(pyName);
		return CModule::OnUserTopicRequest(sChannel);
	}
	PyObject* pyRes = PyObject_CallMethodObjArgs(m_pyObj, pyName, pyArg_sChannel, nullptr);
	if (!pyRes) {
		CString sPyErr = m_pModPython->GetPyExceptionStr();
		DEBUG("modpython: " << (GetUser() ? GetUser()->GetUserName() : CString("<no user>")) << "/" << GetModName() << "/OnUserTopicRequest failed: " << sPyErr);
		Py_CLEAR(pyName);
		Py_CLEAR(pyArg_sChannel);
		return CModule::OnUserTopicRequest(sChannel);
	}
	Py_CLEAR(pyName);
	Py_CLEAR(pyArg_sChannel);
	CModule::EModRet result;
	if (pyRes == Py_None) {
		result = CModule::OnUserTopicRequest(sChannel);
	} else {
		long int x = PyLong_AsLong(pyRes);
		if (PyErr_Occurred()) {
			CString sPyErr = m_pModPython->GetPyExceptionStr();
			DEBUG("modpython: " << (GetUser() ? GetUser()->GetUserName() : CString("<no user>")) << "/" << GetModName() << "/OnUserTopicRequest was expected to return EModRet but: " << sPyErr);
			result = CModule::OnUserTopicRequest(sChannel);
		} else { result = (CModule::EModRet)x; }
	}
	Py_CLEAR(pyRes);
	return result;
}

CModule::EModRet CPyModule::OnUserQuit(CString& sMessage) {
	PyObject* pyName = Py_BuildValue("s", "OnUserQuit");
	if (!pyName) {
		CString sPyErr = m_pModPython->GetPyExceptionStr();
		DEBUG("modpython: " << (GetUser() ? GetUser()->GetUserName() : CString("<no user>")) << "/" << GetModName() << "/OnUserQuit: can't convert string 'OnUserQuit' to PyObject: " << sPyErr);
		return CModule::OnUserQuit(sMessage);
	}
	PyObject* pyArg_sMessage = CPyRetString::wrap(sMessage);
	if (!pyArg_sMessage) {
		CString sPyErr = m_pModPython->GetPyExceptionStr();
		DEBUG("modpython: " << (GetUser() ? GetUser()->GetUserName() : CString("<no user>")) << "/" << GetModName() << "/OnUserQuit: can't convert parameter 'sMessage' to PyObject: " << sPyErr);
		Py_CLEAR(pyName);
		return CModule::OnUserQuit(sMessage);
	}
	PyObject* pyRes = PyObject_CallMethodObjArgs(m_pyObj, pyName, pyArg_sMessage, nullptr);
	if (!pyRes) {
		CString sPyErr = m_pModPython->GetPyExceptionStr();
		DEBUG("modpython: " << (GetUser() ? GetUser()->GetUserName() : CString("<no user>")) << "/" << GetModName() << "/OnUserQuit failed: " << sPyErr);
		Py_CLEAR(pyName);
		Py_CLEAR(pyArg_sMessage);
		return CModule::OnUserQuit(sMessage);
	}
	Py_CLEAR(pyName);
	Py_CLEAR(pyArg_sMessage);
	CModule::EModRet result;
	if (pyRes == Py_None) {
		result = CModule::OnUserQuit(sMessage);
	} else {
		long int x = PyLong_AsLong(pyRes);
		if (PyErr_Occurred()) {
			CString sPyErr = m_pModPython->GetPyExceptionStr();
			DEBUG("modpython: " << (GetUser() ? GetUser()->GetUserName() : CString("<no user>")) << "/" << GetModName() << "/OnUserQuit was expected to return EModRet but: " << sPyErr);
			result = CModule::OnUserQuit(sMessage);
		} else { result = (CModule::EModRet)x; }
	}
	Py_CLEAR(pyRes);
	return result;
}

CModule::EModRet CPyModule::OnCTCPReply(CNick& Nick, CString& sMessage) {
	PyObject* pyName = Py_BuildValue("s", "OnCTCPReply");
	if (!pyName) {
		CString sPyErr = m_pModPython->GetPyExceptionStr();
		DEBUG("modpython: " << (GetUser() ? GetUser()->GetUserName() : CString("<no user>")) << "/" << GetModName() << "/OnCTCPReply: can't convert string 'OnCTCPReply' to PyObject: " << sPyErr);
		return CModule::OnCTCPReply(Nick, sMessage);
	}
	PyObject* pyArg_Nick = SWIG_NewInstanceObj(const_cast<CNick*>(&Nick), SWIG_TypeQuery("CNick*"), 0);
	if (!pyArg_Nick) {
		CString sPyErr = m_pModPython->GetPyExceptionStr();
		DEBUG("modpython: " << (GetUser() ? GetUser()->GetUserName() : CString("<no user>")) << "/" << GetModName() << "/OnCTCPReply: can't convert parameter 'Nick' to PyObject: " << sPyErr);
		Py_CLEAR(pyName);
		return CModule::OnCTCPReply(Nick, sMessage);
	}
	PyObject* pyArg_sMessage = CPyRetString::wrap(sMessage);
	if (!pyArg_sMessage) {
		CString sPyErr = m_pModPython->GetPyExceptionStr();
		DEBUG("modpython: " << (GetUser() ? GetUser()->GetUserName() : CString("<no user>")) << "/" << GetModName() << "/OnCTCPReply: can't convert parameter 'sMessage' to PyObject: " << sPyErr);
		Py_CLEAR(pyName);
		Py_CLEAR(pyArg_Nick);
		return CModule::OnCTCPReply(Nick, sMessage);
	}
	PyObject* pyRes = PyObject_CallMethodObjArgs(m_pyObj, pyName, pyArg_Nick, pyArg_sMessage, nullptr);
	if (!pyRes) {
		CString sPyErr = m_pModPython->GetPyExceptionStr();
		DEBUG("modpython: " << (GetUser() ? GetUser()->GetUserName() : CString("<no user>")) << "/" << GetModName() << "/OnCTCPReply failed: " << sPyErr);
		Py_CLEAR(pyName);
		Py_CLEAR(pyArg_Nick);
		Py_CLEAR(pyArg_sMessage);
		return CModule::OnCTCPReply(Nick, sMessage);
	}
	Py_CLEAR(pyName);
	Py_CLEAR(pyArg_Nick);
	Py_CLEAR(pyArg_sMessage);
	CModule::EModRet result;
	if (pyRes == Py_None) {
		result = CModule::OnCTCPReply(Nick, sMessage);
	} else {
		long int x = PyLong_AsLong(pyRes);
		if (PyErr_Occurred()) {
			CString sPyErr = m_pModPython->GetPyExceptionStr();
			DEBUG("modpython: " << (GetUser() ? GetUser()->GetUserName() : CString("<no user>")) << "/" << GetModName() << "/OnCTCPReply was expected to return EModRet but: " << sPyErr);
			result = CModule::OnCTCPReply(Nick, sMessage);
		} else { result = (CModule::EModRet)x; }
	}
	Py_CLEAR(pyRes);
	return result;
}

CModule::EModRet CPyModule::OnPrivCTCP(CNick& Nick, CString& sMessage) {
	PyObject* pyName = Py_BuildValue("s", "OnPrivCTCP");
	if (!pyName) {
		CString sPyErr = m_pModPython->GetPyExceptionStr();
		DEBUG("modpython: " << (GetUser() ? GetUser()->GetUserName() : CString("<no user>")) << "/" << GetModName() << "/OnPrivCTCP: can't convert string 'OnPrivCTCP' to PyObject: " << sPyErr);
		return CModule::OnPrivCTCP(Nick, sMessage);
	}
	PyObject* pyArg_Nick = SWIG_NewInstanceObj(const_cast<CNick*>(&Nick), SWIG_TypeQuery("CNick*"), 0);
	if (!pyArg_Nick) {
		CString sPyErr = m_pModPython->GetPyExceptionStr();
		DEBUG("modpython: " << (GetUser() ? GetUser()->GetUserName() : CString("<no user>")) << "/" << GetModName() << "/OnPrivCTCP: can't convert parameter 'Nick' to PyObject: " << sPyErr);
		Py_CLEAR(pyName);
		return CModule::OnPrivCTCP(Nick, sMessage);
	}
	PyObject* pyArg_sMessage = CPyRetString::wrap(sMessage);
	if (!pyArg_sMessage) {
		CString sPyErr = m_pModPython->GetPyExceptionStr();
		DEBUG("modpython: " << (GetUser() ? GetUser()->GetUserName() : CString("<no user>")) << "/" << GetModName() << "/OnPrivCTCP: can't convert parameter 'sMessage' to PyObject: " << sPyErr);
		Py_CLEAR(pyName);
		Py_CLEAR(pyArg_Nick);
		return CModule::OnPrivCTCP(Nick, sMessage);
	}
	PyObject* pyRes = PyObject_CallMethodObjArgs(m_pyObj, pyName, pyArg_Nick, pyArg_sMessage, nullptr);
	if (!pyRes) {
		CString sPyErr = m_pModPython->GetPyExceptionStr();
		DEBUG("modpython: " << (GetUser() ? GetUser()->GetUserName() : CString("<no user>")) << "/" << GetModName() << "/OnPrivCTCP failed: " << sPyErr);
		Py_CLEAR(pyName);
		Py_CLEAR(pyArg_Nick);
		Py_CLEAR(pyArg_sMessage);
		return CModule::OnPrivCTCP(Nick, sMessage);
	}
	Py_CLEAR(pyName);
	Py_CLEAR(pyArg_Nick);
	Py_CLEAR(pyArg_sMessage);
	CModule::EModRet result;
	if (pyRes == Py_None) {
		result = CModule::OnPrivCTCP(Nick, sMessage);
	} else {
		long int x = PyLong_AsLong(pyRes);
		if (PyErr_Occurred()) {
			CString sPyErr = m_pModPython->GetPyExceptionStr();
			DEBUG("modpython: " << (GetUser() ? GetUser()->GetUserName() : CString("<no user>")) << "/" << GetModName() << "/OnPrivCTCP was expected to return EModRet but: " << sPyErr);
			result = CModule::OnPrivCTCP(Nick, sMessage);
		} else { result = (CModule::EModRet)x; }
	}
	Py_CLEAR(pyRes);
	return result;
}

CModule::EModRet CPyModule::OnChanCTCP(CNick& Nick, CChan& Channel, CString& sMessage) {
	PyObject* pyName = Py_BuildValue("s", "OnChanCTCP");
	if (!pyName) {
		CString sPyErr = m_pModPython->GetPyExceptionStr();
		DEBUG("modpython: " << (GetUser() ? GetUser()->GetUserName() : CString("<no user>")) << "/" << GetModName() << "/OnChanCTCP: can't convert string 'OnChanCTCP' to PyObject: " << sPyErr);
		return CModule::OnChanCTCP(Nick, Channel, sMessage);
	}
	PyObject* pyArg_Nick = SWIG_NewInstanceObj(const_cast<CNick*>(&Nick), SWIG_TypeQuery("CNick*"), 0);
	if (!pyArg_Nick) {
		CString sPyErr = m_pModPython->GetPyExceptionStr();
		DEBUG("modpython: " << (GetUser() ? GetUser()->GetUserName() : CString("<no user>")) << "/" << GetModName() << "/OnChanCTCP: can't convert parameter 'Nick' to PyObject: " << sPyErr);
		Py_CLEAR(pyName);
		return CModule::OnChanCTCP(Nick, Channel, sMessage);
	}
	PyObject* pyArg_Channel = SWIG_NewInstanceObj(const_cast<CChan*>(&Channel), SWIG_TypeQuery("CChan*"), 0);
	if (!pyArg_Channel) {
		CString sPyErr = m_pModPython->GetPyExceptionStr();
		DEBUG("modpython: " << (GetUser() ? GetUser()->GetUserName() : CString("<no user>")) << "/" << GetModName() << "/OnChanCTCP: can't convert parameter 'Channel' to PyObject: " << sPyErr);
		Py_CLEAR(pyName);
		Py_CLEAR(pyArg_Nick);
		return CModule::OnChanCTCP(Nick, Channel, sMessage);
	}
	PyObject* pyArg_sMessage = CPyRetString::wrap(sMessage);
	if (!pyArg_sMessage) {
		CString sPyErr = m_pModPython->GetPyExceptionStr();
		DEBUG("modpython: " << (GetUser() ? GetUser()->GetUserName() : CString("<no user>")) << "/" << GetModName() << "/OnChanCTCP: can't convert parameter 'sMessage' to PyObject: " << sPyErr);
		Py_CLEAR(pyName);
		Py_CLEAR(pyArg_Nick);
		Py_CLEAR(pyArg_Channel);
		return CModule::OnChanCTCP(Nick, Channel, sMessage);
	}
	PyObject* pyRes = PyObject_CallMethodObjArgs(m_pyObj, pyName, pyArg_Nick, pyArg_Channel, pyArg_sMessage, nullptr);
	if (!pyRes) {
		CString sPyErr = m_pModPython->GetPyExceptionStr();
		DEBUG("modpython: " << (GetUser() ? GetUser()->GetUserName() : CString("<no user>")) << "/" << GetModName() << "/OnChanCTCP failed: " << sPyErr);
		Py_CLEAR(pyName);
		Py_CLEAR(pyArg_Nick);
		Py_CLEAR(pyArg_Channel);
		Py_CLEAR(pyArg_sMessage);
		return CModule::OnChanCTCP(Nick, Channel, sMessage);
	}
	Py_CLEAR(pyName);
	Py_CLEAR(pyArg_Nick);
	Py_CLEAR(pyArg_Channel);
	Py_CLEAR(pyArg_sMessage);
	CModule::EModRet result;
	if (pyRes == Py_None) {
		result = CModule::OnChanCTCP(Nick, Channel, sMessage);
	} else {
		long int x = PyLong_AsLong(pyRes);
		if (PyErr_Occurred()) {
			CString sPyErr = m_pModPython->GetPyExceptionStr();
			DEBUG("modpython: " << (GetUser() ? GetUser()->GetUserName() : CString("<no user>")) << "/" << GetModName() << "/OnChanCTCP was expected to return EModRet but: " << sPyErr);
			result = CModule::OnChanCTCP(Nick, Channel, sMessage);
		} else { result = (CModule::EModRet)x; }
	}
	Py_CLEAR(pyRes);
	return result;
}

CModule::EModRet CPyModule::OnPrivAction(CNick& Nick, CString& sMessage) {
	PyObject* pyName = Py_BuildValue("s", "OnPrivAction");
	if (!pyName) {
		CString sPyErr = m_pModPython->GetPyExceptionStr();
		DEBUG("modpython: " << (GetUser() ? GetUser()->GetUserName() : CString("<no user>")) << "/" << GetModName() << "/OnPrivAction: can't convert string 'OnPrivAction' to PyObject: " << sPyErr);
		return CModule::OnPrivAction(Nick, sMessage);
	}
	PyObject* pyArg_Nick = SWIG_NewInstanceObj(const_cast<CNick*>(&Nick), SWIG_TypeQuery("CNick*"), 0);
	if (!pyArg_Nick) {
		CString sPyErr = m_pModPython->GetPyExceptionStr();
		DEBUG("modpython: " << (GetUser() ? GetUser()->GetUserName() : CString("<no user>")) << "/" << GetModName() << "/OnPrivAction: can't convert parameter 'Nick' to PyObject: " << sPyErr);
		Py_CLEAR(pyName);
		return CModule::OnPrivAction(Nick, sMessage);
	}
	PyObject* pyArg_sMessage = CPyRetString::wrap(sMessage);
	if (!pyArg_sMessage) {
		CString sPyErr = m_pModPython->GetPyExceptionStr();
		DEBUG("modpython: " << (GetUser() ? GetUser()->GetUserName() : CString("<no user>")) << "/" << GetModName() << "/OnPrivAction: can't convert parameter 'sMessage' to PyObject: " << sPyErr);
		Py_CLEAR(pyName);
		Py_CLEAR(pyArg_Nick);
		return CModule::OnPrivAction(Nick, sMessage);
	}
	PyObject* pyRes = PyObject_CallMethodObjArgs(m_pyObj, pyName, pyArg_Nick, pyArg_sMessage, nullptr);
	if (!pyRes) {
		CString sPyErr = m_pModPython->GetPyExceptionStr();
		DEBUG("modpython: " << (GetUser() ? GetUser()->GetUserName() : CString("<no user>")) << "/" << GetModName() << "/OnPrivAction failed: " << sPyErr);
		Py_CLEAR(pyName);
		Py_CLEAR(pyArg_Nick);
		Py_CLEAR(pyArg_sMessage);
		return CModule::OnPrivAction(Nick, sMessage);
	}
	Py_CLEAR(pyName);
	Py_CLEAR(pyArg_Nick);
	Py_CLEAR(pyArg_sMessage);
	CModule::EModRet result;
	if (pyRes == Py_None) {
		result = CModule::OnPrivAction(Nick, sMessage);
	} else {
		long int x = PyLong_AsLong(pyRes);
		if (PyErr_Occurred()) {
			CString sPyErr = m_pModPython->GetPyExceptionStr();
			DEBUG("modpython: " << (GetUser() ? GetUser()->GetUserName() : CString("<no user>")) << "/" << GetModName() << "/OnPrivAction was expected to return EModRet but: " << sPyErr);
			result = CModule::OnPrivAction(Nick, sMessage);
		} else { result = (CModule::EModRet)x; }
	}
	Py_CLEAR(pyRes);
	return result;
}

CModule::EModRet CPyModule::OnChanAction(CNick& Nick, CChan& Channel, CString& sMessage) {
	PyObject* pyName = Py_BuildValue("s", "OnChanAction");
	if (!pyName) {
		CString sPyErr = m_pModPython->GetPyExceptionStr();
		DEBUG("modpython: " << (GetUser() ? GetUser()->GetUserName() : CString("<no user>")) << "/" << GetModName() << "/OnChanAction: can't convert string 'OnChanAction' to PyObject: " << sPyErr);
		return CModule::OnChanAction(Nick, Channel, sMessage);
	}
	PyObject* pyArg_Nick = SWIG_NewInstanceObj(const_cast<CNick*>(&Nick), SWIG_TypeQuery("CNick*"), 0);
	if (!pyArg_Nick) {
		CString sPyErr = m_pModPython->GetPyExceptionStr();
		DEBUG("modpython: " << (GetUser() ? GetUser()->GetUserName() : CString("<no user>")) << "/" << GetModName() << "/OnChanAction: can't convert parameter 'Nick' to PyObject: " << sPyErr);
		Py_CLEAR(pyName);
		return CModule::OnChanAction(Nick, Channel, sMessage);
	}
	PyObject* pyArg_Channel = SWIG_NewInstanceObj(const_cast<CChan*>(&Channel), SWIG_TypeQuery("CChan*"), 0);
	if (!pyArg_Channel) {
		CString sPyErr = m_pModPython->GetPyExceptionStr();
		DEBUG("modpython: " << (GetUser() ? GetUser()->GetUserName() : CString("<no user>")) << "/" << GetModName() << "/OnChanAction: can't convert parameter 'Channel' to PyObject: " << sPyErr);
		Py_CLEAR(pyName);
		Py_CLEAR(pyArg_Nick);
		return CModule::OnChanAction(Nick, Channel, sMessage);
	}
	PyObject* pyArg_sMessage = CPyRetString::wrap(sMessage);
	if (!pyArg_sMessage) {
		CString sPyErr = m_pModPython->GetPyExceptionStr();
		DEBUG("modpython: " << (GetUser() ? GetUser()->GetUserName() : CString("<no user>")) << "/" << GetModName() << "/OnChanAction: can't convert parameter 'sMessage' to PyObject: " << sPyErr);
		Py_CLEAR(pyName);
		Py_CLEAR(pyArg_Nick);
		Py_CLEAR(pyArg_Channel);
		return CModule::OnChanAction(Nick, Channel, sMessage);
	}
	PyObject* pyRes = PyObject_CallMethodObjArgs(m_pyObj, pyName, pyArg_Nick, pyArg_Channel, pyArg_sMessage, nullptr);
	if (!pyRes) {
		CString sPyErr = m_pModPython->GetPyExceptionStr();
		DEBUG("modpython: " << (GetUser() ? GetUser()->GetUserName() : CString("<no user>")) << "/" << GetModName() << "/OnChanAction failed: " << sPyErr);
		Py_CLEAR(pyName);
		Py_CLEAR(pyArg_Nick);
		Py_CLEAR(pyArg_Channel);
		Py_CLEAR(pyArg_sMessage);
		return CModule::OnChanAction(Nick, Channel, sMessage);
	}
	Py_CLEAR(pyName);
	Py_CLEAR(pyArg_Nick);
	Py_CLEAR(pyArg_Channel);
	Py_CLEAR(pyArg_sMessage);
	CModule::EModRet result;
	if (pyRes == Py_None) {
		result = CModule::OnChanAction(Nick, Channel, sMessage);
	} else {
		long int x = PyLong_AsLong(pyRes);
		if (PyErr_Occurred()) {
			CString sPyErr = m_pModPython->GetPyExceptionStr();
			DEBUG("modpython: " << (GetUser() ? GetUser()->GetUserName() : CString("<no user>")) << "/" << GetModName() << "/OnChanAction was expected to return EModRet but: " << sPyErr);
			result = CModule::OnChanAction(Nick, Channel, sMessage);
		} else { result = (CModule::EModRet)x; }
	}
	Py_CLEAR(pyRes);
	return result;
}

CModule::EModRet CPyModule::OnPrivMsg(CNick& Nick, CString& sMessage) {
	PyObject* pyName = Py_BuildValue("s", "OnPrivMsg");
	if (!pyName) {
		CString sPyErr = m_pModPython->GetPyExceptionStr();
		DEBUG("modpython: " << (GetUser() ? GetUser()->GetUserName() : CString("<no user>")) << "/" << GetModName() << "/OnPrivMsg: can't convert string 'OnPrivMsg' to PyObject: " << sPyErr);
		return CModule::OnPrivMsg(Nick, sMessage);
	}
	PyObject* pyArg_Nick = SWIG_NewInstanceObj(const_cast<CNick*>(&Nick), SWIG_TypeQuery("CNick*"), 0);
	if (!pyArg_Nick) {
		CString sPyErr = m_pModPython->GetPyExceptionStr();
		DEBUG("modpython: " << (GetUser() ? GetUser()->GetUserName() : CString("<no user>")) << "/" << GetModName() << "/OnPrivMsg: can't convert parameter 'Nick' to PyObject: " << sPyErr);
		Py_CLEAR(pyName);
		return CModule::OnPrivMsg(Nick, sMessage);
	}
	PyObject* pyArg_sMessage = CPyRetString::wrap(sMessage);
	if (!pyArg_sMessage) {
		CString sPyErr = m_pModPython->GetPyExceptionStr();
		DEBUG("modpython: " << (GetUser() ? GetUser()->GetUserName() : CString("<no user>")) << "/" << GetModName() << "/OnPrivMsg: can't convert parameter 'sMessage' to PyObject: " << sPyErr);
		Py_CLEAR(pyName);
		Py_CLEAR(pyArg_Nick);
		return CModule::OnPrivMsg(Nick, sMessage);
	}
	PyObject* pyRes = PyObject_CallMethodObjArgs(m_pyObj, pyName, pyArg_Nick, pyArg_sMessage, nullptr);
	if (!pyRes) {
		CString sPyErr = m_pModPython->GetPyExceptionStr();
		DEBUG("modpython: " << (GetUser() ? GetUser()->GetUserName() : CString("<no user>")) << "/" << GetModName() << "/OnPrivMsg failed: " << sPyErr);
		Py_CLEAR(pyName);
		Py_CLEAR(pyArg_Nick);
		Py_CLEAR(pyArg_sMessage);
		return CModule::OnPrivMsg(Nick, sMessage);
	}
	Py_CLEAR(pyName);
	Py_CLEAR(pyArg_Nick);
	Py_CLEAR(pyArg_sMessage);
	CModule::EModRet result;
	if (pyRes == Py_None) {
		result = CModule::OnPrivMsg(Nick, sMessage);
	} else {
		long int x = PyLong_AsLong(pyRes);
		if (PyErr_Occurred()) {
			CString sPyErr = m_pModPython->GetPyExceptionStr();
			DEBUG("modpython: " << (GetUser() ? GetUser()->GetUserName() : CString("<no user>")) << "/" << GetModName() << "/OnPrivMsg was expected to return EModRet but: " << sPyErr);
			result = CModule::OnPrivMsg(Nick, sMessage);
		} else { result = (CModule::EModRet)x; }
	}
	Py_CLEAR(pyRes);
	return result;
}

CModule::EModRet CPyModule::OnChanMsg(CNick& Nick, CChan& Channel, CString& sMessage) {
	PyObject* pyName = Py_BuildValue("s", "OnChanMsg");
	if (!pyName) {
		CString sPyErr = m_pModPython->GetPyExceptionStr();
		DEBUG("modpython: " << (GetUser() ? GetUser()->GetUserName() : CString("<no user>")) << "/" << GetModName() << "/OnChanMsg: can't convert string 'OnChanMsg' to PyObject: " << sPyErr);
		return CModule::OnChanMsg(Nick, Channel, sMessage);
	}
	PyObject* pyArg_Nick = SWIG_NewInstanceObj(const_cast<CNick*>(&Nick), SWIG_TypeQuery("CNick*"), 0);
	if (!pyArg_Nick) {
		CString sPyErr = m_pModPython->GetPyExceptionStr();
		DEBUG("modpython: " << (GetUser() ? GetUser()->GetUserName() : CString("<no user>")) << "/" << GetModName() << "/OnChanMsg: can't convert parameter 'Nick' to PyObject: " << sPyErr);
		Py_CLEAR(pyName);
		return CModule::OnChanMsg(Nick, Channel, sMessage);
	}
	PyObject* pyArg_Channel = SWIG_NewInstanceObj(const_cast<CChan*>(&Channel), SWIG_TypeQuery("CChan*"), 0);
	if (!pyArg_Channel) {
		CString sPyErr = m_pModPython->GetPyExceptionStr();
		DEBUG("modpython: " << (GetUser() ? GetUser()->GetUserName() : CString("<no user>")) << "/" << GetModName() << "/OnChanMsg: can't convert parameter 'Channel' to PyObject: " << sPyErr);
		Py_CLEAR(pyName);
		Py_CLEAR(pyArg_Nick);
		return CModule::OnChanMsg(Nick, Channel, sMessage);
	}
	PyObject* pyArg_sMessage = CPyRetString::wrap(sMessage);
	if (!pyArg_sMessage) {
		CString sPyErr = m_pModPython->GetPyExceptionStr();
		DEBUG("modpython: " << (GetUser() ? GetUser()->GetUserName() : CString("<no user>")) << "/" << GetModName() << "/OnChanMsg: can't convert parameter 'sMessage' to PyObject: " << sPyErr);
		Py_CLEAR(pyName);
		Py_CLEAR(pyArg_Nick);
		Py_CLEAR(pyArg_Channel);
		return CModule::OnChanMsg(Nick, Channel, sMessage);
	}
	PyObject* pyRes = PyObject_CallMethodObjArgs(m_pyObj, pyName, pyArg_Nick, pyArg_Channel, pyArg_sMessage, nullptr);
	if (!pyRes) {
		CString sPyErr = m_pModPython->GetPyExceptionStr();
		DEBUG("modpython: " << (GetUser() ? GetUser()->GetUserName() : CString("<no user>")) << "/" << GetModName() << "/OnChanMsg failed: " << sPyErr);
		Py_CLEAR(pyName);
		Py_CLEAR(pyArg_Nick);
		Py_CLEAR(pyArg_Channel);
		Py_CLEAR(pyArg_sMessage);
		return CModule::OnChanMsg(Nick, Channel, sMessage);
	}
	Py_CLEAR(pyName);
	Py_CLEAR(pyArg_Nick);
	Py_CLEAR(pyArg_Channel);
	Py_CLEAR(pyArg_sMessage);
	CModule::EModRet result;
	if (pyRes == Py_None) {
		result = CModule::OnChanMsg(Nick, Channel, sMessage);
	} else {
		long int x = PyLong_AsLong(pyRes);
		if (PyErr_Occurred()) {
			CString sPyErr = m_pModPython->GetPyExceptionStr();
			DEBUG("modpython: " << (GetUser() ? GetUser()->GetUserName() : CString("<no user>")) << "/" << GetModName() << "/OnChanMsg was expected to return EModRet but: " << sPyErr);
			result = CModule::OnChanMsg(Nick, Channel, sMessage);
		} else { result = (CModule::EModRet)x; }
	}
	Py_CLEAR(pyRes);
	return result;
}

CModule::EModRet CPyModule::OnPrivNotice(CNick& Nick, CString& sMessage) {
	PyObject* pyName = Py_BuildValue("s", "OnPrivNotice");
	if (!pyName) {
		CString sPyErr = m_pModPython->GetPyExceptionStr();
		DEBUG("modpython: " << (GetUser() ? GetUser()->GetUserName() : CString("<no user>")) << "/" << GetModName() << "/OnPrivNotice: can't convert string 'OnPrivNotice' to PyObject: " << sPyErr);
		return CModule::OnPrivNotice(Nick, sMessage);
	}
	PyObject* pyArg_Nick = SWIG_NewInstanceObj(const_cast<CNick*>(&Nick), SWIG_TypeQuery("CNick*"), 0);
	if (!pyArg_Nick) {
		CString sPyErr = m_pModPython->GetPyExceptionStr();
		DEBUG("modpython: " << (GetUser() ? GetUser()->GetUserName() : CString("<no user>")) << "/" << GetModName() << "/OnPrivNotice: can't convert parameter 'Nick' to PyObject: " << sPyErr);
		Py_CLEAR(pyName);
		return CModule::OnPrivNotice(Nick, sMessage);
	}
	PyObject* pyArg_sMessage = CPyRetString::wrap(sMessage);
	if (!pyArg_sMessage) {
		CString sPyErr = m_pModPython->GetPyExceptionStr();
		DEBUG("modpython: " << (GetUser() ? GetUser()->GetUserName() : CString("<no user>")) << "/" << GetModName() << "/OnPrivNotice: can't convert parameter 'sMessage' to PyObject: " << sPyErr);
		Py_CLEAR(pyName);
		Py_CLEAR(pyArg_Nick);
		return CModule::OnPrivNotice(Nick, sMessage);
	}
	PyObject* pyRes = PyObject_CallMethodObjArgs(m_pyObj, pyName, pyArg_Nick, pyArg_sMessage, nullptr);
	if (!pyRes) {
		CString sPyErr = m_pModPython->GetPyExceptionStr();
		DEBUG("modpython: " << (GetUser() ? GetUser()->GetUserName() : CString("<no user>")) << "/" << GetModName() << "/OnPrivNotice failed: " << sPyErr);
		Py_CLEAR(pyName);
		Py_CLEAR(pyArg_Nick);
		Py_CLEAR(pyArg_sMessage);
		return CModule::OnPrivNotice(Nick, sMessage);
	}
	Py_CLEAR(pyName);
	Py_CLEAR(pyArg_Nick);
	Py_CLEAR(pyArg_sMessage);
	CModule::EModRet result;
	if (pyRes == Py_None) {
		result = CModule::OnPrivNotice(Nick, sMessage);
	} else {
		long int x = PyLong_AsLong(pyRes);
		if (PyErr_Occurred()) {
			CString sPyErr = m_pModPython->GetPyExceptionStr();
			DEBUG("modpython: " << (GetUser() ? GetUser()->GetUserName() : CString("<no user>")) << "/" << GetModName() << "/OnPrivNotice was expected to return EModRet but: " << sPyErr);
			result = CModule::OnPrivNotice(Nick, sMessage);
		} else { result = (CModule::EModRet)x; }
	}
	Py_CLEAR(pyRes);
	return result;
}

CModule::EModRet CPyModule::OnChanNotice(CNick& Nick, CChan& Channel, CString& sMessage) {
	PyObject* pyName = Py_BuildValue("s", "OnChanNotice");
	if (!pyName) {
		CString sPyErr = m_pModPython->GetPyExceptionStr();
		DEBUG("modpython: " << (GetUser() ? GetUser()->GetUserName() : CString("<no user>")) << "/" << GetModName() << "/OnChanNotice: can't convert string 'OnChanNotice' to PyObject: " << sPyErr);
		return CModule::OnChanNotice(Nick, Channel, sMessage);
	}
	PyObject* pyArg_Nick = SWIG_NewInstanceObj(const_cast<CNick*>(&Nick), SWIG_TypeQuery("CNick*"), 0);
	if (!pyArg_Nick) {
		CString sPyErr = m_pModPython->GetPyExceptionStr();
		DEBUG("modpython: " << (GetUser() ? GetUser()->GetUserName() : CString("<no user>")) << "/" << GetModName() << "/OnChanNotice: can't convert parameter 'Nick' to PyObject: " << sPyErr);
		Py_CLEAR(pyName);
		return CModule::OnChanNotice(Nick, Channel, sMessage);
	}
	PyObject* pyArg_Channel = SWIG_NewInstanceObj(const_cast<CChan*>(&Channel), SWIG_TypeQuery("CChan*"), 0);
	if (!pyArg_Channel) {
		CString sPyErr = m_pModPython->GetPyExceptionStr();
		DEBUG("modpython: " << (GetUser() ? GetUser()->GetUserName() : CString("<no user>")) << "/" << GetModName() << "/OnChanNotice: can't convert parameter 'Channel' to PyObject: " << sPyErr);
		Py_CLEAR(pyName);
		Py_CLEAR(pyArg_Nick);
		return CModule::OnChanNotice(Nick, Channel, sMessage);
	}
	PyObject* pyArg_sMessage = CPyRetString::wrap(sMessage);
	if (!pyArg_sMessage) {
		CString sPyErr = m_pModPython->GetPyExceptionStr();
		DEBUG("modpython: " << (GetUser() ? GetUser()->GetUserName() : CString("<no user>")) << "/" << GetModName() << "/OnChanNotice: can't convert parameter 'sMessage' to PyObject: " << sPyErr);
		Py_CLEAR(pyName);
		Py_CLEAR(pyArg_Nick);
		Py_CLEAR(pyArg_Channel);
		return CModule::OnChanNotice(Nick, Channel, sMessage);
	}
	PyObject* pyRes = PyObject_CallMethodObjArgs(m_pyObj, pyName, pyArg_Nick, pyArg_Channel, pyArg_sMessage, nullptr);
	if (!pyRes) {
		CString sPyErr = m_pModPython->GetPyExceptionStr();
		DEBUG("modpython: " << (GetUser() ? GetUser()->GetUserName() : CString("<no user>")) << "/" << GetModName() << "/OnChanNotice failed: " << sPyErr);
		Py_CLEAR(pyName);
		Py_CLEAR(pyArg_Nick);
		Py_CLEAR(pyArg_Channel);
		Py_CLEAR(pyArg_sMessage);
		return CModule::OnChanNotice(Nick, Channel, sMessage);
	}
	Py_CLEAR(pyName);
	Py_CLEAR(pyArg_Nick);
	Py_CLEAR(pyArg_Channel);
	Py_CLEAR(pyArg_sMessage);
	CModule::EModRet result;
	if (pyRes == Py_None) {
		result = CModule::OnChanNotice(Nick, Channel, sMessage);
	} else {
		long int x = PyLong_AsLong(pyRes);
		if (PyErr_Occurred()) {
			CString sPyErr = m_pModPython->GetPyExceptionStr();
			DEBUG("modpython: " << (GetUser() ? GetUser()->GetUserName() : CString("<no user>")) << "/" << GetModName() << "/OnChanNotice was expected to return EModRet but: " << sPyErr);
			result = CModule::OnChanNotice(Nick, Channel, sMessage);
		} else { result = (CModule::EModRet)x; }
	}
	Py_CLEAR(pyRes);
	return result;
}

CModule::EModRet CPyModule::OnTopic(CNick& Nick, CChan& Channel, CString& sTopic) {
	PyObject* pyName = Py_BuildValue("s", "OnTopic");
	if (!pyName) {
		CString sPyErr = m_pModPython->GetPyExceptionStr();
		DEBUG("modpython: " << (GetUser() ? GetUser()->GetUserName() : CString("<no user>")) << "/" << GetModName() << "/OnTopic: can't convert string 'OnTopic' to PyObject: " << sPyErr);
		return CModule::OnTopic(Nick, Channel, sTopic);
	}
	PyObject* pyArg_Nick = SWIG_NewInstanceObj(const_cast<CNick*>(&Nick), SWIG_TypeQuery("CNick*"), 0);
	if (!pyArg_Nick) {
		CString sPyErr = m_pModPython->GetPyExceptionStr();
		DEBUG("modpython: " << (GetUser() ? GetUser()->GetUserName() : CString("<no user>")) << "/" << GetModName() << "/OnTopic: can't convert parameter 'Nick' to PyObject: " << sPyErr);
		Py_CLEAR(pyName);
		return CModule::OnTopic(Nick, Channel, sTopic);
	}
	PyObject* pyArg_Channel = SWIG_NewInstanceObj(const_cast<CChan*>(&Channel), SWIG_TypeQuery("CChan*"), 0);
	if (!pyArg_Channel) {
		CString sPyErr = m_pModPython->GetPyExceptionStr();
		DEBUG("modpython: " << (GetUser() ? GetUser()->GetUserName() : CString("<no user>")) << "/" << GetModName() << "/OnTopic: can't convert parameter 'Channel' to PyObject: " << sPyErr);
		Py_CLEAR(pyName);
		Py_CLEAR(pyArg_Nick);
		return CModule::OnTopic(Nick, Channel, sTopic);
	}
	PyObject* pyArg_sTopic = CPyRetString::wrap(sTopic);
	if (!pyArg_sTopic) {
		CString sPyErr = m_pModPython->GetPyExceptionStr();
		DEBUG("modpython: " << (GetUser() ? GetUser()->GetUserName() : CString("<no user>")) << "/" << GetModName() << "/OnTopic: can't convert parameter 'sTopic' to PyObject: " << sPyErr);
		Py_CLEAR(pyName);
		Py_CLEAR(pyArg_Nick);
		Py_CLEAR(pyArg_Channel);
		return CModule::OnTopic(Nick, Channel, sTopic);
	}
	PyObject* pyRes = PyObject_CallMethodObjArgs(m_pyObj, pyName, pyArg_Nick, pyArg_Channel, pyArg_sTopic, nullptr);
	if (!pyRes) {
		CString sPyErr = m_pModPython->GetPyExceptionStr();
		DEBUG("modpython: " << (GetUser() ? GetUser()->GetUserName() : CString("<no user>")) << "/" << GetModName() << "/OnTopic failed: " << sPyErr);
		Py_CLEAR(pyName);
		Py_CLEAR(pyArg_Nick);
		Py_CLEAR(pyArg_Channel);
		Py_CLEAR(pyArg_sTopic);
		return CModule::OnTopic(Nick, Channel, sTopic);
	}
	Py_CLEAR(pyName);
	Py_CLEAR(pyArg_Nick);
	Py_CLEAR(pyArg_Channel);
	Py_CLEAR(pyArg_sTopic);
	CModule::EModRet result;
	if (pyRes == Py_None) {
		result = CModule::OnTopic(Nick, Channel, sTopic);
	} else {
		long int x = PyLong_AsLong(pyRes);
		if (PyErr_Occurred()) {
			CString sPyErr = m_pModPython->GetPyExceptionStr();
			DEBUG("modpython: " << (GetUser() ? GetUser()->GetUserName() : CString("<no user>")) << "/" << GetModName() << "/OnTopic was expected to return EModRet but: " << sPyErr);
			result = CModule::OnTopic(Nick, Channel, sTopic);
		} else { result = (CModule::EModRet)x; }
	}
	Py_CLEAR(pyRes);
	return result;
}

bool CPyModule::OnServerCapAvailable(const CString& sCap) {
	PyObject* pyName = Py_BuildValue("s", "OnServerCapAvailable");
	if (!pyName) {
		CString sPyErr = m_pModPython->GetPyExceptionStr();
		DEBUG("modpython: " << (GetUser() ? GetUser()->GetUserName() : CString("<no user>")) << "/" << GetModName() << "/OnServerCapAvailable: can't convert string 'OnServerCapAvailable' to PyObject: " << sPyErr);
		return CModule::OnServerCapAvailable(sCap);
	}
	PyObject* pyArg_sCap = Py_BuildValue("s", sCap.c_str());
	if (!pyArg_sCap) {
		CString sPyErr = m_pModPython->GetPyExceptionStr();
		DEBUG("modpython: " << (GetUser() ? GetUser()->GetUserName() : CString("<no user>")) << "/" << GetModName() << "/OnServerCapAvailable: can't convert parameter 'sCap' to PyObject: " << sPyErr);
		Py_CLEAR(pyName);
		return CModule::OnServerCapAvailable(sCap);
	}
	PyObject* pyRes = PyObject_CallMethodObjArgs(m_pyObj, pyName, pyArg_sCap, nullptr);
	if (!pyRes) {
		CString sPyErr = m_pModPython->GetPyExceptionStr();
		DEBUG("modpython: " << (GetUser() ? GetUser()->GetUserName() : CString("<no user>")) << "/" << GetModName() << "/OnServerCapAvailable failed: " << sPyErr);
		Py_CLEAR(pyName);
		Py_CLEAR(pyArg_sCap);
		return CModule::OnServerCapAvailable(sCap);
	}
	Py_CLEAR(pyName);
	Py_CLEAR(pyArg_sCap);
	bool result;
	if (pyRes == Py_None) {
		result = CModule::OnServerCapAvailable(sCap);
	} else {
		int x = PyObject_IsTrue(pyRes);
		if (-1 == x) {
			CString sPyErr = m_pModPython->GetPyExceptionStr();
			DEBUG("modpython: " << (GetUser() ? GetUser()->GetUserName() : CString("<no user>")) << "/" << GetModName() << "/OnServerCapAvailable was expected to return EModRet but: " << sPyErr);
			result = CModule::OnServerCapAvailable(sCap);
		} else result = x ? true : false;
	}
	Py_CLEAR(pyRes);
	return result;
}

void CPyModule::OnServerCapResult(const CString& sCap, bool bSuccess) {
	PyObject* pyName = Py_BuildValue("s", "OnServerCapResult");
	if (!pyName) {
		CString sPyErr = m_pModPython->GetPyExceptionStr();
		DEBUG("modpython: " << (GetUser() ? GetUser()->GetUserName() : CString("<no user>")) << "/" << GetModName() << "/OnServerCapResult: can't convert string 'OnServerCapResult' to PyObject: " << sPyErr);
		return CModule::OnServerCapResult(sCap, bSuccess);
	}
	PyObject* pyArg_sCap = Py_BuildValue("s", sCap.c_str());
	if (!pyArg_sCap) {
		CString sPyErr = m_pModPython->GetPyExceptionStr();
		DEBUG("modpython: " << (GetUser() ? GetUser()->GetUserName() : CString("<no user>")) << "/" << GetModName() << "/OnServerCapResult: can't convert parameter 'sCap' to PyObject: " << sPyErr);
		Py_CLEAR(pyName);
		return CModule::OnServerCapResult(sCap, bSuccess);
	}
	PyObject* pyArg_bSuccess = Py_BuildValue("l", (long int)bSuccess);
	if (!pyArg_bSuccess) {
		CString sPyErr = m_pModPython->GetPyExceptionStr();
		DEBUG("modpython: " << (GetUser() ? GetUser()->GetUserName() : CString("<no user>")) << "/" << GetModName() << "/OnServerCapResult: can't convert parameter 'bSuccess' to PyObject: " << sPyErr);
		Py_CLEAR(pyName);
		Py_CLEAR(pyArg_sCap);
		return CModule::OnServerCapResult(sCap, bSuccess);
	}
	PyObject* pyRes = PyObject_CallMethodObjArgs(m_pyObj, pyName, pyArg_sCap, pyArg_bSuccess, nullptr);
	if (!pyRes) {
		CString sPyErr = m_pModPython->GetPyExceptionStr();
		DEBUG("modpython: " << (GetUser() ? GetUser()->GetUserName() : CString("<no user>")) << "/" << GetModName() << "/OnServerCapResult failed: " << sPyErr);
		Py_CLEAR(pyName);
		Py_CLEAR(pyArg_sCap);
		Py_CLEAR(pyArg_bSuccess);
		return CModule::OnServerCapResult(sCap, bSuccess);
	}
	Py_CLEAR(pyName);
	Py_CLEAR(pyArg_sCap);
	Py_CLEAR(pyArg_bSuccess);
	Py_CLEAR(pyRes);
}

CModule::EModRet CPyModule::OnTimerAutoJoin(CChan& Channel) {
	PyObject* pyName = Py_BuildValue("s", "OnTimerAutoJoin");
	if (!pyName) {
		CString sPyErr = m_pModPython->GetPyExceptionStr();
		DEBUG("modpython: " << (GetUser() ? GetUser()->GetUserName() : CString("<no user>")) << "/" << GetModName() << "/OnTimerAutoJoin: can't convert string 'OnTimerAutoJoin' to PyObject: " << sPyErr);
		return CModule::OnTimerAutoJoin(Channel);
	}
	PyObject* pyArg_Channel = SWIG_NewInstanceObj(const_cast<CChan*>(&Channel), SWIG_TypeQuery("CChan*"), 0);
	if (!pyArg_Channel) {
		CString sPyErr = m_pModPython->GetPyExceptionStr();
		DEBUG("modpython: " << (GetUser() ? GetUser()->GetUserName() : CString("<no user>")) << "/" << GetModName() << "/OnTimerAutoJoin: can't convert parameter 'Channel' to PyObject: " << sPyErr);
		Py_CLEAR(pyName);
		return CModule::OnTimerAutoJoin(Channel);
	}
	PyObject* pyRes = PyObject_CallMethodObjArgs(m_pyObj, pyName, pyArg_Channel, nullptr);
	if (!pyRes) {
		CString sPyErr = m_pModPython->GetPyExceptionStr();
		DEBUG("modpython: " << (GetUser() ? GetUser()->GetUserName() : CString("<no user>")) << "/" << GetModName() << "/OnTimerAutoJoin failed: " << sPyErr);
		Py_CLEAR(pyName);
		Py_CLEAR(pyArg_Channel);
		return CModule::OnTimerAutoJoin(Channel);
	}
	Py_CLEAR(pyName);
	Py_CLEAR(pyArg_Channel);
	CModule::EModRet result;
	if (pyRes == Py_None) {
		result = CModule::OnTimerAutoJoin(Channel);
	} else {
		long int x = PyLong_AsLong(pyRes);
		if (PyErr_Occurred()) {
			CString sPyErr = m_pModPython->GetPyExceptionStr();
			DEBUG("modpython: " << (GetUser() ? GetUser()->GetUserName() : CString("<no user>")) << "/" << GetModName() << "/OnTimerAutoJoin was expected to return EModRet but: " << sPyErr);
			result = CModule::OnTimerAutoJoin(Channel);
		} else { result = (CModule::EModRet)x; }
	}
	Py_CLEAR(pyRes);
	return result;
}

bool CPyModule::OnEmbeddedWebRequest(CWebSock& WebSock, const CString& sPageName, CTemplate& Tmpl) {
	PyObject* pyName = Py_BuildValue("s", "OnEmbeddedWebRequest");
	if (!pyName) {
		CString sPyErr = m_pModPython->GetPyExceptionStr();
		DEBUG("modpython: " << (GetUser() ? GetUser()->GetUserName() : CString("<no user>")) << "/" << GetModName() << "/OnEmbeddedWebRequest: can't convert string 'OnEmbeddedWebRequest' to PyObject: " << sPyErr);
		return CModule::OnEmbeddedWebRequest(WebSock, sPageName, Tmpl);
	}
	PyObject* pyArg_WebSock = SWIG_NewInstanceObj(const_cast<CWebSock*>(&WebSock), SWIG_TypeQuery("CWebSock*"), 0);
	if (!pyArg_WebSock) {
		CString sPyErr = m_pModPython->GetPyExceptionStr();
		DEBUG("modpython: " << (GetUser() ? GetUser()->GetUserName() : CString("<no user>")) << "/" << GetModName() << "/OnEmbeddedWebRequest: can't convert parameter 'WebSock' to PyObject: " << sPyErr);
		Py_CLEAR(pyName);
		return CModule::OnEmbeddedWebRequest(WebSock, sPageName, Tmpl);
	}
	PyObject* pyArg_sPageName = Py_BuildValue("s", sPageName.c_str());
	if (!pyArg_sPageName) {
		CString sPyErr = m_pModPython->GetPyExceptionStr();
		DEBUG("modpython: " << (GetUser() ? GetUser()->GetUserName() : CString("<no user>")) << "/" << GetModName() << "/OnEmbeddedWebRequest: can't convert parameter 'sPageName' to PyObject: " << sPyErr);
		Py_CLEAR(pyName);
		Py_CLEAR(pyArg_WebSock);
		return CModule::OnEmbeddedWebRequest(WebSock, sPageName, Tmpl);
	}
	PyObject* pyArg_Tmpl = SWIG_NewInstanceObj(const_cast<CTemplate*>(&Tmpl), SWIG_TypeQuery("CTemplate*"), 0);
	if (!pyArg_Tmpl) {
		CString sPyErr = m_pModPython->GetPyExceptionStr();
		DEBUG("modpython: " << (GetUser() ? GetUser()->GetUserName() : CString("<no user>")) << "/" << GetModName() << "/OnEmbeddedWebRequest: can't convert parameter 'Tmpl' to PyObject: " << sPyErr);
		Py_CLEAR(pyName);
		Py_CLEAR(pyArg_WebSock);
		Py_CLEAR(pyArg_sPageName);
		return CModule::OnEmbeddedWebRequest(WebSock, sPageName, Tmpl);
	}
	PyObject* pyRes = PyObject_CallMethodObjArgs(m_pyObj, pyName, pyArg_WebSock, pyArg_sPageName, pyArg_Tmpl, nullptr);
	if (!pyRes) {
		CString sPyErr = m_pModPython->GetPyExceptionStr();
		DEBUG("modpython: " << (GetUser() ? GetUser()->GetUserName() : CString("<no user>")) << "/" << GetModName() << "/OnEmbeddedWebRequest failed: " << sPyErr);
		Py_CLEAR(pyName);
		Py_CLEAR(pyArg_WebSock);
		Py_CLEAR(pyArg_sPageName);
		Py_CLEAR(pyArg_Tmpl);
		return CModule::OnEmbeddedWebRequest(WebSock, sPageName, Tmpl);
	}
	Py_CLEAR(pyName);
	Py_CLEAR(pyArg_WebSock);
	Py_CLEAR(pyArg_sPageName);
	Py_CLEAR(pyArg_Tmpl);
	bool result;
	if (pyRes == Py_None) {
		result = CModule::OnEmbeddedWebRequest(WebSock, sPageName, Tmpl);
	} else {
		int x = PyObject_IsTrue(pyRes);
		if (-1 == x) {
			CString sPyErr = m_pModPython->GetPyExceptionStr();
			DEBUG("modpython: " << (GetUser() ? GetUser()->GetUserName() : CString("<no user>")) << "/" << GetModName() << "/OnEmbeddedWebRequest was expected to return EModRet but: " << sPyErr);
			result = CModule::OnEmbeddedWebRequest(WebSock, sPageName, Tmpl);
		} else result = x ? true : false;
	}
	Py_CLEAR(pyRes);
	return result;
}

CModule::EModRet CPyModule::OnAddNetwork(CIRCNetwork& Network, CString& sErrorRet) {
	PyObject* pyName = Py_BuildValue("s", "OnAddNetwork");
	if (!pyName) {
		CString sPyErr = m_pModPython->GetPyExceptionStr();
		DEBUG("modpython: " << (GetUser() ? GetUser()->GetUserName() : CString("<no user>")) << "/" << GetModName() << "/OnAddNetwork: can't convert string 'OnAddNetwork' to PyObject: " << sPyErr);
		return CModule::OnAddNetwork(Network, sErrorRet);
	}
	PyObject* pyArg_Network = SWIG_NewInstanceObj(const_cast<CIRCNetwork*>(&Network), SWIG_TypeQuery("CIRCNetwork*"), 0);
	if (!pyArg_Network) {
		CString sPyErr = m_pModPython->GetPyExceptionStr();
		DEBUG("modpython: " << (GetUser() ? GetUser()->GetUserName() : CString("<no user>")) << "/" << GetModName() << "/OnAddNetwork: can't convert parameter 'Network' to PyObject: " << sPyErr);
		Py_CLEAR(pyName);
		return CModule::OnAddNetwork(Network, sErrorRet);
	}
	PyObject* pyArg_sErrorRet = CPyRetString::wrap(sErrorRet);
	if (!pyArg_sErrorRet) {
		CString sPyErr = m_pModPython->GetPyExceptionStr();
		DEBUG("modpython: " << (GetUser() ? GetUser()->GetUserName() : CString("<no user>")) << "/" << GetModName() << "/OnAddNetwork: can't convert parameter 'sErrorRet' to PyObject: " << sPyErr);
		Py_CLEAR(pyName);
		Py_CLEAR(pyArg_Network);
		return CModule::OnAddNetwork(Network, sErrorRet);
	}
	PyObject* pyRes = PyObject_CallMethodObjArgs(m_pyObj, pyName, pyArg_Network, pyArg_sErrorRet, nullptr);
	if (!pyRes) {
		CString sPyErr = m_pModPython->GetPyExceptionStr();
		DEBUG("modpython: " << (GetUser() ? GetUser()->GetUserName() : CString("<no user>")) << "/" << GetModName() << "/OnAddNetwork failed: " << sPyErr);
		Py_CLEAR(pyName);
		Py_CLEAR(pyArg_Network);
		Py_CLEAR(pyArg_sErrorRet);
		return CModule::OnAddNetwork(Network, sErrorRet);
	}
	Py_CLEAR(pyName);
	Py_CLEAR(pyArg_Network);
	Py_CLEAR(pyArg_sErrorRet);
	CModule::EModRet result;
	if (pyRes == Py_None) {
		result = CModule::OnAddNetwork(Network, sErrorRet);
	} else {
		long int x = PyLong_AsLong(pyRes);
		if (PyErr_Occurred()) {
			CString sPyErr = m_pModPython->GetPyExceptionStr();
			DEBUG("modpython: " << (GetUser() ? GetUser()->GetUserName() : CString("<no user>")) << "/" << GetModName() << "/OnAddNetwork was expected to return EModRet but: " << sPyErr);
			result = CModule::OnAddNetwork(Network, sErrorRet);
		} else { result = (CModule::EModRet)x; }
	}
	Py_CLEAR(pyRes);
	return result;
}

CModule::EModRet CPyModule::OnDeleteNetwork(CIRCNetwork& Network) {
	PyObject* pyName = Py_BuildValue("s", "OnDeleteNetwork");
	if (!pyName) {
		CString sPyErr = m_pModPython->GetPyExceptionStr();
		DEBUG("modpython: " << (GetUser() ? GetUser()->GetUserName() : CString("<no user>")) << "/" << GetModName() << "/OnDeleteNetwork: can't convert string 'OnDeleteNetwork' to PyObject: " << sPyErr);
		return CModule::OnDeleteNetwork(Network);
	}
	PyObject* pyArg_Network = SWIG_NewInstanceObj(const_cast<CIRCNetwork*>(&Network), SWIG_TypeQuery("CIRCNetwork*"), 0);
	if (!pyArg_Network) {
		CString sPyErr = m_pModPython->GetPyExceptionStr();
		DEBUG("modpython: " << (GetUser() ? GetUser()->GetUserName() : CString("<no user>")) << "/" << GetModName() << "/OnDeleteNetwork: can't convert parameter 'Network' to PyObject: " << sPyErr);
		Py_CLEAR(pyName);
		return CModule::OnDeleteNetwork(Network);
	}
	PyObject* pyRes = PyObject_CallMethodObjArgs(m_pyObj, pyName, pyArg_Network, nullptr);
	if (!pyRes) {
		CString sPyErr = m_pModPython->GetPyExceptionStr();
		DEBUG("modpython: " << (GetUser() ? GetUser()->GetUserName() : CString("<no user>")) << "/" << GetModName() << "/OnDeleteNetwork failed: " << sPyErr);
		Py_CLEAR(pyName);
		Py_CLEAR(pyArg_Network);
		return CModule::OnDeleteNetwork(Network);
	}
	Py_CLEAR(pyName);
	Py_CLEAR(pyArg_Network);
	CModule::EModRet result;
	if (pyRes == Py_None) {
		result = CModule::OnDeleteNetwork(Network);
	} else {
		long int x = PyLong_AsLong(pyRes);
		if (PyErr_Occurred()) {
			CString sPyErr = m_pModPython->GetPyExceptionStr();
			DEBUG("modpython: " << (GetUser() ? GetUser()->GetUserName() : CString("<no user>")) << "/" << GetModName() << "/OnDeleteNetwork was expected to return EModRet but: " << sPyErr);
			result = CModule::OnDeleteNetwork(Network);
		} else { result = (CModule::EModRet)x; }
	}
	Py_CLEAR(pyRes);
	return result;
}

CModule::EModRet CPyModule::OnSendToClient(CString& sLine, CClient& Client) {
	PyObject* pyName = Py_BuildValue("s", "OnSendToClient");
	if (!pyName) {
		CString sPyErr = m_pModPython->GetPyExceptionStr();
		DEBUG("modpython: " << (GetUser() ? GetUser()->GetUserName() : CString("<no user>")) << "/" << GetModName() << "/OnSendToClient: can't convert string 'OnSendToClient' to PyObject: " << sPyErr);
		return CModule::OnSendToClient(sLine, Client);
	}
	PyObject* pyArg_sLine = CPyRetString::wrap(sLine);
	if (!pyArg_sLine) {
		CString sPyErr = m_pModPython->GetPyExceptionStr();
		DEBUG("modpython: " << (GetUser() ? GetUser()->GetUserName() : CString("<no user>")) << "/" << GetModName() << "/OnSendToClient: can't convert parameter 'sLine' to PyObject: " << sPyErr);
		Py_CLEAR(pyName);
		return CModule::OnSendToClient(sLine, Client);
	}
	PyObject* pyArg_Client = SWIG_NewInstanceObj(const_cast<CClient*>(&Client), SWIG_TypeQuery("CClient*"), 0);
	if (!pyArg_Client) {
		CString sPyErr = m_pModPython->GetPyExceptionStr();
		DEBUG("modpython: " << (GetUser() ? GetUser()->GetUserName() : CString("<no user>")) << "/" << GetModName() << "/OnSendToClient: can't convert parameter 'Client' to PyObject: " << sPyErr);
		Py_CLEAR(pyName);
		Py_CLEAR(pyArg_sLine);
		return CModule::OnSendToClient(sLine, Client);
	}
	PyObject* pyRes = PyObject_CallMethodObjArgs(m_pyObj, pyName, pyArg_sLine, pyArg_Client, nullptr);
	if (!pyRes) {
		CString sPyErr = m_pModPython->GetPyExceptionStr();
		DEBUG("modpython: " << (GetUser() ? GetUser()->GetUserName() : CString("<no user>")) << "/" << GetModName() << "/OnSendToClient failed: " << sPyErr);
		Py_CLEAR(pyName);
		Py_CLEAR(pyArg_sLine);
		Py_CLEAR(pyArg_Client);
		return CModule::OnSendToClient(sLine, Client);
	}
	Py_CLEAR(pyName);
	Py_CLEAR(pyArg_sLine);
	Py_CLEAR(pyArg_Client);
	CModule::EModRet result;
	if (pyRes == Py_None) {
		result = CModule::OnSendToClient(sLine, Client);
	} else {
		long int x = PyLong_AsLong(pyRes);
		if (PyErr_Occurred()) {
			CString sPyErr = m_pModPython->GetPyExceptionStr();
			DEBUG("modpython: " << (GetUser() ? GetUser()->GetUserName() : CString("<no user>")) << "/" << GetModName() << "/OnSendToClient was expected to return EModRet but: " << sPyErr);
			result = CModule::OnSendToClient(sLine, Client);
		} else { result = (CModule::EModRet)x; }
	}
	Py_CLEAR(pyRes);
	return result;
}

CModule::EModRet CPyModule::OnSendToIRC(CString& sLine) {
	PyObject* pyName = Py_BuildValue("s", "OnSendToIRC");
	if (!pyName) {
		CString sPyErr = m_pModPython->GetPyExceptionStr();
		DEBUG("modpython: " << (GetUser() ? GetUser()->GetUserName() : CString("<no user>")) << "/" << GetModName() << "/OnSendToIRC: can't convert string 'OnSendToIRC' to PyObject: " << sPyErr);
		return CModule::OnSendToIRC(sLine);
	}
	PyObject* pyArg_sLine = CPyRetString::wrap(sLine);
	if (!pyArg_sLine) {
		CString sPyErr = m_pModPython->GetPyExceptionStr();
		DEBUG("modpython: " << (GetUser() ? GetUser()->GetUserName() : CString("<no user>")) << "/" << GetModName() << "/OnSendToIRC: can't convert parameter 'sLine' to PyObject: " << sPyErr);
		Py_CLEAR(pyName);
		return CModule::OnSendToIRC(sLine);
	}
	PyObject* pyRes = PyObject_CallMethodObjArgs(m_pyObj, pyName, pyArg_sLine, nullptr);
	if (!pyRes) {
		CString sPyErr = m_pModPython->GetPyExceptionStr();
		DEBUG("modpython: " << (GetUser() ? GetUser()->GetUserName() : CString("<no user>")) << "/" << GetModName() << "/OnSendToIRC failed: " << sPyErr);
		Py_CLEAR(pyName);
		Py_CLEAR(pyArg_sLine);
		return CModule::OnSendToIRC(sLine);
	}
	Py_CLEAR(pyName);
	Py_CLEAR(pyArg_sLine);
	CModule::EModRet result;
	if (pyRes == Py_None) {
		result = CModule::OnSendToIRC(sLine);
	} else {
		long int x = PyLong_AsLong(pyRes);
		if (PyErr_Occurred()) {
			CString sPyErr = m_pModPython->GetPyExceptionStr();
			DEBUG("modpython: " << (GetUser() ? GetUser()->GetUserName() : CString("<no user>")) << "/" << GetModName() << "/OnSendToIRC was expected to return EModRet but: " << sPyErr);
			result = CModule::OnSendToIRC(sLine);
		} else { result = (CModule::EModRet)x; }
	}
	Py_CLEAR(pyRes);
	return result;
}

CModule::EModRet CPyModule::OnRawMessage(CMessage& Message) {
	PyObject* pyName = Py_BuildValue("s", "OnRawMessage");
	if (!pyName) {
		CString sPyErr = m_pModPython->GetPyExceptionStr();
		DEBUG("modpython: " << (GetUser() ? GetUser()->GetUserName() : CString("<no user>")) << "/" << GetModName() << "/OnRawMessage: can't convert string 'OnRawMessage' to PyObject: " << sPyErr);
		return CModule::OnRawMessage(Message);
	}
	PyObject* pyArg_Message = SWIG_NewInstanceObj(const_cast<CMessage*>(&Message), SWIG_TypeQuery("CMessage*"), 0);
	if (!pyArg_Message) {
		CString sPyErr = m_pModPython->GetPyExceptionStr();
		DEBUG("modpython: " << (GetUser() ? GetUser()->GetUserName() : CString("<no user>")) << "/" << GetModName() << "/OnRawMessage: can't convert parameter 'Message' to PyObject: " << sPyErr);
		Py_CLEAR(pyName);
		return CModule::OnRawMessage(Message);
	}
	PyObject* pyRes = PyObject_CallMethodObjArgs(m_pyObj, pyName, pyArg_Message, nullptr);
	if (!pyRes) {
		CString sPyErr = m_pModPython->GetPyExceptionStr();
		DEBUG("modpython: " << (GetUser() ? GetUser()->GetUserName() : CString("<no user>")) << "/" << GetModName() << "/OnRawMessage failed: " << sPyErr);
		Py_CLEAR(pyName);
		Py_CLEAR(pyArg_Message);
		return CModule::OnRawMessage(Message);
	}
	Py_CLEAR(pyName);
	Py_CLEAR(pyArg_Message);
	CModule::EModRet result;
	if (pyRes == Py_None) {
		result = CModule::OnRawMessage(Message);
	} else {
		long int x = PyLong_AsLong(pyRes);
		if (PyErr_Occurred()) {
			CString sPyErr = m_pModPython->GetPyExceptionStr();
			DEBUG("modpython: " << (GetUser() ? GetUser()->GetUserName() : CString("<no user>")) << "/" << GetModName() << "/OnRawMessage was expected to return EModRet but: " << sPyErr);
			result = CModule::OnRawMessage(Message);
		} else { result = (CModule::EModRet)x; }
	}
	Py_CLEAR(pyRes);
	return result;
}

CModule::EModRet CPyModule::OnNumericMessage(CNumericMessage& Message) {
	PyObject* pyName = Py_BuildValue("s", "OnNumericMessage");
	if (!pyName) {
		CString sPyErr = m_pModPython->GetPyExceptionStr();
		DEBUG("modpython: " << (GetUser() ? GetUser()->GetUserName() : CString("<no user>")) << "/" << GetModName() << "/OnNumericMessage: can't convert string 'OnNumericMessage' to PyObject: " << sPyErr);
		return CModule::OnNumericMessage(Message);
	}
	PyObject* pyArg_Message = SWIG_NewInstanceObj(const_cast<CNumericMessage*>(&Message), SWIG_TypeQuery("CNumericMessage*"), 0);
	if (!pyArg_Message) {
		CString sPyErr = m_pModPython->GetPyExceptionStr();
		DEBUG("modpython: " << (GetUser() ? GetUser()->GetUserName() : CString("<no user>")) << "/" << GetModName() << "/OnNumericMessage: can't convert parameter 'Message' to PyObject: " << sPyErr);
		Py_CLEAR(pyName);
		return CModule::OnNumericMessage(Message);
	}
	PyObject* pyRes = PyObject_CallMethodObjArgs(m_pyObj, pyName, pyArg_Message, nullptr);
	if (!pyRes) {
		CString sPyErr = m_pModPython->GetPyExceptionStr();
		DEBUG("modpython: " << (GetUser() ? GetUser()->GetUserName() : CString("<no user>")) << "/" << GetModName() << "/OnNumericMessage failed: " << sPyErr);
		Py_CLEAR(pyName);
		Py_CLEAR(pyArg_Message);
		return CModule::OnNumericMessage(Message);
	}
	Py_CLEAR(pyName);
	Py_CLEAR(pyArg_Message);
	CModule::EModRet result;
	if (pyRes == Py_None) {
		result = CModule::OnNumericMessage(Message);
	} else {
		long int x = PyLong_AsLong(pyRes);
		if (PyErr_Occurred()) {
			CString sPyErr = m_pModPython->GetPyExceptionStr();
			DEBUG("modpython: " << (GetUser() ? GetUser()->GetUserName() : CString("<no user>")) << "/" << GetModName() << "/OnNumericMessage was expected to return EModRet but: " << sPyErr);
			result = CModule::OnNumericMessage(Message);
		} else { result = (CModule::EModRet)x; }
	}
	Py_CLEAR(pyRes);
	return result;
}

void CPyModule::OnQuitMessage(CQuitMessage& Message, const std::vector<CChan*>& vChans) {
	PyObject* pyName = Py_BuildValue("s", "OnQuitMessage");
	if (!pyName) {
		CString sPyErr = m_pModPython->GetPyExceptionStr();
		DEBUG("modpython: " << (GetUser() ? GetUser()->GetUserName() : CString("<no user>")) << "/" << GetModName() << "/OnQuitMessage: can't convert string 'OnQuitMessage' to PyObject: " << sPyErr);
		return CModule::OnQuitMessage(Message, vChans);
	}
	PyObject* pyArg_Message = SWIG_NewInstanceObj(const_cast<CQuitMessage*>(&Message), SWIG_TypeQuery("CQuitMessage*"), 0);
	if (!pyArg_Message) {
		CString sPyErr = m_pModPython->GetPyExceptionStr();
		DEBUG("modpython: " << (GetUser() ? GetUser()->GetUserName() : CString("<no user>")) << "/" << GetModName() << "/OnQuitMessage: can't convert parameter 'Message' to PyObject: " << sPyErr);
		Py_CLEAR(pyName);
		return CModule::OnQuitMessage(Message, vChans);
	}
	PyObject* pyArg_vChans = PyList_New(0);
	if (!pyArg_vChans) {
		CString sPyErr = m_pModPython->GetPyExceptionStr();
		DEBUG("modpython: " << (GetUser() ? GetUser()->GetUserName() : CString("<no user>")) << "/" << GetModName() << "/OnQuitMessage: can't convert parameter 'vChans' to PyObject: " << sPyErr);
		Py_CLEAR(pyName);
		Py_CLEAR(pyArg_Message);
		return CModule::OnQuitMessage(Message, vChans);
	}
	for (vector<CChan*>::const_iterator i = vChans.begin(); i != vChans.end(); ++i) {
		PyObject* pyVecEl = SWIG_NewInstanceObj(*i, SWIG_TypeQuery("CChan*"), 0);
		if (!pyVecEl) {
			CString sPyErr = m_pModPython->GetPyExceptionStr();
			DEBUG("modpython: " << (GetUser() ? GetUser()->GetUserName() : CString("<no user>")) << "/" << GetModName() << "/OnQuitMessage: can't convert element of vector 'vChans' to PyObject: " << sPyErr);
			Py_CLEAR(pyName);
			Py_CLEAR(pyArg_Message);
			Py_CLEAR(pyArg_vChans);
			return CModule::OnQuitMessage(Message, vChans);
		}
		if (PyList_Append(pyArg_vChans, pyVecEl)) {
			CString sPyErr = m_pModPython->GetPyExceptionStr();
			DEBUG("modpython: " << (GetUser() ? GetUser()->GetUserName() : CString("<no user>")) << "/" << GetModName() << "/OnQuitMessage: can't add element of vector 'vChans' to PyObject: " << sPyErr);
			Py_CLEAR(pyVecEl);
			Py_CLEAR(pyName);
			Py_CLEAR(pyArg_Message);
			Py_CLEAR(pyArg_vChans);
			return CModule::OnQuitMessage(Message, vChans);
		}
		Py_CLEAR(pyVecEl);
	}
	PyObject* pyRes = PyObject_CallMethodObjArgs(m_pyObj, pyName, pyArg_Message, pyArg_vChans, nullptr);
	if (!pyRes) {
		CString sPyErr = m_pModPython->GetPyExceptionStr();
		DEBUG("modpython: " << (GetUser() ? GetUser()->GetUserName() : CString("<no user>")) << "/" << GetModName() << "/OnQuitMessage failed: " << sPyErr);
		Py_CLEAR(pyName);
		Py_CLEAR(pyArg_Message);
		Py_CLEAR(pyArg_vChans);
		return CModule::OnQuitMessage(Message, vChans);
	}
	Py_CLEAR(pyName);
	Py_CLEAR(pyArg_Message);
	Py_CLEAR(pyArg_vChans);
	Py_CLEAR(pyRes);
}

void CPyModule::OnNickMessage(CNickMessage& Message, const std::vector<CChan*>& vChans) {
	PyObject* pyName = Py_BuildValue("s", "OnNickMessage");
	if (!pyName) {
		CString sPyErr = m_pModPython->GetPyExceptionStr();
		DEBUG("modpython: " << (GetUser() ? GetUser()->GetUserName() : CString("<no user>")) << "/" << GetModName() << "/OnNickMessage: can't convert string 'OnNickMessage' to PyObject: " << sPyErr);
		return CModule::OnNickMessage(Message, vChans);
	}
	PyObject* pyArg_Message = SWIG_NewInstanceObj(const_cast<CNickMessage*>(&Message), SWIG_TypeQuery("CNickMessage*"), 0);
	if (!pyArg_Message) {
		CString sPyErr = m_pModPython->GetPyExceptionStr();
		DEBUG("modpython: " << (GetUser() ? GetUser()->GetUserName() : CString("<no user>")) << "/" << GetModName() << "/OnNickMessage: can't convert parameter 'Message' to PyObject: " << sPyErr);
		Py_CLEAR(pyName);
		return CModule::OnNickMessage(Message, vChans);
	}
	PyObject* pyArg_vChans = PyList_New(0);
	if (!pyArg_vChans) {
		CString sPyErr = m_pModPython->GetPyExceptionStr();
		DEBUG("modpython: " << (GetUser() ? GetUser()->GetUserName() : CString("<no user>")) << "/" << GetModName() << "/OnNickMessage: can't convert parameter 'vChans' to PyObject: " << sPyErr);
		Py_CLEAR(pyName);
		Py_CLEAR(pyArg_Message);
		return CModule::OnNickMessage(Message, vChans);
	}
	for (vector<CChan*>::const_iterator i = vChans.begin(); i != vChans.end(); ++i) {
		PyObject* pyVecEl = SWIG_NewInstanceObj(*i, SWIG_TypeQuery("CChan*"), 0);
		if (!pyVecEl) {
			CString sPyErr = m_pModPython->GetPyExceptionStr();
			DEBUG("modpython: " << (GetUser() ? GetUser()->GetUserName() : CString("<no user>")) << "/" << GetModName() << "/OnNickMessage: can't convert element of vector 'vChans' to PyObject: " << sPyErr);
			Py_CLEAR(pyName);
			Py_CLEAR(pyArg_Message);
			Py_CLEAR(pyArg_vChans);
			return CModule::OnNickMessage(Message, vChans);
		}
		if (PyList_Append(pyArg_vChans, pyVecEl)) {
			CString sPyErr = m_pModPython->GetPyExceptionStr();
			DEBUG("modpython: " << (GetUser() ? GetUser()->GetUserName() : CString("<no user>")) << "/" << GetModName() << "/OnNickMessage: can't add element of vector 'vChans' to PyObject: " << sPyErr);
			Py_CLEAR(pyVecEl);
			Py_CLEAR(pyName);
			Py_CLEAR(pyArg_Message);
			Py_CLEAR(pyArg_vChans);
			return CModule::OnNickMessage(Message, vChans);
		}
		Py_CLEAR(pyVecEl);
	}
	PyObject* pyRes = PyObject_CallMethodObjArgs(m_pyObj, pyName, pyArg_Message, pyArg_vChans, nullptr);
	if (!pyRes) {
		CString sPyErr = m_pModPython->GetPyExceptionStr();
		DEBUG("modpython: " << (GetUser() ? GetUser()->GetUserName() : CString("<no user>")) << "/" << GetModName() << "/OnNickMessage failed: " << sPyErr);
		Py_CLEAR(pyName);
		Py_CLEAR(pyArg_Message);
		Py_CLEAR(pyArg_vChans);
		return CModule::OnNickMessage(Message, vChans);
	}
	Py_CLEAR(pyName);
	Py_CLEAR(pyArg_Message);
	Py_CLEAR(pyArg_vChans);
	Py_CLEAR(pyRes);
}

void CPyModule::OnKickMessage(CKickMessage& Message) {
	PyObject* pyName = Py_BuildValue("s", "OnKickMessage");
	if (!pyName) {
		CString sPyErr = m_pModPython->GetPyExceptionStr();
		DEBUG("modpython: " << (GetUser() ? GetUser()->GetUserName() : CString("<no user>")) << "/" << GetModName() << "/OnKickMessage: can't convert string 'OnKickMessage' to PyObject: " << sPyErr);
		return CModule::OnKickMessage(Message);
	}
	PyObject* pyArg_Message = SWIG_NewInstanceObj(const_cast<CKickMessage*>(&Message), SWIG_TypeQuery("CKickMessage*"), 0);
	if (!pyArg_Message) {
		CString sPyErr = m_pModPython->GetPyExceptionStr();
		DEBUG("modpython: " << (GetUser() ? GetUser()->GetUserName() : CString("<no user>")) << "/" << GetModName() << "/OnKickMessage: can't convert parameter 'Message' to PyObject: " << sPyErr);
		Py_CLEAR(pyName);
		return CModule::OnKickMessage(Message);
	}
	PyObject* pyRes = PyObject_CallMethodObjArgs(m_pyObj, pyName, pyArg_Message, nullptr);
	if (!pyRes) {
		CString sPyErr = m_pModPython->GetPyExceptionStr();
		DEBUG("modpython: " << (GetUser() ? GetUser()->GetUserName() : CString("<no user>")) << "/" << GetModName() << "/OnKickMessage failed: " << sPyErr);
		Py_CLEAR(pyName);
		Py_CLEAR(pyArg_Message);
		return CModule::OnKickMessage(Message);
	}
	Py_CLEAR(pyName);
	Py_CLEAR(pyArg_Message);
	Py_CLEAR(pyRes);
}

void CPyModule::OnJoinMessage(CJoinMessage& Message) {
	PyObject* pyName = Py_BuildValue("s", "OnJoinMessage");
	if (!pyName) {
		CString sPyErr = m_pModPython->GetPyExceptionStr();
		DEBUG("modpython: " << (GetUser() ? GetUser()->GetUserName() : CString("<no user>")) << "/" << GetModName() << "/OnJoinMessage: can't convert string 'OnJoinMessage' to PyObject: " << sPyErr);
		return CModule::OnJoinMessage(Message);
	}
	PyObject* pyArg_Message = SWIG_NewInstanceObj(const_cast<CJoinMessage*>(&Message), SWIG_TypeQuery("CJoinMessage*"), 0);
	if (!pyArg_Message) {
		CString sPyErr = m_pModPython->GetPyExceptionStr();
		DEBUG("modpython: " << (GetUser() ? GetUser()->GetUserName() : CString("<no user>")) << "/" << GetModName() << "/OnJoinMessage: can't convert parameter 'Message' to PyObject: " << sPyErr);
		Py_CLEAR(pyName);
		return CModule::OnJoinMessage(Message);
	}
	PyObject* pyRes = PyObject_CallMethodObjArgs(m_pyObj, pyName, pyArg_Message, nullptr);
	if (!pyRes) {
		CString sPyErr = m_pModPython->GetPyExceptionStr();
		DEBUG("modpython: " << (GetUser() ? GetUser()->GetUserName() : CString("<no user>")) << "/" << GetModName() << "/OnJoinMessage failed: " << sPyErr);
		Py_CLEAR(pyName);
		Py_CLEAR(pyArg_Message);
		return CModule::OnJoinMessage(Message);
	}
	Py_CLEAR(pyName);
	Py_CLEAR(pyArg_Message);
	Py_CLEAR(pyRes);
}

void CPyModule::OnPartMessage(CPartMessage& Message) {
	PyObject* pyName = Py_BuildValue("s", "OnPartMessage");
	if (!pyName) {
		CString sPyErr = m_pModPython->GetPyExceptionStr();
		DEBUG("modpython: " << (GetUser() ? GetUser()->GetUserName() : CString("<no user>")) << "/" << GetModName() << "/OnPartMessage: can't convert string 'OnPartMessage' to PyObject: " << sPyErr);
		return CModule::OnPartMessage(Message);
	}
	PyObject* pyArg_Message = SWIG_NewInstanceObj(const_cast<CPartMessage*>(&Message), SWIG_TypeQuery("CPartMessage*"), 0);
	if (!pyArg_Message) {
		CString sPyErr = m_pModPython->GetPyExceptionStr();
		DEBUG("modpython: " << (GetUser() ? GetUser()->GetUserName() : CString("<no user>")) << "/" << GetModName() << "/OnPartMessage: can't convert parameter 'Message' to PyObject: " << sPyErr);
		Py_CLEAR(pyName);
		return CModule::OnPartMessage(Message);
	}
	PyObject* pyRes = PyObject_CallMethodObjArgs(m_pyObj, pyName, pyArg_Message, nullptr);
	if (!pyRes) {
		CString sPyErr = m_pModPython->GetPyExceptionStr();
		DEBUG("modpython: " << (GetUser() ? GetUser()->GetUserName() : CString("<no user>")) << "/" << GetModName() << "/OnPartMessage failed: " << sPyErr);
		Py_CLEAR(pyName);
		Py_CLEAR(pyArg_Message);
		return CModule::OnPartMessage(Message);
	}
	Py_CLEAR(pyName);
	Py_CLEAR(pyArg_Message);
	Py_CLEAR(pyRes);
}

CModule::EModRet CPyModule::OnChanBufferPlayMessage(CMessage& Message) {
	PyObject* pyName = Py_BuildValue("s", "OnChanBufferPlayMessage");
	if (!pyName) {
		CString sPyErr = m_pModPython->GetPyExceptionStr();
		DEBUG("modpython: " << (GetUser() ? GetUser()->GetUserName() : CString("<no user>")) << "/" << GetModName() << "/OnChanBufferPlayMessage: can't convert string 'OnChanBufferPlayMessage' to PyObject: " << sPyErr);
		return CModule::OnChanBufferPlayMessage(Message);
	}
	PyObject* pyArg_Message = SWIG_NewInstanceObj(const_cast<CMessage*>(&Message), SWIG_TypeQuery("CMessage*"), 0);
	if (!pyArg_Message) {
		CString sPyErr = m_pModPython->GetPyExceptionStr();
		DEBUG("modpython: " << (GetUser() ? GetUser()->GetUserName() : CString("<no user>")) << "/" << GetModName() << "/OnChanBufferPlayMessage: can't convert parameter 'Message' to PyObject: " << sPyErr);
		Py_CLEAR(pyName);
		return CModule::OnChanBufferPlayMessage(Message);
	}
	PyObject* pyRes = PyObject_CallMethodObjArgs(m_pyObj, pyName, pyArg_Message, nullptr);
	if (!pyRes) {
		CString sPyErr = m_pModPython->GetPyExceptionStr();
		DEBUG("modpython: " << (GetUser() ? GetUser()->GetUserName() : CString("<no user>")) << "/" << GetModName() << "/OnChanBufferPlayMessage failed: " << sPyErr);
		Py_CLEAR(pyName);
		Py_CLEAR(pyArg_Message);
		return CModule::OnChanBufferPlayMessage(Message);
	}
	Py_CLEAR(pyName);
	Py_CLEAR(pyArg_Message);
	CModule::EModRet result;
	if (pyRes == Py_None) {
		result = CModule::OnChanBufferPlayMessage(Message);
	} else {
		long int x = PyLong_AsLong(pyRes);
		if (PyErr_Occurred()) {
			CString sPyErr = m_pModPython->GetPyExceptionStr();
			DEBUG("modpython: " << (GetUser() ? GetUser()->GetUserName() : CString("<no user>")) << "/" << GetModName() << "/OnChanBufferPlayMessage was expected to return EModRet but: " << sPyErr);
			result = CModule::OnChanBufferPlayMessage(Message);
		} else { result = (CModule::EModRet)x; }
	}
	Py_CLEAR(pyRes);
	return result;
}

CModule::EModRet CPyModule::OnPrivBufferPlayMessage(CMessage& Message) {
	PyObject* pyName = Py_BuildValue("s", "OnPrivBufferPlayMessage");
	if (!pyName) {
		CString sPyErr = m_pModPython->GetPyExceptionStr();
		DEBUG("modpython: " << (GetUser() ? GetUser()->GetUserName() : CString("<no user>")) << "/" << GetModName() << "/OnPrivBufferPlayMessage: can't convert string 'OnPrivBufferPlayMessage' to PyObject: " << sPyErr);
		return CModule::OnPrivBufferPlayMessage(Message);
	}
	PyObject* pyArg_Message = SWIG_NewInstanceObj(const_cast<CMessage*>(&Message), SWIG_TypeQuery("CMessage*"), 0);
	if (!pyArg_Message) {
		CString sPyErr = m_pModPython->GetPyExceptionStr();
		DEBUG("modpython: " << (GetUser() ? GetUser()->GetUserName() : CString("<no user>")) << "/" << GetModName() << "/OnPrivBufferPlayMessage: can't convert parameter 'Message' to PyObject: " << sPyErr);
		Py_CLEAR(pyName);
		return CModule::OnPrivBufferPlayMessage(Message);
	}
	PyObject* pyRes = PyObject_CallMethodObjArgs(m_pyObj, pyName, pyArg_Message, nullptr);
	if (!pyRes) {
		CString sPyErr = m_pModPython->GetPyExceptionStr();
		DEBUG("modpython: " << (GetUser() ? GetUser()->GetUserName() : CString("<no user>")) << "/" << GetModName() << "/OnPrivBufferPlayMessage failed: " << sPyErr);
		Py_CLEAR(pyName);
		Py_CLEAR(pyArg_Message);
		return CModule::OnPrivBufferPlayMessage(Message);
	}
	Py_CLEAR(pyName);
	Py_CLEAR(pyArg_Message);
	CModule::EModRet result;
	if (pyRes == Py_None) {
		result = CModule::OnPrivBufferPlayMessage(Message);
	} else {
		long int x = PyLong_AsLong(pyRes);
		if (PyErr_Occurred()) {
			CString sPyErr = m_pModPython->GetPyExceptionStr();
			DEBUG("modpython: " << (GetUser() ? GetUser()->GetUserName() : CString("<no user>")) << "/" << GetModName() << "/OnPrivBufferPlayMessage was expected to return EModRet but: " << sPyErr);
			result = CModule::OnPrivBufferPlayMessage(Message);
		} else { result = (CModule::EModRet)x; }
	}
	Py_CLEAR(pyRes);
	return result;
}

CModule::EModRet CPyModule::OnUserRawMessage(CMessage& Message) {
	PyObject* pyName = Py_BuildValue("s", "OnUserRawMessage");
	if (!pyName) {
		CString sPyErr = m_pModPython->GetPyExceptionStr();
		DEBUG("modpython: " << (GetUser() ? GetUser()->GetUserName() : CString("<no user>")) << "/" << GetModName() << "/OnUserRawMessage: can't convert string 'OnUserRawMessage' to PyObject: " << sPyErr);
		return CModule::OnUserRawMessage(Message);
	}
	PyObject* pyArg_Message = SWIG_NewInstanceObj(const_cast<CMessage*>(&Message), SWIG_TypeQuery("CMessage*"), 0);
	if (!pyArg_Message) {
		CString sPyErr = m_pModPython->GetPyExceptionStr();
		DEBUG("modpython: " << (GetUser() ? GetUser()->GetUserName() : CString("<no user>")) << "/" << GetModName() << "/OnUserRawMessage: can't convert parameter 'Message' to PyObject: " << sPyErr);
		Py_CLEAR(pyName);
		return CModule::OnUserRawMessage(Message);
	}
	PyObject* pyRes = PyObject_CallMethodObjArgs(m_pyObj, pyName, pyArg_Message, nullptr);
	if (!pyRes) {
		CString sPyErr = m_pModPython->GetPyExceptionStr();
		DEBUG("modpython: " << (GetUser() ? GetUser()->GetUserName() : CString("<no user>")) << "/" << GetModName() << "/OnUserRawMessage failed: " << sPyErr);
		Py_CLEAR(pyName);
		Py_CLEAR(pyArg_Message);
		return CModule::OnUserRawMessage(Message);
	}
	Py_CLEAR(pyName);
	Py_CLEAR(pyArg_Message);
	CModule::EModRet result;
	if (pyRes == Py_None) {
		result = CModule::OnUserRawMessage(Message);
	} else {
		long int x = PyLong_AsLong(pyRes);
		if (PyErr_Occurred()) {
			CString sPyErr = m_pModPython->GetPyExceptionStr();
			DEBUG("modpython: " << (GetUser() ? GetUser()->GetUserName() : CString("<no user>")) << "/" << GetModName() << "/OnUserRawMessage was expected to return EModRet but: " << sPyErr);
			result = CModule::OnUserRawMessage(Message);
		} else { result = (CModule::EModRet)x; }
	}
	Py_CLEAR(pyRes);
	return result;
}

CModule::EModRet CPyModule::OnUserCTCPReplyMessage(CCTCPMessage& Message) {
	PyObject* pyName = Py_BuildValue("s", "OnUserCTCPReplyMessage");
	if (!pyName) {
		CString sPyErr = m_pModPython->GetPyExceptionStr();
		DEBUG("modpython: " << (GetUser() ? GetUser()->GetUserName() : CString("<no user>")) << "/" << GetModName() << "/OnUserCTCPReplyMessage: can't convert string 'OnUserCTCPReplyMessage' to PyObject: " << sPyErr);
		return CModule::OnUserCTCPReplyMessage(Message);
	}
	PyObject* pyArg_Message = SWIG_NewInstanceObj(const_cast<CCTCPMessage*>(&Message), SWIG_TypeQuery("CCTCPMessage*"), 0);
	if (!pyArg_Message) {
		CString sPyErr = m_pModPython->GetPyExceptionStr();
		DEBUG("modpython: " << (GetUser() ? GetUser()->GetUserName() : CString("<no user>")) << "/" << GetModName() << "/OnUserCTCPReplyMessage: can't convert parameter 'Message' to PyObject: " << sPyErr);
		Py_CLEAR(pyName);
		return CModule::OnUserCTCPReplyMessage(Message);
	}
	PyObject* pyRes = PyObject_CallMethodObjArgs(m_pyObj, pyName, pyArg_Message, nullptr);
	if (!pyRes) {
		CString sPyErr = m_pModPython->GetPyExceptionStr();
		DEBUG("modpython: " << (GetUser() ? GetUser()->GetUserName() : CString("<no user>")) << "/" << GetModName() << "/OnUserCTCPReplyMessage failed: " << sPyErr);
		Py_CLEAR(pyName);
		Py_CLEAR(pyArg_Message);
		return CModule::OnUserCTCPReplyMessage(Message);
	}
	Py_CLEAR(pyName);
	Py_CLEAR(pyArg_Message);
	CModule::EModRet result;
	if (pyRes == Py_None) {
		result = CModule::OnUserCTCPReplyMessage(Message);
	} else {
		long int x = PyLong_AsLong(pyRes);
		if (PyErr_Occurred()) {
			CString sPyErr = m_pModPython->GetPyExceptionStr();
			DEBUG("modpython: " << (GetUser() ? GetUser()->GetUserName() : CString("<no user>")) << "/" << GetModName() << "/OnUserCTCPReplyMessage was expected to return EModRet but: " << sPyErr);
			result = CModule::OnUserCTCPReplyMessage(Message);
		} else { result = (CModule::EModRet)x; }
	}
	Py_CLEAR(pyRes);
	return result;
}

CModule::EModRet CPyModule::OnUserCTCPMessage(CCTCPMessage& Message) {
	PyObject* pyName = Py_BuildValue("s", "OnUserCTCPMessage");
	if (!pyName) {
		CString sPyErr = m_pModPython->GetPyExceptionStr();
		DEBUG("modpython: " << (GetUser() ? GetUser()->GetUserName() : CString("<no user>")) << "/" << GetModName() << "/OnUserCTCPMessage: can't convert string 'OnUserCTCPMessage' to PyObject: " << sPyErr);
		return CModule::OnUserCTCPMessage(Message);
	}
	PyObject* pyArg_Message = SWIG_NewInstanceObj(const_cast<CCTCPMessage*>(&Message), SWIG_TypeQuery("CCTCPMessage*"), 0);
	if (!pyArg_Message) {
		CString sPyErr = m_pModPython->GetPyExceptionStr();
		DEBUG("modpython: " << (GetUser() ? GetUser()->GetUserName() : CString("<no user>")) << "/" << GetModName() << "/OnUserCTCPMessage: can't convert parameter 'Message' to PyObject: " << sPyErr);
		Py_CLEAR(pyName);
		return CModule::OnUserCTCPMessage(Message);
	}
	PyObject* pyRes = PyObject_CallMethodObjArgs(m_pyObj, pyName, pyArg_Message, nullptr);
	if (!pyRes) {
		CString sPyErr = m_pModPython->GetPyExceptionStr();
		DEBUG("modpython: " << (GetUser() ? GetUser()->GetUserName() : CString("<no user>")) << "/" << GetModName() << "/OnUserCTCPMessage failed: " << sPyErr);
		Py_CLEAR(pyName);
		Py_CLEAR(pyArg_Message);
		return CModule::OnUserCTCPMessage(Message);
	}
	Py_CLEAR(pyName);
	Py_CLEAR(pyArg_Message);
	CModule::EModRet result;
	if (pyRes == Py_None) {
		result = CModule::OnUserCTCPMessage(Message);
	} else {
		long int x = PyLong_AsLong(pyRes);
		if (PyErr_Occurred()) {
			CString sPyErr = m_pModPython->GetPyExceptionStr();
			DEBUG("modpython: " << (GetUser() ? GetUser()->GetUserName() : CString("<no user>")) << "/" << GetModName() << "/OnUserCTCPMessage was expected to return EModRet but: " << sPyErr);
			result = CModule::OnUserCTCPMessage(Message);
		} else { result = (CModule::EModRet)x; }
	}
	Py_CLEAR(pyRes);
	return result;
}

CModule::EModRet CPyModule::OnUserActionMessage(CActionMessage& Message) {
	PyObject* pyName = Py_BuildValue("s", "OnUserActionMessage");
	if (!pyName) {
		CString sPyErr = m_pModPython->GetPyExceptionStr();
		DEBUG("modpython: " << (GetUser() ? GetUser()->GetUserName() : CString("<no user>")) << "/" << GetModName() << "/OnUserActionMessage: can't convert string 'OnUserActionMessage' to PyObject: " << sPyErr);
		return CModule::OnUserActionMessage(Message);
	}
	PyObject* pyArg_Message = SWIG_NewInstanceObj(const_cast<CActionMessage*>(&Message), SWIG_TypeQuery("CActionMessage*"), 0);
	if (!pyArg_Message) {
		CString sPyErr = m_pModPython->GetPyExceptionStr();
		DEBUG("modpython: " << (GetUser() ? GetUser()->GetUserName() : CString("<no user>")) << "/" << GetModName() << "/OnUserActionMessage: can't convert parameter 'Message' to PyObject: " << sPyErr);
		Py_CLEAR(pyName);
		return CModule::OnUserActionMessage(Message);
	}
	PyObject* pyRes = PyObject_CallMethodObjArgs(m_pyObj, pyName, pyArg_Message, nullptr);
	if (!pyRes) {
		CString sPyErr = m_pModPython->GetPyExceptionStr();
		DEBUG("modpython: " << (GetUser() ? GetUser()->GetUserName() : CString("<no user>")) << "/" << GetModName() << "/OnUserActionMessage failed: " << sPyErr);
		Py_CLEAR(pyName);
		Py_CLEAR(pyArg_Message);
		return CModule::OnUserActionMessage(Message);
	}
	Py_CLEAR(pyName);
	Py_CLEAR(pyArg_Message);
	CModule::EModRet result;
	if (pyRes == Py_None) {
		result = CModule::OnUserActionMessage(Message);
	} else {
		long int x = PyLong_AsLong(pyRes);
		if (PyErr_Occurred()) {
			CString sPyErr = m_pModPython->GetPyExceptionStr();
			DEBUG("modpython: " << (GetUser() ? GetUser()->GetUserName() : CString("<no user>")) << "/" << GetModName() << "/OnUserActionMessage was expected to return EModRet but: " << sPyErr);
			result = CModule::OnUserActionMessage(Message);
		} else { result = (CModule::EModRet)x; }
	}
	Py_CLEAR(pyRes);
	return result;
}

CModule::EModRet CPyModule::OnUserTextMessage(CTextMessage& Message) {
	PyObject* pyName = Py_BuildValue("s", "OnUserTextMessage");
	if (!pyName) {
		CString sPyErr = m_pModPython->GetPyExceptionStr();
		DEBUG("modpython: " << (GetUser() ? GetUser()->GetUserName() : CString("<no user>")) << "/" << GetModName() << "/OnUserTextMessage: can't convert string 'OnUserTextMessage' to PyObject: " << sPyErr);
		return CModule::OnUserTextMessage(Message);
	}
	PyObject* pyArg_Message = SWIG_NewInstanceObj(const_cast<CTextMessage*>(&Message), SWIG_TypeQuery("CTextMessage*"), 0);
	if (!pyArg_Message) {
		CString sPyErr = m_pModPython->GetPyExceptionStr();
		DEBUG("modpython: " << (GetUser() ? GetUser()->GetUserName() : CString("<no user>")) << "/" << GetModName() << "/OnUserTextMessage: can't convert parameter 'Message' to PyObject: " << sPyErr);
		Py_CLEAR(pyName);
		return CModule::OnUserTextMessage(Message);
	}
	PyObject* pyRes = PyObject_CallMethodObjArgs(m_pyObj, pyName, pyArg_Message, nullptr);
	if (!pyRes) {
		CString sPyErr = m_pModPython->GetPyExceptionStr();
		DEBUG("modpython: " << (GetUser() ? GetUser()->GetUserName() : CString("<no user>")) << "/" << GetModName() << "/OnUserTextMessage failed: " << sPyErr);
		Py_CLEAR(pyName);
		Py_CLEAR(pyArg_Message);
		return CModule::OnUserTextMessage(Message);
	}
	Py_CLEAR(pyName);
	Py_CLEAR(pyArg_Message);
	CModule::EModRet result;
	if (pyRes == Py_None) {
		result = CModule::OnUserTextMessage(Message);
	} else {
		long int x = PyLong_AsLong(pyRes);
		if (PyErr_Occurred()) {
			CString sPyErr = m_pModPython->GetPyExceptionStr();
			DEBUG("modpython: " << (GetUser() ? GetUser()->GetUserName() : CString("<no user>")) << "/" << GetModName() << "/OnUserTextMessage was expected to return EModRet but: " << sPyErr);
			result = CModule::OnUserTextMessage(Message);
		} else { result = (CModule::EModRet)x; }
	}
	Py_CLEAR(pyRes);
	return result;
}

CModule::EModRet CPyModule::OnUserNoticeMessage(CNoticeMessage& Message) {
	PyObject* pyName = Py_BuildValue("s", "OnUserNoticeMessage");
	if (!pyName) {
		CString sPyErr = m_pModPython->GetPyExceptionStr();
		DEBUG("modpython: " << (GetUser() ? GetUser()->GetUserName() : CString("<no user>")) << "/" << GetModName() << "/OnUserNoticeMessage: can't convert string 'OnUserNoticeMessage' to PyObject: " << sPyErr);
		return CModule::OnUserNoticeMessage(Message);
	}
	PyObject* pyArg_Message = SWIG_NewInstanceObj(const_cast<CNoticeMessage*>(&Message), SWIG_TypeQuery("CNoticeMessage*"), 0);
	if (!pyArg_Message) {
		CString sPyErr = m_pModPython->GetPyExceptionStr();
		DEBUG("modpython: " << (GetUser() ? GetUser()->GetUserName() : CString("<no user>")) << "/" << GetModName() << "/OnUserNoticeMessage: can't convert parameter 'Message' to PyObject: " << sPyErr);
		Py_CLEAR(pyName);
		return CModule::OnUserNoticeMessage(Message);
	}
	PyObject* pyRes = PyObject_CallMethodObjArgs(m_pyObj, pyName, pyArg_Message, nullptr);
	if (!pyRes) {
		CString sPyErr = m_pModPython->GetPyExceptionStr();
		DEBUG("modpython: " << (GetUser() ? GetUser()->GetUserName() : CString("<no user>")) << "/" << GetModName() << "/OnUserNoticeMessage failed: " << sPyErr);
		Py_CLEAR(pyName);
		Py_CLEAR(pyArg_Message);
		return CModule::OnUserNoticeMessage(Message);
	}
	Py_CLEAR(pyName);
	Py_CLEAR(pyArg_Message);
	CModule::EModRet result;
	if (pyRes == Py_None) {
		result = CModule::OnUserNoticeMessage(Message);
	} else {
		long int x = PyLong_AsLong(pyRes);
		if (PyErr_Occurred()) {
			CString sPyErr = m_pModPython->GetPyExceptionStr();
			DEBUG("modpython: " << (GetUser() ? GetUser()->GetUserName() : CString("<no user>")) << "/" << GetModName() << "/OnUserNoticeMessage was expected to return EModRet but: " << sPyErr);
			result = CModule::OnUserNoticeMessage(Message);
		} else { result = (CModule::EModRet)x; }
	}
	Py_CLEAR(pyRes);
	return result;
}

CModule::EModRet CPyModule::OnUserJoinMessage(CJoinMessage& Message) {
	PyObject* pyName = Py_BuildValue("s", "OnUserJoinMessage");
	if (!pyName) {
		CString sPyErr = m_pModPython->GetPyExceptionStr();
		DEBUG("modpython: " << (GetUser() ? GetUser()->GetUserName() : CString("<no user>")) << "/" << GetModName() << "/OnUserJoinMessage: can't convert string 'OnUserJoinMessage' to PyObject: " << sPyErr);
		return CModule::OnUserJoinMessage(Message);
	}
	PyObject* pyArg_Message = SWIG_NewInstanceObj(const_cast<CJoinMessage*>(&Message), SWIG_TypeQuery("CJoinMessage*"), 0);
	if (!pyArg_Message) {
		CString sPyErr = m_pModPython->GetPyExceptionStr();
		DEBUG("modpython: " << (GetUser() ? GetUser()->GetUserName() : CString("<no user>")) << "/" << GetModName() << "/OnUserJoinMessage: can't convert parameter 'Message' to PyObject: " << sPyErr);
		Py_CLEAR(pyName);
		return CModule::OnUserJoinMessage(Message);
	}
	PyObject* pyRes = PyObject_CallMethodObjArgs(m_pyObj, pyName, pyArg_Message, nullptr);
	if (!pyRes) {
		CString sPyErr = m_pModPython->GetPyExceptionStr();
		DEBUG("modpython: " << (GetUser() ? GetUser()->GetUserName() : CString("<no user>")) << "/" << GetModName() << "/OnUserJoinMessage failed: " << sPyErr);
		Py_CLEAR(pyName);
		Py_CLEAR(pyArg_Message);
		return CModule::OnUserJoinMessage(Message);
	}
	Py_CLEAR(pyName);
	Py_CLEAR(pyArg_Message);
	CModule::EModRet result;
	if (pyRes == Py_None) {
		result = CModule::OnUserJoinMessage(Message);
	} else {
		long int x = PyLong_AsLong(pyRes);
		if (PyErr_Occurred()) {
			CString sPyErr = m_pModPython->GetPyExceptionStr();
			DEBUG("modpython: " << (GetUser() ? GetUser()->GetUserName() : CString("<no user>")) << "/" << GetModName() << "/OnUserJoinMessage was expected to return EModRet but: " << sPyErr);
			result = CModule::OnUserJoinMessage(Message);
		} else { result = (CModule::EModRet)x; }
	}
	Py_CLEAR(pyRes);
	return result;
}

CModule::EModRet CPyModule::OnUserPartMessage(CPartMessage& Message) {
	PyObject* pyName = Py_BuildValue("s", "OnUserPartMessage");
	if (!pyName) {
		CString sPyErr = m_pModPython->GetPyExceptionStr();
		DEBUG("modpython: " << (GetUser() ? GetUser()->GetUserName() : CString("<no user>")) << "/" << GetModName() << "/OnUserPartMessage: can't convert string 'OnUserPartMessage' to PyObject: " << sPyErr);
		return CModule::OnUserPartMessage(Message);
	}
	PyObject* pyArg_Message = SWIG_NewInstanceObj(const_cast<CPartMessage*>(&Message), SWIG_TypeQuery("CPartMessage*"), 0);
	if (!pyArg_Message) {
		CString sPyErr = m_pModPython->GetPyExceptionStr();
		DEBUG("modpython: " << (GetUser() ? GetUser()->GetUserName() : CString("<no user>")) << "/" << GetModName() << "/OnUserPartMessage: can't convert parameter 'Message' to PyObject: " << sPyErr);
		Py_CLEAR(pyName);
		return CModule::OnUserPartMessage(Message);
	}
	PyObject* pyRes = PyObject_CallMethodObjArgs(m_pyObj, pyName, pyArg_Message, nullptr);
	if (!pyRes) {
		CString sPyErr = m_pModPython->GetPyExceptionStr();
		DEBUG("modpython: " << (GetUser() ? GetUser()->GetUserName() : CString("<no user>")) << "/" << GetModName() << "/OnUserPartMessage failed: " << sPyErr);
		Py_CLEAR(pyName);
		Py_CLEAR(pyArg_Message);
		return CModule::OnUserPartMessage(Message);
	}
	Py_CLEAR(pyName);
	Py_CLEAR(pyArg_Message);
	CModule::EModRet result;
	if (pyRes == Py_None) {
		result = CModule::OnUserPartMessage(Message);
	} else {
		long int x = PyLong_AsLong(pyRes);
		if (PyErr_Occurred()) {
			CString sPyErr = m_pModPython->GetPyExceptionStr();
			DEBUG("modpython: " << (GetUser() ? GetUser()->GetUserName() : CString("<no user>")) << "/" << GetModName() << "/OnUserPartMessage was expected to return EModRet but: " << sPyErr);
			result = CModule::OnUserPartMessage(Message);
		} else { result = (CModule::EModRet)x; }
	}
	Py_CLEAR(pyRes);
	return result;
}

CModule::EModRet CPyModule::OnUserTopicMessage(CTopicMessage& Message) {
	PyObject* pyName = Py_BuildValue("s", "OnUserTopicMessage");
	if (!pyName) {
		CString sPyErr = m_pModPython->GetPyExceptionStr();
		DEBUG("modpython: " << (GetUser() ? GetUser()->GetUserName() : CString("<no user>")) << "/" << GetModName() << "/OnUserTopicMessage: can't convert string 'OnUserTopicMessage' to PyObject: " << sPyErr);
		return CModule::OnUserTopicMessage(Message);
	}
	PyObject* pyArg_Message = SWIG_NewInstanceObj(const_cast<CTopicMessage*>(&Message), SWIG_TypeQuery("CTopicMessage*"), 0);
	if (!pyArg_Message) {
		CString sPyErr = m_pModPython->GetPyExceptionStr();
		DEBUG("modpython: " << (GetUser() ? GetUser()->GetUserName() : CString("<no user>")) << "/" << GetModName() << "/OnUserTopicMessage: can't convert parameter 'Message' to PyObject: " << sPyErr);
		Py_CLEAR(pyName);
		return CModule::OnUserTopicMessage(Message);
	}
	PyObject* pyRes = PyObject_CallMethodObjArgs(m_pyObj, pyName, pyArg_Message, nullptr);
	if (!pyRes) {
		CString sPyErr = m_pModPython->GetPyExceptionStr();
		DEBUG("modpython: " << (GetUser() ? GetUser()->GetUserName() : CString("<no user>")) << "/" << GetModName() << "/OnUserTopicMessage failed: " << sPyErr);
		Py_CLEAR(pyName);
		Py_CLEAR(pyArg_Message);
		return CModule::OnUserTopicMessage(Message);
	}
	Py_CLEAR(pyName);
	Py_CLEAR(pyArg_Message);
	CModule::EModRet result;
	if (pyRes == Py_None) {
		result = CModule::OnUserTopicMessage(Message);
	} else {
		long int x = PyLong_AsLong(pyRes);
		if (PyErr_Occurred()) {
			CString sPyErr = m_pModPython->GetPyExceptionStr();
			DEBUG("modpython: " << (GetUser() ? GetUser()->GetUserName() : CString("<no user>")) << "/" << GetModName() << "/OnUserTopicMessage was expected to return EModRet but: " << sPyErr);
			result = CModule::OnUserTopicMessage(Message);
		} else { result = (CModule::EModRet)x; }
	}
	Py_CLEAR(pyRes);
	return result;
}

CModule::EModRet CPyModule::OnUserQuitMessage(CQuitMessage& Message) {
	PyObject* pyName = Py_BuildValue("s", "OnUserQuitMessage");
	if (!pyName) {
		CString sPyErr = m_pModPython->GetPyExceptionStr();
		DEBUG("modpython: " << (GetUser() ? GetUser()->GetUserName() : CString("<no user>")) << "/" << GetModName() << "/OnUserQuitMessage: can't convert string 'OnUserQuitMessage' to PyObject: " << sPyErr);
		return CModule::OnUserQuitMessage(Message);
	}
	PyObject* pyArg_Message = SWIG_NewInstanceObj(const_cast<CQuitMessage*>(&Message), SWIG_TypeQuery("CQuitMessage*"), 0);
	if (!pyArg_Message) {
		CString sPyErr = m_pModPython->GetPyExceptionStr();
		DEBUG("modpython: " << (GetUser() ? GetUser()->GetUserName() : CString("<no user>")) << "/" << GetModName() << "/OnUserQuitMessage: can't convert parameter 'Message' to PyObject: " << sPyErr);
		Py_CLEAR(pyName);
		return CModule::OnUserQuitMessage(Message);
	}
	PyObject* pyRes = PyObject_CallMethodObjArgs(m_pyObj, pyName, pyArg_Message, nullptr);
	if (!pyRes) {
		CString sPyErr = m_pModPython->GetPyExceptionStr();
		DEBUG("modpython: " << (GetUser() ? GetUser()->GetUserName() : CString("<no user>")) << "/" << GetModName() << "/OnUserQuitMessage failed: " << sPyErr);
		Py_CLEAR(pyName);
		Py_CLEAR(pyArg_Message);
		return CModule::OnUserQuitMessage(Message);
	}
	Py_CLEAR(pyName);
	Py_CLEAR(pyArg_Message);
	CModule::EModRet result;
	if (pyRes == Py_None) {
		result = CModule::OnUserQuitMessage(Message);
	} else {
		long int x = PyLong_AsLong(pyRes);
		if (PyErr_Occurred()) {
			CString sPyErr = m_pModPython->GetPyExceptionStr();
			DEBUG("modpython: " << (GetUser() ? GetUser()->GetUserName() : CString("<no user>")) << "/" << GetModName() << "/OnUserQuitMessage was expected to return EModRet but: " << sPyErr);
			result = CModule::OnUserQuitMessage(Message);
		} else { result = (CModule::EModRet)x; }
	}
	Py_CLEAR(pyRes);
	return result;
}

CModule::EModRet CPyModule::OnCTCPReplyMessage(CCTCPMessage& Message) {
	PyObject* pyName = Py_BuildValue("s", "OnCTCPReplyMessage");
	if (!pyName) {
		CString sPyErr = m_pModPython->GetPyExceptionStr();
		DEBUG("modpython: " << (GetUser() ? GetUser()->GetUserName() : CString("<no user>")) << "/" << GetModName() << "/OnCTCPReplyMessage: can't convert string 'OnCTCPReplyMessage' to PyObject: " << sPyErr);
		return CModule::OnCTCPReplyMessage(Message);
	}
	PyObject* pyArg_Message = SWIG_NewInstanceObj(const_cast<CCTCPMessage*>(&Message), SWIG_TypeQuery("CCTCPMessage*"), 0);
	if (!pyArg_Message) {
		CString sPyErr = m_pModPython->GetPyExceptionStr();
		DEBUG("modpython: " << (GetUser() ? GetUser()->GetUserName() : CString("<no user>")) << "/" << GetModName() << "/OnCTCPReplyMessage: can't convert parameter 'Message' to PyObject: " << sPyErr);
		Py_CLEAR(pyName);
		return CModule::OnCTCPReplyMessage(Message);
	}
	PyObject* pyRes = PyObject_CallMethodObjArgs(m_pyObj, pyName, pyArg_Message, nullptr);
	if (!pyRes) {
		CString sPyErr = m_pModPython->GetPyExceptionStr();
		DEBUG("modpython: " << (GetUser() ? GetUser()->GetUserName() : CString("<no user>")) << "/" << GetModName() << "/OnCTCPReplyMessage failed: " << sPyErr);
		Py_CLEAR(pyName);
		Py_CLEAR(pyArg_Message);
		return CModule::OnCTCPReplyMessage(Message);
	}
	Py_CLEAR(pyName);
	Py_CLEAR(pyArg_Message);
	CModule::EModRet result;
	if (pyRes == Py_None) {
		result = CModule::OnCTCPReplyMessage(Message);
	} else {
		long int x = PyLong_AsLong(pyRes);
		if (PyErr_Occurred()) {
			CString sPyErr = m_pModPython->GetPyExceptionStr();
			DEBUG("modpython: " << (GetUser() ? GetUser()->GetUserName() : CString("<no user>")) << "/" << GetModName() << "/OnCTCPReplyMessage was expected to return EModRet but: " << sPyErr);
			result = CModule::OnCTCPReplyMessage(Message);
		} else { result = (CModule::EModRet)x; }
	}
	Py_CLEAR(pyRes);
	return result;
}

CModule::EModRet CPyModule::OnPrivCTCPMessage(CCTCPMessage& Message) {
	PyObject* pyName = Py_BuildValue("s", "OnPrivCTCPMessage");
	if (!pyName) {
		CString sPyErr = m_pModPython->GetPyExceptionStr();
		DEBUG("modpython: " << (GetUser() ? GetUser()->GetUserName() : CString("<no user>")) << "/" << GetModName() << "/OnPrivCTCPMessage: can't convert string 'OnPrivCTCPMessage' to PyObject: " << sPyErr);
		return CModule::OnPrivCTCPMessage(Message);
	}
	PyObject* pyArg_Message = SWIG_NewInstanceObj(const_cast<CCTCPMessage*>(&Message), SWIG_TypeQuery("CCTCPMessage*"), 0);
	if (!pyArg_Message) {
		CString sPyErr = m_pModPython->GetPyExceptionStr();
		DEBUG("modpython: " << (GetUser() ? GetUser()->GetUserName() : CString("<no user>")) << "/" << GetModName() << "/OnPrivCTCPMessage: can't convert parameter 'Message' to PyObject: " << sPyErr);
		Py_CLEAR(pyName);
		return CModule::OnPrivCTCPMessage(Message);
	}
	PyObject* pyRes = PyObject_CallMethodObjArgs(m_pyObj, pyName, pyArg_Message, nullptr);
	if (!pyRes) {
		CString sPyErr = m_pModPython->GetPyExceptionStr();
		DEBUG("modpython: " << (GetUser() ? GetUser()->GetUserName() : CString("<no user>")) << "/" << GetModName() << "/OnPrivCTCPMessage failed: " << sPyErr);
		Py_CLEAR(pyName);
		Py_CLEAR(pyArg_Message);
		return CModule::OnPrivCTCPMessage(Message);
	}
	Py_CLEAR(pyName);
	Py_CLEAR(pyArg_Message);
	CModule::EModRet result;
	if (pyRes == Py_None) {
		result = CModule::OnPrivCTCPMessage(Message);
	} else {
		long int x = PyLong_AsLong(pyRes);
		if (PyErr_Occurred()) {
			CString sPyErr = m_pModPython->GetPyExceptionStr();
			DEBUG("modpython: " << (GetUser() ? GetUser()->GetUserName() : CString("<no user>")) << "/" << GetModName() << "/OnPrivCTCPMessage was expected to return EModRet but: " << sPyErr);
			result = CModule::OnPrivCTCPMessage(Message);
		} else { result = (CModule::EModRet)x; }
	}
	Py_CLEAR(pyRes);
	return result;
}

CModule::EModRet CPyModule::OnChanCTCPMessage(CCTCPMessage& Message) {
	PyObject* pyName = Py_BuildValue("s", "OnChanCTCPMessage");
	if (!pyName) {
		CString sPyErr = m_pModPython->GetPyExceptionStr();
		DEBUG("modpython: " << (GetUser() ? GetUser()->GetUserName() : CString("<no user>")) << "/" << GetModName() << "/OnChanCTCPMessage: can't convert string 'OnChanCTCPMessage' to PyObject: " << sPyErr);
		return CModule::OnChanCTCPMessage(Message);
	}
	PyObject* pyArg_Message = SWIG_NewInstanceObj(const_cast<CCTCPMessage*>(&Message), SWIG_TypeQuery("CCTCPMessage*"), 0);
	if (!pyArg_Message) {
		CString sPyErr = m_pModPython->GetPyExceptionStr();
		DEBUG("modpython: " << (GetUser() ? GetUser()->GetUserName() : CString("<no user>")) << "/" << GetModName() << "/OnChanCTCPMessage: can't convert parameter 'Message' to PyObject: " << sPyErr);
		Py_CLEAR(pyName);
		return CModule::OnChanCTCPMessage(Message);
	}
	PyObject* pyRes = PyObject_CallMethodObjArgs(m_pyObj, pyName, pyArg_Message, nullptr);
	if (!pyRes) {
		CString sPyErr = m_pModPython->GetPyExceptionStr();
		DEBUG("modpython: " << (GetUser() ? GetUser()->GetUserName() : CString("<no user>")) << "/" << GetModName() << "/OnChanCTCPMessage failed: " << sPyErr);
		Py_CLEAR(pyName);
		Py_CLEAR(pyArg_Message);
		return CModule::OnChanCTCPMessage(Message);
	}
	Py_CLEAR(pyName);
	Py_CLEAR(pyArg_Message);
	CModule::EModRet result;
	if (pyRes == Py_None) {
		result = CModule::OnChanCTCPMessage(Message);
	} else {
		long int x = PyLong_AsLong(pyRes);
		if (PyErr_Occurred()) {
			CString sPyErr = m_pModPython->GetPyExceptionStr();
			DEBUG("modpython: " << (GetUser() ? GetUser()->GetUserName() : CString("<no user>")) << "/" << GetModName() << "/OnChanCTCPMessage was expected to return EModRet but: " << sPyErr);
			result = CModule::OnChanCTCPMessage(Message);
		} else { result = (CModule::EModRet)x; }
	}
	Py_CLEAR(pyRes);
	return result;
}

CModule::EModRet CPyModule::OnPrivActionMessage(CActionMessage& Message) {
	PyObject* pyName = Py_BuildValue("s", "OnPrivActionMessage");
	if (!pyName) {
		CString sPyErr = m_pModPython->GetPyExceptionStr();
		DEBUG("modpython: " << (GetUser() ? GetUser()->GetUserName() : CString("<no user>")) << "/" << GetModName() << "/OnPrivActionMessage: can't convert string 'OnPrivActionMessage' to PyObject: " << sPyErr);
		return CModule::OnPrivActionMessage(Message);
	}
	PyObject* pyArg_Message = SWIG_NewInstanceObj(const_cast<CActionMessage*>(&Message), SWIG_TypeQuery("CActionMessage*"), 0);
	if (!pyArg_Message) {
		CString sPyErr = m_pModPython->GetPyExceptionStr();
		DEBUG("modpython: " << (GetUser() ? GetUser()->GetUserName() : CString("<no user>")) << "/" << GetModName() << "/OnPrivActionMessage: can't convert parameter 'Message' to PyObject: " << sPyErr);
		Py_CLEAR(pyName);
		return CModule::OnPrivActionMessage(Message);
	}
	PyObject* pyRes = PyObject_CallMethodObjArgs(m_pyObj, pyName, pyArg_Message, nullptr);
	if (!pyRes) {
		CString sPyErr = m_pModPython->GetPyExceptionStr();
		DEBUG("modpython: " << (GetUser() ? GetUser()->GetUserName() : CString("<no user>")) << "/" << GetModName() << "/OnPrivActionMessage failed: " << sPyErr);
		Py_CLEAR(pyName);
		Py_CLEAR(pyArg_Message);
		return CModule::OnPrivActionMessage(Message);
	}
	Py_CLEAR(pyName);
	Py_CLEAR(pyArg_Message);
	CModule::EModRet result;
	if (pyRes == Py_None) {
		result = CModule::OnPrivActionMessage(Message);
	} else {
		long int x = PyLong_AsLong(pyRes);
		if (PyErr_Occurred()) {
			CString sPyErr = m_pModPython->GetPyExceptionStr();
			DEBUG("modpython: " << (GetUser() ? GetUser()->GetUserName() : CString("<no user>")) << "/" << GetModName() << "/OnPrivActionMessage was expected to return EModRet but: " << sPyErr);
			result = CModule::OnPrivActionMessage(Message);
		} else { result = (CModule::EModRet)x; }
	}
	Py_CLEAR(pyRes);
	return result;
}

CModule::EModRet CPyModule::OnChanActionMessage(CActionMessage& Message) {
	PyObject* pyName = Py_BuildValue("s", "OnChanActionMessage");
	if (!pyName) {
		CString sPyErr = m_pModPython->GetPyExceptionStr();
		DEBUG("modpython: " << (GetUser() ? GetUser()->GetUserName() : CString("<no user>")) << "/" << GetModName() << "/OnChanActionMessage: can't convert string 'OnChanActionMessage' to PyObject: " << sPyErr);
		return CModule::OnChanActionMessage(Message);
	}
	PyObject* pyArg_Message = SWIG_NewInstanceObj(const_cast<CActionMessage*>(&Message), SWIG_TypeQuery("CActionMessage*"), 0);
	if (!pyArg_Message) {
		CString sPyErr = m_pModPython->GetPyExceptionStr();
		DEBUG("modpython: " << (GetUser() ? GetUser()->GetUserName() : CString("<no user>")) << "/" << GetModName() << "/OnChanActionMessage: can't convert parameter 'Message' to PyObject: " << sPyErr);
		Py_CLEAR(pyName);
		return CModule::OnChanActionMessage(Message);
	}
	PyObject* pyRes = PyObject_CallMethodObjArgs(m_pyObj, pyName, pyArg_Message, nullptr);
	if (!pyRes) {
		CString sPyErr = m_pModPython->GetPyExceptionStr();
		DEBUG("modpython: " << (GetUser() ? GetUser()->GetUserName() : CString("<no user>")) << "/" << GetModName() << "/OnChanActionMessage failed: " << sPyErr);
		Py_CLEAR(pyName);
		Py_CLEAR(pyArg_Message);
		return CModule::OnChanActionMessage(Message);
	}
	Py_CLEAR(pyName);
	Py_CLEAR(pyArg_Message);
	CModule::EModRet result;
	if (pyRes == Py_None) {
		result = CModule::OnChanActionMessage(Message);
	} else {
		long int x = PyLong_AsLong(pyRes);
		if (PyErr_Occurred()) {
			CString sPyErr = m_pModPython->GetPyExceptionStr();
			DEBUG("modpython: " << (GetUser() ? GetUser()->GetUserName() : CString("<no user>")) << "/" << GetModName() << "/OnChanActionMessage was expected to return EModRet but: " << sPyErr);
			result = CModule::OnChanActionMessage(Message);
		} else { result = (CModule::EModRet)x; }
	}
	Py_CLEAR(pyRes);
	return result;
}

CModule::EModRet CPyModule::OnPrivTextMessage(CTextMessage& Message) {
	PyObject* pyName = Py_BuildValue("s", "OnPrivTextMessage");
	if (!pyName) {
		CString sPyErr = m_pModPython->GetPyExceptionStr();
		DEBUG("modpython: " << (GetUser() ? GetUser()->GetUserName() : CString("<no user>")) << "/" << GetModName() << "/OnPrivTextMessage: can't convert string 'OnPrivTextMessage' to PyObject: " << sPyErr);
		return CModule::OnPrivTextMessage(Message);
	}
	PyObject* pyArg_Message = SWIG_NewInstanceObj(const_cast<CTextMessage*>(&Message), SWIG_TypeQuery("CTextMessage*"), 0);
	if (!pyArg_Message) {
		CString sPyErr = m_pModPython->GetPyExceptionStr();
		DEBUG("modpython: " << (GetUser() ? GetUser()->GetUserName() : CString("<no user>")) << "/" << GetModName() << "/OnPrivTextMessage: can't convert parameter 'Message' to PyObject: " << sPyErr);
		Py_CLEAR(pyName);
		return CModule::OnPrivTextMessage(Message);
	}
	PyObject* pyRes = PyObject_CallMethodObjArgs(m_pyObj, pyName, pyArg_Message, nullptr);
	if (!pyRes) {
		CString sPyErr = m_pModPython->GetPyExceptionStr();
		DEBUG("modpython: " << (GetUser() ? GetUser()->GetUserName() : CString("<no user>")) << "/" << GetModName() << "/OnPrivTextMessage failed: " << sPyErr);
		Py_CLEAR(pyName);
		Py_CLEAR(pyArg_Message);
		return CModule::OnPrivTextMessage(Message);
	}
	Py_CLEAR(pyName);
	Py_CLEAR(pyArg_Message);
	CModule::EModRet result;
	if (pyRes == Py_None) {
		result = CModule::OnPrivTextMessage(Message);
	} else {
		long int x = PyLong_AsLong(pyRes);
		if (PyErr_Occurred()) {
			CString sPyErr = m_pModPython->GetPyExceptionStr();
			DEBUG("modpython: " << (GetUser() ? GetUser()->GetUserName() : CString("<no user>")) << "/" << GetModName() << "/OnPrivTextMessage was expected to return EModRet but: " << sPyErr);
			result = CModule::OnPrivTextMessage(Message);
		} else { result = (CModule::EModRet)x; }
	}
	Py_CLEAR(pyRes);
	return result;
}

CModule::EModRet CPyModule::OnChanTextMessage(CTextMessage& Message) {
	PyObject* pyName = Py_BuildValue("s", "OnChanTextMessage");
	if (!pyName) {
		CString sPyErr = m_pModPython->GetPyExceptionStr();
		DEBUG("modpython: " << (GetUser() ? GetUser()->GetUserName() : CString("<no user>")) << "/" << GetModName() << "/OnChanTextMessage: can't convert string 'OnChanTextMessage' to PyObject: " << sPyErr);
		return CModule::OnChanTextMessage(Message);
	}
	PyObject* pyArg_Message = SWIG_NewInstanceObj(const_cast<CTextMessage*>(&Message), SWIG_TypeQuery("CTextMessage*"), 0);
	if (!pyArg_Message) {
		CString sPyErr = m_pModPython->GetPyExceptionStr();
		DEBUG("modpython: " << (GetUser() ? GetUser()->GetUserName() : CString("<no user>")) << "/" << GetModName() << "/OnChanTextMessage: can't convert parameter 'Message' to PyObject: " << sPyErr);
		Py_CLEAR(pyName);
		return CModule::OnChanTextMessage(Message);
	}
	PyObject* pyRes = PyObject_CallMethodObjArgs(m_pyObj, pyName, pyArg_Message, nullptr);
	if (!pyRes) {
		CString sPyErr = m_pModPython->GetPyExceptionStr();
		DEBUG("modpython: " << (GetUser() ? GetUser()->GetUserName() : CString("<no user>")) << "/" << GetModName() << "/OnChanTextMessage failed: " << sPyErr);
		Py_CLEAR(pyName);
		Py_CLEAR(pyArg_Message);
		return CModule::OnChanTextMessage(Message);
	}
	Py_CLEAR(pyName);
	Py_CLEAR(pyArg_Message);
	CModule::EModRet result;
	if (pyRes == Py_None) {
		result = CModule::OnChanTextMessage(Message);
	} else {
		long int x = PyLong_AsLong(pyRes);
		if (PyErr_Occurred()) {
			CString sPyErr = m_pModPython->GetPyExceptionStr();
			DEBUG("modpython: " << (GetUser() ? GetUser()->GetUserName() : CString("<no user>")) << "/" << GetModName() << "/OnChanTextMessage was expected to return EModRet but: " << sPyErr);
			result = CModule::OnChanTextMessage(Message);
		} else { result = (CModule::EModRet)x; }
	}
	Py_CLEAR(pyRes);
	return result;
}

CModule::EModRet CPyModule::OnPrivNoticeMessage(CNoticeMessage& Message) {
	PyObject* pyName = Py_BuildValue("s", "OnPrivNoticeMessage");
	if (!pyName) {
		CString sPyErr = m_pModPython->GetPyExceptionStr();
		DEBUG("modpython: " << (GetUser() ? GetUser()->GetUserName() : CString("<no user>")) << "/" << GetModName() << "/OnPrivNoticeMessage: can't convert string 'OnPrivNoticeMessage' to PyObject: " << sPyErr);
		return CModule::OnPrivNoticeMessage(Message);
	}
	PyObject* pyArg_Message = SWIG_NewInstanceObj(const_cast<CNoticeMessage*>(&Message), SWIG_TypeQuery("CNoticeMessage*"), 0);
	if (!pyArg_Message) {
		CString sPyErr = m_pModPython->GetPyExceptionStr();
		DEBUG("modpython: " << (GetUser() ? GetUser()->GetUserName() : CString("<no user>")) << "/" << GetModName() << "/OnPrivNoticeMessage: can't convert parameter 'Message' to PyObject: " << sPyErr);
		Py_CLEAR(pyName);
		return CModule::OnPrivNoticeMessage(Message);
	}
	PyObject* pyRes = PyObject_CallMethodObjArgs(m_pyObj, pyName, pyArg_Message, nullptr);
	if (!pyRes) {
		CString sPyErr = m_pModPython->GetPyExceptionStr();
		DEBUG("modpython: " << (GetUser() ? GetUser()->GetUserName() : CString("<no user>")) << "/" << GetModName() << "/OnPrivNoticeMessage failed: " << sPyErr);
		Py_CLEAR(pyName);
		Py_CLEAR(pyArg_Message);
		return CModule::OnPrivNoticeMessage(Message);
	}
	Py_CLEAR(pyName);
	Py_CLEAR(pyArg_Message);
	CModule::EModRet result;
	if (pyRes == Py_None) {
		result = CModule::OnPrivNoticeMessage(Message);
	} else {
		long int x = PyLong_AsLong(pyRes);
		if (PyErr_Occurred()) {
			CString sPyErr = m_pModPython->GetPyExceptionStr();
			DEBUG("modpython: " << (GetUser() ? GetUser()->GetUserName() : CString("<no user>")) << "/" << GetModName() << "/OnPrivNoticeMessage was expected to return EModRet but: " << sPyErr);
			result = CModule::OnPrivNoticeMessage(Message);
		} else { result = (CModule::EModRet)x; }
	}
	Py_CLEAR(pyRes);
	return result;
}

CModule::EModRet CPyModule::OnChanNoticeMessage(CNoticeMessage& Message) {
	PyObject* pyName = Py_BuildValue("s", "OnChanNoticeMessage");
	if (!pyName) {
		CString sPyErr = m_pModPython->GetPyExceptionStr();
		DEBUG("modpython: " << (GetUser() ? GetUser()->GetUserName() : CString("<no user>")) << "/" << GetModName() << "/OnChanNoticeMessage: can't convert string 'OnChanNoticeMessage' to PyObject: " << sPyErr);
		return CModule::OnChanNoticeMessage(Message);
	}
	PyObject* pyArg_Message = SWIG_NewInstanceObj(const_cast<CNoticeMessage*>(&Message), SWIG_TypeQuery("CNoticeMessage*"), 0);
	if (!pyArg_Message) {
		CString sPyErr = m_pModPython->GetPyExceptionStr();
		DEBUG("modpython: " << (GetUser() ? GetUser()->GetUserName() : CString("<no user>")) << "/" << GetModName() << "/OnChanNoticeMessage: can't convert parameter 'Message' to PyObject: " << sPyErr);
		Py_CLEAR(pyName);
		return CModule::OnChanNoticeMessage(Message);
	}
	PyObject* pyRes = PyObject_CallMethodObjArgs(m_pyObj, pyName, pyArg_Message, nullptr);
	if (!pyRes) {
		CString sPyErr = m_pModPython->GetPyExceptionStr();
		DEBUG("modpython: " << (GetUser() ? GetUser()->GetUserName() : CString("<no user>")) << "/" << GetModName() << "/OnChanNoticeMessage failed: " << sPyErr);
		Py_CLEAR(pyName);
		Py_CLEAR(pyArg_Message);
		return CModule::OnChanNoticeMessage(Message);
	}
	Py_CLEAR(pyName);
	Py_CLEAR(pyArg_Message);
	CModule::EModRet result;
	if (pyRes == Py_None) {
		result = CModule::OnChanNoticeMessage(Message);
	} else {
		long int x = PyLong_AsLong(pyRes);
		if (PyErr_Occurred()) {
			CString sPyErr = m_pModPython->GetPyExceptionStr();
			DEBUG("modpython: " << (GetUser() ? GetUser()->GetUserName() : CString("<no user>")) << "/" << GetModName() << "/OnChanNoticeMessage was expected to return EModRet but: " << sPyErr);
			result = CModule::OnChanNoticeMessage(Message);
		} else { result = (CModule::EModRet)x; }
	}
	Py_CLEAR(pyRes);
	return result;
}

CModule::EModRet CPyModule::OnTopicMessage(CTopicMessage& Message) {
	PyObject* pyName = Py_BuildValue("s", "OnTopicMessage");
	if (!pyName) {
		CString sPyErr = m_pModPython->GetPyExceptionStr();
		DEBUG("modpython: " << (GetUser() ? GetUser()->GetUserName() : CString("<no user>")) << "/" << GetModName() << "/OnTopicMessage: can't convert string 'OnTopicMessage' to PyObject: " << sPyErr);
		return CModule::OnTopicMessage(Message);
	}
	PyObject* pyArg_Message = SWIG_NewInstanceObj(const_cast<CTopicMessage*>(&Message), SWIG_TypeQuery("CTopicMessage*"), 0);
	if (!pyArg_Message) {
		CString sPyErr = m_pModPython->GetPyExceptionStr();
		DEBUG("modpython: " << (GetUser() ? GetUser()->GetUserName() : CString("<no user>")) << "/" << GetModName() << "/OnTopicMessage: can't convert parameter 'Message' to PyObject: " << sPyErr);
		Py_CLEAR(pyName);
		return CModule::OnTopicMessage(Message);
	}
	PyObject* pyRes = PyObject_CallMethodObjArgs(m_pyObj, pyName, pyArg_Message, nullptr);
	if (!pyRes) {
		CString sPyErr = m_pModPython->GetPyExceptionStr();
		DEBUG("modpython: " << (GetUser() ? GetUser()->GetUserName() : CString("<no user>")) << "/" << GetModName() << "/OnTopicMessage failed: " << sPyErr);
		Py_CLEAR(pyName);
		Py_CLEAR(pyArg_Message);
		return CModule::OnTopicMessage(Message);
	}
	Py_CLEAR(pyName);
	Py_CLEAR(pyArg_Message);
	CModule::EModRet result;
	if (pyRes == Py_None) {
		result = CModule::OnTopicMessage(Message);
	} else {
		long int x = PyLong_AsLong(pyRes);
		if (PyErr_Occurred()) {
			CString sPyErr = m_pModPython->GetPyExceptionStr();
			DEBUG("modpython: " << (GetUser() ? GetUser()->GetUserName() : CString("<no user>")) << "/" << GetModName() << "/OnTopicMessage was expected to return EModRet but: " << sPyErr);
			result = CModule::OnTopicMessage(Message);
		} else { result = (CModule::EModRet)x; }
	}
	Py_CLEAR(pyRes);
	return result;
}

CModule::EModRet CPyModule::OnSendToClientMessage(CMessage& Message) {
	PyObject* pyName = Py_BuildValue("s", "OnSendToClientMessage");
	if (!pyName) {
		CString sPyErr = m_pModPython->GetPyExceptionStr();
		DEBUG("modpython: " << (GetUser() ? GetUser()->GetUserName() : CString("<no user>")) << "/" << GetModName() << "/OnSendToClientMessage: can't convert string 'OnSendToClientMessage' to PyObject: " << sPyErr);
		return CModule::OnSendToClientMessage(Message);
	}
	PyObject* pyArg_Message = SWIG_NewInstanceObj(const_cast<CMessage*>(&Message), SWIG_TypeQuery("CMessage*"), 0);
	if (!pyArg_Message) {
		CString sPyErr = m_pModPython->GetPyExceptionStr();
		DEBUG("modpython: " << (GetUser() ? GetUser()->GetUserName() : CString("<no user>")) << "/" << GetModName() << "/OnSendToClientMessage: can't convert parameter 'Message' to PyObject: " << sPyErr);
		Py_CLEAR(pyName);
		return CModule::OnSendToClientMessage(Message);
	}
	PyObject* pyRes = PyObject_CallMethodObjArgs(m_pyObj, pyName, pyArg_Message, nullptr);
	if (!pyRes) {
		CString sPyErr = m_pModPython->GetPyExceptionStr();
		DEBUG("modpython: " << (GetUser() ? GetUser()->GetUserName() : CString("<no user>")) << "/" << GetModName() << "/OnSendToClientMessage failed: " << sPyErr);
		Py_CLEAR(pyName);
		Py_CLEAR(pyArg_Message);
		return CModule::OnSendToClientMessage(Message);
	}
	Py_CLEAR(pyName);
	Py_CLEAR(pyArg_Message);
	CModule::EModRet result;
	if (pyRes == Py_None) {
		result = CModule::OnSendToClientMessage(Message);
	} else {
		long int x = PyLong_AsLong(pyRes);
		if (PyErr_Occurred()) {
			CString sPyErr = m_pModPython->GetPyExceptionStr();
			DEBUG("modpython: " << (GetUser() ? GetUser()->GetUserName() : CString("<no user>")) << "/" << GetModName() << "/OnSendToClientMessage was expected to return EModRet but: " << sPyErr);
			result = CModule::OnSendToClientMessage(Message);
		} else { result = (CModule::EModRet)x; }
	}
	Py_CLEAR(pyRes);
	return result;
}

CModule::EModRet CPyModule::OnSendToIRCMessage(CMessage& Message) {
	PyObject* pyName = Py_BuildValue("s", "OnSendToIRCMessage");
	if (!pyName) {
		CString sPyErr = m_pModPython->GetPyExceptionStr();
		DEBUG("modpython: " << (GetUser() ? GetUser()->GetUserName() : CString("<no user>")) << "/" << GetModName() << "/OnSendToIRCMessage: can't convert string 'OnSendToIRCMessage' to PyObject: " << sPyErr);
		return CModule::OnSendToIRCMessage(Message);
	}
	PyObject* pyArg_Message = SWIG_NewInstanceObj(const_cast<CMessage*>(&Message), SWIG_TypeQuery("CMessage*"), 0);
	if (!pyArg_Message) {
		CString sPyErr = m_pModPython->GetPyExceptionStr();
		DEBUG("modpython: " << (GetUser() ? GetUser()->GetUserName() : CString("<no user>")) << "/" << GetModName() << "/OnSendToIRCMessage: can't convert parameter 'Message' to PyObject: " << sPyErr);
		Py_CLEAR(pyName);
		return CModule::OnSendToIRCMessage(Message);
	}
	PyObject* pyRes = PyObject_CallMethodObjArgs(m_pyObj, pyName, pyArg_Message, nullptr);
	if (!pyRes) {
		CString sPyErr = m_pModPython->GetPyExceptionStr();
		DEBUG("modpython: " << (GetUser() ? GetUser()->GetUserName() : CString("<no user>")) << "/" << GetModName() << "/OnSendToIRCMessage failed: " << sPyErr);
		Py_CLEAR(pyName);
		Py_CLEAR(pyArg_Message);
		return CModule::OnSendToIRCMessage(Message);
	}
	Py_CLEAR(pyName);
	Py_CLEAR(pyArg_Message);
	CModule::EModRet result;
	if (pyRes == Py_None) {
		result = CModule::OnSendToIRCMessage(Message);
	} else {
		long int x = PyLong_AsLong(pyRes);
		if (PyErr_Occurred()) {
			CString sPyErr = m_pModPython->GetPyExceptionStr();
			DEBUG("modpython: " << (GetUser() ? GetUser()->GetUserName() : CString("<no user>")) << "/" << GetModName() << "/OnSendToIRCMessage was expected to return EModRet but: " << sPyErr);
			result = CModule::OnSendToIRCMessage(Message);
		} else { result = (CModule::EModRet)x; }
	}
	Py_CLEAR(pyRes);
	return result;
}

CModule::EModRet CPyModule::OnAddUser(CUser& User, CString& sErrorRet) {
	PyObject* pyName = Py_BuildValue("s", "OnAddUser");
	if (!pyName) {
		CString sPyErr = m_pModPython->GetPyExceptionStr();
		DEBUG("modpython: " << (GetUser() ? GetUser()->GetUserName() : CString("<no user>")) << "/" << GetModName() << "/OnAddUser: can't convert string 'OnAddUser' to PyObject: " << sPyErr);
		return CModule::OnAddUser(User, sErrorRet);
	}
	PyObject* pyArg_User = SWIG_NewInstanceObj(const_cast<CUser*>(&User), SWIG_TypeQuery("CUser*"), 0);
	if (!pyArg_User) {
		CString sPyErr = m_pModPython->GetPyExceptionStr();
		DEBUG("modpython: " << (GetUser() ? GetUser()->GetUserName() : CString("<no user>")) << "/" << GetModName() << "/OnAddUser: can't convert parameter 'User' to PyObject: " << sPyErr);
		Py_CLEAR(pyName);
		return CModule::OnAddUser(User, sErrorRet);
	}
	PyObject* pyArg_sErrorRet = CPyRetString::wrap(sErrorRet);
	if (!pyArg_sErrorRet) {
		CString sPyErr = m_pModPython->GetPyExceptionStr();
		DEBUG("modpython: " << (GetUser() ? GetUser()->GetUserName() : CString("<no user>")) << "/" << GetModName() << "/OnAddUser: can't convert parameter 'sErrorRet' to PyObject: " << sPyErr);
		Py_CLEAR(pyName);
		Py_CLEAR(pyArg_User);
		return CModule::OnAddUser(User, sErrorRet);
	}
	PyObject* pyRes = PyObject_CallMethodObjArgs(m_pyObj, pyName, pyArg_User, pyArg_sErrorRet, nullptr);
	if (!pyRes) {
		CString sPyErr = m_pModPython->GetPyExceptionStr();
		DEBUG("modpython: " << (GetUser() ? GetUser()->GetUserName() : CString("<no user>")) << "/" << GetModName() << "/OnAddUser failed: " << sPyErr);
		Py_CLEAR(pyName);
		Py_CLEAR(pyArg_User);
		Py_CLEAR(pyArg_sErrorRet);
		return CModule::OnAddUser(User, sErrorRet);
	}
	Py_CLEAR(pyName);
	Py_CLEAR(pyArg_User);
	Py_CLEAR(pyArg_sErrorRet);
	CModule::EModRet result;
	if (pyRes == Py_None) {
		result = CModule::OnAddUser(User, sErrorRet);
	} else {
		long int x = PyLong_AsLong(pyRes);
		if (PyErr_Occurred()) {
			CString sPyErr = m_pModPython->GetPyExceptionStr();
			DEBUG("modpython: " << (GetUser() ? GetUser()->GetUserName() : CString("<no user>")) << "/" << GetModName() << "/OnAddUser was expected to return EModRet but: " << sPyErr);
			result = CModule::OnAddUser(User, sErrorRet);
		} else { result = (CModule::EModRet)x; }
	}
	Py_CLEAR(pyRes);
	return result;
}

CModule::EModRet CPyModule::OnDeleteUser(CUser& User) {
	PyObject* pyName = Py_BuildValue("s", "OnDeleteUser");
	if (!pyName) {
		CString sPyErr = m_pModPython->GetPyExceptionStr();
		DEBUG("modpython: " << (GetUser() ? GetUser()->GetUserName() : CString("<no user>")) << "/" << GetModName() << "/OnDeleteUser: can't convert string 'OnDeleteUser' to PyObject: " << sPyErr);
		return CModule::OnDeleteUser(User);
	}
	PyObject* pyArg_User = SWIG_NewInstanceObj(const_cast<CUser*>(&User), SWIG_TypeQuery("CUser*"), 0);
	if (!pyArg_User) {
		CString sPyErr = m_pModPython->GetPyExceptionStr();
		DEBUG("modpython: " << (GetUser() ? GetUser()->GetUserName() : CString("<no user>")) << "/" << GetModName() << "/OnDeleteUser: can't convert parameter 'User' to PyObject: " << sPyErr);
		Py_CLEAR(pyName);
		return CModule::OnDeleteUser(User);
	}
	PyObject* pyRes = PyObject_CallMethodObjArgs(m_pyObj, pyName, pyArg_User, nullptr);
	if (!pyRes) {
		CString sPyErr = m_pModPython->GetPyExceptionStr();
		DEBUG("modpython: " << (GetUser() ? GetUser()->GetUserName() : CString("<no user>")) << "/" << GetModName() << "/OnDeleteUser failed: " << sPyErr);
		Py_CLEAR(pyName);
		Py_CLEAR(pyArg_User);
		return CModule::OnDeleteUser(User);
	}
	Py_CLEAR(pyName);
	Py_CLEAR(pyArg_User);
	CModule::EModRet result;
	if (pyRes == Py_None) {
		result = CModule::OnDeleteUser(User);
	} else {
		long int x = PyLong_AsLong(pyRes);
		if (PyErr_Occurred()) {
			CString sPyErr = m_pModPython->GetPyExceptionStr();
			DEBUG("modpython: " << (GetUser() ? GetUser()->GetUserName() : CString("<no user>")) << "/" << GetModName() << "/OnDeleteUser was expected to return EModRet but: " << sPyErr);
			result = CModule::OnDeleteUser(User);
		} else { result = (CModule::EModRet)x; }
	}
	Py_CLEAR(pyRes);
	return result;
}

void CPyModule::OnClientConnect(CZNCSock* pSock, const CString& sHost, unsigned short uPort) {
	PyObject* pyName = Py_BuildValue("s", "OnClientConnect");
	if (!pyName) {
		CString sPyErr = m_pModPython->GetPyExceptionStr();
		DEBUG("modpython: " << (GetUser() ? GetUser()->GetUserName() : CString("<no user>")) << "/" << GetModName() << "/OnClientConnect: can't convert string 'OnClientConnect' to PyObject: " << sPyErr);
		return CModule::OnClientConnect(pSock, sHost, uPort);
	}
	PyObject* pyArg_pSock = SWIG_NewInstanceObj(const_cast<CZNCSock*>(pSock), SWIG_TypeQuery("CZNCSock*"), 0);
	if (!pyArg_pSock) {
		CString sPyErr = m_pModPython->GetPyExceptionStr();
		DEBUG("modpython: " << (GetUser() ? GetUser()->GetUserName() : CString("<no user>")) << "/" << GetModName() << "/OnClientConnect: can't convert parameter 'pSock' to PyObject: " << sPyErr);
		Py_CLEAR(pyName);
		return CModule::OnClientConnect(pSock, sHost, uPort);
	}
	PyObject* pyArg_sHost = Py_BuildValue("s", sHost.c_str());
	if (!pyArg_sHost) {
		CString sPyErr = m_pModPython->GetPyExceptionStr();
		DEBUG("modpython: " << (GetUser() ? GetUser()->GetUserName() : CString("<no user>")) << "/" << GetModName() << "/OnClientConnect: can't convert parameter 'sHost' to PyObject: " << sPyErr);
		Py_CLEAR(pyName);
		Py_CLEAR(pyArg_pSock);
		return CModule::OnClientConnect(pSock, sHost, uPort);
	}
	PyObject* pyArg_uPort = Py_BuildValue("H", uPort);
	if (!pyArg_uPort) {
		CString sPyErr = m_pModPython->GetPyExceptionStr();
		DEBUG("modpython: " << (GetUser() ? GetUser()->GetUserName() : CString("<no user>")) << "/" << GetModName() << "/OnClientConnect: can't convert parameter 'uPort' to PyObject: " << sPyErr);
		Py_CLEAR(pyName);
		Py_CLEAR(pyArg_pSock);
		Py_CLEAR(pyArg_sHost);
		return CModule::OnClientConnect(pSock, sHost, uPort);
	}
	PyObject* pyRes = PyObject_CallMethodObjArgs(m_pyObj, pyName, pyArg_pSock, pyArg_sHost, pyArg_uPort, nullptr);
	if (!pyRes) {
		CString sPyErr = m_pModPython->GetPyExceptionStr();
		DEBUG("modpython: " << (GetUser() ? GetUser()->GetUserName() : CString("<no user>")) << "/" << GetModName() << "/OnClientConnect failed: " << sPyErr);
		Py_CLEAR(pyName);
		Py_CLEAR(pyArg_pSock);
		Py_CLEAR(pyArg_sHost);
		Py_CLEAR(pyArg_uPort);
		return CModule::OnClientConnect(pSock, sHost, uPort);
	}
	Py_CLEAR(pyName);
	Py_CLEAR(pyArg_pSock);
	Py_CLEAR(pyArg_sHost);
	Py_CLEAR(pyArg_uPort);
	Py_CLEAR(pyRes);
}

void CPyModule::OnFailedLogin(const CString& sUsername, const CString& sRemoteIP) {
	PyObject* pyName = Py_BuildValue("s", "OnFailedLogin");
	if (!pyName) {
		CString sPyErr = m_pModPython->GetPyExceptionStr();
		DEBUG("modpython: " << (GetUser() ? GetUser()->GetUserName() : CString("<no user>")) << "/" << GetModName() << "/OnFailedLogin: can't convert string 'OnFailedLogin' to PyObject: " << sPyErr);
		return CModule::OnFailedLogin(sUsername, sRemoteIP);
	}
	PyObject* pyArg_sUsername = Py_BuildValue("s", sUsername.c_str());
	if (!pyArg_sUsername) {
		CString sPyErr = m_pModPython->GetPyExceptionStr();
		DEBUG("modpython: " << (GetUser() ? GetUser()->GetUserName() : CString("<no user>")) << "/" << GetModName() << "/OnFailedLogin: can't convert parameter 'sUsername' to PyObject: " << sPyErr);
		Py_CLEAR(pyName);
		return CModule::OnFailedLogin(sUsername, sRemoteIP);
	}
	PyObject* pyArg_sRemoteIP = Py_BuildValue("s", sRemoteIP.c_str());
	if (!pyArg_sRemoteIP) {
		CString sPyErr = m_pModPython->GetPyExceptionStr();
		DEBUG("modpython: " << (GetUser() ? GetUser()->GetUserName() : CString("<no user>")) << "/" << GetModName() << "/OnFailedLogin: can't convert parameter 'sRemoteIP' to PyObject: " << sPyErr);
		Py_CLEAR(pyName);
		Py_CLEAR(pyArg_sUsername);
		return CModule::OnFailedLogin(sUsername, sRemoteIP);
	}
	PyObject* pyRes = PyObject_CallMethodObjArgs(m_pyObj, pyName, pyArg_sUsername, pyArg_sRemoteIP, nullptr);
	if (!pyRes) {
		CString sPyErr = m_pModPython->GetPyExceptionStr();
		DEBUG("modpython: " << (GetUser() ? GetUser()->GetUserName() : CString("<no user>")) << "/" << GetModName() << "/OnFailedLogin failed: " << sPyErr);
		Py_CLEAR(pyName);
		Py_CLEAR(pyArg_sUsername);
		Py_CLEAR(pyArg_sRemoteIP);
		return CModule::OnFailedLogin(sUsername, sRemoteIP);
	}
	Py_CLEAR(pyName);
	Py_CLEAR(pyArg_sUsername);
	Py_CLEAR(pyArg_sRemoteIP);
	Py_CLEAR(pyRes);
}

CModule::EModRet CPyModule::OnUnknownUserRaw(CClient* pClient, CString& sLine) {
	PyObject* pyName = Py_BuildValue("s", "OnUnknownUserRaw");
	if (!pyName) {
		CString sPyErr = m_pModPython->GetPyExceptionStr();
		DEBUG("modpython: " << (GetUser() ? GetUser()->GetUserName() : CString("<no user>")) << "/" << GetModName() << "/OnUnknownUserRaw: can't convert string 'OnUnknownUserRaw' to PyObject: " << sPyErr);
		return CModule::OnUnknownUserRaw(pClient, sLine);
	}
	PyObject* pyArg_pClient = SWIG_NewInstanceObj(const_cast<CClient*>(pClient), SWIG_TypeQuery("CClient*"), 0);
	if (!pyArg_pClient) {
		CString sPyErr = m_pModPython->GetPyExceptionStr();
		DEBUG("modpython: " << (GetUser() ? GetUser()->GetUserName() : CString("<no user>")) << "/" << GetModName() << "/OnUnknownUserRaw: can't convert parameter 'pClient' to PyObject: " << sPyErr);
		Py_CLEAR(pyName);
		return CModule::OnUnknownUserRaw(pClient, sLine);
	}
	PyObject* pyArg_sLine = CPyRetString::wrap(sLine);
	if (!pyArg_sLine) {
		CString sPyErr = m_pModPython->GetPyExceptionStr();
		DEBUG("modpython: " << (GetUser() ? GetUser()->GetUserName() : CString("<no user>")) << "/" << GetModName() << "/OnUnknownUserRaw: can't convert parameter 'sLine' to PyObject: " << sPyErr);
		Py_CLEAR(pyName);
		Py_CLEAR(pyArg_pClient);
		return CModule::OnUnknownUserRaw(pClient, sLine);
	}
	PyObject* pyRes = PyObject_CallMethodObjArgs(m_pyObj, pyName, pyArg_pClient, pyArg_sLine, nullptr);
	if (!pyRes) {
		CString sPyErr = m_pModPython->GetPyExceptionStr();
		DEBUG("modpython: " << (GetUser() ? GetUser()->GetUserName() : CString("<no user>")) << "/" << GetModName() << "/OnUnknownUserRaw failed: " << sPyErr);
		Py_CLEAR(pyName);
		Py_CLEAR(pyArg_pClient);
		Py_CLEAR(pyArg_sLine);
		return CModule::OnUnknownUserRaw(pClient, sLine);
	}
	Py_CLEAR(pyName);
	Py_CLEAR(pyArg_pClient);
	Py_CLEAR(pyArg_sLine);
	CModule::EModRet result;
	if (pyRes == Py_None) {
		result = CModule::OnUnknownUserRaw(pClient, sLine);
	} else {
		long int x = PyLong_AsLong(pyRes);
		if (PyErr_Occurred()) {
			CString sPyErr = m_pModPython->GetPyExceptionStr();
			DEBUG("modpython: " << (GetUser() ? GetUser()->GetUserName() : CString("<no user>")) << "/" << GetModName() << "/OnUnknownUserRaw was expected to return EModRet but: " << sPyErr);
			result = CModule::OnUnknownUserRaw(pClient, sLine);
		} else { result = (CModule::EModRet)x; }
	}
	Py_CLEAR(pyRes);
	return result;
}

CModule::EModRet CPyModule::OnUnknownUserRawMessage(CMessage& Message) {
	PyObject* pyName = Py_BuildValue("s", "OnUnknownUserRawMessage");
	if (!pyName) {
		CString sPyErr = m_pModPython->GetPyExceptionStr();
		DEBUG("modpython: " << (GetUser() ? GetUser()->GetUserName() : CString("<no user>")) << "/" << GetModName() << "/OnUnknownUserRawMessage: can't convert string 'OnUnknownUserRawMessage' to PyObject: " << sPyErr);
		return CModule::OnUnknownUserRawMessage(Message);
	}
	PyObject* pyArg_Message = SWIG_NewInstanceObj(const_cast<CMessage*>(&Message), SWIG_TypeQuery("CMessage*"), 0);
	if (!pyArg_Message) {
		CString sPyErr = m_pModPython->GetPyExceptionStr();
		DEBUG("modpython: " << (GetUser() ? GetUser()->GetUserName() : CString("<no user>")) << "/" << GetModName() << "/OnUnknownUserRawMessage: can't convert parameter 'Message' to PyObject: " << sPyErr);
		Py_CLEAR(pyName);
		return CModule::OnUnknownUserRawMessage(Message);
	}
	PyObject* pyRes = PyObject_CallMethodObjArgs(m_pyObj, pyName, pyArg_Message, nullptr);
	if (!pyRes) {
		CString sPyErr = m_pModPython->GetPyExceptionStr();
		DEBUG("modpython: " << (GetUser() ? GetUser()->GetUserName() : CString("<no user>")) << "/" << GetModName() << "/OnUnknownUserRawMessage failed: " << sPyErr);
		Py_CLEAR(pyName);
		Py_CLEAR(pyArg_Message);
		return CModule::OnUnknownUserRawMessage(Message);
	}
	Py_CLEAR(pyName);
	Py_CLEAR(pyArg_Message);
	CModule::EModRet result;
	if (pyRes == Py_None) {
		result = CModule::OnUnknownUserRawMessage(Message);
	} else {
		long int x = PyLong_AsLong(pyRes);
		if (PyErr_Occurred()) {
			CString sPyErr = m_pModPython->GetPyExceptionStr();
			DEBUG("modpython: " << (GetUser() ? GetUser()->GetUserName() : CString("<no user>")) << "/" << GetModName() << "/OnUnknownUserRawMessage was expected to return EModRet but: " << sPyErr);
			result = CModule::OnUnknownUserRawMessage(Message);
		} else { result = (CModule::EModRet)x; }
	}
	Py_CLEAR(pyRes);
	return result;
}

bool CPyModule::IsClientCapSupported(CClient* pClient, const CString& sCap, bool bState) {
	PyObject* pyName = Py_BuildValue("s", "IsClientCapSupported");
	if (!pyName) {
		CString sPyErr = m_pModPython->GetPyExceptionStr();
		DEBUG("modpython: " << (GetUser() ? GetUser()->GetUserName() : CString("<no user>")) << "/" << GetModName() << "/IsClientCapSupported: can't convert string 'IsClientCapSupported' to PyObject: " << sPyErr);
		return CModule::IsClientCapSupported(pClient, sCap, bState);
	}
	PyObject* pyArg_pClient = SWIG_NewInstanceObj(const_cast<CClient*>(pClient), SWIG_TypeQuery("CClient*"), 0);
	if (!pyArg_pClient) {
		CString sPyErr = m_pModPython->GetPyExceptionStr();
		DEBUG("modpython: " << (GetUser() ? GetUser()->GetUserName() : CString("<no user>")) << "/" << GetModName() << "/IsClientCapSupported: can't convert parameter 'pClient' to PyObject: " << sPyErr);
		Py_CLEAR(pyName);
		return CModule::IsClientCapSupported(pClient, sCap, bState);
	}
	PyObject* pyArg_sCap = Py_BuildValue("s", sCap.c_str());
	if (!pyArg_sCap) {
		CString sPyErr = m_pModPython->GetPyExceptionStr();
		DEBUG("modpython: " << (GetUser() ? GetUser()->GetUserName() : CString("<no user>")) << "/" << GetModName() << "/IsClientCapSupported: can't convert parameter 'sCap' to PyObject: " << sPyErr);
		Py_CLEAR(pyName);
		Py_CLEAR(pyArg_pClient);
		return CModule::IsClientCapSupported(pClient, sCap, bState);
	}
	PyObject* pyArg_bState = Py_BuildValue("l", (long int)bState);
	if (!pyArg_bState) {
		CString sPyErr = m_pModPython->GetPyExceptionStr();
		DEBUG("modpython: " << (GetUser() ? GetUser()->GetUserName() : CString("<no user>")) << "/" << GetModName() << "/IsClientCapSupported: can't convert parameter 'bState' to PyObject: " << sPyErr);
		Py_CLEAR(pyName);
		Py_CLEAR(pyArg_pClient);
		Py_CLEAR(pyArg_sCap);
		return CModule::IsClientCapSupported(pClient, sCap, bState);
	}
	PyObject* pyRes = PyObject_CallMethodObjArgs(m_pyObj, pyName, pyArg_pClient, pyArg_sCap, pyArg_bState, nullptr);
	if (!pyRes) {
		CString sPyErr = m_pModPython->GetPyExceptionStr();
		DEBUG("modpython: " << (GetUser() ? GetUser()->GetUserName() : CString("<no user>")) << "/" << GetModName() << "/IsClientCapSupported failed: " << sPyErr);
		Py_CLEAR(pyName);
		Py_CLEAR(pyArg_pClient);
		Py_CLEAR(pyArg_sCap);
		Py_CLEAR(pyArg_bState);
		return CModule::IsClientCapSupported(pClient, sCap, bState);
	}
	Py_CLEAR(pyName);
	Py_CLEAR(pyArg_pClient);
	Py_CLEAR(pyArg_sCap);
	Py_CLEAR(pyArg_bState);
	bool result;
	if (pyRes == Py_None) {
		result = CModule::IsClientCapSupported(pClient, sCap, bState);
	} else {
		int x = PyObject_IsTrue(pyRes);
		if (-1 == x) {
			CString sPyErr = m_pModPython->GetPyExceptionStr();
			DEBUG("modpython: " << (GetUser() ? GetUser()->GetUserName() : CString("<no user>")) << "/" << GetModName() << "/IsClientCapSupported was expected to return EModRet but: " << sPyErr);
			result = CModule::IsClientCapSupported(pClient, sCap, bState);
		} else result = x ? true : false;
	}
	Py_CLEAR(pyRes);
	return result;
}

void CPyModule::OnClientCapRequest(CClient* pClient, const CString& sCap, bool bState) {
	PyObject* pyName = Py_BuildValue("s", "OnClientCapRequest");
	if (!pyName) {
		CString sPyErr = m_pModPython->GetPyExceptionStr();
		DEBUG("modpython: " << (GetUser() ? GetUser()->GetUserName() : CString("<no user>")) << "/" << GetModName() << "/OnClientCapRequest: can't convert string 'OnClientCapRequest' to PyObject: " << sPyErr);
		return CModule::OnClientCapRequest(pClient, sCap, bState);
	}
	PyObject* pyArg_pClient = SWIG_NewInstanceObj(const_cast<CClient*>(pClient), SWIG_TypeQuery("CClient*"), 0);
	if (!pyArg_pClient) {
		CString sPyErr = m_pModPython->GetPyExceptionStr();
		DEBUG("modpython: " << (GetUser() ? GetUser()->GetUserName() : CString("<no user>")) << "/" << GetModName() << "/OnClientCapRequest: can't convert parameter 'pClient' to PyObject: " << sPyErr);
		Py_CLEAR(pyName);
		return CModule::OnClientCapRequest(pClient, sCap, bState);
	}
	PyObject* pyArg_sCap = Py_BuildValue("s", sCap.c_str());
	if (!pyArg_sCap) {
		CString sPyErr = m_pModPython->GetPyExceptionStr();
		DEBUG("modpython: " << (GetUser() ? GetUser()->GetUserName() : CString("<no user>")) << "/" << GetModName() << "/OnClientCapRequest: can't convert parameter 'sCap' to PyObject: " << sPyErr);
		Py_CLEAR(pyName);
		Py_CLEAR(pyArg_pClient);
		return CModule::OnClientCapRequest(pClient, sCap, bState);
	}
	PyObject* pyArg_bState = Py_BuildValue("l", (long int)bState);
	if (!pyArg_bState) {
		CString sPyErr = m_pModPython->GetPyExceptionStr();
		DEBUG("modpython: " << (GetUser() ? GetUser()->GetUserName() : CString("<no user>")) << "/" << GetModName() << "/OnClientCapRequest: can't convert parameter 'bState' to PyObject: " << sPyErr);
		Py_CLEAR(pyName);
		Py_CLEAR(pyArg_pClient);
		Py_CLEAR(pyArg_sCap);
		return CModule::OnClientCapRequest(pClient, sCap, bState);
	}
	PyObject* pyRes = PyObject_CallMethodObjArgs(m_pyObj, pyName, pyArg_pClient, pyArg_sCap, pyArg_bState, nullptr);
	if (!pyRes) {
		CString sPyErr = m_pModPython->GetPyExceptionStr();
		DEBUG("modpython: " << (GetUser() ? GetUser()->GetUserName() : CString("<no user>")) << "/" << GetModName() << "/OnClientCapRequest failed: " << sPyErr);
		Py_CLEAR(pyName);
		Py_CLEAR(pyArg_pClient);
		Py_CLEAR(pyArg_sCap);
		Py_CLEAR(pyArg_bState);
		return CModule::OnClientCapRequest(pClient, sCap, bState);
	}
	Py_CLEAR(pyName);
	Py_CLEAR(pyArg_pClient);
	Py_CLEAR(pyArg_sCap);
	Py_CLEAR(pyArg_bState);
	Py_CLEAR(pyRes);
}

CModule::EModRet CPyModule::OnModuleLoading(const CString& sModName, const CString& sArgs, CModInfo::EModuleType eType, bool& bSuccess, CString& sRetMsg) {
	PyObject* pyName = Py_BuildValue("s", "OnModuleLoading");
	if (!pyName) {
		CString sPyErr = m_pModPython->GetPyExceptionStr();
		DEBUG("modpython: " << (GetUser() ? GetUser()->GetUserName() : CString("<no user>")) << "/" << GetModName() << "/OnModuleLoading: can't convert string 'OnModuleLoading' to PyObject: " << sPyErr);
		return CModule::OnModuleLoading(sModName, sArgs, eType, bSuccess, sRetMsg);
	}
	PyObject* pyArg_sModName = Py_BuildValue("s", sModName.c_str());
	if (!pyArg_sModName) {
		CString sPyErr = m_pModPython->GetPyExceptionStr();
		DEBUG("modpython: " << (GetUser() ? GetUser()->GetUserName() : CString("<no user>")) << "/" << GetModName() << "/OnModuleLoading: can't convert parameter 'sModName' to PyObject: " << sPyErr);
		Py_CLEAR(pyName);
		return CModule::OnModuleLoading(sModName, sArgs, eType, bSuccess, sRetMsg);
	}
	PyObject* pyArg_sArgs = Py_BuildValue("s", sArgs.c_str());
	if (!pyArg_sArgs) {
		CString sPyErr = m_pModPython->GetPyExceptionStr();
		DEBUG("modpython: " << (GetUser() ? GetUser()->GetUserName() : CString("<no user>")) << "/" << GetModName() << "/OnModuleLoading: can't convert parameter 'sArgs' to PyObject: " << sPyErr);
		Py_CLEAR(pyName);
		Py_CLEAR(pyArg_sModName);
		return CModule::OnModuleLoading(sModName, sArgs, eType, bSuccess, sRetMsg);
	}
	PyObject* pyArg_eType = Py_BuildValue("i", (int)eType);
	if (!pyArg_eType) {
		CString sPyErr = m_pModPython->GetPyExceptionStr();
		DEBUG("modpython: " << (GetUser() ? GetUser()->GetUserName() : CString("<no user>")) << "/" << GetModName() << "/OnModuleLoading: can't convert parameter 'eType' to PyObject: " << sPyErr);
		Py_CLEAR(pyName);
		Py_CLEAR(pyArg_sModName);
		Py_CLEAR(pyArg_sArgs);
		return CModule::OnModuleLoading(sModName, sArgs, eType, bSuccess, sRetMsg);
	}
	PyObject* pyArg_bSuccess = CPyRetBool::wrap(bSuccess);
	if (!pyArg_bSuccess) {
		CString sPyErr = m_pModPython->GetPyExceptionStr();
		DEBUG("modpython: " << (GetUser() ? GetUser()->GetUserName() : CString("<no user>")) << "/" << GetModName() << "/OnModuleLoading: can't convert parameter 'bSuccess' to PyObject: " << sPyErr);
		Py_CLEAR(pyName);
		Py_CLEAR(pyArg_sModName);
		Py_CLEAR(pyArg_sArgs);
		Py_CLEAR(pyArg_eType);
		return CModule::OnModuleLoading(sModName, sArgs, eType, bSuccess, sRetMsg);
	}
	PyObject* pyArg_sRetMsg = CPyRetString::wrap(sRetMsg);
	if (!pyArg_sRetMsg) {
		CString sPyErr = m_pModPython->GetPyExceptionStr();
		DEBUG("modpython: " << (GetUser() ? GetUser()->GetUserName() : CString("<no user>")) << "/" << GetModName() << "/OnModuleLoading: can't convert parameter 'sRetMsg' to PyObject: " << sPyErr);
		Py_CLEAR(pyName);
		Py_CLEAR(pyArg_sModName);
		Py_CLEAR(pyArg_sArgs);
		Py_CLEAR(pyArg_eType);
		Py_CLEAR(pyArg_bSuccess);
		return CModule::OnModuleLoading(sModName, sArgs, eType, bSuccess, sRetMsg);
	}
	PyObject* pyRes = PyObject_CallMethodObjArgs(m_pyObj, pyName, pyArg_sModName, pyArg_sArgs, pyArg_eType, pyArg_bSuccess, pyArg_sRetMsg, nullptr);
	if (!pyRes) {
		CString sPyErr = m_pModPython->GetPyExceptionStr();
		DEBUG("modpython: " << (GetUser() ? GetUser()->GetUserName() : CString("<no user>")) << "/" << GetModName() << "/OnModuleLoading failed: " << sPyErr);
		Py_CLEAR(pyName);
		Py_CLEAR(pyArg_sModName);
		Py_CLEAR(pyArg_sArgs);
		Py_CLEAR(pyArg_eType);
		Py_CLEAR(pyArg_bSuccess);
		Py_CLEAR(pyArg_sRetMsg);
		return CModule::OnModuleLoading(sModName, sArgs, eType, bSuccess, sRetMsg);
	}
	Py_CLEAR(pyName);
	Py_CLEAR(pyArg_sModName);
	Py_CLEAR(pyArg_sArgs);
	Py_CLEAR(pyArg_eType);
	Py_CLEAR(pyArg_bSuccess);
	Py_CLEAR(pyArg_sRetMsg);
	CModule::EModRet result;
	if (pyRes == Py_None) {
		result = CModule::OnModuleLoading(sModName, sArgs, eType, bSuccess, sRetMsg);
	} else {
		long int x = PyLong_AsLong(pyRes);
		if (PyErr_Occurred()) {
			CString sPyErr = m_pModPython->GetPyExceptionStr();
			DEBUG("modpython: " << (GetUser() ? GetUser()->GetUserName() : CString("<no user>")) << "/" << GetModName() << "/OnModuleLoading was expected to return EModRet but: " << sPyErr);
			result = CModule::OnModuleLoading(sModName, sArgs, eType, bSuccess, sRetMsg);
		} else { result = (CModule::EModRet)x; }
	}
	Py_CLEAR(pyRes);
	return result;
}

CModule::EModRet CPyModule::OnModuleUnloading(CModule* pModule, bool& bSuccess, CString& sRetMsg) {
	PyObject* pyName = Py_BuildValue("s", "OnModuleUnloading");
	if (!pyName) {
		CString sPyErr = m_pModPython->GetPyExceptionStr();
		DEBUG("modpython: " << (GetUser() ? GetUser()->GetUserName() : CString("<no user>")) << "/" << GetModName() << "/OnModuleUnloading: can't convert string 'OnModuleUnloading' to PyObject: " << sPyErr);
		return CModule::OnModuleUnloading(pModule, bSuccess, sRetMsg);
	}
	PyObject* pyArg_pModule = SWIG_NewInstanceObj(const_cast<CModule*>(pModule), SWIG_TypeQuery("CModule*"), 0);
	if (!pyArg_pModule) {
		CString sPyErr = m_pModPython->GetPyExceptionStr();
		DEBUG("modpython: " << (GetUser() ? GetUser()->GetUserName() : CString("<no user>")) << "/" << GetModName() << "/OnModuleUnloading: can't convert parameter 'pModule' to PyObject: " << sPyErr);
		Py_CLEAR(pyName);
		return CModule::OnModuleUnloading(pModule, bSuccess, sRetMsg);
	}
	PyObject* pyArg_bSuccess = CPyRetBool::wrap(bSuccess);
	if (!pyArg_bSuccess) {
		CString sPyErr = m_pModPython->GetPyExceptionStr();
		DEBUG("modpython: " << (GetUser() ? GetUser()->GetUserName() : CString("<no user>")) << "/" << GetModName() << "/OnModuleUnloading: can't convert parameter 'bSuccess' to PyObject: " << sPyErr);
		Py_CLEAR(pyName);
		Py_CLEAR(pyArg_pModule);
		return CModule::OnModuleUnloading(pModule, bSuccess, sRetMsg);
	}
	PyObject* pyArg_sRetMsg = CPyRetString::wrap(sRetMsg);
	if (!pyArg_sRetMsg) {
		CString sPyErr = m_pModPython->GetPyExceptionStr();
		DEBUG("modpython: " << (GetUser() ? GetUser()->GetUserName() : CString("<no user>")) << "/" << GetModName() << "/OnModuleUnloading: can't convert parameter 'sRetMsg' to PyObject: " << sPyErr);
		Py_CLEAR(pyName);
		Py_CLEAR(pyArg_pModule);
		Py_CLEAR(pyArg_bSuccess);
		return CModule::OnModuleUnloading(pModule, bSuccess, sRetMsg);
	}
	PyObject* pyRes = PyObject_CallMethodObjArgs(m_pyObj, pyName, pyArg_pModule, pyArg_bSuccess, pyArg_sRetMsg, nullptr);
	if (!pyRes) {
		CString sPyErr = m_pModPython->GetPyExceptionStr();
		DEBUG("modpython: " << (GetUser() ? GetUser()->GetUserName() : CString("<no user>")) << "/" << GetModName() << "/OnModuleUnloading failed: " << sPyErr);
		Py_CLEAR(pyName);
		Py_CLEAR(pyArg_pModule);
		Py_CLEAR(pyArg_bSuccess);
		Py_CLEAR(pyArg_sRetMsg);
		return CModule::OnModuleUnloading(pModule, bSuccess, sRetMsg);
	}
	Py_CLEAR(pyName);
	Py_CLEAR(pyArg_pModule);
	Py_CLEAR(pyArg_bSuccess);
	Py_CLEAR(pyArg_sRetMsg);
	CModule::EModRet result;
	if (pyRes == Py_None) {
		result = CModule::OnModuleUnloading(pModule, bSuccess, sRetMsg);
	} else {
		long int x = PyLong_AsLong(pyRes);
		if (PyErr_Occurred()) {
			CString sPyErr = m_pModPython->GetPyExceptionStr();
			DEBUG("modpython: " << (GetUser() ? GetUser()->GetUserName() : CString("<no user>")) << "/" << GetModName() << "/OnModuleUnloading was expected to return EModRet but: " << sPyErr);
			result = CModule::OnModuleUnloading(pModule, bSuccess, sRetMsg);
		} else { result = (CModule::EModRet)x; }
	}
	Py_CLEAR(pyRes);
	return result;
}

CModule::EModRet CPyModule::OnGetModInfo(CModInfo& ModInfo, const CString& sModule, bool& bSuccess, CString& sRetMsg) {
	PyObject* pyName = Py_BuildValue("s", "OnGetModInfo");
	if (!pyName) {
		CString sPyErr = m_pModPython->GetPyExceptionStr();
		DEBUG("modpython: " << (GetUser() ? GetUser()->GetUserName() : CString("<no user>")) << "/" << GetModName() << "/OnGetModInfo: can't convert string 'OnGetModInfo' to PyObject: " << sPyErr);
		return CModule::OnGetModInfo(ModInfo, sModule, bSuccess, sRetMsg);
	}
	PyObject* pyArg_ModInfo = SWIG_NewInstanceObj(const_cast<CModInfo*>(&ModInfo), SWIG_TypeQuery("CModInfo*"), 0);
	if (!pyArg_ModInfo) {
		CString sPyErr = m_pModPython->GetPyExceptionStr();
		DEBUG("modpython: " << (GetUser() ? GetUser()->GetUserName() : CString("<no user>")) << "/" << GetModName() << "/OnGetModInfo: can't convert parameter 'ModInfo' to PyObject: " << sPyErr);
		Py_CLEAR(pyName);
		return CModule::OnGetModInfo(ModInfo, sModule, bSuccess, sRetMsg);
	}
	PyObject* pyArg_sModule = Py_BuildValue("s", sModule.c_str());
	if (!pyArg_sModule) {
		CString sPyErr = m_pModPython->GetPyExceptionStr();
		DEBUG("modpython: " << (GetUser() ? GetUser()->GetUserName() : CString("<no user>")) << "/" << GetModName() << "/OnGetModInfo: can't convert parameter 'sModule' to PyObject: " << sPyErr);
		Py_CLEAR(pyName);
		Py_CLEAR(pyArg_ModInfo);
		return CModule::OnGetModInfo(ModInfo, sModule, bSuccess, sRetMsg);
	}
	PyObject* pyArg_bSuccess = CPyRetBool::wrap(bSuccess);
	if (!pyArg_bSuccess) {
		CString sPyErr = m_pModPython->GetPyExceptionStr();
		DEBUG("modpython: " << (GetUser() ? GetUser()->GetUserName() : CString("<no user>")) << "/" << GetModName() << "/OnGetModInfo: can't convert parameter 'bSuccess' to PyObject: " << sPyErr);
		Py_CLEAR(pyName);
		Py_CLEAR(pyArg_ModInfo);
		Py_CLEAR(pyArg_sModule);
		return CModule::OnGetModInfo(ModInfo, sModule, bSuccess, sRetMsg);
	}
	PyObject* pyArg_sRetMsg = CPyRetString::wrap(sRetMsg);
	if (!pyArg_sRetMsg) {
		CString sPyErr = m_pModPython->GetPyExceptionStr();
		DEBUG("modpython: " << (GetUser() ? GetUser()->GetUserName() : CString("<no user>")) << "/" << GetModName() << "/OnGetModInfo: can't convert parameter 'sRetMsg' to PyObject: " << sPyErr);
		Py_CLEAR(pyName);
		Py_CLEAR(pyArg_ModInfo);
		Py_CLEAR(pyArg_sModule);
		Py_CLEAR(pyArg_bSuccess);
		return CModule::OnGetModInfo(ModInfo, sModule, bSuccess, sRetMsg);
	}
	PyObject* pyRes = PyObject_CallMethodObjArgs(m_pyObj, pyName, pyArg_ModInfo, pyArg_sModule, pyArg_bSuccess, pyArg_sRetMsg, nullptr);
	if (!pyRes) {
		CString sPyErr = m_pModPython->GetPyExceptionStr();
		DEBUG("modpython: " << (GetUser() ? GetUser()->GetUserName() : CString("<no user>")) << "/" << GetModName() << "/OnGetModInfo failed: " << sPyErr);
		Py_CLEAR(pyName);
		Py_CLEAR(pyArg_ModInfo);
		Py_CLEAR(pyArg_sModule);
		Py_CLEAR(pyArg_bSuccess);
		Py_CLEAR(pyArg_sRetMsg);
		return CModule::OnGetModInfo(ModInfo, sModule, bSuccess, sRetMsg);
	}
	Py_CLEAR(pyName);
	Py_CLEAR(pyArg_ModInfo);
	Py_CLEAR(pyArg_sModule);
	Py_CLEAR(pyArg_bSuccess);
	Py_CLEAR(pyArg_sRetMsg);
	CModule::EModRet result;
	if (pyRes == Py_None) {
		result = CModule::OnGetModInfo(ModInfo, sModule, bSuccess, sRetMsg);
	} else {
		long int x = PyLong_AsLong(pyRes);
		if (PyErr_Occurred()) {
			CString sPyErr = m_pModPython->GetPyExceptionStr();
			DEBUG("modpython: " << (GetUser() ? GetUser()->GetUserName() : CString("<no user>")) << "/" << GetModName() << "/OnGetModInfo was expected to return EModRet but: " << sPyErr);
			result = CModule::OnGetModInfo(ModInfo, sModule, bSuccess, sRetMsg);
		} else { result = (CModule::EModRet)x; }
	}
	Py_CLEAR(pyRes);
	return result;
}

void CPyModule::OnGetAvailableMods(std::set<CModInfo>& ssMods, CModInfo::EModuleType eType) {
	PyObject* pyName = Py_BuildValue("s", "OnGetAvailableMods");
	if (!pyName) {
		CString sPyErr = m_pModPython->GetPyExceptionStr();
		DEBUG("modpython: " << (GetUser() ? GetUser()->GetUserName() : CString("<no user>")) << "/" << GetModName() << "/OnGetAvailableMods: can't convert string 'OnGetAvailableMods' to PyObject: " << sPyErr);
		return CModule::OnGetAvailableMods(ssMods, eType);
	}
	PyObject* pyArg_ssMods = SWIG_NewInstanceObj(const_cast<std::set<CModInfo>*>(&ssMods), SWIG_TypeQuery("std::set<CModInfo>*"), 0);
	if (!pyArg_ssMods) {
		CString sPyErr = m_pModPython->GetPyExceptionStr();
		DEBUG("modpython: " << (GetUser() ? GetUser()->GetUserName() : CString("<no user>")) << "/" << GetModName() << "/OnGetAvailableMods: can't convert parameter 'ssMods' to PyObject: " << sPyErr);
		Py_CLEAR(pyName);
		return CModule::OnGetAvailableMods(ssMods, eType);
	}
	PyObject* pyArg_eType = Py_BuildValue("i", (int)eType);
	if (!pyArg_eType) {
		CString sPyErr = m_pModPython->GetPyExceptionStr();
		DEBUG("modpython: " << (GetUser() ? GetUser()->GetUserName() : CString("<no user>")) << "/" << GetModName() << "/OnGetAvailableMods: can't convert parameter 'eType' to PyObject: " << sPyErr);
		Py_CLEAR(pyName);
		Py_CLEAR(pyArg_ssMods);
		return CModule::OnGetAvailableMods(ssMods, eType);
	}
	PyObject* pyRes = PyObject_CallMethodObjArgs(m_pyObj, pyName, pyArg_ssMods, pyArg_eType, nullptr);
	if (!pyRes) {
		CString sPyErr = m_pModPython->GetPyExceptionStr();
		DEBUG("modpython: " << (GetUser() ? GetUser()->GetUserName() : CString("<no user>")) << "/" << GetModName() << "/OnGetAvailableMods failed: " << sPyErr);
		Py_CLEAR(pyName);
		Py_CLEAR(pyArg_ssMods);
		Py_CLEAR(pyArg_eType);
		return CModule::OnGetAvailableMods(ssMods, eType);
	}
	Py_CLEAR(pyName);
	Py_CLEAR(pyArg_ssMods);
	Py_CLEAR(pyArg_eType);
	Py_CLEAR(pyRes);
}

void CPyModule::OnClientCapLs(CClient* pClient, SCString& ssCaps) {
	PyObject* pyName = Py_BuildValue("s", "OnClientCapLs");
	if (!pyName) {
		CString sPyErr = m_pModPython->GetPyExceptionStr();
		DEBUG("modpython: " << (GetUser() ? GetUser()->GetUserName() : CString("<no user>")) << "/" << GetModName() << "/OnClientCapLs: can't convert string 'OnClientCapLs' to PyObject: " << sPyErr);
		return CModule::OnClientCapLs(pClient, ssCaps);
	}
	PyObject* pyArg_pClient = SWIG_NewInstanceObj(const_cast<CClient*>(pClient), SWIG_TypeQuery("CClient*"), 0);
	if (!pyArg_pClient) {
		CString sPyErr = m_pModPython->GetPyExceptionStr();
		DEBUG("modpython: " << (GetUser() ? GetUser()->GetUserName() : CString("<no user>")) << "/" << GetModName() << "/OnClientCapLs: can't convert parameter 'pClient' to PyObject: " << sPyErr);
		Py_CLEAR(pyName);
		return CModule::OnClientCapLs(pClient, ssCaps);
	}
	PyObject* pyArg_ssCaps = SWIG_NewInstanceObj(const_cast<SCString*>(&ssCaps), SWIG_TypeQuery("SCString*"), 0);
	if (!pyArg_ssCaps) {
		CString sPyErr = m_pModPython->GetPyExceptionStr();
		DEBUG("modpython: " << (GetUser() ? GetUser()->GetUserName() : CString("<no user>")) << "/" << GetModName() << "/OnClientCapLs: can't convert parameter 'ssCaps' to PyObject: " << sPyErr);
		Py_CLEAR(pyName);
		Py_CLEAR(pyArg_pClient);
		return CModule::OnClientCapLs(pClient, ssCaps);
	}
	PyObject* pyRes = PyObject_CallMethodObjArgs(m_pyObj, pyName, pyArg_pClient, pyArg_ssCaps, nullptr);
	if (!pyRes) {
		CString sPyErr = m_pModPython->GetPyExceptionStr();
		DEBUG("modpython: " << (GetUser() ? GetUser()->GetUserName() : CString("<no user>")) << "/" << GetModName() << "/OnClientCapLs failed: " << sPyErr);
		Py_CLEAR(pyName);
		Py_CLEAR(pyArg_pClient);
		Py_CLEAR(pyArg_ssCaps);
		return CModule::OnClientCapLs(pClient, ssCaps);
	}
	Py_CLEAR(pyName);
	Py_CLEAR(pyArg_pClient);
	Py_CLEAR(pyArg_ssCaps);
	Py_CLEAR(pyRes);
}

CModule::EModRet CPyModule::OnLoginAttempt(std::shared_ptr<CAuthBase> Auth) {
	PyObject* pyName = Py_BuildValue("s", "OnLoginAttempt");
	if (!pyName) {
		CString sPyErr = m_pModPython->GetPyExceptionStr();
		DEBUG("modpython: " << (GetUser() ? GetUser()->GetUserName() : CString("<no user>")) << "/" << GetModName() << "/OnLoginAttempt: can't convert string 'OnLoginAttempt' to PyObject: " << sPyErr);
		return CModule::OnLoginAttempt(Auth);
	}
	PyObject* pyArg_Auth = SWIG_NewInstanceObj(new std::shared_ptr<CAuthBase>(Auth), SWIG_TypeQuery("std::shared_ptr<CAuthBase>*"), SWIG_POINTER_OWN);
	if (!pyArg_Auth) {
		CString sPyErr = m_pModPython->GetPyExceptionStr();
		DEBUG("modpython: " << (GetUser() ? GetUser()->GetUserName() : CString("<no user>")) << "/" << GetModName() << "/OnLoginAttempt: can't convert parameter 'Auth' to PyObject: " << sPyErr);
		Py_CLEAR(pyName);
		return CModule::OnLoginAttempt(Auth);
	}
	PyObject* pyRes = PyObject_CallMethodObjArgs(m_pyObj, pyName, pyArg_Auth, nullptr);
	if (!pyRes) {
		CString sPyErr = m_pModPython->GetPyExceptionStr();
		DEBUG("modpython: " << (GetUser() ? GetUser()->GetUserName() : CString("<no user>")) << "/" << GetModName() << "/OnLoginAttempt failed: " << sPyErr);
		Py_CLEAR(pyName);
		Py_CLEAR(pyArg_Auth);
		return CModule::OnLoginAttempt(Auth);
	}
	Py_CLEAR(pyName);
	Py_CLEAR(pyArg_Auth);
	CModule::EModRet result;
	if (pyRes == Py_None) {
		result = CModule::OnLoginAttempt(Auth);
	} else {
		long int x = PyLong_AsLong(pyRes);
		if (PyErr_Occurred()) {
			CString sPyErr = m_pModPython->GetPyExceptionStr();
			DEBUG("modpython: " << (GetUser() ? GetUser()->GetUserName() : CString("<no user>")) << "/" << GetModName() << "/OnLoginAttempt was expected to return EModRet but: " << sPyErr);
			result = CModule::OnLoginAttempt(Auth);
		} else { result = (CModule::EModRet)x; }
	}
	Py_CLEAR(pyRes);
	return result;
}

