/*      Copyright (C) 2001, 2002, 2003, 2004, 2005 Stijn van Dongen
 *
 * This file is part of Zoem. You can redistribute and/or modify Zoem under the
 * terms of the GNU General Public License;  either version 2 of the License or
 * (at your option) any later  version.  You should have received a copy of the
 * GPL along with Zoem, in the file COPYING.
*/

#ifndef zoem_source_h__
#define zoem_source_h__

#include "sink.h"
#include "util.h"

#include "util/io.h"
#include "util/ting.h"

void enter_interactive
(  void
)  ;


enum
{  STATUS_FAIL_OPEN  =  STATUS_UNUSED
,  STATUS_FAIL_READ
,  STATUS_FAIL_ZOEM
}  ;

mcxstatus sourceAscend
(  mcxTing        *fnsearch
,  sink*          fd
,  int            fltidx
,  size_t         chunk_size
,  int            debug
,  int            use_searchpath
,  int            allow_inline
)  ;

/*
 * This module maintains a stack of input files.
*/

mcxstatus sourcePush
(  const char* str
,  const mcxTing* txt
)  ;

mcxstatus sourcePop
(  void
)  ;
void sourceIncrLc
(  const mcxTing* txt
,  int   d
)  ;
int sourceGetLc
(  void
)  ;
const char* sourceGetName
(  void
)  ;
mcxTing* sourceGetPath
(  void
)  ;
mcxbool sourceCanPush
(  void
)  ;

void mod_source_init
(  int   n
)  ;

void mod_source_exit
(  void
)  ;

#endif

