<?php
//
// ZoneMinder web HU Hungarian language file, $Date: 2008-02-10 21:58:00 +0000 (Sun, 10 Feb 2008) $, $Revision: 2291 $
// Copyright (C) 2003, 2004, 2005, 2006  Philip Coombes
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
//

// ZoneMinder Hungarian Translation by szimszon at oregpreshaz dot eu, robi
// version: 0.5 - 2007.12.30. - frissts 1.23.1-hez (robi)
// version: 0.4 - 2007.12.30. - frissts 1.23.0-hoz (robi)
// version: 0.3 - 2006.04.27. - fordts befejezse, elrendezse elfrshez (robi)
// version: 0.2 - 2006.12.05. - par javitas
// version: 0.1 - 2006.11.27. - sok typoval es par leforditatlan resszel

// Notes for Translators
// 0. Get some credit, put your name in the line above (optional)
// 1. When composing the language tokens in your language you should try and keep to roughly the
//   same length text if possible. Abbreviate where necessary as spacing is quite close in a number of places.
// 2. There are four types of string replacement
//   a) Simple replacements are words or short phrases that are static and used directly. This type of
//     replacement can be used 'as is'.
//   b) Complex replacements involve some dynamic element being included and so may require substitution
//     or changing into a different order. The token listed in this file will be passed through sprintf as
//     a formatting string. If the dynamic element is a number you will usually need to use a variable
//     replacement also as described below.
//   c) Variable replacements are used in conjunction with complex replacements and involve the generation
//     of a singular or plural noun depending on the number passed into the zmVlang function. See the 
//     the zmVlang section below for a further description of this.
//   d) Optional strings which can be used to replace the prompts and/or help text for the Options section
//     of the web interface. These are not listed below as they are quite large and held in the database
//     so that they can also be used by the zmconfig.pl script. However you can build up your own list
//     quite easily from the Config table in the database if necessary.
// 3. The tokens listed below are not used to build up phrases or sentences from single words. Therefore
//   you can safely assume that a single word token will only be used in that context.
// 4. In new language files, or if you are changing only a few words or phrases it makes sense from a 
//   maintenance point of view to include the original language file and override the old definitions rather
//   than copy all the language tokens across. To do this change the line below to whatever your base language
//   is and uncomment it.
// require_once( 'zm_lang_en_gb.php' );

// You may need to change the character set here, if your web server does not already
// do this by default, uncomment this if required.
//
// Example
header( "Content-Type: text/html; charset=iso8859-2" );

// You may need to change your locale here if your default one is incorrect for the
// language described in this file, or if you have multiple languages supported.
// If you do need to change your locale, be aware that the format of this function
// is subtlely different in versions of PHP before and after 4.3.0, see
// http://uk2.php.net/manual/en/function.setlocale.php for details.
// Also be aware that changing the whole locale may affect some floating point or decimal 
// arithmetic in the database, if this is the case change only the individual locale areas
// that don't affect this rather than all at once. See the examples below.
// Finally, depending on your setup, PHP may not enjoy have multiple locales in a shared 
// threaded environment, if you get funny errors it may be this.
//
// Examples
// setlocale( 'LC_ALL', 'en_GB' ); All locale settings pre-4.3.0
// setlocale( LC_ALL, 'hu_HU' ); //All locale settings 4.3.0 and after
//setlocale( LC_CTYPE, 'hu_HU'); //Character class settings 4.3.0 and after
//setlocale( LC_TIME, 'hu_HU'); //Date and time formatting 4.3.0 and after

setlocale( LC_TIME, 'hu_HU' );
setlocale( LC_ALL, 'hu_HU' );

// Simple String Replacements
$zmSlang24BitColour          = '24 bites szn';
$zmSlang8BitGrey             = '8 bit szrkernyalat';
$zmSlangAction               = 'Mvelet';
$zmSlangActual               = 'Tnyleges';
$zmSlangAddNewControl        = 'j vezrls';
$zmSlangAddNewMonitor        = 'j monitor';
$zmSlangAddNewUser           = 'j felhasznl';
$zmSlangAddNewZone           = 'j zna';
$zmSlangAlarmBrFrames        = 'Riad<br/>kpek';
$zmSlangAlarmFrameCount      = 'Riad kpek szma';
$zmSlangAlarmFrame           = 'Riad kp';
$zmSlangAlarmLimits          = 'Riasztsi hatrok';
$zmSlangAlarmMaximumFPS      = 'Maximlis FPS riasztsnl';
$zmSlangAlarmPx              = 'Riad kppont';
$zmSlangAlarmRGBUnset        = 'Be kell lltani egy RGB sznt a riasztshoz';
$zmSlangAlarm                = 'Riad';
$zmSlangAlert                = 'Riaszts';
$zmSlangAll                  = 'Mind';
$zmSlangApply                = 'Alkalmaz';
$zmSlangApplyingStateChange  = 'llapot vlts...';
$zmSlangArchArchived         = 'Csak archivlt';
$zmSlangArchive              = 'Archivls';
$zmSlangArchived             = 'Archvum';
$zmSlangArchUnarchived       = 'Csak archivlatlan';
$zmSlangArea                 = 'Terlet';
$zmSlangAreaUnits            = 'Terlet (px/%)';
$zmSlangAttrAlarmFrames      = 'Riad kpkockk';
$zmSlangAttrArchiveStatus    = 'Archivlt llapot';
$zmSlangAttrAvgScore         = 'tlagos rtk';
$zmSlangAttrCause            = 'Okoz';
$zmSlangAttrDate             = 'Dtum';
$zmSlangAttrDateTime         = 'Dtum/Id';
$zmSlangAttrDiskBlocks       = 'Lemez blokkok';
$zmSlangAttrDiskPercent      = 'Lemez szzalk';
$zmSlangAttrDuration         = 'Idtartam';
$zmSlangAttrFrames           = 'Kpkockk';
$zmSlangAttrId               = 'Azonost';
$zmSlangAttrMaxScore         = 'Max. rtk';
$zmSlangAttrMonitorId        = 'Monitor azon.';
$zmSlangAttrMonitorName      = 'Monitor nv';
$zmSlangAttrName             = 'Nv';
$zmSlangAttrNotes            = 'Megjegyzs';
$zmSlangAttrSystemLoad       = 'Rendszer terhels';
$zmSlangAttrTime             = 'Id';
$zmSlangAttrTotalScore       = 'ssz. rtk';
$zmSlangAttrWeekday          = 'Htkznap';
$zmSlangAuto                 = 'Auto';
$zmSlangAutoStopTimeout      = 'Auto megllsi id tllps';
$zmSlangAvgBrScore           = 'tlag<br/>rtk';
$zmSlangBackgroundFilter     = 'Szr futtatsa a httrben';
$zmSlangBackground           = 'Httr';
$zmSlangBadAlarmFrameCount   = 'Riad kpek szma 1 vagy nagyobb egsz szm legyen';
$zmSlangBadAlarmMaxFPS       = 'A riad maximlis FPS szma pozitv szm legyen';
$zmSlangBadChannel           = 'A csatorna szma 0 vagy nagyobb egsz szm legyen';
$zmSlangBadDevice            = 'Az eszkz rtk vals legyen';
$zmSlangBadFormat            = 'A tpus 0 vagy nagyobb egsz szm legyen';
$zmSlangBadFPSReportInterval = 'FPS informcis idkz puffer szmllja 100 vagy nagyobb egsz legyen';
$zmSlangBadFrameSkip         = 'Kpkocka eldobsok szma 0 vagy nagyobb egsz szm legyen';
$zmSlangBadHeight            = 'A kpmagassg rvnyes rtk legyen kppontban';
$zmSlangBadHost              = 'A hoszt vals IP cm vagy hosztnv legyen, http:// nlkl';
$zmSlangBadImageBufferCount  = 'Kp puffer mrete legyen 10 vagy nagyobb szm';
$zmSlangBadLabelX            = 'A cimke X koordintja legyen 0 vagy nagyobb egsz szm';
$zmSlangBadLabelY            = 'A cimke Y koordintja legyen 0 vagy nagyobb egsz szm';
$zmSlangBadMaxFPS            = 'A maximlis FPS nullnl nagyobb szm legyen';
$zmSlangBadNameChars         = 'A nv csak alfanumerikus karaktereket, plusz-, kt-, s alhzsjelet tartalmazhat';
$zmSlangBadPath              = 'A kp elrsi tvonala vals legyen';
$zmSlangBadPort              = 'A portszm vals legyen';
$zmSlangBadPostEventCount    = 'Az esemny utni kpek puffere 0 vagy nagyobb egsz szm legyen';
$zmSlangBadPreEventCount     = 'Az esemny eltti kpek puffere 0 vagy nagyobb egsz szm legyen';
$zmSlangBadRefBlendPerc      = 'A referencia kpkeverk-szzalk pozitv egsz szm legyen';
$zmSlangBadSectionLength     = 'Egy egysg hossza 30 vagy hosszabb legyen';
$zmSlangBadSignalCheckColour = 'A jel ellenrzsi szn egy rvnyes RGP kd kell legyen';
$zmSlangBadStreamReplayBuffer= 'Folyam visszajtsz puffer 0 vagy nagyobb egsz szm legyen';
$zmSlangBadWarmupCount       = 'Bemelegt kpek szma 0 vagy nagyobb egsz szm legyen';
$zmSlangBadWebColour         = 'A web szn rvnyes web szn kd legyen';
$zmSlangBadWidth             = 'A kpszlessg rvnyes rtk legyen kppontban';
$zmSlangBandwidth            = 'Svszlessgre';
$zmSlangBlobPx               = 'Blob kppont';
$zmSlangBlobs                = 'Blob-ok';
$zmSlangBlobSizes            = 'Blob mrete';
$zmSlangBrightness           = 'Fnyer';
$zmSlangBuffers              = 'Pufferek';
$zmSlangCanAutoFocus         = 'Auto fkusz van';
$zmSlangCanAutoGain          = 'Auto gain van';
$zmSlangCanAutoIris          = 'Auto risz van';
$zmSlangCanAutoWhite         = 'Van autmata fehr egyensly';
$zmSlangCanAutoZoom          = 'Auto zoom van';
$zmSlangCancelForcedAlarm    = 'Kzi riaszts lelltsa';
$zmSlangCancel               = 'Mgsem';
$zmSlangCanFocusAbs          = 'Tud abszolt fkuszt';
$zmSlangCanFocusCon          = 'Tud folyamatos fkuszt';
$zmSlangCanFocusRel          = 'Tud relatv fkuszt';
$zmSlangCanFocus             = 'Tud fkuszlni';
$zmSlangCanGainAbs           = 'Tud abszolt erstst';
$zmSlangCanGainCon           = 'Tud folyamatos erstst';
$zmSlangCanGainRel           = 'Tud relatv erstst';
$zmSlangCanGain              = 'Tud ersteni';
$zmSlangCanIrisAbs           = 'Tud abszolut riszt';
$zmSlangCanIrisCon           = 'Folyamatosan tud riszt vltoztatni';
$zmSlangCanIrisRel           = 'Relatven tud riszt vltoztatni';
$zmSlangCanIris              = 'Tud riszt vltoztatni';
$zmSlangCanMoveAbs           = 'Tud abszolult mozgst';
$zmSlangCanMoveCon           = 'Folyamatosan tud mozogni';
$zmSlangCanMoveDiag          = 'Diagonlban tud mozogni';
$zmSlangCanMoveMap           = 'tvonalon tud mozogni';
$zmSlangCanMoveRel           = 'Relatven tud mozogni';
$zmSlangCanMove              = 'Tud mozogni';
$zmSlangCanPan               = 'Tud jobb-bal mozgst' ;
$zmSlangCanReset             = 'Tud alaphelyzetbe jnni';
$zmSlangCanSetPresets        = 'Tud menteni profilokat';
$zmSlangCanSleep             = 'Tud phihen zemmdot';
$zmSlangCanTilt              = 'Tud fel-le mozgst';
$zmSlangCanWake              = 'Tud felledni';
$zmSlangCanWhiteAbs          = 'Tud abszolut fehr egyenslyt';
$zmSlangCanWhiteBal          = 'Tud fehr egyenslyt';
$zmSlangCanWhiteCon          = 'Tud folyamatos fehr egyenslyt';
$zmSlangCanWhiteRel          = 'Tud relatv fehr egyenslyt';
$zmSlangCanWhite             = 'Tud fehr egyenslyt';
$zmSlangCanZoomAbs           = 'Tud abszolut zoom-ot';
$zmSlangCanZoomCon           = 'Tud folyamatos zoom-ot';
$zmSlangCanZoomRel           = 'Tud relatv zoom-ot';
$zmSlangCanZoom              = 'Tud zoom-olni';
$zmSlangCaptureHeight        = 'Kpmagassg';
$zmSlangCapturePalette       = 'Felvtel szn-paletta';
$zmSlangCaptureWidth         = 'Kpszlessg';
$zmSlangCause                = 'Okoz';
$zmSlangCheckMethod          = 'A riaszts figyelsnek mdja';
$zmSlangChooseFilter         = 'Vlassz szrt';
$zmSlangChoosePreset         = 'Vlassz profilt';
$zmSlangClose                = 'Bezr';
$zmSlangColour               = 'Szn';
$zmSlangCommand              = 'Parancs';
$zmSlangConfig               = 'Bellts';
$zmSlangConfiguredFor        = 'Belltva';
$zmSlangConfirmDeleteEvents  = 'Biztos benne, hogy trli a kivlasztott esemnyeket?';
$zmSlangConfirmPassword      = 'Jelsz megersts';
$zmSlangConjAnd              = 's';
$zmSlangConjOr               = 'vagy';
$zmSlangConsole              = 'Konzol';
$zmSlangContactAdmin         = 'Krem vegye fel a kapcsolatot a rendszergazdval a rszletekrt.';
$zmSlangContinue             = 'Folytats';
$zmSlangContrast             = 'Kontraszt';
$zmSlangControlAddress       = 'Vezrlsi jogok';
$zmSlangControlCaps          = 'Vezrlsi lehetsgek';
$zmSlangControlCap           = 'Vezrlsi lehetsg';
$zmSlangControlDevice        = 'Vezrl eszkz';
$zmSlangControllable         = 'Vezrelhet';
$zmSlangControlType          = 'Vezrls tpusa';
$zmSlangControl              = 'Vezrls';
$zmSlangCycle                = 'Krkapcsols';
$zmSlangCycleWatch           = 'Krkapcsols';
$zmSlangDay                  = 'Napon';
$zmSlangDebug                = 'Nyomon<br>kvets';
$zmSlangDefaultRate          = 'Alaprtelmezett FPS';
$zmSlangDefaultScale         = 'Alaprtelmezett arny';
$zmSlangDefaultView          = 'Alaprtelmezett nzet';
$zmSlangDeleteAndNext        = 'Trl &amp;<br>kvetkez';
$zmSlangDeleteAndPrev        = 'Trl &amp;<br>elz';
$zmSlangDeleteSavedFilter    = 'Mentett szr trlse';
$zmSlangDelete               = 'Trl';
$zmSlangDescription          = 'Lers';
$zmSlangDeviceChannel        = 'Eszkz csatornja';
$zmSlangDeviceFormat         = 'Eszkz formtuma';
$zmSlangDeviceNumber         = 'Eszkz szm';
$zmSlangDevicePath           = 'Eszkz elrsi tvonala';
$zmSlangDevices              = 'Eszkzk';
$zmSlangDimensions           = 'Dimenzik';
$zmSlangDisableAlarms        = 'Riaszts tiltsa';
$zmSlangDisk                 = 'Trhely';
$zmSlangDonateAlready        = 'Nem, n mr tmogattam';
$zmSlangDonateEnticement     = 'n mr j ideje hasznlja a ZoneMindert remlhetleg hasznos kiegsztsnek tartja hza vagy munkahelye biztostsban. Br ZoneMinder szabad, nylt forrskd, s az is marad; a fejlesztse pnzbe kerl. Ha tmogatni szeretn a jvbeni fejlesztseket s az j funkcikat krem tmogasson. A tmogats teljesen nkntes, de nagyon megbecslt s annyival tud tmogatni amennyivel kvn.<br><br>Ha tmogatni szertne krem vlasszon az albbi lehetsgekbl vagy ltogassa meg a http://www.zoneminder.com/donate.html oldalt.<br><br>Ksznm, hogy hasznlja a ZoneMinder-t s ne felejtse el megltogatni a frumokat a ZoneMinder.com oldalon tmogatsrt s tletekrt, hogy tudja mg jobban hasznlni a ZoneMinder-t.';
$zmSlangDonate               = 'Krem tmogasson';
$zmSlangDonateRemindDay      = 'Nem most, figyelmeztess 1 nap mlva';
$zmSlangDonateRemindHour     = 'Nem most, figyelmeztess 1 ra mlva';
$zmSlangDonateRemindMonth    = 'Nem most, figyelmeztess 1 hnap mlva';
$zmSlangDonateRemindNever    = 'Nem akarom tmogatni, ne is emlkeztess';
$zmSlangDonateRemindWeek     = 'Nem most, figyelmeztess 1 ht mlva';
$zmSlangDonateYes            = 'Igen, most szeretnm tmogatni';
$zmSlangDownload             = 'Letlt';
$zmSlangDuration             = 'Idtartam';
$zmSlangEdit                 = 'Szerkeszt';
$zmSlangEmail                = 'Email';
$zmSlangEnableAlarms         = 'Riaszts feloldsa';
$zmSlangEnabled              = 'Engedlyezve';
$zmSlangEnterNewFilterName   = 'rd be az j szr nevt';
$zmSlangErrorBrackets        = 'Hiba, ellenrizd, hogy ugyanannyi nyit s zr zrjel van';
$zmSlangError                = 'Hiba';
$zmSlangErrorValidValue      = 'Hiba, ellenrizd, hogy minden belltsnak rvnyes rtke van';
$zmSlangEtc                  = 'stb';
$zmSlangEvent                = 'Esemny';
$zmSlangEventFilter          = 'Esemny szr';
$zmSlangEventId              = 'Esemny azonost';
$zmSlangEventName            = 'Esemny nv';
$zmSlangEventPrefix          = 'Esemny eltag';
$zmSlangEvents               = 'Esemnyek';
$zmSlangExclude              = 'Kizr';
$zmSlangExecute              = 'Futtat';
$zmSlangExportDetails        = 'Esemny adatainak exportlsa';
$zmSlangExport               = 'Exportl';
$zmSlangExportFailed         = 'Hibs exportls';
$zmSlangExportFormat         = 'Exportlt fjl formtuma';
$zmSlangExportFormatTar      = 'TAR';
$zmSlangExportFormatZip      = 'ZIP';
$zmSlangExportFrames         = 'Kpek adatainak exportlsa';
$zmSlangExportImageFiles     = 'Kpek exportlsa';
$zmSlangExporting            = 'Exportls...';
$zmSlangExportMiscFiles      = 'Egyb fjlok exportlsa (ha vannak)';
$zmSlangExportOptions        = 'Exportls belltsai';
$zmSlangExportVideoFiles     = 'Vide fjlok exportlsa (ha vannak)';
$zmSlangFar                  = 'Tvol';
$zmSlangFastForward          = 'Elre tekers';
$zmSlangFeed                 = 'Folyam';
$zmSlangFileColours          = 'Fjl sznei';
$zmSlangFile                 = 'Fjl';
$zmSlangFilePath             = 'Fjl elrsi tvonala';
$zmSlangFilterArchiveEvents  = 'Minden tallat archivlsa';
$zmSlangFilterDeleteEvents   = 'Minden tallat trlse';
$zmSlangFilterEmailEvents    = 'Minden tallat adatainak elkldse E-mailben';
$zmSlangFilterExecuteEvents  = 'Parancs futtatsa minden tallaton';
$zmSlangFilterMessageEvents  = 'Minden tallat adatainak zense';
$zmSlangFilterPx             = 'Szrt kpkockk';
$zmSlangFilters              = 'Szrk';
$zmSlangFilterUnset          = 'Meg kell adnod a szr szlessgt s magassgt';
$zmSlangFilterUploadEvents   = 'Minden tallat feltltse';
$zmSlangFilterVideoEvents    = 'Vide ksztse minden tallatrl';
$zmSlangFirst                = 'Els';
$zmSlangFlippedHori          = 'Vzszintes tkrzs';
$zmSlangFlippedVert          = 'Fggleges tkrzs';
$zmSlangFocus                = 'Fkusz';
$zmSlangForceAlarm           = 'Kzi riaszts';
$zmSlangFormat               = 'Formtum';
$zmSlangFPS                  = 'fps';
$zmSlangFPSReportInterval    = 'FPS jelents idkze';
$zmSlangFrameId              = 'Kpkocka azonost';
$zmSlangFrame                = 'Kpkocka';
$zmSlangFrameRate            = 'FPS';
$zmSlangFrameSkip            = 'Kpk. kihagys';
$zmSlangFrames               = 'Kpkocka';
$zmSlangFTP                  = 'FTP';
$zmSlangFunc                 = 'Funk.';
$zmSlangFunction             = 'Funkci';
$zmSlangGain                 = 'Ersts';
$zmSlangGeneral              = 'ltalnos';
$zmSlangGenerateVideo        = 'Vide kszts';
$zmSlangGeneratingVideo      = 'Vide ksztse...';
$zmSlangGoToZoneMinder       = 'Ltogats a ZoneMinder.com-ra';
$zmSlangGrey                 = 'Szrke';
$zmSlangGroup                = 'Csoport';
$zmSlangGroups               = 'Csoportok';
$zmSlangHasFocusSpeed        = 'Van fkusz sebessg';
$zmSlangHasGainSpeed         = 'Van ersts sebessg';
$zmSlangHasHomePreset        = 'Van kedvenc profilja';
$zmSlangHasIrisSpeed         = 'Van risz sebessg';
$zmSlangHasPanSpeed          = 'Van jobb-bal sebessg';
$zmSlangHasPresets           = 'Vannak profiljai';
$zmSlangHasTiltSpeed         = 'Van le-fel sebessg';
$zmSlangHasTurboPan          = 'Van turb jobb-bal';
$zmSlangHasTurboTilt         = 'Van turb le-fel';
$zmSlangHasWhiteSpeed        = 'Van fehr egyensly sebessg';
$zmSlangHasZoomSpeed         = 'Van zoom sebessg';
$zmSlangHighBW               = 'Magas<br>svsz.';
$zmSlangHigh                 = 'Magas';
$zmSlangHome                 = 'Home';
$zmSlangHour                 = 'rban';
$zmSlangHue                  = 'Sznrnyalat';
$zmSlangId                   = 'Az.';
$zmSlangIdle                 = 'Nyugalom';
$zmSlangIgnore               = 'Figyelmen kvl hagy';
$zmSlangImageBufferSize      = 'Kppuffer mrete (kpkockk)';
$zmSlangImage                = 'Kp';
$zmSlangImages               = 'Kp';
$zmSlangInclude              = 'Begyaz';
$zmSlangIn                   = 'In';
$zmSlangInverted             = 'Invertlva';
$zmSlangIris                 = 'risz';
$zmSlangKeyString            = 'Kulcs karaktersor';
$zmSlangLabel                = 'Cimke';
$zmSlangLanguage             = 'Nyelv';
$zmSlangLast                 = 'Utols';
$zmSlangLimitResultsPost     = 'tallatig korltoz'; // This is used at the end of the phrase 'Limit to first N results only'
$zmSlangLimitResultsPre      = 'Az els'; // This is used at the beginning of the phrase 'Limit to first N results only'
$zmSlangLinkedMonitors       = 'sszefgg monitorok';
$zmSlangList                 = 'Lista';
$zmSlangLoad                 = 'Terhels';
$zmSlangLocal                = 'Helyi';
$zmSlangLoggedInAs           = 'Bejelentkezve mint';
$zmSlangLoggingIn            = 'Bejelentkezs folyamatban';
$zmSlangLogin                = 'Bejelentkezs';
$zmSlangLogout               = 'Kilps';
$zmSlangLow                  = 'Alacsony';
$zmSlangLowBW                = 'Alacsony<br>svsz.';
$zmSlangMain                 = 'F';
$zmSlangMan                  = 'Man';
$zmSlangManual               = 'Kziknyv';
$zmSlangMark                 = 'Jells';
$zmSlangMaxBandwidth         = 'Max. svszlessg';
$zmSlangMaxBrScore           = 'Max.<br/>rtk';
$zmSlangMaxFocusRange        = 'Max. fkusz tartomny';
$zmSlangMaxFocusSpeed        = 'Max. fkusz sebessg';
$zmSlangMaxFocusStep         = 'Max. fkusz lps';
$zmSlangMaxGainRange         = 'Max Gain Range';
$zmSlangMaxGainSpeed         = 'Max Gain Speed';
$zmSlangMaxGainStep          = 'Max Gain Step';
$zmSlangMaximumFPS           = 'Maximum FPS';
$zmSlangMaxIrisRange         = 'Max. risz tartomny';
$zmSlangMaxIrisSpeed         = 'Max. risz sebessg';
$zmSlangMaxIrisStep          = 'Max. risz lps';
$zmSlangMax                  = 'Max.';
$zmSlangMaxPanRange          = 'Max. jobb-bal tartomny';
$zmSlangMaxPanSpeed          = 'Max. jobb-bal sebessg';
$zmSlangMaxPanStep           = 'Max. jobb-bal lps';
$zmSlangMaxTiltRange         = 'Max. fel-le tartomny';
$zmSlangMaxTiltSpeed         = 'Max. fel-le sebessg';
$zmSlangMaxTiltStep          = 'Max. fel-le lps';
$zmSlangMaxWhiteRange        = 'Max. fehr egyensly tartomny';
$zmSlangMaxWhiteSpeed        = 'Max. fehr egyensly sebessg';
$zmSlangMaxWhiteStep         = 'Max. fehr egyensly lps';
$zmSlangMaxZoomRange         = 'Max. zoom tartomny';
$zmSlangMaxZoomSpeed         = 'Max. zoom sebessg';
$zmSlangMaxZoomStep          = 'Max. zoom lps';
$zmSlangMediumBW             = 'Kzepes<br>svsz.';
$zmSlangMedium               = 'Kzepes';
$zmSlangMinAlarmAreaLtMax    = 'A minimum riasztott terletnek kisebbnek kell lennie mint a maximumnak';
$zmSlangMinAlarmAreaUnset    = 'Meg kell adnod a minimum riasztott kppontok szmt';
$zmSlangMinBlobAreaLtMax     = 'A minimum blob terletnek kisebbnek kell lennie mint a maximumnak';
$zmSlangMinBlobAreaUnset     = 'Meg kell adnod a minimum blob kppontok szmt';
$zmSlangMinBlobLtMinFilter   = 'A minimum blob terletnek kisebbnek vagy egyenlnek kell lennie a megszrt terlettel';
$zmSlangMinBlobsLtMax        = 'A minimum bloboknak kisebbeknek kell lennik, mint a maximum';
$zmSlangMinBlobsUnset        = 'Meg kell adnod a blobok szmt';
$zmSlangMinFilterAreaLtMax   = 'A minimum megszrt terletnek kisebbnek kell lennie mint a maximum';
$zmSlangMinFilterAreaUnset   = 'Meg kell adnod a megszrt terlet kppontjainak szmt';
$zmSlangMinFilterLtMinAlarm  = 'A megszrt terletnek kisebbnek vagy ugyanakkornak kell lennie mint a riasztott terlet';
$zmSlangMinFocusRange        = 'Min. fkusz terlet';
$zmSlangMinFocusSpeed        = 'Min. fkusz sebessg';
$zmSlangMinFocusStep         = 'Min. fkusz lps';
$zmSlangMinGainRange         = 'Min Gain Range';
$zmSlangMinGainSpeed         = 'Min Gain Speed';
$zmSlangMinGainStep          = 'Min Gain Step';
$zmSlangMinIrisRange         = 'Min. risz terlet';
$zmSlangMinIrisSpeed         = 'Min. risz sebessg';
$zmSlangMinIrisStep          = 'Min. risz lps';
$zmSlangMinPanRange          = 'Min. jobb-bal tartomny';
$zmSlangMinPanSpeed          = 'Min. jobb-bal sebessg';
$zmSlangMinPanStep           = 'Min. jobb-bal lps';
$zmSlangMinPixelThresLtMax   = 'A minimum kszb kppontnak kisebbnek kell lennie, mint a maximum';
$zmSlangMinPixelThresUnset   = 'Meg kell adnod a minimum kppont kszbt';
$zmSlangMinTiltRange         = 'Min. fel-le tartomny';
$zmSlangMinTiltSpeed         = 'Min. fel-le sebessg';
$zmSlangMinTiltStep          = 'Min. fel-le lps';
$zmSlangMinWhiteRange        = 'Min. fehr egyensly terlet';
$zmSlangMinWhiteSpeed        = 'Min. fehr egyensly sebessg';
$zmSlangMinWhiteStep         = 'Min. fehr egyensly lps';
$zmSlangMinZoomRange         = 'Min. zoom terlet';
$zmSlangMinZoomSpeed         = 'Min. zoom sebessg';
$zmSlangMinZoomStep          = 'Min. zoom lps';
$zmSlangMisc                 = 'Egyb';
$zmSlangMonitorIds           = 'Monitor&nbsp;Azonostk';
$zmSlangMonitor              = 'Monitor';
$zmSlangMonitorPreset        = 'Elre belltott rtkprofilok megfigyelshez';
$zmSlangMonitorPresetIntro   = 'Vlassz egy, az elre meghatrozott<br> rtkprofilt az albbiak kzl.<br><br>Vedd figyelembe, hogy ez fellrhatja <br>az ltalad mr belltott rtkeket.<br><br>';
$zmSlangMonitors             = 'Megfigyelsek';
$zmSlangMontage              = 'Tbbkamers nzet';
$zmSlangMonth                = 'Hnapban';
$zmSlangMove                 = 'Mozgs';
$zmSlangMustBeGe             = 'nagyobbnak vagy egyenlnek kell lennie';
$zmSlangMustBeLe             = 'kisebbnek vagy egyenlnek kell lennie';
$zmSlangMustConfirmPassword  = 'Meg kell erstened a jelszt';
$zmSlangMustSupplyPassword   = 'Meg kell adnod a jelszt';
$zmSlangMustSupplyUsername   = 'Meg kell adnod felhasznli nevet';
$zmSlangName                 = 'Nv';
$zmSlangNear                 = 'Kzel';
$zmSlangNetwork              = 'Hlzat';
$zmSlangNewGroup             = 'j csoport';
$zmSlangNewLabel             = 'j cimke';
$zmSlangNewPassword          = 'j jelsz';
$zmSlangNewState             = 'j llapot';
$zmSlangNew                  = 'Uj';
$zmSlangNewUser              = 'j felhasznl';
$zmSlangNext                 = 'Kvetkez';
$zmSlangNoFramesRecorded     = 'Nincs felvett kpkocka ehhez az esemnyhez';
$zmSlangNoGroup              = 'Nincs csoport';
$zmSlangNoneAvailable        = 'Nincs elrhet';
$zmSlangNo                   = 'Nem';
$zmSlangNone                 = 'Nincs kivlasztva';
$zmSlangNormal               = 'Normlis';
$zmSlangNoSavedFilters       = 'Nincs mentett szr';
$zmSlangNoStatisticsRecorded = 'Nincs mentett statisztika ehhez az esemnyhez/kpkockhoz';
$zmSlangNotes                = 'Megjegyzsek';
$zmSlangNumPresets           = 'Profilok szma';
$zmSlangOff                  = 'Ki';
$zmSlangOn                   = 'Be';
$zmSlangOpen                 = 'Megnyits';
$zmSlangOpEq                 = 'egyenl';
$zmSlangOpGtEq               = 'nagyobb van egyenl';
$zmSlangOpGt                 = 'nagyobb mint';
$zmSlangOpIn                 = 'belltva';
$zmSlangOpLtEq               = 'kisebb vagy egyenl';
$zmSlangOpLt                 = 'kisebb mint';
$zmSlangOpMatches            = 'tallatok';
$zmSlangOpNe                 = 'nem egyenl';
$zmSlangOpNotIn              = 'nincs belltva';
$zmSlangOpNotMatches         = 'nincs tallat';
$zmSlangOptionHelp           = 'Belltsi segtsg';
$zmSlangOptionRestartWarning = 'Ez a bellts nem jut teljesen rvnyre\namg a rendszer fut. Ha megtettl minden\nbelltst, indtsd jra a ZoneMinder szolgltatst.';
$zmSlangOptions              = 'Belltsok';
$zmSlangOrder                = 'Sorrend';
$zmSlangOrEnterNewName       = 'vagy adj meg j nevet';
$zmSlangOrientation          = 'Orientci';
$zmSlangOut                  = 'Kifel';
$zmSlangOverwriteExisting    = 'Meglv fellrsa';
$zmSlangPaged                = 'Lapozva';
$zmSlangPan                  = 'Jobb-bal mozgs';
$zmSlangPanLeft              = 'Mozgs balra';
$zmSlangPanRight             = 'Mozgs jobbra';
$zmSlangPanTilt              = 'Mozgat';
$zmSlangParameter            = 'Paramter';
$zmSlangPassword             = 'Jelsz';
$zmSlangPasswordsDifferent   = 'Az j s a megerstett jelsz klnbzik!';
$zmSlangPaths                = 'tvonalak';
$zmSlangPause                = 'Sznet';
$zmSlangPhoneBW              = 'Betrcsz<br>svsz.';
$zmSlangPhone                = 'Telefonon betrcszva';
$zmSlangPixelDiff            = 'Kppont eltrs';
$zmSlangPixels               = 'kppont';
$zmSlangPlayAll              = 'Mind lejtszsa';
$zmSlangPlay                 = 'Lejtszs';
$zmSlangPleaseWait           = 'Krlek vrj...';
$zmSlangPoint                = 'Pont';
$zmSlangPostEventImageBuffer = 'Esemny utni kppuffer';
$zmSlangPreEventImageBuffer  = 'Esemny eltti kppuffer';
$zmSlangPreserveAspect	     = 'Kparny megtartsa';
$zmSlangPreset               = 'Elre belltott profil';
$zmSlangPresets              = 'Elre belltott profilok';
$zmSlangPrev                 = 'Elz';
$zmSlangProtocol             = 'Protocol';
$zmSlangRate                 = 'FPS';
$zmSlangReal                 = 'Vals';
$zmSlangRecord               = 'Felvtel';
$zmSlangRefImageBlendPct     = 'Vltozs a referenciakptl %-ban';
$zmSlangRefresh              = 'Frisst';
$zmSlangRemote               = 'Hlzati';
$zmSlangRemoteHostName       = 'Hlzati IP cm/hosztnv';
$zmSlangRemoteHostPath       = 'A kp elrsi tja';
$zmSlangRemoteHostPort       = 'Hlzati gp portszma';
$zmSlangRemoteImageColours   = 'A kp szne';
$zmSlangRename               = 'tnevez';
$zmSlangReplayAll            = 'Minden esemnyt';
$zmSlangReplay               = 'Az elejtl';
$zmSlangReplayGapless        = 'Folyamatos esemnyeket';
$zmSlangReplaySingle         = 'Egyni esemny';
$zmSlangReplay               = 'Visszajtszs';
$zmSlangReset                = 'Alaprtkre llt';
$zmSlangResetEventCounts     = 'Esemny szmll nullzsa';
$zmSlangRestarting           = 'jraindts';
$zmSlangRestart              = 'jraindt';
$zmSlangRestrictedCameraIds  = 'Korltozott kamerk azonosti';
$zmSlangRestrictedMonitors   = 'Korltozott kamerk';
$zmSlangReturnDelay          = 'Visszarkezs ksleltetse';
$zmSlangReturnLocation       = 'Visszarkezs helye';
$zmSlangRewind               = 'Visszatekers';
$zmSlangRotateLeft           = 'Balra forgats';
$zmSlangRotateRight          = 'Jobbra forgats';
$zmSlangRunMode              = 'Futsi md';
$zmSlangRunning              = 'les';
$zmSlangRunState             = 'Futsi llapot';
$zmSlangSaveAs               = 'Ments mint';
$zmSlangSaveFilter           = 'Szr mentse';
$zmSlangSave                 = 'Ments';
$zmSlangScale                = 'Mret';
$zmSlangScore                = 'Pontszm';
$zmSlangSecs                 = 'mp.';
$zmSlangSectionlength        = 'Rsz hossz';
$zmSlangSelect               = 'Kivlaszts';
$zmSlangSelectMonitors       = 'Monitorok kivlasztsa';
$zmSlangSelfIntersecting     = 'A sokszg szlei nem keresztezdhetnek';
$zmSlangSet                  = 'Bellt';
$zmSlangSetLearnPrefs        = 'Set Learn Prefs'; // This can be ignored for now
$zmSlangSetNewBandwidth      = 'j svszlessg bellts';
$zmSlangSetPreset            = 'Alaprtelmezett belltsa';
$zmSlangSettings             = 'Belltsok';
$zmSlangShowFilterWindow     = 'Szrablak megjelents';
$zmSlangShowTimeline         = 'Idvonal megjelents';
$zmSlangSignalCheckColour    = 'Szn a jel kimaradsakor';
$zmSlangSize                 = 'Fjlmret';
$zmSlangSleep                = 'Alvs';
$zmSlangSortAsc              = 'Nvekv';
$zmSlangSortBy               = 'Sorbarendezs:';
$zmSlangSortDesc             = 'Cskken';
$zmSlangSource               = 'Forrs';
$zmSlangSourceType           = 'Forrs tpusa';
$zmSlangSpeedHigh            = 'Nagy sebssg';
$zmSlangSpeedLow             = 'Alacsony sebessg';
$zmSlangSpeedMedium          = 'Kzepes sebessg';
$zmSlangSpeed                = 'Sebessg';
$zmSlangSpeedTurbo           = 'Turb sebessg';
$zmSlangStart                = 'Indt';
$zmSlangState                = 'llapot';
$zmSlangStats                = 'Statisztikk';
$zmSlangStatus               = 'Sttusz';
$zmSlangStepBack             = 'Visszalps';
$zmSlangStepForward          = 'Elrelps';
$zmSlangStepLarge            = 'Nagy ugrs';
$zmSlangStepMedium           = 'Kzepes ugrs';
$zmSlangStepNone             = 'Nincs ugrs';
$zmSlangStepSmall            = 'Kis ugrs';
$zmSlangStep                 = 'Ugrs';
$zmSlangStills               = 'llkpek';
$zmSlangStop                 = 'Megllts';
$zmSlangStopped              = 'Meglltva';
$zmSlangStream               = 'l folyam';
$zmSlangStreamReplayBuffer   = 'Folyam visszajtsz kppuffer';
$zmSlangSubmit               = 'Elkld';
$zmSlangSystem               = 'Rendszer';
$zmSlangTele                 = 'Tv';
$zmSlangThumbnail            = 'Elnzet';
$zmSlangTilt                 = 'Fel-le mozgs';
$zmSlangTimeDelta            = 'Id vltozs';
$zmSlangTime                 = 'Idpont';
$zmSlangTimeline             = 'Idvonal';
$zmSlangTimestamp            = 'Idblyeg';
$zmSlangTimeStamp            = 'Idblyeg';
$zmSlangTimestampLabelFormat = 'Idblyeg formtum';
$zmSlangTimestampLabelX      = 'Elhelyezs X pozici';
$zmSlangTimestampLabelY      = 'Elhelyezs Y pozici';
$zmSlangToday                = 'Ma';
$zmSlangTools                = 'Eszkzk';
$zmSlangTotalBrScore         = 'ssz.<br/>pontszm';
$zmSlangTrackDelay           = 'Ksleltets kvetse';
$zmSlangTrackMotion          = 'Mozgs kvetse';
$zmSlangTriggers             = 'Elidzk';
$zmSlangTurboPanSpeed        = 'Turb jobb-bal sebessg';
$zmSlangTurboTiltSpeed       = 'Turbo fel-le sebessg';
$zmSlangType                 = 'Tpus';
$zmSlangUnarchive            = 'Archvumbl ki';
$zmSlangUnits                = 'Egysgek';
$zmSlangUnknown              = 'Ismeretlen';
$zmSlangUpdateAvailable      = 'Elrhet ZoneMinder frissts.';
$zmSlangUpdate               = 'Frissts';
$zmSlangUpdateNotNecessary   = 'Nem szksges a frissts.';
$zmSlangUseFilterExprsPost   = '&nbsp;szr&nbsp;kifejezs hasznlata'; // This is used at the end of the phrase 'use N filter expressions'
$zmSlangUseFilterExprsPre    = '&nbsp;'; // This is used at the beginning of the phrase 'use N filter expressions'
$zmSlangUseFilter            = 'Szrt hasznl';
$zmSlangUser                 = 'Felhasznl';
$zmSlangUsername             = 'Felhasznlnv';
$zmSlangUsers                = 'Felhasznlk';
$zmSlangValue                = 'rtk';
$zmSlangVersionIgnore        = 'Ennek a verzinak a figyelmen kvl hagysa';
$zmSlangVersionRemindDay     = '1 nap mlva emlkeztess';
$zmSlangVersionRemindHour    = '1 ra mlva emlkeztess';
$zmSlangVersionRemindNever   = 'Ne emlkeztess az j verzirl';
$zmSlangVersionRemindWeek    = '1 ht mlva emlkeztess';
$zmSlangVersion              = 'Verzi';
$zmSlangVideoFormat          = 'Vide formtum';
$zmSlangVideoGenFailed       = 'Hiba a vide ksztsekor!';
$zmSlangVideoGenFiles        = 'Ltez videk';
$zmSlangVideoGenNoFiles      = 'Nem tallhatk videk';
$zmSlangVideoGenParms        = 'Vide ksztsi paramterek';
$zmSlangVideoGenSucceeded    = 'A vide elkszlt!';
$zmSlangVideoSize            = 'Kp mrete';
$zmSlangVideo                = 'Vide';
$zmSlangViewAll              = 'Az sszes listzsa';
$zmSlangViewEvent            = 'Esemnyek nzet';
$zmSlangView                 = 'Megtekint';
$zmSlangViewPaged            = 'Oldal nzet';
$zmSlangWake                 = 'breszt';
$zmSlangWarmupFrames         = 'Bemelegt kpkockk';
$zmSlangWatch                = 'Figyel';
$zmSlangWebColour            = 'Szn az idvonal ablakban';
$zmSlangWeb                  = 'Web';
$zmSlangWeek                 = 'Hten';
$zmSlangWhiteBalance         = 'Fehr egyensly';
$zmSlangWhite                = 'Fehr';
$zmSlangWide                 = 'Szles';
$zmSlangX10ActivationString  = 'X10 lest karaktersor';
$zmSlangX10InputAlarmString  = 'X10 bemeneti riad karaktersor';
$zmSlangX10OutputAlarmString = 'X10 kimeneti riad karaktersor';
$zmSlangX10                  = 'X10';
$zmSlangX                    = 'X';
$zmSlangYes                  = 'Igen';
$zmSlangYouNoPerms           = 'Nincs jogod az erforrs elrshez.';
$zmSlangY                    = 'Y';
$zmSlangZoneAlarmColour      = 'Riad szn (R/G/B)';
$zmSlangZoneArea             = 'Zna terlet';
$zmSlangZoneFilterSize       = 'Szrt szlessg/magassg (kppontok)';
$zmSlangZoneMinMaxAlarmArea  = 'Min/Max riad terlet';
$zmSlangZoneMinMaxBlobArea   = 'Min/Max Blob terlet';
$zmSlangZoneMinMaxBlobs      = 'Min/Max Blobok';
$zmSlangZoneMinMaxFiltArea   = 'Min/Max szrt terlet';
$zmSlangZoneMinMaxPixelThres = 'Min/Max kppont kszb (0-255)';
$zmSlangZoneOverloadFrames   = 'Tlterhels esetn ennyi kpkocka hagyhat ki';
$zmSlangZones                = 'Znk';
$zmSlangZone                 = 'Zna:';
$zmSlangZoomIn               = 'Zoom be';
$zmSlangZoomOut              = 'Zoom ki';
$zmSlangZoom                 = 'Zoom';

// Complex replacements with formatting and/or placements, must be passed through sprintf
$zmClangCurrentLogin         = 'Jelenleg belpve mint \'%1$s\'';
$zmClangEventCount           = '%1$s %2$s'; // For example '37 Events' (from Vlang below)
$zmClangLastEvents           = 'Utols %1$s %2$s'; // For example 'Last 37 Events' (from Vlang below)
$zmClangLatestRelease        = 'Az utols kiads v%1$s, ami neked van v%2$s.';
$zmClangMonitorCount         = '%1$s %2$s'; // For example '4 Monitors' (from Vlang below)
$zmClangMonitorFunction      = 'Megfigyels funkci: %1$s';
$zmClangRunningRecentVer     = 'A legfrissebb ZoneMinder verzit hasznlod, v%s.';

// The next section allows you to describe a series of word ending and counts used to 
// generate the correctly conjugated forms of words depending on a count that is associated
// with that word.
// This intended to allow phrases such a '0 potatoes', '1 potato', '2 potatoes' etc to
// conjugate correctly with the associated count.
// In some languages such as English this is fairly simple and can be expressed by assigning
// a count with a singular or plural form of a word and then finding the nearest (lower) value.
// So '0' of something generally ends in 's', 1 of something is singular and has no extra
// ending and 2 or more is a plural and ends in 's' also. So to find the ending for '187' of
// something you would find the nearest lower count (2) and use that ending.
//
// So examples of this would be
// $zmVlangPotato = array( 0=>'Potatoes', 1=>'Potato', 2=>'Potatoes' );
// $zmVlangSheep = array( 0=>'Sheep' );
//
// where you can have as few or as many entries in the array as necessary
// If your language is similar in form to this then use the same format and choose the
// appropriate zmVlang function below.
// If however you have a language with a different format of plural endings then another
// approach is required . For instance in Russian the word endings change continuously
// depending on the last digit (or digits) of the numerator. In this case then zmVlang
// arrays could be written so that the array index just represents an arbitrary 'type'
// and the zmVlang function does the calculation about which version is appropriate.
//
// So an example in Russian might be (using English words, and made up endings as I
// don't know any Russian!!)
// $zmVlangPotato = array( 1=>'Potati', 2=>'Potaton', 3=>'Potaten' );
//
// and the zmVlang function decides that the first form is used for counts ending in
// 0, 5-9 or 11-19 and the second form when ending in 1 etc.
//

// Variable arrays expressing plurality, see the zmVlang description above
$zmVlangEvent                = array( 0=>'Esemnyek', 1=>'Esemny', 2=>'Esemny' );
$zmVlangMonitor              = array( 0=>'Monitorok', 1=>'Monitor', 2=>'Monitor' );

// You will need to choose or write a function that can correlate the plurality string arrays
// with variable counts. This is used to conjugate the Vlang arrays above with a number passed
// in to generate the correct noun form.
//
// In languages such as English this is fairly simple 
// Note this still has to be used with printf etc to get the right formating
function zmVlang( $lang_var_array, $count )
{
	krsort( $lang_var_array );
	foreach ( $lang_var_array as $key=>$value )
	{
		if ( abs($count) >= $key )
		{
			return( $value );
		}
	}
	die( 'Error, unable to correlate variable language string' );
}

// This is an version that could be used in the Russian example above
// The rules are that the first word form is used if the count ends in
// 0, 5-9 or 11-19. The second form is used then the count ends in 1
// (not including 11 as above) and the third form is used when the 
// count ends in 2-4, again excluding any values ending in 12-14.
// 
// function zmVlang( $lang_var_array, $count )
// {
// 	$secondlastdigit = substr( $count, -2, 1 );
// 	$lastdigit = substr( $count, -1, 1 );
// 	// or
// 	// $secondlastdigit = ($count/10)%10;
// 	// $lastdigit = $count%10;
// 
// 	// Get rid of the special cases first, the teens
// 	if ( $secondlastdigit == 1 && $lastdigit != 0 )
// 	{
// 		return( $lang_var_array[1] );
// 	}
// 	switch ( $lastdigit )
// 	{
// 		case 0 :
// 		case 5 :
// 		case 6 :
// 		case 7 :
// 		case 8 :
// 		case 9 :
// 		{
// 			return( $lang_var_array[1] );
// 			break;
// 		}
// 		case 1 :
// 		{
// 			return( $lang_var_array[2] );
// 			break;
// 		}
// 		case 2 :
// 		case 3 :
// 		case 4 :
// 		{
// 			return( $lang_var_array[3] );
// 			break;
// 		}
// 	}
// 	die( 'Error, unable to correlate variable language string' );
// }

// This is an example of how the function is used in the code which you can uncomment and 
// use to test your custom function.
//$monitors = array();
//$monitors[] = 1; // Choose any number
//echo sprintf( $zmClangMonitorCount, count($monitors), zmVlang( $zmVlangMonitor, count($monitors) ) );

// In this section you can override the default prompt and help texts for the options area
// These overrides are in the form of $zmOlangPrompt<option> and $zmOlangHelp<option>
// where <option> represents the option name minus the initial ZM_
// So for example, to override the help text for ZM_LANG_DEFAULT do
//$zmOlangPromptLANG_DEFAULT = "This is a new prompt for this option";
//$zmOlangHelpLANG_DEFAULT = "This is some new help for this option which will be displayed in the popup window when the ? is clicked";
//

?>

