<?php
//
// ZoneMinder web UK English language file, $Date$, $Revision$
// Copyright (C) 2001-2008 Philip Coombes
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
//

// ZoneMinder Czech Translation by Lukas Pokorny/Mlada Boleslav

// Notes for Translators
// 0. Get some credit, put your name in the line above (optional)
// 1. When composing the language tokens in your language you should try and keep to roughly the
//   same length text if possible. Abbreviate where necessary as spacing is quite close in a number of places.
// 2. There are four types of string replacement
//   a) Simple replacements are words or short phrases that are static and used directly. This type of
//     replacement can be used 'as is'.
//   b) Complex replacements involve some dynamic element being included and so may require substitution
//     or changing into a different order. The token listed in this file will be passed through sprintf as
//     a formatting string. If the dynamic element is a number you will usually need to use a variable
//     replacement also as described below.
//   c) Variable replacements are used in conjunction with complex replacements and involve the generation
//     of a singular or plural noun depending on the number passed into the zmVlang function. See the 
//     the zmVlang section below for a further description of this.
//   d) Optional strings which can be used to replace the prompts and/or help text for the Options section
//     of the web interface. These are not listed below as they are quite large and held in the database
//     so that they can also be used by the zmconfig.pl script. However you can build up your own list
//     quite easily from the Config table in the database if necessary.
// 3. The tokens listed below are not used to build up phrases or sentences from single words. Therefore
//   you can safely assume that a single word token will only be used in that context.
// 4. In new language files, or if you are changing only a few words or phrases it makes sense from a 
//   maintenance point of view to include the original language file and override the old definitions rather
//   than copy all the language tokens across. To do this change the line below to whatever your base language
//   is and uncomment it.
//require_once( 'zm_lang_en_gb.php' );

// You may need to change the character set here, if your web server does not already
// do this by default, uncomment this if required.
//
// Example
//header( "Content-Type: text/html; charset=iso-8859-2" );

// You may need to change your locale here if your default one is incorrect for the
// language described in this file, or if you have multiple languages supported.
// If you do need to change your locale, be aware that the format of this function
// is subtlely different in versions of PHP before and after 4.3.0, see
// http://uk2.php.net/manual/en/function.setlocale.php for details.
// Also be aware that changing the whole locale may affect some floating point or decimal 
// arithmetic in the database, if this is the case change only the individual locale areas
// that don't affect this rather than all at once. See the examples below.
// Finally, depending on your setup, PHP may not enjoy have multiple locales in a shared 
// threaded environment, if you get funny errors it may be this.
//
// Examples
//setlocale( 'LC_ALL', 'cs_CZ' ); All locale settings pre-4.3.0
// setlocale( LC_ALL, 'en_GB' ); All locale settings 4.3.0 and after
// setlocale( LC_CTYPE, 'en_GB' ); Character class settings 4.3.0 and after
// setlocale( LC_TIME, 'en_GB' ); Date and time formatting 4.3.0 and after

// Simple String Replacements
$SLANG = array(
    '24BitColour'          => '24 bit barevn',
    '32BitColour'          => '32 bit barevn',          // Added - 2011-06-15
    '8BitGrey'             => '8 bit ed kla',
    'Action'               => 'Akce',
    'Actual'               => 'Skuten',
    'AddNewControl'        => 'Pidat nov zen',
    'AddNewMonitor'        => 'Pidat kameru',
    'AddNewUser'           => 'Pidat uivatele',
    'AddNewZone'           => 'Pidat znu',
    'Alarm'                => 'Alarm',
    'AlarmBrFrames'        => 'Alarm<br/>Snmky',
    'AlarmFrame'           => 'Alarm snmek',
    'AlarmFrameCount'      => 'Poet alarm snmk',
    'AlarmLimits'          => 'Limity alarmu',
    'AlarmMaximumFPS'      => 'Alarm Maximum FPS',
    'AlarmPx'              => 'Alarm Px',
    'AlarmRGBUnset'        => 'You must set an alarm RGB colour',
    'Alert'                => 'Pozor',
    'All'                  => 'Vechny',
    'Apply'                => 'Pout',
    'ApplyingStateChange'  => 'Aplikuji zmnu stavu',
    'ArchArchived'         => 'Pouze archivovan',
    'ArchUnarchived'       => 'Pouze nearchivovan',
    'Archive'              => 'Archiv',
    'Archived'             => 'Archivovn',
    'Area'                 => 'Area',
    'AreaUnits'            => 'Area (px/%)',
    'AttrAlarmFrames'      => 'Alarm snmky',
    'AttrArchiveStatus'    => 'Archiv status',
    'AttrAvgScore'         => 'Prm. skre',
    'AttrCause'            => 'Pina',
    'AttrDate'             => 'Datum',
    'AttrDateTime'         => 'Datum/as',
    'AttrDiskBlocks'       => 'Bloky disku',
    'AttrDiskPercent'      => 'Zaplnn disku',
    'AttrDuration'         => 'Prbh',
    'AttrFrames'           => 'Snmky',
    'AttrId'               => 'Id',
    'AttrMaxScore'         => 'Max. skre',
    'AttrMonitorId'        => 'Kamera Id',
    'AttrMonitorName'      => 'Jmno kamery',
    'AttrName'             => 'Jmno',
    'AttrNotes'            => 'Notes',
    'AttrSystemLoad'       => 'System Load',
    'AttrTime'             => 'as',
    'AttrTotalScore'       => 'Celkov skre',
    'AttrWeekday'          => 'Den v tdnu',
    'Auto'                 => 'Auto',
    'AutoStopTimeout'      => 'asov limit pro vypren',
    'Available'            => 'Available',              // Added - 2009-03-31
    'AvgBrScore'           => 'Prm.<br/>Skre',
    'Background'           => 'Background',
    'BackgroundFilter'     => 'Run filter in background',
    'BadAlarmFrameCount'   => 'Alarm frame count must be an integer of one or more',
    'BadAlarmMaxFPS'       => 'Alarm Maximum FPS must be a positive integer or floating point value',
    'BadChannel'           => 'Channel must be set to an integer of zero or more',
    'BadColours'           => 'Target colour must be set to a valid value', // Added - 2011-06-15
    'BadDevice'            => 'Device must be set to a valid value',
    'BadFPSReportInterval' => 'FPS report interval buffer count must be an integer of 0 or more',
    'BadFormat'            => 'Format must be set to an integer of zero or more',
    'BadFrameSkip'         => 'Frame skip count must be an integer of zero or more',
    'BadMotionFrameSkip'   => 'Motion Frame skip count must be an integer of zero or more',
    'BadHeight'            => 'Height must be set to a valid value',
    'BadHost'              => 'Host must be set to a valid ip address or hostname, do not include http://',
    'BadImageBufferCount'  => 'Image buffer size must be an integer of 10 or more',
    'BadLabelX'            => 'Label X co-ordinate must be set to an integer of zero or more',
    'BadLabelY'            => 'Label Y co-ordinate must be set to an integer of zero or more',
    'BadMaxFPS'            => 'Maximum FPS must be a positive integer or floating point value',
    'BadNameChars'         => 'Jmna moho obsahovat pouze alfanumerick znaky a podtrtko i pomlku',
    'BadPalette'           => 'Palette must be set to a valid value', // Added - 2009-03-31
    'BadPath'              => 'Path must be set to a valid value',
    'BadPort'              => 'Port must be set to a valid number',
    'BadPostEventCount'    => 'Post event image count must be an integer of zero or more',
    'BadPreEventCount'     => 'Pre event image count must be at least zero, and less than image buffer size',
    'BadRefBlendPerc'      => 'Reference blend percentage must be a positive integer',
    'BadSectionLength'     => 'Section length must be an integer of 30 or more',
    'BadSignalCheckColour' => 'Signal check colour must be a valid RGB colour string',
    'BadStreamReplayBuffer'=> 'Stream replay buffer must be an integer of zero or more',
    'BadWarmupCount'       => 'Warmup frames must be an integer of zero or more',
    'BadWebColour'         => 'Web colour must be a valid web colour string',
    'BadWidth'             => 'Width must be set to a valid value',
    'Bandwidth'            => 'Rychlost st',
    'BandwidthHead'        => 'Bandwidth',	// This is the end of the bandwidth status on the top of the console, different in many language due to phrasing
    'BlobPx'               => 'Znaka Px',
    'BlobSizes'            => 'Velikost znaky',
    'Blobs'                => 'Znaky',
    'Brightness'           => 'Svtlost',
    'Buffers'              => 'Bufery',
    'CanAutoFocus'         => 'Um automaticky zaostit',
    'CanAutoGain'          => 'Um automatick zisk',
    'CanAutoIris'          => 'Um auto iris',
    'CanAutoWhite'         => 'Um automaticky vyvit blou',
    'CanAutoZoom'          => 'Um automaticky zoomovat',
    'CanFocus'             => 'Um zaostit',
    'CanFocusAbs'          => 'Um zaostit absolutn',
    'CanFocusCon'          => 'Um prbn zaostit',
    'CanFocusRel'          => 'Um relativn zaostit',
    'CanGain'              => 'Um zisk',
    'CanGainAbs'           => 'Um absolutn zisk',
    'CanGainCon'           => 'Um prbn zisk',
    'CanGainRel'           => 'Um relativn zisk',
    'CanIris'              => 'Um iris',
    'CanIrisAbs'           => 'Um absolutn iris',
    'CanIrisCon'           => 'Um prbn iris',
    'CanIrisRel'           => 'Um relativn iris',
    'CanMove'              => 'Um pohyb',
    'CanMoveAbs'           => 'Um absoultn pohyb',
    'CanMoveCon'           => 'Um prbn pohyb',
    'CanMoveDiag'          => 'Um diagonln pohyb',
    'CanMoveMap'           => 'Um mapovan pohyb',
    'CanMoveRel'           => 'Um relativn pohyb',
    'CanPan'               => 'Um oten',
    'CanReset'             => 'Um reset',
    'CanSetPresets'        => 'Um navolit pedvolby',
    'CanSleep'             => 'Me spt',
    'CanTilt'              => 'Um nklon',
    'CanWake'              => 'Lze vzbudit',
    'CanWhite'             => 'Um vyven bl',
    'CanWhiteAbs'          => 'Um absolutn vyven bl',
    'CanWhiteBal'          => 'Um vyven bl',
    'CanWhiteCon'          => 'Um prbn vyven bl',
    'CanWhiteRel'          => 'Um relativn vyven bl',
    'CanZoom'              => 'Um zoom',
    'CanZoomAbs'           => 'Um absolutn zoom',
    'CanZoomCon'           => 'Um prbn zoom',
    'CanZoomRel'           => 'Um relativn zoom',
    'Cancel'               => 'Zruit',
    'CancelForcedAlarm'    => 'Zastavit sputn alarm',
    'CaptureHeight'        => 'Vka zdrojovho snmku',
    'CaptureMethod'        => 'Capture Method',         // Added - 2009-02-08
    'CapturePalette'       => 'Paleta zdrojovho snmku',
    'CaptureWidth'         => 'ka zdrojovho snmku',
    'Cause'                => 'Pina',
    'CheckMethod'          => 'Metoda znakovn alarmem',
    'ChooseDetectedCamera' => 'Choose Detected Camera', // Added - 2009-03-31
    'ChooseFilter'         => 'Vybrat filtr',
    'ChooseLogFormat'      => 'Choose a log format',    // Added - 2011-06-17
    'ChooseLogSelection'   => 'Choose a log selection', // Added - 2011-06-17
    'ChoosePreset'         => 'Choose Preset',
    'Clear'                => 'Clear',                  // Added - 2011-06-16
    'Close'                => 'Zavt',
    'Colour'               => 'Barva',
    'Command'              => 'Pkaz',
    'Component'            => 'Component',              // Added - 2011-06-16
    'Config'               => 'Nastaven',
    'ConfiguredFor'        => 'Nastaveno pro',
    'ConfirmDeleteEvents'  => 'Are you sure you wish to delete the selected events?',
    'ConfirmPassword'      => 'Potvrdit heslo',
    'ConjAnd'              => 'a',
    'ConjOr'               => 'nebo',
    'Console'              => 'Konzola',
    'ContactAdmin'         => 'Pro detailn info kontaktujte Vaeho administrtora.',
    'Continue'             => 'Pokraovat',
    'Contrast'             => 'Kontrast',
    'Control'              => 'zen',
    'ControlAddress'       => 'Adresa zen',
    'ControlCap'           => 'Schopnosti zen',
    'ControlCaps'          => 'Typy zen',
    'ControlDevice'        => 'Zazen zen',
    'ControlType'          => 'Typ zen',
    'Controllable'         => 'diteln',
    'Cycle'                => 'Cyklus',
    'CycleWatch'           => 'Cyklick prohlen',
    'DateTime'             => 'Date/Time',              // Added - 2011-06-16
    'Day'                  => 'Den',
    'Debug'                => 'Debug',
    'DefaultRate'          => 'Default Rate',
    'DefaultScale'         => 'Pednastaven velikost',
    'DefaultView'          => 'Default View',
    'Delete'               => 'Smazat',
    'DeleteAndNext'        => 'Smazat &amp; Dal',
    'DeleteAndPrev'        => 'Smazat &amp; Pedchoz',
    'DeleteSavedFilter'    => 'Smazat filtr',
    'Description'          => 'Popis',
    'DetectedCameras'      => 'Detected Cameras',       // Added - 2009-03-31
    'Device'               => 'Device',                 // Added - 2009-02-08
    'DeviceChannel'        => 'Kanl zazen',
    'DeviceFormat'         => 'Formt zazen',
    'DeviceNumber'         => 'slo zarzen',
    'DevicePath'           => 'Cesta k zazen',
    'Devices'              => 'Devices',
    'Dimensions'           => 'Rozmry',
    'DisableAlarms'        => 'Zakzat alarmy',
    'Disk'                 => 'Disk',
    'Display'              => 'Display',                // Added - 2011-01-30
    'Displaying'           => 'Displaying',             // Added - 2011-06-16
    'Donate'               => 'Prosm podpote',
    'DonateAlready'        => 'Ne, u jsem podpoil',
    'DonateEnticement'     => 'Ji njakou dobu pouvte software ZoneMinder k ochran svho majetku a pedpokldm, e jej shledvte uitenm. Pestoe je ZoneMinder, znovu pipomnm, zdarma a voln en software, stoj jeho vvoj a podpora njak penze. Pokud byste chtl/a podpoit budouc vvoj a nov monosti softwaru, prosm zvate darovn finann pomoci. Darovn je, samozejm, dobrovoln, ale zato velmi cenn mete pispt jakou stkou chcete.<br><br>Pokud mte zjem podpoit n tm, prosm, vyberte ne uvedenou monost, nebo navtivte http://www.zoneminder.com/donate.html.<br><br>Dkuji Vm e jste si vybral/a software ZoneMinder a nezapomete navtvit frum na ZoneMinder.com pro podporu a nvrhy jak udlat ZoneMinder jet lepm ne je dnes.',
    'DonateRemindDay'      => 'Nyn ne, pipomenout za 1 den',
    'DonateRemindHour'     => 'Nyn ne, pipomenout za hodinu',
    'DonateRemindMonth'    => 'Nyn ne, pipomenout za msc',
    'DonateRemindNever'    => 'Ne, nechci podpoit ZoneMinder, nepipomnat',
    'DonateRemindWeek'     => 'Nyn ne, pipomenout za tden',
    'DonateYes'            => 'Ano, chcit podpoit ZoneMinder nyn',
    'DoNativeMotionDetection'=> 'Do Native Motion Detection',
    'Download'             => 'Sthnout',
    'DuplicateMonitorName' => 'Duplicate Monitor Name', // Added - 2009-03-31
    'Duration'             => 'Prbh',
    'Edit'                 => 'Editovat',
    'Email'                => 'Email',
    'EnableAlarms'         => 'Povolit alarmy',
    'Enabled'              => 'Povoleno',
    'EnterNewFilterName'   => 'Zadejte nov jmno filtru',
    'Error'                => 'Chyba',
    'ErrorBrackets'        => 'Chyba, zkontrolujte prosm zvorky',
    'ErrorValidValue'      => 'Chyba, zkontrolujte e podmnky maj sprvn hodnoty',
    'Etc'                  => 'atd',
    'Event'                => 'Zznam',
    'EventFilter'          => 'Filtr zznam',
    'EventId'              => 'Id zznamu',
    'EventName'            => 'Jmno zznamu',
    'EventPrefix'          => 'Prefix zznamu',
    'Events'               => 'Zznamy',
    'Exclude'              => 'Vyjmout',
    'Execute'              => 'Execute',
    'Export'               => 'Exportovat',
    'ExportDetails'        => 'Exportovat detaily zznamu',
    'ExportFailed'         => 'Chyba pi exportu',
    'ExportFormat'         => 'Formt exportovanho souboru',
    'ExportFormatTar'      => 'Tar',
    'ExportFormatZip'      => 'Zip',
    'ExportFrames'         => 'Exportovat detaily snmku',
    'ExportImageFiles'     => 'Exportovat obrazov soubory',
    'ExportLog'            => 'Export Log',             // Added - 2011-06-17
    'ExportMiscFiles'      => 'Exportovat ostatn soubory (jestli existuj)',
    'ExportOptions'        => 'Monosti exportu',
    'ExportSucceeded'      => 'Export Succeeded',       // Added - 2009-02-08
    'ExportVideoFiles'     => 'Exportovat video soubory (jestli existuj)',
    'Exporting'            => 'Exportuji',
    'FPS'                  => 'fps',
    'FPSReportInterval'    => 'FPS Interval pro report',
    'FTP'                  => 'FTP',
    'Far'                  => 'Daleko',
    'FastForward'          => 'Fast Forward',
    'Feed'                 => 'Nasytit',
    'Ffmpeg'               => 'Ffmpeg',                 // Added - 2009-02-08
    'File'                 => 'Soubor',
    'FilterArchiveEvents'  => 'Archivovat vechny nalezen',
    'FilterDeleteEvents'   => 'Smazat vechny nalezen',
    'FilterEmailEvents'    => 'Poslat email s detaily nalezench',
    'FilterExecuteEvents'  => 'Spustit pkaz na vech nalezench',
    'FilterMessageEvents'  => 'Podat zprvu o vech nalezench',
    'FilterPx'             => 'Filtr Px',
    'FilterUnset'          => 'You must specify a filter width and height',
    'FilterUploadEvents'   => 'Uploadovat nalezen',
    'FilterVideoEvents'    => 'Create video for all matches',
    'Filters'              => 'Filtry',
    'First'                => 'Prvn',
    'FlippedHori'          => 'Peklopen vodorovn',
    'FlippedVert'          => 'Peklopen svisle',
    'FnNone'                => 'None',            // Added 2013.08.16.
    'FnMonitor'             => 'Monitor',            // Added 2013.08.16.
    'FnModect'              => 'Modect',            // Added 2013.08.16.
    'FnRecord'              => 'Record',            // Added 2013.08.16.
    'FnMocord'              => 'Mocord',            // Added 2013.08.16.
    'FnNodect'              => 'Nodect',            // Added 2013.08.16.
    'Focus'                => 'Zaosten',
    'ForceAlarm'           => 'Spustit alarm',
    'Format'               => 'Formt',
    'Frame'                => 'Snmek',
    'FrameId'              => 'Snmek Id',
    'FrameRate'            => 'Rychlost snmk',
    'FrameSkip'            => 'Vynechat snmek',
    'MotionFrameSkip'      => 'Motion Frame Skip',
    'Frames'               => 'Snmky',
    'Func'                 => 'Funkce',
    'Function'             => 'Funkce',
    'Gain'                 => 'Zisk',
    'General'              => 'General',
    'GenerateVideo'        => 'Generovat video',
    'GeneratingVideo'      => 'Generuji video',
    'GoToZoneMinder'       => 'Jt na ZoneMinder.com',
    'Grey'                 => 'ed',
    'Group'                => 'Group',
    'Groups'               => 'Skupiny',
    'HasFocusSpeed'        => 'M rychlost zaosten',
    'HasGainSpeed'         => 'M rychlost zisku',
    'HasHomePreset'        => 'M Home volbu',
    'HasIrisSpeed'         => 'M rychlost irisu',
    'HasPanSpeed'          => 'M rychlost oten',
    'HasPresets'           => 'M pedvolby',
    'HasTiltSpeed'         => 'M rychlost nklonu',
    'HasTurboPan'          => 'M Turbo oten',
    'HasTurboTilt'         => 'M Turbo nklon',
    'HasWhiteSpeed'        => 'M rychlost vyven bl',
    'HasZoomSpeed'         => 'M rychlost zoomu',
    'High'                 => 'Rychl',
    'HighBW'               => 'Rychl&nbsp;B/W',
    'Home'                 => 'Dom',
    'Hour'                 => 'Hodina',
    'Hue'                  => 'Odstn',
    'Id'                   => 'Id',
    'Idle'                 => 'Pipraven',
    'Ignore'               => 'Ignorovat',
    'Image'                => 'Obraz',
    'ImageBufferSize'      => 'Velikost buferu snmk',
    'Images'               => 'Images',
    'In'                   => 'Dovnit',
    'Include'              => 'Vloit',
    'Inverted'             => 'Pevrcen',
    'Iris'                 => 'Iris',
    'KeyString'            => 'Key String',
    'Label'                => 'Label',
    'Language'             => 'Jazyk',
    'Last'                 => 'Posledn',
    'Layout'               => 'Layout',                 // Added - 2009-02-08
    'Level'                => 'Level',                  // Added - 2011-06-16
    'Libvlc'               => 'Libvlc',
    'LimitResultsPost'     => 'vsledk', // This is used at the end of the phrase 'Limit to first N results only'
    'LimitResultsPre'      => 'Zobrazit pouze prvnch', // This is used at the beginning of the phrase 'Limit to first N results only'
    'Line'                 => 'Line',                   // Added - 2011-06-16
    'LinkedMonitors'       => 'Linked Monitors',
    'List'                 => 'Seznam',
    'Load'                 => 'Load',
    'Local'                => 'Lokln',
    'Log'                  => 'Log',                    // Added - 2011-06-16
    'LoggedInAs'           => 'Pihlen jako',
    'Logging'              => 'Logging',                // Added - 2011-06-16
    'LoggingIn'            => 'Pihlauji',
    'Login'                => 'Pihlsit',
    'Logout'               => 'Odhlsit',
    'Logs'                 => 'Logs',                   // Added - 2011-06-17
    'Low'                  => 'Pomal',
    'LowBW'                => 'Pomal&nbsp;B/W',
    'Main'                 => 'Hlavn',
    'Man'                  => 'Man',
    'Manual'               => 'Manul',
    'Mark'                 => 'Oznait',
    'Max'                  => 'Max',
    'MaxBandwidth'         => 'Max bandwidth',
    'MaxBrScore'           => 'Max.<br/>skre',
    'MaxFocusRange'        => 'Max rozsah zaosten',
    'MaxFocusSpeed'        => 'Max rychlost zaosten',
    'MaxFocusStep'         => 'Max krok zaosten',
    'MaxGainRange'         => 'Max rozsah zisku',
    'MaxGainSpeed'         => 'Max rychlost zisku',
    'MaxGainStep'          => 'Max krok zisku',
    'MaxIrisRange'         => 'Max rozsah iris',
    'MaxIrisSpeed'         => 'Max rychlost iris',
    'MaxIrisStep'          => 'Max krok iris',
    'MaxPanRange'          => 'Max rozsah oten',
    'MaxPanSpeed'          => 'Max rychlost oten',
    'MaxPanStep'           => 'Max krok oten',
    'MaxTiltRange'         => 'Max rozsah nklonu',
    'MaxTiltSpeed'         => 'Max rychlost nklonu',
    'MaxTiltStep'          => 'Max krok nklonu',
    'MaxWhiteRange'        => 'Max rozsah vyven bl',
    'MaxWhiteSpeed'        => 'Max rychlost vyven bl',
    'MaxWhiteStep'         => 'Max krok vyven bl',
    'MaxZoomRange'         => 'Max rozsah zoomu',
    'MaxZoomSpeed'         => 'Max rychlost zoomu',
    'MaxZoomStep'          => 'Max krok zoomu',
    'MaximumFPS'           => 'Maximum FPS',
    'Medium'               => 'Stedn',
    'MediumBW'             => 'Stedn&nbsp;B/W',
    'Message'              => 'Message',                // Added - 2011-06-16
    'MinAlarmAreaLtMax'    => 'Minimum alarm area should be less than maximum',
    'MinAlarmAreaUnset'    => 'You must specify the minimum alarm pixel count',
    'MinBlobAreaLtMax'     => 'Minimum znakovan oblasti by mlo bt men ne maximum',
    'MinBlobAreaUnset'     => 'You must specify the minimum blob pixel count',
    'MinBlobLtMinFilter'   => 'Minimum blob area should be less than or equal to minimum filter area',
    'MinBlobsLtMax'        => 'Minimum znaek by mlo bt men ne maximum',
    'MinBlobsUnset'        => 'You must specify the minimum blob count',
    'MinFilterAreaLtMax'   => 'Minimum filter area should be less than maximum',
    'MinFilterAreaUnset'   => 'You must specify the minimum filter pixel count',
    'MinFilterLtMinAlarm'  => 'Minimum filter area should be less than or equal to minimum alarm area',
    'MinFocusRange'        => 'Min rozsah zaosten',
    'MinFocusSpeed'        => 'Min rychlost zaosten',
    'MinFocusStep'         => 'Min krok zaosten',
    'MinGainRange'         => 'Min rozsah zisku',
    'MinGainSpeed'         => 'Min rychlost zisku',
    'MinGainStep'          => 'Min krok zisku',
    'MinIrisRange'         => 'Min rozsah iris',
    'MinIrisSpeed'         => 'Min rychlost iris',
    'MinIrisStep'          => 'Min krok iris',
    'MinPanRange'          => 'Min rozsah oten',
    'MinPanSpeed'          => 'Min rychlost oten',
    'MinPanStep'           => 'Min krok oten',
    'MinPixelThresLtMax'   => 'Minimln prh pixelu by ml bt men ne  maximumln',
    'MinPixelThresUnset'   => 'You must specify a minimum pixel threshold',
    'MinTiltRange'         => 'Min rozsah nklonu',
    'MinTiltSpeed'         => 'Min rychlost nklonu',
    'MinTiltStep'          => 'Min krok nklonu',
    'MinWhiteRange'        => 'Min rozsah vyven bl',
    'MinWhiteSpeed'        => 'Min rychlost vyven bl',
    'MinWhiteStep'         => 'Min krok vyven bl',
    'MinZoomRange'         => 'Min rozsah zoomu',
    'MinZoomSpeed'         => 'Min rychlost zoomu',
    'MinZoomStep'          => 'Min krok zoomu',
    'Misc'                 => 'Ostatn',
    'Monitor'              => 'Kamera',
    'MonitorIds'           => 'Id&nbsp;kamer',
    'MonitorPreset'        => 'Monitor Preset',
    'MonitorPresetIntro'   => 'Select an appropriate preset from the list below.<br><br>Please note that this may overwrite any values you already have configured for this monitor.<br><br>',
    'MonitorProbe'         => 'Monitor Probe',          // Added - 2009-03-31
    'MonitorProbeIntro'    => 'The list below shows detected analog and network cameras and whether they are already being used or available for selection.<br/><br/>Select the desired entry from the list below.<br/><br/>Please note that not all cameras may be detected and that choosing a camera here may overwrite any values you already have configured for the current monitor.<br/><br/>', // Added - 2009-03-31
    'Monitors'             => 'Kamery',
    'Montage'              => 'Sestih',
    'Month'                => 'Msc',
    'More'                 => 'More',                   // Added - 2011-06-16
    'Move'                 => 'Pohyb',
    'MtgDefault'           => 'Default',              // Added 2013.08.15.
    'Mtg2widgrd'           => '2-wide grid',              // Added 2013.08.15.
    'Mtg3widgrd'           => '3-wide grid',              // Added 2013.08.15.
    'Mtg4widgrd'           => '4-wide grid',              // Added 2013.08.15.
    'Mtg3widgrx'           => '3-wide grid, scaled, enlarge on alarm',              // Added 2013.08.15.
    'MustBeGe'             => 'mus bt vt nebo rovno ne',
    'MustBeLe'             => 'mus bt men nebo rovno ne',
    'MustConfirmPassword'  => 'Muste potvrdit heslo',
    'MustSupplyPassword'   => 'Muste zadat heslo',
    'MustSupplyUsername'   => 'Muste zadat uivatelsk jmno',
    'Name'                 => 'Jmno',
    'Near'                 => 'Blzko',
    'Network'              => 'S',
    'New'                  => 'Nov',
    'NewGroup'             => 'Nov skupina',
    'NewLabel'             => 'New Label',
    'NewPassword'          => 'Nov heslo',
    'NewState'             => 'Nov stav',
    'NewUser'              => 'Nov uivatel',
    'Next'                 => 'Dal',
    'No'                   => 'Ne',
    'NoDetectedCameras'    => 'No Detected Cameras',    // Added - 2009-03-31
    'NoFramesRecorded'     => 'Pro tento snmek nejsou dn zznamy',
    'NoGroup'              => 'No Group',
    'NoSavedFilters'       => 'dn uloen filtry',
    'NoStatisticsRecorded' => 'Pro tento zznam/snmek nejsou zaznamenny dn statistiky',
    'None'                 => 'Zakzat',
    'NoneAvailable'        => 'dn nen dostupn',
    'Normal'               => 'Normaln',
    'Notes'                => 'Poznmky',
    'NumPresets'           => 'Poet pedvoleb',
    'Off'                  => 'Off',
    'On'                   => 'On',
    'OpEq'                 => 'rovno',
    'OpGt'                 => 'vt',
    'OpGtEq'               => 'vt nebo rovno',
    'OpIn'                 => 'nin set',
    'OpLt'                 => 'men',
    'OpLtEq'               => 'men nebo rovno',
    'OpMatches'            => 'obsahuje',
    'OpNe'                 => 'nerovn se',
    'OpNotIn'              => 'nnot in set',
    'OpNotMatches'         => 'neobsahuje',
    'Open'                 => 'Otevt',
    'OptionHelp'           => 'MonostHelp',
    'OptionRestartWarning' => 'Tyto zmny se neprojev\ndokud systm b. Jakmile\ndokonte provdn zmn prosm\nrestartujte ZoneMinder.',
    'Options'              => 'Monosti',
    'OrEnterNewName'       => 'nebo vlote nov jmno',
    'Order'                => 'Poad',
    'Orientation'          => 'Orientace',
    'Out'                  => 'Ven',
    'OverwriteExisting'    => 'Pepsat existujc',
    'Paged'                => 'Strkov',
    'Pan'                  => 'Oten',
    'PanLeft'              => 'Posunout vlevo',
    'PanRight'             => 'Posunout vpravo',
    'PanTilt'              => 'Oten/Nklon',
    'Parameter'            => 'Parametr',
    'Password'             => 'Heslo',
    'PasswordsDifferent'   => 'Hesla se neshoduj',
    'Paths'                => 'Cesty',
    'Pause'                => 'Pause',
    'Phone'                => 'Modem',
    'PhoneBW'              => 'Modem&nbsp;B/W',
    'Pid'                  => 'PID',                    // Added - 2011-06-16
    'PixelDiff'            => 'Pixel Diff',
    'Pixels'               => 'pixely',
    'Play'                 => 'Play',
    'PlayAll'              => 'Pehrt ve',
    'PleaseWait'           => 'Prosm ekejte',
    'Plugins'              => 'Plugins',
    'Point'                => 'Point',
    'PostEventImageBuffer' => 'Pozznamov bufer',
    'PreEventImageBuffer'  => 'Pedzznamov bufer',
    'PreserveAspect'       => 'Preserve Aspect Ratio',
    'Preset'               => 'Pedvolba',
    'Presets'              => 'Pedvolby',
    'Prev'                 => 'Zpt',
    'Probe'                => 'Probe',                  // Added - 2009-03-31
    'Protocol'             => 'Protocol',
    'Rate'                 => 'Rychlost',
    'Real'                 => 'Skuten',
    'Record'               => 'Nahrvat',
    'RefImageBlendPct'     => 'Reference Image Blend %ge',
    'Refresh'              => 'Obnovit',
    'Remote'               => 'Sov',
    'RemoteHostName'       => 'Adresa',
    'RemoteHostPath'       => 'Cesta',
    'RemoteHostPort'       => 'Port',
    'RemoteHostSubPath'    => 'Remote Host SubPath',    // Added - 2009-02-08
    'RemoteImageColours'   => 'Barvy',
    'RemoteMethod'         => 'Remote Method',          // Added - 2009-02-08
    'RemoteProtocol'       => 'Remote Protocol',        // Added - 2009-02-08
    'Rename'               => 'Pejmenovat',
    'Replay'               => 'Replay',
    'ReplayAll'            => 'All Events',
    'ReplayGapless'        => 'Gapless Events',
    'ReplaySingle'         => 'Single Event',
    'Reset'                => 'Reset',
    'ResetEventCounts'     => 'Resetovat poty zznam',
    'Restart'              => 'Restartovat',
    'Restarting'           => 'Restartuji',
    'RestrictedCameraIds'  => 'Povolen id kamer',
    'RestrictedMonitors'   => 'Restricted Monitors',
    'ReturnDelay'          => 'Prodleva vracen',
    'ReturnLocation'       => 'Lokace vrcen',
    'Rewind'               => 'Rewind',
    'RotateLeft'           => 'Otoit vlevo',
    'RotateRight'          => 'Otoit vpravo',
    'RunLocalUpdate'       => 'Please run zmupdate.pl to update', // Added - 2011-05-25
    'RunMode'              => 'Reim',
    'RunState'             => 'Stav',
    'Running'              => 'B',
    'Save'                 => 'Uloit',
    'SaveAs'               => 'Uloit jako',
    'SaveFilter'           => 'Uloit filtr',
    'Scale'                => 'Velikost',
    'Score'                => 'Skre',
    'Secs'                 => 'Dlka(s)',
    'Sectionlength'        => 'Dlka sekce',
    'Select'               => 'Vybrat',
    'SelectFormat'         => 'Select Format',          // Added - 2011-06-17
    'SelectLog'            => 'Select Log',             // Added - 2011-06-17
    'SelectMonitors'       => 'Select Monitors',
    'SelfIntersecting'     => 'Polygon edges must not intersect',
    'Set'                  => 'Nastavit',
    'SetNewBandwidth'      => 'Nastavit novou rychlost st',
    'SetPreset'            => 'Nastavit pedvolbu',
    'Settings'             => 'Nastaven',
    'ShowFilterWindow'     => 'Zobrazit filtr',
    'ShowTimeline'         => 'Zobrazit asovou linii ',
    'SignalCheckColour'    => 'Signal Check Colour',
    'Size'                 => 'Velikost',
    'SkinDescription'      => 'Change the default skin for this computer', // Added - 2011-01-30
    'Sleep'                => 'Spt',
    'SortAsc'              => 'Vzestupn',
    'SortBy'               => 'adit dle',
    'SortDesc'             => 'Sestupn',
    'Source'               => 'Zdroj',
    'SourceColours'        => 'Source Colours',         // Added - 2009-02-08
    'SourcePath'           => 'Source Path',            // Added - 2009-02-08
    'SourceType'           => 'Typ zdroje',
    'Speed'                => 'Rychlost',
    'SpeedHigh'            => 'Vysok rychlost',
    'SpeedLow'             => 'Nzk rychlost',
    'SpeedMedium'          => 'Stedn rychlost',
    'SpeedTurbo'           => 'Turbo rychlost',
    'Start'                => 'Start',
    'State'                => 'Stav',
    'Stats'                => 'Statistiky',
    'Status'               => 'Status',
    'Step'                 => 'Krok',
    'StepBack'             => 'Step Back',
    'StepForward'          => 'Step Forward',
    'StepLarge'            => 'Velk krok',
    'StepMedium'           => 'Stedn krok',
    'StepNone'             => 'dn krok',
    'StepSmall'            => 'Mal krok',
    'Stills'               => 'Snmky',
    'Stop'                 => 'Zastavit',
    'Stopped'              => 'Zastaven',
    'Stream'               => 'Stream',
    'StreamReplayBuffer'   => 'Stream Replay Image Buffer',
    'Submit'               => 'Potvrdit',
    'System'               => 'System',
    'SystemLog'            => 'System Log',             // Added - 2011-06-16
    'Tele'                 => 'Piblit',
    'Thumbnail'            => 'Miniatura',
    'Tilt'                 => 'Nklon',
    'Time'                 => 'as',
    'TimeDelta'            => 'Delta asu',
    'TimeStamp'            => 'asov raztko',
    'Timeline'             => 'asov linie',
    'TimelineTip1'          => 'Pass your mouse over the graph to view a snapshot image and event details.',              // Added 2013.08.15.
    'TimelineTip2'          => 'Click on the coloured sections of the graph, or the image, to view the event.',              // Added 2013.08.15.
    'TimelineTip3'          => 'Click on the background to zoom in to a smaller time period based around your click.',              // Added 2013.08.15.
    'TimelineTip4'          => 'Use the controls below to zoom out or navigate back and forward through the time range.',              // Added 2013.08.15.
    'Timestamp'            => 'Raztko',
    'TimestampLabelFormat' => 'Formt asovho raztka',
    'TimestampLabelX'      => 'asov raztko X',
    'TimestampLabelY'      => 'asov raztko Y',
    'Today'                => 'Dnes',
    'Tools'                => 'Nstroje',
    'Total'                => 'Total',                  // Added - 2011-06-16
    'TotalBrScore'         => 'Celkov<br/>skre',
    'TrackDelay'           => 'Prodleva drhy',
    'TrackMotion'          => 'Pohyb po drze',
    'Triggers'             => 'Trigery',
    'TurboPanSpeed'        => 'Rychlost Turbo oten',
    'TurboTiltSpeed'       => 'Rychlost Turbo nklonu',
    'Type'                 => 'Typ',
    'Unarchive'            => 'Vyjmout z archivu',
    'Undefined'            => 'Undefined',              // Added - 2009-02-08
    'Units'                => 'Jednotky',
    'Unknown'              => 'Neznm',
    'Update'               => 'Update',
    'UpdateAvailable'      => 'Je dostupn nov update ZoneMinder.',
    'UpdateNotNecessary'   => 'Update nen poteba.',
    'Updated'              => 'Updated',                // Added - 2011-06-16
    'Upload'               => 'Upload',                 // Added - 2011-08-23
    'UsedPlugins'	   => 'Used Plugins',
    'UseFilter'            => 'Pout filtr',
    'UseFilterExprsPost'   => '&nbsp;vraz', // This is used at the end of the phrase 'use N filter expressions'
    'UseFilterExprsPre'    => 'Pout&nbsp;', // This is used at the beginning of the phrase 'use N filter expressions'
    'User'                 => 'Uivatel',
    'Username'             => 'Uivatelsk jmno',
    'Users'                => 'Uivatel',
    'Value'                => 'Hodnota',
    'Version'              => 'Verze',
    'VersionIgnore'        => 'Ignorovat tuto verzi',
    'VersionRemindDay'     => 'Pipomenout za 1 den',
    'VersionRemindHour'    => 'Pipomenout za hodinu',
    'VersionRemindNever'   => 'Nepipomnat nov veze',
    'VersionRemindWeek'    => 'Pipomenout za tden',
    'Video'                => 'Video',
    'VideoFormat'          => 'Video formt',
    'VideoGenFailed'       => 'Chyba pi generovn videa!',
    'VideoGenFiles'        => 'Existujc video soubory',
    'VideoGenNoFiles'      => 'dn video soubory nenalezeny',
    'VideoGenParms'        => 'Parametry generovn videa',
    'VideoGenSucceeded'    => 'Video vygenerovno spn!',
    'VideoSize'            => 'Velikost videa',
    'View'                 => 'Zobrazit',
    'ViewAll'              => 'Zobrazit vechny',
    'ViewEvent'            => 'Zobrazit zznam',
    'ViewPaged'            => 'Zobrazit strkov',
    'Wake'                 => 'Vzbudit',
    'WarmupFrames'         => 'Zahvac snmky',
    'Watch'                => 'Sledovat',
    'Web'                  => 'Web',
    'WebColour'            => 'Webov barva',
    'Week'                 => 'Tden',
    'White'                => 'Bl',
    'WhiteBalance'         => 'Vyven bl',
    'Wide'                 => 'Oddlit',
    'X'                    => 'X',
    'X10'                  => 'X10',
    'X10ActivationString'  => 'X10 aktivan etzec',
    'X10InputAlarmString'  => 'X10 input alarm etzec',
    'X10OutputAlarmString' => 'X10 output alarm etzec',
    'Y'                    => 'Y',
    'Yes'                  => 'Ano',
    'YouNoPerms'           => 'K tomuto zdroji nemte oprvnn.',
    'Zone'                 => 'Zna',
    'ZoneAlarmColour'      => 'Barva alarmu (Red/Green/Blue)',
    'ZoneArea'             => 'Zone Area',
    'ZoneFilterSize'       => 'Filter Width/Height (pixels)',
    'ZoneMinMaxAlarmArea'  => 'Min/Max Alarmed Area',
    'ZoneMinMaxBlobArea'   => 'Min/Max Blob Area',
    'ZoneMinMaxBlobs'      => 'Min/Max Blobs',
    'ZoneMinMaxFiltArea'   => 'Min/Max Filtered Area',
    'ZoneMinMaxPixelThres' => 'Min/Max Pixel Threshold (0-255)',
    'ZoneMinderLog'        => 'ZoneMinder Log',         // Added - 2011-06-17
    'ZoneOverloadFrames'   => 'Overload Frame Ignore Count',
    'ZoneExtendAlarmFrames' => 'Extend Alarm Frame Count',
    'Zones'                => 'Zny',
    'Zoom'                 => 'Zoom',
    'ZoomIn'               => 'Zvtit',
    'ZoomOut'              => 'Zmenit',
);

// Complex replacements with formatting and/or placements, must be passed through sprintf
$CLANG = array(
    'CurrentLogin'         => 'Prv je pihlen \'%1$s\'',
    'EventCount'           => '%1$s %2$s', // For example '37 Events' (from Vlang below)
    'LastEvents'           => 'Poslednch %1$s %2$s', // For example 'Last 37 Events' (from Vlang below)
    'LatestRelease'        => 'Posledn verze je v%1$s, vy mte v%2$s.',
    'MonitorCount'         => '%1$s %2$s', // For example '4 Monitors' (from Vlang below)
    'MonitorFunction'      => 'Funkce %1$s kamery',
    'RunningRecentVer'     => 'Pouvte posledn verzi ZoneMinder, v%s.',
    'VersionMismatch'      => 'Version mismatch, system is version %1$s, database is %2$s.', // Added - 2011-05-25
);

// The next section allows you to describe a series of word ending and counts used to 
// generate the correctly conjugated forms of words depending on a count that is associated
// with that word.
// This intended to allow phrases such a '0 potatoes', '1 potato', '2 potatoes' etc to
// conjugate correctly with the associated count.
// In some languages such as English this is fairly simple and can be expressed by assigning
// a count with a singular or plural form of a word and then finding the nearest (lower) value.
// So '0' of something generally ends in 's', 1 of something is singular and has no extra
// ending and 2 or more is a plural and ends in 's' also. So to find the ending for '187' of
// something you would find the nearest lower count (2) and use that ending.
//
// So examples of this would be
// $zmVlangPotato = array( 0=>'Potatoes', 1=>'Potato', 2=>'Potatoes' );
// $zmVlangSheep = array( 0=>'Sheep' );
//
// where you can have as few or as many entries in the array as necessary
// If your language is similar in form to this then use the same format and choose the
// appropriate zmVlang function below.
// If however you have a language with a different format of plural endings then another
// approach is required . For instance in Russian the word endings change continuously
// depending on the last digit (or digits) of the numerator. In this case then zmVlang
// arrays could be written so that the array index just represents an arbitrary 'type'
// and the zmVlang function does the calculation about which version is appropriate.
//
// So an example in Russian might be (using English words, and made up endings as I
// don't know any Russian!!)
// $zmVlangPotato = array( 1=>'Potati', 2=>'Potaton', 3=>'Potaten' );
//
// and the zmVlang function decides that the first form is used for counts ending in
// 0, 5-9 or 11-19 and the second form when ending in 1 etc.
//

// Variable arrays expressing plurality, see the zmVlang description above
$VLANG = array(
    'Event'                => array( 0=>'Zznam', 1=>'Zznam', 2=>'Zznamy', 5=>'Zznam' ),
    'Monitor'              => array( 0=>'Kamer', 1=>'Kamera', 2=>'Kamery', 5=>'Kamer' ),
);

// You will need to choose or write a function that can correlate the plurality string arrays
// with variable counts. This is used to conjugate the Vlang arrays above with a number passed
// in to generate the correct noun form.
//
// In languages such as English this is fairly simple 
// Note this still has to be used with printf etc to get the right formating
function zmVlang( $langVarArray, $count )
{
    krsort( $langVarArray );
    foreach ( $langVarArray as $key=>$value )
    {
        if ( abs($count) >= $key )
        {
            return( $value );
        }
    }
    die( 'Error, unable to correlate variable language string' );
}

// This is an version that could be used in the Russian example above
// The rules are that the first word form is used if the count ends in
// 0, 5-9 or 11-19. The second form is used then the count ends in 1
// (not including 11 as above) and the third form is used when the 
// count ends in 2-4, again excluding any values ending in 12-14.
// 
// function zmVlang( $langVarArray, $count )
// {
//  $secondlastdigit = substr( $count, -2, 1 );
//  $lastdigit = substr( $count, -1, 1 );
//  // or
//  // $secondlastdigit = ($count/10)%10;
//  // $lastdigit = $count%10;
// 
//  // Get rid of the special cases first, the teens
//  if ( $secondlastdigit == 1 && $lastdigit != 0 )
//  {
//      return( $langVarArray[1] );
//  }
//  switch ( $lastdigit )
//  {
//      case 0 :
//      case 5 :
//      case 6 :
//      case 7 :
//      case 8 :
//      case 9 :
//      {
//          return( $langVarArray[1] );
//          break;
//      }
//      case 1 :
//      {
//          return( $langVarArray[2] );
//          break;
//      }
//      case 2 :
//      case 3 :
//      case 4 :
//      {
//          return( $langVarArray[3] );
//          break;
//      }
//  }
//  die( 'Error, unable to correlate variable language string' );
// }

// This is an example of how the function is used in the code which you can uncomment and 
// use to test your custom function.
//$monitors = array();
//$monitors[] = 1; // Choose any number
//echo sprintf( $zmClangMonitorCount, count($monitors), zmVlang( $zmVlangMonitor, count($monitors) ) );

// In this section you can override the default prompt and help texts for the options area
// These overrides are in the form show below where the array key represents the option name minus the initial ZM_
// So for example, to override the help text for ZM_LANG_DEFAULT do
$OLANG = array(
	'OPTIONS_FFMPEG' => array(
		'Help' => "Parameters in this field are passwd on to FFmpeg. Multiple parameters can be separated by ,~~ ".
		          "Examples (do not enter quotes)~~~~".
		          "\"allowed_media_types=video\" Set datatype to request fromcam (audio, video, data)~~~~".
		          "\"reorder_queue_size=nnn\" Set number of packets to buffer for handling of reordered packets~~~~".
		          "\"loglevel=debug\" Set verbosiy of FFmpeg (quiet, panic, fatal, error, warning, info, verbose, debug)"
	),
	'OPTIONS_LIBVLC' => array(
		'Help' => "Parameters in this field are passwd on to libVLC. Multiple parameters can be separated by ,~~ ".
		          "Examples (do not enter quotes)~~~~".
		          "\"--rtp-client-port=nnn\" Set local port to use for rtp data~~~~". 
		          "\"--verbose=2\" Set verbosity of libVLC"
	),
	
//    'LANG_DEFAULT' => array(
//        'Prompt' => "This is a new prompt for this option",
//        'Help' => "This is some new help for this option which will be displayed in the popup window when the ? is clicked"
//    ),
);

?>
