
package ONVIF::Device::Elements::SetZeroConfiguration;
use strict;
use warnings;

{ # BLOCK to scope variables

sub get_xmlns { 'http://www.onvif.org/ver10/device/wsdl' }

__PACKAGE__->__set_name('SetZeroConfiguration');
__PACKAGE__->__set_nillable();
__PACKAGE__->__set_minOccurs();
__PACKAGE__->__set_maxOccurs();
__PACKAGE__->__set_ref();

use base qw(
    SOAP::WSDL::XSD::Typelib::Element
    SOAP::WSDL::XSD::Typelib::ComplexType
);

our $XML_ATTRIBUTE_CLASS;
undef $XML_ATTRIBUTE_CLASS;

sub __get_attr_class {
    return $XML_ATTRIBUTE_CLASS;
}

use Class::Std::Fast::Storable constructor => 'none';
use base qw(SOAP::WSDL::XSD::Typelib::ComplexType);

Class::Std::initialize();

{ # BLOCK to scope variables

my %InterfaceToken_of :ATTR(:get<InterfaceToken>);
my %Enabled_of :ATTR(:get<Enabled>);

__PACKAGE__->_factory(
    [ qw(        InterfaceToken
        Enabled

    ) ],
    {
        'InterfaceToken' => \%InterfaceToken_of,
        'Enabled' => \%Enabled_of,
    },
    {
        'InterfaceToken' => 'ONVIF::Device::Types::ReferenceToken',
        'Enabled' => 'SOAP::WSDL::XSD::Typelib::Builtin::boolean',
    },
    {

        'InterfaceToken' => 'InterfaceToken',
        'Enabled' => 'Enabled',
    }
);

} # end BLOCK







} # end of BLOCK



1;


=pod

=head1 NAME

ONVIF::Device::Elements::SetZeroConfiguration

=head1 DESCRIPTION

Perl data type class for the XML Schema defined element
SetZeroConfiguration from the namespace http://www.onvif.org/ver10/device/wsdl.







=head1 PROPERTIES

The following properties may be accessed using get_PROPERTY / set_PROPERTY
methods:

=over

=item * InterfaceToken

 $element->set_InterfaceToken($data);
 $element->get_InterfaceToken();




=item * Enabled

 $element->set_Enabled($data);
 $element->get_Enabled();





=back


=head1 METHODS

=head2 new

 my $element = ONVIF::Device::Elements::SetZeroConfiguration->new($data);

Constructor. The following data structure may be passed to new():

 {
   InterfaceToken => $some_value, # ReferenceToken
   Enabled =>  $some_value, # boolean
 },

=head1 AUTHOR

Generated by SOAP::WSDL

=cut

